/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import gov.nasa.jpf.util.test.TestJPF;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import tlc2.tool.fp.OffHeapDiskFPSet;

public class OffHeapDiskFPSetJPFTest
extends TestJPF {
    private static final int PROBE_LIMIT = 2;

    @Test
    public void test() throws InterruptedException, BrokenBarrierException {
        if (this.verifyNoPropertyViolation(new String[]{"+listener=.listener.AssertionProperty,.listener.ErrorTraceGenerator"})) {
            int size = 3;
            int max = 3;
            final DummyOffHeapDiskFPSet fpSet = new DummyOffHeapDiskFPSet(3, 3L);
            int i = 0;
            while (i < 2) {
                Thread worker = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        long i = 1L;
                        while (i <= 3L) {
                            fpSet.memInsert(i);
                            ++i;
                        }
                    }
                }, "Worker");
                worker.start();
                ++i;
            }
            assert (fpSet.checkInvariant()) : "FPSet violates its invariant: " + Arrays.toString(DummyOffHeapDiskFPSet.DummyLongArray.access$0(DummyOffHeapDiskFPSet.access$0(fpSet)));
        }
    }

    private static class DummyOffHeapDiskFPSet {
        private static final int EMPTY = 0;
        private final OffHeapDiskFPSet.Indexer indexer;
        private final DummyLongArray array;
        private final AtomicInteger tblCnt = new AtomicInteger(0);

        public DummyOffHeapDiskFPSet(int positions, long max) {
            this.array = new DummyLongArray(positions);
            this.indexer = new OffHeapDiskFPSet.Indexer(positions, 1, max);
        }

        public boolean memInsert(long fp) {
            int i = 0;
            while (i < 2) {
                int position = (int)this.indexer.getIdx(fp, i);
                long expected = this.array.get(position);
                if (expected == 0L) {
                    if (this.array.trySet(position, expected, fp)) {
                        this.tblCnt.incrementAndGet();
                        return false;
                    }
                    --i;
                } else if (expected == fp) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public synchronized boolean checkInvariant() {
            int cnt = 0;
            HashSet<Long> s = new HashSet<Long>(this.array.array.length);
            int i = 0;
            while (i < this.array.array.length) {
                if (this.array.array[i] > 0L) {
                    s.add(this.array.array[i]);
                    ++cnt;
                }
                ++i;
            }
            return cnt == s.size();
        }

        static /* synthetic */ DummyLongArray access$0(DummyOffHeapDiskFPSet dummyOffHeapDiskFPSet) {
            return dummyOffHeapDiskFPSet.array;
        }

        private static class DummyLongArray {
            private final long[] array;

            public DummyLongArray(int positions) {
                this.array = new long[positions];
            }

            public long get(int position) {
                return this.array[position];
            }

            public synchronized boolean trySet(int position, long expected, long l) {
                if (this.array[position] == expected) {
                    this.array[position] = l;
                    return true;
                }
                return false;
            }
        }
    }
}

