/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.io.File;
import java.io.IOException;
import org.junit.Test;
import pcal.PCalTest;
import tla2sany.drivers.SANY;
import util.TestPrintStream;
import util.ToolIO;

public class DivergenceTest
extends PCalTest {
    @Test
    public void divergenceTest00() throws IOException {
        String filename = "divergenceTest001" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--algorithm a\n" + "begin\n" + "  skip;\n" + "end algorithm; *)\n" + "\\* BEGIN TRANSLATION\n" + "VARIABLE pc\n" + "\n" + "vars == << pc >>\n" + "\n" + "Init == /\\ pc = \"Lbl_1\"\n" + "\n" + "Lbl_1 == /\\ pc = \"Lbl_1\"\n" + "         /\\ TRUE\n" + "         /\\ pc' = \"Done\"\n" + "\n" + "(* Allow infinite stuttering to prevent deadlock on termination. *)\n" + "Terminating == pc = \"Done\" /\\ UNCHANGED vars\n" + "\n" + "Next == Lbl_1\n" + "           \\/ Terminating\n" + "\n" + "Spec == Init /\\ [][Next]_vars\n" + "\n" + "Termination == <>(pc = \"Done\")\n" + "\n" + "\\* END TRANSLATION\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertNoSubstring("!! WARNING " + filename);
    }

    @Test
    public void divergenceTest01() throws IOException {
        String filename = "divergenceTest01" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--algorithm a\n" + "begin\n" + "  skip;\n" + "end algorithm; *)\n" + "\\* BEGIN TRANSLATION (chksum(PCal) \\in STRING /\\ chksum(TLA+) \\in STRING)\n" + "VARIABLE pc\n" + "\n" + "vars == << pc >>\n" + "\n" + "Init == /\\ pc = \"Lbl_1\"\n" + "\n" + "Lbl_1 == /\\ pc = \"Lbl_1\"\n" + "         /\\ TRUE\n" + "         /\\ pc' = \"Done\"\n" + "\n" + "(* Allow infinite stuttering to prevent deadlock on termination. *)\n" + "Terminating == pc = \"Done\" /\\ UNCHANGED vars\n" + "\n" + "Next == Lbl_1\n" + "           \\/ Terminating\n" + "\n" + "Spec == Init /\\ [][Next]_vars\n" + "\n" + "Termination == <>(pc = \"Done\")\n" + "\n" + "\\* END TRANSLATION\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertNoSubstring("!! WARNING " + filename);
    }

    @Test
    public void divergenceTest01fair() throws IOException {
        String filename = "divergenceTest01" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--fair algorithm a\n" + "begin\n" + "  skip;\n" + "end algorithm; *)\n" + "\\* BEGIN TRANSLATION (checksum(PlusCal) = \"4860ac97\" /\\ chksum(TLA+) \\in STRING)\n" + "\\* END TRANSLATION\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertSubstring(String.format("!! WARNING: The PlusCal algorithm in module %s has changed since its last translation.", filename));
    }

    @Test
    public void divergenceTest01unfair() throws IOException {
        String filename = "divergenceTest01" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--algorithm a\n" + "begin\n" + "  skip;\n" + "end algorithm; *)\n" + "\\* BEGIN TRANSLATION (checksum(PlusCal) = \"7c28162a\" /\\ chksum(TLA+) \\in STRING)\n" + "\\* END TRANSLATION\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertSubstring(String.format("!! WARNING: The PlusCal algorithm in module %s has changed since its last translation.", filename));
    }

    @Test
    public void divergenceTestIndentation() throws IOException {
        String filename = "divergenceTest01" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--algorithm a\nvariable f;" + "begin\n" + "  f := /\\ TRUE\n" + "    /\\ TRUE;\n" + "end algorithm; *)\n" + "\\* BEGIN TRANSLATION (checksum(PlusCal) = \"996afab0\" /\\ chksum(TLA+) \\in STRING)\n" + "\\* END TRANSLATION\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertSubstring(String.format("!! WARNING: The PlusCal algorithm in module %s has changed since its last translation.", filename));
    }

    @Test
    public void divergenceTest02() throws IOException {
        String filename = "divergenceTest02" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--algorithm a\n" + "begin\n" + "  print \"msg\";\n" + "end algorithm; *)\n" + "\\* BEGIN TRANSLATION (chksum(PCal) = \"4860ac97\" /\\ chksum(TLA+) = \"af3d9146\")\n" + "VARIABLE pc\n" + "\n" + "vars == << pc >>\n" + "\n" + "Init == /\\ pc = \"Lbl_1\"\n" + "\n" + "Lbl_1 == /\\ pc = \"Lbl_1\"\n" + "         /\\ TRUE\n" + "         /\\ pc' = \"Done\"\n" + "\n" + "(* Allow infinite stuttering to prevent deadlock on termination. *)\n" + "Terminating == pc = \"Done\" /\\ UNCHANGED vars\n" + "\n" + "Next == Lbl_1\n" + "           \\/ Terminating\n" + "\n" + "Spec == Init /\\ [][Next]_vars\n" + "\n" + "Termination == <>(pc = \"Done\")\n" + "\n" + "\\* END TRANSLATION\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertSubstring(String.format("!! WARNING: The PlusCal algorithm in module %s has changed since its last translation.", filename));
    }

    @Test
    public void divergenceTest03() throws IOException {
        String filename = "divergenceTest03" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--algorithm a\n" + "begin\n" + "  skip;\n" + "end algorithm; *)\n" + "\\* BEGIN TRANSLATION (checksum(PlusCal) = \"4860ac97\" /\\ ChkSum(tla+) = \"af3d9146\")\n" + "VARIABLE pc\n" + "\n" + "vars == << pc >>\n" + "\n" + "Init == /\\ pc = \"Lbl_1\"\n" + "\n" + "Lbl_1 == /\\ pc = \"Lbl_1\"\n" + "         /\\ TRUE\n" + "         /\\ pc' = \"Done\"\n" + "\n" + "(* Allow infinite stuttering to prevent deadlock on termination. *)\n" + "Terminating == pc = \"Done\" /\\ UNCHANGED vars\n" + "\n" + "Next == Lbl_1\n" + "\n" + "Spec == Init /\\ [][Next]_vars\n" + "\n" + "Termination == <>(pc = \"Done\")\n" + "\n" + "\\* END TRANSLATION\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertSubstring(String.format("!! WARNING: The TLA+ translation in module %s has changed since its last translation.", filename));
    }

    @Test
    public void divergenceTest04() throws IOException {
        String filename = "divergenceTest04" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--algorithm a\n" + "begin\n" + "  print \"msg\";\n" + "end algorithm; *)\n" + "\\* BEGIN TRANSLATION   (checksum(PlusCal) = \"4860ac97\" /\\ ChkSum(tla+) = \"af3d9146\")  \n" + "VARIABLE pc\n" + "\n" + "vars == << pc >>\n" + "\n" + "Init == /\\ pc = \"Lbl_1\"\n" + "\n" + "Lbl_1 == /\\ pc = \"Lbl_1\"\n" + "         /\\ TRUE\n" + "         /\\ pc' = \"Done\"\n" + "\n" + "(* Allow infinite stuttering to prevent deadlock on termination. *)\n" + "Terminating == pc = \"Done\" /\\ UNCHANGED vars\n" + "\n" + "Next == Lbl_1\n" + "\n" + "Spec == Init /\\ [][Next]_vars\n" + "\n" + "Termination == <>(pc = \"Done\")\n" + "\n" + "\\* END TRANSLATION\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertSubstring(String.format("!! WARNING: The PlusCal algorithm and its TLA+ translation in module %s filename since the last translation.", filename));
    }

    @Test
    public void divergenceTest05() throws IOException {
        String filename = "divergenceTest04" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--algorithm a\n" + "begin\n" + "  print \"msg\";\n" + "end algorithm; *)\n" + "\\* BEGIN TRANSLATION   (checksum(PlusCal) \\in  STRING /\\ ChkSum(tla+) \\in STRING)  \n" + "VARIABLE pc\n" + "\n" + "vars == << pc >>\n" + "\n" + "Init == /\\ pc = \"Lbl_1\"\n" + "\n" + "Lbl_1 == /\\ pc = \"Lbl_1\"\n" + "         /\\ TRUE\n" + "         /\\ pc' = \"Done\"\n" + "\n" + "(* Allow infinite stuttering to prevent deadlock on termination. *)\n" + "Terminating == pc = \"Done\" /\\ UNCHANGED vars\n" + "\n" + "Next == Lbl_1\n" + "\n" + "Spec == Init /\\ [][Next]_vars\n" + "\n" + "Termination == <>(pc = \"Done\")\n" + "\n" + "\\* END TRANSLATION\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertNoSubstring(String.format("!! WARNING:", filename));
    }

    @Test
    public void divergenceTest06() throws IOException {
        String filename = "divergenceTest05" + System.currentTimeMillis();
        String absolutePath = DivergenceTest.writeFile(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename, "---- MODULE " + filename + " ----\n" + "\n" + "(*\n" + "--algorithm a\n" + "begin\n" + "  skip;\n" + "end algorithm; *)\n" + "\n=========================");
        TestPrintStream testPrintStream = new TestPrintStream();
        ToolIO.out = testPrintStream;
        SANY.SANYmain(new String[]{absolutePath});
        testPrintStream.assertSubstring("Semantic processing of module " + filename);
        testPrintStream.assertNoSubstring("!! WARNING " + filename);
    }
}

