/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.LevelConstants;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ParamAndPosition;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;
import tla2sany.xml.XMLExportable;
import tlc2.tool.coverage.CostModel;

public class Subst
implements LevelConstants,
ASTConstants,
ExploreNode,
XMLExportable {
    private OpDeclNode op;
    private ExprOrOpArgNode expr;
    private TreeNode exprSTN;
    private boolean implicit;
    private CostModel cm = CostModel.DO_NOT_RECORD;

    public Subst(OpDeclNode odn, ExprOrOpArgNode exp, TreeNode exSTN, boolean imp) {
        this.op = odn;
        this.expr = exp;
        this.exprSTN = exSTN;
        this.implicit = imp;
    }

    public final OpDeclNode getOp() {
        return this.op;
    }

    public final void setOp(OpDeclNode opd) {
        this.op = opd;
    }

    public final ExprOrOpArgNode getExpr() {
        return this.expr;
    }

    public final void setExpr(ExprOrOpArgNode exp, boolean imp) {
        this.expr = exp;
        this.implicit = imp;
    }

    public final TreeNode getExprSTN() {
        return this.exprSTN;
    }

    public final void setExprSTN(TreeNode stn) {
        this.exprSTN = stn;
    }

    public final boolean isImplicit() {
        return this.implicit;
    }

    public final CostModel getCM() {
        return this.cm;
    }

    public final Subst setCM(CostModel cm) {
        this.cm = cm;
        return this;
    }

    public static ExprOrOpArgNode getSub(Object param, Subst[] subs) {
        for (int i = 0; i < subs.length; ++i) {
            if (subs[i].getOp() != param) continue;
            return subs[i].getExpr();
        }
        return null;
    }

    public static HashSet<SymbolNode> paramSet(SymbolNode param, Subst[] subs) {
        int idx;
        for (idx = 0; idx < subs.length && subs[idx].getOp() != param; ++idx) {
        }
        if (idx < subs.length) {
            return subs[idx].getExpr().getLevelParams();
        }
        HashSet<SymbolNode> res = new HashSet<SymbolNode>();
        res.add(param);
        return res;
    }

    public static HashSet<SymbolNode> allParamSet(SymbolNode param, Subst[] subs) {
        int idx;
        for (idx = 0; idx < subs.length && subs[idx].getOp() != param; ++idx) {
        }
        if (idx < subs.length) {
            return subs[idx].getExpr().getAllParams();
        }
        HashSet<SymbolNode> res = new HashSet<SymbolNode>();
        res.add(param);
        return res;
    }

    public static SetOfLevelConstraints getSubLCSet(LevelNode body, Subst[] subs, boolean isConstant, int itr) {
        SetOfLevelConstraints res = new SetOfLevelConstraints();
        SetOfLevelConstraints lcSet = body.getLevelConstraints();
        for (SymbolNode param : lcSet.keySet()) {
            Integer plevel = (Integer)lcSet.get(param);
            if (!isConstant) {
                if (param.getKind() == 2) {
                    plevel = Levels[0];
                } else if (param.getKind() == 3) {
                    plevel = Levels[1];
                }
            }
            Iterator<SymbolNode> iter1 = Subst.paramSet(param, subs).iterator();
            while (iter1.hasNext()) {
                res.put(iter1.next(), plevel);
            }
        }
        HashSet<ArgLevelParam> alpSet = body.getArgLevelParams();
        for (ArgLevelParam alp : alpSet) {
            OpArgNode sub = (OpArgNode)Subst.getSub(alp.op, subs);
            if (sub == null || !(sub.getOp() instanceof OpDefNode)) continue;
            OpDefNode subDef = (OpDefNode)sub.getOp();
            subDef.levelCheck(itr);
            Integer mlevel = new Integer(subDef.getMaxLevel(alp.i));
            Iterator<SymbolNode> iter1 = Subst.paramSet(alp.param, subs).iterator();
            while (iter1.hasNext()) {
                res.put(iter1.next(), mlevel);
            }
        }
        return res;
    }

    public static SetOfArgLevelConstraints getSubALCSet(LevelNode body, Subst[] subs, int itr) {
        SetOfArgLevelConstraints res = new SetOfArgLevelConstraints();
        SetOfArgLevelConstraints alcSet = body.getArgLevelConstraints();
        for (ParamAndPosition pap : alcSet.keySet()) {
            Integer plevel = (Integer)alcSet.get(pap);
            ExprOrOpArgNode sub = Subst.getSub(pap.param, subs);
            if (sub == null) {
                res.put(pap, plevel);
                continue;
            }
            SymbolNode subOp = ((OpArgNode)sub).getOp();
            if (!subOp.isParam()) continue;
            pap = new ParamAndPosition(subOp, pap.position);
            res.put(pap, plevel);
        }
        HashSet<ArgLevelParam> alpSet = body.getArgLevelParams();
        for (ArgLevelParam alp : alpSet) {
            ExprOrOpArgNode subOp;
            SymbolNode op;
            ExprOrOpArgNode subParam = Subst.getSub(alp.param, subs);
            if (subParam == null || !(op = (subOp = Subst.getSub(alp.op, subs)) == null ? alp.op : ((OpArgNode)subOp).getOp()).isParam()) continue;
            ParamAndPosition pap = new ParamAndPosition(op, alp.i);
            subParam.levelCheck(itr);
            Integer subLevel = new Integer(subParam.getLevel());
            res.put(pap, subLevel);
        }
        return res;
    }

    public static HashSet<ArgLevelParam> getSubALPSet(LevelNode body, Subst[] subs) {
        HashSet<ArgLevelParam> res = new HashSet<ArgLevelParam>();
        HashSet<ArgLevelParam> alpSet = body.getArgLevelParams();
        for (ArgLevelParam alp : alpSet) {
            ExprOrOpArgNode sub = Subst.getSub(alp.op, subs);
            if (sub == null) {
                res.add(alp);
                continue;
            }
            SymbolNode subOp = ((OpArgNode)sub).getOp();
            if (!subOp.isParam()) continue;
            Iterator<SymbolNode> iter1 = Subst.paramSet(alp.param, subs).iterator();
            while (iter1.hasNext()) {
                res.add(new ArgLevelParam(subOp, alp.i, iter1.next()));
            }
        }
        return res;
    }

    @Override
    public final String levelDataToString() {
        return "Dummy level string";
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        visitor.preVisit(this);
        if (this.op != null) {
            this.op.walkGraph(semNodesTable, visitor);
        }
        if (this.expr != null) {
            this.expr.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth) {
        return "\nOp: " + Strings.indent(2, this.op != null ? this.op.toString(depth - 1) : "<null>") + "\nExpr: " + Strings.indent(2, this.expr != null ? this.expr.toString(depth - 1) : "<null>");
    }

    @Override
    public Element export(Document doc, SymbolContext context) {
        Element ret = doc.createElement("Subst");
        ret.appendChild(this.op.export(doc, context));
        ret.appendChild(this.expr.export(doc, context));
        return ret;
    }
}

