/*
 * Decompiled with CFR 0.152.
 */
package tlc2.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import tlc2.input.AbstractMCOutputConsumer;
import tlc2.input.MCOutputMessage;

public class MCOutputPipeConsumer
extends AbstractMCOutputConsumer {
    private String specName;
    private File sourceDirectory;
    private boolean currentlyEncounteringModuleInformation;
    private final ArrayList<File> extendedModuleLocations;
    private MCOutputMessage tlcVersionMessage;
    private final InputStream sourceStream;
    private final ConsumerLifespanListener listener;

    public MCOutputPipeConsumer(InputStream inputStream, ConsumerLifespanListener lifespanListener) {
        this.sourceStream = inputStream;
        this.listener = lifespanListener;
        this.currentlyEncounteringModuleInformation = false;
        this.extendedModuleLocations = new ArrayList();
    }

    public List<MCOutputMessage> consumeOutput(boolean returnAllMessages) throws IOException {
        ArrayList<MCOutputMessage> encounteredMessages = returnAllMessages ? new ArrayList<MCOutputMessage>() : null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.sourceStream));){
            MCOutputMessage message;
            while ((message = this.parseChunk(br)) != null) {
                if (returnAllMessages) {
                    encounteredMessages.add(message);
                }
                if (message.getType() == 1) {
                    this.consumeErrorMessageAndStates(br, message);
                    continue;
                }
                if (message.getCode() == 2262) {
                    this.tlcVersionMessage = message;
                    continue;
                }
                if (message.getCode() != 2186) continue;
                break;
            }
        }
        catch (IOException ioe) {
            if (this.outputHadNoToolMessages()) {
                return encounteredMessages;
            }
            throw ioe;
        }
        return encounteredMessages;
    }

    public boolean outputHadNoToolMessages() {
        return this.tlcVersionMessage == null;
    }

    public String getSpecName() {
        return this.specName;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public List<File> getExtendedModuleLocations() {
        return this.extendedModuleLocations;
    }

    @Override
    protected void handleUnknownReadLine(String line) throws IOException {
        if ((this.specName == null || this.currentlyEncounteringModuleInformation) && line.startsWith("Parsing file")) {
            if (this.tlcVersionMessage == null) {
                throw new IOException("Output does not appear to be generated by TLC run with the '-tool' flag.");
            }
            String wholePath = line.substring("Parsing file".length() + 1);
            File tlaFile = new File(wholePath);
            if (this.specName == null) {
                this.sourceDirectory = tlaFile.getParentFile();
                String tlaFilename = tlaFile.getName();
                int extensionDotIndex = tlaFilename.lastIndexOf(46);
                this.specName = tlaFilename.substring(0, extensionDotIndex);
                if (this.listener != null) {
                    this.listener.consumptionFoundSourceDirectoryAndSpecName(this);
                }
                this.currentlyEncounteringModuleInformation = true;
            } else {
                this.extendedModuleLocations.add(tlaFile);
            }
        } else if (this.currentlyEncounteringModuleInformation) {
            this.currentlyEncounteringModuleInformation = false;
        }
    }

    public static interface ConsumerLifespanListener {
        public void consumptionFoundSourceDirectoryAndSpecName(MCOutputPipeConsumer var1);
    }
}

