/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import tlc2.TLCGlobals;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.ValueConstants;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import util.BufferedDataInputStream;
import util.FileUtil;
import util.IDataInputStream;
import util.UniqueString;
import util.WrongInvocationException;

public final class ValueInputStream
implements ValueConstants,
IValueInputStream {
    private final BufferedDataInputStream dis;
    private final HandleTable handles;

    public ValueInputStream(File file2, boolean compressed) throws IOException {
        this.dis = FileUtil.newBdFIS(compressed, file2);
        this.handles = new HandleTable();
    }

    public ValueInputStream(File file2) throws IOException {
        this(file2, TLCGlobals.useGZIP);
    }

    public ValueInputStream(String fname) throws IOException {
        this(new File(fname));
    }

    @Override
    public final IValue read() throws IOException {
        byte kind = this.dis.readByte();
        switch (kind) {
            case 0: {
                return this.dis.readBoolean() ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 1: {
                return IntValue.gen(this.dis.readInt());
            }
            case 3: {
                return StringValue.createFrom(this);
            }
            case 21: {
                return ModelValue.mvs[this.dis.readShort()];
            }
            case 23: {
                return new IntervalValue(this.dis.readInt(), this.dis.readInt());
            }
            case 4: {
                return RecordValue.createFrom(this);
            }
            case 9: {
                return FcnRcdValue.createFrom(this);
            }
            case 5: {
                return SetEnumValue.createFrom(this);
            }
            case 7: {
                return TupleValue.createFrom(this);
            }
            case 26: {
                return (IValue)this.handles.getValue(this.readNat());
            }
        }
        throw new WrongInvocationException("ValueInputStream: Can not unpickle a value of kind " + kind);
    }

    public final IValue read(Map<String, UniqueString> tbl) throws IOException {
        byte kind = this.dis.readByte();
        switch (kind) {
            case 0: {
                return this.dis.readBoolean() ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 1: {
                return IntValue.gen(this.dis.readInt());
            }
            case 3: {
                return StringValue.createFrom(this, tbl);
            }
            case 21: {
                return ModelValue.mvs[this.dis.readShort()];
            }
            case 23: {
                return new IntervalValue(this.dis.readInt(), this.dis.readInt());
            }
            case 4: {
                return RecordValue.createFrom(this, tbl);
            }
            case 9: {
                return FcnRcdValue.createFrom(this, tbl);
            }
            case 5: {
                return SetEnumValue.createFrom(this, tbl);
            }
            case 7: {
                return TupleValue.createFrom(this, tbl);
            }
            case 26: {
                return (IValue)this.handles.getValue(this.readNat());
            }
        }
        throw new WrongInvocationException("ValueInputStream: Can not unpickle a value of kind " + kind);
    }

    @Override
    public final int readShort() throws IOException {
        return this.dis.readShort();
    }

    @Override
    public final int readInt() throws IOException {
        return this.dis.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this.dis.readLong();
    }

    @Override
    public final void close() throws IOException {
        this.dis.close();
    }

    @Override
    public final int readNat() throws IOException {
        int res2 = this.dis.readShort();
        if (res2 >= 0) {
            return res2;
        }
        res2 = res2 << 16 | this.dis.readShort() & 0xFFFF;
        return -res2;
    }

    @Override
    public final short readShortNat() throws IOException {
        short res2 = this.dis.readByte();
        if (res2 >= 0) {
            return res2;
        }
        return (short)(-(res2 << 8 | this.dis.readByte() & 0xFF));
    }

    @Override
    public final long readLongNat() throws IOException {
        long res2 = this.dis.readInt();
        if (res2 >= 0L) {
            return res2;
        }
        res2 = res2 << 32 | (long)this.dis.readInt() & 0xFFFFFFFFL;
        return -res2;
    }

    @Override
    public final byte readByte() throws EOFException, IOException {
        return this.dis.readByte();
    }

    @Override
    public final void assign(Object obj, int idx) {
        this.handles.assign(obj, idx);
    }

    @Override
    public final int getIndex() {
        return this.handles.getIndex();
    }

    @Override
    public final IDataInputStream getInputStream() {
        return this.dis;
    }

    @Override
    public final UniqueString getValue(int idx) {
        return (UniqueString)this.handles.getValue(idx);
    }

    private static class HandleTable {
        private Object[] values = new Object[16];
        private int index = 0;

        HandleTable() {
        }

        final int getIndex() {
            if (this.index >= this.values.length) {
                Object[] newValues = new Object[this.index * 2];
                System.arraycopy(this.values, 0, newValues, 0, this.index);
                this.values = newValues;
            }
            return this.index++;
        }

        final void assign(Object val2, int idx) {
            this.values[idx] = val2;
        }

        final Object getValue(int idx) {
            return this.values[idx];
        }
    }
}

