/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.PrintWriter;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import tlc2.tool.Action;
import tlc2.tool.EvalException;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.util.IdThread;
import tlc2.util.RandomGenerator;
import util.FileUtil;

public class SimulationWorker
extends IdThread {
    final RandomGenerator localRng;
    TLCState curState;
    StateVec stateTrace;
    private final StateVec initStates;
    private final BlockingQueue<SimulationWorkerResult> resultQueue;
    private int traceCnt = 0;
    private final long maxTraceNum;
    private final long maxTraceDepth;
    private final boolean checkDeadlock;
    private final String traceFile;
    private final LongAdder numOfGenStates;
    private final LongAdder numOfGenTraces;
    private final ITool tool;
    private final ILiveCheck liveCheck;

    public SimulationWorker(int id, ITool tool, StateVec initStates, BlockingQueue<SimulationWorkerResult> resultQueue, long seed, long maxTraceDepth, long maxTraceNum, boolean checkDeadlock, String traceFile, ILiveCheck liveCheck, LongAdder numOfGenStates, LongAdder numOfGenTraces) {
        super(id);
        this.localRng = new RandomGenerator(seed);
        this.tool = tool;
        this.maxTraceDepth = maxTraceDepth;
        this.maxTraceNum = maxTraceNum;
        this.resultQueue = resultQueue;
        this.initStates = initStates;
        this.checkDeadlock = checkDeadlock;
        this.traceFile = traceFile;
        this.liveCheck = liveCheck;
        this.numOfGenStates = numOfGenStates;
        this.numOfGenTraces = numOfGenTraces;
    }

    @Override
    public final void run() {
        try {
            do {
                Optional<SimulationWorkerError> res2 = this.simulateRandomTrace();
                ++this.traceCnt;
                this.numOfGenTraces.increment();
                if (!res2.isPresent()) continue;
                SimulationWorkerError err = res2.get();
                this.resultQueue.put(SimulationWorkerResult.Error(this.myGetId(), err));
            } while ((long)this.traceCnt < this.maxTraceNum);
            this.resultQueue.put(SimulationWorkerResult.OK(this.myGetId()));
            return;
        }
        catch (InterruptedException e2) {
            this.resultQueue.offer(SimulationWorkerResult.OK(this.myGetId()));
            return;
        }
        catch (Exception e3) {
            SimulationWorkerError err = new SimulationWorkerError(0, null, this.curState, this.stateTrace, e3);
            this.resultQueue.offer(SimulationWorkerResult.Error(this.myGetId(), err));
            return;
        }
    }

    private void checkForInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public final StateVec randomNextStates(RandomGenerator rng, TLCState state) {
        Action[] actions = this.tool.getActions();
        int len = actions.length;
        int index2 = (int)Math.floor(rng.nextDouble() * (double)len);
        int p = rng.nextPrime();
        for (int i = 0; i < len; ++i) {
            StateVec pstates = this.tool.getNextStates(actions[index2], state);
            if (!pstates.empty()) {
                return pstates;
            }
            index2 = (index2 + p) % len;
        }
        return null;
    }

    private final TLCState randomState(RandomGenerator rng, StateVec states) throws EvalException {
        int len = states.size();
        if (len > 0) {
            int index2 = (int)Math.floor(rng.nextDouble() * (double)len);
            return states.elementAt(index2);
        }
        return null;
    }

    private Optional<SimulationWorkerError> simulateRandomTrace() throws Exception {
        this.curState = null;
        this.stateTrace = new StateVec((int)this.maxTraceDepth);
        this.stateTrace.clear();
        this.curState = this.randomState(this.localRng, this.initStates);
        SimulationWorker.setCurrentState(this.curState);
        boolean inConstraints = this.tool.isInModel(this.curState);
        int traceIdx = 0;
        while ((long)traceIdx < this.maxTraceDepth) {
            this.checkForInterrupt();
            this.stateTrace.addElement(this.curState);
            if (!inConstraints) break;
            StateVec nextStates = this.randomNextStates(this.localRng, this.curState);
            if (nextStates == null) {
                if (!this.checkDeadlock) break;
                return Optional.of(new SimulationWorkerError(2114, null, this.curState, this.stateTrace, null));
            }
            for (int i = 0; i < nextStates.size(); ++i) {
                this.numOfGenStates.increment();
                TLCState state = nextStates.elementAt(i);
                if (!this.tool.isGoodState(state)) {
                    return Optional.of(new SimulationWorkerError(2109, null, state, this.stateTrace, null));
                }
                int idx = 0;
                try {
                    for (idx = 0; idx < this.tool.getInvariants().length; ++idx) {
                        if (this.tool.isValid(this.tool.getInvariants()[idx], state)) continue;
                        return Optional.of(new SimulationWorkerError(2110, new String[]{this.tool.getInvNames()[idx]}, state, this.stateTrace, null));
                    }
                }
                catch (Exception e2) {
                    return Optional.of(new SimulationWorkerError(2111, new String[]{this.tool.getInvNames()[idx], e2.getMessage()}, state, this.stateTrace, null));
                }
                try {
                    for (idx = 0; idx < this.tool.getImpliedActions().length; ++idx) {
                        if (this.tool.isValid(this.tool.getImpliedActions()[idx], this.curState, state)) continue;
                        return Optional.of(new SimulationWorkerError(2112, new String[]{this.tool.getImpliedActNames()[idx]}, state, this.stateTrace, null));
                    }
                    continue;
                }
                catch (Exception e3) {
                    return Optional.of(new SimulationWorkerError(2113, new String[]{this.tool.getImpliedActNames()[idx], e3.getMessage()}, state, this.stateTrace, null));
                }
            }
            TLCState s1 = this.randomState(this.localRng, nextStates);
            inConstraints = this.tool.isInModel(s1) && this.tool.isInActions(this.curState, s1);
            s1.setPredecessor(this.curState);
            this.curState = s1;
            SimulationWorker.setCurrentState(this.curState);
            ++traceIdx;
        }
        this.checkForInterrupt();
        this.liveCheck.checkTrace(this.tool, this.stateTrace);
        if (this.traceFile != null) {
            String fileName = this.traceFile + "_" + String.valueOf(this.myGetId()) + "_" + this.traceCnt;
            PrintWriter pw = new PrintWriter(FileUtil.newBFOS(fileName));
            pw.println("---------------- MODULE " + fileName + " -----------------");
            for (int idx = 0; idx < this.stateTrace.size(); ++idx) {
                pw.println("STATE_" + (idx + 1) + " == ");
                pw.println(this.stateTrace.elementAt(idx) + "\n");
            }
            pw.println("=================================================");
            pw.close();
        }
        return Optional.empty();
    }

    public static class SimulationWorkerResult {
        private int workerId;
        private Optional<SimulationWorkerError> error = Optional.empty();

        static SimulationWorkerResult OK(int workerId) {
            SimulationWorkerResult res2 = new SimulationWorkerResult();
            res2.workerId = workerId;
            return res2;
        }

        static SimulationWorkerResult Error(int workerId, SimulationWorkerError err) {
            SimulationWorkerResult res2 = new SimulationWorkerResult();
            res2.error = Optional.of(err);
            res2.workerId = workerId;
            return res2;
        }

        public boolean isError() {
            return this.error.isPresent();
        }

        public SimulationWorkerError error() {
            return this.error.get();
        }

        public int workerId() {
            return this.workerId;
        }
    }

    public static class SimulationWorkerError {
        public int errorCode;
        public String[] parameters;
        public TLCState state;
        public StateVec stateTrace;
        public Exception exception;

        public SimulationWorkerError(int errorCode, String[] parameters, TLCState state, StateVec stateTrace, Exception e2) {
            this.errorCode = errorCode;
            this.parameters = parameters;
            this.state = state;
            this.stateTrace = stateTrace;
            this.exception = e2;
        }
    }
}

