/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.macosx;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ScalableSurface;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MonitorEvent;
import com.jogamp.opengl.math.FloatUtil;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.DriverClearFocus;
import jogamp.newt.driver.DriverUpdatePosition;
import jogamp.newt.driver.macosx.DisplayDriver;
import jogamp.newt.driver.macosx.MacKeyUtil;

public class WindowDriver
extends WindowImpl
implements MutableSurface,
DriverClearFocus,
DriverUpdatePosition {
    private static final int NSBorderlessWindowMask = 0;
    private static final int NSTitledWindowMask = 1;
    private static final int NSClosableWindowMask = 2;
    private static final int NSMiniaturizableWindowMask = 4;
    private static final int NSResizableWindowMask = 8;
    private static final int NSBackingStoreRetained = 0;
    private static final int NSBackingStoreNonretained = 1;
    private static final int NSBackingStoreBuffered = 2;
    private volatile long surfaceHandle = 0L;
    private long sscSurfaceHandle = 0L;
    private boolean isOffscreenInstance = false;

    private boolean updatePixelScale(boolean bl, boolean bl2, boolean bl3, float f, float f2) {
        float f3;
        float f4 = FloatUtil.isZero(f, 1.1920929E-7f) ? 1.0f : f;
        float[] fArray = new float[]{f4, f4};
        this.maxPixelScale[0] = f3 = FloatUtil.isZero(f2, 1.1920929E-7f) ? 1.0f : f2;
        this.maxPixelScale[1] = f3;
        if (SurfaceScaleUtils.setNewPixelScale(this.hasPixelScale, this.hasPixelScale, fArray, this.minPixelScale, this.maxPixelScale, DEBUG_IMPLEMENTATION ? this.getClass().getName() : null)) {
            if (bl) {
                if (bl3) {
                    this.superSizeChangedOffThread(bl2, this.getWidth(), this.getHeight(), true);
                } else {
                    super.sizeChanged(bl2, this.getWidth(), this.getHeight(), true);
                }
            } else {
                this.defineSize(this.getWidth(), this.getHeight());
            }
            return true;
        }
        return false;
    }

    private boolean updatePixelScaleByDisplayID(boolean bl) {
        float f = (float)OSXUtil.GetPixelScaleByDisplayID(this.getDisplayID());
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.updatePixelScale.1: " + this.hasPixelScale[0] + ", " + f + " (max)");
        }
        return this.updatePixelScale(bl, true, false, f, f);
    }

    private boolean updatePixelScaleByWindowHandle(boolean bl) {
        long l = this.getWindowHandle();
        if (0L != l) {
            float f = (float)OSXUtil.GetPixelScale(l);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("WindowDriver.updatePixelScale.2: " + this.hasPixelScale[0] + ", " + f + " (max)");
            }
            return this.updatePixelScale(bl, true, false, f, f);
        }
        return false;
    }

    protected void updatePixelScale(boolean bl, float f, float f2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.updatePixelScale.3: " + this.hasPixelScale[0] + " (has) -> " + f + " (new), " + f2 + " (max), drop " + !this.isNativeValid());
        }
        if (this.isNativeValid()) {
            this.updatePixelScale(true, bl, true, f, f2);
        }
    }

    @Override
    protected final void instantiationFinishedImpl() {
        this.updatePixelScaleByDisplayID(false);
    }

    @Override
    protected void setScreen(ScreenImpl screenImpl) {
        super.setScreen(screenImpl);
        this.updatePixelScaleByDisplayID(false);
    }

    @Override
    protected void monitorModeChanged(MonitorEvent monitorEvent, boolean bl) {
        this.updatePixelScaleByWindowHandle(false);
    }

    @Override
    public final boolean setSurfaceScale(float[] fArray) {
        super.setSurfaceScale(fArray);
        boolean bl = false;
        if (this.isNativeValid()) {
            if (this.isOffscreenInstance) {
                NativeWindow nativeWindow = this.getParent();
                if (nativeWindow instanceof ScalableSurface) {
                    ScalableSurface scalableSurface = (ScalableSurface)((Object)nativeWindow);
                    scalableSurface.setSurfaceScale(this.reqPixelScale);
                    scalableSurface.getMaximumSurfaceScale(this.maxPixelScale);
                    scalableSurface.getMinimumSurfaceScale(this.minPixelScale);
                    float[] fArray2 = scalableSurface.getCurrentSurfaceScale(new float[2]);
                    bl = this.updatePixelScale(true, true, true, fArray2[0], this.maxPixelScale[0]);
                } else {
                    bl = this.updatePixelScale(true, true, true, this.reqPixelScale[0], this.maxPixelScale[0]);
                }
            } else {
                final float[] fArray3 = new float[2];
                System.arraycopy(this.hasPixelScale, 0, fArray3, 0, 2);
                if (SurfaceScaleUtils.setNewPixelScale(fArray3, fArray3, this.reqPixelScale, this.minPixelScale, this.maxPixelScale, DEBUG_IMPLEMENTATION ? this.getClass().getName() : null)) {
                    OSXUtil.RunOnMainThread(true, false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.setPixelScale0(WindowDriver.this.getWindowHandle(), WindowDriver.this.surfaceHandle, fArray3[0]);
                        }
                    });
                    bl = true;
                }
            }
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.setPixelScale: min[" + this.minPixelScale[0] + ", " + this.minPixelScale[1] + "], max[" + this.maxPixelScale[0] + ", " + this.maxPixelScale[1] + "], req[" + this.reqPixelScale[0] + ", " + this.reqPixelScale[1] + "] -> result[" + this.hasPixelScale[0] + ", " + this.hasPixelScale[1] + "] - changed " + bl + ", realized " + this.isNativeValid());
        }
        return bl;
    }

    @Override
    protected void createNativeImpl() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(this.getScreen().getDisplay().getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, this.getScreen().getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        this.reconfigureWindowImpl(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getReconfigureMask(Integer.MIN_VALUE, true));
        if (!this.isNativeValid()) {
            throw new NativeWindowException("Error creating window");
        }
    }

    @Override
    protected void closeNativeImpl() {
        block4: {
            try {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.CloseAction " + Thread.currentThread().getName());
                }
                final long l = this.getWindowHandle();
                this.visibleChanged(true, false);
                this.setWindowHandle(0L);
                this.surfaceHandle = 0L;
                this.sscSurfaceHandle = 0L;
                this.isOffscreenInstance = false;
                if (0L != l) {
                    OSXUtil.RunOnMainThread(false, true, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.close0(l);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG_IMPLEMENTATION) break block4;
                Exception exception = new Exception("Warning: closeNative failed - " + Thread.currentThread().getName(), throwable);
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected int lockSurfaceImpl() {
        long l = this.getWindowHandle();
        long l2 = this.surfaceHandle;
        if (0L != l2 && 0L != l) {
            return this.lockSurface0(l, l2) ? 3 : 1;
        }
        return 1;
    }

    @Override
    protected void unlockSurfaceImpl() {
        long l = this.getWindowHandle();
        long l2 = this.surfaceHandle;
        if (0L != l && 0L != l2 && !this.unlockSurface0(l, l2)) {
            throw new NativeWindowException("Failed to unlock surface, probably not locked!");
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return 0L != this.sscSurfaceHandle ? this.sscSurfaceHandle : this.surfaceHandle;
    }

    @Override
    public void setSurfaceHandle(long l) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.setSurfaceHandle(): 0x" + Long.toHexString(l));
        }
        this.sscSurfaceHandle = l;
        if (this.isNativeValid() && 0L != this.sscSurfaceHandle) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.orderOut0(0L != WindowDriver.this.getParentWindowHandle() ? WindowDriver.this.getParentWindowHandle() : WindowDriver.this.getWindowHandle());
                }
            });
        }
    }

    @Override
    protected void setTitleImpl(final String string) {
        OSXUtil.RunOnMainThread(false, false, new Runnable(){

            @Override
            public void run() {
                WindowDriver.this.setTitle0(WindowDriver.this.getWindowHandle(), string);
            }
        });
    }

    @Override
    protected void requestFocusImpl(final boolean bl) {
        final boolean bl2 = this.isFullscreen();
        boolean bl3 = this.isOffscreenInstance;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: requestFocusImpl(), isOffscreenInstance " + bl3 + ", isFullscreen " + bl2);
        }
        if (!bl3) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.requestFocus0(WindowDriver.this.getWindowHandle(), bl);
                    if (bl2) {
                        WindowDriver.this.focusChanged(false, true);
                    }
                }
            });
        } else {
            this.focusChanged(false, true);
        }
    }

    @Override
    public final void clearFocus() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: clearFocus(), isOffscreenInstance " + this.isOffscreenInstance);
        }
        if (!this.isOffscreenInstance) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.resignFocus0(WindowDriver.this.getWindowHandle());
                }
            });
        } else {
            this.focusChanged(false, false);
        }
    }

    private boolean useParent(NativeWindow nativeWindow) {
        return null != nativeWindow && 0L != nativeWindow.getWindowHandle();
    }

    @Override
    public void updatePosition(int n, int n2) {
        long l = this.getWindowHandle();
        if (0L != l && !this.isOffscreenInstance) {
            NativeWindow nativeWindow = this.getParent();
            boolean bl = this.useParent(nativeWindow);
            final Point point = bl ? this.getLocationOnScreenByParent(n, n2, nativeWindow) : (Point)WindowDriver.getLocationOnScreen0(l, n, n2);
            if (DEBUG_IMPLEMENTATION) {
                int n3 = nativeWindow.getX();
                int n4 = nativeWindow.getY();
                System.err.println("MacWindow: updatePosition() parent[" + bl + " " + n3 + "/" + n4 + "] " + n + "/" + n2 + " ->  " + n + "/" + n2 + " rel-client-pos, " + point + " screen-client-pos");
            }
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.setWindowClientTopLeftPoint0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY(), WindowDriver.this.isVisible());
                }
            });
            this.positionChanged(true, n, n2);
        }
    }

    @Override
    protected final int getSupportedReconfigMaskImpl() {
        return 16381;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, final int n5) {
        long l;
        Point point;
        boolean bl = WindowDriver.isOffscreenInstance(this, this.getParent());
        boolean bl2 = this.isOffscreenInstance = 0L != this.sscSurfaceHandle || bl;
        if (this.isOffscreenInstance) {
            n = 0;
            n2 = 0;
            point = new Point(0, 0);
        } else {
            NativeWindow nativeWindow = this.getParent();
            if (this.useParent(nativeWindow)) {
                point = this.getLocationOnScreenByParent(n, n2, nativeWindow);
            } else {
                if (0 != (0xC00000 & n5)) {
                    int[] nArray = new int[]{n, n2, n3, n4};
                    this.reconfigMaximizedManual(n5, nArray, this.getInsets());
                    n = nArray[0];
                    n2 = nArray[1];
                    n3 = nArray[2];
                    n4 = nArray[3];
                }
                point = new Point(n, n2);
            }
        }
        int n6 = n;
        int n7 = n2;
        final int n8 = n3;
        final int n9 = n4;
        boolean bl3 = this.hasFocus();
        if (DEBUG_IMPLEMENTATION) {
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.getGraphicsConfiguration();
            NativeWindow nativeWindow = this.getParent();
            AbstractGraphicsConfiguration abstractGraphicsConfiguration2 = null != nativeWindow ? nativeWindow.getGraphicsConfiguration() : null;
            System.err.println("MacWindow reconfig.0: " + n6 + "/" + n7 + " -> clientPosOnScreen " + point + " - " + n8 + "x" + n9 + ", " + WindowDriver.getReconfigStateMaskString(n5) + ",\n\t parent type " + (null != nativeWindow ? nativeWindow.getClass().getName() : null) + ",\n\t   this-chosenCaps " + (null != abstractGraphicsConfiguration ? abstractGraphicsConfiguration.getChosenCapabilities() : null) + ",\n\t parent-chosenCaps " + (null != abstractGraphicsConfiguration2 ? abstractGraphicsConfiguration2.getChosenCapabilities() : null) + ", isOffscreenInstance(sscSurfaceHandle " + WindowDriver.toHexString(this.sscSurfaceHandle) + ", ioi: " + bl + ") -> " + this.isOffscreenInstance);
        }
        if (0 != (Integer.MIN_VALUE & n5) && 0 == (1 & n5)) {
            if (!this.isOffscreenInstance) {
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.orderOut0(WindowDriver.this.getWindowHandle());
                        WindowDriver.this.visibleChanged(true, false);
                    }
                });
            } else {
                this.visibleChanged(true, false);
            }
        }
        if (0L == (l = this.getWindowHandle()) && 0 != (1 & n5) || 0 != (0x20000000 & n5) || 0 != (0x10000000 & n5) || 0 != (0x8000000 & n5) || 0 != (0x4000000 & n5) || 0 != (0x1000000 & n5) || 0 != (0x200000 & n5)) {
            if (this.isOffscreenInstance) {
                this.createWindow(true, 0L != l, point, 64, 64, n5);
            } else {
                this.createWindow(false, 0L != l, point, n8, n9, n5);
            }
            this.updatePixelScaleByWindowHandle(false);
            if (this.isOffscreenInstance) {
                super.sizeChanged(false, n8, n9, true);
                this.positionChanged(false, n6, n7);
            } else {
                this.updateSizePosInsets0(this.getWindowHandle(), false);
            }
            this.visibleChanged(false, 0 != (1 & n5));
            if (bl3) {
                this.requestFocusImpl(true);
            }
        } else if (0L != l) {
            if (n8 > 0 && n9 > 0) {
                if (!this.isOffscreenInstance) {
                    OSXUtil.RunOnMainThread(true, false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.setWindowClientTopLeftPointAndSize0(l, point.getX(), point.getY(), n8, n9, 0 != (1 & n5));
                        }
                    });
                    this.updateSizePosInsets0(l, false);
                } else {
                    super.sizeChanged(false, n8, n9, false);
                    this.positionChanged(false, n6, n7);
                }
            }
            if (0 != (Integer.MIN_VALUE & n5) && 0 != (1 & n5)) {
                if (!this.isOffscreenInstance) {
                    OSXUtil.RunOnMainThread(false, false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.orderFront0(WindowDriver.this.getWindowHandle());
                            WindowDriver.this.visibleChanged(true, true);
                        }
                    });
                } else {
                    this.visibleChanged(true, true);
                }
            }
        } else {
            throw new InternalError("Null windowHandle but no re-creation triggered, check visibility: " + this.getStateMaskString());
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow reconfig.X: " + this.getLocationOnScreenImpl(0, 0) + " " + this.getWidth() + "x" + this.getHeight() + ", insets " + this.getInsets() + ", " + this.getStateMaskString());
        }
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        NativeWindow nativeWindow = this.getParent();
        if (this.useParent(nativeWindow)) {
            return this.getLocationOnScreenByParent(n, n2, nativeWindow);
        }
        long l = this.getWindowHandle();
        if (!this.isOffscreenInstance && 0L != l) {
            return (Point)WindowDriver.getLocationOnScreen0(l, n, n2);
        }
        return new Point(n, n2);
    }

    private Point getLocationOnScreenByParent(int n, int n2, NativeWindow nativeWindow) {
        return new Point(n, n2).translate(nativeWindow.getLocationOnScreen(null));
    }

    protected void screenPositionChanged(final boolean bl, final int n, final int n2) {
        if (this.isNativeValid()) {
            final NativeWindow nativeWindow = this.getParent();
            if (!this.useParent(nativeWindow) || this.isOffscreenInstance) {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.positionChanged.0 (Screen Pos - TOP): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n + "/" + n2);
                }
                this.positionChanged(bl, n, n2);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Point point = new Point(n, n2);
                        Point point2 = nativeWindow.getLocationOnScreen(null);
                        point.translate(point2.scale(-1, -1));
                        if (Window.DEBUG_IMPLEMENTATION) {
                            System.err.println("MacWindow.positionChanged.1 (Screen Pos - CHILD): (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") " + WindowDriver.this.getX() + "/" + WindowDriver.this.getY() + " -> absPos " + n + "/" + n2 + ", parentOnScreen " + point2 + " -> " + point);
                        }
                        WindowDriver.this.positionChanged(false, point.getX(), point.getY());
                    }
                };
                if (bl) {
                    new InterruptSource.Thread(null, runnable).start();
                } else {
                    runnable.run();
                }
            }
        } else if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.positionChanged.2 (Screen Pos - IGN): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n + "/" + n2);
        }
    }

    @Override
    protected void sizeChanged(boolean bl, int n, int n2, boolean bl2) {
        if (bl2 || this.getWidth() != n || this.getHeight() != n2) {
            NativeWindow nativeWindow;
            boolean bl3;
            if (this.isNativeValid() && !this.isOffscreenInstance && (bl3 = this.useParent(nativeWindow = this.getParent()))) {
                int n3 = this.getX();
                int n4 = this.getY();
                final Point point = this.getLocationOnScreenByParent(n3, n4, nativeWindow);
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow: sizeChanged() parent[" + bl3 + " " + n3 + "/" + n4 + "] " + this.getX() + "/" + this.getY() + " " + n + "x" + n2 + " ->  " + point + " screen-client-pos");
                }
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.setWindowClientTopLeftPoint0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY(), WindowDriver.this.isVisible());
                    }
                });
            }
            this.superSizeChangedOffThread(bl, n, n2, bl2);
        }
    }

    private void superSizeChangedOffThread(boolean bl, final int n, final int n2, final boolean bl2) {
        if (bl) {
            new InterruptSource.Thread(){

                @Override
                public void run() {
                    WindowDriver.super.sizeChanged(false, n, n2, bl2);
                }
            }.start();
        } else {
            WindowDriver.super.sizeChanged(false, n, n2, bl2);
        }
    }

    protected void sizeScreenPosInsetsChanged(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        this.sizeChanged(bl, n3, n4, bl2);
        this.screenPositionChanged(bl, n, n2);
        this.insetsChanged(bl, n5, n6, n7, n8);
    }

    @Override
    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
        if (!this.isOffscreenInstance) {
            final long l = null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L;
            OSXUtil.RunOnMainThread(true, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.setPointerIcon0(WindowDriver.this.getWindowHandle(), l);
                }
            });
        }
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        if (!this.isOffscreenInstance) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.setPointerVisible0(WindowDriver.this.getWindowHandle(), WindowDriver.this.hasFocus(), bl);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    protected boolean confinePointerImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            WindowDriver.confinePointer0(this.getWindowHandle(), bl);
            return true;
        }
        return false;
    }

    @Override
    protected void warpPointerImpl(int n, int n2) {
        if (!this.isOffscreenInstance) {
            WindowDriver.warpPointer0(this.getWindowHandle(), SurfaceScaleUtils.scaleInv(n, this.getPixelScaleX()), SurfaceScaleUtils.scaleInv(n2, this.getPixelScaleY()));
        }
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float[] fArray, float f) {
        super.doMouseEvent(bl, bl2, s, n, SurfaceScaleUtils.scale(n2, this.getPixelScaleX()), SurfaceScaleUtils.scale(n3, this.getPixelScaleY()), s2, fArray, f);
    }

    @Override
    public final void sendKeyEvent(short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    protected final void enqueueKeyEvent(boolean bl, short s, int n, short s2, char c, char c2) {
        short s3 = MacKeyUtil.validateKeyCode(s2, c);
        short s4 = '\u0000' != c2 ? KeyEvent.utf16ToVKey(c2) : (short)0;
        short s5 = 0 != s4 ? s4 : s3;
        switch (s) {
            case 301: {
                if (!this.isKeyCodeTracked(s3)) break;
                this.setKeyPressed(s3, false);
                break;
            }
            case 300: {
                if (!this.isKeyCodeTracked(s3) || !this.setKeyPressed(s3, true)) break;
                super.enqueueKeyEvent(bl, (short)301, n |= 0x20000000, s3, s5, c);
            }
        }
        super.enqueueKeyEvent(bl, s, n, s3, s5, c);
    }

    protected int getDisplayID() {
        if (!this.isOffscreenInstance) {
            return this.getDisplayID0(this.getWindowHandle());
        }
        return 0;
    }

    private void createWindow(final boolean bl, boolean bl2, final PointImmutable pointImmutable, final int n, final int n2, final int n3) {
        final long l = this.getParentWindowHandle();
        final long l2 = this.getWindowHandle();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.createWindow on thread " + Thread.currentThread().getName() + ": offscreen " + bl + ", recreate " + bl2 + ", pS " + pointImmutable + ", " + n + "x" + n2 + ", state " + WindowDriver.getReconfigStateMaskString(n3) + ", preWinHandle " + WindowDriver.toHexString(l2) + ", parentWin " + WindowDriver.toHexString(l) + ", surfaceHandle " + WindowDriver.toHexString(this.surfaceHandle));
        }
        try {
            if (0L != l2) {
                this.setWindowHandle(0L);
                if (0L == this.surfaceHandle) {
                    throw new NativeWindowException("Internal Error - create w/ window, but no Newt NSView");
                }
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.changeContentView0(l, l2, 0L);
                        WindowDriver.this.close0(l2);
                    }
                });
            } else {
                if (0L != this.surfaceHandle) {
                    throw new NativeWindowException("Internal Error - create w/o window, but has Newt NSView");
                }
                this.surfaceHandle = this.createView0(pointImmutable.getX(), pointImmutable.getY(), n, n2);
                if (0L == this.surfaceHandle) {
                    throw new NativeWindowException("Could not create native view " + Thread.currentThread().getName() + " " + this);
                }
            }
            int n4 = 0;
            if (0 != (0x10 & n3) || bl) {
                n4 = 0;
            } else {
                n4 = 7;
                if (0 != (0x100 & n3)) {
                    n4 |= 8;
                }
            }
            int n5 = n4;
            final long l3 = this.createWindow0(pointImmutable.getX(), pointImmutable.getY(), n, n2, 0 != (0x800 & n3), n5, 2, this.surfaceHandle);
            if (l3 == 0L) {
                throw new NativeWindowException("Could not create native window " + Thread.currentThread().getName() + " " + this);
            }
            this.setWindowHandle(l3);
            final boolean bl3 = this.getGraphicsConfiguration().getChosenCapabilities().isBackgroundOpaque() && !bl;
            OSXUtil.RunOnMainThread(true, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.initWindow0(l, l3, pointImmutable.getX(), pointImmutable.getY(), n, n2, WindowDriver.this.reqPixelScale[0], bl3, !bl && 0 != (0x20 & n3), !bl && 0 != (0x40 & n3), !bl && 0 != (1 & n3), WindowDriver.this.surfaceHandle);
                    if (bl) {
                        WindowDriver.this.orderOut0(0L != l ? l : l3);
                    } else {
                        WindowDriver.this.setTitle0(l3, WindowDriver.this.getTitle());
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static native boolean initIDs0();

    private native long createView0(int var1, int var2, int var3, int var4);

    private native long createWindow0(int var1, int var2, int var3, int var4, boolean var5, int var6, int var7, long var8);

    private native void initWindow0(long var1, long var3, int var5, int var6, int var7, int var8, float var9, boolean var10, boolean var11, boolean var12, boolean var13, long var14);

    private native int getDisplayID0(long var1);

    private native void setPixelScale0(long var1, long var3, float var5);

    private native boolean lockSurface0(long var1, long var3);

    private native boolean unlockSurface0(long var1, long var3);

    private native void requestFocus0(long var1, boolean var3);

    private native void resignFocus0(long var1);

    private native void orderOut0(long var1);

    private native void orderFront0(long var1);

    private native void close0(long var1);

    private native void setTitle0(long var1, String var3);

    private native long contentView0(long var1);

    private native void changeContentView0(long var1, long var3, long var5);

    private native void setWindowClientTopLeftPointAndSize0(long var1, int var3, int var4, int var5, int var6, boolean var7);

    private native void setWindowClientTopLeftPoint0(long var1, int var3, int var4, boolean var5);

    private native void updateSizePosInsets0(long var1, boolean var3);

    private static native Object getLocationOnScreen0(long var0, int var2, int var3);

    private static native void setPointerIcon0(long var0, long var2);

    private static native void setPointerVisible0(long var0, boolean var2, boolean var3);

    private static native void confinePointer0(long var0, boolean var2);

    private static native void warpPointer0(long var0, int var2, int var3);

    static {
        DisplayDriver.initSingleton();
    }
}

