(ns clj-qldb.core
  (:import (pbalduino.cljqldb.helper Driver)
           (software.amazon.qldb PooledQldbDriver
                                 QldbSession)))

(defn create-driver
  ([^String ledger-name]
   (create-driver ledger-name 5))
  ([^String ledger-name ^Integer retries]
   {:pre [(some? ledger-name)]}
   (Driver/createQldbDriver ledger-name retries)))

(defn get-session [^PooledQldbDriver driver]
  (.getSession driver))

(defn create-session
  ([^String ledger-name]
   (create-session ledger-name 5))
  ([^String ledger-name ^Integer retries]
   (get-session (Driver/createQldbDriver ledger-name retries))))

(defn get-table-names [^QldbSession session]
  (-> session
      .getTableNames
      .iterator
      iterator-seq))

(defn create-table [_ _])

(defn insert [session table data]
  (let [statement (format "INSERT INTO %s ?" table)]
    (.execute session (fn [txn]
                        (println "I'm inside the lambda!" statement data txn)))))

; delete

; select
