/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.Boot;
import com.simontuffs.onejar.Handler;
import com.simontuffs.onejar.IProperties;
import com.simontuffs.onejar.OneJarURLConnection;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarClassLoader
extends ClassLoader
implements IProperties {
    public static final String LIB_PREFIX = "lib/";
    public static final String BINLIB_PREFIX = "binlib/";
    public static final String MAIN_PREFIX = "main/";
    public static final String RECORDING = "recording";
    public static final String TMP = "tmp";
    public static final String UNPACK = "unpack";
    public static final String EXPAND = "One-Jar-Expand";
    public static final String EXPAND_DIR = "One-Jar-Expand-Dir";
    public static final String SHOW_EXPAND = "One-Jar-Show-Expand";
    public static final String CONFIRM_EXPAND = "One-Jar-Confirm-Expand";
    public static final String CLASS = ".class";
    public static final String NL = System.getProperty("line.separator");
    public static final String JAVA_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    protected String name;
    protected boolean noExpand;
    protected boolean expanded;
    protected ClassLoader externalClassLoader;
    protected Map byteCode = Collections.synchronizedMap(new HashMap());
    protected Map pdCache = Collections.synchronizedMap(new HashMap());
    protected Map binLibPath = Collections.synchronizedMap(new HashMap());
    protected Set jarNames = Collections.synchronizedSet(new HashSet());
    protected boolean record = false;
    protected boolean flatten = false;
    protected boolean unpackFindResource = false;
    protected boolean verbose = false;
    protected boolean info = false;
    protected boolean warning = true;
    protected String recording = "recording";
    protected String jarName;
    protected String mainJar;
    protected String wrapDir;
    protected boolean delegateToParent;
    protected static ThreadLocal current;
    protected URLStreamHandler oneJarHandler = new Handler();
    protected IURLFactory urlFactory = new FileURLFactory();

    protected String PREFIX() {
        return "JarClassLoader: ";
    }

    protected String NAME() {
        return this.name != null ? "'" + this.name + "' " : "";
    }

    protected void VERBOSE(String string) {
        if (this.verbose) {
            System.out.println(this.PREFIX() + this.NAME() + string);
        }
    }

    protected void WARNING(String string) {
        if (this.warning) {
            System.err.println(this.PREFIX() + "Warning: " + this.NAME() + string);
        }
    }

    protected void INFO(String string) {
        if (this.info) {
            System.out.println(this.PREFIX() + "Info: " + this.NAME() + string);
        }
    }

    protected void PRINTLN(String string) {
        System.out.println(string);
    }

    protected void PRINT(String string) {
        System.out.print(string);
    }

    public JarClassLoader(String string) {
        this.wrapDir = string;
        this.delegateToParent = this.wrapDir == null;
        Boot.setProperties(this);
        this.init();
    }

    public JarClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.delegateToParent = true;
        Boot.setProperties(this);
        this.init();
    }

    protected void init() {
        String string = System.getProperty("one-jar.class.path");
        if (string != null) {
            String[] stringArray = string.split("\\|");
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                try {
                    arrayList.add(new URL(string2));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        String string3 = new File(string2).getCanonicalPath();
                        arrayList.add(new File(string3).toURI().toURL());
                        continue;
                    }
                    catch (MalformedURLException malformedURLException2) {
                        Boot.WARNING("Unable to parse external path: " + string2);
                        continue;
                    }
                    catch (IOException iOException) {
                        Boot.WARNING("Unable to parse external path: " + string2);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Boot.WARNING("Unable to parse external path: " + string2);
                    }
                }
            }
            URL[] uRLArray = arrayList.toArray(new URL[0]);
            Boot.INFO("external URLs=" + Arrays.asList(uRLArray));
            this.externalClassLoader = new URLClassLoader(uRLArray, (ClassLoader)this){
                static final String LOAD_CLASS = "loadClass():";
                static final String GET_RESOURCE = "getResource():";
                static final String FIND_RESOURCE = "findResource():";

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Class loadClass(String string) throws ClassNotFoundException {
                    if (this.reentered(LOAD_CLASS + string)) {
                        throw new ClassNotFoundException(string);
                    }
                    JarClassLoader.this.VERBOSE("externalClassLoader.loadClass(" + string + ")");
                    Object t = current.get();
                    current.set(LOAD_CLASS + string);
                    try {
                        Class<?> clazz = super.loadClass(string);
                        return clazz;
                    }
                    finally {
                        current.set(t);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public URL getResource(String string) {
                    if (this.reentered(GET_RESOURCE + string)) {
                        return null;
                    }
                    JarClassLoader.this.VERBOSE("externalClassLoader.getResource(" + string + ")");
                    Object t = current.get();
                    current.set(GET_RESOURCE + string);
                    try {
                        URL uRL = super.getResource(string);
                        return uRL;
                    }
                    finally {
                        current.set(t);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public URL findResource(String string) {
                    if (this.reentered(FIND_RESOURCE + string)) {
                        return null;
                    }
                    JarClassLoader.this.VERBOSE("externalClassLoader.findResource(" + string + ")");
                    Object t = current.get();
                    current.set(string);
                    try {
                        current.set(FIND_RESOURCE + string);
                        URL uRL = super.findResource(string);
                        return uRL;
                    }
                    finally {
                        current.set(t);
                    }
                }

                protected boolean reentered(String string) {
                    Object t = current.get();
                    return t != null && t.equals(string);
                }
            };
        }
    }

    public String load(String string) {
        String string2 = Boot.getMyJarPath();
        return this.load(string, string2);
    }

    public String load(String string, String string2) {
        this.VERBOSE("load(" + string + "," + string2 + ")");
        if (this.record) {
            new File(this.recording).mkdirs();
        }
        try {
            Object object;
            boolean bl;
            if (string2 == null) {
                string2 = Boot.getMyJarPath();
            }
            JarFile jarFile = new JarFile(string2);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            Manifest manifest = jarFile.getManifest();
            String[] stringArray = null;
            String string3 = manifest.getMainAttributes().getValue(EXPAND);
            String string4 = System.getProperty("one-jar.expand.dir");
            if (string4 == null) {
                string4 = manifest.getMainAttributes().getValue(EXPAND_DIR);
            }
            if (string4 == null) {
                String string5 = new File(string2).getName().replaceFirst("\\.[^\\.]*$", "");
                string4 = "${java.io.tmpdir}/" + string5;
            }
            string4 = this.replaceProps(System.getProperties(), string4);
            System.setProperty("one-jar.expand.dir", string4);
            boolean bl2 = true;
            File file = new File(string4);
            if (!this.noExpand && string3 != null) {
                this.expanded = true;
                this.VERBOSE("One-Jar-Expand=" + string3);
                stringArray = string3.split(",");
                bl = Boolean.TRUE.toString().equals(manifest.getMainAttributes().getValue(CONFIRM_EXPAND));
                if (bl) {
                    object = this.getConfirmation(file);
                    if (object == null) {
                        object = "n";
                    }
                    if (((String)(object = ((String)object).trim().toLowerCase())).startsWith("q")) {
                        this.PRINTLN("exiting without expansion.");
                        System.exit(1);
                    } else if (((String)object).startsWith("n")) {
                        bl2 = false;
                    }
                }
            }
            if (bl = Boolean.TRUE.toString().equals(manifest.getMainAttributes().getValue(SHOW_EXPAND))) {
                this.PRINTLN("Expanding to: " + file.getAbsolutePath());
            }
            while (enumeration.hasMoreElements()) {
                File file2;
                Object object2;
                Object object3;
                object = enumeration.nextElement();
                if (((ZipEntry)object).isDirectory()) continue;
                String string6 = ((ZipEntry)object).getName();
                if (stringArray != null && bl2 && JarClassLoader.shouldExpand(stringArray, string6)) {
                    object3 = new File(file, string6);
                    if (!((File)object3).exists() || ((File)object3).lastModified() < ((ZipEntry)object).getTime()) {
                        object2 = "Expanding:  " + string6;
                        if (bl) {
                            this.PRINTLN((String)object2);
                        } else {
                            this.INFO((String)object2);
                        }
                        if (((File)object3).exists()) {
                            this.INFO("Update because lastModified=" + new Date(((File)object3).lastModified()) + ", entry=" + new Date(((ZipEntry)object).getTime()));
                        }
                        if ((file2 = ((File)object3).getParentFile()) != null) {
                            file2.mkdirs();
                        }
                        this.VERBOSE("using jarFile.getInputStream(" + object + ")");
                        InputStream inputStream = jarFile.getInputStream((ZipEntry)object);
                        FileOutputStream fileOutputStream = new FileOutputStream((File)object3);
                        this.copy(inputStream, fileOutputStream);
                        inputStream.close();
                        fileOutputStream.close();
                    } else {
                        object2 = "Up-to-date: " + string6;
                        if (bl) {
                            this.PRINTLN((String)object2);
                        } else {
                            this.VERBOSE((String)object2);
                        }
                    }
                }
                if (this.wrapDir != null && string6.startsWith(this.wrapDir) || string6.startsWith(LIB_PREFIX) || string6.startsWith(MAIN_PREFIX)) {
                    if (this.wrapDir != null && !((ZipEntry)object).getName().startsWith(this.wrapDir)) continue;
                    this.VERBOSE("caching " + string6);
                    this.VERBOSE("using jarFile.getInputStream(" + object + ")");
                    object3 = jarFile.getInputStream((ZipEntry)object);
                    if (object3 == null) {
                        throw new IOException("Unable to load resource /" + string6 + " using " + this);
                    }
                    this.loadByteCode((InputStream)object3, string6, null);
                    if (!string6.startsWith(MAIN_PREFIX)) continue;
                    if (string == null) {
                        object3 = new JarInputStream(jarFile.getInputStream((ZipEntry)object));
                        object2 = ((JarInputStream)object3).getManifest();
                        ((ZipInputStream)object3).close();
                        if (object2 == null) continue;
                        string = ((JarInputStream)object3).getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                        this.mainJar = string6;
                        continue;
                    }
                    if (this.mainJar == null) continue;
                    this.WARNING("A main class is defined in multiple jar files inside main/" + this.mainJar + " and " + string6);
                    this.WARNING("The main class " + string + " from " + this.mainJar + " will be used");
                    continue;
                }
                if (this.wrapDir == null && string6.startsWith(UNPACK)) {
                    object3 = this.getClass().getResourceAsStream("/" + string6);
                    if (object3 == null) {
                        throw new IOException(string6);
                    }
                    object2 = new File(TMP);
                    file2 = new File((File)object2, string6.replace('/', '.'));
                    if (file2.exists()) continue;
                    this.INFO("unpacking " + string6 + " into " + ((File)object2).getCanonicalPath());
                    this.loadByteCode((InputStream)object3, string6, TMP);
                    file2.getParentFile().mkdirs();
                    file2.createNewFile();
                    continue;
                }
                if (string6.endsWith(CLASS)) {
                    this.loadBytes((JarEntry)object, jarFile.getInputStream((ZipEntry)object), "/", null, manifest);
                    this.VERBOSE("One-Jar class: " + jarFile.getName() + "!/" + ((ZipEntry)object).getName());
                    continue;
                }
                this.loadBytes((JarEntry)object, jarFile.getInputStream((ZipEntry)object), "/", null, manifest);
                this.VERBOSE("One-Jar resource: " + jarFile.getName() + "!/" + ((ZipEntry)object).getName());
            }
        }
        catch (IOException iOException) {
            System.err.println("Unable to load resource: " + iOException);
            iOException.printStackTrace(System.err);
        }
        return string;
    }

    public String replaceProps(Map map, String string) {
        Object object;
        Pattern pattern = Pattern.compile("\\$\\{([^\\}]*)");
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.find();
        HashMap hashMap = new HashMap();
        while (bl) {
            object = matcher.group(1);
            hashMap.put(object, map.get(object));
            bl = matcher.find();
        }
        object = hashMap.keySet();
        for (String string2 : hashMap.keySet()) {
            string = string.replace("${" + string2 + "}", (String)hashMap.get(string2));
        }
        return string;
    }

    public static boolean shouldExpand(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected void loadByteCode(InputStream inputStream, String string, String string2) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        JarEntry jarEntry = null;
        Manifest manifest = jarInputStream.getManifest();
        if (manifest == null) {
            this.WARNING("Null manifest from input stream associated with: " + string);
        }
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            this.loadBytes(jarEntry, jarInputStream, string, string2, manifest);
        }
        if (manifest != null) {
            jarEntry = new JarEntry("META-INF/MANIFEST.MF");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            manifest.write(byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.loadBytes(jarEntry, byteArrayInputStream, string, string2, manifest);
        }
    }

    protected void loadBytes(JarEntry jarEntry, InputStream inputStream, String string, String string2, Manifest manifest) throws IOException {
        Object object;
        String string3 = jarEntry.getName();
        int n = string3.lastIndexOf(46);
        String string4 = string3.substring(n + 1);
        int n2 = string3.lastIndexOf(47, n - 1);
        if (string3.endsWith(CLASS) && n2 > -1 && this.getPackage((String)(object = string3.substring(0, n2).replace('/', '.'))) == null) {
            if (manifest != null) {
                this.definePackage((String)object, manifest, this.urlFactory.getCodeBase(string));
            } else {
                this.definePackage((String)object, null, null, null, null, null, null, null);
            }
        }
        object = new ByteArrayOutputStream();
        this.copy(inputStream, (OutputStream)object);
        if (string2 != null) {
            File file = new File(string2, jarEntry.getName());
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(((ByteArrayOutputStream)object).toByteArray());
            fileOutputStream.close();
        } else if (string4.equals("class")) {
            if (this.alreadyCached(string3, string, (ByteArrayOutputStream)object)) {
                return;
            }
            this.byteCode.put(string3, new ByteCode(string3, jarEntry.getName(), (ByteArrayOutputStream)object, string, manifest));
            this.VERBOSE("cached bytes for class " + string3);
        } else {
            String string5 = string + "/" + string3;
            this.byteCode.put(string5, new ByteCode(string5, jarEntry.getName(), (ByteArrayOutputStream)object, string, manifest));
            this.jarNames.add(string);
            this.VERBOSE("cached bytes for local name " + string5);
            if (this.alreadyCached(string3, string, (ByteArrayOutputStream)object)) {
                return;
            }
            this.byteCode.put(string3, new ByteCode(string3, jarEntry.getName(), (ByteArrayOutputStream)object, string, manifest));
            this.VERBOSE("cached bytes for entry name " + string3);
        }
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Thread.currentThread().setContextClassLoader(this);
        return super.loadClass(string, bl);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this.externalClassLoader != null) {
            try {
                return this.externalClassLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((clazz = this.findLoadedClass(string)) != null) {
            return clazz;
        }
        this.VERBOSE("findClass(" + string + ")");
        String string2 = string.replace('.', '/') + CLASS;
        ByteCode byteCode = (ByteCode)this.byteCode.get(string2);
        if (byteCode != null) {
            Object object;
            ProtectionDomain protectionDomain;
            this.VERBOSE("found " + string + " in codebase '" + byteCode.codebase + "'");
            if (this.record) {
                this.record(byteCode);
            }
            if ((protectionDomain = (ProtectionDomain)this.pdCache.get(byteCode.codebase)) == null) {
                try {
                    object = this.urlFactory.getCodeBase(byteCode.codebase);
                    CodeSource codeSource = new CodeSource((URL)object, (Certificate[])null);
                    protectionDomain = new ProtectionDomain(codeSource, null, this, null);
                    this.pdCache.put(byteCode.codebase, protectionDomain);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new ClassNotFoundException(string, malformedURLException);
                }
            }
            object = byteCode.bytes;
            int n = string.lastIndexOf(46);
            if (n != -1) {
                String string3 = string.substring(0, n);
                Package package_ = this.getPackage(string3);
                Manifest manifest = byteCode.manifest;
                if (package_ != null) {
                    if (package_.isSealed()) {
                        if (!package_.isSealed(protectionDomain.getCodeSource().getLocation())) {
                            throw new SecurityException("sealing violation: package " + string3 + " is sealed");
                        }
                    } else if (manifest != null && this.isSealed(string3, manifest)) {
                        throw new SecurityException("sealing violation: can't seal package " + string3 + ": already loaded");
                    }
                } else if (manifest != null) {
                    this.definePackage(string3, manifest, protectionDomain.getCodeSource().getLocation());
                } else {
                    this.definePackage(string3, null, null, null, null, null, null, null);
                }
            }
            return this.defineClass(string, (byte[])object, protectionDomain);
        }
        this.VERBOSE(string + " not found");
        throw new ClassNotFoundException(string);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        boolean bl;
        String string2 = string.concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if (string9 != null && (bl = Boolean.parseBoolean(string9))) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    protected Class defineClass(String string, byte[] byArray, ProtectionDomain protectionDomain) throws ClassFormatError {
        this.VERBOSE("defineClass(" + string + ")");
        return this.defineClass(string, byArray, 0, byArray.length, protectionDomain);
    }

    protected void record(ByteCode byteCode) {
        String string;
        File file = new File(this.recording, this.flatten ? "" : byteCode.codebase);
        File file2 = new File(file, string = byteCode.original);
        if (!file2.exists()) {
            file2.getParentFile().mkdirs();
            this.VERBOSE("" + file2);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.write(byteCode.bytes);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println(this.PREFIX() + "unable to record " + file2 + ": " + iOException);
            }
        }
    }

    protected String canon(String string) {
        String string2;
        String string3 = string2 = (string = string.replaceAll("/\\./", "/"));
        while (!(string3 = string2).equals(string2 = string2.replaceFirst("([^/]*/\\.\\./)", ""))) {
        }
        return string2;
    }

    public InputStream getByteStream(String string) {
        Object object;
        this.VERBOSE("getByteStream(" + string + ")");
        InputStream inputStream = null;
        if (this.externalClassLoader != null) {
            inputStream = this.externalClassLoader.getResourceAsStream(string);
        }
        if (inputStream == null && (object = this.getParent()) != null) {
            inputStream = ((ClassLoader)object).getResourceAsStream(string);
        }
        if (inputStream == null) {
            object = (ByteCode)this.byteCode.get(this.resolve(string = this.canon(string)));
            if (object == null) {
                object = (ByteCode)this.byteCode.get(string);
            }
            if (object != null) {
                inputStream = new ByteArrayInputStream(((ByteCode)object).bytes);
            }
        }
        if (inputStream == null && this.jarNames.contains(string)) {
            this.INFO("loading resource file directly" + string);
            inputStream = super.getResourceAsStream(string);
        }
        if (inputStream == null && this.delegateToParent) {
            object = this.getParent();
            inputStream = object instanceof JarClassLoader ? ((JarClassLoader)object).getByteStream(string) : ((ClassLoader)object).getResourceAsStream(string);
        }
        this.VERBOSE("getByteStream(" + string + ") -> " + inputStream);
        return inputStream;
    }

    protected String resolve(String string) {
        String string2;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        String string3 = null;
        String string4 = this.getCaller();
        ByteCode byteCode = (ByteCode)this.byteCode.get(string4);
        if (byteCode != null && this.byteCode.get(string2 = byteCode.codebase + "/" + string) != null) {
            string3 = string2;
        }
        if (string3 == null) {
            string3 = this.byteCode.get(string) == null ? null : string;
        }
        this.VERBOSE("resource " + string + " resolved to " + string3 + (byteCode != null ? " in codebase " + byteCode.codebase : " (unknown codebase)"));
        return string3;
    }

    protected boolean alreadyCached(String string, String string2, ByteArrayOutputStream byteArrayOutputStream) {
        ByteCode byteCode = (ByteCode)this.byteCode.get(string);
        if (byteCode != null) {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (!Arrays.equals(byteCode.bytes, byArray) && !string.startsWith("META-INF")) {
                String string3 = byteCode.name + " in " + string2 + " is hidden by " + byteCode.codebase + " (with different bytecode)";
                if (string.endsWith(CLASS)) {
                    this.WARNING(byteCode.name + " in " + string2 + " is hidden by " + byteCode.codebase + " (with different bytecode)");
                } else {
                    this.INFO(byteCode.name + " in " + string2 + " is hidden by " + byteCode.codebase + " (with different bytes)");
                }
            } else {
                this.VERBOSE(byteCode.name + " in " + string2 + " is hidden by " + byteCode.codebase + " (with same bytecode)");
            }
            byArray = null;
            return true;
        }
        return false;
    }

    protected String getCaller() {
        return null;
    }

    @Override
    public void setRecording(String string) {
        this.recording = string;
        if (this.recording == null) {
            this.recording = RECORDING;
        }
    }

    public String getRecording() {
        return this.recording;
    }

    @Override
    public void setRecord(boolean bl) {
        this.record = bl;
    }

    public boolean getRecord() {
        return this.record;
    }

    @Override
    public void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    @Override
    public void setVerbose(boolean bl) {
        this.verbose = bl;
        if (this.verbose) {
            this.info = true;
        }
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    @Override
    public void setInfo(boolean bl) {
        this.info = bl;
    }

    public boolean getInfo() {
        return this.info;
    }

    @Override
    public void setWarning(boolean bl) {
        this.warning = bl;
    }

    public boolean getWarning() {
        return this.warning;
    }

    @Override
    public URL getResource(String string) {
        URL uRL;
        if (this.externalClassLoader != null && (uRL = this.externalClassLoader.getResource(string)) != null) {
            return uRL;
        }
        return super.getResource(string);
    }

    public void setURLFactory(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.urlFactory = (IURLFactory)this.loadClass(string).newInstance();
    }

    public IURLFactory getURLFactory() {
        return this.urlFactory;
    }

    @Override
    protected URL findResource(String string) {
        try {
            URL uRL;
            this.VERBOSE("findResource(\"" + string + "\")");
            URL uRL2 = uRL = this.externalClassLoader != null ? this.externalClassLoader.getResource(string) : null;
            if (uRL != null) {
                this.INFO("findResource() found in external: \"" + string + "\"");
                return uRL;
            }
            ClassLoader classLoader = this.getParent();
            if (classLoader != null && (uRL = classLoader.getResource(string)) != null) {
                return uRL;
            }
            String string2 = this.resolve(string);
            if (string2 != null) {
                ByteCode byteCode = (ByteCode)this.byteCode.get(string2);
                this.INFO("findResource() found: \"" + string + "\" for caller " + this.getCaller() + " in codebase " + byteCode.codebase);
                return this.urlFactory.getURL(byteCode.codebase, string);
            }
            this.INFO("findResource(): unable to locate \"" + string + "\"");
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            this.WARNING("unable to locate " + string + " due to " + malformedURLException);
            return null;
        }
    }

    protected Enumeration findResources(String string) throws IOException {
        Object object;
        this.INFO("findResources(" + string + ")");
        this.INFO("findResources: looking in " + this.jarNames);
        Iterator iterator = this.jarNames.iterator();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (iterator.hasNext()) {
            object = iterator.next().toString() + "/" + string;
            ByteCode byteCode = (ByteCode)this.byteCode.get(object);
            if (!this.byteCode.containsKey(object)) continue;
            URL uRL = this.urlFactory.getURL(byteCode.codebase, string);
            this.INFO("findResources(): Adding " + uRL + " to resources list.");
            arrayList.add(uRL);
        }
        object = arrayList.iterator();
        return new Enumeration((Iterator)object){
            final /* synthetic */ Iterator val$ri;
            {
                this.val$ri = iterator;
            }

            @Override
            public boolean hasMoreElements() {
                return this.val$ri.hasNext();
            }

            public Object nextElement() {
                return this.val$ri.next();
            }
        };
    }

    protected void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public String toString() {
        return super.toString() + (this.name != null ? "(" + this.name + ")" : "");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setExpand(boolean bl) {
        this.noExpand = !bl;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    protected String findLibrary(String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("os.arch").toLowerCase();
        String string4 = null;
        string4 = string2.startsWith("mac os x") ? "binlib/macosx/" : (string2.startsWith("windows") ? (string3.equals("x86") ? "binlib/windows32/" : "binlib/windows64/") : (string3.equals("i386") ? "binlib/linux32/" : "binlib/linux64/"));
        this.VERBOSE("Using arch-specific native library path: " + string4);
        String string5 = this.findTheLibrary(string4, string);
        if (string5 != null) {
            this.VERBOSE("Found in arch-specific directory!");
            return string5;
        }
        this.VERBOSE("Search in standard native directory!");
        return this.findTheLibrary(BINLIB_PREFIX, string);
    }

    protected String findTheLibrary(String string, String string2) {
        String string3 = null;
        String string4 = string + System.mapLibraryName(string2);
        if (this.binLibPath.get(string4) != null) {
            string3 = (String)this.binLibPath.get(string4);
        } else {
            File file = null;
            FileOutputStream fileOutputStream = null;
            try {
                InputStream inputStream;
                int n = string4.lastIndexOf(46);
                String string5 = null;
                if (n >= 0) {
                    string5 = string4.substring(n);
                }
                if ((inputStream = this.getClass().getResourceAsStream("/" + string4)) != null) {
                    file = File.createTempFile(string2 + "-", string5);
                    file.deleteOnExit();
                    fileOutputStream = new FileOutputStream(file);
                    this.copy(inputStream, fileOutputStream);
                    fileOutputStream.close();
                    this.VERBOSE("Stored native library " + string2 + " at " + file);
                    string3 = file.getPath();
                    this.binLibPath.put(string4, string3);
                } else {
                    this.VERBOSE("No native library at " + string4 + "java.library.path will be searched instead.");
                }
            }
            catch (Throwable throwable) {
                this.WARNING("Unable to load native library: " + throwable);
            }
        }
        return string3;
    }

    protected String getConfirmation(File file) throws IOException {
        String string = "";
        while (string == null || !string.startsWith("n") && !string.startsWith("y") && !string.startsWith("q")) {
            this.promptForConfirm(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            string = bufferedReader.readLine();
            bufferedReader.close();
        }
        return string;
    }

    protected void promptForConfirm(File file) {
        this.PRINTLN("Do you want to allow '" + Boot.getMyJarName() + "' to expand files into the file-system at the following location?");
        this.PRINTLN("  " + file);
        this.PRINT("Answer y(es) to expand files, n(o) to continue without expanding, or q(uit) to exit: ");
    }

    static {
        String string = System.getProperty(JAVA_PROTOCOL_HANDLER);
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            string = "|" + string;
        }
        string = "com.simontuffs" + string;
        System.setProperty(JAVA_PROTOCOL_HANDLER, string);
        current = new ThreadLocal();
    }

    public static class OneJarURLFactory
    implements IURLFactory {
        @Override
        public URL getURL(String string, String string2) throws MalformedURLException {
            String string3 = string2.endsWith(JarClassLoader.CLASS) ? "" : string + "/";
            URL uRL = new URL(Handler.PROTOCOL + ":/" + string3 + string2);
            return uRL;
        }

        @Override
        public URL getCodeBase(String string) throws MalformedURLException {
            return new URL(Handler.PROTOCOL + ":" + string);
        }
    }

    public static class FileURLFactory
    implements IURLFactory {
        public URLStreamHandler jarHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL uRL) throws IOException {
                OneJarURLConnection oneJarURLConnection = new OneJarURLConnection(uRL);
                ((URLConnection)oneJarURLConnection).connect();
                return oneJarURLConnection;
            }
        };

        @Override
        public URL getURL(String string, String string2) throws MalformedURLException {
            string = !string.equals("/") ? string + "!/" : "";
            String string3 = "file:/" + Boot.getMyJarPath() + "!/" + string + string2;
            URL uRL = new URL("jar", "", -1, string3, this.jarHandler);
            return uRL;
        }

        @Override
        public URL getCodeBase(String string) throws MalformedURLException {
            ProtectionDomain protectionDomain = JarClassLoader.class.getProtectionDomain();
            URL uRL = protectionDomain.getCodeSource().getLocation();
            if (uRL != null) {
                uRL = new URL("jar", "", -1, uRL + "!/" + string, this.jarHandler);
            }
            return uRL;
        }
    }

    public static interface IURLFactory {
        public URL getURL(String var1, String var2) throws MalformedURLException;

        public URL getCodeBase(String var1) throws MalformedURLException;
    }

    protected static class ByteCode {
        public byte[] bytes;
        public String name;
        public String original;
        public String codebase;
        public Manifest manifest;

        public ByteCode(String string, String string2, ByteArrayOutputStream byteArrayOutputStream, String string3, Manifest manifest) {
            this.name = string;
            this.original = string2;
            this.bytes = byteArrayOutputStream.toByteArray();
            this.codebase = string3;
            this.manifest = manifest;
        }
    }
}

