/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.IProperties;
import com.simontuffs.onejar.JarClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Boot {
    public static final String BOOT_CLASS = "Boot-Class";
    public static final String ONE_JAR_CLASSLOADER = "One-Jar-Class-Loader";
    public static final String ONE_JAR_MAIN_CLASS = "One-Jar-Main-Class";
    public static final String ONE_JAR_DEFAULT_MAIN_JAR = "One-Jar-Default-Main-Jar";
    public static final String ONE_JAR_MAIN_ARGS = "One-Jar-Main-Args";
    public static final String ONE_JAR_URL_FACTORY = "One-Jar-URL-Factory";
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String MAIN_JAR = "main/main.jar";
    public static final String WRAP_CLASS_LOADER = "Wrap-Class-Loader";
    public static final String WRAP_DIR = "wrap";
    public static final String WRAP_JAR = "/wrap/wraploader.jar";
    public static final String PROPERTY_PREFIX = "one-jar.";
    public static final String P_MAIN_CLASS = "one-jar.main.class";
    public static final String P_MAIN_JAR = "one-jar.main.jar";
    public static final String P_MAIN_APP = "one-jar.main.app";
    public static final String P_RECORD = "one-jar.record";
    public static final String P_JARNAMES = "one-jar.jar.names";
    public static final String P_VERBOSE = "one-jar.verbose";
    public static final String P_INFO = "one-jar.info";
    public static final String P_WARNING = "one-jar.warning";
    public static final String P_STATISTICS = "one-jar.statistics";
    public static final String P_SHOW_PROPERTIES = "one-jar.show.properties";
    public static final String P_JARPATH = "one-jar.jar.path";
    public static final String P_ONE_JAR_CLASS_PATH = "one-jar.class.path";
    public static final String P_JAVA_CLASS_PATH = "java.class.path";
    public static final String P_PATH_SEPARATOR = "|";
    public static final String P_EXPAND_DIR = "one-jar.expand.dir";
    public static final String A_HELP = "--one-jar-help";
    public static final String A_VERSION = "--one-jar-version";
    public static final String[] HELP_PROPERTIES = new String[]{"one-jar.main.class", "Specifies the name of the class which should be executed \n(via public static void main(String[])", "one-jar.main.app", "Specifies the name of the main/<app>.jar to be executed", "one-jar.record", "true:  Enables recording of the classes loaded by the application", "one-jar.jar.names", "true:  Recorded classes are kept in directories corresponding to their jar names.\nfalse: Recorded classes are flattened into a single directory.  \nDuplicates are ignored (first wins)", "one-jar.verbose", "true:  Print verbose classloading information", "one-jar.info", "true:  Print informative classloading information", "one-jar.warning", "true:  Print serious classloading warnings", "one-jar.statistics", "true:  Shows statistics about the One-Jar Classloader", "one-jar.jar.path", "Full path of the one-jar file being executed.  \nOnly needed if java.class.path does not contain the path to the jar, e.g. on Max OS/X.", "one-jar.class.path", "Extra classpaths to be added to the execution environment.  \nUse platform independent path separator '|'", "one-jar.expand.dir", "Directory to use for expanded files.", "one-jar.show.properties", "true:  Shows the JVM system properties."};
    public static final String[] HELP_ARGUMENTS = new String[]{"--one-jar-help", "Shows this message, then exits.", "--one-jar-version", "Shows the version of One-JAR, then exits."};
    protected static String mainJar;
    protected static boolean warning;
    protected static boolean info;
    protected static boolean verbose;
    protected static boolean statistics;
    protected static String myJarPath;
    protected static long startTime;
    protected static long endTime;
    private static JarClassLoader loader;

    public static synchronized JarClassLoader getClassLoader() {
        return loader;
    }

    public static synchronized void setClassLoader(JarClassLoader jarClassLoader) {
        if (loader != null) {
            throw new RuntimeException("Attempt to set a second Boot loader");
        }
        loader = jarClassLoader;
    }

    protected static void VERBOSE(String string) {
        if (verbose) {
            System.out.println("Boot: " + string);
        }
    }

    protected static void WARNING(String string) {
        System.err.println("Boot: Warning: " + string);
    }

    protected static void INFO(String string) {
        if (info) {
            System.out.println("Boot: Info: " + string);
        }
    }

    protected static void PRINTLN(String string) {
        System.out.println("Boot: " + string);
    }

    public static void main(String[] stringArray) throws Exception {
        Boot.run(stringArray);
    }

    public static void run(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        URL uRL;
        Object object3;
        Object object4;
        String string;
        String string2;
        stringArray = Boot.processArgs(stringArray);
        String string3 = null;
        Object object5 = new Properties();
        Object object6 = "one-jar.properties";
        InputStream inputStream = Boot.class.getResourceAsStream("/" + (String)object6);
        if (inputStream != null) {
            Boot.INFO("loading properties from " + (String)object6);
            ((Properties)object5).load(inputStream);
        }
        if (new File((String)object6).exists() && (inputStream = new FileInputStream((String)object6)) != null) {
            Boot.INFO("merging properties from " + (String)object6);
            ((Properties)object5).load(inputStream);
        }
        Object object7 = ((Properties)object5).propertyNames();
        while (object7.hasMoreElements()) {
            string2 = (String)object7.nextElement();
            if (System.getProperty(string2) != null) continue;
            System.setProperty(string2, ((Properties)object5).getProperty(string2));
        }
        if (Boolean.valueOf(System.getProperty(P_SHOW_PROPERTIES, "false")).booleanValue()) {
            object5 = System.getProperties();
            object6 = ((Properties)object5).keySet().toArray(new String[0]);
            Arrays.sort((Object[])object6);
            for (int i = 0; i < ((Object)object6).length; ++i) {
                object7 = object6[i];
                System.out.println((String)object7 + "=" + ((Properties)object5).get(object7));
            }
        }
        if (string3 == null) {
            string3 = System.getProperty(P_MAIN_CLASS);
        }
        if (mainJar == null) {
            object5 = System.getProperty(P_MAIN_APP);
            mainJar = object5 != null ? "main/" + (String)object5 + ".jar" : System.getProperty(P_MAIN_JAR, MAIN_JAR);
        }
        object5 = Boot.getMyJarPath();
        object6 = new JarFile((String)object5);
        Manifest manifest = ((JarFile)object6).getManifest();
        object7 = manifest.getMainAttributes();
        string2 = ((Attributes)object7).getValue(ONE_JAR_CLASSLOADER);
        if (mainJar == null) {
            mainJar = ((Attributes)object7).getValue(ONE_JAR_DEFAULT_MAIN_JAR);
        }
        if ((string = ((Attributes)object7).getValue(ONE_JAR_MAIN_ARGS)) != null && stringArray.length == 0) {
            stringArray = string.split("[^\\\\]\\s");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].replaceAll("\\\\(\\s)", "$1");
            }
        }
        if (string3 == null && (string3 = ((Attributes)object7).getValue(ONE_JAR_MAIN_CLASS)) == null && (string3 = ((Attributes)object7).getValue(BOOT_CLASS)) != null) {
            Boot.WARNING("The manifest attribute Boot-Class is deprecated in favor of the attribute One-Jar-Main-Class");
        }
        if (string3 == null) {
            InputStream inputStream2 = Boot.class.getResourceAsStream("/" + mainJar);
            if (inputStream2 != null) {
                object4 = new JarInputStream(inputStream2);
                object3 = ((JarInputStream)object4).getManifest();
                ((ZipInputStream)object4).close();
                string3 = ((Manifest)object3).getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            } else if (!"".equals(mainJar)) {
                Boot.INFO("Unable to locate main jar '" + mainJar + "' in the JAR file " + Boot.getMyJarPath());
            }
        }
        if ((uRL = Boot.class.getResource(WRAP_JAR)) != null) {
            object4 = Boot.getBootLoader(string2);
            ((JarClassLoader)object4).load(null);
            object3 = Boot.class.getResourceAsStream(WRAP_JAR);
            if (object3 != null) {
                object2 = new JarInputStream((InputStream)object3);
                object = ((JarInputStream)object2).getManifest().getMainAttributes().getValue(WRAP_CLASS_LOADER);
                ((ZipInputStream)object2).close();
                if (object == null) {
                    Boot.WARNING(uRL + " did not contain a " + WRAP_CLASS_LOADER + " attribute, unable to load wrapping classloader");
                } else {
                    Boot.INFO("using " + (String)object);
                    JarClassLoader jarClassLoader = Boot.getWrapLoader((ClassLoader)object4, (String)object);
                    if (jarClassLoader == null) {
                        Boot.WARNING("Unable to instantiate " + (String)object + " from " + WRAP_DIR + ": using default JarClassLoader");
                        jarClassLoader = Boot.getBootLoader(null);
                    }
                    Boot.setClassLoader(jarClassLoader);
                }
            }
        } else {
            Boot.setClassLoader(Boot.getBootLoader(string2, Boot.class.getClassLoader()));
            Boot.INFO("using JarClassLoader: " + Boot.getClassLoader().getClass().getName());
        }
        object4 = ((Attributes)object7).getValue(ONE_JAR_URL_FACTORY);
        if (object4 != null) {
            loader.setURLFactory((String)object4);
        }
        if ((string3 = loader.load(string3)) == null && !loader.isExpanded()) {
            throw new Exception(Boot.getMyJarName() + " main class was not found (fix: add main/main.jar with a Main-Class manifest attribute, or specify -D" + P_MAIN_CLASS + "=<your.class.name>), or use " + ONE_JAR_MAIN_CLASS + " in the manifest");
        }
        if (string3 != null) {
            object3 = Boot.class.getName();
            if (((String)object3).equals(string3)) {
                throw new Exception(Boot.getMyJarName() + " main class (" + string3 + ") would cause infinite recursion: check main.jar/META-INF/MANIFEST.MF/Main-Class attribute: " + string3);
            }
            object2 = loader.loadClass(string3);
            endTime = System.currentTimeMillis();
            Boot.showTime();
            object = ((Class)object2).getMethod("main", String[].class);
            ((Method)object).invoke(null, new Object[]{stringArray});
        }
    }

    public static void showTime() {
        long l = System.currentTimeMillis();
        if (statistics) {
            Boot.PRINTLN("Elapsed time: " + (l - startTime) + "ms");
        }
    }

    public static void setProperties(IProperties iProperties) {
        Boot.INFO("setProperties(" + iProperties + ")");
        if (Boot.getProperty(P_RECORD, "false")) {
            iProperties.setRecord(true);
            iProperties.setRecording(System.getProperty(P_RECORD));
        }
        if (Boot.getProperty(P_JARNAMES, "false")) {
            iProperties.setRecord(true);
            iProperties.setFlatten(false);
        }
        if (verbose = Boot.getProperty(P_VERBOSE, "false")) {
            iProperties.setVerbose(true);
            iProperties.setInfo(true);
        }
        info = Boot.getProperty(P_INFO, "false");
        iProperties.setInfo(info);
        warning = Boot.getProperty(P_WARNING, "true");
        iProperties.setWarning(warning);
        statistics = Boot.getProperty(P_STATISTICS, "false");
    }

    public static boolean getProperty(String string, String string2) {
        return Boolean.valueOf(System.getProperty(string, "false"));
    }

    public static String getMyJarName() {
        String string = Boot.getMyJarPath();
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getMyJarPath() {
        if (myJarPath != null) {
            return myJarPath;
        }
        myJarPath = System.getProperty(P_JARPATH);
        if (myJarPath == null) {
            try {
                String string = System.getProperty(P_JAVA_CLASS_PATH);
                String[] stringArray = string.split(System.getProperty("path.separator"));
                for (int i = 0; i < stringArray.length; ++i) {
                    string = stringArray[i];
                    Boot.VERBOSE("Checking " + string + " as One-Jar file");
                    InputStream inputStream = null;
                    try {
                        inputStream = new URL(string).openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            inputStream = new FileInputStream(string);
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                    }
                    ZipEntry zipEntry = Boot.findJarEntry(new JarInputStream(inputStream), Boot.class.getName().replace('.', '/') + ".class");
                    if (zipEntry != null) {
                        myJarPath = string;
                    } else {
                        zipEntry = Boot.findZipEntry(new ZipFile(string), Boot.class.getName().replace('.', '/') + ".class");
                        if (zipEntry == null) continue;
                        myJarPath = string;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Boot.WARNING("jar=" + myJarPath + " loaded from " + P_JAVA_CLASS_PATH + " (" + System.getProperty(P_JAVA_CLASS_PATH) + ")");
            }
        }
        if (myJarPath == null) {
            throw new IllegalArgumentException("Unable to locate " + Boot.class.getName() + " in the java.class.path: consider using -D" + P_JARPATH + " to specify the one-jar filename.");
        }
        myJarPath = myJarPath.replace('\\', '/');
        return myJarPath;
    }

    public static JarEntry findJarEntry(JarInputStream jarInputStream, String string) throws IOException {
        JarEntry jarEntry;
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            if (!jarEntry.getName().equals(string)) continue;
            return jarEntry;
        }
        return null;
    }

    public static ZipEntry findZipEntry(ZipFile zipFile, String string) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            Boot.VERBOSE("findZipEntry(): entry=" + zipEntry.getName());
            if (!zipEntry.getName().equals(string)) continue;
            return zipEntry;
        }
        return null;
    }

    public static int firstWidth(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].length() <= n) continue;
            n = stringArray[i].length();
        }
        return n;
    }

    public static String pad(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        for (int i = 0; i < n - string2.length(); ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String wrap(String string, String string2, int n) {
        String string3 = Boot.pad(string, "", n);
        string2 = string2.replaceAll("\n", "\n" + string3);
        return string2;
    }

    public static String[] processArgs(String[] stringArray) throws Exception {
        Boot.VERBOSE("processArgs(" + Arrays.asList(stringArray) + ")");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith(A_HELP)) {
                int n;
                int n2 = Boot.firstWidth(HELP_ARGUMENTS);
                System.out.println("One-Jar uses the following command-line arguments");
                for (n = 0; n < HELP_ARGUMENTS.length; ++n) {
                    System.out.print(Boot.pad("    ", HELP_ARGUMENTS[n++], n2 + 1));
                    System.out.println(Boot.wrap("    ", HELP_ARGUMENTS[n], n2 + 1));
                }
                System.out.println();
                n2 = Boot.firstWidth(HELP_PROPERTIES);
                System.out.println("One-Jar uses the following VM properties (-D<property>=<true|false|string>)");
                for (n = 0; n < HELP_PROPERTIES.length; ++n) {
                    System.out.print(Boot.pad("    ", HELP_PROPERTIES[n++], n2 + 1));
                    System.out.println(Boot.wrap("    ", HELP_PROPERTIES[n], n2 + 1));
                }
                System.out.println();
                System.exit(0);
                continue;
            }
            if (string.startsWith(A_VERSION)) {
                InputStream inputStream = Boot.class.getResourceAsStream("/.version");
                if (inputStream != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String string2 = bufferedReader.readLine();
                    bufferedReader.close();
                    System.out.println("One-JAR version " + string2);
                } else {
                    System.out.println("Unable to determine One-JAR version (missing /.version resource in One-JAR archive)");
                }
                System.exit(0);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    protected static JarClassLoader getBootLoader(final String string) {
        JarClassLoader jarClassLoader = (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (string != null) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        Constructor<?> constructor = clazz.getConstructor(String.class);
                        return constructor.newInstance(Boot.WRAP_DIR);
                    }
                    catch (Exception exception) {
                        Boot.WARNING("Unable to instantiate " + string + ": " + exception + " continuing using default " + JarClassLoader.class.getName());
                    }
                }
                return new JarClassLoader(Boot.WRAP_DIR);
            }
        });
        return jarClassLoader;
    }

    protected static JarClassLoader getBootLoader(final String string, ClassLoader classLoader) {
        return (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (string != null) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        Constructor<?> constructor = clazz.getConstructor(ClassLoader.class);
                        return constructor.newInstance(Boot.class.getClassLoader());
                    }
                    catch (Exception exception) {
                        Boot.WARNING("Unable to instantiate " + string + ": " + exception + " continuing using default " + JarClassLoader.class.getName());
                    }
                }
                return new JarClassLoader(Boot.class.getClassLoader());
            }
        });
    }

    protected static JarClassLoader getWrapLoader(final ClassLoader classLoader, final String string) {
        return (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Constructor<?> constructor = clazz.getConstructor(ClassLoader.class);
                    return constructor.newInstance(classLoader);
                }
                catch (Throwable throwable) {
                    Boot.WARNING(throwable.toString());
                    return null;
                }
            }
        });
    }

    public static long getEndTime() {
        return endTime;
    }

    public static long getStartTime() {
        return startTime;
    }

    static {
        warning = true;
        startTime = System.currentTimeMillis();
        endTime = 0L;
        loader = null;
    }
}

