(ns donut.endpoint.route-writer
  "Writes route data to a known location for sharing between backend and frontend"
  (:require
   [clojure.java.io :as io]
   [clojure.pprint :as pp]
   [clojure.walk :as walk]
   [donut.system :as ds]))


(def PREAMBLE
  "(ns donut.generated.endpoint-routes
  \"do not modify this! this is auto-generated by donut. it contains backend routes for the frontend to read.\")

")

(defn defroutes-str
  [routes allowed-keys]
  (str PREAMBLE
       "(def routes
"
       (-> (walk/postwalk (fn [x]
                            (if (map? x)
                              (select-keys x allowed-keys)
                              x))
                          routes)
           pp/pprint
           with-out-str)
       ")"))

(def RouteWriterComponent
  {::ds/start (fn [{:keys [::ds/config]}]
                (let [{:keys [routes allowed-keys path]} config]
                  (io/make-parents path)
                  (spit path (defroutes-str routes allowed-keys))))
   ::ds/config {:allowed-keys #{:name :ent-type :id-key}
                :routes (ds/ref [:routing :routes])
                :path "src/donut/generated/endpoint_routes.cljc"}})
