(ns donut.endpoint.route-writer
  "Writes route data to a known location for sharing between backend and frontend"
  (:require
   [clojure.java.io :as io]
   [clojure.pprint :as pp]
   [clojure.walk :as walk]
   [donut.system :as ds]))

(def RouteWriterComponent
  {::ds/start (fn [{:keys [::ds/config]}]
                (let [{:keys [routes allowed-keys]} config]
                  (io/make-parents "src/donut/generated/endpoint_routes.cljc")
                  (spit "src/donut/generated/endpoint_routes.cljc"
                        (str "(ns donut.generated.endpoint-routes
  \"do not modify this! this is auto-generated by donut. it contains backend routes for the frontend to read.\")

(def routes
"
                             (with-out-str
                               (pp/pprint
                                (walk/postwalk (fn [x]
                                                 (if (map? x)
                                                   (select-keys x allowed-keys)
                                                   x))
                                               routes)))
                             ")"))))
   ::ds/config {:allowed-keys #{:name :ent-type :id-key}
                :routes (ds/ref [:routing :routes])}})
