(ns {{ns-name}}.web
  "Parse webapp

https://parse.com/docs/cloud_code_guide#webapp
"
  (:require [{{ns-name}}.domain :refer [Widget all-widgets]]
            [parseapp-cljs.web :refer [static render]]
            parseapp-cljs.async
            parseapp-cljs.express)
  (:require-macros [parseapp-cljs.async-macros :refer [<?]]
                   [cljs.core.async.macros :refer [go]]
                   [parseapp-cljs.express-macros :refer [defexpress]]))

(def express (js/require "express"))
(def app (express))


(defexpress {:views "cloud/views"
             :view-engine "jade"
             :body-parser true
             :static ["terms"]}
  (.get "/widgets"
        (fn [request response]
          (go
           (let [widgets (map #(.get % "name") (<? (all-widgets)))]
             (render response "widgets" {:widgets widgets}))))))
