/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.dynamap.java;

import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import palisades.lakes.dynafun.java.Signature2;
import palisades.lakes.dynafun.java.Signature3;
import palisades.lakes.dynafun.java.SignatureN;

public final class DynaFun
implements IFn {
    private final String name;
    private final Map<Object, IFn> methodTable;
    private final Map<Object, Set> preferTable;
    private volatile Map<Object, IFn> methodCache;

    private DynaFun(String n, Map mTable, Map pTable) {
        assert (null != n && !n.isEmpty());
        this.name = n;
        this.methodTable = mTable;
        this.preferTable = pTable;
        this.methodCache = new HashMap<Object, IFn>(mTable);
    }

    public static final DynaFun empty(String name) {
        return new DynaFun(name, Collections.emptyMap(), Collections.emptyMap());
    }

    private static final Map assoc(Map m, Object k, Object v) {
        HashMap<Object, Object> b = new HashMap<Object, Object>(m);
        b.put(k, v);
        return b;
    }

    private static final Set add(Set s, Object v) {
        if (null == s) {
            return Collections.singleton(v);
        }
        HashSet<Object> b = new HashSet<Object>(s);
        b.add(v);
        return b;
    }

    private static final Map add(Map m, Object k, Object v) {
        HashMap<Object, Set> b = new HashMap<Object, Set>(m);
        b.put(k, DynaFun.add((Set)b.get(k), v));
        return b;
    }

    public final DynaFun addMethod(Object signature2, IFn method) {
        return new DynaFun(this.name, DynaFun.assoc(this.methodTable, signature2, method), this.preferTable);
    }

    private static final boolean isAssignableFrom(Class[] c0, Class[] c1) {
        if (c0.length != c1.length) {
            return false;
        }
        for (int i = 0; i < c0.length; ++i) {
            if (c0[i].isAssignableFrom(c1[i])) continue;
            return false;
        }
        return true;
    }

    private static final boolean isAssignableFrom(Object s0, Object s1) {
        if (s0 instanceof Class && s1 instanceof Class) {
            return ((Class)s0).isAssignableFrom((Class)s1);
        }
        if (s0 instanceof Class[] && s1 instanceof Class[]) {
            return DynaFun.isAssignableFrom((Class[])s0, (Class[])s1);
        }
        if (s0 instanceof Signature2 && s1 instanceof Signature2) {
            return ((Signature2)s0).isAssignableFrom((Signature2)s1);
        }
        if (s0 instanceof Signature3 && s1 instanceof Signature3) {
            return ((Signature3)s0).isAssignableFrom((Signature3)s1);
        }
        if (s0 instanceof Class && s1 instanceof Class) {
            return ((Class)s0).isAssignableFrom((Class)s1);
        }
        if (s0 instanceof SignatureN && s1 instanceof SignatureN) {
            return ((SignatureN)s0).isAssignableFrom((SignatureN)s1);
        }
        return false;
    }

    private final boolean prefers(Object x, Object y) {
        Set xprefs = this.preferTable.get(x);
        if (xprefs != null) {
            if (xprefs.contains(y)) {
                return true;
            }
            for (Object xx : xprefs) {
                if (!this.prefers(xx, y)) continue;
                return true;
            }
        }
        for (Object k : this.preferTable.keySet()) {
            if (x.equals(k) || !DynaFun.isAssignableFrom(k, x) || !this.prefers(k, y)) continue;
            return true;
        }
        return false;
    }

    public final DynaFun preferMethod(Object x, Object y) {
        if (this.prefers(y, x)) {
            throw new IllegalStateException(String.format("Preference conflict in multimethod '%s':%s is already preferred to %s", this.name, y, x));
        }
        return new DynaFun(this.name, this.methodTable, DynaFun.add(this.preferTable, x, y));
    }

    private final boolean dominates(Object x, Object y) {
        return this.prefers(x, y) || DynaFun.isAssignableFrom(y, x);
    }

    private final IFn findAndCacheBestMethod(Object signature2) {
        Map.Entry<Object, IFn> bestEntry = null;
        for (Map.Entry<Object, IFn> o : this.methodTable.entrySet()) {
            Map.Entry<Object, IFn> e = o;
            if (!DynaFun.isAssignableFrom(e.getKey(), signature2)) continue;
            if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                bestEntry = e;
            }
            if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
            throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match signature value: %s -> %s and %s, and neither is preferred", this.name, signature2, e.getKey(), bestEntry.getKey()));
        }
        if (null == bestEntry) {
            return null;
        }
        IFn method = (IFn)bestEntry.getValue();
        this.methodCache = DynaFun.assoc(this.methodCache, signature2, method);
        return method;
    }

    private final IFn getMethod(Object signature2) {
        IFn cached = this.methodCache.get(signature2);
        if (null != cached) {
            return cached;
        }
        IFn method = this.findAndCacheBestMethod(signature2);
        if (method == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for signature: %s", this.name, signature2));
        }
        return method;
    }

    public final Object invoke() {
        return this.getMethod(null).invoke();
    }

    public final Object invoke(Object arg1) {
        Class<?> k = arg1.getClass();
        IFn f = this.getMethod(k);
        return f.invoke(arg1);
    }

    public final Object invoke(Object arg1, Object arg2) {
        Signature2 k = new Signature2(arg1.getClass(), arg2.getClass());
        IFn f = this.getMethod(k);
        return f.invoke(arg1, arg2);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3) {
        Signature3 k = new Signature3(arg1.getClass(), arg2.getClass(), arg3.getClass());
        IFn f = this.getMethod(k);
        return f.invoke(arg1, arg2, arg3);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4})).invoke(arg1, arg2, arg3, arg4);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5})).invoke(arg1, arg2, arg3, arg4, arg5);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6})).invoke(arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20);
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) {
        return this.getMethod(SignatureN.extract((Object[])new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args})).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args);
    }

    public final Object call() throws Exception {
        return this.invoke();
    }

    public final void run() {
        this.invoke();
    }

    public final Object applyTo(ISeq args) {
        return AFn.applyToHelper((IFn)this, (ISeq)args);
    }
}

