/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.dynest.java;

import clojure.lang.IFn;
import clojure.lang.ISeq;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import palisades.lakes.dynafun.java.Signature2;
import palisades.lakes.dynafun.java.Signature3;
import palisades.lakes.dynafun.java.Signatures;
import palisades.lakes.dynest.java.MethodCache1;
import palisades.lakes.dynest.java.MethodCache2;
import palisades.lakes.dynest.java.MethodCache3;
import palisades.lakes.dynest.java.Util;

public final class DynaFun
implements IFn {
    private final String name;
    private final Map<Class, IFn> methodTable;
    private final Map<Class, Set> preferTable;
    private volatile MethodCache1 cache1;
    private volatile MethodCache2 cache2;
    private volatile MethodCache3 cache3;

    private DynaFun(String n, Map mTable, Map pTable) {
        assert (null != n && !n.isEmpty());
        this.name = n;
        this.methodTable = mTable;
        this.preferTable = pTable;
        this.cache1 = MethodCache1.empty();
        this.cache2 = MethodCache2.empty();
        this.cache3 = MethodCache3.empty();
    }

    public static final DynaFun empty(String name2) {
        return new DynaFun(name2, Collections.emptyMap(), Collections.emptyMap());
    }

    public final DynaFun addMethod(Object signature2, IFn method) {
        return new DynaFun(this.name, Util.assoc(this.methodTable, signature2, method), this.preferTable);
    }

    private final boolean prefers(Object x, Object y) {
        Set xprefs = this.preferTable.get(x);
        if (xprefs != null) {
            if (xprefs.contains(y)) {
                return true;
            }
            for (Class<Object> clazz : xprefs) {
                if (!this.prefers(clazz, y)) continue;
                return true;
            }
        }
        for (Class<Object> clazz : this.preferTable.keySet()) {
            if (x.equals(clazz) || !Signatures.isAssignableFrom(clazz, (Object)x) || !this.prefers(clazz, y)) continue;
            return true;
        }
        return false;
    }

    public final DynaFun preferMethod(Object x, Object y) {
        if (this.prefers(y, x)) {
            throw new IllegalStateException(String.format("Preference conflict in multimethod '%s':%s is already preferred to %s", this.name, y, x));
        }
        return new DynaFun(this.name, this.methodTable, Util.add(this.preferTable, x, y));
    }

    private final boolean dominates(Object x, Object y) {
        return this.prefers(x, y) || Signatures.isAssignableFrom((Object)y, (Object)x);
    }

    private final IFn findAndCacheBestMethod(Class k) {
        Map.Entry<Class, IFn> bestEntry = null;
        for (Map.Entry<Class, IFn> o : this.methodTable.entrySet()) {
            Map.Entry<Class, IFn> e = o;
            if (!Signatures.isAssignableFrom((Object)e.getKey(), (Object)k)) continue;
            if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                bestEntry = e;
            }
            if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
            throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match signature value: %s -> %s and %s, and neither is preferred", this.name, k, e.getKey(), bestEntry.getKey()));
        }
        if (null == bestEntry) {
            return null;
        }
        IFn method = (IFn)bestEntry.getValue();
        this.cache1 = this.cache1.assoc(k, method);
        return method;
    }

    private final IFn getMethod(Class k) {
        IFn cached = this.cache1.get(k);
        if (null != cached) {
            return cached;
        }
        IFn method = this.findAndCacheBestMethod(k);
        if (method == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for signature: %s", this.name, k));
        }
        return method;
    }

    private final IFn findAndCacheBestMethod(Class k0, Class k1) {
        Signature2 k = new Signature2(k0, k1);
        Map.Entry<Class, IFn> bestEntry = null;
        for (Map.Entry<Class, IFn> o : this.methodTable.entrySet()) {
            Map.Entry<Class, IFn> e = o;
            if (!Signatures.isAssignableFrom((Object)e.getKey(), (Object)k)) continue;
            if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                bestEntry = e;
            }
            if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
            throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match signature value: %s -> %s and %s, and neither is preferred", this.name, k, e.getKey(), bestEntry.getKey()));
        }
        if (null == bestEntry) {
            return null;
        }
        IFn method = (IFn)bestEntry.getValue();
        this.cache2 = this.cache2.assoc(k0, k1, method);
        return method;
    }

    private final IFn getMethod(Class k0, Class k1) {
        IFn cached = this.cache2.get(k0, k1);
        if (null != cached) {
            return cached;
        }
        IFn method = this.findAndCacheBestMethod(k0, k1);
        if (method == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for: %s, %s", this.name, k0, k1));
        }
        return method;
    }

    private final IFn findAndCacheBestMethod(Class k0, Class k1, Class k2) {
        Signature3 k = new Signature3(k0, k1, k2);
        Map.Entry<Class, IFn> bestEntry = null;
        for (Map.Entry<Class, IFn> o : this.methodTable.entrySet()) {
            Map.Entry<Class, IFn> e = o;
            if (!Signatures.isAssignableFrom((Object)e.getKey(), (Object)k)) continue;
            if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                bestEntry = e;
            }
            if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
            throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match signature value: %s -> %s and %s, and neither is preferred", this.name, k, e.getKey(), bestEntry.getKey()));
        }
        if (null == bestEntry) {
            return null;
        }
        IFn method = (IFn)bestEntry.getValue();
        this.cache3 = this.cache3.assoc(k0, k1, k2, method);
        return method;
    }

    private final IFn getMethod(Class k0, Class k1, Class k2) {
        IFn cached = this.cache3.get(k0, k1, k2);
        if (null != cached) {
            return cached;
        }
        IFn method = this.findAndCacheBestMethod(k0, k1, k2);
        if (method == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for: %s, %s, %s", this.name, k0, k1, k2));
        }
        return method;
    }

    private final UnsupportedOperationException illegalArity(int i) {
        return new UnsupportedOperationException(this.getClass().getSimpleName() + " can't handle " + i + " operands");
    }

    public final Object invoke() {
        throw this.illegalArity(0);
    }

    public final Object invoke(Object x) {
        return this.getMethod(x.getClass()).invoke(x);
    }

    public final Object invoke(Object x0, Object x1) {
        return this.getMethod(x0.getClass(), x1.getClass()).invoke(x0, x1);
    }

    public final Object invoke(Object x0, Object x1, Object x2) {
        return this.getMethod(x0.getClass(), x1.getClass(), x2.getClass()).invoke(x0, x1, x2);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3) {
        throw this.illegalArity(4);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4) {
        throw this.illegalArity(5);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5) {
        throw this.illegalArity(6);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6) {
        throw this.illegalArity(7);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7) {
        throw this.illegalArity(8);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8) {
        throw this.illegalArity(9);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9) {
        throw this.illegalArity(10);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10) {
        throw this.illegalArity(11);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11) {
        throw this.illegalArity(12);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12) {
        throw this.illegalArity(13);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13) {
        throw this.illegalArity(14);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14) {
        throw this.illegalArity(15);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15) {
        throw this.illegalArity(16);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16) {
        throw this.illegalArity(17);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16, Object x17) {
        throw this.illegalArity(18);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16, Object x17, Object x18) {
        throw this.illegalArity(19);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16, Object x17, Object x18, Object x19) {
        throw this.illegalArity(20);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16, Object x17, Object x18, Object x19, Object ... xs) {
        throw this.illegalArity(20 + xs.length);
    }

    public final Object call() throws Exception {
        throw this.illegalArity(0);
    }

    public final void run() {
        throw this.illegalArity(0);
    }

    public final Object applyTo(ISeq xs) {
        if (1 == xs.count()) {
            return this.invoke(xs.first());
        }
        throw this.illegalArity(xs.count());
    }
}

