/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.multimethods.java.signature;

import clojure.lang.ArraySeq;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import palisades.lakes.multimethods.java.signature.Signature;

public final class SignatureN
implements Signature {
    public final Class[] classes;

    public final boolean isAssignableFrom(SignatureN that) {
        Class[] those = that.classes;
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i].isAssignableFrom(those[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int size() {
        return this.classes.length;
    }

    @Override
    public final boolean isAssignableFrom(Signature that) {
        if (that instanceof SignatureN) {
            return this.isAssignableFrom((SignatureN)that);
        }
        return false;
    }

    @Override
    public final boolean isAssignableFrom(Class k) {
        return false;
    }

    @Override
    public final boolean isAssignableFrom(Class k0, Class k1) {
        return false;
    }

    @Override
    public final boolean isAssignableFrom(Class k0, Class k1, Class k2) {
        return false;
    }

    @Override
    public final boolean isAssignableFrom(Class ... ks) {
        if (this.classes.length != ks.length) {
            return false;
        }
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i].isAssignableFrom(ks[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equiv(Class k0, Class k1) {
        return false;
    }

    @Override
    public final boolean equiv(Class k0, Class k1, Class k2) {
        return false;
    }

    @Override
    public final boolean equiv(Class ... ks) {
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i].equals(ks[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int result = 17;
        for (Class c : this.classes) {
            result = 37 * result + c.hashCode();
        }
        return result;
    }

    @Override
    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof SignatureN) {
            return this.equiv(((SignatureN)that).classes);
        }
        return false;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder("(");
        builder.append(this.getClass().getSimpleName());
        builder.append(". ");
        for (Class c : this.classes) {
            builder.append(c.getName());
            builder.append(" ");
        }
        builder.append(")");
        return builder.toString();
    }

    public SignatureN(Class ... ks) {
        assert (ks.length > 3);
        this.classes = ks;
    }

    public SignatureN(Class c0, Class c1, Class c2, ArraySeq as) {
        Object[] cs = as.array;
        int n = cs.length + 3;
        assert (n > 3);
        this.classes = new Class[n];
        this.classes[0] = c0;
        this.classes[1] = c1;
        this.classes[2] = c2;
        int i = 3;
        int j = 0;
        while (i < n) {
            this.classes[i] = (Class)cs[j];
            ++i;
            ++j;
        }
    }

    public static final SignatureN get(Class ... ks) {
        return new SignatureN(ks);
    }

    public static final SignatureN get(Class k0, Class k1, List ks) {
        Class[] classes = new Class[2 + ks.size()];
        classes[0] = k0;
        classes[1] = k1;
        int i = 2;
        for (Object k : ks) {
            classes[i++] = (Class)k;
        }
        return new SignatureN(classes);
    }

    public static final SignatureN extract(Object ... xs) {
        int n = xs.length;
        assert (n > 3);
        Class[] ks = new Class[n];
        for (int i = 0; i < n; ++i) {
            ks[i] = xs[i].getClass();
        }
        return new SignatureN(ks);
    }

    public static final SignatureN extract(Object x0, Object x1, Object x2, ArraySeq as) {
        Object[] xs = as.array;
        int n = xs.length + 3;
        assert (n > 3);
        Class[] cs = new Class[n];
        cs[0] = x0.getClass();
        cs[1] = x1.getClass();
        cs[2] = x2.getClass();
        int i = 3;
        int j = 0;
        while (i < n) {
            cs[i] = xs[j].getClass();
            ++i;
            ++j;
        }
        return new SignatureN(cs);
    }

    @Override
    public boolean add(Object arg0) {
        throw new UnsupportedOperationException("add unsupported for " + this.getClass());
    }

    public void add(int arg0, Object arg1) {
        throw new UnsupportedOperationException("add unsupported for " + this.getClass());
    }

    @Override
    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException("addAll unsupported for " + this.getClass());
    }

    public boolean addAll(int arg0, Collection arg1) {
        throw new UnsupportedOperationException("addAll unsupported for " + this.getClass());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear unsupported for " + this.getClass());
    }

    @Override
    public boolean contains(Object arg0) {
        return Arrays.asList(this.classes).contains(arg0);
    }

    @Override
    public boolean containsAll(Collection arg0) {
        return Arrays.asList(this.classes).containsAll(arg0);
    }

    public Object get(int arg0) {
        return this.classes[arg0];
    }

    @Override
    public int indexOf(Object arg0) {
        return Arrays.asList(this.classes).indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator iterator() {
        return Arrays.asList(this.classes).iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return Arrays.asList(this.classes).lastIndexOf(arg0);
    }

    public ListIterator listIterator() {
        return Arrays.asList(this.classes).listIterator();
    }

    public ListIterator listIterator(int arg0) {
        return Arrays.asList(this.classes).listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException("remove unsupported for " + this.getClass());
    }

    public Object remove(int arg0) {
        throw new UnsupportedOperationException("remove unsupported for " + this.getClass());
    }

    @Override
    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException("removeAll unsupported for " + this.getClass());
    }

    @Override
    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException("retainAll unsupported for " + this.getClass());
    }

    public Object set(int arg0, Object arg1) {
        throw new UnsupportedOperationException("set unsupported for " + this.getClass());
    }

    public List subList(int arg0, int arg1) {
        throw new UnsupportedOperationException("subList unsupported for " + this.getClass());
    }

    @Override
    public Object[] toArray() {
        return Arrays.asList(this.classes).toArray();
    }

    @Override
    public Object[] toArray(Object[] arg0) {
        return Arrays.asList(this.classes).toArray(arg0);
    }
}

