/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.dynafun.java;

import clojure.lang.IFn;
import java.util.Collections;
import java.util.Map;
import palisades.lakes.dynafun.java.Signature2;
import palisades.lakes.dynafun.java.Util;

public final class ClassCache2 {
    private final Class[] classes0;
    private final Class[][] classes1;
    private final IFn[][] methods;
    private final Map<Signature2, IFn> nonlinear;

    public final IFn get(Class c0, Class c1) {
        for (int i0 = 0; i0 < this.classes0.length; ++i0) {
            if (!c0.equals(this.classes0[i0])) continue;
            Class[] cs1 = this.classes1[i0];
            for (int i1 = 0; i1 < cs1.length; ++i1) {
                if (!c1.equals(cs1[i1])) continue;
                return this.methods[i0][i1];
            }
        }
        return this.nonlinear.get(new Signature2(c0, c1));
    }

    private ClassCache2(Class[] ks0, Class[][] ks1, IFn[][] ms, Map m) {
        this.classes0 = ks0;
        this.classes1 = ks1;
        this.methods = ms;
        this.nonlinear = m;
    }

    public static final ClassCache2 empty() {
        return new ClassCache2(new Class[0], new Class[0][], new IFn[0][], Collections.emptyMap());
    }

    private final int index(Class c0) {
        for (int i0 = 0; i0 < this.classes0.length; ++i0) {
            if (!c0.equals(this.classes0[i0])) continue;
            return i0;
        }
        return -1;
    }

    private final int index(int i0, Class c1) {
        Class[] cs1 = this.classes1[i0];
        for (int i1 = 0; i1 < cs1.length; ++i1) {
            if (!c1.equals(cs1[i1])) continue;
            return i1;
        }
        return -1;
    }

    private final ClassCache2 addCell(Class c0, Class c1) {
        return new ClassCache2(Util.append(this.classes0, c0), Util.append(this.classes1, new Class[]{c1}), Util.append(this.methods, new IFn[]{null}), this.nonlinear);
    }

    private final ClassCache2 addCell(int i0, Class c1) {
        return new ClassCache2(Util.copy(this.classes0), Util.append(this.classes1, i0, c1), Util.append(this.methods, i0, null), this.nonlinear);
    }

    private final ClassCache2 ensureCell(Class c0, Class c1) {
        int i0 = this.index(c0);
        if (0 > i0) {
            return this.addCell(c0, c1);
        }
        int i1 = this.index(i0, c1);
        if (0 > i1) {
            return this.addCell(i0, c1);
        }
        return this;
    }

    private final ClassCache2 set(Class c0, Class c1, IFn m) {
        int i0 = this.index(c0);
        assert (0 <= i0);
        int i1 = this.index(i0, c1);
        assert (0 <= i1);
        IFn[][] ms = Util.copy(this.methods);
        ms[i0][i1] = m;
        return new ClassCache2(Util.copy(this.classes0), Util.copy(this.classes1), ms, this.nonlinear);
    }

    public final ClassCache2 assoc(Class c0, Class c1, IFn m) {
        return this.ensureCell(c0, c1).set(c0, c1, m);
    }
}

