/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.dynafun.java;

import clojure.lang.IFn;
import java.util.Collections;
import java.util.Map;
import palisades.lakes.dynafun.java.Util;
import palisades.lakes.dynafun.java.signature.SignatureN;

public final class SignatureNCache {
    private final SignatureN[] signatures;
    private final IFn[] methods;
    private final Map<SignatureN, IFn> nonlinear;

    public final IFn get(SignatureN k) {
        for (int i = 0; i < this.signatures.length; ++i) {
            if (!k.equals(this.signatures[i])) continue;
            return this.methods[i];
        }
        return this.nonlinear.get(k);
    }

    private SignatureNCache(SignatureN[] ks, IFn[] vs, Map m) {
        this.signatures = ks;
        this.methods = vs;
        this.nonlinear = m;
    }

    public static final SignatureNCache empty() {
        return new SignatureNCache(new SignatureN[0], new IFn[0], Collections.emptyMap());
    }

    private final int index(SignatureN k) {
        for (int i = 0; i < this.signatures.length; ++i) {
            if (!k.equals(this.signatures[i])) continue;
            return i;
        }
        return -1;
    }

    private final SignatureNCache set(int i0, SignatureN c, IFn m) {
        SignatureN[] cs = Util.copy(this.signatures);
        IFn[] ms = Util.copy(this.methods);
        cs[i0] = c;
        ms[i0] = m;
        return new SignatureNCache(cs, ms, this.nonlinear);
    }

    public final SignatureNCache assoc(SignatureN k, IFn m) {
        int i0 = this.index(k);
        if (0 <= i0) {
            return this.set(i0, k, m);
        }
        return new SignatureNCache(Util.append(this.signatures, k), Util.append(this.methods, m), this.nonlinear);
    }
}

