/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.dynafun.java;

import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.PersistentArrayMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import palisades.lakes.dynafun.java.ClassCache1;
import palisades.lakes.dynafun.java.ClassCache2;
import palisades.lakes.dynafun.java.ClassCache3;
import palisades.lakes.dynafun.java.SignatureNCache;
import palisades.lakes.dynafun.java.Util;
import palisades.lakes.dynafun.java.signature.Signature2;
import palisades.lakes.dynafun.java.signature.Signature3;
import palisades.lakes.dynafun.java.signature.SignatureN;
import palisades.lakes.dynafun.java.signature.Signatures;

public final class DynaFun
implements IFn,
IObj {
    private final String _name;
    private final IPersistentMap _meta;
    private final Map<Class, IFn> methodTable;
    private final Map<Class, Set> preferTable;
    private volatile ClassCache1 cache1;
    private volatile ClassCache2 cache2;
    private volatile ClassCache3 cache3;
    private volatile SignatureNCache cacheN;

    private DynaFun(String n, IPersistentMap m, Map mTable, Map pTable) {
        assert (null != n && !n.isEmpty());
        this._name = n;
        this._meta = m;
        this.methodTable = mTable;
        this.preferTable = pTable;
        this.cache1 = ClassCache1.empty();
        this.cache2 = ClassCache2.empty();
        this.cache3 = ClassCache3.empty();
    }

    public static final DynaFun empty(String name) {
        return new DynaFun(name, (IPersistentMap)PersistentArrayMap.EMPTY, Collections.emptyMap(), Collections.emptyMap());
    }

    public final IPersistentMap meta() {
        return this._meta;
    }

    public final IObj withMeta(IPersistentMap m) {
        return new DynaFun(this._name, m, this.methodTable, this.preferTable);
    }

    public final DynaFun addMethod(Object signature2, IFn method) {
        return new DynaFun(this._name, this._meta, Util.assoc(this.methodTable, signature2, method), this.preferTable);
    }

    private final boolean prefers(Object x, Object y) {
        Set xprefs = this.preferTable.get(x);
        if (xprefs != null) {
            if (xprefs.contains(y)) {
                return true;
            }
            for (Class<Object> clazz : xprefs) {
                if (!this.prefers(clazz, y)) continue;
                return true;
            }
        }
        for (Class<Object> clazz : this.preferTable.keySet()) {
            if (x.equals(clazz) || !Signatures.isAssignableFrom(clazz, x) || !this.prefers(clazz, y)) continue;
            return true;
        }
        return false;
    }

    public final DynaFun preferMethod(Object x, Object y) {
        if (this.prefers(y, x)) {
            throw new IllegalStateException(String.format("Preference conflict in multimethod '%s':%s is already preferred to %s", this._name, y, x));
        }
        return new DynaFun(this._name, this._meta, this.methodTable, Util.add(this.preferTable, x, y));
    }

    private final boolean dominates(Object x, Object y) {
        return this.prefers(x, y) || Signatures.isAssignableFrom(y, x);
    }

    private final Set updateMinima(Map.Entry e0, Set<Map.Entry> minima) {
        boolean add = true;
        HashSet<Map.Entry> updated = new HashSet<Map.Entry>(minima.size());
        Object k0 = e0.getKey();
        for (Map.Entry e : minima) {
            Object k = e.getKey();
            if (this.dominates(k, k0)) {
                add = false;
            }
            if (this.dominates(k0, k)) continue;
            updated.add(e);
        }
        if (add) {
            updated.add(e0);
        }
        return updated;
    }

    private static final Map.Entry first(Set<Map.Entry> i) {
        return i.iterator().next();
    }

    private final IFn findAndCacheBestMethod(Class k) {
        Set minima = new HashSet<Map.Entry>();
        for (Map.Entry<Class, IFn> o : this.methodTable.entrySet()) {
            Map.Entry<Class, IFn> e = o;
            if (!Signatures.isAssignableFrom(e.getKey(), (Object)k)) continue;
            minima = this.updateMinima(e, minima);
        }
        if (minima.isEmpty()) {
            return null;
        }
        if (1 != minima.size()) {
            throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match dispatch value: %s -> %s, and none is preferred", this._name, k, minima));
        }
        IFn method = (IFn)DynaFun.first(minima).getValue();
        this.cache1 = this.cache1.assoc(k, method);
        return method;
    }

    private final IFn getMethod(Class k) {
        IFn cached = this.cache1.get(k);
        if (null != cached) {
            return cached;
        }
        IFn method = this.findAndCacheBestMethod(k);
        if (method == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for signature: %s", this._name, k));
        }
        return method;
    }

    private final IFn findAndCacheBestMethod(Class k0, Class k1) {
        Signature2 k = new Signature2(k0, k1);
        Map.Entry<Class, IFn> bestEntry = null;
        for (Map.Entry<Class, IFn> o : this.methodTable.entrySet()) {
            Map.Entry<Class, IFn> e = o;
            if (!Signatures.isAssignableFrom(e.getKey(), k)) continue;
            if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                bestEntry = e;
            }
            if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
            throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match signature value: %s -> %s and %s, and neither is preferred", this._name, k, e.getKey(), bestEntry.getKey()));
        }
        if (null == bestEntry) {
            return null;
        }
        IFn method = (IFn)bestEntry.getValue();
        this.cache2 = this.cache2.assoc(k0, k1, method);
        return method;
    }

    private final IFn getMethod(Class k0, Class k1) {
        IFn cached = this.cache2.get(k0, k1);
        if (null != cached) {
            return cached;
        }
        IFn method = this.findAndCacheBestMethod(k0, k1);
        if (method == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for: %s, %s", this._name, k0, k1));
        }
        return method;
    }

    private final IFn findAndCacheBestMethod(Class k0, Class k1, Class k2) {
        Signature3 k = new Signature3(k0, k1, k2);
        Map.Entry<Class, IFn> bestEntry = null;
        for (Map.Entry<Class, IFn> o : this.methodTable.entrySet()) {
            Map.Entry<Class, IFn> e = o;
            if (!Signatures.isAssignableFrom(e.getKey(), k)) continue;
            if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                bestEntry = e;
            }
            if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
            throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match signature value: %s -> %s and %s, and neither is preferred", this._name, k, e.getKey(), bestEntry.getKey()));
        }
        if (null == bestEntry) {
            return null;
        }
        IFn method = (IFn)bestEntry.getValue();
        this.cache3 = this.cache3.assoc(k0, k1, k2, method);
        return method;
    }

    private final IFn getMethod(Class k0, Class k1, Class k2) {
        IFn cached = this.cache3.get(k0, k1, k2);
        if (null != cached) {
            return cached;
        }
        IFn method = this.findAndCacheBestMethod(k0, k1, k2);
        if (method == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for: %s, %s, %s", this._name, k0, k1, k2));
        }
        return method;
    }

    private final IFn findAndCacheBestMethod(SignatureN k) {
        Map.Entry<Class, IFn> bestEntry = null;
        for (Map.Entry<Class, IFn> o : this.methodTable.entrySet()) {
            Map.Entry<Class, IFn> e = o;
            if (!Signatures.isAssignableFrom(e.getKey(), k)) continue;
            if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                bestEntry = e;
            }
            if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
            throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match signature value: %s -> %s and %s, and neither is preferred", this._name, k, e.getKey(), bestEntry.getKey()));
        }
        if (null == bestEntry) {
            return null;
        }
        IFn method = (IFn)bestEntry.getValue();
        this.cacheN = this.cacheN.assoc(k, method);
        return method;
    }

    private final IFn getMethod(SignatureN k) {
        IFn cached = this.cacheN.get(k);
        if (null != cached) {
            return cached;
        }
        IFn method = this.findAndCacheBestMethod(k);
        if (method == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for signature: %s", this._name, k));
        }
        return method;
    }

    private final UnsupportedOperationException illegalArity(int i) {
        return new UnsupportedOperationException(this.getClass().getSimpleName() + " can't handle " + i + " operands");
    }

    public final Object invoke() {
        throw this.illegalArity(0);
    }

    public final Object invoke(Object x) {
        return this.getMethod(x.getClass()).invoke(x);
    }

    public final Object invoke(Object x0, Object x1) {
        return this.getMethod(x0.getClass(), x1.getClass()).invoke(x0, x1);
    }

    public final Object invoke(Object x0, Object x1, Object x2) {
        return this.getMethod(x0.getClass(), x1.getClass(), x2.getClass()).invoke(x0, x1, x2);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3) {
        SignatureN k = new SignatureN(x0.getClass(), x1.getClass(), x2.getClass(), x3.getClass());
        return this.getMethod(k).invoke(x0, x1, x2, x3);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4) {
        throw this.illegalArity(5);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5) {
        throw this.illegalArity(6);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6) {
        throw this.illegalArity(7);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7) {
        throw this.illegalArity(8);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8) {
        throw this.illegalArity(9);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9) {
        throw this.illegalArity(10);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10) {
        throw this.illegalArity(11);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11) {
        throw this.illegalArity(12);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12) {
        throw this.illegalArity(13);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13) {
        throw this.illegalArity(14);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14) {
        throw this.illegalArity(15);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15) {
        throw this.illegalArity(16);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16) {
        throw this.illegalArity(17);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16, Object x17) {
        throw this.illegalArity(18);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16, Object x17, Object x18) {
        throw this.illegalArity(19);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16, Object x17, Object x18, Object x19) {
        throw this.illegalArity(20);
    }

    public final Object invoke(Object x0, Object x1, Object x2, Object x3, Object x4, Object x5, Object x6, Object x7, Object x8, Object x9, Object x10, Object x11, Object x12, Object x13, Object x14, Object x15, Object x16, Object x17, Object x18, Object x19, Object ... xs) {
        throw this.illegalArity(20 + xs.length);
    }

    public final Object call() throws Exception {
        throw this.illegalArity(0);
    }

    public final void run() {
        throw this.illegalArity(0);
    }

    public final Object applyTo(ISeq xs) {
        if (1 == xs.count()) {
            return this.invoke(xs.first());
        }
        throw this.illegalArity(xs.count());
    }
}

