/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.dynafun.java;

import clojure.lang.IFn;
import java.util.Collections;
import java.util.Map;
import palisades.lakes.dynafun.java.Util;
import palisades.lakes.dynafun.java.signature.Signature3;

public final class ClassCache3 {
    private final Class[] classes0;
    private final Class[][] classes1;
    private final Class[][][] classes2;
    private final IFn[][][] methods;
    private final Map<Signature3, IFn> nonlinear;

    public final IFn get(Class c0, Class c1, Class c2) {
        for (int i0 = 0; i0 < this.classes0.length; ++i0) {
            if (!c0.equals(this.classes0[i0])) continue;
            Class[] cs1 = this.classes1[i0];
            for (int i1 = 0; i1 < cs1.length; ++i1) {
                if (!c1.equals(cs1[i1])) continue;
                Class[] cs2 = this.classes2[i0][i1];
                for (int i2 = 0; i2 < cs2.length; ++i2) {
                    if (!c2.equals(cs2[i2])) continue;
                    return this.methods[i0][i1][i2];
                }
            }
        }
        return this.nonlinear.get(new Signature3(c0, c1, c2));
    }

    private ClassCache3(Class[] ks0, Class[][] ks1, Class[][][] ks2, IFn[][][] ms, Map m) {
        this.classes0 = ks0;
        this.classes1 = ks1;
        this.classes2 = ks2;
        this.methods = ms;
        this.nonlinear = m;
    }

    public static final ClassCache3 empty() {
        return new ClassCache3(new Class[0], new Class[0][], new Class[0][][], new IFn[0][][], Collections.emptyMap());
    }

    private final int index(Class c0) {
        for (int i0 = 0; i0 < this.classes0.length; ++i0) {
            if (!c0.equals(this.classes0[i0])) continue;
            return i0;
        }
        return -1;
    }

    private final int index(int i0, Class c1) {
        Class[] cs1 = this.classes1[i0];
        for (int i1 = 0; i1 < cs1.length; ++i1) {
            if (!c1.equals(cs1[i1])) continue;
            return i1;
        }
        return -1;
    }

    private final int index(int i0, int i1, Class c2) {
        Class[] cs2 = this.classes2[i0][i1];
        for (int i2 = 0; i2 < cs2.length; ++i2) {
            if (!c2.equals(cs2[i2])) continue;
            return i2;
        }
        return -1;
    }

    private final ClassCache3 addCell(int i0, int i1, Class c2) {
        return new ClassCache3(Util.copy(this.classes0), Util.copy(this.classes1), Util.append(this.classes2, i0, i1, c2), Util.append(this.methods, i0, i1, null), this.nonlinear);
    }

    private final ClassCache3 addCell(int i0, Class c1, Class c2) {
        return new ClassCache3(Util.copy(this.classes0), Util.append(this.classes1, i0, c1), Util.append(this.classes2, i0, new Class[]{c2}), Util.append(this.methods, i0, new IFn[]{null}), this.nonlinear);
    }

    private final ClassCache3 addCell(Class c0, Class c1, Class c2) {
        return new ClassCache3(Util.append(this.classes0, c0), Util.append(this.classes1, new Class[]{c1}), Util.append(this.classes2, new Class[][]{{c2}}), Util.append(this.methods, new IFn[][]{{null}}), this.nonlinear);
    }

    private final ClassCache3 ensureCell(Class c0, Class c1, Class c2) {
        int i0 = this.index(c0);
        if (0 > i0) {
            return this.addCell(c0, c1, c2);
        }
        int i1 = this.index(i0, c1);
        if (0 > i1) {
            return this.addCell(i0, c1, c2);
        }
        int i2 = this.index(i0, i1, c2);
        if (0 > i2) {
            return this.addCell(i0, i1, c2);
        }
        return this;
    }

    private final ClassCache3 set(Class c0, Class c1, Class c2, IFn m) {
        int i0 = this.index(c0);
        assert (0 <= i0);
        int i1 = this.index(i0, c1);
        assert (0 <= i1);
        int i2 = this.index(i0, i1, c2);
        assert (0 <= i2);
        IFn[][][] ms = Util.copy(this.methods);
        ms[i0][i1][i2] = m;
        return new ClassCache3(Util.copy(this.classes0), Util.copy(this.classes1), Util.copy(this.classes2), ms, this.nonlinear);
    }

    public final ClassCache3 assoc(Class c0, Class c1, Class c2, IFn m) {
        return this.ensureCell(c0, c1, c2).set(c0, c1, c2, m);
    }
}

