/*
 * Decompiled with CFR 0.152.
 */
package benchtools.java.matrices;

import benchtools.java.matrices.DenseMatrix;
import benchtools.java.matrices.Matrix;
import clojure.lang.IFn;
import java.util.Arrays;

public final class DiagonalMatrix
implements Matrix {
    private final int _nrows;
    private final int _ncols;
    private final double[] _elts;

    public final DiagonalMatrix add(DiagonalMatrix m) {
        System.out.println("call DiagonalMatrix.add(DiagonalMatrix)");
        assert (this.nrows() == m.nrows());
        assert (this.ncols() == m.ncols());
        int n = Math.min(this.nrows(), this.ncols());
        double[] e = new double[n];
        for (int i = 0; i < n; ++i) {
            e[i] = this._elts[i] + m._elts[i];
        }
        return new DiagonalMatrix(this._nrows, this._ncols, e);
    }

    public final DenseMatrix add(DenseMatrix m) {
        System.out.println("call DiagonalMatrix.add(DenseMatrix)");
        assert (this.nrows() == m.nrows());
        assert (this.ncols() == m.ncols());
        double[][] e = new double[this.nrows()][this.ncols()];
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                e[i][j] = this.get(i, j) + m.get(i, j);
            }
        }
        return DenseMatrix.make(e);
    }

    @Override
    public final int nrows() {
        return this._nrows;
    }

    @Override
    public final int ncols() {
        return this._ncols;
    }

    @Override
    public final double get(int i, int j) {
        if (i != j) {
            return 0.0;
        }
        return this._elts[i];
    }

    @Override
    public final Matrix add(Matrix m) {
        System.out.println("call DiagonalMatrix.add(Matrix)");
        assert (this.nrows() == m.nrows());
        assert (this.ncols() == m.ncols());
        double[][] e = new double[this.nrows()][this.ncols()];
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                e[i][j] = this.get(i, j) + m.get(i, j);
            }
        }
        return DenseMatrix.make(e);
    }

    private DiagonalMatrix(int nr, int nc, double[] e) {
        this._nrows = nr;
        this._ncols = nc;
        this._elts = e;
    }

    public static final DiagonalMatrix make(int nr, int nc, double[] e) {
        int n = Math.min(nr, nc);
        assert (n == e.length);
        return new DiagonalMatrix(nr, nc, Arrays.copyOf(e, n));
    }

    public static final DiagonalMatrix generate(IFn.D g, int nr, int nc) {
        int n = Math.min(nr, nc);
        double[] e = new double[n];
        for (int i = 0; i < n; ++i) {
            e[i] = g.invokePrim();
        }
        return DiagonalMatrix.make(nr, nc, e);
    }
}

