/*
 * Decompiled with CFR 0.152.
 */
package benchtools.java.matrices;

import benchtools.java.matrices.DiagonalMatrix;
import benchtools.java.matrices.Matrix;
import clojure.lang.IFn;
import java.util.Arrays;

public final class DenseMatrix
implements Matrix {
    private final int _nrows;
    private final int _ncols;
    private final double[][] _elts;

    public final DenseMatrix add(DiagonalMatrix m) {
        System.out.println("call DenseMatrix.add(DiagonalMatrix)");
        assert (this.nrows() == m.nrows());
        assert (this.ncols() == m.ncols());
        double[][] e = new double[this.nrows()][this.ncols()];
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                e[i][j] = i == j ? this.get(i, j) + m.get(i, j) : this.get(i, j);
            }
        }
        return DenseMatrix.make(e);
    }

    public final DenseMatrix add(DenseMatrix m) {
        System.out.println("call DenseMatrix.add(DenseMatrix)");
        assert (this.nrows() == m.nrows());
        assert (this.ncols() == m.ncols());
        double[][] e = new double[this.nrows()][this.ncols()];
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                e[i][j] = this.get(i, j) + m.get(i, j);
            }
        }
        return DenseMatrix.make(e);
    }

    @Override
    public final int nrows() {
        return this._nrows;
    }

    @Override
    public final int ncols() {
        return this._ncols;
    }

    @Override
    public final double get(int i, int j) {
        return this._elts[i][j];
    }

    @Override
    public final Matrix add(Matrix m) {
        System.out.println("call DenseMatrix.add(Matrix)");
        assert (this.nrows() == m.nrows());
        assert (this.ncols() == m.ncols());
        double[][] e = new double[this.nrows()][this.ncols()];
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                e[i][j] = this.get(i, j) + m.get(i, j);
            }
        }
        return new DenseMatrix(this._nrows, this._ncols, e);
    }

    private DenseMatrix(int nr, int nc, double[][] e) {
        assert (nr == e.length);
        for (int i = 0; i < this.nrows(); ++i) {
            assert (nc == e[i].length);
        }
        this._nrows = nr;
        this._ncols = nc;
        this._elts = e;
    }

    public static final DenseMatrix make(double[][] e) {
        int nr = e.length;
        int nc = e[0].length;
        double[][] ee = new double[nr][];
        for (int i = 0; i < nr; ++i) {
            assert (nc == e[i].length);
            ee[i] = Arrays.copyOf(e[i], nc);
        }
        return new DenseMatrix(nr, nc, ee);
    }

    public static final DenseMatrix generate(IFn.D g, int nr, int nc) {
        double[][] e = new double[nr][nc];
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                e[i][j] = g.invokePrim();
            }
        }
        return DenseMatrix.make(e);
    }
}

