/*
 * Decompiled with CFR 0.152.
 */
package supercollider;

import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import supercollider.MessageReceivedListener;
import supercollider.ReplyCallback;
import supercollider.ScSynthLibrary;
import supercollider.ScSynthStartedListener;
import supercollider.ScSynthStoppedListener;
import supercollider.ScsynthJnaStartOptions;
import supercollider.SndBuf;

public class ScSynth
implements Runnable {
    private Pointer world = Pointer.NULL;
    boolean running = false;
    private ReplyCallback globalReplyCallback = new ReplyCallback(){

        @Override
        public void callback(Pointer addr, Pointer buf, int size) {
            ByteBuffer b = buf.getByteBuffer(0L, (long)size);
            for (MessageReceivedListener l : ScSynth.this.messageListeners) {
                l.messageReceived(b, size);
            }
        }
    };
    ArrayList<ScSynthStartedListener> startedListeners = new ArrayList();
    ArrayList<ScSynthStoppedListener> stoppedListeners = new ArrayList();
    ArrayList<MessageReceivedListener> messageListeners = new ArrayList();

    public void openUdp(int port) {
        if (this.running) {
            ScSynthLibrary.World_OpenUDP(this.world, port);
        }
    }

    public void openTcp(int port) {
        if (this.running) {
            ScSynthLibrary.World_OpenTCP(this.world, port, 64, 8);
        }
    }

    @Override
    public void run() {
        if (!this.running) {
            ScSynthLibrary.scsynth_jna_init();
            ScsynthJnaStartOptions.ByReference o = new ScsynthJnaStartOptions.ByReference();
            o.UGensPluginPath = ScSynthLibrary.getUgensPath();
            this.world = ScSynthLibrary.scsynth_jna_start(o);
            this.running = true;
            for (ScSynthStartedListener scSynthStartedListener : this.startedListeners) {
                scSynthStartedListener.scSynthStarted();
            }
            ScSynthLibrary.World_WaitForQuit(this.world);
            ScSynthLibrary.scsynth_jna_cleanup();
            this.running = false;
            for (ScSynthStoppedListener scSynthStoppedListener : this.stoppedListeners) {
                scSynthStoppedListener.scSynthStopped();
            }
        }
    }

    public void addScSynthStartedListener(ScSynthStartedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.startedListeners.add(listener);
    }

    public void removeScSynthStartedListener(ScSynthStartedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.startedListeners.remove(listener);
    }

    public void addScSynthStoppedListener(ScSynthStoppedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.stoppedListeners.add(listener);
    }

    public void removeScSynthStoppedListener(ScSynthStoppedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.stoppedListeners.remove(listener);
    }

    public void addMessageReceivedListener(MessageReceivedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.messageListeners.add(listener);
    }

    public void removeMessageReceivedListener(MessageReceivedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.messageListeners.remove(listener);
    }

    public void send(ByteBuffer b) {
        if (this.running) {
            ScSynthLibrary.World_SendPacket(this.world, b.limit(), b, this.globalReplyCallback);
        }
    }

    public SndBuf getSndBuf(int index) {
        SndBuf retval = null;
        if (this.running) {
            retval = ScSynthLibrary.scsynth_jna_copy_sndbuf(this.world, index);
        }
        return retval;
    }

    public static void main(String[] args) {
        ScSynth sc = new ScSynth();
        new Thread(sc).start();
    }
}

