/*
 * Decompiled with CFR 0.152.
 */
package supercollider;

import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCByteArrayToJavaConverter;
import com.illposed.osc.utility.OSCPacketDispatcher;
import java.nio.ByteBuffer;
import supercollider.MessageReceivedListener;
import supercollider.ScSynth;
import supercollider.ScSynthOptions;

public class IllposedOscScSynthProxy
extends ScSynth {
    final OSCByteArrayToJavaConverter converter = new OSCByteArrayToJavaConverter();
    final OSCPacketDispatcher dispatcher = new OSCPacketDispatcher();

    private void initProxy() {
        this.addMessageReceivedListener(new MessageReceivedListener(){

            @Override
            public void messageReceived(ByteBuffer bb, int size) {
                byte[] msgAsByteArray = new byte[size];
                bb.get(msgAsByteArray);
                OSCPacket oscPacket = IllposedOscScSynthProxy.this.converter.convert(msgAsByteArray, size);
                IllposedOscScSynthProxy.this.dispatcher.dispatchPacket(oscPacket);
            }
        });
    }

    public IllposedOscScSynthProxy() {
        this.initProxy();
    }

    public IllposedOscScSynthProxy(ScSynthOptions options) {
        super(options);
        this.initProxy();
    }

    public void send(OSCMessage msg) {
        if (this.running) {
            this.send(ByteBuffer.wrap(msg.getByteArray()));
        }
    }

    public void addOSCListener(String anAddress, OSCListener listener) {
        this.dispatcher.addListener(anAddress, listener);
    }
}

