/*
 * Decompiled with CFR 0.152.
 */
package supercollider.scsynth;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import supercollider.scsynth.ScSynth;
import supercollider.scsynth.ScSynthDefaultOptions;
import supercollider.scsynth.ScSynthDevice;
import supercollider.scsynth.ScSynthOptions;
import supercollider.scsynth.ScSynthSetup;
import supercollider.scsynth.internal.Util;

public class ScSynthSetupPanel
extends JPanel {
    ScSynthOptions options = new ScSynthOptions();
    JPanel variablesPanel = new JPanel((LayoutManager)new MigLayout());
    HashMap<String, JSpinner> variableSpinners = new HashMap();

    public ScSynthSetupPanel() {
        this.setLayout((LayoutManager)new MigLayout());
        this.header(this, "Variables");
        this.variables();
        this.deviceSelection();
        JButton defaultsButton = new JButton("Defaults");
        defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScSynthSetupPanel.this.setVariables((ScSynthOptions)new ScSynthDefaultOptions());
            }
        });
        this.add((Component)defaultsButton, "width 80!, height 15!, wrap");
    }

    public ScSynthOptions getOptions() {
        return this.options;
    }

    private void header(Container target, String value) {
        target.add((Component)new JLabel(value), "split, span, gaptop 10");
        target.add((Component)new JSeparator(), "growx, wrap, gaptop 10");
    }

    private void addVariable(String name, int min, int max, int step, boolean wrap, final ScSynthSetup.VariableActionListener performed) {
        this.variablesPanel.add((Component)new JLabel(name), "gap 10, gapright 15, span 2");
        final SpinnerNumberModel model = new SpinnerNumberModel(-1, min, max, step);
        JSpinner spinner = new JSpinner(model);
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                performed.actionPerformed(model.getNumber().intValue());
            }
        });
        this.variableSpinners.put(name, spinner);
        this.variablesPanel.add((Component)spinner, "span, width 75!" + (wrap ? ", wrap" : ""));
    }

    private void variables() {
        this.header(this.variablesPanel, "Channels");
        JScrollPane v = new JScrollPane(this.variablesPanel);
        v.setHorizontalScrollBarPolicy(31);
        this.add((Component)v, "growx, span 3, height 100::, wrap");
        this.addVariable("number of control bus channels", -1, 1000000, 256, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setNumControlBusChannels(value);
            }
        });
        this.addVariable("number of audio bus channels", -1, 1000000, 32, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setNumAudioBusChannels(value);
            }
        });
        this.addVariable("number of input bus channels", -1, 1000000, 2, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setNumInputBusChannels(value);
            }
        });
        this.addVariable("number of output bus channels", -1, 1000000, 2, true, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setNumOutputBusChannels(value);
            }
        });
        this.header(this.variablesPanel, "Other options");
        this.addVariable("block size", -1, 1000000, 8, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setBufLength(value);
            }
        });
        if (!Util.getOsName().equals("linux")) {
            this.addVariable("hardware buffer size", -1, 1000000, 1, false, new ScSynthSetup.VariableActionListener(){

                @Override
                public void actionPerformed(int value) {
                    ScSynthSetupPanel.this.options.setPreferredHardwareBufferFrameSize(value);
                }
            });
            this.addVariable("hardware sample rate", -1, 1000000, 1, false, new ScSynthSetup.VariableActionListener(){

                @Override
                public void actionPerformed(int value) {
                    ScSynthSetupPanel.this.options.setPreferredSampleRate(value);
                }
            });
        }
        this.addVariable("number of sample buffers", -1, 1000000, 256, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setNumBuffers(value);
            }
        });
        this.addVariable("max number of nodes", -1, 1000000, 256, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setMaxNodes(value);
            }
        });
        this.addVariable("max number of synth defs", -1, 1000000, 256, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setMaxGraphDefs(value);
            }
        });
        this.addVariable("real time memory size", -1, 1000000, 1024, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setRealTimeMemorySize(value);
            }
        });
        this.addVariable("number of wire buffers", -1, 1000000, 8, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setMaxWireBufs(value);
            }
        });
        this.addVariable("number of random seeds", -1, 1000000, 8, false, new ScSynthSetup.VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetupPanel.this.options.setNumRGens(value);
            }
        });
    }

    private void setVariables(ScSynthOptions options) {
        this.variableSpinners.get("number of control bus channels").setValue(options.getNumControlBusChannels());
        this.variableSpinners.get("number of audio bus channels").setValue(options.getNumAudioBusChannels());
        this.variableSpinners.get("number of input bus channels").setValue(options.getNumInputBusChannels());
        this.variableSpinners.get("number of output bus channels").setValue(options.getNumOutputBusChannels());
        this.variableSpinners.get("block size").setValue(options.getBufLength());
        if (!Util.getOsName().equals("linux")) {
            this.variableSpinners.get("hardware buffer size").setValue(options.getPreferredHardwareBufferFrameSize());
            this.variableSpinners.get("hardware sample rate").setValue(options.getPreferredSampleRate());
        }
        this.variableSpinners.get("number of sample buffers").setValue(options.getNumBuffers());
        this.variableSpinners.get("max number of nodes").setValue(options.getMaxNodes());
        this.variableSpinners.get("max number of synth defs").setValue(options.getMaxGraphDefs());
        this.variableSpinners.get("real time memory size").setValue(options.getRealTimeMemorySize());
        this.variableSpinners.get("number of wire buffers").setValue(options.getMaxWireBufs());
        this.variableSpinners.get("number of random seeds").setValue(options.getNumRGens());
    }

    private void deviceSelection() {
        this.header(this, "Choose devices for input and output");
        this.add((Component)new JLabel("Choose input device"), "gaptop 10");
        DefaultComboBoxModel<DeviceOption> inputDeviceModel = new DefaultComboBoxModel<DeviceOption>();
        final JComboBox inputDeviceList = new JComboBox(inputDeviceModel);
        inputDeviceList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceOption item = (DeviceOption)inputDeviceList.getSelectedItem();
                ScSynthSetupPanel.this.options.setInDeviceName(item.value);
            }
        });
        inputDeviceModel.addElement(new DeviceOption("", "DEFAULT"));
        for (ScSynthDevice d : ScSynth.getDevices()) {
            if (d.getMaxInputs() <= 0) continue;
            inputDeviceModel.addElement(new DeviceOption(d.getName(), d.getName() + " in: " + d.getMaxInputs() + " out: " + d.getMaxOutputs()));
        }
        this.add(inputDeviceList, "growx, span 3, wrap");
        this.add((Component)new JLabel("Choose output device"), "gaptop 10");
        DefaultComboBoxModel<DeviceOption> outputDeviceModel = new DefaultComboBoxModel<DeviceOption>();
        final JComboBox outputDeviceList = new JComboBox(outputDeviceModel);
        outputDeviceList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceOption item = (DeviceOption)outputDeviceList.getSelectedItem();
                ScSynthSetupPanel.this.options.setOutDeviceName(item.value);
            }
        });
        outputDeviceModel.addElement(new DeviceOption("", "DEFAULT"));
        for (ScSynthDevice d : ScSynth.getDevices()) {
            if (d.getMaxOutputs() <= 0) continue;
            outputDeviceModel.addElement(new DeviceOption(d.getName(), d.getName() + " in: " + d.getMaxInputs() + " out: " + d.getMaxOutputs()));
        }
        this.add(outputDeviceList, "growx, span 3, wrap");
    }

    class DeviceOption {
        String text;
        String value;

        public DeviceOption(String value, String text) {
            this.value = value;
            this.text = text;
        }

        public String toString() {
            return this.text.toString();
        }
    }
}

