/*
 * Decompiled with CFR 0.152.
 */
package supercollider.scsynth;

import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.ByteBuffer;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import supercollider.scsynth.IllposedOscScSynthProxy;
import supercollider.scsynth.ScSynthOptions;
import supercollider.scsynth.ScSynthSetupPanel;
import supercollider.scsynth.ScSynthStartedListener;
import supercollider.scsynth.ScSynthStoppedListener;
import supercollider.scsynth.internal.Util;

public class ScSynthSetup
extends JFrame {
    ScSynthSetupPanel panel = new ScSynthSetupPanel();
    IllposedOscScSynthProxy sc = new IllposedOscScSynthProxy();
    JEditorPane logger = new JEditorPane();

    public ScSynthOptions getOptions() {
        return this.panel.getOptions();
    }

    public ScSynthSetup() {
        this.setTitle("ScSynth Setup");
        this.setLayout((LayoutManager)new MigLayout());
        this.setResizable(false);
        this.header(this, "Information");
        this.add((Component)new JLabel("operating system"), "growx, span 2");
        this.add((Component)new JLabel(Util.getOsName()), " growx, wrap");
        this.add((Component)new JLabel("architecture"), " growx, span 2");
        this.add((Component)new JLabel(Util.getOsArch()), " growx, wrap");
        this.add((Component)this.panel, "growx, growy, wrap");
        this.header(this, "Actions");
        JPanel actionsPanel = new JPanel();
        actionsPanel.setLayout((LayoutManager)new MigLayout());
        JButton bootButton = new JButton("Boot");
        bootButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScSynthSetup.this.startScSynth();
            }
        });
        actionsPanel.add((Component)bootButton, "width 80!, height 15!");
        JButton statusButton = new JButton("Status");
        statusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScSynthSetup.this.sendStatusMessage();
            }
        });
        actionsPanel.add((Component)statusButton, "width 80!, height 15!");
        JButton quitButton = new JButton("Quit");
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScSynthSetup.this.sendQuitMessage();
            }
        });
        actionsPanel.add((Component)quitButton, "width 80!, height 15!");
        this.add((Component)actionsPanel, "span 3, wrap");
        JScrollPane loggerScroll = new JScrollPane(this.logger);
        this.logger.setEditable(false);
        loggerScroll.setHorizontalScrollBarPolicy(31);
        this.add((Component)loggerScroll, "growx, span 3, height 60!");
        this.pack();
        this.setMinimumSize(new Dimension(this.getWidth(), 250));
        this.setupCommunication();
    }

    private void log(String msg) {
        try {
            msg = msg + "\n";
            this.logger.getDocument().insertString(this.logger.getDocument().getLength(), msg, null);
            this.logger.setCaretPosition(this.logger.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void startScSynth() {
        this.sc.setOptions(this.panel.getOptions());
        new Thread((Runnable)this.sc).start();
    }

    private void sendQuitMessage() {
        OSCMessage msg = new OSCMessage("/quit");
        this.sc.send(ByteBuffer.wrap(msg.getByteArray()));
    }

    private void sendStatusMessage() {
        OSCMessage msg = new OSCMessage("/status");
        this.sc.send(ByteBuffer.wrap(msg.getByteArray()));
    }

    private void setupCommunication() {
        this.sc.addScSynthStartedListener(new ScSynthStartedListener(){

            public void started() {
                ScSynthSetup.this.log("ScSynth started");
            }
        });
        this.sc.addScSynthStoppedListener(new ScSynthStoppedListener(){

            public void stopped() {
                ScSynthSetup.this.log("ScSynth stopped");
            }
        });
        this.sc.addOSCListener("/status.reply", new OSCListener(){

            public void acceptMessage(Date date, OSCMessage oscm) {
                ScSynthSetup.this.log("Got status message ");
            }
        });
    }

    private void header(Container target, String value) {
        target.add((Component)new JLabel(value), "split, span, gaptop 10");
        target.add((Component)new JSeparator(), "growx, wrap, gaptop 10");
    }

    public static void main(String[] args) {
        ScSynthSetup s = new ScSynthSetup();
        s.setVisible(true);
        s.setDefaultCloseOperation(3);
    }

    static interface VariableActionListener {
        public void actionPerformed(int var1);
    }
}

