/*
 * Decompiled with CFR 0.152.
 */
package supercollider.scsynth;

import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import supercollider.scsynth.DefaultScSynthOptions;
import supercollider.scsynth.IllposedOscScSynthProxy;
import supercollider.scsynth.ScSynth;
import supercollider.scsynth.ScSynthDevice;
import supercollider.scsynth.ScSynthOptions;
import supercollider.scsynth.ScSynthStartedListener;
import supercollider.scsynth.ScSynthStoppedListener;
import supercollider.scsynth.internal.Util;

public class ScSynthSetup
extends JFrame {
    ScSynthOptions options = new ScSynthOptions();
    JPanel variablesPanel = new JPanel((LayoutManager)new MigLayout());
    IllposedOscScSynthProxy sc = new IllposedOscScSynthProxy();
    JEditorPane logger = new JEditorPane();
    HashMap<String, JSpinner> variableSpinners = new HashMap();

    public ScSynthOptions getOptions() {
        return this.options;
    }

    public ScSynthSetup() {
        this.setTitle("ScSynth Setup");
        this.setLayout((LayoutManager)new MigLayout());
        this.header(this, "Information");
        this.add((Component)new JLabel("operating system"), "growx, span 2");
        this.add((Component)new JLabel(Util.getOsName()), " growx, wrap");
        this.add((Component)new JLabel("architecture"), " growx, span 2");
        this.add((Component)new JLabel(Util.getOsArch()), " growx, wrap");
        this.variables();
        if (Util.getOsName().equals("macosx") || Util.getOsName().equals("windows")) {
            this.deviceSelection();
        }
        this.header(this, "Actions");
        JPanel actionsPanel = new JPanel();
        actionsPanel.setLayout((LayoutManager)new MigLayout());
        JButton bootButton = new JButton("Boot");
        bootButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScSynthSetup.this.startScSynth();
            }
        });
        actionsPanel.add((Component)bootButton, "width 80!, height 15!");
        JButton statusButton = new JButton("Status");
        statusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScSynthSetup.this.sendStatusMessage();
            }
        });
        actionsPanel.add((Component)statusButton, "width 80!, height 15!");
        JButton quitButton = new JButton("Quit");
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScSynthSetup.this.sendQuitMessage();
            }
        });
        actionsPanel.add((Component)quitButton, "width 80!, height 15!");
        JButton defaultsButton = new JButton("Defaults");
        defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScSynthSetup.this.setVariables((ScSynthOptions)new DefaultScSynthOptions());
            }
        });
        actionsPanel.add((Component)defaultsButton, "width 80!, height 15!, wrap");
        this.add((Component)actionsPanel, "span 3, wrap");
        JScrollPane loggerScroll = new JScrollPane(this.logger);
        this.logger.setEditable(false);
        loggerScroll.setHorizontalScrollBarPolicy(31);
        this.add((Component)loggerScroll, "growx, span 3, height 60!");
        this.pack();
        this.setMinimumSize(new Dimension(this.getWidth(), 250));
        this.setupCommunication();
    }

    private void setVariables(ScSynthOptions options) {
        this.variableSpinners.get("number of control bus channels").setValue(options.getNumControlBusChannels());
        this.variableSpinners.get("number of audio bus channels").setValue(options.getNumAudioBusChannels());
        this.variableSpinners.get("number of input bus channels").setValue(options.getNumInputBusChannels());
        this.variableSpinners.get("number of output bus channels").setValue(options.getNumOutputBusChannels());
        this.variableSpinners.get("block size").setValue(options.getBufLength());
        if (!Util.getOsName().equals("linux")) {
            this.variableSpinners.get("hardware buffer size").setValue(options.getPreferredHardwareBufferFrameSize());
            this.variableSpinners.get("hardware sample rate").setValue(options.getPreferredSampleRate());
        }
        this.variableSpinners.get("number of sample buffers").setValue(options.getNumBuffers());
        this.variableSpinners.get("max number of nodes").setValue(options.getMaxNodes());
        this.variableSpinners.get("max number of synth defs").setValue(options.getMaxGraphDefs());
        this.variableSpinners.get("real time memory size").setValue(options.getRealTimeMemorySize());
        this.variableSpinners.get("number of wire buffers").setValue(options.getMaxWireBufs());
        this.variableSpinners.get("number of random seeds").setValue(options.getNumRGens());
    }

    private void addVariable(String name, int min, int max, int step, boolean wrap, final VariableActionListener performed) {
        this.variablesPanel.add((Component)new JLabel(name), "gap 10, gapright 15, span 2");
        final SpinnerNumberModel model = new SpinnerNumberModel(-1, min, max, step);
        JSpinner spinner = new JSpinner(model);
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                performed.actionPerformed(model.getNumber().intValue());
            }
        });
        this.variableSpinners.put(name, spinner);
        this.variablesPanel.add((Component)spinner, "span, width 75!" + (wrap ? ", wrap" : ""));
    }

    private void variables() {
        this.header(this.variablesPanel, "Channels");
        JScrollPane v = new JScrollPane(this.variablesPanel);
        v.setHorizontalScrollBarPolicy(31);
        this.add((Component)v, "growx, span 3, height 100::, wrap");
        this.addVariable("number of control bus channels", -1, 1000000, 256, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setNumControlBusChannels(value);
            }
        });
        this.addVariable("number of audio bus channels", -1, 1000000, 32, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setNumAudioBusChannels(value);
            }
        });
        this.addVariable("number of input bus channels", -1, 1000000, 2, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setNumInputBusChannels(value);
            }
        });
        this.addVariable("number of output bus channels", -1, 1000000, 2, true, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setNumOutputBusChannels(value);
            }
        });
        this.header(this.variablesPanel, "Other options");
        this.addVariable("block size", -1, 1000000, 8, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setBufLength(value);
            }
        });
        if (!Util.getOsName().equals("linux")) {
            this.addVariable("hardware buffer size", -1, 1000000, 1, false, new VariableActionListener(){

                @Override
                public void actionPerformed(int value) {
                    ScSynthSetup.this.options.setPreferredHardwareBufferFrameSize(value);
                }
            });
            this.addVariable("hardware sample rate", -1, 1000000, 1, false, new VariableActionListener(){

                @Override
                public void actionPerformed(int value) {
                    ScSynthSetup.this.options.setPreferredSampleRate(value);
                }
            });
        }
        this.addVariable("number of sample buffers", -1, 1000000, 256, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setNumBuffers(value);
            }
        });
        this.addVariable("max number of nodes", -1, 1000000, 256, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setMaxNodes(value);
            }
        });
        this.addVariable("max number of synth defs", -1, 1000000, 256, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setMaxGraphDefs(value);
            }
        });
        this.addVariable("real time memory size", -1, 1000000, 1024, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setRealTimeMemorySize(value);
            }
        });
        this.addVariable("number of wire buffers", -1, 1000000, 8, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setMaxWireBufs(value);
            }
        });
        this.addVariable("number of random seeds", -1, 1000000, 8, false, new VariableActionListener(){

            @Override
            public void actionPerformed(int value) {
                ScSynthSetup.this.options.setNumRGens(value);
            }
        });
    }

    private void log(String msg) {
        try {
            msg = msg + "\n";
            this.logger.getDocument().insertString(this.logger.getDocument().getLength(), msg, null);
            this.logger.setCaretPosition(this.logger.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void startScSynth() {
        this.sc.setOptions(this.options);
        new Thread((Runnable)this.sc).start();
    }

    private void sendQuitMessage() {
        OSCMessage msg = new OSCMessage("/quit");
        this.sc.send(ByteBuffer.wrap(msg.getByteArray()));
    }

    private void sendStatusMessage() {
        OSCMessage msg = new OSCMessage("/status");
        this.sc.send(ByteBuffer.wrap(msg.getByteArray()));
    }

    private void setupCommunication() {
        this.sc.addScSynthStartedListener(new ScSynthStartedListener(){

            public void started() {
                ScSynthSetup.this.log("ScSynth started");
            }
        });
        this.sc.addScSynthStoppedListener(new ScSynthStoppedListener(){

            public void stopped() {
                ScSynthSetup.this.log("ScSynth stopped");
            }
        });
        this.sc.addOSCListener("/status.reply", new OSCListener(){

            public void acceptMessage(Date date, OSCMessage oscm) {
                ScSynthSetup.this.log("Got status message ");
            }
        });
    }

    private void header(Container target, String value) {
        target.add((Component)new JLabel(value), "split, span, gaptop 10");
        target.add((Component)new JSeparator(), "growx, wrap, gaptop 10");
    }

    private void deviceSelection() {
        this.header(this, "Choose devices for input and output");
        this.add((Component)new JLabel("Choose input device"), "gaptop 10");
        DefaultComboBoxModel<DeviceOption> inputDeviceModel = new DefaultComboBoxModel<DeviceOption>();
        final JComboBox inputDeviceList = new JComboBox(inputDeviceModel);
        inputDeviceList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceOption item = (DeviceOption)inputDeviceList.getSelectedItem();
                ScSynthSetup.this.options.setInDeviceName(item.value);
            }
        });
        inputDeviceModel.addElement(new DeviceOption("", "DEFAULT"));
        for (ScSynthDevice d : ScSynth.getDevices()) {
            if (d.getMaxInputs() <= 0) continue;
            inputDeviceModel.addElement(new DeviceOption(d.getName(), d.getName() + " in: " + d.getMaxInputs() + " out: " + d.getMaxOutputs()));
        }
        this.add(inputDeviceList, "growx, span 3, wrap");
        this.add((Component)new JLabel("Choose output device"), "gaptop 10");
        DefaultComboBoxModel<DeviceOption> outputDeviceModel = new DefaultComboBoxModel<DeviceOption>();
        final JComboBox outputDeviceList = new JComboBox(outputDeviceModel);
        outputDeviceList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceOption item = (DeviceOption)outputDeviceList.getSelectedItem();
                ScSynthSetup.this.options.setOutDeviceName(item.value);
            }
        });
        outputDeviceModel.addElement(new DeviceOption("", "DEFAULT"));
        for (ScSynthDevice d : ScSynth.getDevices()) {
            if (d.getMaxOutputs() <= 0) continue;
            outputDeviceModel.addElement(new DeviceOption(d.getName(), d.getName() + " in: " + d.getMaxInputs() + " out: " + d.getMaxOutputs()));
        }
        this.add(outputDeviceList, "growx, span 3, wrap");
    }

    public static void main(String[] args) {
        ScSynthSetup s = new ScSynthSetup();
        s.setVisible(true);
        s.setDefaultCloseOperation(3);
    }

    class DeviceOption {
        String text;
        String value;

        public DeviceOption(String value, String text) {
            this.value = value;
            this.text = text;
        }

        public String toString() {
            return this.text.toString();
        }
    }

    static interface VariableActionListener {
        public void actionPerformed(int var1);
    }
}

