/*
 * Decompiled with CFR 0.152.
 */
package supercollider.sclang.internal;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import supercollider.sclang.internal.Util;

public class ScLangLibrary {
    private static String sclangDir = "";

    public static String getScLangPath() {
        return sclangDir;
    }

    private static void mkTempSubdirs(File p) {
        File parent = p.getParentFile();
        if (!parent.getName().equals("SCClassLibrary") && !parent.exists()) {
            ScLangLibrary.mkTempSubdirs(parent);
        }
        if (!p.exists()) {
            p.mkdir();
            p.deleteOnExit();
        }
    }

    public static List<String> getFileList(String path) throws IOException {
        ArrayList<String> retval = new ArrayList<String>();
        InputStream in = ScLangLibrary.class.getResource(path).openStream();
        String[] contents = Util.convertStreamToString(in).split("\n");
        retval.addAll(Arrays.asList(contents));
        in.close();
        return retval;
    }

    public static native void sclang_interop_set_compile_dir(String var0);

    public static native boolean sclang_interop_is_compiled_ok();

    public static native void sclang_interop_set_cmdline(Pointer var0, String var1);

    public static native void sclang_interop_init_mem_pools(int var0, int var1);

    public static native void sclang_interop_compile_library();

    public static native void sclang_interop_run_library(Pointer var0);

    public static native Pointer sclang_interop_get_scglobals();

    public static native void sclang_interop_sched_init();

    public static native Pointer sclang_interop_get_sym(String var0);

    public static native void sclang_interop_init_osc(int var0);

    public static native void sclang_interop_set_vpost_callback(VpostCallback var0);

    public static native void sclang_interop_set_gui_init_callback(InitGUICallback var0);

    public static native void sclang_interop_set_gui_close_callback(CloseGUICallback var0);

    public static native int sclang_interop_init();

    public static native void sclang_interop_cleanup();

    static {
        try {
            String baseTempPath = System.getProperty("java.io.tmpdir");
            Random rand = new Random();
            int randomInt = 100000 + rand.nextInt(899999);
            File tempDir = new File(baseTempPath + File.separator + "sclang_interop" + randomInt);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            tempDir.deleteOnExit();
            String os = Util.getOsName();
            String arch = Util.getOsArch();
            String variant = "common";
            String resourcesBasePath = "/supercollider/sclang/" + os + "/" + arch + "/" + variant;
            List<String> scLangDirList = ScLangLibrary.getFileList(resourcesBasePath + "/contents.txt");
            for (String fn : scLangDirList) {
                String source = resourcesBasePath + "/" + fn;
                String target = tempDir.getPath() + File.separator + fn;
                File lib = Util.copyResourceToFS(source, target);
                lib.deleteOnExit();
            }
            String clBasePath = "/supercollider/sclang";
            List<String> classlibDirList = ScLangLibrary.getFileList(clBasePath + "/contents.txt");
            File classlibdir = new File(tempDir.getPath() + File.separator + "SCClassLibrary");
            classlibdir.mkdir();
            classlibdir.deleteOnExit();
            for (String fn : classlibDirList) {
                String source = clBasePath + File.separator + fn.substring(2);
                String target = tempDir.getPath() + File.separator + fn.substring(2);
                ScLangLibrary.mkTempSubdirs(new File(target).getParentFile());
                File lib = Util.copyResourceToFS(source, target);
                lib.deleteOnExit();
            }
            System.setProperty("jna.library.path", tempDir.getPath());
            Native.register((String)"sclang-interop");
            sclangDir = tempDir.getPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static interface CloseGUICallback
    extends StdCallLibrary.StdCallCallback {
        public void callback();
    }

    public static interface InitGUICallback
    extends StdCallLibrary.StdCallCallback {
        public void callback();
    }

    public static interface VpostCallback
    extends StdCallLibrary.StdCallCallback {
        public void callback(String var1);
    }
}

