(ns clj-jack.core
  (:use [clj-native.direct :only [defclib]]))

(def jack-status-map
     {:failure         0x01
      :invalid-option  0x02
      :name-not-unique 0x04
      :server-started  0x08
      :server-failed   0x10
      :server-error    0x20
      :no-such-client  0x40
      :load-failure    0x80
      :init-failure    0x100
      :shm-failure     0x200
      :version-error   0x400
      :backend-error   0x800
      :client-zombie   0x1000})

(def jack-options-map
     {:null-option     0x00
      :no-start-server 0x01
      :use-exact-name  0x02
      :server-name     0x04
      :load-name       0x08
      :load-init       0x10})

(defclib
  jack
  (:functions
   (jack_client_open [constchar* int void* constchar*] void*)
   (jack_get_ports [void* constchar* constchar* long] void*)
   (jack_client_close [void*] int)))

(loadlib-jack)

(comment

  (def client (jack_client_open "lsp" (:no-start-server jack-options-map) nil nil))
  (def bb (.getStringArray (jack_get_ports client "" "" 0) 0))
  (println (seq bb))
  (jack_client_close client)

  )
