# Assemble

Assemble is a Leiningen plugin for building and distributing client
side ClojureScript and Garden projects. It provides a single command
for easy automatic and one-time building of these projects.

### Table of Contents

* [Usage](#usage)
* [Configuration](#configuration)

## Usage

Put `[outpace/assemble "0.2.0"]` into the `:plugins` vector of your project.clj.

## Configuration

```clj
:outpace/assemble
{:aws-config {;; AWS credentials
              :access-key "..."
              :secret-key "..."
              :token "..." ;; Optional
              ;; S3 configuration for pushing assets and URL rewriting.
              :s3-base-path "my-app-name"
              :s3-bucket "my-bucket-name"
              :cloudfront-base-url "//lol420wtf330.cloudfront.net"}
 ;; Which garden and cljsbuilds to use. 
 :builds [{:id "dev"
           :garden ["dev"]
           :cljsbuild ["dev"]}
          {:id "prod"
           :garden ["prod"]
           :cljsbuild ["prod"]}]})
```
