(ns leiningen.new.outfit
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "outfit"))

(defn outfit
  "Create a new Om application"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' outfit project.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render "gitignore" data)]
             ["dist/index.html" (render "index.html" data)]
             ["dist/css/screen.css" (render "screen.css" data)]
             ;; Clojure
             ["src/clj/{{sanitized}}/stylesheets.clj" (render "stylesheets.clj" data)]
             ;; ClojureScript
             ["src/cljs/{{sanitized}}/app.cljs" (render "app.cljs" data)]
             ["src/cljs/{{sanitized}}/data.cljs" (render "data.cljs" data)]
             ["src/cljs/{{sanitized}}/routes.cljs" (render "routes.cljs" data)]
             ["src/cljs/{{sanitized}}/util.cljs" (render "util.cljs" data)]
             ["src/cljs/{{sanitized}}/history.cljs" (render "history.cljs" data)]
             ["src/cljs/{{sanitized}}/views/main.cljs" (render "main.cljs" data)]
             ["src/cljs/{{sanitized}}/views/home.cljs" (render "home.cljs" data)]
             ["src/cljs/{{sanitized}}/views/common.cljs" (render "common.cljs" data)]
             ["test/cljs/{{sanitized}}/app_test.cljs" (render "app_test.cljs" data)])))
