(ns {{name}}.history
  (:require [secretary.core :as secretary])
  (:import goog.History
           goog.history.EventType))

(def history nil)

(defn history-listener [e]
  (secretary/dispatch! (.-token e)))

(defn start! []
  (let [h (History.)]
    (goog.events/listen h EventType/NAVIGATE history-listener)

    (def history (doto h (.setEnabled true)))))

(defn stop! []
  (goog.events/unlisten history EventType/NAVIGATE history-listener)
  (def history nil))

