(defproject oscar-marshall/datomic-cljs "0.0.1-alpha-1"
  :description "Datomic REST client for ClojureScript"
  :url "https://github.com/zachallaun/datomic-cljs"
  :license {:name "MIT" :url "http://opensource.org/licenses/MIT"}

  :dependencies [[figwheel-sidecar "0.5.2"]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/clojurescript "1.8.34"]
                 [org.clojure/core.async "0.2.374"]]

  :npm {:dependencies [[request "2.70.0"]]}

  :profiles {:dev {:plugins [[lein-cljsbuild "1.1.3"]
                             [lein-npm "0.6.2"]]}}

  :cljsbuild {:builds [{:id           "dev"
                        :source-paths ["src"]
                        :figwheel     true
                        :compiler     {:output-to  "target/dev/index.js"
                                       :output-dir "target/dev"
                                       :source-map true
                                       :target     :nodejs}}
                       {:id           "test"
                        :source-paths ["src" "test"]
                        :compiler     {:target        :nodejs
                                       :output-to     "target/test.js"
                                       :optimizations :simple
                                       :pretty-print  true}}
                       {:id           "example"
                        :source-paths ["src" "examples"]
                        :compiler     {:target        :nodejs
                                       :output-to     "target/example.js"
                                       :optimizations :simple
                                       :pretty-print  true}}]})
