# Building static web with hot-code reloading

![Volcano](doc/volcano.png)

[![Clojars Project](https://img.shields.io/clojars/v/orgpad/volcano.svg)](https://clojars.org/orgpad/volcano)

> Remind me that the most fertile lands were built by the fires of volcanoes.
> ? Andrea Gibson, The Madness Vase

Well, we really love hot-code reloading while developing single page applications (SPA) in ClojureScript.
It was introduced by Figwheel, and well, if you haven't seen these amazing videos you should watch them:
[Figwheel introduction](https://www.youtube.com/watch?v=j-kj2qwJa_E) and
[coding Flappy Bird](https://www.youtube.com/watch?v=KZjFVdU8VLI). We mean it, you should go to watch them right now!
In [OrgPad](https://orgpad.com), we were happily using this in development and didn't even have data persistence for
the first two months.

We wanted to rebuild our [landing page](https//orgpad.com/about). The requirements are that it should consist of a
few static webpages linked together, with the minimum amount of Javascript and CSS, so they load really fast even on
a slow mobile connection. We wanted to use Clojure(Script) to be able to connect them to the rest of our codebase.
So we were originally generating HTML using [Hiccup library](https://github.com/weavejester/hiccup). You do a change,
you reload the file in REPL, then you reload the browser, and you see the result. It's incredibly slow and tedious
if you are used to instant code reloading from your SPA. If you use CSS generators such as
[Less](https://github.com/montoux/lein-less) or [Garden](https://github.com/noprompt/lein-garden), you also have to
reload the browser after every change.

We were looking into existing Clojure solutions: [Stasis](https://github.com/magnars/stasis),
[Oz](https://github.com/metasoarous/oz), and a few others. They were either build for a different purpose:
generating large webs, generating easy blogs, scientific visualizations. They were difficult to set up. They were
either very restrictive or just giving a few functions which you should use to build your own infrastructure. Hot-code
reloading and auto-updating of CSS files which we wanted was not included. Therefore, we build Volcano which is
a microframework for generating static web. If you are familiar with Clojure(Script), you should get it running in
5 minutes.

## How it works

You just write a single config map describing your entire web. Each site is a sequence in data in Hiccup format.
In development, Volcano runs your Web as a SPA using ClojureScript, [Shadow-cljs](http://shadow-cljs.org/) and
[Reagent](https://github.com/reagent-project/reagent). When you do any changes to the config map, you see them
immediately. For production, Volcano builds static HTML files of your Web using Clojure which you can deploy online
or further process. Since your code is runned by both Clojure and ClojureScript, it has to be written in .cljc files.

## Getting started

Include this dependency into your project:

[![Clojars Project](http://clojars.org/orgpad/volcano/latest-version.svg)](http://clojars.org/orgpad/vulcano)


