/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import org.zeromq.ZMsg;
import org.zeromq.ZThread;

public class ZAuth {
    private ZMQ.Socket pipe;
    private boolean verbose;

    public ZAuth(ZContext ctx) {
        this.pipe = ZThread.fork(ctx, new ZAuthAgent(this), new Object[0]);
        ZMsg msg = ZMsg.recvMsg(this.pipe);
        String response = msg.popString();
        msg.destroy();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        ZMsg msg = new ZMsg();
        msg.add("VERBOSE");
        msg.add(String.format("%b", verbose));
        msg.send(this.pipe);
        msg.destroy();
    }

    public void allow(String address) {
        assert (address != null);
        ZMsg msg = new ZMsg();
        msg.add("ALLOW");
        msg.add(address);
        msg.send(this.pipe);
        msg.destroy();
    }

    public void deny(String address) {
        assert (address != null);
        ZMsg msg = new ZMsg();
        msg.add("DENY");
        msg.add(address);
        msg.send(this.pipe);
        msg.destroy();
    }

    public void configurePlain(String domain, String filename) {
        assert (domain != null);
        assert (filename != null);
        ZMsg msg = new ZMsg();
        msg.add("PLAIN");
        msg.add(domain);
        msg.add(filename);
        msg.send(this.pipe);
        msg.destroy();
    }

    public void destroy() {
        ZMsg request = new ZMsg();
        request.add("TERMINATE");
        request.send(this.pipe);
        request.destroy();
        ZMsg reply = ZMsg.recvMsg(this.pipe);
        reply.destroy();
    }

    public void configureGSSAPI(String domain) {
        assert (domain != null);
        ZMsg msg = new ZMsg();
        msg.add("GSSAPI");
        msg.add(domain);
        msg.send(this.pipe);
        msg.destroy();
    }

    protected boolean authenticateGSS(ZAPRequest request) {
        if (this.verbose) {
            System.out.printf("I: ALLOWED (GSSAPI allow any client) principal = %s identity = %s%n", request.principal, request.identity);
        }
        return true;
    }

    private static class ZAuthAgent
    implements ZThread.IAttachedRunnable {
        private ZMQ.Socket pipe;
        private ZMQ.Socket handler;
        private boolean verbose;
        private ConcurrentMap<String, String> whitelist = new ConcurrentHashMap<String, String>();
        private ConcurrentMap<String, String> blacklist = new ConcurrentHashMap<String, String>();
        private ConcurrentMap<String, String> passwords = new ConcurrentHashMap<String, String>();
        private boolean terminated;
        private File passwords_file;
        private long passwords_modified;
        private final ZAuth auth;

        private ZAuthAgent(ZAuth auth) {
            this.auth = auth;
        }

        private boolean controlMessage() {
            ZMsg msg = ZMsg.recvMsg(this.pipe);
            String command = msg.popString();
            if (command == null) {
                return false;
            }
            if (command.equals("ALLOW")) {
                String address = msg.popString();
                this.whitelist.put(address, "OK");
            } else if (command.equals("DENY")) {
                String address = msg.popString();
                this.blacklist.put(address, "OK");
            } else if (command.equals("PLAIN")) {
                String domain = msg.popString();
                String filename = msg.popString();
                this.passwords_file = new File(filename);
                this.loadPasswords(true);
                ZMsg reply = new ZMsg();
                reply.add("OK");
                reply.send(this.pipe);
                reply.destroy();
            } else if (command.equals("GSSAPI")) {
                String domain = msg.popString();
            } else if (command.equals("VERBOSE")) {
                String verboseStr = msg.popString();
                this.verbose = verboseStr.equals("true");
            } else if (command.equals("TERMINATE")) {
                this.terminated = true;
                ZMsg reply = new ZMsg();
                reply.add("OK");
                reply.send(this.pipe);
                reply.destroy();
            }
            msg.destroy();
            return true;
        }

        private boolean authenticate() {
            ZAPRequest request = ZAPRequest.recvRequest(this.handler);
            if (request == null) {
                return false;
            }
            boolean allowed = false;
            boolean denied = false;
            if (!this.whitelist.isEmpty()) {
                if (this.whitelist.containsKey(request.address)) {
                    allowed = true;
                    if (this.verbose) {
                        System.out.printf("I: PASSED (whitelist) address = %s\n", request.address);
                    }
                } else {
                    denied = true;
                    if (this.verbose) {
                        System.out.printf("I: DENIED (not in whitelist) address = %s\n", request.address);
                    }
                }
            } else if (!this.blacklist.isEmpty()) {
                if (this.blacklist.containsKey(request.address)) {
                    denied = true;
                    if (this.verbose) {
                        System.out.printf("I: DENIED (blacklist) address = %s\n", request.address);
                    }
                } else {
                    allowed = true;
                    if (this.verbose) {
                        System.out.printf("I: PASSED (not in blacklist) address = %s\n", request.address);
                    }
                }
            }
            if (!denied) {
                if (request.mechanism.equals("NULL") && !allowed) {
                    if (this.verbose) {
                        System.out.printf("I: ALLOWED (NULL)\n", new Object[0]);
                    }
                    allowed = true;
                } else if (request.mechanism.equals("PLAIN")) {
                    allowed = this.authenticatePlain(request);
                } else if (!request.mechanism.equals("CURVE")) {
                    if (request.mechanism.equals("GSSAPI")) {
                        allowed = this.auth.authenticateGSS(request);
                    } else {
                        System.out.printf("Skipping unknown mechanism%n", new Object[0]);
                    }
                }
            }
            if (allowed) {
                ZAPRequest.reply(request, "200", "OK");
            } else {
                ZAPRequest.reply(request, "400", "NO ACCESS");
            }
            return true;
        }

        private boolean authenticatePlain(ZAPRequest request) {
            this.loadPasswords(false);
            String password = (String)this.passwords.get(request.username);
            if (password != null && password.equals(request.password)) {
                if (this.verbose) {
                    System.out.printf("ZAUTH I: ALLOWED (PLAIN) username=%s password=%s\n", request.username, request.password);
                }
                return true;
            }
            if (this.verbose) {
                System.out.printf("ZAUTH I: DENIED (PLAIN) username=%s password=%s\n", request.username, request.password);
            }
            return false;
        }

        @Override
        public void run(Object[] args, ZContext ctx, ZMQ.Socket pipe) {
            int rc;
            this.pipe = pipe;
            this.handler = ctx.createSocket(4);
            try {
                this.handler.bind("inproc://zeromq.zap.01");
            }
            catch (ZMQException e) {
                pipe.send("ERROR");
                return;
            }
            pipe.send("OK");
            ZMQ.PollItem[] pollItems = new ZMQ.PollItem[]{new ZMQ.PollItem(pipe, 1), new ZMQ.PollItem(this.handler, 1)};
            while (!(this.terminated || Thread.currentThread().isInterrupted() || (rc = ZMQ.poll((ZMQ.PollItem[])pollItems, (long)-1L)) == -1 || pollItems[0].isReadable() && !this.controlMessage() || pollItems[1].isReadable() && !this.authenticate())) {
            }
        }

        private void loadPasswords(boolean initial) {
            if (!initial) {
                long lastModified = this.passwords_file.lastModified();
                long age = System.currentTimeMillis() - lastModified;
                if (lastModified > this.passwords_modified && age > 1000L) {
                    this.passwords.clear();
                } else {
                    return;
                }
            }
            this.passwords_modified = this.passwords_file.lastModified();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.passwords_file));
                while ((line = br.readLine()) != null) {
                    int equals = line.indexOf(61);
                    if (line.charAt(0) == '#' || equals == -1 || equals == line.length() - 1) continue;
                    this.passwords.put(line.substring(0, equals), line.substring(equals + 1, line.length()));
                }
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ZAPRequest {
        public ZMQ.Socket handler;
        public String version;
        public String sequence;
        public String domain;
        public String address;
        public String identity;
        public String mechanism;
        public String username;
        public String password;
        public String clientKey;
        public String principal;

        static ZAPRequest recvRequest(ZMQ.Socket handler) {
            if (ZMQ.getMajorVersion() == 4) {
                ZMsg request = ZMsg.recvMsg(handler);
                ZAPRequest self = new ZAPRequest();
                self.handler = handler;
                self.version = request.popString();
                self.sequence = request.popString();
                self.domain = request.popString();
                self.address = request.popString();
                self.identity = request.popString();
                self.mechanism = request.popString();
                assert (self.version.equals("1.0"));
                if (self.mechanism.equals("PLAIN")) {
                    self.username = request.popString();
                    self.password = request.popString();
                } else if (!self.mechanism.equals("CURVE") && self.mechanism.equals("GSSAPI")) {
                    self.principal = request.popString();
                }
                request.destroy();
                return self;
            }
            return null;
        }

        static void reply(ZAPRequest request, String statusCode, String statusText) {
            if (request == null) {
                return;
            }
            ZMsg msg = new ZMsg();
            msg.add("1.0");
            msg.add(request.sequence);
            msg.add(statusCode);
            msg.add(statusText);
            msg.add("");
            msg.add("");
            msg.send(request.handler);
        }
    }
}

