(ns clj-opentracing.singleton-tracer
  (:require [clj-opentracing.explicit-tracer :as tracing])
  (:import (io.opentracing.propagation Format$Builtin)))


(def *tracer nil)


(defn set-tracer! [tracer]
  (alter-var-root #'*tracer (constantly tracer)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Before using any of the functions below, set your tracer: (set-tracer! tracer)


(defn set-tag! [k v]
  (tracing/set-tag! *tracer k v))


(defn set-tags! [tag-map]
  (tracing/set-tags! *tracer tag-map))


(defn log!
  ([string-or-map]
   (tracing/log! *tracer string-or-map))
  ([timestamp string-or-map]
   (tracing/log! *tracer timestamp string-or-map)))


(defmacro with-span [span-name & body]
  `(tracing/with-span *tracer ~span-name ~@body))


(defmacro with-child-span [span-name parent-span-or-context & body]
  `(tracing/with-child-span *tracer ~span-name ~parent-span-or-context ~@body))


(defn wrap-span [handler span-name tags]
  (tracing/wrap-span handler *tracer span-name tags))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Using parent spans created by our server's clients


(defn headers->span-context [headers]
  (tracing/headers->span-context *tracer headers))

(defn text-map->span-context [text-map]
  (tracing/text-map->span-context *tracer text-map))

(defn wrap-span-from-request [handler span-name additional-tags]
  (tracing/wrap-span-from-request handler *tracer span-name additional-tags))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; For us as a client to include our current span context in a HTTP request to another service


(defn get-span-context-headers [span]
  (tracing/get-span-context *tracer span Format$Builtin/HTTP_HEADERS))

(defn get-current-span-context-headers []
  (tracing/get-current-span-context-headers *tracer))

(defn get-current-span-context-text-map []
  (tracing/get-current-span-context-text-map *tracer))

(defn get-span-context-text-map [span]
  (tracing/get-span-context *tracer span Format$Builtin/TEXT_MAP))
