/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.stub;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.webbitserver.HttpResponse;

public class StubHttpResponse
implements HttpResponse {
    private Charset charset = Charset.forName("UTF-8");
    private int status = 200;
    private Map<String, String> headers = new HashMap<String, String>();
    private Throwable error;
    private boolean ended;
    private ByteArrayOutputStream contents = new ByteArrayOutputStream();

    @Override
    public StubHttpResponse charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public StubHttpResponse status(int status) {
        this.status = status;
        return this;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public StubHttpResponse header(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.put(name, value);
        }
        return this;
    }

    @Override
    public StubHttpResponse header(String name, long value) {
        return this.header(name, String.valueOf(value));
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public boolean hasHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public StubHttpResponse content(String content) {
        return this.content(content.getBytes(this.charset));
    }

    @Override
    public StubHttpResponse content(byte[] content) {
        try {
            this.contents.write(content);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return this;
    }

    public byte[] contents() {
        return this.contents.toByteArray();
    }

    public String contentsString() {
        return new String(this.contents(), this.charset);
    }

    @Override
    public StubHttpResponse error(Throwable error) {
        this.error = error;
        this.status = 500;
        String message = error.toString();
        this.content(message);
        this.header("Content-Type", "text/plain");
        this.header("Content-Length", message.length());
        this.ended = true;
        return this;
    }

    public Throwable error() {
        return this.error;
    }

    @Override
    public StubHttpResponse end() {
        this.ended = true;
        return this;
    }

    public boolean ended() {
        return this.ended;
    }

    public String toString() {
        return "StubHttpResponse{charset=" + this.charset + ", status=" + this.status + ", headers=" + this.headers + ", error=" + this.error + ", ended=" + this.ended + ", contents=" + this.contentsString() + '}';
    }
}

