/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelHandlerContext;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import org.webbitserver.netty.NettyHttpRequest;

public class NettyWebSocketConnection
implements WebSocketConnection {
    private final Executor executor;
    private final NettyHttpRequest nettyHttpRequest;
    private final ChannelHandlerContext ctx;

    public NettyWebSocketConnection(Executor executor, NettyHttpRequest nettyHttpRequest, ChannelHandlerContext ctx) {
        this.executor = executor;
        this.nettyHttpRequest = nettyHttpRequest;
        this.ctx = ctx;
    }

    @Override
    public NettyHttpRequest httpRequest() {
        return this.nettyHttpRequest;
    }

    @Override
    public WebSocketConnection send(String message) {
        this.ctx.getChannel().write(new DefaultWebSocketFrame(message));
        return this;
    }

    @Override
    public WebSocketConnection close() {
        this.ctx.getChannel().close();
        return this;
    }

    @Override
    public Map<String, Object> data() {
        return this.nettyHttpRequest.data();
    }

    @Override
    public Object data(String key) {
        return this.data().get(key);
    }

    @Override
    public NettyWebSocketConnection data(String key, Object value) {
        this.data().put(key, value);
        return this;
    }

    @Override
    public Set<String> dataKeys() {
        return this.data().keySet();
    }

    @Override
    public Executor handlerExecutor() {
        return this.executor;
    }

    @Override
    public void execute(Runnable command) {
        this.handlerExecutor().execute(command);
    }
}

