/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.nio.channels.ClosedChannelException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.dependencies.org.jboss.netty.buffer.ChannelBuffer;
import org.webbitserver.dependencies.org.jboss.netty.buffer.ChannelBuffers;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelHandler;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelHandlerContext;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelPipeline;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelStateEvent;
import org.webbitserver.dependencies.org.jboss.netty.channel.ExceptionEvent;
import org.webbitserver.dependencies.org.jboss.netty.channel.MessageEvent;
import org.webbitserver.dependencies.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpRequest;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpResponse;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.websocket.WebSocketFrameDecoder;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.websocket.WebSocketFrameEncoder;
import org.webbitserver.netty.NettyHttpRequest;

public class NettyWebSocketChannelHandler
extends SimpleChannelUpstreamHandler {
    private final Executor executor;
    private final NettyHttpRequest nettyHttpRequest;
    private final WebSocketHandler handler;
    private final WebSocketConnection webSocketConnection;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Thread.UncaughtExceptionHandler ioExceptionHandler;

    public NettyWebSocketChannelHandler(Executor executor, ChannelHandlerContext ctx, NettyHttpRequest nettyHttpRequest, HttpRequest request, HttpResponse response, WebSocketHandler handler, WebSocketConnection webSocketConnection, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler) {
        this.executor = executor;
        this.nettyHttpRequest = nettyHttpRequest;
        this.handler = handler;
        this.webSocketConnection = webSocketConnection;
        this.exceptionHandler = exceptionHandler;
        this.ioExceptionHandler = ioExceptionHandler;
        if (!this.requestingWebsocketUpgrade(request)) {
            throw new RuntimeException("Expecting WebSocket upgrade. Looks like a standard HTTP request.");
        }
        if (this.isNewSkoolWebSocketRequest(request)) {
            this.upgradeResponseNewSkool(request, response);
        } else {
            this.upgradeResponseOldSkool(request, response);
        }
        ChannelPipeline p = ctx.getChannel().getPipeline();
        p.remove("aggregator");
        p.replace("decoder", "wsdecoder", (ChannelHandler)new WebSocketFrameDecoder());
        p.replace("handler", "wshandler", (ChannelHandler)this);
        ctx.getChannel().write(response);
        p.replace("encoder", "wsencoder", (ChannelHandler)new WebSocketFrameEncoder());
        try {
            handler.onOpen(this.webSocketConnection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean requestingWebsocketUpgrade(HttpRequest request) {
        return "Upgrade".equalsIgnoreCase(request.getHeader("Connection")) && "WebSocket".equalsIgnoreCase(request.getHeader("Upgrade"));
    }

    private boolean isNewSkoolWebSocketRequest(HttpRequest req) {
        return req.containsHeader("Sec-WebSocket-Key1") && req.containsHeader("Sec-WebSocket-Key2");
    }

    private void upgradeResponseNewSkool(HttpRequest req, HttpResponse res) {
        res.setStatus(new HttpResponseStatus(101, "Web Socket Protocol Handshake"));
        res.addHeader("Upgrade", "WebSocket");
        res.addHeader("Connection", "Upgrade");
        res.addHeader("Sec-WebSocket-Origin", req.getHeader("Origin"));
        res.addHeader("Sec-WebSocket-Location", this.getWebSocketLocation(req));
        String protocol = req.getHeader("Sec-WebSocket-Protocol");
        if (protocol != null) {
            res.addHeader("Sec-WebSocket-Protocol", protocol);
        }
        String key1 = req.getHeader("Sec-WebSocket-Key1");
        String key2 = req.getHeader("Sec-WebSocket-Key2");
        int a = (int)(Long.parseLong(key1.replaceAll("[^0-9]", "")) / (long)key1.replaceAll("[^ ]", "").length());
        int b = (int)(Long.parseLong(key2.replaceAll("[^0-9]", "")) / (long)key2.replaceAll("[^ ]", "").length());
        long c = req.getContent().readLong();
        ChannelBuffer input = ChannelBuffers.buffer(16);
        input.writeInt(a);
        input.writeInt(b);
        input.writeLong(c);
        try {
            ChannelBuffer output = ChannelBuffers.wrappedBuffer(MessageDigest.getInstance("MD5").digest(input.array()));
            res.setContent(output);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private void upgradeResponseOldSkool(HttpRequest req, HttpResponse res) {
        res.setStatus(new HttpResponseStatus(101, "Web Socket Protocol Handshake"));
        res.addHeader("Upgrade", "WebSocket");
        res.addHeader("Connection", "Upgrade");
        res.addHeader("WebSocket-Origin", req.getHeader("Origin"));
        res.addHeader("WebSocket-Location", this.getWebSocketLocation(req));
        String protocol = req.getHeader("WebSocket-Protocol");
        if (protocol != null) {
            res.addHeader("WebSocket-Protocol", protocol);
        }
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.getHeader("Host") + req.getUri();
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, final MessageEvent e) throws Exception {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    NettyWebSocketChannelHandler.this.handler.onMessage(NettyWebSocketChannelHandler.this.webSocketConnection, ((WebSocketFrame)e.getMessage()).getTextData());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    NettyWebSocketChannelHandler.this.handler.onClose(NettyWebSocketChannelHandler.this.webSocketConnection);
                }
                catch (Exception e1) {
                    NettyWebSocketChannelHandler.this.exceptionHandler.uncaughtException(Thread.currentThread(), e1);
                }
            }
        });
    }

    public String toString() {
        return this.nettyHttpRequest.toString();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, final ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof ClosedChannelException) {
            e.getChannel().close();
        } else {
            final Thread thread = Thread.currentThread();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    NettyWebSocketChannelHandler.this.ioExceptionHandler.uncaughtException(thread, e.getCause());
                }
            });
        }
    }
}

