/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.Iterator;
import java.util.concurrent.Executor;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelHandlerContext;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.webbitserver.netty.NettyHttpRequest;
import org.webbitserver.netty.NettyHttpResponse;
import org.webbitserver.netty.NettyWebSocketChannelHandler;
import org.webbitserver.netty.NettyWebSocketConnection;

public class NettyHttpControl
implements HttpControl {
    private final Iterator<HttpHandler> handlerIterator;
    private final Executor executor;
    private final ChannelHandlerContext ctx;
    private final NettyHttpRequest nettyHttpRequest;
    private final org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpRequest httpRequest;
    private final DefaultHttpResponse defaultHttpResponse;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Thread.UncaughtExceptionHandler ioExceptionHandler;
    private HttpRequest defaultRequest;
    private HttpResponse defaultResponse;
    private HttpControl defaultControl;

    public NettyHttpControl(Iterator<HttpHandler> handlerIterator, Executor executor, ChannelHandlerContext ctx, NettyHttpRequest nettyHttpRequest, NettyHttpResponse nettyHttpResponse, org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpRequest httpRequest, DefaultHttpResponse defaultHttpResponse, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler) {
        this.handlerIterator = handlerIterator;
        this.executor = executor;
        this.ctx = ctx;
        this.nettyHttpRequest = nettyHttpRequest;
        this.httpRequest = httpRequest;
        this.defaultHttpResponse = defaultHttpResponse;
        this.defaultRequest = nettyHttpRequest;
        this.defaultResponse = nettyHttpResponse;
        this.ioExceptionHandler = ioExceptionHandler;
        this.defaultControl = this;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void nextHandler() {
        this.nextHandler(this.defaultRequest, this.defaultResponse, this.defaultControl);
    }

    @Override
    public void nextHandler(HttpRequest request, HttpResponse response) {
        this.nextHandler(request, response, this.defaultControl);
    }

    @Override
    public void nextHandler(HttpRequest request, HttpResponse response, HttpControl control) {
        this.defaultRequest = request;
        this.defaultResponse = response;
        this.defaultControl = control;
        if (this.handlerIterator.hasNext()) {
            HttpHandler handler = this.handlerIterator.next();
            try {
                handler.handleHttpRequest(request, response, control);
            }
            catch (Throwable e) {
                response.error(e);
            }
        } else {
            response.status(404).end();
        }
    }

    @Override
    public NettyWebSocketConnection upgradeToWebSocketConnection(WebSocketHandler handler) {
        NettyWebSocketConnection webSocketConnection = this.createWebSocketConnection();
        new NettyWebSocketChannelHandler(this.executor, this.ctx, this.nettyHttpRequest, this.httpRequest, this.defaultHttpResponse, handler, webSocketConnection, this.exceptionHandler, this.ioExceptionHandler);
        return webSocketConnection;
    }

    @Override
    public NettyWebSocketConnection createWebSocketConnection() {
        return new NettyWebSocketConnection(this.executor, this.nettyHttpRequest, this.ctx);
    }

    @Override
    public Executor handlerExecutor() {
        return this.executor;
    }

    @Override
    public void execute(Runnable command) {
        this.handlerExecutor().execute(command);
    }
}

