/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.Executor;
import org.webbitserver.HttpHandler;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelHandlerContext;
import org.webbitserver.dependencies.org.jboss.netty.channel.ExceptionEvent;
import org.webbitserver.dependencies.org.jboss.netty.channel.MessageEvent;
import org.webbitserver.dependencies.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpRequest;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpVersion;
import org.webbitserver.netty.NettyHttpControl;
import org.webbitserver.netty.NettyHttpRequest;
import org.webbitserver.netty.NettyHttpResponse;

public class NettyHttpChannelHandler
extends SimpleChannelUpstreamHandler {
    private final Executor executor;
    private final List<HttpHandler> httpHandlers;
    private final Object id;
    private final long timestamp;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Thread.UncaughtExceptionHandler ioExceptionHandler;

    public NettyHttpChannelHandler(Executor executor, List<HttpHandler> httpHandlers, Object id, long timestamp, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler) {
        this.executor = executor;
        this.httpHandlers = httpHandlers;
        this.id = id;
        this.timestamp = timestamp;
        this.exceptionHandler = exceptionHandler;
        this.ioExceptionHandler = ioExceptionHandler;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        HttpRequest httpRequest = (HttpRequest)messageEvent.getMessage();
        final NettyHttpRequest nettyHttpRequest = new NettyHttpRequest(messageEvent, httpRequest, this.id, this.timestamp);
        final NettyHttpResponse nettyHttpResponse = new NettyHttpResponse(ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), this.exceptionHandler);
        final NettyHttpControl control = new NettyHttpControl(this.httpHandlers.iterator(), this.executor, ctx, nettyHttpRequest, nettyHttpResponse, httpRequest, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), this.exceptionHandler, this.ioExceptionHandler);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    control.nextHandler(nettyHttpRequest, nettyHttpResponse);
                }
                catch (Exception exception) {
                    NettyHttpChannelHandler.this.exceptionHandler.uncaughtException(Thread.currentThread(), exception);
                }
            }
        });
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, final ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof ClosedChannelException) {
            e.getChannel().close();
        } else {
            final Thread thread = Thread.currentThread();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    NettyHttpChannelHandler.this.ioExceptionHandler.uncaughtException(thread, e.getCause());
                }
            });
        }
    }
}

