/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;

public abstract class AbstractResourceHandler
implements HttpHandler {
    public static final Map<String, String> DEFAULT_MIME_TYPES;
    protected static final String DEFAULT_WELCOME_FILE_NAME = "index.html";
    protected final Executor ioThread;
    protected final Map<String, String> mimeTypes;
    protected String welcomeFileName;

    public AbstractResourceHandler(Executor ioThread) {
        this.ioThread = ioThread;
        this.mimeTypes = new HashMap<String, String>(DEFAULT_MIME_TYPES);
        this.welcomeFileName = DEFAULT_WELCOME_FILE_NAME;
    }

    public AbstractResourceHandler addMimeType(String extension, String mimeType) {
        this.mimeTypes.put(extension, mimeType);
        return this;
    }

    public AbstractResourceHandler welcomeFile(String welcomeFile) {
        this.welcomeFileName = welcomeFile;
        return this;
    }

    @Override
    public void handleHttpRequest(HttpRequest request, HttpResponse response, HttpControl control) throws Exception {
        this.ioThread.execute(this.createIOWorker(request, response, control));
    }

    protected abstract IOWorker createIOWorker(HttpRequest var1, HttpResponse var2, HttpControl var3);

    static {
        HashMap<String, String> mimeTypes = new HashMap<String, String>();
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("csv", "text/csv");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("xml", "text/xml");
        mimeTypes.put("js", "text/javascript");
        mimeTypes.put("xhtml", "application/xhtml+xml");
        mimeTypes.put("json", "application/json");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("tar", "application/x-tar");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("svg", "image/svg+xml");
        mimeTypes.put("ico", "image/vnd.microsoft.icon");
        DEFAULT_MIME_TYPES = Collections.unmodifiableMap(mimeTypes);
    }

    protected abstract class IOWorker
    implements Runnable {
        protected String path;
        protected final HttpResponse response;
        protected final HttpControl control;

        protected IOWorker(String path, HttpResponse response, HttpControl control) {
            this.path = path;
            this.response = response;
            this.control = control;
        }

        protected void notFound() {
            this.control.execute(new Runnable(){

                @Override
                public void run() {
                    IOWorker.this.control.nextHandler();
                }
            });
        }

        protected void serve(final String mimeType, final byte[] contents) {
            this.control.execute(new Runnable(){

                @Override
                public void run() {
                    IOWorker.this.response.header("Content-Type", mimeType).header("Content-Length", contents.length).content(contents).end();
                }
            });
        }

        protected void error(final IOException exception) {
            this.control.execute(new Runnable(){

                @Override
                public void run() {
                    IOWorker.this.response.error(exception);
                }
            });
        }

        @Override
        public void run() {
            this.path = this.withoutTrailingSlashOrQuery(this.path);
            try {
                byte[] content = null;
                if (!this.exists()) {
                    this.notFound();
                } else {
                    content = this.fileBytes();
                    if (content != null) {
                        this.serve(this.guessMimeType(this.path), content);
                    } else {
                        content = this.welcomeBytes();
                        if (content != null) {
                            this.serve(this.guessMimeType(AbstractResourceHandler.this.welcomeFileName), content);
                        } else {
                            this.notFound();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.error(e);
            }
        }

        protected abstract boolean exists() throws IOException;

        protected abstract byte[] fileBytes() throws IOException;

        protected abstract byte[] welcomeBytes() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] read(int length, InputStream in) throws IOException {
            byte[] data = new byte[length];
            try {
                in.read(data);
            }
            finally {
                in.close();
            }
            return data;
        }

        private String guessMimeType(String path) {
            int lastDot = path.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            String extension = path.substring(lastDot + 1).toLowerCase();
            String mimeType = AbstractResourceHandler.this.mimeTypes.get(extension);
            if (mimeType == null) {
                return null;
            }
            if (mimeType.startsWith("text/") && this.response.charset() != null) {
                mimeType = mimeType + "; charset=" + this.response.charset().name();
            }
            return mimeType;
        }

        protected String withoutTrailingSlashOrQuery(String path) {
            int queryStart = path.indexOf(63);
            if (queryStart > -1) {
                path = path.substring(0, queryStart);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
    }
}

