(ns datamos.module-helpers
  (:require [datamos
             [rdf-function :as rdf-fn]
             [messaging :as dm]]
            [taoensso.timbre :as log]))

(defn retrieve-prefixes
  [rdf-map]
  (mapv keyword
       (set (keep namespace
                  (filter keyword?
                          (tree-seq coll? seq
                                    rdf-map))))))

(defn private-register
  [lr]
  (fn [_ _ message]
    (let [rdf-content (rdf-fn/message-content message)
          r           @lr
          values      (rdf-fn/values-by-predicate :dms-def/function
                                                  rdf-content
                                                  r)]
      (log/debug "@private-register" rdf-content r values)
      (log/trace "@private-register" (log/get-env))
      (when (apply = values)
        (do
          (log/debug "@private-register - duplicate module-fns" rdf-content values)
          (swap! lr (fn [m]
                      (dissoc m
                              (first (rdf-fn/subject-object-by-predicate m :dms-def/function)))))))
      (swap! lr conj rdf-content))))

(defn local-module-register
  [local-register]
  {:datamos-fn/registry (private-register local-register)})