(ns org.usfinformatics.clinicaltrialgov.Main
  (:require [clinicaltrials-gov.core :as c]
            [clinicaltrials-gov.data :as d])
  (:import [org.usfinformatics.clinicaltrialgov Record]
           [java.util List]
           )
  (:gen-class
    :prefix "-"
    :methods [^:static [searchOpenTrials [String] java.util.List]]
    ))

(defn ^:private ->Record
  [z]
  (reify Record
    (getNCTID [this] (d/nct-id z))
    (getOrgStudyID [this] (d/org-study-id z))
    (getBriefTitle [this] (d/brief-title z))
    (getOfficialTitle [this] (d/official-title z))
    (getLeadSponsor [this] (d/lead-sponsor z))
    (getBriefSummary [this] (d/brief-summary z))
    (getOverallStatus [this] (d/overall-status z))
    (getPhase [this] (d/phase z))
    (getStudyType [this] (d/study-type z))
    (getStudyDesign [this] (d/study-design z))
    (getCondition [this] (d/condition z))
    (getEligibilityText [this] (d/eligibility-text z))
    (getEligibilityGender [this] (d/eligibility-gender z))
    (getEligibilityMinAge [this] (d/eligibility-min-age z))
    (getEligibilityMaxAge [this] (d/eligibility-max-age z))
    (getEligibilityHealthyVolunteers [this] (d/eligibility-healthy-volunteers? z))
    ))

(defn ^List -searchOpenTrials
  [^String terms]
  (let [results (c/search terms [:open :exclude-unknown])]
    (mapv ->Record results)))