;;   Copyright (c) Dragan Djuric. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php) or later
;;   which can be found in the file LICENSE at the root of this distribution.
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any other, from this software.

(defproject org.uncomplicate/neanderthal-openblas "0.54.0-SNAPSHOT"
  :description "Neanderthal's OpenBLAS engine."
  :url "https://github.com/uncomplicate/neanderthal/neanderthal-openblas"
  :scm {:name "git"
        :url "https://github.com/uncomplicate/neanderthal"}
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :plugins [[lein-parent "0.3.9"]]

  :parent-project {:path "../neanderthal-base/project.clj"
                   :inherit [:managed-dependencies :dependencies :plugins :repositories
                             :javac-options :license :scm [:profiles :dev/all]
                             [:profiles :dev] [:profiles :linux] [:profiles :windows] [:profiles :macosx]]}

  :dependencies [[org.uncomplicate/neanderthal-base]
                 [org.bytedeco/openblas-platform]]

  :profiles {:dev [:dev/all ~(leiningen.core.utils/get-os)]
             :dev/all {:dependencies [[org.uncomplicate/neanderthal-test]]}
             :linux {:dependencies [[org.bytedeco/openblas :classifier linux-x86_64]]}
             :windows {:dependencies [[org.bytedeco/openblas :classifier windows-x86_64]]}
             :macosx {:dependencies [[org.bytedeco/openblas :classifier macosx-arm64]]}})
