// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package uncomplicate.javacpp.accelerate.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class vimage extends uncomplicate.javacpp.accelerate.presets.vimage {
    static { Loader.load(); }

// Parsed from vImage_Types.h

/**
 *  \header vImage_Types.h
 *  vImage_Framework
 *
 *  See vImage/vImage.h for more on how to view the headerdoc documentation for types declared herein.
 *
 *  \copyright Copyright (c) 2002-2016 by Apple Inc. All rights reserved.
 *
 *  \discussion     Defines various types and constants common to vImage.
 */

// #ifndef VIMAGE_TYPES_H
// #define VIMAGE_TYPES_H

// #ifdef __cplusplus
// #endif

// #include <stdbool.h>
// #include <stdint.h>
// #include <stddef.h>
// #include <unistd.h>

// #include <TargetConditionals.h>


// #if __has_include(<os/availability.h>) && !defined(__linux__) && !0 && !0
// #    include <os/availability.h>
// #else
// #    ifndef  __API_AVAILABLE
// #    define __API_AVAILABLE(...)
// #    endif

// #    ifndef  API_AVAILABLE
// #    define API_AVAILABLE(...) /* nothing */
// #    endif
// #endif // __has_include(<os/availability.h>)

/**
 *  \define     __has_attribute
 *  \abstract   Compiler attribute detection
 *  \discussion A macro for testing whether your compiler supports a particular clang attribute.
 *  \noParse
 */

// #ifndef __has_attribute          /* clang will define this. Other compilers maybe not. */
//     #define __has_attribute(a)   0
// #endif
    
/**
 *  \define     VIMAGE_NON_NULL
 *  \abstract   Enumerates which parameters may not be NULL.
 *  \discussion Macro to use to decorate API for sanity checking. Many vImage pointer operands may not be NULL.
 *  \noParse
 *  \ignorefuncmacro VIMAGE_NON_NULL
 */
// #if __has_attribute(nonnull)
// #   define VIMAGE_NON_NULL(...)         __attribute__ ((nonnull(__VA_ARGS__)))
// #else
// #   define VIMAGE_NON_NULL(...)
// #endif

/**
 *  \define     __has_feature
 *  \abstract   Compiler feature detection
 *  \discussion A macro for testing whether your compiler supports a particular clang feature.
 *  \noParse
 */

// #ifndef __has_feature           /* clang will define this. Other compilers maybe not. */
// #   define __has_feature(f)     0
// #endif
// #ifndef __has_extension         /* clang will define this. Other compilers maybe not. */
// #   define __has_extension(e)   0
// #endif

/**
 *  \define     CF_BRIDGED_TYPE
 *  \abstract   CoreFoundation definition detection and aliasing.
 *  \discussion A macro for annotating structs bridging to CoreFoundation types.
 *  \noParse
 */
// #ifndef CF_BRIDGED_TYPE
// #   if __has_feature(objc_bridge_id)
// #       define CF_BRIDGED_TYPE(...) __attribute__((objc_bridge(__VA_ARGS__)))
// #   else
// #       define CF_BRIDGED_TYPE(...)
// #   endif
// #endif
    

    /* The C++'11 strongly typed enum feature turns out to be not exactly what we want because it precludes doing things like kvImageLeaveAlphaUnchanged | kvImageCopyInPlace */
    /* We are still exploring options to deliver something better than what we have today for enums. */
// #if 0 /*(__cplusplus && __cplusplus >= 201103L && (__has_extension(cxx_strong_enums) || __has_feature(objc_fixed_enum))) || (!__cplusplus && __has_feature(objc_fixed_enum))*/
// #else
// #   define VIMAGE_CHOICE_ENUM( _name, _type)        _type _name; enum
// #   define VIMAGE_OPTIONS_ENUM( _name, _type)       _type _name; enum      
// #endif

/**
 *  \availabilitymacro VIMAGE_ENUM_AVAILABLE_STARTING
 */
    
// #if __has_extension(enumerator_attributes)
// #else
// #   define VIMAGE_ENUM_AVAILABLE_STARTING( _a, _b )
// #endif

/*
 *  @vImage function prototype prefix - Currently only set for visibility
 */
    
// #ifndef VIMAGE_PF

// 		#define VIMAGE_PF __attribute__ ((visibility ("default")))

// #endif

/* Please see vImage.h and vImage documentation for the meaning of these types. */

/**
    \typedef vImagePixelCount
    \discussion A number of pixels.  Typically, this is the height or width of an image.
 */       /* Pedantic: A number of pixels. For LP64 (arm64/x86_64) this is a 64-bit quantity.  */

    
/**
    \typedef vImage_Buffer
    \field  data        A pointer to the top left corner of the buffer contain image pixels.
    \field  height      The number of pixels in a column of the image. 
    \field  width       The number of visible pixels in a row of an image (excluding padding at the ends of rows)
    \field  rowBytes    The number of bytes from a pixel to the next pixel down in the same column.
    \discussion The vImage_Buffer describes a rectangular region within a regular array of pixels. It may describe
                the entire image, or just a sub rectangle of it.  The vImage_Buffer struct is not a complete description
                of an image. Other aspects like pixel format, color space, channel ordering, etc. are generally given
                by the names of functions that operate on the vImage_Buffer or by parameters passed to those functions.
                A vImage_Buffer may contain multiple color channels interleaved with one another, or a single color channel
                (or alpha) as a planar buffer.  vImage_Buffers are often initialized directly by you, by setting fields
                to appropriate values to point to image data you already own. Convenience methods are also available as
                vImageBuffer_Init, vImageBuffer_InitWithCGImage and vImageBuffer_InitWithCVPixelBuffer
 */
    

public static class vImage_Buffer extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vImage_Buffer() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vImage_Buffer(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImage_Buffer(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vImage_Buffer position(long position) {
        return (vImage_Buffer)super.position(position);
    }
    @Override public vImage_Buffer getPointer(long i) {
        return new vImage_Buffer((Pointer)this).offsetAddress(i);
    }

    public native Pointer data(); public native vImage_Buffer data(Pointer setter);        /* Pointer to the top left pixel of the buffer.    */
    public native @Cast("vImagePixelCount") long height(); public native vImage_Buffer height(long setter);       /* The height (in pixels) of the buffer        */
    public native @Cast("vImagePixelCount") long width(); public native vImage_Buffer width(long setter);        /* The width (in pixels) of the buffer         */
    public native @Cast("size_t") long rowBytes(); public native vImage_Buffer rowBytes(long setter);     /* The number of bytes in a pixel row, including any unused space between one row and the next. */
}



/**
    \typedef vImage_AffineTransform
    \field  a        top left cell in 3x2 transform matrix
    \field  b        top right cell in 3x2 transform matrix
    \field  c        middle left cell in 3x2 transform matrix
    \field  d        middle right cell in 3x2 transform matrix
    \field  tx       The x coordinate translation
    \field  ty       The y coordinate translation
    \discussion      This 3x2 matrix generally operates the same as the CGAffineTransform, except that the fields
                     are all float, not CGFloat. If you are looking for CGAffineTransform compatibility, it is 
                     recommended that you use vImage_CGAffineTransform and associated APIs instead.
 */
 
public static class vImage_AffineTransform extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vImage_AffineTransform() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vImage_AffineTransform(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImage_AffineTransform(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vImage_AffineTransform position(long position) {
        return (vImage_AffineTransform)super.position(position);
    }
    @Override public vImage_AffineTransform getPointer(long i) {
        return new vImage_AffineTransform((Pointer)this).offsetAddress(i);
    }

    public native float a(); public native vImage_AffineTransform a(float setter);
    public native float b(); public native vImage_AffineTransform b(float setter);
    public native float c(); public native vImage_AffineTransform c(float setter);
    public native float d(); public native vImage_AffineTransform d(float setter);
    public native float tx(); public native vImage_AffineTransform tx(float setter);
    public native float ty(); public native vImage_AffineTransform ty(float setter);
}

/**
  \typedef vImage_AffineTransform_Double
  \field  a        top left cell in 3x2 transform matrix
  \field  b        top right cell in 3x2 transform matrix
  \field  c        middle left cell in 3x2 transform matrix
  \field  d        middle right cell in 3x2 transform matrix
  \field  tx       The x coordinate translation
  \field  ty       The y coordinate translation
  \discussion      This 3x2 matrix generally operates the same as the CGAffineTransform, except that the fields
                    are all double precision, not CGFloat. If you are looking for CGAffineTransform compatibility, it is
                    recommended that you use vImage_CGAffineTransform and associated APIs instead.
*/

     
// #ifndef VIMAGE_AFFINETRANSFORM_DOUBLE_IS_AVAILABLE
    public static final int VIMAGE_AFFINETRANSFORM_DOUBLE_IS_AVAILABLE =      1;     /* defined if vImage_AffineTransform_Double type is available. undefined otherwise */
    public static class vImage_AffineTransform_Double extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public vImage_AffineTransform_Double() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public vImage_AffineTransform_Double(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public vImage_AffineTransform_Double(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public vImage_AffineTransform_Double position(long position) {
            return (vImage_AffineTransform_Double)super.position(position);
        }
        @Override public vImage_AffineTransform_Double getPointer(long i) {
            return new vImage_AffineTransform_Double((Pointer)this).offsetAddress(i);
        }
    
        public native double a(); public native vImage_AffineTransform_Double a(double setter);
        public native double b(); public native vImage_AffineTransform_Double b(double setter);
        public native double c(); public native vImage_AffineTransform_Double c(double setter);
        public native double d(); public native vImage_AffineTransform_Double d(double setter);
        public native double tx(); public native vImage_AffineTransform_Double tx(double setter);
        public native double ty(); public native vImage_AffineTransform_Double ty(double setter);
    }
// #endif

 /**
  \typedef vImage_CGAffineTransform
  \field  a        top left cell in 3x2 transform matrix
  \field  b        top right cell in 3x2 transform matrix
  \field  c        middle left cell in 3x2 transform matrix
  \field  d        middle right cell in 3x2 transform matrix
  \field  tx       The x coordinate translation
  \field  ty       The y coordinate translation
  \discussion      This type mirrors the CGAffineTransform type, and may be used interchangeably with it.
  \seealso         CGAffineTransform utilities in CoreGraphics/CGAffineTransform.h
  */
// #if VIMAGE_AFFINETRANSFORM_DOUBLE_IS_AVAILABLE       /* Interfaces that use this are only available on MacOS X.6 and later */
    public static final int VIMAGE_CGAFFINETRANSFORM_IS_AVAILABLE =			1;
//     #if defined( __LP64__ )
//     #else    
//     #endif
// #endif

/**
 \typedef  vImage_PerpsectiveTransform
 \abstract Coefficients defining the 3x3 perspective (projective) transform matrix
 \field  a        top left cell in 3x3 transform matrix
 \field  b        top middle cell in 3x3 transform matrix
 \field  c        middle left cell in 3x3 transform matrix
 \field  d        middle right cell in 3x3 transform matrix
 \field  tx       The x-coordinate translation
 \field  ty       The y-coordinate translation
 \field  vx      The x-component of the projective vector
 \field  vy      The y-component of the projective vector
 \field  v        The homogeneous scale factor
 */
public static class vImage_PerpsectiveTransform extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vImage_PerpsectiveTransform() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vImage_PerpsectiveTransform(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImage_PerpsectiveTransform(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vImage_PerpsectiveTransform position(long position) {
        return (vImage_PerpsectiveTransform)super.position(position);
    }
    @Override public vImage_PerpsectiveTransform getPointer(long i) {
        return new vImage_PerpsectiveTransform((Pointer)this).offsetAddress(i);
    }

    public native float a(); public native vImage_PerpsectiveTransform a(float setter);
    public native float b(); public native vImage_PerpsectiveTransform b(float setter);
    public native float c(); public native vImage_PerpsectiveTransform c(float setter);
    public native float d(); public native vImage_PerpsectiveTransform d(float setter);
    public native float tx(); public native vImage_PerpsectiveTransform tx(float setter);
    public native float ty(); public native vImage_PerpsectiveTransform ty(float setter);
    public native float vx(); public native vImage_PerpsectiveTransform vx(float setter);
    public native float vy(); public native vImage_PerpsectiveTransform vy(float setter);
    public native float v(); public native vImage_PerpsectiveTransform v(float setter);
}

/**
 \enum       vImage_WarpInterpolation
 \abstract   Constants for selecting the interpolation mode
 \discussion These constants selects the interpolation mode for certain geometry functions like perspective warp
 \constant   kvImageInterpolationNearest      Nearest neigborhood
 \constant   kvImageInterpolationLinear         Linear interpoation
 */ /** enum  */
 public static final int
    kvImageInterpolationNearest      = 0,
    kvImageInterpolationLinear       = 1;


/**
 \typedef   Pixel_8
 \abstract   An 8-bit per component unsigned planar pixel value.
*/            /* 8 bit planar pixel value */

/**
 \typedef   Pixel_F
 \abstract   A single precision floating-point planar pixel value.
 \discussion Typically, these have range [0,1] though other values are generally allowed.
*/            /* floating point planar pixel value */

/**
 \typedef   Pixel_88
 \abstract  A two channel, 8-bit per channel pixel.
 \discussion The channel order is generally given by the function that consumes the value.
 */      /* CbCr interleaved (8 bit/channel) pixel value. uint8_t[2] = { Cb, Cr } */

/**
 \typedef   Pixel_8888
 \abstract  A four channel, 8-bit per channel pixel.
 \discussion The channel order is generally given by the function that consumes the value.
 */      /* ARGB interleaved (8 bit/channel) pixel value. uint8_t[4] = { alpha, red, green, blue } */
 
/**
 \typedef   Pixel_FFFF
 \abstract  A four channel, single precision floating-point per channel pixel. 
 \discussion The channel order is generally given by the function that consumes the value.
 */      /* ARGB interleaved (floating point) pixel value. float[4] = { alpha, red, green, blue } */
 
/**
 \typedef   Pixel_16U
 \abstract  A 16-bit per channel unsigned pixel.  
 \discussion Typical range is [0,USHRT_MAX] meaning [0.0, 1.0], though most functions tolerate other ranges.
*/          /* 16 bit unsigned pixel */

/**
 \typedef   Pixel_16S
 \abstract  A 16-bit per channel signed pixel.  
 \discussion Typical range is [SHRT_MIN,SHRT_MAX] meaning [-1.0, 1.0], though most functions tolerate other ranges.
*/          /* 16 bit signed pixel */

/**
 \typedef   Pixel_16Q12
 \abstract  A signed 16 bit fixed point number with 12 bits of fractional precision.
 \discussion Normal range is [-4096,4096] meaning [-1.0, 1.0]. Values in the range [-8.0, 8.0) are representable.
 */		/* 16 bit signed pixel */

/**
 \typedef   Pixel_16U16U
 \abstract  A two channel, 16-bit per channel pixel.
 \discussion The channel order is generally given by the function that consumes the value.
 */	/* CbCr interleaved (16 bit/channel) pixel value. uint16_t[2] = { Cb, Cr } */

/**
 \typedef   Pixel_16S16S
 \abstract  A two channel, 16-bit per channel signed pixel.
 \discussion The channel order is generally given by the function that consumes the value.
 */    /* CbCr interleaved (16 bit/channel) signed pixel value. int16_t[2] = { Cb, Cr } */

/**
 \typedef   Pixel_32U
 \abstract  Type used for XRGB2101010 format.
 \discussion Typical range for RGB channels is [0,1023] meaning [0.0, 1.0], though most functions tolerate other ranges.
*/          /* 32 bit unsigned pixel */

/**
 \typedef   Pixel_ARGB_16U
 \abstract  A four channel, 16-bit unsigned per channel pixel.  
 \discussion The channel order is generally given by the function that consumes the value. It is not necessarily ARGB.
 */  /* four-channel 16-bit unsigned pixel */

/**
 \typedef   Pixel_ARGB_16S
 \abstract  A four channel, 16-bit signed per channel pixel.  
 \discussion The channel order is generally given by the function that consumes the value. It is not necessarily ARGB.
*/  /* four-channel 16-bit signed pixel */

/**
 \typedef    Pixel_16F
 \abstract   A 16-bit half precision floating-point planar pixel value.
 \discussion Typically, these have range [0,1] though other values are generally allowed.
             Defined as a 16-bit integer since this is a storage format only.
 */            /* 16-bit floating point planar pixel value */

/**
 \typedef   Pixel_16F16F
 \abstract  A two-channel, 16-bit floating-point per channel pixel.
 \discussion The channel order is generally given by the function that consumes the value.
 */    /* CbCr interleaved 16-bit floating point per channel pixel value. uint16_t[2] = { Cb, Cr } */

/**
 \typedef   Pixel_ARGB_16F
 \abstract  A four-channel, 16-bit floating-point per channel pixel.
 \discussion The channel order is generally given by the function that consumes the value.
 */    /* ARGB interleaved 16-bit floating point per channel pixel value. uint16_t[2] = { Cb, Cr } */


/**
 \typedef   Pixel_FF
 \abstract  A two-channel, single precision floating-point per channel pixel.
 \discussion The channel order is generally given by the function that consumes the value.
 */      /* CbCr interleaved (floating point) pixel value. float[2] = { Cb, Cr } */

/**
 \typedef ResamplingFilter
 \abstract A ResamplingFilter is an opaque structure used by vImage to hold precalculated filter coefficients for a resampling filter,
             such as a Lanczos or Gaussian resampling filter. 
 \discussion It is created with vImageNewResamplingFilter or vImageNewResamplingFilterUsingBuffer and is consumed by various vertical 
             and horizontal shear functions in vImage/Geometry.h. When possible, for better performance, reuse ResamplingFilters over 
             multiple vImage calls, instead of allocating a new one each time.
*/
    
@Namespace @Name("void") @Opaque public static class ResamplingFilter extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public ResamplingFilter() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ResamplingFilter(Pointer p) { super(p); }
}   /* Used by certain Geometry functions.  */

    
/**
 \typedef GammaFunction
 \discussion A GammaFunction is an opaque structure used by vImage to represent an approximation of a non-linear curve. It is created with
             vImageCreateGammaFunction, and destroyed with vImageDestroyGammaFunction. When possible, for better performance,
             reuse GammaFunctions over multiple vImage function calls, instead of creating a new one each time.
 */
    
@Namespace @Name("void") @Opaque public static class GammaFunction extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public GammaFunction() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GammaFunction(Pointer p) { super(p); }
}      /* Used by vImageGamma                  */

/* vImage Errors                                                                                */
/* ============                                                                                 */
/*   All return values < 0 indicate failure. In this case, the results in the destination       */
/*   buffer are undefined. The list of error codes may grow in the future.                      */
/*                                                                                              */
/*   Note: It is also possible for positive non-zero numbers to be returned out the LHS of a    */
/*   vImage function. This happens when the kvImageGetTempBufferSize bit is set in the flags.   */
/*   In this case, no work is done by the vImage function.  The value returned is the size of   */
/*   the temp buffer needed by the function.                                                    */
/**
     \typedef   vImage_Error 
     \abstract  An error code returned by a vImage function.
     \discussion    All negative values are errors.
                    Positive return values are likely to be the result of kvImageGetTempBufferSize.
                    Zero indicates no error, or quasi-ambiguously a zero temp buffer size, if that
                    flag was passed. Please see the documentation for the function that returned the
                    error code for additional information about the error.
 
    \constant   kvImageNoError      Success.  If kvImageGetTempBufferSize is set in flags, then
                                    it indicates the temp buffer size is 0 and the function did
                                    nothing else.
    \constant   kvImageRoiLargerThanInputBuffer     The size or positioning of the result buffer 
                                    was such that pixels were needed in the source buffer, were
                                    found to be missing and could not be discovered using an edging
                                    process like kvImageEdgeExtend. Typically, this means that the
                                    source image was smaller than the destination image. 
    \constant   kvImageInvalidKernelSize    The size of a kernel was invalid. Typically, kernels have
                                    have an odd number of rows and columns. The kernel might also have
                                    been too large or of zero dimension. Typically only returned by
                                    convolutions and morphological operations.
 
    \constant   kvImageInvalidEdgeStyle   The edging style {kvImageBackgroundColorFill, kvImageCopyInPlace, kvImageEdgeExtend, kvImageTruncateKernel}
                                    was invalid. Typically, the edging style is either missing or the edging style 
                                    is not supported by this function.
 
    \constant   kvImageInvalidOffset_X   Some functions take an integer offset in the horizontal dimension. This indicates
                                    how far from the left edge of the vImage_Buffer we shoud consider the origin to be.
                                    The offset allows real pixel data to be used where an edging method like kvImageEdgeExtend
                                    might otherwise have to be used to generate missing pixels. An X offset is essential to
                                    obtaining correct results for tiled image processing when the tile is not at the left
                                    edge of the (whole) image and the function has a kernel or ResamplingFilter.
                                    Typically, this can happen when the offset is negative or larger than the source vImage_Buffer.width.
 
    \constant   kvImageInvalidOffset_Y   Some functions take an integer offset in the vertical dimension. This indicates
                                    how far from the top edge of the vImage_Buffer we shoud consider the origin to be.
                                    The offset allows real pixel data to be used where an edging method like kvImageEdgeExtend
                                    might otherwise have to be used to generate missing pixels. A Y offset is essential to
                                    obtaining correct results for tiled image processing when the tile is not at the top
                                    edge of the (whole) image and the function has a kernel or ResamplingFilter.
                                    Typically, this can happen when the offset is negative or larger than the source vImage_Buffer.height.
 
    \constant   kvImageMemoryAllocationError    vImage attempted to allocate memory and the allocator failed, returning NULL.
 
    \constant   kvImageNullPointerArgument      One or more arguments to the function are NULL, which are not allowed to be NULL.
                                    Typically, arguments that are not allowed to be NULL are listed in the VIMAGE_NON_NULL() attribute
                                    that follows the function declaration.
 
    \constant   kvImageInvalidParameter         A function parameter has an invalid value. This is the fallback error code when there is not
                                    an error code that more precisely describes the invalid parameter value such as kvImageNullPointerArgument,
                                    kvImageInvalidEdgeStyle, kvImageInvalidRowBytes, etc.
 
    \constant   kvImageBufferSizeMismatch       This most often occurs when a set of planar buffers are not the same size.  Most often
                                    this occurs when the destination image is planar and the destination planes are not the same size.
                                    It may also occur in rare cases when chunk sizes mismatch for some high level conversions.
 
    \constant   kvImageUnknownFlagsBit      A bit in the flags field is set, which the function does not understand or currently support.
                                    Please check flags enum availability info to make sure the flag is supported on the target OS revision.
 
    \constant   kvImageInternalError    A serious error occured inside vImage, which prevented vImage from continuing. This error is
                                    probably a problem with vImage itself, and not how it is being used. Please file a bug with a
                                    reproducible test case attached, if possible!
 
    \constant   kvImageInvalidRowBytes  The vImage_Buffer.rowBytes field is invalid. In some circumstances, rowBytes of 0 is not supported, 
                                    particularly with destination images or when vImage is asked to initialize a vImage_Buffer and the
                                    rowBytes is too small to hold a row of image data.
 
    \constant   kvImageInvalidImageFormat  Usually a vImage_CGImageFormat or vImageCVImageFormatRef contains an invalid format. It might be a
                                    NULL pointer, a description which is not allowed according to rules of CG or CV image format encodings.
 
    \constant   kvImageColorSyncIsAbsent    ColorSync.framework is completely missing. Certain operations will not work.
 
    \constant   kvImageOutOfPlaceOperationRequired   The source images and destination images may not alias the same image data. This will
                                    be returned by vImageCGConverter_MustOperateOutOfPlace(). However, there are many functions in vImage
                                    that do not work in place which do not check to see if the buffers overlap. Please inspect the documentation
                                    of each function for notes on in-place usage before using them that way.
 
    \constant   kvImageInvalidImageObject   An invalid CGImageRef or CVPixelBufferRef was passed to the function.  Typically, the object was NULL.
                                    A non-NULL invalid CGImageRef or CVPixelBufferRef will result in undefined behavior.
 
    \constant   kvImageInvalidCVImageFormat A vImageCVImageFormatRef contains an invalid format. It might be a NULL pointer, or an image format
                                    which is not allowed according to rules of CV image format encodings.
 
    \constant   kvImageUnsupportedConversion    Some lower level conversion APIs only support conversion among a sparse matrix of image formats.
 */ /** enum  */
 public static final int
    kvImageNoError                     = 0,
    kvImageRoiLargerThanInputBuffer    = -21766,
    kvImageInvalidKernelSize           = -21767,
    kvImageInvalidEdgeStyle            = -21768,
    kvImageInvalidOffset_X             = -21769,
    kvImageInvalidOffset_Y             = -21770,
    kvImageMemoryAllocationError       = -21771,
    kvImageNullPointerArgument         = -21772,
    kvImageInvalidParameter            = -21773,
    kvImageBufferSizeMismatch          = -21774,
    kvImageUnknownFlagsBit             = -21775,
    kvImageInternalError               = -21776,    /* Should never see this. File a bug! */
    kvImageInvalidRowBytes             = -21777,
    kvImageInvalidImageFormat          = -21778,
    kvImageColorSyncIsAbsent           = -21779,
    kvImageOutOfPlaceOperationRequired = -21780,
    kvImageInvalidImageObject          = -21781,
    kvImageInvalidCVImageFormat        = -21782,
    kvImageUnsupportedConversion       = -21783,
    kvImageCoreVideoIsAbsent           = -21784;
    
/* vImage Flags                                                                                 */
/* ============                                                                                 */
/* The values here indicate bits in a vImage_Flags bit field.                                   */
/* Other bits are reserved for future use.                                                      */
/* Some flags are mutually exclusive. You can not have more                                     */
/* than one bit from this set set at the same time:                                             */
/* { kvImageCopyInPlace, kvImageBackgroundColorFill, kvImageEdgeExtend, kvImageTruncateKernel } */
/* all unused flags bits must be set to 0                                                       */
/* Not all flags are allowed by all functions.                                                  */
/**
 \typedef   vImage_Flags
 \abstract      vImage_Flags is a 32-bit bitfield of options of general use to vImage functions.
 \discussion    Multiple bits may be set concurrently. kvImageUnknownFlagsBit may be returned by
                a function if a flag bit is set (1) but the function does not know what the flag
                bit means (e.g. your new code on an older version of vImage) or if the flag should
                cause a behavior that is unsupported by the function, for example, kvImageHighQualityResampling
                to a function that does not do image resampling.
 \constant  kvImageNoFlags   Use the default behavior. Internal multithreading is enabled. Debug 
                messages are generally not printed to the console. No edging method is specified. 
                Normal quality resampling methods are used (Lanczos3, probably). Do the function,
                instead of returning a temp buffer size. Allocate memory as needed.
 
 \constant  kvImageLeaveAlphaUnchanged   Some functions that operate on ARGB data in place allow
                you to operate on just the RGB components and leave the alpha channel unmodified.
                These are typically histogram and gamma functions and some convolution functions.
 
 \constant  kvImageCopyInPlace  One of four edging modes. This one tells vImage to do nothing for
                destination pixels that need source pixels that are missing. The corresponding source
                pixel is copied to the destination image. This is only used for image filters that take a
                kernel, such as convolutions. It is not allowed for Morphology filters.
 
 \constant kvImageBackgroundColorFill  One of four edging modes. This one tells vImage to use the
                backgroundColor parameter of the function as the color of any missing pixels in
                a source image. Missing pixels occur when a filter needs to read off the edge of
                a source image. 
 
 \constant kvImageEdgeExtend    One of four edging modes.  This one tells vImage to use the nearest
                existing source image pixel when it needs source data but finds it needs a non-existant
                pixel off the edge of the provided source image. 
 
 \constant kvImageDoNotTile     Do not internally subdivide the image for processing on multiple CPUs
                or other compute devices. If this flag is set, the function will run single threaded
                on the current thread. Usually this flag may be expected to cause a significant increase
                in the execution time of a vImage function. However, if you are calling the function
                from a heavily multithreaded context (such as your own tiling engine) and CPU occupancy
                is high, this may lead to small performance improvements due to reduced CPU contention.
 
 \constant kvImageHighQualityResampling  Use a more expensive image resampling method than what is available
                by default. Typically this is Lanczos5. Note that as vImage resampling already leans towards
                quality over performance -- the GPU texture unit is your friend if you just want raw performance
                -- the additional quality from kvImageHighQualityResampling may be difficult to see in some images. 
                It is best suited to background rendering tasks.
 
 \constant kvImageTruncateKernel    One of four edging modes. This one tells vImage to use only the pixels it 
                has and reweight the kernel accordingly. The reweighting process can be expensive.  It can 
                also lead to difficulties if a contiguous sub-rectangle of the kernel sums to zero. In this
                case, the area of the kernel is zero and you have formally asked vImage to do division by zero,
                in which case vImage behavior is undefined.
 
 \constant kvImageGetTempBufferSize  Instead of performing the function requested, return (as a vImage_Error)
                the size of the temp buffer requried by the function for this set of parameters. The image pixels
                are not touched. If the function does not take a temp buffer, then 0 will be returned and the 
                function will do nothing. Some functions may return a 0 sized temp buffer for some sets of parameters 
                an not others. The size of the temporary buffer may change for different parameters, and for
                different OS revisions.
 
 \constant kvImagePrintDiagnosticsToConsole Some of the high level functions in vImage_Utilities.h and 
                vImage_CVUtilities.h have complex failure modes that could prove baffling with just a 
                error code return.  This flag instructions these functions to also print a human readable
                diagnostic message to the Apple System Logger when an error is encountered. The output 
                should be visible in Console.app.
 
 \constant kvImageNoAllocate    Some vImage functions may allocate memory, possibly returning it to you.
                This flag instructs the function to use the memory provided instead. For example, instead of
                overwriting vImage_Buffer.data with a newly allocated pointer to memory, use the memory
                pointed to by vImage_Buffer.data directly. In other cases, it may cause the function to
                assume ownership of a buffer, rather than allocating a copy. You are responsible for making
                sure the buffer that you allocate instead of vImage is large enough to hold the image. Most 
                vImage functions do not allocate memory and assume that vImage_Buffer.data is already allocated, 
                and in the case of source image buffers, contain valid pixel data.
 
 \constant kvImageHDRContent    The pixels described in the input image may contain high dymanic range content.
                HDR pixels may have value outside of [-2,2.0]. This flag is generally only applicable to 
                floating-point images. Most 8- and 16-bit pixels can not represent values outside [0,1] and
                functions that operate on 16Q12 formats are designed to operate over the full range of [-8,8).
                Most floating-point functions in vImage are linear in behavior and so work equally well 
                on any float.  Some non-linear functions like polynomials (or by extension colorspace conversion)
                are only valid over a limited range (typically [-2,2]) and will return incorrect answers 
                for values outside that range.  In addition, certain IIR or FFT algorithms in convolution may
                encounter precision issues with HDR content.  For these cases, if you know you have HDR content,
                pass kvImageHDRContent and a (typically slower) alternative method will be used for these
                sources.
 
 \constant kvImageUseFP16Accumulator    Use a faster and lower precision internal arithmetic, when available,
               for the functions operating on 16-bit half-precision floating-point pixels (Pixel16_F).
               This will enforce for example convolutions to be computed with 16-bit half-precision floating-point
               arithmetic internally, when architecture of the CPU supports it. The arm64e architectures supports it
               but none of the Intel architectures.
 
 */ /** enum  */
 public static final int
    kvImageNoFlags                   = 0,
    
     /* Operate on red, green and blue channels only. Alpha is copied from source 
        to destination. For Interleaved formats only. */
    kvImageLeaveAlphaUnchanged       = 1,    
    
     /* Copy edge pixels. Convolution Only. */
    kvImageCopyInPlace               = 2,
    
    /* Use the background color for missing pixels. */
    kvImageBackgroundColorFill       = 4,
    
    /* Use the nearest pixel for missing pixels. */
    kvImageEdgeExtend                = 8,
    
    /* Pass to turn off internal tiling and disable internal multithreading. Use this if 
       you want to do your own tiling, or to use the Min/Max filters in place. */
    kvImageDoNotTile                 = 16,
    
    /* Use a higher quality, slower resampling filter for Geometry operations 
       (shear, scale, rotate, affine transform, etc.) */
    kvImageHighQualityResampling     = 32,
    
     /* Use only the part of the kernel that overlaps the image. For integer kernels, 
        real_divisor = divisor * (sum of used kernel elements) / (sum of kernel elements). 
        This should preserve image brightness at the edges. Convolution only. */
    kvImageTruncateKernel            = 64,
    
    /* The function will return the number of bytes required for the temp buffer. 
       If this value is negative, it is an error, per standard usage. */
    kvImageGetTempBufferSize         = 128,
    
    /* Some functions such as vImageConverter_CreateWithCGImageFormat have so many possible error conditions 
       that developers may need more help than a simple error code to diagnose problems. When this 
       flag is set and an error is encountered, an informative error message will be logged to the Apple 
       System Logger (ASL).  The output should be visible in Console.app. */
    kvImagePrintDiagnosticsToConsole = 256,
    
    /* Pass this flag to prevent vImage from allocating additional storage. */
    kvImageNoAllocate                = 512,

    /* Use methods that are HDR-aware, capable of providing correct results for input images with pixel values
       outside the otherwise limited (typically [-2,2]) range. This may be slower. */
    kvImageHDRContent                = 1024,

    /* Pass to disable clamping is some conversions to floating point formats. Use this if the input data
       may describe values outside [0,1] which should be preserved.. */
    kvImageDoNotClamp                 = 2048,
    
    /* Use a lower precision, faster floating-point arithmetic for all internal computations when available.
       This applies to all functions operating on 16-bit half-precision floating-point pixels, Pixel_16F. */
    kvImageUseFP16Accumulator     = 4096;

/**
    \class vImageConverterRef
    \abstract   An opaque type which contains a decription of a conversion from one CoreGraphics image format to another.
 
    \discussion The vImageConverter is an opaque type which contains information needed to do a rapid conversion from
    one image type to another. Sometimes, it can take a significant amount of time to figure out how to convert
    from one format to another. It wouldn't be good to do that redundantly for a bunch of small images. The
    vImageConversionSetup allows us to set up the conversion once and reuse the information many times, to
    keep net latencies low.
 
    Note that creating a vImageConverter can at times take a while. While usually it is quick, it might have
    to do things like load other frameworks in the system (e.g. Colorsync) if they are not loaded already,
    or build a lookup table. It is a good idea to setup your conversions in advance and reuse the conversion
    objects.  The objects are thread safe. You can use the same object in multiple threads concurrently. They
    follow standard retain / release semantics and can be used as CFTypeRefs.
 
    \superclass CFTypeRef
 
    \seealso Please see vImage_Utilities.h for interfaces that operate on the vImageConverterRef
 */

@Opaque public static class vImageConverter extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vImageConverter() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImageConverter(Pointer p) { super(p); }
}

/**
    \class vImageCVImageFormatRef
    \abstract   An opaque type which contains a decription of a conversion from a CoreGraphics image format to a CVPixelBuffer, or the reverse.
 
    \superclass CFTypeRef
    \discussion The vImageCVImageFormatRef describes how the image is encoded in a CVPixelBufferRef. vImage uses this information to construct converters that
    are capable of converting to and from this image encoding.  The format stores a description of the pixels in the image (planar/color representation/
    bit depth/number of channels, etc.) but not the image size, location of the base pointer or rowbytes. It is intended for the vImageCVImageFormatRef
    to be reused for other CVPixelBufferRefs of the same format, such as other frames from the same movie.
 
    vImageCVImageFormatRefs are capable of holding an incomplete encoding representation. You may be required to provide addition information such
    as colorspace and (YCbCr only) chroma siting or conversion matrix before the vImageCVImageFormatRef can be used for image conversion to other
    formats.
 
    The vImageCVImageFormatRef is a CFTypeRef. CFEqual does not test for equivalence of the userData field. You should use vImageCVImageFormat_Retain/Release
    when working with vImageCVImageFormatRef to manage ownership of the object.
        <p>
        <pre>
        \textblock
        Thread Safety:
            <p>
            The vImageCVImageFormatRef may be safely read from multiple threads concurrently.  However,
            it makes no attempt to keep its internal state coherent when multiple threads write to it,
            or when one thread writes to it while one or more threads are reading from it at the same
            time. This can be trivially handled by keeping the knowledge of the vImageCVImageFormatRef
            limited to a single thread while it is being created / configured and then treat it as
            immutable thereafter.  If necessary, you can also use a read/write lock to limit reentrant
            access.
        \/textblock
        </pre>
 
 
    Information tracked by vImageCVImageFormatRef:
 
 <pre>
 \textblock
    imageFormatType     A CVPixelFormatType such as '2vuy'. See CVPixelBuffer.h for the complete list.
 
    number_of_channels  How many  color + alpha channels are encoded in the image. An alpha channel is included in this count
                        if it takes up space in the image, even if its value is described always 1.0, for example by /Last
                        kCGImageAlphaNoneSkipFirst or kCVImageBufferAlphaChannelIsOpaque.  This field is automatically initialized
                        based on the imageFormatType (see above) and is never missing.
 
    channel_names       A list of vImageBufferTypeCodes corresponding to the channels in the image. Unlike what happens for
                        vImageConverterRefs, the type codes used here always encode a single color channel.  vImageConverterRefs
                        use the channel names to encode what is in each vImage_Buffer. Here it is used to describe each channel.
                        So, an ARGB buffer might be described as kvImageBufferTypeCode_CGFormat but will be described as
                        { kvImageBufferTypeCode_RGB_Red, kvImageBufferTypeCode_RGB_Green, kvImageBufferTypeCode_RGB_Blue,
                        kvImageBufferTypeCode_Alpha, kvImageBufferTypeCode_EndOfList }. The order of the channels in the list
                        may not match the order of the channels in the buffer.  This field is automatically initialized based on
                        the imageFormatType (see above) and is never missing.
 
   matrix               (YpCbCr only.)  A YpCbCr image has an associated 3x3 matrix that encodes how it was converted to YpCbCr from
                        a reference RGB colorspace (see colorspace below). The matrix is encoded as a NULL pointer when missing.
                        This field is ignored for non-YpCbCr formats.
 
 
   chroma_siting        Some YpCbCr formats store their chroma components as a smaller image than the luminance component.
                        This describes where the subsampled chroma samples are positioned relative to the luminance component.
                        This field is encoded as a NULL CFStringRef when missing. The field is ignored for RGB, monochrome,
                        indexed and 4:4:4 YpCbCr image formats.
 
   colorspace           For RGB, indexed and grayscale images, this is the colorspace that describes the image encoding.
                        For YpCbCr images, this is the colorspace of the RGB image that you get once the matrix (see above)
                        is unapplied. Thus, the colorspace encodes for the underlying primaries and transfer function of the
                        YpCbCr image. See also vImageCreateRGBColorSpaceWithPrimariesAndTransferFunction.  This field is required
                        for all image formats. A colorspace of NULL indicates a missing colorspace. (This is inconsistent with
                        the shorthand used in vImage_Utilities.h where NULL maps to sRGB.)  Since vImage has no concept of
                        a current graphics device, deviceRGB maps to sRGB and device gray maps to gray 2.2. If you wish to
                        ensure no color correction / conversion, you should match this colorspace with the one in the
                        vImage_CGImageFormat to / from which you are converting.
 
   channel_description  Some CVPixelBuffer formats do not use the entire representable range of the format to encode image data.
                        For example, a 'yuvs' "video range" buffer only uses the range [16,235] for luminance and [16,240] for
                        chroma. Values outside that range are considered to have value equal to the nearest in-range value. In
                        addition, we add additionional fields to leave open the possibility that some formats can encode information
                        outside of the traditional [0,1.0] range ([-1.0,1.0] for chroma) so reference values for the encoding for 0
                        and 1.0 are also described. (See vImageChannelDescription below.) The zero/one fields are analogous in function
                        to the decode arrays provided by CG. It is possible to use the channel description to create formats that are
                        not correctly understood by CoreVideo. These are provided to allow for interoperation with custom video formats.
                        The channel description is initialized automatically for known image format types (see imageFormatType above)
                        and probably only very rarely needs to be changed. It is never missing.
 
  alpha_is_one_hint     Some images are encoded with an alpha channel. However, you may have additional information that the image is
                        really completely opaque. The "alpha is one hint" tells vImage that the alpha channel is always 1.0 (opaque)
                        across the entire image. Setting the hint to 1 may allow vImage to avoid work and run faster in some cases.
                        There is no vImageCVImageFormatRef representation for premultiplied alpha, currently. Since it is a hint,
                        the hint may never be missing from a vImageCVImageFormatRef.  The hint is ignored for image formats that do
                        not contain an alpha channel.
 
  user_data             The vImageCVImageFormatRef has a userData field to allow you to easily reference your data starting from
                        a handle to the object. vImage does  not attempt to interact with the memory pointed to by the userData
                        pointer. It simply holds on to the pointer for you and will call a destructor callback function when the
                        vImageCVImageFormatRef to allow you to free that memory, and do any other post processing needed when the
                        vImageCVImageFormatRef is destroyed. Since there is only one userData pointer, by convention its use is
                        considered private to the application/library/framework that created the vImageCVImageFormatRef, including
                        cases where the creator does not set the userData field. If you need to attach your own data to a
                        vImageCVImageFormatRef created by someone else, you can make  a copy of it or wrap it with your own object.
 \/textblock
 </pre>
 
    \seealso Please see vImage_CVUtilities.h for interfaces that operate on the vImageCVImageFormatRef
 */

@Opaque public static class vImageCVImageFormat extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vImageCVImageFormat() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImageCVImageFormat(Pointer p) { super(p); }
}



/**
    \typedef    vImageARGBType
    \abstract   An encoding of an image format type to be used with RGB <-> Y'CbCr conversions in vImage/Conversions.h
    \discussion These formats enumerate different vImage ARGB pixel formats.
 */
/** enum vImageARGBType */
public static final int
        kvImageARGB8888   = 0,   /* Any 8-bit four channel interleaved buffer [0,255]=[0,1.0]. Does not specify channel order. */
        kvImageARGB16U    = 1,   /* Any 16-bit unsigned four channel interleaved buffer [0,65535]=[0,1.0]. Does not specify channel order. */
        kvImageARGB16Q12  = 2;    /* Any 16-bit signed fixedpoint four channel interleaved buffer [0,4096]=[0,1.0]. Does not specify channel order.  */
    
/**
    \typedef    vImageYpCbCrType
    \abstract   An encoding of an image format type to be used with RGB <-> Y'CbCr conversions in vImage/Conversions.h
    \discussion These formats enumerate different vImage/CoreVideo Y'CbCr pixel formats.
    \seealso    CVPixelBuffer OSTypes in CVPixelBuffer.h
 */
/** enum vImageYpCbCrType */
public static final int
        kvImage422CbYpCrYp8                  = 0,   /* 2vuy        */
        kvImage422YpCbYpCr8                  = 1,   /* yuvs / yuvf */
        kvImage422CbYpCrYp8_AA8              = 2,   /* a2vy        */
        kvImage420Yp8_Cb8_Cr8                = 3,   /* y420 / f420 */
        kvImage420Yp8_CbCr8                  = 4,   /* 420v / 420f */
        kvImage444AYpCbCr8                   = 5,   /* r408 / y408 */
        kvImage444CrYpCb8                    = 6,   /* v308        */
        kvImage444CbYpCrA8                   = 7,   /* v408        */
        kvImage444CrYpCb10                   = 8,   /* v410        */
        kvImage422CrYpCbYpCbYpCbYpCrYpCrYp10 = 9,   /* v210        */
        kvImage422CbYpCrYp16                 = 13,  /* v216 16-bit */
        kvImage444AYpCbCr16                  = 14;   /* y416        */
    

/**
 \struct    vImage_YpCbCrToARGBMatrix
 
 \field Yp      matrix[0][0].  Typically 1.
 \field Cr_R    matrix[0][2].
 \field Cb_G    matrix[1][1].
 \field Cr_G    matrix[1][2].
 \field Cb_B    matrix[2][1]
 
 \abstract   A 3x3 converson matrix for converting Y'CbCr signals to RGB
 \discussion The matrix is sparse. The 3x3 matrix is given by:
 
            <pre>
            \textblock
                    | R |   | Yp    0     Cr_R |   | Y' |
                    | G | = | Yp   Cb_G   Cr_G | * | Cb |
                    | B |   | Yp   Cb_B     0  |   | Cr |
            \/textblock
            </pre>
 
            Limits on the range of the fields in the matrix may apply.
 
 \seealso    vImage_ARGBToYpCbCrMatrix, which is the inverse matrix
 */

/* Input information into vImageConvert_YpCbCrToARGB_GenerateConversion() */
public static class vImage_YpCbCrToARGBMatrix extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vImage_YpCbCrToARGBMatrix() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vImage_YpCbCrToARGBMatrix(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImage_YpCbCrToARGBMatrix(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vImage_YpCbCrToARGBMatrix position(long position) {
        return (vImage_YpCbCrToARGBMatrix)super.position(position);
    }
    @Override public vImage_YpCbCrToARGBMatrix getPointer(long i) {
        return new vImage_YpCbCrToARGBMatrix((Pointer)this).offsetAddress(i);
    }

        public native float Yp(); public native vImage_YpCbCrToARGBMatrix Yp(float setter);
        public native float Cr_R(); public native vImage_YpCbCrToARGBMatrix Cr_R(float setter);
        public native float Cr_G(); public native vImage_YpCbCrToARGBMatrix Cr_G(float setter);
        public native float Cb_G(); public native vImage_YpCbCrToARGBMatrix Cb_G(float setter);
        public native float Cb_B(); public native vImage_YpCbCrToARGBMatrix Cb_B(float setter);
}
 
// #if !0 && !0
/** \const      kvImage_YpCbCrToARGBMatrix_ITU_R_601_4
 \abstract   Y'CbCr->RGB conversion matrix for ITU-Recommendation BT.601-4 */
public static native @Const vImage_YpCbCrToARGBMatrix kvImage_YpCbCrToARGBMatrix_ITU_R_601_4(); public static native void kvImage_YpCbCrToARGBMatrix_ITU_R_601_4(vImage_YpCbCrToARGBMatrix setter);

/** \const      kvImage_YpCbCrToARGBMatrix_ITU_R_709_2
 \abstract   Y'CbCr->RGB conversion matrix for ITU-Recommendation BT.709-2 */
public static native @Const vImage_YpCbCrToARGBMatrix kvImage_YpCbCrToARGBMatrix_ITU_R_709_2(); public static native void kvImage_YpCbCrToARGBMatrix_ITU_R_709_2(vImage_YpCbCrToARGBMatrix setter);
// #endif
    
    
    
/**
 \typedef    vImage_YpCbCrToARGB
 \abstract   An opaque representation of a 3x3 converson matrix for converting Y'CbCr signals to RGB.
             It is used to do the actual conversions. Please attempt to reuse these rather than making
             new ones each time.
 \discussion The representation also includes the range of the input and output pixels from the matrix and
             clamping information.
 
 \seealso    vImage_ARGBToYpCbCr, which is the inverse matrix
 */

public static class vImage_YpCbCrToARGB extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vImage_YpCbCrToARGB() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vImage_YpCbCrToARGB(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImage_YpCbCrToARGB(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vImage_YpCbCrToARGB position(long position) {
        return (vImage_YpCbCrToARGB)super.position(position);
    }
    @Override public vImage_YpCbCrToARGB getPointer(long i) {
        return new vImage_YpCbCrToARGB((Pointer)this).offsetAddress(i);
    }

        public native @Cast("uint8_t") byte opaque(int i); public native vImage_YpCbCrToARGB opaque(int i, byte setter);
        @MemberGetter public native @Cast("uint8_t*") BytePointer opaque();
}
    
/**
 \typedef    vImage_ARGBToYpCbCrMatrix
 \abstract   A 3x3 converson matrix for converting RGB signals to Y'CbCr
 \discussion The matrix has one repeating parameter. The 3x3 matrix is given by:
 
 \textblock
        | Y' |   | R_Yp        G_Yp  B_Yp      |   | R |
        | Cb | = | R_Cb        G_Cb  B_Cb_R_Cr | * | G |
        | Cr |   | B_Cb_R_Cr   G_Cr  B_Cr      |   | B |
 \/textblock
 
 Typically, these matrix coefficients come from a conversion of form:
 
 \textblock
    Y' = R_Yp * R + G_Yp * G + B_Yp * B         0 <= Y' <= 1
    Cb = k0 * (B - Y')                          -0.5 <= Cb <= 0.5
    Cr = k1 * (R - Y')                          -0.5 <= Cr <= 0.5
 \/textblock
 
 {R_Yp, G_Yp, B_Yp} are typically derived from the perceived brightness for red, green and blue.
 k0 and k1 are typically scaled so that Cb and Cr have the indicated range. Because of these
 relationships, {R_Yp, G_Yp, B_Yp} are usually positive, and B_Cb_R_Cr is usually 0.5.
 Limits on the range of the fields in the matrix may apply.
 \field R_Yp    matrix[0][0]
 \field G_Yp    matrix[0][1]
 \field B_Yp    matrix[0][2]
 \field R_Cb    matrix[1][0]
 \field G_Cb    matrix[1][1]
 \field B_Cb_R_Cr matrix[1][2] and matrix[2][0]
 \field G_Cr    matrix[2][1]
 \field B_Cr    matrix[2][2]
 \seealso    vImage_YpCbCrToARGBMatrix, which is the inverse matrix
 
 */
/* Input information into vImageConvert_ARGBToYpCbCr_GenerateConversion() */
public static class vImage_ARGBToYpCbCrMatrix extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vImage_ARGBToYpCbCrMatrix() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vImage_ARGBToYpCbCrMatrix(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImage_ARGBToYpCbCrMatrix(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vImage_ARGBToYpCbCrMatrix position(long position) {
        return (vImage_ARGBToYpCbCrMatrix)super.position(position);
    }
    @Override public vImage_ARGBToYpCbCrMatrix getPointer(long i) {
        return new vImage_ARGBToYpCbCrMatrix((Pointer)this).offsetAddress(i);
    }

        public native float R_Yp(); public native vImage_ARGBToYpCbCrMatrix R_Yp(float setter);
        public native float G_Yp(); public native vImage_ARGBToYpCbCrMatrix G_Yp(float setter);
        public native float B_Yp(); public native vImage_ARGBToYpCbCrMatrix B_Yp(float setter);
        public native float R_Cb(); public native vImage_ARGBToYpCbCrMatrix R_Cb(float setter);
        public native float G_Cb(); public native vImage_ARGBToYpCbCrMatrix G_Cb(float setter);
        public native float B_Cb_R_Cr(); public native vImage_ARGBToYpCbCrMatrix B_Cb_R_Cr(float setter);
        public native float G_Cr(); public native vImage_ARGBToYpCbCrMatrix G_Cr(float setter);
        public native float B_Cr(); public native vImage_ARGBToYpCbCrMatrix B_Cr(float setter);
}

// #if !0 && !0
/** \const      kvImage_ARGBToYpCbCrMatrix_ITU_R_601_4
 \abstract   RGB->Y'CbCr conversion matrix for ITU-Recommendation BT.601-4 */
public static native @Const vImage_ARGBToYpCbCrMatrix kvImage_ARGBToYpCbCrMatrix_ITU_R_601_4(); public static native void kvImage_ARGBToYpCbCrMatrix_ITU_R_601_4(vImage_ARGBToYpCbCrMatrix setter);

/** \const      kvImage_ARGBToYpCbCrMatrix_ITU_R_709_2
 \abstract   RGB->Y'CbCr conversion matrix for ITU-Recommendation BT.709-2 */
public static native @Const vImage_ARGBToYpCbCrMatrix kvImage_ARGBToYpCbCrMatrix_ITU_R_709_2(); public static native void kvImage_ARGBToYpCbCrMatrix_ITU_R_709_2(vImage_ARGBToYpCbCrMatrix setter);
// #endif

/**
 \typedef    vImage_ARGBToYpCbCr
 \abstract   An opaque representation of a 3x3 converson matrix for converting RGB signals to Y'CbCr.
 It is used to do the actual conversions. Please attempt to reuse these rather than making
 new ones each time.
 \discussion The representation also includes the range of the input and output pixels from the matrix and
 clamping information.
 
 \seealso    vImage_ARGBToYpCbCr, which is the inverse matrix
 */
public static class vImage_ARGBToYpCbCr extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vImage_ARGBToYpCbCr() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vImage_ARGBToYpCbCr(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImage_ARGBToYpCbCr(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vImage_ARGBToYpCbCr position(long position) {
        return (vImage_ARGBToYpCbCr)super.position(position);
    }
    @Override public vImage_ARGBToYpCbCr getPointer(long i) {
        return new vImage_ARGBToYpCbCr((Pointer)this).offsetAddress(i);
    }

        public native @Cast("uint8_t") byte opaque(int i); public native vImage_ARGBToYpCbCr opaque(int i, byte setter);
        @MemberGetter public native @Cast("uint8_t*") BytePointer opaque();
}
    
/** 
 \typedef vImage_YpCbCrPixelRange
 \abstract  Range and clamping information for Y'CbCr pixel formats
 \discussion Y'CbCr formats frequently don't use the entire representable range available to 
             them to represent image data. While a "full range" video format does use the
             entire range, a "video range" format often leaves the extrema unused, except perhaps
             to represent values outside of the standard Y'=[0,1] CbCr = [-0.5, 0.5] range. 
             For example, a 8-bit video range format typically uses the range [16,235] for
             Y' and [16, 240] for Cb and Cr. 
 
 
             Some examples:
    
 \textblock
                (vImage_YpCbCrPixelRange){ 16, 128, 235, 240, 255, 0, 255, 1 }      // video range 8-bit, unclamped
                (vImage_YpCbCrPixelRange){ 16, 128, 235, 240, 235, 16, 240, 16 }    // video range 8-bit, clamped to video range
                (vImage_YpCbCrPixelRange){ 0, 128, 255, 255, 255, 1, 255, 0 }       // full range 8-bit, clamped to full range
 \/textblock
 
            The bias will be the prebias for YUV -> RGB and postbias for RGB -> YUV.
 
 \field Yp_bias The encoding for Y' = 0.0 for this video format (varies by bitdepth)
 \field CbCr_bias The encoding for {Cb,Cr} = 0.0 for this video format. This is usually the MIDDLE of the range of CbCr, not the low end. 
 \field YpRangeMax The encoding for Y' = 1.0 for this video format. For video range, this is typically less than the maximum representable value.
 \field CbCrRangeMax The encoding for {Cb,Cr} = 0.5 for this video format. This is usually near the high end of the encodable range (e.g. 0xf0), if not the maximum encodable value (e.g. 0xff)
 \field YpMax  The encoding for the maximum allowed Y' value. All values larger than this will be clamped to this value.
 \field YpMin   The encoding of the minimum allowed Y' value. All values less than this will be clamped to this value.
 \field CbCrMax The encoding of the maximum allowed {Cb, Cr} value. All chroma values greater than this value will be clamped to this value.
 \field CbCrMin The encoding of the minimum allowed {Cb, Cr} value. All chroma values less than this value will be clamped to this value.
 \seealso vImageChannelDescription
*/
public static class vImage_YpCbCrPixelRange extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vImage_YpCbCrPixelRange() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vImage_YpCbCrPixelRange(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vImage_YpCbCrPixelRange(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vImage_YpCbCrPixelRange position(long position) {
        return (vImage_YpCbCrPixelRange)super.position(position);
    }
    @Override public vImage_YpCbCrPixelRange getPointer(long i) {
        return new vImage_YpCbCrPixelRange((Pointer)this).offsetAddress(i);
    }

        public native int Yp_bias(); public native vImage_YpCbCrPixelRange Yp_bias(int setter);
        public native int CbCr_bias(); public native vImage_YpCbCrPixelRange CbCr_bias(int setter);
        public native int YpRangeMax(); public native vImage_YpCbCrPixelRange YpRangeMax(int setter);
        public native int CbCrRangeMax(); public native vImage_YpCbCrPixelRange CbCrRangeMax(int setter);
        public native int YpMax(); public native vImage_YpCbCrPixelRange YpMax(int setter);
        public native int YpMin(); public native vImage_YpCbCrPixelRange YpMin(int setter);
        public native int CbCrMax(); public native vImage_YpCbCrPixelRange CbCrMax(int setter);
        public native int CbCrMin(); public native vImage_YpCbCrPixelRange CbCrMin(int setter);
}

    
// #ifdef __cplusplus
// #endif


// #endif /* vImage_TYPES_H */


// Parsed from Alpha.h

/**
*  \header Alpha.h
*  vImage Framework
*
*  \copyright Copyright (c) 2003-2016 by Apple Inc. All rights reserved.
*
*  See vImage/vImage.h for more on how to better view the headerdoc documentation for functions declared herein.
*
*  \discussion
*  Alpha compositing is the practice of blending one image into another using a coverage component, commonly called
*  alpha, to indicate how opaque each pixel is.  A value of 1.0 (or 255 if an 8-bit image) indicates the
*  pixel is fully opaque. A value of 0 indicates that it is fully transparent. Values in beetween establish a linear scale
*  of partial opacity. Alpha can be used to slowly fade one image into another. Some images such as icons, have opqaue
*  portions and transparent portions. A blending operation based on alpha is required to draw these over a background
*  image.
*
*  In its simplest form, an alpha blend is a linear interpolation between pixel of two images:
* <pre>\textblock
*      float: new color =  top color * alpha + (1-alpha) * bottom color
*      8-bit: new color =  (top color * alpha + (255-alpha) * bottom color + 127) / 255
* \/textblock </pre>
*  However, these formulations are a bit too simplistic because they do not account for the possibility that
*  the bottom layer may have some transparency to it too. One subtlety of adding transparency to the bottom image
*  is that the result image has an alpha component to it too that should be divided out:
* <pre>\textblock
*      float: new alpha =  top alpha + (1-top alpha) * bottom alpha
*      float: new color =  (top color * top alpha + (1- top alpha) * bottom color * bottom alpha ) / new alpha
*
*      8-bit: new alpha =  top alpha + ((255-top alpha) * bottom alpha + 127)/255
*      8-bit: new color =  (255 * top color * top alpha + (255- top alpha) * bottom color * bottom alpha + (255*255)/2) / (255 * 255 * new alpha)
* \/textblock </pre>
* As might be imagined, this extra complication may become costly.  At the cost of a small amount of accuracy in non-opaque regions
* of the image, it is common to leave the alpha multiplied into the image. This avoids the division at the end. In addition,
* if the result is used in another blend, we don't have to multiply the alpha back in at that stage, which simplifies things
* all around. Such images with the alpha channel multiplied into the other channels are called pre-multiplied images.
*
* This gives us the following for premultiplied alpha blends:
* <pre>\textblock
*      float: new alpha               = top alpha +               (1 - top alpha) * bottom alpha
*      float: new premultiplied color = top premultiplied color + (1 - top alpha) * bottom premultiplied color
*
*      8-bit: new alpha               =  top alpha +               ((255 - top alpha) * bottom alpha + 127)/255
*      8-bit: new premultiplied color =  top premultiplied color + ((255 - top alpha) * bottom premultiplied color + 127)/255
* \/textblock </pre>
*
* Some images are known to be fully opaque. For such images, alpha is 1.0 (or 255) for all the pixels, and consequently
* do not require any computation to be done to interconvert between premultiplied and non-premultiplied states. That is,
* since x/1 = x  and x*1 = x, they are non-premultiplied and premultiplied at the same time, and can serve in either
* capacity as needed.  Because of this special status, CoreGraphics labels them kCGImageAlphaNoneSkipFirst/Last. vImage
* does similar things in vImage_Utilities.h. Labelling opaque buffers as such enables cheaper alpha blending and will frequently
* will let us avoid blending all-together as a simple copy operation will do.
*
* This header provides compositing (blending) operations for both premultiplied and non-premultiplied images, functions
* to premultiply or unpremultiply images, and some functions to make sure that the color channel values do not exceed
* the alpha value, which sometimes can happen after a convolution, morphological or resampling operation.
*
*    These alpha compositing functions assume that the floating point range is 0.0 (black) to 1.0 (full intensity color).
*    While values outside these ranges do function correctly (you can have 110% intensity color or -50% color, for example),
*    the calculation is done assuming 1.0 represents full intensity color, and 0.0 represents the absence of color. If these
*    assumptions are not correct, then the calculation will produce incorrect results. Apple does not currently provide
*    alpha compositing functions that work with any floating point range in vImage.
*
*    8 bit functionality assumes that 0 is no color, and 255 is full color. 8 bit functions do saturated clipping before
*    converting from internal precision back to 8 bits to make sure that modulo overflow does not occur. The internal
*  calculation is done with higher precision.
*
*  \ignorefuncmacro VIMAGE_NON_NULL
*/

// #ifndef VIMAGE_ALPHA_H
// #define VIMAGE_ALPHA_H

// #include <vImage/vImage_Types.h>

// #ifdef __cplusplus
// #endif

/**
 * \functiongroup Alpha Blend
 * \discussion The Alpha Blend functions composite two non-premultiplied images together to produce a non-premultiplied result.
 *             They are in general more expensive than their premultiplied counterparts, because the alpha has to be
 *             divided out of the result at the end.
 */

/**
 * \function vImageAlphaBlend_Planar8
 * \abstract Composite two non-premultiplied planar 8-bit images, to produce a non-premultiplied result.
 * \discussion
 *
 *      For each color channel:
 * <pre>\textblock
 *          float destColor = (  srcTopColor * srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha * srcBottomColor ) / alpha
 * \/textblock </pre>
 *      alpha (the new alpha value for that pixel) is calculated as:
 * <pre>\textblock
 *          float alpha =  srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha
 * \/textblock </pre>
 *      For planar data, you need to calculate alpha yourself ahead of time and provide that as an argument to this function.
 *      This can be done using:
 * <pre>\textblock
 *          vImagePremultipliedAlphaBlend_Planar8( srcTopAlpha, srcTopAlpha, srcBottomAlpha, alpha, kvImageNoFlags );
 * \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The ARGB versions work for all 4 channel 8-bit / channel image formats with alpha first in memory.
 *
 * @param srcTop        The color image that is composited on top of the bottom image
 * @param srcTopAlpha   The alpha channel corresponding to the srcTop image
 * @param srcBottom     The color image that is below the srcTop image, into which it is blended
 * @param srcBottomAlpha The alpha channel corresponding to the srcBottom image
 * @param alpha         The alpha channel for the destination image. You need to calculate this ahead of time as:
 * <pre>\textblock
 *          vImagePremultipliedAlphaBlend_Planar8( srcTopAlpha, srcTopAlpha, srcBottomAlpha, alpha, kvImageNoFlags );
 * \/textblock </pre>
 * \oaram dest          The non-premultiplied result will be written here.
 *
 * @param flags         The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags          Default operation
 *
 *          kvImageDoNotTile        Disables internal multithreading. This may be useful if you are writing your own multithreaded tiling engine.
 *  \/textblock</pre>
 * @return              The following result codes may be returned:
 *  <pre>\textblock
 *          kvImageNoError                      Success!
 *
 *          kvImageRoiLargerThanInputBuffer     The destination buffer must be no larger than srcTop, srcBottom, srcTopAlpha, srcBottomAlpha and alpha.
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImageAlphaBlend_Planar8( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcTopAlpha, @Const vImage_Buffer srcBottom, @Const vImage_Buffer srcBottomAlpha, @Const vImage_Buffer alpha, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImageAlphaBlend_PlanarF
 * \abstract Composite two non-premultiplied planar floating-point images, to produce a non-premultiplied result.
 * \discussion
 *
 *      For each color channel:
 * <pre>\textblock
 *          float destColor = (  srcTopColor * srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha * srcBottomColor ) / alpha
 * \/textblock </pre>
 *      alpha (the new alpha value for that pixel) is calculated as:
 * <pre>\textblock
 *          float alpha =  srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha
 * \/textblock </pre>
 *      For planar data, you need to calculate alpha yourself ahead of time and provide that as an argument to this function.
 *      This can be done using:
 * <pre>\textblock
 *          vImagePremultipliedAlphaBlend_PlanarF( srcTopAlpha, srcTopAlpha, srcBottomAlpha, alpha, kvImageNoFlags );
 * \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The ARGB versions work for all 4 channel 8-bit / channel image formats with alpha first in memory.
 *
 * @param srcTop        The color image that is composited on top of the bottom image
 * @param srcTopAlpha   The alpha channel corresponding to the srcTop image
 * @param srcBottom     The color image that is below the srcTop image, into which it is blended
 * @param srcBottomAlpha The alpha channel corresponding to the srcBottom image
 * @param alpha         The alpha channel for the destination image. You need to calculate this ahead of time as:
 * <pre>\textblock
 *                          vImagePremultipliedAlphaBlend_PlanarF( srcTopAlpha, srcTopAlpha, srcBottomAlpha, alpha, kvImageNoFlags );
 * \/textblock </pre>
 * \oaram dest          The non-premultiplied result will be written here.
 *
 * @param flags         The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags          Default operation
 *
 *          kvImageDoNotTile        Disables internal multithreading. This may be useful if you are writing your own multithreaded tiling engine.
 *  \/textblock</pre>
 * @return              The following result codes may be returned:
 *  <pre>\textblock
 *          kvImageNoError                      Success!
 *
 *          kvImageRoiLargerThanInputBuffer     The destination buffer must be no larger than srcTop, srcBottom, srcTopAlpha, srcBottomAlpha and alpha.
 *  \/textblock</pre>
 */

public static native @Cast("vImage_Error") long vImageAlphaBlend_PlanarF( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcTopAlpha, @Const vImage_Buffer srcBottom, @Const vImage_Buffer srcBottomAlpha, @Const vImage_Buffer alpha, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImageAlphaBlend_ARGB8888
 * \abstract Composite two non-premultiplied ARGB8888 images, to produce a non-premultiplied result.
 * \discussion
 *
 *      For each color channel:
 * <pre>\textblock
 *          float destColor = (  srcTopColor * srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha * srcBottomColor ) / alpha
 * \/textblock </pre>
 *      alpha (the new alpha value for that pixel) is calculated as:
 * <pre>\textblock
 *          float alpha =  srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha
 * \/textblock </pre>
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The ARGB versions work for all 4 channel 8-bit / channel image formats with alpha first in memory.
 *
 * @param srcTop        The image that is composited on top of the bottom image. The alpha channel must appear first.
 * @param srcBottom     The image that is below the srcTop image, into which it is blended. The alpha channel must appear first.
 * \oaram dest          The non-premultiplied result will be written here.
 *
 * @param flags         The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags          Default operation
 *
 *          kvImageDoNotTile        Disables internal multithreading. This may be useful if you are writing your own multithreaded tiling engine.
 *  \/textblock</pre>
 * @return              The following result codes may be returned:
 *  <pre>\textblock
 *          kvImageNoError                      Success!
 *
 *          kvImageRoiLargerThanInputBuffer     The destination buffer must be no larger than srcTop, srcBottom, srcTopAlpha, srcBottomAlpha and alpha.
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImageAlphaBlend_ARGB8888( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImageAlphaBlend_ARGBFFFF
 * \abstract Composite two non-premultiplied ARGBFFFF images, to produce a non-premultiplied result.
 * \discussion
 *
 *      For each color channel:
 * <pre>\textblock
 *          float destColor = (  srcTopColor * srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha * srcBottomColor ) / alpha
 * \/textblock </pre>
 *      alpha (the new alpha value for that pixel) is calculated as:
 * <pre>\textblock
 *          float alpha =  srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha
 * \/textblock </pre>
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The ARGB versions work for all 4 channel float / channel image formats with alpha first in memory.
 *
 * @param srcTop        The image that is composited on top of the bottom image. The alpha channel must appear first.
 * @param srcBottom     The image that is below the srcTop image, into which it is blended. The alpha channel must appear first.
 * \oaram dest          The non-premultiplied result will be written here.
 *
 * @param flags         The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags          Default operation
 *
 *          kvImageDoNotTile        Disables internal multithreading. This may be useful if you are writing your own multithreaded tiling engine.
 *  \/textblock</pre>
 * @return              The following result codes may be returned:
 *  <pre>\textblock
 *          kvImageNoError                      Success!
 *
 *          kvImageRoiLargerThanInputBuffer     The destination buffer must be no larger than srcTop, srcBottom, srcTopAlpha, srcBottomAlpha and alpha.
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImageAlphaBlend_ARGBFFFF( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \functiongroup Alpha Blend (Premultiplied)
 * \discussion  Premultiplied alpha blends composite two premultiplied images to produce a premultiplied result.
 */

/**
 * \function vImagePremultipliedAlphaBlend_Planar8
 * \abstract blend two premultiplied Planar8 images to produce a premultiplied Planar8 result.
 * \discussion
 *      For each color channel:
 * <pre>\textblock
 *          uint8_t destColor = srcTopColor  + ((255 - srcTopAlpha) * srcBottomColor + 127)/255;
 * \/textblock</pre>
 *      Similarly, the output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          uint8_t alpha =  srcTopAlpha + ((255 - srcTopAlpha) * srcBottomAlpha + 127)/255;
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0, 255].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 * @param srcTop            The top image
 * @param srcTopAlpha       The coverage component for the top image (alpha)
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlend_Planar8( @Const vImage_Buffer srcTop,
                                                                @Const vImage_Buffer srcTopAlpha,
                                                                @Const vImage_Buffer srcBottom,
                                                                @Const vImage_Buffer dest,
                                                                @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedAlphaBlend_PlanarF
 * \abstract blend two premultiplied PlanarF images to produce a premultiplied PlanarF result.
 * \discussion
 *      For each color channel:
 * <pre>\textblock
 *          float destColor = srcTopColor  + (1.0 - srcTopAlpha) * srcBottomColor;
 * \/textblock</pre>
 *      Similarly, the output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          float alpha =  srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0.0f, 1.0f].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 * @param srcTop            The top image
 * @param srcTopAlpha       The coverage component for the top image (alpha)
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 *
 */

public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlend_PlanarF( @Const vImage_Buffer srcTop,
                                                                @Const vImage_Buffer srcTopAlpha,
                                                                @Const vImage_Buffer srcBottom,
                                                                @Const vImage_Buffer dest,
                                                                @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedAlphaBlend_ARGB8888
 * \abstract blend two premultiplied ARGB8888 images to produce a premultiplied ARGB8888 result.
 * \discussion
 *      For each color channel:
 * <pre>\textblock
 *          uint8_t destColor = srcTopColor  + ((255 - srcTopAlpha) * srcBottomColor + 127)/255;
 * \/textblock</pre>
 *      Similarly, the output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          uint8_t alpha =  srcTopAlpha + ((255 - srcTopAlpha) * srcBottomAlpha + 127)/255;
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0, 255].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The function will work for all 4 channel 8-bit / channel image formats with alpha first in memory, not just ARGB.
 *
 * @param srcTop            The top image
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * @param flags             The following flags may be used:
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlend_ARGB8888( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedAlphaBlend_BGRA8888
 * \abstract blend two premultiplied BGRA8888 images to produce a premultiplied BGRA8888 result.
 * \discussion
 *      For each color channel:
 * <pre>\textblock
 *          uint8_t destColor = srcTopColor  + ((255 - srcTopAlpha) * srcBottomColor + 127)/255;
 * \/textblock</pre>
 *      Similarly, the output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          uint8_t alpha =  srcTopAlpha + ((255 - srcTopAlpha) * srcBottomAlpha + 127)/255;
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0, 255].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The function will work for all 4 channel 8-bit / channel image formats with alpha last in memory, not just BGRA.
 *      Also available as vImagePremultipliedAlphaBlend_RGBA8888().
 *
 * @param srcTop            The top image
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * @param flags             The following flags may be used:
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlend_BGRA8888( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImagePremultipliedAlphaBlend_RGBA8888( _srcTop, _srcBottom, _dest, _flags )    vImagePremultipliedAlphaBlend_BGRA8888((_srcTop), (_srcBottom), (_dest), (_flags))

/**
 * \function vImagePremultipliedAlphaBlend_ARGBFFFF
 * \abstract blend two premultiplied ARGBFFFF images to produce a premultiplied ARGBFFFF result.
 * \discussion
 * <pre>\textblock
 *          float destColor = srcTopColor  + (1.0 - srcTopAlpha) * srcBottomColor;
 * \/textblock</pre>
 *      Similarly, the output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          float alpha =  srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0.0f, 1.0f].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The function will work for all 4 channel float / channel image formats with alpha first in memory, not just ARGB.
 *
 * @param srcTop            The top image
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * @param flags             The following flags may be used:
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlend_ARGBFFFF( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedAlphaBlend_BGRAFFFF
 * \abstract blend two premultiplied ARGBFFFF images to produce a premultiplied BGRAFFFF result.
 * \discussion
 * <pre>\textblock
 *          float destColor = srcTopColor  + (1.0 - srcTopAlpha) * srcBottomColor;
 * \/textblock</pre>
 *      Similarly, the output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          float alpha =  srcTopAlpha + (1.0 - srcTopAlpha) * srcBottomAlpha
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0.0f, 1.0f].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The function will work for all 4 channel float / channel image formats with alpha first in memory, not just BGRA.
 *      Also available as vImagePremultipliedAlphaBlend_RGBAFFFF.
 *
 * @param srcTop            The top image
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * @param flags             The following flags may be used:
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlend_BGRAFFFF( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImagePremultipliedAlphaBlend_RGBAFFFF( _srcTop, _srcBottom, _dest, _flags )    vImagePremultipliedAlphaBlend_BGRAFFFF((_srcTop), (_srcBottom), (_dest), (_flags))

/**
 * \function vImagePremultipliedAlphaBlendWithPermute_ARGB8888
 * \abstract Reorder the channels of the top 8-bit 4 channel premultiplied image, blend into a bottom premultiplied ARGB8888 image.
 * \discussion
 *  This function does 3 things.
 * <pre>\textblock
 *      1. Changes the order of channels of srcTop according to permuteMap.
 *      2. A premultiplied alpha compositing.
 *      3. Set destA to 0xFF when makeDestAlphaOpaque is true.
 *
 *      permuteMap[i] = 0, 1, 2, or 3 to specify how we permute each channel in srcTop.
 *
 *      permuteMap[0] tells which channel in srcTop XXXX8888 will be used as A.
 *      permuteMap[1] tells which channel in srcTop XXXX8888 will be used as R.
 *      permuteMap[2] tells which channel in srcTop XXXX8888 will be used as G.
 *      permuteMap[3] tells which channel in srcTop XXXX8888 will be used as B.
 * \/textblock</pre>
 *
 *  This permuteMap lets us to cover any channel order for the top and bottom images.
 *  For example,
 * <pre>\textblock
 *      PremultipliedAlphaBlend(srcTop_ARGB8888, srcBottom_ARGB8888) -> dest_ARGB8888
 *                     will be covered by permuteMap[4] = {0, 1, 2, 3}
 *
 *      PremultipliedAlphaBlend(srcTop_RGBA8888, srcBottom_ARGB8888) -> dest_ARGB8888
 *                     will be covered by permuteMap[4] = {3, 0, 1, 2}
 *
 *      PremultipliedAlphaBlend(srcTop_ABGR8888, srcBottom_ARGB8888) -> dest_ARGB8888
 *                     will be covered by permuteMap[4] = {0, 3, 2, 1}
 *
 *      PremultipliedAlphaBlend(srcTop_BGRA8888, srcBottom_ARGB8888) -> dest_ARGB8888
 *                     will be covered by permuteMap[4] = {3, 2, 1, 0}
 * \/textblock</pre>
 *
 *  srcBottom will have the same pixel format (ARGB8888) as dest.
 *
 *
 *  The per-pixel operation is:
 *
 * <pre>\textblock
 *  uint8_t *srcTop, *srcBottom, *dest;
 *  uint8_t srcTopA, srcTopR, srcTopG, srcTopB;
 *  uint8_t srcBottomA, srcBottomR, srcBottomG, srcBottomB;
 *  uint8_t destA, destR, destG, destB;
 *
 *  srcTopA = srcTop[ permuteMap[0] ];
 *  srcTopR = srcTop[ permuteMap[1] ];
 *  srcTopG = srcTop[ permuteMap[2] ];
 *  srcTopB = srcTop[ permuteMap[3] ];
 *
 *  srcBottomA = srcBottom[ 0 ];
 *  srcBottomR = srcBottom[ 1 ];
 *  srcBottomG = srcBottom[ 2 ];
 *  srcBottomB = srcBottom[ 3 ];
 *
 *  destR = (srcTopR * 255 + (255 - srcTopA) * srcBottomR + 127) / 255;
 *  destG = (srcTopG * 255 + (255 - srcTopA) * srcBottomG + 127) / 255;
 *  destB = (srcTopB * 255 + (255 - srcTopA) * srcBottomB + 127) / 255;
 *
 *  if(makeDestAlphaOpaque)
 *  {
 *
 *      dest[0] = 0xFF;
 *      dest[1] = destR;
 *      dest[2] = destG;
 *      dest[3] = destB;
 *  }
 *  else
 *  {
 *      destA = (srcTopA * 255 + (255 - srcTopA) * srcBottomA + 127) / 255;
 *
 *      dest[0] = destA;
 *      dest[1] = destR;
 *      dest[2] = destG;
 *      dest[3] = destB;
 *  }
 * \/textblock</pre>
 *
 *  This function can work in place.
 *
 *  @param srcTop       A pointer to vImage_Buffer that references 8-bit XXXX interleaved source top image.
 *  @param srcBottom    A pointer to vImage_Buffer that references 8-bit ARGB interleaved source bottom image.
 *  @param dest         A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination image.
 *  @param permuteMap   Values that can be used to switch the channel order of the source top image.
 *  @param makeDestAlphaOpaque  A boolean to set destA into 0xFF when it's true.
 *  @param flags        The following flags are allowed:
 * <pre>\textblock
 *      kvImageGetTempBufferSize    Returns 0. Does no work.
 *      kvImageDoNotTile            Disables internal multithreading, if any.
 * \/textblock</pre>
 * @return The following error codes may be returned:
 * <pre>\textblock
 *      kvImageNoError                  Is returned when there was no error.
 *      kvImageRoiLargerThanInputBuffer The destination buffers are larger than the source buffer.
 *      kvImageBufferSizeMismatch       Is returned when there is a mismatch in width & height of srcTop and srcBottom.
 *      kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 *      kvImageInvalidParameter         Is returned when the values in permuteMap[i] is not one of 0, 1, 2, or 3.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendWithPermute_ARGB8888(@Const vImage_Buffer srcTop,
                                                                         @Const vImage_Buffer srcBottom,
                                                                         @Const vImage_Buffer dest,
                                                                         @Cast("const uint8_t*") BytePointer permuteMap,
                                                                         @Cast("bool") boolean makeDestAlphaOpaque,
                                                                         @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendWithPermute_ARGB8888(@Const vImage_Buffer srcTop,
                                                                         @Const vImage_Buffer srcBottom,
                                                                         @Const vImage_Buffer dest,
                                                                         @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                                         @Cast("bool") boolean makeDestAlphaOpaque,
                                                                         @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendWithPermute_ARGB8888(@Const vImage_Buffer srcTop,
                                                                         @Const vImage_Buffer srcBottom,
                                                                         @Const vImage_Buffer dest,
                                                                         @Cast("const uint8_t*") byte[] permuteMap,
                                                                         @Cast("bool") boolean makeDestAlphaOpaque,
                                                                         @Cast("vImage_Flags") long flags );



/**
 * \function vImagePremultipliedAlphaBlendWithPermute_RGBA8888
 * \abstract Reorder the channels of the top 8-bit 4 channel premultiplied image, blend into a bottom premultiplied RGBA8888 image.
 * \discussion
 *  This function does 3 things.
 * <pre>\textblock
 *      1. Changes the order of channels of srcTop according to permuteMap.
 *      2. A premultiplied alpha compositing.
 *      3. Set destA to 0xFF when makeDestAlphaOpaque is true.
 *
 *      permuteMap[i] = 0, 1, 2, or 3 to specify how we permute each channel in srcTop.
 *
 *      permuteMap[0] tells which channel in srcTop XXXX8888 will be used as A.
 *      permuteMap[1] tells which channel in srcTop XXXX8888 will be used as R.
 *      permuteMap[2] tells which channel in srcTop XXXX8888 will be used as G.
 *      permuteMap[3] tells which channel in srcTop XXXX8888 will be used as B.
 * \/textblock</pre>
 *
 *  This permuteMap lets us to cover any channel order for the top and bottom images.
 *  For example,
 * <pre>\textblock
 *      PremultipliedAlphaBlend(srcTop_RGBA8888, srcBottom_RGBA8888) -> dest_RGBA8888
 *                     will be covered by permuteMap[4] = {0, 1, 2, 3}
 *
 *      PremultipliedAlphaBlend(srcTop_ARGB8888, srcBottom_RGBA8888) -> dest_RGBA8888
 *                     will be covered by permuteMap[4] = {1, 2, 3, 0}
 *
 *      PremultipliedAlphaBlend(srcTop_ABGR8888, srcBottom_RGBA8888) -> dest_RGBA8888
 *                     will be covered by permuteMap[4] = {3, 2, 1, 0}
 *
 *      PremultipliedAlphaBlend(srcTop_BGRA8888, srcBottom_RGBA8888) -> dest_RGBA8888
 *                     will be covered by permuteMap[4] = {2, 1, 0, 3}
 * \/textblock</pre>
 *
 *  srcBottom will have the same pixel format (RGBA8888) as dest.
 *
 *
 *  The per-pixel operation is:
 *
 * <pre>\textblock
 *  uint8_t *srcTop, *srcBottom, *dest;
 *  uint8_t srcTopA, srcTopR, srcTopG, srcTopB;
 *  uint8_t srcBottomA, srcBottomR, srcBottomG, srcBottomB;
 *  uint8_t destA, destR, destG, destB;
 *
 *  srcTopR = srcTop[ permuteMap[0] ];
 *  srcTopG = srcTop[ permuteMap[1] ];
 *  srcTopB = srcTop[ permuteMap[2] ];
 *  srcTopA = srcTop[ permuteMap[3] ];
 *
 *  srcBottomR = srcBottom[ 0 ];
 *  srcBottomG = srcBottom[ 1 ];
 *  srcBottomB = srcBottom[ 2 ];
 *  srcBottomA = srcBottom[ 3 ];
 *
 *  destR = (srcTopR * 255 + (255 - srcTopA) * srcBottomR + 127) / 255;
 *  destG = (srcTopG * 255 + (255 - srcTopA) * srcBottomG + 127) / 255;
 *  destB = (srcTopB * 255 + (255 - srcTopA) * srcBottomB + 127) / 255;
 *
 *  if(makeDestAlphaOpaque)
 *  {
 *
 *      dest[0] = 0xFF;
 *      dest[1] = destR;
 *      dest[2] = destG;
 *      dest[3] = destB;
 *  }
 *  else
 *  {
 *      destA = (srcTopA * 255 + (255 - srcTopA) * srcBottomA + 127) / 255;
 *
 *      dest[0] = destA;
 *      dest[1] = destR;
 *      dest[2] = destG;
 *      dest[3] = destB;
 *  }
 * \/textblock</pre>
 *
 *  This function can work in place.
 *
 *  @param srcTop       A pointer to vImage_Buffer that references 8-bit XXXX interleaved source top image.
 *  @param srcBottom    A pointer to vImage_Buffer that references 8-bit RGBA interleaved source bottom image.
 *  @param dest         A pointer to vImage_Buffer that references 8-bit RGBA interleaved destination image.
 *  @param permuteMap   Values that can be used to switch the channel order of the source top image.
 *  @param makeDestAlphaOpaque  A boolean to set destA into 0xFF when it's true.
 *  @param flags        The following flags are allowed:
 * <pre>\textblock
 *      kvImageGetTempBufferSize    Returns 0. Does no work.
 *      kvImageDoNotTile            Disables internal multithreading, if any.
 * \/textblock</pre>
 * @return The following error codes may be returned:
 * <pre>\textblock
 *      kvImageNoError                  Is returned when there was no error.
 *      kvImageRoiLargerThanInputBuffer The destination buffers are larger than the source buffer.
 *      kvImageBufferSizeMismatch       Is returned when there is a mismatch in width & height of srcTop and srcBottom.
 *      kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 *      kvImageInvalidParameter         Is returned when the values in permuteMap[i] is not one of 0, 1, 2, or 3.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendWithPermute_RGBA8888(@Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("bool") boolean makeDestAlphaOpaque, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendWithPermute_RGBA8888(@Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("bool") boolean makeDestAlphaOpaque, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendWithPermute_RGBA8888(@Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("const uint8_t*") byte[] permuteMap, @Cast("bool") boolean makeDestAlphaOpaque, @Cast("vImage_Flags") long flags );


/**
 *  \functiongroup Alpha Blend (Premultiplied, other blend modes)
 *  \discussion These alternative blend modes correspond to the blend modes required for SVG
 *              (http://www.w3.org/TR/SVG/filters.html, see feBlend)
 */

/**
 * \function vImagePremultipliedAlphaBlendMultiply_RGBA8888
 * \abstract blend two premultiplied RGBA8888 images using the Multiply blend mode to produce a premultiplied RGBA8888 result.
 * \discussion
 *      For each color channel:
 * <pre>\textblock
 *          uint8_t destColor =((255 -    srcTopAlpha) * srcBottomColor +
 *                              (255 - srcBottomAlpha) * srcTopColor +
 *                               srcTopColor * srcBottomColor + 127)/255;
 * \/textblock</pre>
 *      The output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          uint8_t alpha =  srcTopAlpha + ((255 - srcTopAlpha) * srcBottomAlpha + 127)/255;
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0, 255].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The function will work for all 4 channel 8-bit / channel image formats with alpha last in memory, not just RGBA.
 *      This function corresponds to the multiply blend mode in feBlend in the SVG standard. http://www.w3.org/TR/SVG/filters.html)
 *
 * @param srcTop            The top image
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * @param flags             The following flags may be used:
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendMultiply_RGBA8888( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedAlphaBlendScreen_RGBA8888
 * \abstract blend two premultiplied RGBA8888 images using the Screen blend mode to produce a premultiplied RGBA8888 result.
 * \discussion
 *      For each color channel:
 * <pre>\textblock
 *          uint8_t destColor = CLAMP( srcTopColor + srcBottomcolor - (srcTopColor * srcBottomColor + 127)/255, 0, 255);
 * \/textblock</pre>
 *      The output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          uint8_t alpha =  srcTopAlpha + ((255 - srcTopAlpha) * srcBottomAlpha + 127)/255;
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0, 255].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The function will work for all 4 channel 8-bit / channel image formats with alpha last in memory, not just RGBA.
 *      This function corresponds to the screen blend mode in feBlend in the SVG standard. http://www.w3.org/TR/SVG/filters.html)
 *
 * @param srcTop            The top image
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * @param flags             The following flags may be used:
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendScreen_RGBA8888( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedAlphaBlendDarken_RGBA8888
 * \abstract blend two premultiplied RGBA8888 images using the Darken blend mode to produce a premultiplied RGBA8888 result.
 * \discussion
 *      For each color channel:
 * <pre>\textblock
 *          uint8_t destColor = MIN( topColor +    ((255 - srcTopAlpha) *  srcBotomColor + 127) / 255,
 *                                   bottomColor + ((255 - srcBottomAlpha) * srcTopColor + 127) / 255);
 * \/textblock</pre>
 *      The output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          uint8_t alpha =  srcTopAlpha + ((255 - srcTopAlpha) * srcBottomAlpha + 127)/255;
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0, 255].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The function will work for all 4 channel 8-bit / channel image formats with alpha last in memory, not just RGBA.
 *      This function corresponds to the darken blend mode in feBlend in the SVG standard. http://www.w3.org/TR/SVG/filters.html)
 *
 * @param srcTop            The top image
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * @param flags             The following flags may be used:
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 *
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendDarken_RGBA8888( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedAlphaBlendLighten_RGBA8888
 * \abstract blend two premultiplied RGBA8888 images using the Lighten blend mode to produce a premultiplied RGBA8888 result.
 * \discussion
 *      For each color channel:
 * <pre>\textblock
 *          uint8_t destColor = MAX( topColor +    ((255 - srcTopAlpha) *  srcBotomColor + 127) / 255,
 *                                   bottomColor + ((255 - srcBottomAlpha) * srcTopColor + 127) / 255);
 * \/textblock</pre>
 *      The output alpha channel (the new alpha value for that pixel) can be calculated as:
 * <pre>\textblock
 *          uint8_t alpha =  srcTopAlpha + ((255 - srcTopAlpha) * srcBottomAlpha + 127)/255;
 * \/textblock</pre>
 *      The alpha values are presumed to be normalized over the range [0, 255].
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The function will work for all 4 channel 8-bit / channel image formats with alpha last in memory, not just RGBA.
 *      This function corresponds to the lighten blend mode in feBlend in the SVG standard. http://www.w3.org/TR/SVG/filters.html)
 *
 * @param srcTop            The top image
 * @param srcBottom         The bottom image
 * @param dest              The result image is written here. This buffer must be preallocated before the function is called.
 * @param flags             The following flags may be used:
 * <pre>\textblock
 *      kvImageNoFlags      Default operation
 *
 *      kvImageDoNotTile    Disable internal multithreading. You might want to do that if you are calling
 *                          this in the context of your own multithreaded tiling engine.
 * \/textblock </pre>
 *
 * @return  The following error codes may occur:
 * <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     The height and width of the result must be less than or equal to each of the input buffers.
 * \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultipliedAlphaBlendLighten_RGBA8888( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );




/**
 *  \functiongroup Premultiply Data
 *  \discussion  Multiply a non-premultiplied (normal) image with its
 *               alpha channel to produce a premultiplied image.
 */

/**
 *  \function vImagePremultiplyData_Planar8
 *  \abstract Multiply a Planar8 color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *  <pre>\textblock
 *      For each color channel:
 *
 *          uint8_t destColor = (src * alpha + 127) / 255;
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *  \/textblock </pre>
 *
 *  @param src      The color data to multiply with alpha
 *  @param alpha    The alpha data to multiply against src
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already  multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer alpha, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImagePremultiplyData_PlanarF
 *  \abstract Multiply a PlanarF color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *  <pre>\textblock
 *      For each color channel:
 *
 *          float destColor = src * alpha;
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *  \/textblock </pre>
 *
 *  @param src      The color data to multiply with alpha
 *  @param alpha    The alpha data to multiply against src
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already  multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer alpha, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImagePremultiplyData_ARGB8888
 *  \abstract Multiply a ARGB8888 color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *  <pre>\textblock
 *      For each color channel:
 *
 *          uint8_t destColor = (src * alpha + 127) / 255;
 *          uint8_t destAlpha = alpha;
 *
 *      This function can work in place provided the following are true:
 *          If src overlaps with dest, src->data must be equal to dest->data
 *          If src also has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *                  (It is not necessary to pass kvImageDoNotTile if src and dest do not overlap.)
 *  \/textblock </pre>
 *
 *      This function will for all 4 channel 8-bit / channel image formats with alpha first in memory.
 *      It does not have to be ARGB.
 *
 *  @param src      The color data to multiply with alpha
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImagePremultiplyData_ARGBFFFF
 *  \abstract Multiply a ARGBFFFF color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *  <pre>\textblock
 *      For each color channel:
 *
 *          float destColor = src * alpha;
 *          float destAlpha = alpha;
 *
 *      This function can work in place provided the following are true:
 *          If src overlaps with dest, src->data must be equal to dest->data
 *          If src also has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *                  (It is not necessary to pass kvImageDoNotTile if src and dest do not overlap.)
 *  \/textblock </pre>
 *
 *      This function will for all 4 channel float / channel image formats with alpha first in memory.
 *      It does not have to be ARGB.
 *
 *  @param src      The color data to multiply with alpha
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImagePremultiplyData_RGBA8888
 *  \abstract Multiply a RGBA8888 color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *  <pre>\textblock
 *      For each color channel:
 *
 *          uint8_t destColor = (src * alpha + 127) / 255;
 *          uint8_t destAlpha = alpha;
 *
 *      This function can work in place provided the following are true:
 *          If src overlaps with dest, src->data must be equal to dest->data
 *          If src also has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *                  (It is not necessary to pass kvImageDoNotTile if src and dest do not overlap.)
 *  \/textblock </pre>
 *
 *      This function will for all 4 channel 8-bit / channel image formats with alpha last in memory.
 *      It does not have to be RGBA. Also available as vImagePremultiplyData_BGRA8888().
 *
 *  @param src      The color data to multiply with alpha
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_RGBA8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImagePremultiplyData_BGRA8888( _src, _dest, _flags )           vImagePremultiplyData_RGBA8888((_src), (_dest), (_flags))

/**
 *  \function vImagePremultiplyData_RGBAFFFF
 *  \abstract Multiply a RGBAFFFF color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *  <pre>\textblock
 *      For each color channel:
 *
 *          float destColor = src * alpha;
 *          float destAlpha = alpha;
 *
 *      This function can work in place provided the following are true:
 *          If src overlaps with dest, src->data must be equal to dest->data
 *          If src also has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *                  (It is not necessary to pass kvImageDoNotTile if src and dest do not overlap.)
 *  \/textblock </pre>
 *
 *      This function will for all 4 channel float / channel image formats with alpha first in memory.
 *      It does not have to be RGBA. Also available as vImagePremultiplyData_BGRAFFFF().
 *
 *  @param src      The color data to multiply with alpha
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_RGBAFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImagePremultiplyData_BGRAFFFF( _src, _dest, _flags )           vImagePremultiplyData_RGBAFFFF((_src), (_dest), (_flags))

/**
 *  \function vImagePremultiplyData_RGBA16F
 *  \abstract Multiply a RGBA16F color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *  <pre>\textblock
 *      For each color channel:
 *
 *          float destColor = src * alpha;
 *          float destAlpha = alpha;
 *
 *      This function can work in place provided the following are true:
 *          If src overlaps with dest, src->data must be equal to dest->data
 *          If src also has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *                  (It is not necessary to pass kvImageDoNotTile if src and dest do not overlap.)
 *  \/textblock </pre>
 *
 *      This function will for all 4 channel 16F / channel image formats with alpha first in memory.
 *      It does not have to be RGBA. Also available as vImagePremultiplyData_BGRA16F().
 *
 *  @param src      The color data to multiply with alpha
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_RGBA16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImagePremultiplyData_BGRA16F( _src, _dest, _flags )           vImagePremultiplyData_RGBA16F((_src), (_dest), (_flags))

/**
 *  \function vImagePremultiplyData_ARGB16U
 *  \abstract Multiply a unsigned 16-bit ARGB color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *  <pre>\textblock
 *      For each color channel:
 *
 *          uint16_t destColor = (src * alpha + 32767) / 65535;
 *          uint16_t destAlpha = alpha;
 *
 *      This function can work in place provided the following are true:
 *          If src overlaps with dest, src->data must be equal to dest->data
 *          If src also has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *                  (It is not necessary to pass kvImageDoNotTile if src and dest do not overlap.)
 *  \/textblock </pre>
 *
 *      This function will for all 4 channel uint16_t / channel image formats with alpha first in memory.
 *      It does not have to be ARGB.
 *
 *  @param src      The color data to multiply with alpha
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_ARGB16U( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImagePremultiplyData_RGBA16U
 *  \abstract Multiply a unsigned 16-bit RGBA color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *  <pre>\textblock
 *      For each color channel:
 *
 *          uint16_t destColor = (src * alpha + 32767) / 65535;
 *          uint16_t destAlpha = alpha;
 *
 *      This function can work in place provided the following are true:
 *          If src overlaps with dest, src->data must be equal to dest->data
 *          If src also has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *                  (It is not necessary to pass kvImageDoNotTile if src and dest do not overlap.)
 *  \/textblock </pre>
 *
 *      This function will for all 4 channel uint16_t / channel image formats with alpha last in memory.
 *      It does not have to be RGBA. Also available as vImagePremultiplyData_BGRA16U().
 *
 *  @param src      The color data to multiply with alpha
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_RGBA16U( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImagePremultiplyData_BGRA16U( _src, _dest, _flags )           vImagePremultiplyData_RGBA16U((_src), (_dest), (_flags))


/**
 *  \function vImagePremultiplyData_ARGB16Q12
 *  \abstract Multiply a signed 16Q12 fixed-point ARGB color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *      For each color in each pixel:
 *  <pre>\textblock
 *          int16_t destColor = CLAMP((src * alpha + 2048) / 4096, INT16_MIN, INT16_MAX);
 *          int16_t destAlpha = alpha;
 *  \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          If src overlaps with dest, src->data must be equal to dest->data
 *          If src also has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *                  (It is not necessary to pass kvImageDoNotTile if src and dest do not overlap.)
 *
 *      This function will for other 4 channel 16Q12 / channel image formats with alpha first in memory.
 *      It does not have to be ARGB.
 *
 *  @param src      The color data to multiply with alpha
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_ARGB16Q12( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImagePremultiplyData_RGBA16Q12
 *  \abstract Multiply a signed 16Q12 RGBA color channel by its corresponding alpha
 *  \discussion
 *  This function multiplies color channels by the alpha channel.
 *      For each color in each pixel:
 *  <pre>\textblock
 *          int16_t destColor = CLAMP((src * alpha + 2048) / 4096, INT16_MIN, INT16_MAX);
 *          int16_t destAlpha = alpha;
 *  \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          If src overlaps with dest, src->data must be equal to dest->data
 *          If src also has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *                  (It is not necessary to pass kvImageDoNotTile if src and dest do not overlap.)
 *
 *      This function will for all 4 channel 16Q12 / channel image formats with alpha last in memory.
 *      It does not have to be RGBA.
 *
 *  @param src      The color data to multiply with alpha
 *  @param dest     A preallocated vImage_Buffer where the results are written
 *  @param flags    The following flags are allowed:
 *  <pre>\textblock
 *          kvImageNoFlags                      Default operation
 *
 *          kvImageDoNotTile                    Turn off internal multithreading. This might be useful if you are already multithreading
 *                                              the work in your own tiling engine.
 *  \/textblock </pre>
 *  @return         The following result codes may occur:
 *  <pre>\textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->width and dest->height must be less than or equal to corresponding
 *                                              dimensions in src and alpha
 *  \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultiplyData_RGBA16Q12( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \functiongroup Unpremultiply Data
 *  \discussion Divide a premultiplied image by its alpha channel to produce a non-premultiplied image.
 */

/**
 *  \function vImageUnpremultiplyData_Planar8
 *  \abstract Divide alpha from a premultiplied Planar8 images
 *
 *  \discussion This function divides color channels by the alpha channel.
 *      For each color channel:
 *  <pre>\textblock
 *          uint8_t destColor = ( MIN(src_color, alpha) * 255 + alpha/2) / alpha;
 *  \/textblock </pre>
 *      ...which is the nearest unpremultiplied result, with clamping to ensure no modulo overflow in cases where srcColor > srcAlpha.
 *      In the division by zero case, the returned color value is 0.
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data.
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *  @param src          The planar8 input color channel
 *  @param alpha        The planar8 input alpha channel
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer alpha, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );


/**
 *  \function vImageUnpremultiplyData_PlanarF
 *  \abstract Divide alpha from a premultiplied PlanarF images
 *
 *  \discussion This function divides color channels by the alpha channel.
 *      For each color channel:
 *  <pre>\textblock
 *          float destColor = destColor / alpha;   // according to current rounding mode
 *  \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data.
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *  @param src          The planarF input color channel
 *  @param alpha        The planarF input alpha channel
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer alpha, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageUnpremultiplyData_ARGB8888
 *  \abstract Divide the alpha channel from the color channels in a ARGB8888 image
 *  \discussion
 *  This function divides color channels by the alpha channel.
 *      For each color channel:
 *      <pre>\textblock
 *          uint8_t destColor = ( MIN(src_color, alpha) * 255 + alpha/2) / alpha;
 *          uint8_t destAlpha = alpha;
 *      \/textblock </pre>
 *
 *      ...which is the nearest unpremultiplied result, with clamping to ensure no modulo overflow in cases where srcColor > srcAlpha.
 *      In the division by zero case, the returned color value is 0.
 *
 *      The positioning of only the alpha channel is important for interleaved formats for these functions.
 *      This function will work with other channel orders that have alpha first.
 *
 *      This function can work in place provided the following are true:
 *          src->data must be equal to dest->data
 *          src->rowBytes must be equal to dest->rowBytes
 *
 *  @param src          The input inmage
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageUnpremultiplyData_RGBA8888
 *  \abstract Divide the alpha channel from the color channels in a RGBA8888 image
 *  \discussion
 *  This function divides color channels by the alpha channel.
 *      For each color channel:
 *      <pre>\textblock
 *          uint8_t destColor = ( MIN(src_color, alpha) * 255 + alpha/2) / alpha;
 *          uint8_t destAlpha = alpha;
 *      \/textblock </pre>
 *
 *      ...which is the nearest unpremultiplied result, with clamping to ensure no modulo overflow in cases where srcColor > srcAlpha.
 *      In the division by zero case, the returned color value is 0.
 *
 *      The positioning of only the alpha channel is important for interleaved formats for these functions.
 *      This function will work with other channel orders that have alpha last. The function is also available as vImageUnpremultiplyData_BGRA8888.
 *
 *      This function can work in place provided the following are true:
 *          src->data must be equal to dest->data
 *          src->rowBytes must be equal to dest->rowBytes
 *
 *  @param src          The input inmage
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_RGBA8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImageUnpremultiplyData_BGRA8888( _src, _dest, _flags )             vImageUnpremultiplyData_RGBA8888((_src), (_dest), (_flags))

/**
 *  \function vImageUnpremultiplyData_ARGBFFFF
 *  \abstract Divide the alpha channel from the color channels in a ARGBFFFF image
 *  \discussion
 *  This function divides color channels by the alpha channel.
 *      For each color channel:
 *      <pre>\textblock
 *          float destColor = destColor / alpha;
 *          float destAlpha = alpha;
 *      \/textblock </pre>
 *
 *      The positioning of only the alpha channel is important for interleaved formats for these functions.
 *      This function will work with other channel orders that have alpha first.
 *
 *      This function can work in place provided the following are true:
 *          src->data must be equal to dest->data
 *          src->rowBytes must be equal to dest->rowBytes
 *
 *  @param src          The input inmage
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );


/**
 *  \function vImageUnpremultiplyData_RGBAFFFF
 *  \abstract Divide the alpha channel from the color channels in a RGBAFFFF image
 *  \discussion
 *  This function divides color channels by the alpha channel.
 *      For each color channel:
 *      <pre>\textblock
 *          float destColor = destColor / alpha;
 *          float destAlpha = alpha;
 *      \/textblock </pre>
 *
 *      The positioning of only the alpha channel is important for interleaved formats for these functions.
 *      This function will work with other channel orders that have alpha last. It is also available as vImageUnpremultiplyData_BGRAFFFF().
 *
 *      This function can work in place provided the following are true:
 *          src->data must be equal to dest->data
 *          src->rowBytes must be equal to dest->rowBytes
 *
 *  @param src          The input inmage
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_RGBAFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImageUnpremultiplyData_BGRAFFFF( _src, _dest, _flags )             vImageUnpremultiplyData_RGBAFFFF((_src), (_dest), (_flags))


/**
 *  \function vImageUnpremultiplyData_RGBA16F
 *  \abstract Divide the alpha channel from the color channels in a RGBA16F image
 *  \discussion
 *  This function divides color channels by the alpha channel.
 *      For each color channel:
 *      <pre>\textblock
 *          float destColor = destColor / alpha;
 *          float destAlpha = alpha;
 *      \/textblock </pre>
 *
 *      The positioning of only the alpha channel is important for interleaved formats for these functions.
 *      This function will work with other channel orders that have alpha last. It is also available as vImageUnpremultiplyData_BGRA16F().
 *
 *      This function can work in place provided the following are true:
 *          src->data must be equal to dest->data
 *          src->rowBytes must be equal to dest->rowBytes
 *
 *  @param src          The input image
 *  @param dest         A preallocated 16F destination buffer into which the result will be written.
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_RGBA16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImageUnpremultiplyData_BGRA16F( _src, _dest, _flags )             vImageUnpremultiplyData_RGBA16F((_src), (_dest), (_flags))

/**
 *  \function vImageUnpremultiplyData_ARGB16U
 *  \abstract Divide the alpha channel from the color channels in a ARGB16U image
 *  \discussion
 *  This function divides color channels by the alpha channel.
 *      For each color channel:
 *      <pre>\textblock
 *          uint16_t destColor = ( MIN(src_color, alpha) * 65535 + alpha/2) / alpha;
 *          uint16_t destAlpha = alpha;
 *      \/textblock </pre>
 *
 *      ...which is the nearest unpremultiplied result, with clamping to ensure no modulo overflow in cases where srcColor > srcAlpha.
 *      In the division by zero case, the returned color value is 0.
 *
 *      The positioning of only the alpha channel is important for interleaved formats for these functions.
 *      This function will work with other channel orders that have alpha first.
 *
 *      This function can work in place provided the following are true:
 *          src->data must be equal to dest->data
 *          src->rowBytes must be equal to dest->rowBytes
 *
 *  @param src          The input inmage
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_ARGB16U( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );


/**
 *  \function vImageUnpremultiplyData_RGBA16U
 *  \abstract Divide the alpha channel from the color channels in a RGBA16U image
 *  \discussion
 *  This function divides color channels by the alpha channel.
 *      For each color channel:
 *      <pre>\textblock
 *          uint16_t destColor = ( MIN(src_color, alpha) * 65535 + alpha/2) / alpha;
 *          uint16_t destAlpha = alpha;
 *      \/textblock </pre>
 *
 *      ...which is the nearest unpremultiplied result, with clamping to ensure no modulo overflow in cases where srcColor > srcAlpha.
 *      In the division by zero case, the returned color value is 0.
 *
 *      The positioning of only the alpha channel is important for interleaved formats for these functions.
 *      This function will work with other channel orders that have alpha last. The function is also available as vImageUnpremultiplyData_BGRA16U.
 *
 *      This function can work in place provided the following are true:
 *          src->data must be equal to dest->data
 *          src->rowBytes must be equal to dest->rowBytes
 *
 *  @param src          The input inmage
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_RGBA16U( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImageUnpremultiplyData_BGRA16U( _src, _dest, _flags )             vImageUnpremultiplyData_RGBA16U((_src), (_dest), (_flags))

/**
 *  \function vImageUnpremultiplyData_ARGB16Q12
 *  \abstract Divide the alpha channel from the color channels in a ARGB16Q12 image
 *  \discussion
 *  This function divides color channels by the alpha channel.
 *      For each color channel:
 *      <pre>\textblock
 *          int16_t destColor = ( MIN(src_color, alpha) * 4096 + alpha/2) / alpha;
 *          int16_t destAlpha = alpha;
 *      \/textblock </pre>
 *
 *      ...which is the nearest unpremultiplied result, with clamping to ensure no modulo overflow in cases where srcColor > srcAlpha.
 *      In the division by zero case, the returned color value is 0.
 *
 *      The positioning of only the alpha channel is important for interleaved formats for these functions.
 *      This function will work with other channel orders that have alpha first.
 *
 *      This function can work in place provided the following are true:
 *          src->data must be equal to dest->data
 *          src->rowBytes must be equal to dest->rowBytes
 *
 *  @param src          The input inmage
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_ARGB16Q12( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );


/**
 *  \function vImageUnpremultiplyData_RGBA16Q12
 *  \abstract Divide the alpha channel from the color channels in a RGBA16Q12 image
 *  \discussion
 *  This function divides color channels by the alpha channel.
 *      For each color channel:
 *      <pre>\textblock
 *          int16_t destColor = ( MIN(src_color, alpha) * 4096 + alpha/2) / alpha;
 *          int16_t destAlpha = alpha;
 *      \/textblock </pre>
 *
 *      ...which is the nearest unpremultiplied result, with clamping to ensure no modulo overflow in cases where srcColor > srcAlpha.
 *      In the division by zero case, the returned color value is 0.
 *
 *      The positioning of only the alpha channel is important for interleaved formats for these functions.
 *      This function will work with other channel orders that have alpha last.
 *
 *      This function can work in place provided the following are true:
 *          src->data must be equal to dest->data
 *          src->rowBytes must be equal to dest->rowBytes
 *
 *  @param src          The input inmage
 *  @param dest         A preallocated planar8 destination buffer into which the result will be written.'
 *  @param flags        The following flags are allowed:
 *      <pre>\textblock
 *                      kvImageNoFlags          Default operation
 *
 *                      kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *
 *  @return The following error codes may be returned:
 *      <pre>\textblock
 *                      kvImageNoError                      Success
 *
 *                      kvImageRoiLargerThanInputBuffer     dest->height or width is larger than the corresponding src or alpha dimension
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageUnpremultiplyData_RGBA16Q12( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \functiongroup Alpha Blend (Premultiplied with additional constant alpha)
 * \discussion  A premultiplied alpha blend with an extra constant alpha applied to the top image to allow
 *              it to be faded in our out.
 */

/**
 * \function vImagePremultipliedConstAlphaBlend_Planar8
 * \abstract Blend two Planar8 premultiplied images with an extra image-wide alpha for the top image
 * \discussion  This is a premultiplied alpha compositing function using a constant for alpha over the whole image.
 *  Color data from both images is presumed to be already premultiplied by its own per-pixel alpha.
 *      For calculations involving 8-bit integer data, the calculation is done with an additional rounding step
 *      followed by division by 255:
 * <pre>\textblock
 *          uint8_t destColor = (srcTopColor * constAlpha * 255  + (255*255 - srcTopAlpha * constAlpha) * srcBottomColor + 127*255) / (255*255);
 *          uint8_t destAlpha =  (srcTopAlpha * constAlpha * 255 + (255*255 - srcTopAlpha * constAlpha) * srcBottomAlpha + 127*255 ) / (255*255);
 * \/textblock</pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 * @param srcTop        The top image
 * @param constAlpha    An extra alpha to apply to the entire top image
 * @param srcTopAlpha   The alpha channel for the top image
 * @param srcBottom     The bottom image
 * @param dest          A preallocate vImage_Buffer where the result will be written
 * @param flags         The following flags are allowed:
 * <pre>\textblock
 *          kvImageNoFlags          Default operation
 *
 *          kvImageDoNotTile        Turn off internal multithreading
 * \/textblock</pre>
 * @return The following error codes may be returned:
 * <pre>\textblock
 *          kvImageNoError                      Success
 *
 *          kvImageRoiLargerThanInputBuffer     The destination buffer height or width is larger than the corresponding dimension in
 *                                              srcTop, srcTopAlpha or srcBottom
 * \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultipliedConstAlphaBlend_Planar8( @Const vImage_Buffer srcTop, @Cast("uint8_t") byte constAlpha, @Const vImage_Buffer srcTopAlpha, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedConstAlphaBlend_PlanarF
 * \abstract Blend two PlanarF premultiplied images with an extra image-wide alpha for the top image
 * \discussion  This is a premultiplied alpha compositing function using a constant for alpha over the whole image.
 *  Color data from both images is presumed to be already premultiplied by its own per-pixel alpha.
 * <pre>\textblock
 *          float destColor = srcTopColor * constAlpha  + (1.0 - srcTopAlpha  * constAlpha) * srcBottomColor;
 *          float alpha =  srcTopAlpha * constAlpha + (1.0 - srcTopAlpha * constAlpha) * srcBottomAlpha
 * \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 * @param srcTop        The top image
 * @param constAlpha    An extra alpha to apply to the entire top image
 * @param srcTopAlpha   The alpha channel for the top image
 * @param srcBottom     The bottom image
 * @param dest          A preallocate vImage_Buffer where the result will be written
 * @param flags         The following flags are allowed:
 * <pre>\textblock
 *          kvImageNoFlags          Default operation
 *
 *          kvImageDoNotTile        Turn off internal multithreading
 * \/textblock</pre>
 * @return The following error codes may be returned:
 * <pre>\textblock
 *          kvImageNoError                      Success
 *
 *          kvImageRoiLargerThanInputBuffer     The destination buffer height or width is larger than the corresponding dimension in
 *                                              srcTop, srcTopAlpha or srcBottom
 * \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultipliedConstAlphaBlend_PlanarF( @Const vImage_Buffer srcTop, @Cast("float") float constAlpha, @Const vImage_Buffer srcTopAlpha, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedConstAlphaBlend_ARGB8888
 * \abstract Blend two ARGB8888 premultiplied images with an extra image-wide alpha for the top image
 * \discussion  This is a premultiplied alpha compositing function using a constant for alpha over the whole image.
 *  Color data from both images is presumed to be already premultiplied by its own per-pixel alpha.
 *      For calculations involving 8-bit integer data, the calculation is done with an additional rounding step
 *      followed by division by 255:
 * <pre>\textblock
 *          uint8_t destColor = (srcTopColor * constAlpha * 255  + (255*255 - srcTopAlpha * constAlpha) * srcBottomColor + 127*255) / (255*255);
 *          uint8_t destAlpha =  (srcTopAlpha * constAlpha * 255 + (255*255 - srcTopAlpha * constAlpha) * srcBottomAlpha + 127*255 ) / (255*255);
 * \/textblock</pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The  function will work for all 4 channel 8-bit / channel image formats with alpha first in memory, not just ARGB.
 * @param srcTop        The top image
 * @param constAlpha    An extra alpha to apply to the entire top image
 * @param srcBottom     The bottom image
 * @param dest          A preallocate vImage_Buffer where the result will be written
 * @param flags         The following flags are allowed:
 * <pre>\textblock
 *          kvImageNoFlags          Default operation
 *
 *          kvImageDoNotTile        Turn off internal multithreading
 * \/textblock</pre>
 * @return The following error codes may be returned:
 * <pre>\textblock
 *          kvImageNoError                      Success
 *
 *          kvImageRoiLargerThanInputBuffer     The destination buffer height or width is larger than the corresponding dimension in
 *                                              srcTop, srcTopAlpha or srcBottom
 * \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultipliedConstAlphaBlend_ARGB8888( @Const vImage_Buffer srcTop, @Cast("uint8_t") byte constAlpha, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImagePremultipliedConstAlphaBlend_ARGBFFFF
 * \abstract Blend two ARGBFFFF premultiplied images with an extra image-wide alpha for the top image
 * \discussion  This is a premultiplied alpha compositing function using a constant for alpha over the whole image.
 *  Color data from both images is presumed to be already premultiplied by its own per-pixel alpha.
 *      For calculations involving 8-bit integer data, the calculation is done with an additional rounding step
 *      followed by division by 255:
 * <pre>\textblock
 *          float destColor = srcTopColor * constAlpha  + (1.0 - srcTopAlpha  * constAlpha) * srcBottomColor;
 *          float alpha =  srcTopAlpha * constAlpha + (1.0 - srcTopAlpha * constAlpha) * srcBottomAlpha
 * \/textblock</pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      The function will work for all 4 channel float / channel image formats with alpha first in memory, not just ARGB.
 * @param srcTop        The top image
 * @param constAlpha    An extra alpha to apply to the entire top image
 * @param srcBottom     The bottom image
 * @param dest          A preallocate vImage_Buffer where the result will be written
 * @param flags         The following flags are allowed:
 * <pre>\textblock
 *          kvImageNoFlags          Default operation
 *
 *          kvImageDoNotTile        Turn off internal multithreading
 * \/textblock</pre>
 * @return The following error codes may be returned:
 * <pre>\textblock
 *          kvImageNoError                      Success
 *
 *          kvImageRoiLargerThanInputBuffer     The destination buffer height or width is larger than the corresponding dimension in
 *                                              srcTop, srcTopAlpha or srcBottom
 * \/textblock</pre>
 */
public static native @Cast("vImage_Error") long vImagePremultipliedConstAlphaBlend_ARGBFFFF( @Const vImage_Buffer srcTop, @Cast("float") float constAlpha, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \functiongroup Alpha Blend (Non-premultiplied to premultiplied)
 *  \discussion    These functions blend a non-premultiplied top image into a premultiplied bottom image
 *                 to produce a premultiplied result.
 */

/**
 * \function vImageAlphaBlend_NonpremultipliedToPremultiplied_Planar8
 * \abstract Blend a non-premultiplied top Planar8 image into a premultiplied Planar8 bottom image and return a premultiplied Planar8 result.
 * \discussion Top buffer is non-premultiplied. Bottom buffer is premultiplied. Dest buffer is premultiplied. Works in place.
 * <pre>\textblock
 *      result = (srcTop * srctopAlpha + (255 - srcTopAlpha) * bottomAlpha + 127 ) / 255;
 * \/textblock </pre>
 * This function will work in place as long as the src and dest buffer overlap exactly.
 * The src buffers must be at least as large as the dest buffer in each dimension. (src.height >= dest.height && src.width >= dest.width)
 *
 *  To calculate the alpha result for the Planar cases, use
 * <pre>\textblock
 *      vImagePremultipliedAlphaBlend_Planar8( srcTopAlpha, srcTopAlpha, srcBottomAlpha, dest, flags );
 * \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 * @param srcTop        Planar8 non-premultiplied color channel for top image
 * @param srcTopAlpha   Planar8 alpha channel for top image
 * @param srcBottom     Planar8 premultiplied color channel for bottom image
 * @param dest          Planar8 premultiplied result. Must be preallocated before the call is made.
 * @param flags         The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageAlphaBlend_NonpremultipliedToPremultiplied_Planar8( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcTopAlpha, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImageAlphaBlend_NonpremultipliedToPremultiplied_PlanarF
 * \abstract Blend a non-premultiplied top PlanarF image into a premultiplied PlanarF bottom image and return a premultiplied PlanarF result.
 * \discussion Top buffer is non-premultiplied. Bottom buffer is premultiplied. Dest buffer is premultiplied. Works in place.
 * <pre>\textblock
 *      result = srcTop * srcTopAlpha + (1 - srcTopAlpha) * srcBottom
 * \/textblock </pre>
 * This function will work in place as long as the src and dest buffer overlap exactly.
 * The src buffers must be at least as large as the dest buffer in each dimension. (src.height >= dest.height && src.width >= dest.width)
 *
 *  To calculate the alpha result for the Planar cases, use
 * <pre>\textblock
 *      vImagePremultipliedAlphaBlend_PlanarF( srcTopAlpha, srcTopAlpha, srcBottomAlpha, dest, flags );
 * \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 * @param srcTop        Planar8 non-premultiplied color channel for top image
 * @param srcTopAlpha   Planar8 alpha channel for top image
 * @param srcBottom     Planar8 premultiplied color channel for bottom image
 * @param dest          Planar8 premultiplied result. Must be preallocated before the call is made.
 * @param flags         The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageAlphaBlend_NonpremultipliedToPremultiplied_PlanarF( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcTopAlpha, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImageAlphaBlend_NonpremultipliedToPremultiplied_ARGB8888
 * \abstract Blend a non-premultiplied top ARGB8888 image into a premultiplied ARGB8888 bottom image and return a premultiplied ARGB8888 result.
 * \discussion Top buffer is non-premultiplied. Bottom buffer is premultiplied. Dest buffer is premultiplied. Works in place.
 * <pre>\textblock
 *      result = (srcTop * srctopAlpha + (255 - srcTopAlpha) * bottomAlpha + 127 ) / 255;
 * \/textblock </pre>
 * This function will work in place as long as the src and dest buffer overlap exactly.
 * The src buffers must be at least as large as the dest buffer in each dimension. (src.height >= dest.height && src.width >= dest.width)
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *  This function will work with any channel order with alpha first, not just ARGB.
 *
 * @param srcTop        Planar8 non-premultiplied color channel for top image
 * @param srcBottom     Planar8 premultiplied color channel for bottom image
 * @param dest          Planar8 premultiplied result. Must be preallocated before the call is made.
 * @param flags         The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageAlphaBlend_NonpremultipliedToPremultiplied_ARGB8888( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \function vImageAlphaBlend_NonpremultipliedToPremultiplied_ARGBFFFF
 * \abstract Blend a non-premultiplied top ARGBFFFF image into a premultiplied ARGBFFFF bottom image and return a premultiplied ARGBFFFF result.
 * \discussion Top buffer is non-premultiplied. Bottom buffer is premultiplied. Dest buffer is premultiplied. Works in place.
 * <pre>\textblock
 *      result = srcTop * srcTopAlpha + (1 - srcTopAlpha) * srcBottom
 * \/textblock </pre>
 * This function will work in place as long as the src and dest buffer overlap exactly.
 * The src buffers must be at least as large as the dest buffer in each dimension. (src.height >= dest.height && src.width >= dest.width)
 *
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *  This function will work with any channel order with alpha first, not just ARGB.
 *
 * @param srcTop        Planar8 non-premultiplied color channel for top image
 * @param srcBottom     Planar8 premultiplied color channel for bottom image
 * @param dest          Planar8 premultiplied result. Must be preallocated before the call is made.
 * @param flags         The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageAlphaBlend_NonpremultipliedToPremultiplied_ARGBFFFF( @Const vImage_Buffer srcTop, @Const vImage_Buffer srcBottom, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 * \functiongroup Clip To Alpha
 * \discusssion  If a premultiplied image color channel has a value greater than alpha it is super-opaque.  This may
 *               cause problems later in compositing operations. Alpha > color can happen normally as a result of
 *               convolutions, resampling, and morphological operations. While such operations should generally be done
 *               on non-premultiplied content, sometimes premultiplied content slips through. vImage provides a clamping
 *               function vImageClipToAlpha which identify color channels that are greater than alpha and clamp them to be
 *               equal to alpha.
 */

/**
 *  \function vImageClipToAlpha_Planar8
 *  \abstract Clamp a Planar8 color buffer to be less than or equal to alpha
 *  \discussion
 *  For each pixel, each color channel shall be set to the smaller of the color channel or alpha value for that pixel.
 *  <pre>\textblock
 *          color_result = MIN( color, alpha )
 *  \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *  @param src      The color image to clip
 *  @param alpha    The alpha channel
 *  @param dest     A preallocated buffer to receive the results.
 *  @param flags    The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageClipToAlpha_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer alpha, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageClipToAlpha_PlanarF
 *  \abstract Clamp a PlanarF color buffer to be less than or equal to alpha
 *  \discussion
 *  For each pixel, each color channel shall be set to the smaller of the color channel or alpha value for that pixel.
 *  <pre>\textblock
 *          color_result = MIN( color, alpha )
 *  \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *  @param src      The color image to clip
 *  @param alpha    The alpha channel
 *  @param dest     A preallocated buffer to receive the results.
 *  @param flags    The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageClipToAlpha_PlanarF( @Const vImage_Buffer src,  @Const vImage_Buffer alpha,  @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageClipToAlpha_ARGB8888
 *  \abstract Clamp a ARGB8888 color buffer to be less than or equal to alpha
 *  \discussion
 *  For each pixel, each color channel shall be set to the smaller of the color channel or alpha value for that pixel.
 *  <pre>\textblock
 *          alpha_result = alpha
 *          color_result = MIN( color, alpha )
 *  \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      This function will work for any channel order with alpha first, not just ARGB.
 *
 *  @param src      The color image to clip
 *  @param dest     A preallocated buffer to receive the results.
 *  @param flags    The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageClipToAlpha_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageClipToAlpha_ARGBFFFF
 *  \abstract Clamp a ARGBFFFF color buffer to be less than or equal to alpha
 *  \discussion
 *  For each pixel, each color channel shall be set to the smaller of the color channel or alpha value for that pixel.
 *  <pre>\textblock
 *          alpha_result = alpha
 *          color_result = MIN( color, alpha )
 *  \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      This function will work for any channel order with alpha first, not just ARGB.
 *
 *  @param src      The color image to clip
 *  @param dest     A preallocated buffer to receive the results.
 *  @param flags    The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageClipToAlpha_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageClipToAlpha_RGBA8888
 *  \abstract Clamp a RGBA8888 color buffer to be less than or equal to alpha
 *  \discussion
 *  For each pixel, each color channel shall be set to the smaller of the color channel or alpha value for that pixel.
 *  <pre>\textblock
 *          alpha_result = alpha
 *          color_result = MIN( color, alpha )
 *  \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      This function will work for any channel order with alpha last, not just RGBA. Also available as vImageClipToAlpha_BGRA8888().
 *
 *  @param src      The color image to clip
 *  @param dest     A preallocated buffer to receive the results.
 *  @param flags    The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageClipToAlpha_RGBA8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define vImageClipToAlpha_BGRA8888(_src, _dest, _flags)   vImageClipToAlpha_RGBA8888((_src), (_dest), (_flags))

/**
 *  \function vImageClipToAlpha_RGBAFFFF
 *  \abstract Clamp a RGBAFFFF color buffer to be less than or equal to alpha
 *  \discussion
 *  For each pixel, each color channel shall be set to the smaller of the color channel or alpha value for that pixel.
 *  <pre>\textblock
 *          alpha_result = alpha
 *          color_result = MIN( color, alpha )
 *  \/textblock </pre>
 *      This function can work in place provided the following are true:
 *          For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data
 *          If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 *
 *      This function will work for any channel order with alpha last, not just RGBA. Also available as vImageClipToAlpha_BGRAFFFF().
 *
 *  @param src      The color image to clip
 *  @param dest     A preallocated buffer to receive the results.
 *  @param flags    The following flags are allowed:
 *      <pre> \textblock
 *          kvImageNoFlags          Default operation.
 *
 *          kvImageDoNotTile        Disable internal multithreading.
 *      \/textblock </pre>
 *  @return     The following error codes may occur:
 *      <pre> \textblock
 *          kvImageNoError                      Success.
 *
 *          kvImageRoiLargerThanInputBuffer     dest->height and dest->width must be less than or equal to corresponding
 *                                              dimensions in srcTop, srcTopAlpha and srcBottom.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageClipToAlpha_RGBAFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define vImageClipToAlpha_BGRAFFFF(_src, _dest, _flags)   vImageClipToAlpha_RGBAFFFF((_src), (_dest), (_flags))

/*
 * See also the vImageFlatten APIs in Conversion.h for compositing an image against a constant color opaque background.
 */

// #ifdef __cplusplus
// #endif

// #endif /* vImage_ALPHA_H */




// Parsed from Convolution.h

/**
*  \header Convolution.h
*  vImage_Framework
*
*  See vImage/vImage.h for more on how to view the headerdoc documentation for functions declared herein.
*
*  \copyright Copyright (c) 2002-2020 by Apple Inc. All rights reserved.
*
*  \discussion Convolution is a weighted average between a pixel and its neighboring pixels. By smoothing
*              out high frequency signal, convolution can be used to blur an image. By subtracting out the
*              low frequency signal, it can be used to produce a sharpening effect. Convolution is also used
*              with a variety of filters such as Laplace and Sobel to detect edges in the image. Here we also
*              provide a deconvolution filter that attempts to iteratively undo the effect of a convolution.
*              Where the convolution kernel can be accurately determined, it can be used to remove focus
*              problems, motion blur and distortion introduced by the lens.
*
*      <pre>\textblock
*              =========================================================================
*              ======    MOST VIMAGE CONVOLUTION FUNCTIONS DO NOT WORK IN PLACE    =====
*              =========================================================================
*      \/textblock </pre>
*
*              Since a weighted average of nearby pixels can for some positions extend off the edge of the
*              input image, a variety of edging modes are provided which specify what happens in such
*              cases:
*      <pre>\textblock
*              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
*                                          copy the corresponding source pixel to the destination. This
*                                          will result in a ring off unconvolved content at the edges
*                                          and convolved content in the middle.
*
*              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
*                                          For a blur filter this will look like the edges of the image
*                                          have been blurred into a particular color. This is usually
*                                          appropriate when the color of the surface onto which the image
*                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
*                                          as a background color, and let the downstream image compositor
*                                          blend in the background color. In this case, the result image
*                                          should be treated as a premultiplied image.
*
*              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
*                                          This is better when the image is drawn into a frame or other
*                                          context where the background is not expected to contribute to
*                                          the final content.
*
*              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
*                                          simply ignored, and the bias and divisor are adjusted accordingly.
*                                          Because of the complication at the edges, this edging mode can
*                                          be significantly slower than the others. It can be numerically
*                                          unstable if the sum over any rectangular subsection of the kernel
*                                          is zero, which can result in division by zero during the computation.
*                                          The results for this edging mode are usually quite visually similar
*                                          to kvImageEdgeExtend.
*      \/textblock </pre>
*              Only one edging mode may be active at a time.  Please see the Convolution section in
*              the vImage Programming Guide for a better description of edging modes.
*              (https://developer.apple.com/library/ios/documentation/Performance/Conceptual/vImage/vImage.pdf)
*
*
*              When calling these interfaces from within the context of your own tiling engine,
*              it may be necessary to produce a result tile starting from different points in the
*              input image. Simply repackaging the input image by adjusting the height, width and
*              src->data to achieve this affect will not work correctly because it introduces
*              artificial edges into the input image. (See discussion of edging modes above.)
*              Instead, X and Y offset parameters are provided. Simply pass in the whole input image
*              and use the X and Y offsets to adjust the position of the content used to produce
*              the output image.  The size of the output tile is given by the dest->height and width.
*
*  \ignorefuncmacro VIMAGE_NON_NULL
*/


// #ifndef VIMAGE_CONVOLUTION_H
// #define VIMAGE_CONVOLUTION_H


// #ifdef __cplusplus
// #endif

// #include <vImage/vImage_Types.h>

/**
 *  \functiongroup General Convolution
 *  \discussion A general convolve filter allows you to provide an arbitrary set of weights to use
 *              in the weighted average between each pixel and its neighbors. As such, it is a
 *              very flexible tool for achieving a variety of image effects, from blurring to sharpening
 *              to edge detection to sub-pixel image translation and motion blur.
 *
 *              Some filters such as edge detection filters take the first derivative of the image
 *              surface. Since a derivative can be either positive or negative  and some formats such
 *              as Planar8 (unorm8) can only represent positive numbers, the general convolution is also
 *              available in a form which allows you to provide a bias to add to the weighted sum before
 *              the divisor is applied, to shift the values into the positive.  You might provide a
 *              bias of 128 * divisor to move the encoding for 0 to 128 so that negative numbers are
 *              representable, for example. (In this case, -20 would now be encoded as 128-20=108.)
 *
 *              Finally, vImage provides multikernel convolution, which allows a different kernel, bias
 *              and divisor to be used for each color channel. This might allow for the position of the
 *              different color channels to be shifted independently, or for alpha to be blurred differently
 *              from color.
 *      <pre>\textblock
 *              =========================================================================
 *              ======    MOST VIMAGE CONVOLUTION FUNCTIONS DO NOT WORK IN PLACE    =====
 *              =========================================================================
 *      \/textblock </pre>
 */

/**
 *  \function vImageConvolve_Planar8
 *  \abstract General convolution on a Planar8 image.
 *  \discussion This filter applies a convolution filter of your choosing to a Planar8 image.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              int sum = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sum += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2];
 *              }
 *              // Correct for the scaling introduced by multiplying by the weights table
 *              sum = (sum + divisor/2) / divisor;
 *
 *              // write out result
 *              result[y][x] = CLAMP(sum, 0, 255);
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const int16_t kernel[9] = { 1, 2, 1,
 *                                                      2, 4, 2,
 *                                                      1, 2, 1 };
 *                          \/textblock </pre>
 *
 *                          The kernel values may not sum in any combination to be outside the range
 *                          [-2**23, 2**23), or modulo overflow in the accumulator may result.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param divisor          The weighted sum of nearby pixels is typically a large number, which must be corrected
 *                          to fit back into the image format of the destination image. The correction factor
 *                          is passed in as divisor here, and is divided from the sum before the result is
 *                          returned. Typically, the divisor is the sum over the area of the kernel. If the divisor
 *                          is 0, 1 will be used instead.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolve_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const ShortPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const ShortBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const short[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolve_PlanarF
 *  \abstract General convolution on a PlanarF image.
 *  \discussion This filter applies a convolution filter of your choosing to a PlanarF image.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              float sum = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sum += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2];
 *              }
 *
 *              // write out result
 *              result[y][x] = sum;
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolve_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("float") float backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("float") float backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const float[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("float") float backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolve_Planar16F
 *  \abstract General convolution on a Planar16F image.
 *  \discussion This filter applies a convolution filter of your choosing to a Planar16F image.
 *              The kernel values are specified as 32-bit single-precision floats and the
 *              weighted average is also computed in single precision by default. However, if
 *              the flag kvImageUseFP16Accumulator is set all internal filtering operations will
 *              use 16-bit half-precision floating-point arithmetic when the CPU architecture
 *              supports it. This results in up to 2x performance improvements but at the
 *              expense of a less precise result; typically 2-3 bits of precision is lost.
 *
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              // sum is declared as type _Float16 when the flag kvImageUseFP16Accumulator is set
 *              float sum = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sum += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2];
 *              }
 *
 *              // write out result
 *              result[y][x] = (_Float16)sum;
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile                     Disable internal multithreading.
 *
 *              kvImageUseFP16Accumulator  Enable 16-bit half-precision floating-point arithmetic when computing the
 *                                          kernel averages when the CPU architecture supports it.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolve_Planar16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("Pixel_16F") short backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_Planar16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("Pixel_16F") short backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_Planar16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const float[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("Pixel_16F") short backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolve_ARGB8888
 *  \abstract General convolution on a ARGB888 image of any channel order.
 *  \discussion This filter applies a convolution filter of your choosing to a ARGB8888 image.
 *              This filter will work on any four-channel, 8-bit per component image format, not just ARGB.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              int sumA = 0;
 *              int sumR = 0;
 *              int sumG = 0;
 *              int sumB = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][3];
 *              }
 *              // Correct for the scaling introduced by multiplying by the weights table
 *              sumA = (sumA + divisor/2) / divisor;
 *              sumR = (sumR + divisor/2) / divisor;
 *              sumG = (sumG + divisor/2) / divisor;
 *              sumB = (sumB + divisor/2) / divisor;
 *
 *              // write out result
 *              result[y][x][0] = CLAMP(sumA, 0, 255);
 *              result[y][x][1] = CLAMP(sumR, 0, 255);
 *              result[y][x][2] = CLAMP(sumG, 0, 255);
 *              result[y][x][3] = CLAMP(sumB, 0, 255);
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const int16_t kernel[9] = { 1, 2, 1,
 *                                                      2, 4, 2,
 *                                                      1, 2, 1 };
 *                          \/textblock </pre>
 *
 *                          The kernel values may not sum in any combination to be outside the range
 *                          [-2**23, 2**23), or modulo overflow in the accumulator may result.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param divisor          The weighted sum of nearby pixels is typically a large number, which must be corrected
 *                          to fit back into the image format of the destination image. The correction factor
 *                          is passed in as divisor here, and is divided from the sum before the result is
 *                          returned. Typically, the divisor is the sum over the area of the kernel. If the divisor
 *                          is 0, 1 will be used instead.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolve_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const ShortPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const ShortBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const short[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolve_ARGBFFFF
 *  \abstract General convolution on a ARGBFFFF image of any channel order.
 *  \discussion This filter applies a convolution filter of your choosing to a ARGBFFFF image.
 *              This filter will work on any four-channel, float per component image format, not just ARGB.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              float sumA = 0;
 *              float sumR = 0;
 *              float sumG = 0;
 *              float sumB = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][3];
 *              }
 *
 *              // write out result
 *              result[y][x][0] = sumA;
 *              result[y][x][1] = sumR;
 *              result[y][x][2] = sumG;
 *              result[y][x][3] = sumB;
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolve_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("const float*") FloatPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("const float*") FloatPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const float[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("const float*") FloatPointer backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolve_ARGB16F
 *  \abstract General convolution on a ARGB16F image of any channel order.
 *  \discussion This filter applies a convolution filter of your choosing to a ARGB16F image.
 *              This filter will work on any four-channel, half-float per component image format, not just ARGB.
 *              The kernel values are specified as 32-bit single-precision floats and the
 *              weighted average is also computed in single precision by default. However, if
 *              the flag kvImageUseFP16Accumulator is set all internal filtering operations will
 *              use 16-bit half-precision floating-point arithmetic when the CPU architecture
 *              supports it. This results in up to 2x performance improvements but at the
 *              expense of a less precise result; typically 2-3 bits of precision is lost.
 *
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              // Sums are declared as type _Float16 when the flag kvImageUseFP16Accumulator is set
 *              float sumA = 0;
 *              float sumR = 0;
 *              float sumG = 0;
 *              float sumB = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][3];
 *              }
 *
 *              // write out result
 *              result[y][x][0] = (_Float16)sumA;
 *              result[y][x][1] = (_Float16)sumR;
 *              result[y][x][2] = (_Float16)sumG;
 *              result[y][x][3] = (_Float16)sumB;
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile                     Disable internal multithreading.
 *
 *              kvImageUseFP16Accumulator  Enable 16-bit half-precision floating-point arithmetic when computing the
 *                                          kernel averages when the CPU architecture supports it.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolve_ARGB16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("const uint16_t*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_ARGB16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("const uint16_t*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolve_ARGB16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const float[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("const uint16_t*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolveWithBias_Planar8
 *  \abstract General convolution on a Planar8 image with added bias.
 *  \discussion This filter applies a convolution filter of your choosing to a Planar8 image.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              int sum = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sum += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2];
 *              }
 *              // Correct for the scaling introduced by multiplying by the weights table
 *              sum = (sum + bias) / divisor;
 *
 *              // write out result
 *              result[y][x] = CLAMP(sum, 0, 255);
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const int16_t kernel[9] = { 1, 2, 1,
 *                                                      2, 4, 2,
 *                                                      1, 2, 1 };
 *                          \/textblock </pre>
 *
 *                          The kernel values may not sum in any combination to be outside the range
 *                          [-2**23, 2**23), or modulo overflow in the accumulator may result.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param divisor          The weighted sum of nearby pixels is typically a large number, which must be corrected
 *                          to fit back into the image format of the destination image. The correction factor
 *                          is passed in as divisor here, and is divided from the sum before the result is
 *                          returned. Typically, the divisor is the sum over the area of the kernel. If the divisor
 *                          is 0, 1 will be used instead.
 *
 *  @param bias             This value is added to the sum of weighted pixels before the divisor is applied.
 *                          It can serve to both control rounding and adjust the brightness of the result.
 *                          A large bias (e.g 128 * divisor) may be required for some kernels to return
 *                          representable results, such as edge detection filters.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolveWithBias_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const ShortPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, int bias, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const ShortBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, int bias, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const short[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, int bias, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolveWithBias_PlanarF
 *  \abstract General convolution on a PlanarF image with added bias.
 *  \discussion This filter applies a convolution filter of your choosing to a PlanarF image.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              float sum = bias;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sum += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2];
 *              }
 *
 *              // write out result
 *              result[y][x] = sum;
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param bias             This value is added to the sum of weighted pixels.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolveWithBias_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias, @Cast("float") float backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias, @Cast("float") float backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const float[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias, @Cast("float") float backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolveWithBias_Planar16F
 *  \abstract General convolution on a Planar16F image.
 *  \discussion This filter applies a convolution filter of your choosing to a Planar16F image.
 *              The kernel values are specified as 32-bit single-precision floats and the
 *              weighted average is also computed in single precision by default. However, if
 *              the flag kvImageUseFP16Accumulator is set all internal filtering operations will
 *              use 16-bit half-precision floating-point arithmetic when the CPU architecture
 *              supports it. This results in up to 2x performance improvements but at the
 *              expense of a less precise result; typically 2-3 bits of precision is lost.
 *
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              // sum is declared as type _Float16 when the flag kvImageUseFP16Accumulator is set
 *              float sum = bias;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sum += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2];
 *              }
 *
 *              // write out result
 *              result[y][x] = (_Float16)sum;
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param bias             This value is added to the sum of weighted pixels.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile                     Disable internal multithreading.
 *
 *              kvImageUseFP16Accumulator  Enable 16-bit half-precision floating-point arithmetic when computing the
 *                                          kernel averages when the CPU architecture supports it.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolveWithBias_Planar16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias, @Cast("Pixel_16F") short backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_Planar16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias, @Cast("Pixel_16F") short backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_Planar16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const float[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias, @Cast("Pixel_16F") short backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolveWithBias_ARGB8888
 *  \abstract General convolution on a ARGB888 image of any channel order with bias.
 *  \discussion This filter applies a convolution filter of your choosing to a ARGB8888 image.
 *              This filter will work on any four-channel, 8-bit per component image format, not just ARGB.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              int sumA = 0;
 *              int sumR = 0;
 *              int sumG = 0;
 *              int sumB = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][3];
 *              }
 *              // Correct for the scaling introduced by multiplying by the weights table
 *              sumA = (sumA + bias[0]) / divisor;
 *              sumR = (sumR + bias[1]) / divisor;
 *              sumG = (sumG + bias[2]) / divisor;
 *              sumB = (sumB + bias[3]) / divisor;
 *
 *              // write out result
 *              result[y][x][0] = CLAMP(sumA, 0, 255);
 *              result[y][x][1] = CLAMP(sumR, 0, 255);
 *              result[y][x][2] = CLAMP(sumG, 0, 255);
 *              result[y][x][3] = CLAMP(sumB, 0, 255);
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const int16_t kernel[9] = { 1, 2, 1,
 *                                                      2, 4, 2,
 *                                                      1, 2, 1 };
 *                          \/textblock </pre>
 *
 *                          The kernel values may not sum in any combination to be outside the range
 *                          [-2**23, 2**23), or modulo overflow in the accumulator may result.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param divisor          The weighted sum of nearby pixels is typically a large number, which must be corrected
 *                          to fit back into the image format of the destination image. The correction factor
 *                          is passed in as divisor here, and is divided from the sum before the result is
 *                          returned. Typically, the divisor is the sum over the area of the kernel. If the divisor
 *                          is 0, 1 will be used instead.
 *
 *  @param bias             This value is added to the sum of weighted pixels before the divisor is applied.
 *                          It can serve to both control rounding and adjust the brightness of the result.
 *                          A large bias (e.g 128 * divisor) may be required for some kernels, such as edge
 *                          detection filters, to return representable results.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolveWithBias_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const ShortPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, int bias, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const ShortBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, int bias, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const short[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, int divisor, int bias, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolveFloatKernel_ARGB8888
 *  \abstract General convolution on a ARGB888 image of any channel order with a kernel with floating-point weights.
 *  \discussion Performs a filtering operation just like vImageConvolveWithBias_ARGB8888 but with a float rather than an integer (with divisor) kernel.
 *
 */
public static native @Cast("vImage_Error") long vImageConvolveFloatKernel_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const FloatPointer kernel, @Cast("uint32_t") int kernelHeight, @Cast("uint32_t") int kernelWidth, float bias, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvolveFloatKernel_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const FloatBuffer kernel, @Cast("uint32_t") int kernelHeight, @Cast("uint32_t") int kernelWidth, float bias, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvolveFloatKernel_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const float[] kernel, @Cast("uint32_t") int kernelHeight, @Cast("uint32_t") int kernelWidth, float bias, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags);

/**
 *  \function vImageConvolveWithBias_ARGBFFFF
 *  \abstract General convolution on a ARGBFFFF image of any channel order with bias.
 *  \discussion This filter applies a convolution filter of your choosing to a ARGBFFFF image.
 *              This filter will work on any four-channel, float per component image format, not just ARGB.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              float sumA = bias[0];
 *              float sumR = bias[1];
 *              float sumG = bias[2];
 *              float sumB = bias[3];
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][3];
 *              }
 *
 *              // write out result
 *              result[y][x][0] = sumA;
 *              result[y][x][1] = sumR;
 *              result[y][x][2] = sumG;
 *              result[y][x][3] = sumB;
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param bias             This value is added to the sum of weighted pixels.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolveWithBias_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias,  @Cast("const float*") FloatPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias,  @Cast("const float*") FloatPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const float[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias,  @Cast("const float*") FloatPointer backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolveWithBias_ARGB16F
 *  \abstract General convolution on a ARGB16F image of any channel order.
 *  \discussion This filter applies a convolution filter of your choosing to a ARGB16F image.
 *              This filter will work on any four-channel, half-float per component image format, not just ARGB.
 *              The kernel values are specified as 32-bit single-precision floats and the
 *              weighted average is also computed in single precision by default. However, if
 *              the flag kvImageUseFP16Accumulator is set all internal filtering operations will
 *              use 16-bit half-precision floating-point arithmetic when the CPU architecture
 *              supports it. This results in up to 2x performance improvements but at the
 *              expense of a less precise result; typically 2-3 bits of precision is lost.
 *
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              // Sums are declared as type _Float16 when the flag kvImageUseFP16Accumulator is set
 *              float sumA = bias;
 *              float sumR = bias;
 *              float sumG = bias;
 *              float sumB = bias;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][3];
 *              }
 *
 *              // write out result
 *              result[y][x][0] = (_Float16)sumA;
 *              result[y][x][1] = (_Float16)sumR;
 *              result[y][x][2] = (_Float16)sumG;
 *              result[y][x][3] = (_Float16)sumB;
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param bias             This value is added to the sum of weighted pixels.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile                     Disable internal multithreading.
 *
 *              kvImageUseFP16Accumulator  Enable 16-bit half-precision floating-point arithmetic when computing the
 *                                          kernel averages when the CPU architecture supports it.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolveWithBias_ARGB16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatPointer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias, @Cast("const uint16_t*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_ARGB16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const FloatBuffer kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias, @Cast("const uint16_t*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveWithBias_ARGB16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,  @Const float[] kernel, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, float bias, @Cast("const uint16_t*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageConvolveMultiKernel_ARGB8888
 *  \abstract General convolution on a ARGB8888 image of any channel order with separate bias, kernel and divisor for each channel.
 *  \discussion This filter applies a convolution filter of your choosing to a ARGB8888 image.
 *              This filter will work on any four-channel, 8-bit per component image format, not just ARGB.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              int sumA = 0;
 *              int sumR = 0;
 *              int sumG = 0;
 *              int sumB = 0;
 *                const int16_t *kA = kernel[0];
 *                const int16_t *kR = kernel[1];
 *                const int16_t *kG = kernel[2];
 *                const int16_t *kB = kernel[3];
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += kA[i*kernel_width+j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += kR[i*kernel_width+j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += kG[i*kernel_width+j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += kB[i*kernel_width+j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][3];
 *              }
 *              // Correct for the scaling introduced by multiplying by the weights table
 *              sumA = (sumA + bias[0]) / divisor[0];
 *              sumR = (sumR + bias[1]) / divisor[1];
 *              sumG = (sumG + bias[2]) / divisor[2];
 *              sumB = (sumB + bias[3]) / divisor[3];
 *
 *              // write out result
 *              result[y][x][0] = CLAMP(sumA, 0, 255);
 *              result[y][x][1] = CLAMP(sumR, 0, 255);
 *              result[y][x][2] = CLAMP(sumG, 0, 255);
 *              result[y][x][3] = CLAMP(sumB, 0, 255);
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           An array of 4 pointers to weights of dimension kernel_height x kernel_width.
 *                          The kernel values in each array may not sum in any combination to be outside the range
 *                          [-2**23, 2**23), or modulo overflow in the accumulator may result.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param divisor          The weighted sum of nearby pixels is typically a large number, which must be corrected
 *                          to fit back into the image format of the destination image. The correction factor
 *                          is passed in as divisor here, and is divided from the sum before the result is
 *                          returned. Typically, the divisor is the sum over the area of the kernel. If the divisor
 *                          is 0, 1 will be used instead.
 *
 *  @param bias             This array of values is added to the sum of weighted pixels for each channel respectively
 *                          before the divisor is applied. It can serve to both control rounding and adjust the
 *                          brightness of the result. A large bias (e.g 128 * divisor) may be required for some
 *                          kernels, such as edge detection filters, to return representable results.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolveMultiKernel_ARGB8888(    @Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          Pointer tempBuffer,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_X,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                                                          @Cast("const int16_t**") PointerPointer kernels,
                                                          @Cast("uint32_t") int kernel_height,
                                                          @Cast("uint32_t") int kernel_width,
                                                          @Const IntPointer divisors,
                                                          @Const IntPointer biases,
                                                          @Cast("const uint8_t*") BytePointer backgroundColor,
                                                          @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveMultiKernel_ARGB8888(    @Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          Pointer tempBuffer,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_X,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                                                          @Const @ByPtrPtr ShortPointer kernels,
                                                          @Cast("uint32_t") int kernel_height,
                                                          @Cast("uint32_t") int kernel_width,
                                                          @Const IntPointer divisors,
                                                          @Const IntPointer biases,
                                                          @Cast("const uint8_t*") BytePointer backgroundColor,
                                                          @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveMultiKernel_ARGB8888(    @Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          Pointer tempBuffer,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_X,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                                                          @Const @ByPtrPtr ShortBuffer kernels,
                                                          @Cast("uint32_t") int kernel_height,
                                                          @Cast("uint32_t") int kernel_width,
                                                          @Const IntBuffer divisors,
                                                          @Const IntBuffer biases,
                                                          @Cast("const uint8_t*") BytePointer backgroundColor,
                                                          @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveMultiKernel_ARGB8888(    @Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          Pointer tempBuffer,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_X,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                                                          @Const @ByPtrPtr short[] kernels,
                                                          @Cast("uint32_t") int kernel_height,
                                                          @Cast("uint32_t") int kernel_width,
                                                          @Const int[] divisors,
                                                          @Const int[] biases,
                                                          @Cast("const uint8_t*") BytePointer backgroundColor,
                                                          @Cast("vImage_Flags") long flags );


/**
 *  \function vImageConvolveMultiKernel_ARGBFFFF
 *  \abstract General convolution on a ARGBFFFF image of any channel order with separate bias and kernel for each channel.
 *  \discussion This filter applies a convolution filter of your choosing to a ARGBFFFF image.
 *              This filter will work on any four-channel, float per component image format, not just ARGB.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              float sumA = bias[0];
 *              float sumR = bias[1];
 *              float sumG = bias[2];
 *              float sumB = bias[3];
 *                const float *kA = kernel[0];
 *                const float *kR = kernel[1];
 *                const float *kG = kernel[2];
 *                const float *kB = kernel[3];
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += kA[i*kernel_width+j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += kR[i*kernel_width+j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += kG[i*kernel_width+j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += kB[i*kernel_width+j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2] [x+j+srcOffsetToROI_X- kernel_width/2][3];
 *              }
 *
 *              // write out result
 *              result[y][x][0] = sumA;
 *              result[y][x][1] = sumR;
 *              result[y][x][2] = sumG;
 *              result[y][x][3] = sumB;
 *          }
 *      \/textblock </pre>
 *              (Above, we imagine the kernel to be a 2D array of size kernel_height by kernel_width.
 *              However, in practice it is passed in as a contiguous 1D array of size kernel_height *
 *              kernel_width.)
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param bias             This value is added to the sum of weighted pixels.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageConvolveMultiKernel_ARGBFFFF(    @Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          Pointer tempBuffer,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_X,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                                                          @Cast("const float**") PointerPointer kernels,
                                                          @Cast("uint32_t") int kernel_height,
                                                          @Cast("uint32_t") int kernel_width,
                                                          @Const FloatPointer biases,
                                                          @Cast("const float*") FloatPointer backgroundColor,
                                                          @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveMultiKernel_ARGBFFFF(    @Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          Pointer tempBuffer,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_X,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                                                          @Const @ByPtrPtr FloatPointer kernels,
                                                          @Cast("uint32_t") int kernel_height,
                                                          @Cast("uint32_t") int kernel_width,
                                                          @Const FloatPointer biases,
                                                          @Cast("const float*") FloatPointer backgroundColor,
                                                          @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveMultiKernel_ARGBFFFF(    @Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          Pointer tempBuffer,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_X,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                                                          @Const @ByPtrPtr FloatBuffer kernels,
                                                          @Cast("uint32_t") int kernel_height,
                                                          @Cast("uint32_t") int kernel_width,
                                                          @Const FloatBuffer biases,
                                                          @Cast("const float*") FloatPointer backgroundColor,
                                                          @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvolveMultiKernel_ARGBFFFF(    @Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          Pointer tempBuffer,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_X,
                                                          @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                                                          @Const @ByPtrPtr float[] kernels,
                                                          @Cast("uint32_t") int kernel_height,
                                                          @Cast("uint32_t") int kernel_width,
                                                          @Const float[] biases,
                                                          @Cast("const float*") FloatPointer backgroundColor,
                                                          @Cast("vImage_Flags") long flags );




/**
 * \functiongroup Richardson-Lucy Deconvolution
 *
 * \discussion Richardson-Lucy deconvolution (a.k.a. Lucy-Richardson) is an iterative procedure for estimating what an original image
 *  probably was before a convolution, given the convolution end result and the kernel used to create it.  It is typically used to fix blurring caused
 *  by lens distortion, most famously for the Hubble telescope, but also to improve images in confocal microscopy and other uses. When used
 *  to correct loss of signal due to physical limitations of the imaging system, the point spread function (kernel) is estimated from known
 *  parameters associated with the lensing system. It can also be used to sharpen images that have been digitally blurred, as long as the
 *  original convolution kernel is known or can be estimated.
 *
 *  This routine iteratively uses the following formula:
 *      <pre>\textblock
 *        e[i+1] = e[i] x (psf0 * ( e[0] / (psf1 * e[i]) ) )
 *
 *        where:
 *              e[0] = the observed image (src parameter)
 *              e[n] = the result of the nth iteration
 *              psf  = point spread function (kernel for call to convolution)
 *                x    = multiply operator
 *              '*'  = convolution operator
 *      \/textblock </pre>
 *  As with any sharpening operation, Richardson-Lucy amplifies noise, and at some number of iterations the noise becomes noticeable as artifacts.
 *      <pre>\textblock
 *              =========================================================================
 *              ======    MOST VIMAGE CONVOLUTION FUNCTIONS DO NOT WORK IN PLACE    =====
 *              =========================================================================
 *      \/textblock </pre>
 */


/**
 * \function vImageRichardsonLucyDeConvolve_Planar8
 * \abstract Perform N iterations of a Lucy-Richardson deconvolution on Planar8 data
 * \discussion
 *  This routine iteratively uses the following formula:
 *      <pre>\textblock
 *        e[i+1] = e[i] x (psf0 * ( e[0] / (psf1 * e[i]) ) )
 *
 *        where:
 *              e[0] = the observed image (src parameter)
 *              e[n] = the result of the nth iteration
 *              psf  = point spread function (kernel for call to convolution)
 *                x    = multiply operator
 *              '*'  = convolution operator
 *      \/textblock </pre>
 *
 *  The work in these functions is currently done internally with floating point precision. If you plan to call this function multiple times
 *  (rather than with iterationCount > 1) on 8-bit per channel images, you can save some computation by converting the 8-bit image data to
 *  single precision floating-point yourself using something like vImageConvert_Planar8toPlanarF and iterating on the appropriate
 *  floating-point Richardson Lucy variant. Convert back, when you are done.
 *
 *  Does not work in place.
 * @param src           The input image
 *
 * @param dest          A preallocated buffer to receive the result image.
 *                      This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const int16_t kernel[9] = { 1, 2, 1,
 *                                                      2, 4, 2,
 *                                                      1, 2, 1 };
 *                          \/textblock </pre>
 *
 *                          This is psf0 in the formula given in the discussion.
 *
 *  @param kernel2          A pointer to a second 1D array of weights of dimension kernel_height2 x kernel_width2.
 *                          This is psf1 in the formula given in the discussion.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel1. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel1. It must be an odd number.
 *
 *  @param kernel_height2   The height of the 2D table of weights passed in as kernel2. It must be an odd number.
 *
 *  @param kernel_width2    The width of the 2D table of weights passed in as kernel2. It must be an odd number.
 *
 *  @param divisor          The divisor to use to correct for the volume under kernel.
 *
 *  @param divisor2         The divisor to use to correct for the volume under kernel2.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param iterationCount   The number of Richardson-Lucy iterations to perform on the data before returning.
 *                          If 0, the src buffer is coped to dest.
 *
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const ShortPointer kernel, @Const ShortPointer kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, int divisor, int divisor2, @Cast("uint8_t") byte backgroundColor, @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const ShortBuffer kernel, @Const ShortBuffer kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, int divisor, int divisor2, @Cast("uint8_t") byte backgroundColor, @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const short[] kernel, @Const short[] kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, int divisor, int divisor2, @Cast("uint8_t") byte backgroundColor, @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );

/**
 * \function vImageRichardsonLucyDeConvolve_PlanarF
 * \abstract Perform N iterations of a Lucy-Richardson deconvolution on PlanarF data
 * \discussion
 *  This routine iteratively uses the following formula:
 *      <pre>\textblock
 *        e[i+1] = e[i] x (psf0 * ( e[0] / (psf1 * e[i]) ) )
 *
 *        where:
 *              e[0] = the observed image (src parameter)
 *              e[n] = the result of the nth iteration
 *              psf  = point spread function (kernel for call to convolution)
 *                x    = multiply operator
 *              '*'  = convolution operator
 *      \/textblock </pre>
 *
 *  Does not work in place.
 * @param src           The input image
 *
 * @param dest          A preallocated buffer to receive the result image.
 *                      This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *                          This is psf0 in the formula given in the discussion.
 *
 *  @param kernel2          A pointer to a second 1D array of weights of dimension kernel_height2 x kernel_width2.
 *                          This is psf1 in the formula given in the discussion.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel1. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel1. It must be an odd number.
 *
 *  @param kernel_height2   The height of the 2D table of weights passed in as kernel2. It must be an odd number.
 *
 *  @param kernel_width2    The width of the 2D table of weights passed in as kernel2. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param iterationCount   The number of Richardson-Lucy iterations to perform on the data before returning.
 *                          If 0, the src buffer is coped to dest.
 *
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const FloatPointer kernel, @Const FloatPointer kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, @Cast("float") float backgroundColor,  @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const FloatBuffer kernel, @Const FloatBuffer kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, @Cast("float") float backgroundColor,  @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_PlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const float[] kernel, @Const float[] kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, @Cast("float") float backgroundColor,  @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );

/**
 * \function vImageRichardsonLucyDeConvolve_ARGB8888
 * \abstract Perform N iterations of a Lucy-Richardson deconvolution on ARGB8888 data.
 * \discussion
 *  This routine iteratively uses the following formula:
 *      <pre>\textblock
 *        e[i+1] = e[i] x (psf0 * ( e[0] / (psf1 * e[i]) ) )
 *
 *        where:
 *              e[0] = the observed image (src parameter)
 *              e[n] = the result of the nth iteration
 *              psf  = point spread function (kernel for call to convolution)
 *                x    = multiply operator
 *              '*'  = convolution operator
 *      \/textblock </pre>
 *  The channels are operated on independently of one another. Consequently, this function will work on
 *  any 4-channel interleaved 8-bit per component format (e.g. RGBA, BGRA...), not just ARGB.
 *
 *  The work in these functions is currently done internally with floating point precision. If you plan to call this function multiple times
 *  (rather than with iterationCount > 1) on 8-bit per channel images, you can save some computation by converting the 8-bit image data to
 *  single precision floating-point yourself using something like vImageConvert_Planar8toPlanarF and iterating on the appropriate
 *  floating-point Richardson Lucy variant. Convert back, when you are done.
 *
 *  Does not work in place.
 *
 * @param src           The input image
 *
 * @param dest          A preallocated buffer to receive the result image.
 *                      This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const int16_t kernel[9] = { 1, 2, 1,
 *                                                      2, 4, 2,
 *                                                      1, 2, 1 };
 *                          \/textblock </pre>
 *
 *                          This is psf0 in the formula given in the discussion.
 *
 *  @param kernel2          A pointer to a second 1D array of weights of dimension kernel_height2 x kernel_width2.
 *                          This is psf1 in the formula given in the discussion.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel1. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel1. It must be an odd number.
 *
 *  @param kernel_height2   The height of the 2D table of weights passed in as kernel2. It must be an odd number.
 *
 *  @param kernel_width2    The width of the 2D table of weights passed in as kernel2. It must be an odd number.
 *
 *  @param divisor          The divisor to use to correct for the volume under kernel.
 *
 *  @param divisor2         The divisor to use to correct for the volume under kernel2.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param iterationCount   The number of Richardson-Lucy iterations to perform on the data before returning.
 *                          If 0, the src buffer is coped to dest.
 *
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *              kvImageLeaveAlphaUnchanged  Operate only on the last 3 channels in memory. Leave the first channel
 *                                          unmodified.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const ShortPointer kernel, @Const ShortPointer kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, int divisor, int divisor2, @Cast("const uint8_t*") BytePointer backgroundColor,  @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const ShortBuffer kernel, @Const ShortBuffer kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, int divisor, int divisor2, @Cast("const uint8_t*") BytePointer backgroundColor,  @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const short[] kernel, @Const short[] kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, int divisor, int divisor2, @Cast("const uint8_t*") BytePointer backgroundColor,  @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );

/**
 * \function vImageRichardsonLucyDeConvolve_ARGBFFFF
 * \abstract Perform N iterations of a Lucy-Richardson deconvolution on ARGBFFFF data
 * \discussion
 *  This routine iteratively uses the following formula:
 *      <pre>\textblock
 *        e[i+1] = e[i] x (psf0 * ( e[0] / (psf1 * e[i]) ) )
 *
 *        where:
 *              e[0] = the observed image (src parameter)
 *              e[n] = the result of the nth iteration
 *              psf  = point spread function (kernel for call to convolution)
 *                x    = multiply operator
 *              '*'  = convolution operator
 *      \/textblock </pre>
 *
 *  The channels are operated on independently of one another. Consequently, this function will work on
 *  any 4-channel interleaved 8-bit per component format (e.g. RGBA, BGRA...), not just ARGB.
 *
 *  Does not work in place.
 * @param src           The input image
 *
 * @param dest          A preallocated buffer to receive the result image.
 *                      This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel           A pointer to a 1D array of weights of dimension kernel_height x kernel_width.
 *                          For example, for a simple 3x3 blur, it might be:
 *                          <pre>\textblock
 *                          const float kernel[9] =   { 1./16, 2./16, 1./16,
 *                                                      2./16, 4./16, 2./16,
 *                                                      1./16, 2./16, 1./16 };
 *                          \/textblock </pre>
 *
 *                          This is psf0 in the formula given in the discussion.
 *
 *  @param kernel2          A pointer to a second 1D array of weights of dimension kernel_height2 x kernel_width2.
 *                          This is psf1 in the formula given in the discussion.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel1. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel1. It must be an odd number.
 *
 *  @param kernel_height2   The height of the 2D table of weights passed in as kernel2. It must be an odd number.
 *
 *  @param kernel_width2    The width of the 2D table of weights passed in as kernel2. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param iterationCount   The number of Richardson-Lucy iterations to perform on the data before returning.
 *                          If 0, the src buffer is coped to dest.
 *
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *              kvImageLeaveAlphaUnchanged  Operate only on the last 3 channels in memory. Leave the first channel
 *                                          unmodified.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const FloatPointer kernel, @Const FloatPointer kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, @Cast("const float*") FloatPointer backgroundColor,  @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const FloatBuffer kernel, @Const FloatBuffer kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, @Cast("const float*") FloatPointer backgroundColor,  @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageRichardsonLucyDeConvolve_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Const float[] kernel, @Const float[] kernel2, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint32_t") int kernel_height2, @Cast("uint32_t") int kernel_width2, @Cast("const float*") FloatPointer backgroundColor,  @Cast("uint32_t") int iterationCount, @Cast("vImage_Flags") long flags );

/**
 *  \functiongroup Box Convolve
 *  \discussion  A box convolve is a special case of the standard convolution, which has a much faster algorithm.
 *               A box kernel is a kernel populated with all 1's. This returns the unweighted average of the pixels
 *               near the result pixel. Unlike general purpose convolution, the cost of a box convolve algorithm
 *               is theoretically constant regardless of kernel size, so it can be an inexpensive choice for very
 *               large blurs. The box convolve behavior may not be as desired, however, because the blur effect is
 *               rectangular in appearance, whereas most expect it to be gaussian or roughly circular. A tent blur has
 *               similar rectangular character, but because the weighting is non uniform, it is less obvious. A
 *               tent blur is also constant cost per pixel, but larger constant cost.
 *
 *               Two box blur passes of the same kernel size results in a tent blur.  To see this we can take a 1-d starting image:
 *                <pre> \textblock
 *                      p0          p1          p2          p3          p4          p5          p6
 *                \/textblock </pre>
 *               and blur it once with a 3 wide box blur, ignoring for the moment what happens at the edges:
 *                <pre> \textblock
 *                     (edge)    p0+p1+p2    p1+p2+p3    p2+p3+p4    p3+p4+p5    p4+p5+p6    p5+p6+p7
 *                \/textblock </pre>
 *               and a second time:
 *                <pre> \textblock
 *                     (edge)           p0+2p1+3p2+2p3+p4       p2+2p3+3p4+2p5+p6       p4+2p5+3p6+2p7+p8 .....
 *                               (edge)             p1+2p2+3p3+2p4+p5       p3+2p4+3p5+2p6+p7
 *                \/textblock </pre>
 *
 *                If this process is continued, the shape converges towards a gaussian over multiple passes.
 *      <pre>\textblock
 *              =========================================================================
 *              ======    MOST VIMAGE CONVOLUTION FUNCTIONS DO NOT WORK IN PLACE    =====
 *              =========================================================================
 *      \/textblock </pre>
 */

/**
 *  \function vImageBoxConvolve_Planar8
 *  \abstract Special purpose box convolution on a Planar8 image.
 *  \discussion This filter applies a box filter to a Planar8 image.  A box filter uses a much faster algorithm
 *              than a standard convolution, and may be a good solution for real time application of large blur
 *              radii against images.
 *              For each pixel:
 *      <pre>\textblock
 *          vImagePixelCount kernel_area = kernel_height * kernel_width;
 *          for each pixel[y][x] in image{
 *              int sum = 0;
 *
 *              // Calculate unweighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sum += pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                              [x+j+srcOffsetToROI_X- kernel_width/2];
 *              }
 *              // Correct for the scaling introduced by multiplying by the weights table
 *              sum = (sum + kernel_area/2) / kernel_area;
 *
 *              // write out result
 *              result[y][x] = CLAMP(sum, 0, 255);
 *          }
 *      \/textblock </pre>
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageBoxConvolve_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \function vImageBoxConvolve_ARGB8888
 *  \abstract Special purpose box convolution on a 4-channel interleaved, 8-bit per channel image.
 *  \discussion This filter applies a box filter to a 4-channel interleaved, 8-bit per channel imagee.
 *              A box filter uses a much faster algorithm than a standard convolution, and may be a good
 *              solution for real time application of large blur radii against images.
 *              For each pixel:
 *      <pre>\textblock
 *          vImagePixelCount kernel_area = kernel_height * kernel_width;
 *          for each pixel[y][x] in image{
 *              int sumA = 0;
 *              int sumR = 0;
 *              int sumG = 0;
 *              int sumB = 0;
 *
 *              // Calculate unweighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2][3];
 *              }
 *              // Correct for the scaling introduced by multiplying by the weights table
 *              sumA = (sumA + kernel_area/2) / kernel_area;
 *              sumR = (sumR + kernel_area/2) / kernel_area;
 *              sumG = (sumG + kernel_area/2) / kernel_area;
 *              sumB = (sumB + kernel_area/2) / kernel_area;
 *
 *              // write out result
 *              result[y][x][0] = CLAMP(sumA, 0, 255);
 *              result[y][x][1] = CLAMP(sumR, 0, 255);
 *              result[y][x][2] = CLAMP(sumG, 0, 255);
 *              result[y][x][3] = CLAMP(sumB, 0, 255);
 *          }
 *      \/textblock </pre>
 *
 *              This filter does not work in place.
 *
 *              This filter will work without modification for other byte orders such as RGBA, BGRA, AGBR, CMYK, etc.
 *              The image should be non-premultiplied to avoid odd results in non-opaque regions.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageLeaveAlphaUnchanged  Apply the convolution to the last three channels in memory, only.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageBoxConvolve_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \functiongroup Tent Convolve
 *  \discussion  A tent convolve is a special case of the standard convolution, which has a much faster algorithm.
 *               A tent kernel is a kernel populated with slope of 1 rising towards the center. 2D kernels
 *               are calculated as the product of the appropriate 1D kernels. e.g.
 *               <pre> \textblock
 *                  {1,2,3,2,1}
 *               \/textblock </pre>
 *               or
 *               <pre> \textblock
 *               |1|                { {1,2,1},
 *               |2| *  {1,2,1} =     {2,4,2},
 *               |1|                  {1,2,1}   }
 *               \/textblock </pre>
 *               This returns a blur that is more heavily weighted towards the center pixel than a box blur.
 *
 *               Unlike general purpose convolution, the cost of a tent convolve algorithm is theoretically constant
 *               regardless of kernel size, so it can be an inexpensive choice for very large blurs. The tent convolve
 *               behavior may not be as desired, however, because the blur effect is rectangular in appearance, whereas
 *               most expect a blurring effect to be gaussian or roughly circular. The rectangularity of the tent blur
 *               is less obvious than the box blur.  A tent blur has somewhat larger constant cost than a box blur.
 *
 *      <pre>\textblock
 *              =========================================================================
 *              ======    MOST VIMAGE CONVOLUTION FUNCTIONS DO NOT WORK IN PLACE    =====
 *              =========================================================================
 *      \/textblock </pre>
 */

/**
 *  \function vImageTentConvolve_Planar8
 *  \abstract Special purpose tent convolution on a Planar8 image.
 *  \discussion This filter applies a tent filter to a Planar8 image.  A tent filter uses a much faster algorithm
 *              than a standard convolution, and may be a good solution for real time application of large blur
 *              radii against images.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              int sum = 0;
 *              int divisor = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sum += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2];
 *                  divisor += kernel_element[i][j];
 *              }
 *
 *              // Correct for the scaling introduced by multiplying by the weights table
 *              sum = (sum + divisor/2) / divisor;
 *
 *              // write out result
 *              result[y][x] = CLAMP(sum, 0, 255);
 *          }
 *      \/textblock </pre>
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageTentConvolve_Planar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags );




/**
 *  \function vImageTentConvolve_ARGB8888
 *  \abstract Special purpose tent convolution on a 4-channel interleaved, 8-bit per channel image.
 *  \discussion This filter applies a tent filter to a 4-channel interleaved, 8-bit per channel imagee.
 *              A tent filter uses a much faster algorithm than a standard convolution, and may be a good
 *              solution for real time application of large blur radii against images.
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image{
 *              int sumA = 0;
 *              int sumR = 0;
 *              int sumG = 0;
 *              int sumB = 0;
 *              int divisor = 0;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernel_element[i][j] in kernel{
 *                  sumA += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][0];
 *                  sumR += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][1];
 *                  sumG += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][2];
 *                  sumB += kernel_element[i][j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2][x+j+srcOffsetToROI_X- kernel_width/2][3];
 *                  divisor += kernel_element[i][j];
 *              }
 *              // Correct for the scaling introduced by multiplying by the weights table
 *              sumA = (sumA + divisor/2) / divisor;
 *              sumR = (sumR + divisor/2) / divisor;
 *              sumG = (sumG + divisor/2) / divisor;
 *              sumB = (sumB + divisor/2) / divisor;
 *
 *              // write out result
 *              result[y][x][0] = CLAMP(sumA, 0, 255);
 *              result[y][x][1] = CLAMP(sumR, 0, 255);
 *              result[y][x][2] = CLAMP(sumG, 0, 255);
 *              result[y][x][3] = CLAMP(sumB, 0, 255);
 *          }
 *      \/textblock </pre>
 *
 *              This filter does not work in place.
 *
 *              This filter will work without modification for other byte orders such as RGBA, BGRA, AGBR, CMYK, etc.
 *              The image should be non-premultiplied to avoid odd results in non-opaque regions.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernel_height    The height of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param kernel_width     The width of the 2D table of weights passed in as kernel. It must be an odd number.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageLeaveAlphaUnchanged  Apply the convolution to the last three channels in memory, only.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel height and width must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageTentConvolve_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y, @Cast("uint32_t") int kernel_height, @Cast("uint32_t") int kernel_width, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );

/**
 *  \functiongroup Separable Convolution
 *
 *  \discussion A separable convolution applies two separate 1D filters along the rows and columns
 *              of an image in succession. This allows for a faster implementation compared to
 *              applying the corresponding 2D convolution filter, which is the outer product of the
 *              two 1D filters. An example is the Sobel filter for approximating the image gradient.
 *              The Sobel filter is composed of the averaging filter {1,2,1} and the differentiation
 *              filter {-1,0,1}. For the image x-derivative, this results in the general 2D filter:
 *               <pre> \textblock
 *               |1|                { {-1,0,1},
 *               |2| * {-1,0,1} =     {-2,0,2},
 *               |1|                  {-1,0,1}   }
 *               \/textblock </pre>
 *               The specialized tent convolve filter vImageTentConvolve_Planar8() is a particular
 *               example of a separable filter.
 *
 *               There are functions for separable convolution of Planar8 (8-bit integer) and
 *               PlanarF (float) images, just as for the general 2D convolutions functions above.
 *               In addition, there are functions for separable convolution of Planar16U (16-bit
 *               integer) images and Planar8 to Planar16U images. These 16-bit versions can be used
 *               to, for example, implement scale-space filtering where several layers of Gaussian
 *               smoothed images, with increasing sigma, are generated. The initial image is often
 *               8-bit and the Gaussian smoothed images are represented with 16 bits of precision.
 *
 *               A difference in the API of these separable convolution functions, compared to the
 *               general 2D functions above, is that all planar integer versions uses floating point
 *               kernels, just as the PlanarF version. This allows for increased precision while
 *               still being fast on modern processors. The general convolution function
 *               vImageConvolve_Planar8() is using 16-bit kernels with a 32-bit integer accumulator
 *               becasue at the time it was first implemented this allowed for faster execution.
 *
 *               All separable convolution functions also support a bias which is added to the
 *               weighted sum of the pixels. This can be used to control the range of planar integer
 *               images and effectively treating the 8-bit and 16-bit versions as signed ranges.
 *               Since all separable functions support a bias as input parameter the WithBias string
 *               has not been added to the functions names.
 *
 */

/**
 *  \function vImageSepConvolve_Planar8
 *  \abstract Separable convolution on a Planar8 image.
 *  \discussion This filter applies two separate 1D filters along the rows and columns of
 *              a Planar8 image.
 *
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image {
 *              float sum = bias;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernelY_element[i] in kernelY {
 *                  for each kernelX_element[j] in kernelX {
 *                  sum += kernelY_element[i] * kernelX_element[j] *
 *                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2];
 *                  }
 *              }
 *              // Add 0.5 to round to nearest int when converting float to uint8_t
 *              sum = sum + 0.5f;
 *
 *              // write out result
 *              result[y][x] = (uint8_t)CLAMP(sum, 0, 255);
 *          }
 *      \/textblock </pre>
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernelX          A pointer to a 1D array of weights of dimension kernelX_width.
 *                          For example, for a simple 3x3 Sobel x-derivative filter it's {-1.0, 0.0, 1.0}.
 *
 *  @param kernelX_width    The width of the 1D array of weights passed in as kernelX. It must be an odd number.
 *
 *  @param kernelY          A pointer to a 1D array of weights of dimension kernelY_width.
 *                          For example, for a simple 3x3 Sobel x-derivative filter it's {1.0, 2.0, 1.0}.
 *
 *  @param kernelY_width    The width of the 1D array of weights passed in as kernelY. It must be an odd number.
 *
 *  @param bias             This value is added to the sum of weighted pixels.
 *                          You might provide a bias of 128 to move the encoding for 0 to 128 so that
 *                          negative numbers are representable, such as Sobel derivative filters.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel sizes must be odd numbers.
 *      \/textblock </pre>
 */
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                          @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                          @Const FloatPointer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatPointer kernelY, @Cast("uint32_t") int kernelY_width,
                          float bias, @Cast("Pixel_16U") short backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                          @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                          @Const FloatBuffer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatBuffer kernelY, @Cast("uint32_t") int kernelY_width,
                          float bias, @Cast("Pixel_16U") short backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                          @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                          @Const float[] kernelX, @Cast("uint32_t") int kernelX_width, @Const float[] kernelY, @Cast("uint32_t") int kernelY_width,
                          float bias, @Cast("Pixel_16U") short backgroundColor, @Cast("vImage_Flags") long flags);

/**
*  \function vImageSepConvolve_PlanarF
*  \abstract Separable convolution on a PlanarF image.
*  \discussion This filter applies two separate 1D filters along the rows and columns of
*              a PlanarF image.
*
*              For each pixel:
*      <pre>\textblock
*          for each pixel[y][x] in image {
*              float sum = bias;
*
*              // Calculate weighted average over kernel area
*              for each kernelY_element[i] in kernelY {
*                  for each kernelX_element[j] in kernelX {
*                  sum += kernelY_element[i] * kernelX_element[j] *
*                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
*                               [x+j+srcOffsetToROI_X- kernel_width/2];
*                  }
*              }
*
*              // write out result
*              result[y][x] = sum;
*          }
*      \/textblock </pre>
*
*              This filter does not work in place.
*
*  @param src              The input image
*
*  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
*                          This may not alias the src image.
*
*  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
*                          computation.  The size of the tempBuffer is given by calling the function
*                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
*                          the size is returned instead of an error code from the left hand side.
*                          You may pass NULL here, in which case a region of memory of similar size
*                          will be allocated by the function and freed before it returns.  Temp Buffers
*                          are a way of avoiding lost time due to VM faults to initialize newly allocated
*                          buffers. If you will be calling this function repeatedly with similar parameters
*                          you should use a temp buffer. If the function is called from different threads
*                          concurrently, a different temp buffer should be used for each.
*
*  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
*                          relative to the src image. Typically this is 0. Non-Zero values are needed
*                          when the destination tile is not aligned with the left edge of the image.
*
*  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
*                          relative to the src image. Typically this is 0. Non-Zero values are needed
*                          when the destination tile is not aligned with the top edge of the image.
*
*  @param kernelX          A pointer to a 1D array of weights of dimension kernelX_width.
*
*  @param kernelX_width    The width of the 1D array of weights passed in as kernelX. It must be an odd number.
*
*  @param kernelY          A pointer to a 1D array of weights of dimension kernelY_width.
*
*  @param kernelY_width    The width of the 1D array of weights passed in as kernelY. It must be an odd number.
*
*  @param bias             This value is added to the sum of weighted pixels.
*
*  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
*                          parameter provides the background color to be used for missing pixels when the
*                          kernel extends off the edge of the image.
*
*  @param flags            The following flags are allowed:
*      <pre>\textblock
*              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
*                                          copy the corresponding source pixel to the destination. This
*                                          will result in a ring off unconvolved content at the edges
*                                          and convolved content in the middle.
*
*              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
*                                          For a blur filter this will look like the edges of the image
*                                          have been blurred into a particular color. This is usually
*                                          appropriate when the color of the surface onto which the image
*                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
*                                          as a background color, and let the downstream image compositor
*                                          blend in the background color. In this case, the result image
*                                          should be treated as a premultiplied image.
*
*              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
*                                          This is better when the image is drawn into a frame or other
*                                          context where the background is not expected to contribute to
*                                          the final content.
*
*              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
*                                          simply ignored, and the bias and divisor are adjusted accordingly.
*                                          Because of the complication at the edges, this edging mode can
*                                          be significantly slower than the others. It can be numerically
*                                          unstable if the sum over any rectangular subsection of the kernel
*                                          is zero, which can result in division by zero during the computation.
*                                          The results for this edging mode are usually quite visually similar
*                                          to kvImageEdgeExtend.
*
*              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
*                                          size of the temp buffer needed for this set of parameters. Does
*                                          not touch the src or dest image.
*
*              kvImageDoNotTile            Disable internal multithreading.
*
*      \/textblock </pre>
*                          The first four flags listed are edging modes. One and only one edging mode must be
*                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
*                          be returned.
*
*  @return One of the following error codes may be returned:
*      <pre>\textblock
*          kvImageNoError              Success.
*              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
*                                      the temp buffer to use with this function and this set of
*                                      parameters.
*
*          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
*                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
*                                           kvImageEdgeExtend,  kvImageTruncateKernel }
*
*          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
*                                          to corresponding dimensions of the source buffer.
*
*          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
*
*          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
*
*          kvImageNullPointerArgument  kernel may not be NULL
*
*          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
*
*          kvImageInvalidKernelSize    The kernel sizes must be odd numbers.
*      \/textblock </pre>
*/
public static native @Cast("vImage_Error") long vImageSepConvolve_PlanarF(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                          @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                          @Const FloatPointer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatPointer kernelY, @Cast("uint32_t") int kernelY_width,
                          float bias, @Cast("float") float backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_PlanarF(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                          @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                          @Const FloatBuffer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatBuffer kernelY, @Cast("uint32_t") int kernelY_width,
                          float bias, @Cast("float") float backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_PlanarF(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                          @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                          @Const float[] kernelX, @Cast("uint32_t") int kernelX_width, @Const float[] kernelY, @Cast("uint32_t") int kernelY_width,
                          float bias, @Cast("float") float backgroundColor, @Cast("vImage_Flags") long flags);

/**
 *  \function vImageSepConvolve_Planar16F
 *  \abstract Separable convolution on a Planar16F image.
 *  \discussion This filter applies two separate 1D filters along the rows and columns of a Planar16F image.
 *              The weighted average is computed with single-precision floating-point kernel values.  However, if
 *              the flag kvImageUseFP16Accumulator is set all internal filtering operations will
 *              use 16-bit half-precision floating-point arithmetic when the CPU architecture
 *              supports it. This results in up to 2x performance improvements but at the
 *              expense of a less precise result; typically 2-3 bits of precision is lost.
 *
 *              For each pixel:
 *      <pre>\textblock
 *          for each pixel[y][x] in image {
 *              float sum = bias;
 *
 *              // Calculate weighted average over kernel area
 *              for each kernelY_element[i] in kernelY {
 *                  for each kernelX_element[j] in kernelX {
 *                  sum += kernelY_element[i] * kernelX_element[j] *
 *                          (float)pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
 *                               [x+j+srcOffsetToROI_X- kernel_width/2];
 *                  }
 *              }
 *
 *              // Convert to half precisio and write out result
 *              result[y][x] = (_Float16)sum;
 *          }
 *      \/textblock </pre>
 *
 *              This filter does not work in place.
 *
 *  @param src              The input image
 *
 *  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
 *                          This may not alias the src image.
 *
 *  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
 *                          computation.  The size of the tempBuffer is given by calling the function
 *                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
 *                          the size is returned instead of an error code from the left hand side.
 *                          You may pass NULL here, in which case a region of memory of similar size
 *                          will be allocated by the function and freed before it returns.  Temp Buffers
 *                          are a way of avoiding lost time due to VM faults to initialize newly allocated
 *                          buffers. If you will be calling this function repeatedly with similar parameters
 *                          you should use a temp buffer. If the function is called from different threads
 *                          concurrently, a different temp buffer should be used for each.
 *
 *  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the left edge of the image.
 *
 *  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
 *                          relative to the src image. Typically this is 0. Non-Zero values are needed
 *                          when the destination tile is not aligned with the top edge of the image.
 *
 *  @param kernelX          A pointer to a 1D array of weights of dimension kernelX_width.
 *
 *  @param kernelX_width    The width of the 1D array of weights passed in as kernelX. It must be an odd number.
 *
 *  @param kernelY          A pointer to a 1D array of weights of dimension kernelY_width.
 *
 *  @param kernelY_width    The width of the 1D array of weights passed in as kernelY. It must be an odd number.
 *
 *  @param bias             This value is added to the sum of weighted pixels.
 *
 *  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
 *                          parameter provides the background color to be used for missing pixels when the
 *                          kernel extends off the edge of the image.
 *
 *  @param flags            The following flags are allowed:
 *      <pre>\textblock
 *              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
 *                                          copy the corresponding source pixel to the destination. This
 *                                          will result in a ring off unconvolved content at the edges
 *                                          and convolved content in the middle.
 *
 *              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
 *                                          For a blur filter this will look like the edges of the image
 *                                          have been blurred into a particular color. This is usually
 *                                          appropriate when the color of the surface onto which the image
 *                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
 *                                          as a background color, and let the downstream image compositor
 *                                          blend in the background color. In this case, the result image
 *                                          should be treated as a premultiplied image.
 *
 *              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
 *                                          This is better when the image is drawn into a frame or other
 *                                          context where the background is not expected to contribute to
 *                                          the final content.
 *
 *              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
 *                                          simply ignored, and the bias and divisor are adjusted accordingly.
 *                                          Because of the complication at the edges, this edging mode can
 *                                          be significantly slower than the others. It can be numerically
 *                                          unstable if the sum over any rectangular subsection of the kernel
 *                                          is zero, which can result in division by zero during the computation.
 *                                          The results for this edging mode are usually quite visually similar
 *                                          to kvImageEdgeExtend.
 *
 *              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
 *                                          size of the temp buffer needed for this set of parameters. Does
 *                                          not touch the src or dest image.
 *
 *              kvImageDoNotTile            Disable internal multithreading.
 *
 *              kvImageUseFP16Accumulator  Enable 16-bit half-precision floating-point arithmetic when computing the
 *                                          kernel averages when the CPU architecture supports it.
 *
 *      \/textblock </pre>
 *                          The first four flags listed are edging modes. One and only one edging mode must be
 *                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
 *                          be returned.
 *
 *  @return One of the following error codes may be returned:
 *      <pre>\textblock
 *          kvImageNoError              Success.
 *              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
 *                                      the temp buffer to use with this function and this set of
 *                                      parameters.
 *
 *          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
 *                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
 *                                           kvImageEdgeExtend,  kvImageTruncateKernel }
 *
 *          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
 *                                          to corresponding dimensions of the source buffer.
 *
 *          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
 *
 *          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
 *
 *          kvImageNullPointerArgument  kernel may not be NULL
 *
 *          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
 *
 *          kvImageInvalidKernelSize    The kernel sizes must be odd numbers.
 *      \/textblock </pre>
*/
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar16F(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                            @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                            @Const FloatPointer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatPointer kernelY, @Cast("uint32_t") int kernelY_width,
                            float bias, @Cast("Pixel_16F") short backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar16F(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                            @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                            @Const FloatBuffer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatBuffer kernelY, @Cast("uint32_t") int kernelY_width,
                            float bias, @Cast("Pixel_16F") short backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar16F(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                            @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                            @Const float[] kernelX, @Cast("uint32_t") int kernelX_width, @Const float[] kernelY, @Cast("uint32_t") int kernelY_width,
                            float bias, @Cast("Pixel_16F") short backgroundColor, @Cast("vImage_Flags") long flags);

/**
*  \function vImageSepConvolve_Planar16U
*  \abstract Separable convolution on a Planar16U image.
*  \discussion This filter applies two separate 1D filters along the rows and columns of
*              a Planar16U image.
*
*              For each pixel:
*      <pre>\textblock
*          for each pixel[y][x] in image {
*              float sum = bias;
*
*              // Calculate weighted average over kernel area
*              for each kernelY_element[i] in kernelY {
*                  for each kernelX_element[j] in kernelX {
*                  sum += kernelY_element[i] * kernelX_element[j] *
*                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
*                               [x+j+srcOffsetToROI_X- kernel_width/2];
*                  }
*              }
*              // Add 0.5 to round to nearest int when converting float to uint16_t
*              sum = sum + 0.5f;
*
*              // write out result
*              result[y][x] = (uint16_t)CLAMP(sum, 0, 65535);
*          }
*      \/textblock </pre>
*
*              This filter does not work in place.
*
*  @param src              The input image
*
*  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
*                          This may not alias the src image.
*
*  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
*                          computation.  The size of the tempBuffer is given by calling the function
*                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
*                          the size is returned instead of an error code from the left hand side.
*                          You may pass NULL here, in which case a region of memory of similar size
*                          will be allocated by the function and freed before it returns.  Temp Buffers
*                          are a way of avoiding lost time due to VM faults to initialize newly allocated
*                          buffers. If you will be calling this function repeatedly with similar parameters
*                          you should use a temp buffer. If the function is called from different threads
*                          concurrently, a different temp buffer should be used for each.
*
*  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
*                          relative to the src image. Typically this is 0. Non-Zero values are needed
*                          when the destination tile is not aligned with the left edge of the image.
*
*  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
*                          relative to the src image. Typically this is 0. Non-Zero values are needed
*                          when the destination tile is not aligned with the top edge of the image.
*
*  @param kernelX          A pointer to a 1D array of weights of dimension kernelX_width.
*
*  @param kernelX_width    The width of the 1D array of weights passed in as kernelX. It must be an odd number.
*
*  @param kernelY          A pointer to a 1D array of weights of dimension kernelY_width.
*
*  @param kernelY_width    The width of the 1D array of weights passed in as kernelY. It must be an odd number.
*
*  @param bias             This value is added to the sum of weighted pixels.
*                          You might provide a bias of 2 ** 15 = 32768 to move the encoding so that
*                          negative numbers are representable.
*
*  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
*                          parameter provides the background color to be used for missing pixels when the
*                          kernel extends off the edge of the image.
*
*  @param flags            The following flags are allowed:
*      <pre>\textblock
*              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
*                                          copy the corresponding source pixel to the destination. This
*                                          will result in a ring off unconvolved content at the edges
*                                          and convolved content in the middle.
*
*              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
*                                          For a blur filter this will look like the edges of the image
*                                          have been blurred into a particular color. This is usually
*                                          appropriate when the color of the surface onto which the image
*                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
*                                          as a background color, and let the downstream image compositor
*                                          blend in the background color. In this case, the result image
*                                          should be treated as a premultiplied image.
*
*              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
*                                          This is better when the image is drawn into a frame or other
*                                          context where the background is not expected to contribute to
*                                          the final content.
*
*              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
*                                          simply ignored, and the bias and divisor are adjusted accordingly.
*                                          Because of the complication at the edges, this edging mode can
*                                          be significantly slower than the others. It can be numerically
*                                          unstable if the sum over any rectangular subsection of the kernel
*                                          is zero, which can result in division by zero during the computation.
*                                          The results for this edging mode are usually quite visually similar
*                                          to kvImageEdgeExtend.
*
*              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
*                                          size of the temp buffer needed for this set of parameters. Does
*                                          not touch the src or dest image.
*
*              kvImageDoNotTile            Disable internal multithreading.
*
*      \/textblock </pre>
*                          The first four flags listed are edging modes. One and only one edging mode must be
*                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
*                          be returned.
*
*  @return One of the following error codes may be returned:
*      <pre>\textblock
*          kvImageNoError              Success.
*              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
*                                      the temp buffer to use with this function and this set of
*                                      parameters.
*
*          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
*                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
*                                           kvImageEdgeExtend,  kvImageTruncateKernel }
*
*          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
*                                          to corresponding dimensions of the source buffer.
*
*          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
*
*          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
*
*          kvImageNullPointerArgument  kernel may not be NULL
*
*          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
*
*          kvImageInvalidKernelSize    The kernel sizes must be odd numbers.
*      \/textblock </pre>
*/
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                            @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                            @Const FloatPointer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatPointer kernelY, @Cast("uint32_t") int kernelY_width,
                            float bias, @Cast("Pixel_16U") short backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                            @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                            @Const FloatBuffer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatBuffer kernelY, @Cast("uint32_t") int kernelY_width,
                            float bias, @Cast("Pixel_16U") short backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                            @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                            @Const float[] kernelX, @Cast("uint32_t") int kernelX_width, @Const float[] kernelY, @Cast("uint32_t") int kernelY_width,
                            float bias, @Cast("Pixel_16U") short backgroundColor, @Cast("vImage_Flags") long flags);

/**
*  \function vImageSepConvolve_Planar8to16U
*  \abstract Separable convolution on a Planar8 image.
*  \discussion This filter applies two separate 1D filters along the rows and columns of
*              a Planar8 source image and writing the result to a Planar16U destination image.
*              Both a bias and scale factor can be specified to control the range of the result.
*
*              For each pixel:
*      <pre>\textblock
*          for each pixel[y][x] in image {
*              float sum = 0.0f;
*
*              // Calculate weighted average over kernel area
*              for each kernelY_element[i] in kernelY {
*                  for each kernelX_element[j] in kernelX {
*                  sum += kernelY_element[i] * kernelX_element[j] *
*                          pixel[y+i+srcOffsetToROI_Y-kernel_height/2]
*                               [x+j+srcOffsetToROI_X- kernel_width/2];
*                  }
*              }
*              // Scale sum and add bias and 0.5 to round float to uint16_t
*              sum = scale * sum + bias + 0.5f;
*
*              // write out result
*              result[y][x] = (uint16_t)CLAMP(sum, 0, 65535);
*          }
*      \/textblock </pre>
*
*              This filter does not work in place.
*
*  @param src              The input image
*
*  @param dest             A pointer to a preallocated vImage_Buffer to receive the result image.
*                          This may not alias the src image.
*
*  @param tempBuffer       An optional pointer to a region of memory to use as a working area during
*                          computation.  The size of the tempBuffer is given by calling the function
*                          with the same parameters and the kvImageGetTempBufferSize flag, in which case
*                          the size is returned instead of an error code from the left hand side.
*                          You may pass NULL here, in which case a region of memory of similar size
*                          will be allocated by the function and freed before it returns.  Temp Buffers
*                          are a way of avoiding lost time due to VM faults to initialize newly allocated
*                          buffers. If you will be calling this function repeatedly with similar parameters
*                          you should use a temp buffer. If the function is called from different threads
*                          concurrently, a different temp buffer should be used for each.
*
*  @param srcOffsetToROI_X An offset used in tiling to shift the position of the destination image
*                          relative to the src image. Typically this is 0. Non-Zero values are needed
*                          when the destination tile is not aligned with the left edge of the image.
*
*  @param srcOffsetToROI_Y An offset used in tiling to shift the position of the destination image
*                          relative to the src image. Typically this is 0. Non-Zero values are needed
*                          when the destination tile is not aligned with the top edge of the image.
*
*  @param kernelX          A pointer to a 1D array of weights of dimension kernelX_width.
*
*  @param kernelX_width    The width of the 1D array of weights passed in as kernelX. It must be an odd number.
*
*  @param kernelY          A pointer to a 1D array of weights of dimension kernelY_width.
*
*  @param kernelY_width    The width of the 1D array of weights passed in as kernelY. It must be an odd number.
*
*  @param scale            This value is multiplied with the sum of weighted pixels, before the bias
*                          is applied. For example, for normalized kernels, where the weights add to 1.0,
*                          specifying a scale of 257 ( = 65535 / 255 ) would expand the 8-bit input
*                          range to a full 16-bit output range.
*
*  @param bias             This value is added to the sum of weighted pixels.
*
*  @param backgroundColor  When the kvImageBackgroundColorFill edging mode is active, the backgroundColor
*                          parameter provides the background color to be used for missing pixels when the
*                          kernel extends off the edge of the image.
*
*  @param flags            The following flags are allowed:
*      <pre>\textblock
*              kvImageCopyInPlace          If any pixels covered by the kernel do no not exist, simply
*                                          copy the corresponding source pixel to the destination. This
*                                          will result in a ring off unconvolved content at the edges
*                                          and convolved content in the middle.
*
*              kvImageBackgroundColorFill  Substitute in the provided background color for missing pixels.
*                                          For a blur filter this will look like the edges of the image
*                                          have been blurred into a particular color. This is usually
*                                          appropriate when the color of the surface onto which the image
*                                          will be drawn is known.  You can also use {Alpha = 0, color = 0}
*                                          as a background color, and let the downstream image compositor
*                                          blend in the background color. In this case, the result image
*                                          should be treated as a premultiplied image.
*
*              kvImageEdgeExtend           Substitute in the nearest defined pixel for missing pixels.
*                                          This is better when the image is drawn into a frame or other
*                                          context where the background is not expected to contribute to
*                                          the final content.
*
*              kvImageTruncateKernel       This is similar to kvImageEdgeExtend, except that edge pixels are
*                                          simply ignored, and the bias and divisor are adjusted accordingly.
*                                          Because of the complication at the edges, this edging mode can
*                                          be significantly slower than the others. It can be numerically
*                                          unstable if the sum over any rectangular subsection of the kernel
*                                          is zero, which can result in division by zero during the computation.
*                                          The results for this edging mode are usually quite visually similar
*                                          to kvImageEdgeExtend.
*
*              kvImageGetTempBufferSize    Instead of calculating the convolution of the image, return the
*                                          size of the temp buffer needed for this set of parameters. Does
*                                          not touch the src or dest image.
*
*              kvImageDoNotTile            Disable internal multithreading.
*
*      \/textblock </pre>
*                          The first four flags listed are edging modes. One and only one edging mode must be
*                          provided. If no edging mode is provided (e.g. kvImageNoFlags), then an error will
*                          be returned.
*
*  @return One of the following error codes may be returned:
*      <pre>\textblock
*          kvImageNoError              Success.
*              >= 0                    If kvImageGetTempBufferSize is passed, this is the size of
*                                      the temp buffer to use with this function and this set of
*                                      parameters.
*
*          kvImageInvalidEdgeStyle     One and only one of the following flags must be provided:
*                                         { kvImageCopyInPlace, kvImageBackgroundColorFill,
*                                           kvImageEdgeExtend,  kvImageTruncateKernel }
*
*          kvImageRoiLargerThanInputBuffer The dest->width and height must be less than or equal
*                                          to corresponding dimensions of the source buffer.
*
*          kvImageInvalidOffset_X      The destination width + srcOffsetToROI_X > src->width
*
*          kvImageInvalidOffset_Y      The destination height + srcOffsetToROI_Y > src->height
*
*          kvImageNullPointerArgument  kernel may not be NULL
*
*          kvImageMemoryAllocationError Could not allocate memory to serve as a temp buffer.
*
*          kvImageInvalidKernelSize    The kernel sizes must be odd numbers.
*      \/textblock </pre>
*/
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar8to16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                               @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                               @Const FloatPointer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatPointer kernelY, @Cast("uint32_t") int kernelY_width,
                               float scale, float bias, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar8to16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                               @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                               @Const FloatBuffer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatBuffer kernelY, @Cast("uint32_t") int kernelY_width,
                               float scale, float bias, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_Planar8to16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                               @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                               @Const float[] kernelX, @Cast("uint32_t") int kernelX_width, @Const float[] kernelY, @Cast("uint32_t") int kernelY_width,
                               float scale, float bias, @Cast("uint8_t") byte backgroundColor, @Cast("vImage_Flags") long flags);


public static native @Cast("vImage_Error") long vImageSepConvolve_ARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                           @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                           @Const FloatPointer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatPointer kernelY, @Cast("uint32_t") int kernelY_width,
                           float bias, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_ARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                           @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                           @Const FloatBuffer kernelX, @Cast("uint32_t") int kernelX_width, @Const FloatBuffer kernelY, @Cast("uint32_t") int kernelY_width,
                           float bias, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageSepConvolve_ARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer,
                           @Cast("vImagePixelCount") long srcOffsetToROI_X, @Cast("vImagePixelCount") long srcOffsetToROI_Y,
                           @Const float[] kernelX, @Cast("uint32_t") int kernelX_width, @Const float[] kernelY, @Cast("uint32_t") int kernelY_width,
                           float bias, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags);

// #ifdef __cplusplus
// #endif

// #endif




// Parsed from Conversion.h

/**
\header Conversion.h
vImage_Framework
<p>
See vImage/vImage.h for more on how to view the headerdoc documentation for functions declared herein.
<p>
\discussion  This header lists conversions between the many different image formats supported by vImage.  The core formats:
<pre>{@code
Planar 8        Planar 16U      Planar 16S      Float
ARGB8888        ARGB16U         ARGB16S         ARGBFFFF        (also available in other channel orderings)
}</pre>
are supported generally throughout vImage. Other formats may need to be converted to a core format before much can be
done with them. Many conversions between core formats as well as those between core formats and non-core formats are available here.
Please also see vImage_Utilities.h and vImage_CVUtilities.h for interfaces that allow for conversion between various CoreGraphics
and CoreVideo formats.  In many cases, those interfaces can serve as a simpler entrypoint into these APIs. They should be strongly
considered in cases where your code has to handle a variety of different image formats. These interfaces provide direct access to
the low-level workhorse functions for the case when you know exactly what image formats you are working with and want to just call
the right conversion directly.
<p>
Generally speaking, conversions are much faster than other image filters. When tiled correctly, they do not add a lot of extra cost
in cases where you find that your image format is not directly supported by other image filters. They are usually fast enough that
their performance is bottlenecked by throughput to L2, L3, etc. caches.  They benefit greatly from tiling, usually performing best
with wide tile sizes that are less than half the size of the L1 cache. Because of the L1 cache residency requirement for best performance,
they are often not internally multithreaded (it wouldn't help for out-of-cache performance and would cause slowdowns for in-cache)
and may need  to be used within the context of your tiling engine (or vImageConvert_AnyToAny) to reach peak performance. If you are calling
vImage functions within your own multithreaded tiling engine, it is recommended that you use the kvImageDoNotTile flag to make sure that
vImage does its work on the calling thread. This will help ensure that the data just produced on that thread by a previous pass
is resident in the correct L1 cache for the next pass.
<p>
\copyright Copyright (c) 2003-2016 by Apple Inc. All rights reserved.
<p>
\ignorefuncmacro VIMAGE_NON_NULL
*/


// #ifndef VIMAGE_CONVERSION_H
// #define VIMAGE_CONVERSION_H

// #include <vImage/vImage_Types.h>

// #ifdef __cplusplus
// #endif

// #include <TargetConditionals.h>
// #if !0 && !0

/**
 \function vImageClip_PlanarF
 
 \abstract Clips the pixel values of an image in PlanarF format, using the provided minimum and maximum values.
 
 \discussion For each pixel, do the following:
 <pre>{@code
 if( pixel > maxFloat )
 pixel = maxFloat;
 if( pixel < minFloat )
 pixel = minFloat;
 }</pre>
 
 This function can work in place provided the following are true:
 If src overlaps with dest, src->data must be equal to dest->data and src->rowBytes >= dest->rowBytes
 If an overlapping src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param src
 A pointer to a vImage buffer structure that contains the source image whose data you want to clip.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a allocated buffer to receive the result pixels.
 
 @param maxFloat
 A maximum pixel value. The function clips larger values to this value in the destination image.
 
 @param minFloat
 A minimum pixel value. The function clips smaller values to this value in the destination image.
 
 @param flags
 \p kvImageNoFlags      Default operation.
 \p kvImageDoNotTile    Disable internal multithreading.
 
 @return kvImageNoError                      Success
 @return kvImageRoiLargerThanInputBuffer     The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \note This function may be used for multichannel image formats, such as ARGBFFFF.
 Scale the vImage_Buffer.width to compensate for the extra channels.
 */
public static native @Cast("vImage_Error") long vImageClip_PlanarF(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("float") float maxFloat, @Cast("float") float minFloat, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_Planar8toPlanarF
 
 \abstract Convert an array of 8 bit integer data to floating point data.
 
 \discussion For each pixel, do the following:
 <pre>{@code
 float result = (maxFloat - minFloat) * (float) srcPixel / 255.0  + minFloat
 }</pre>
 
 You can use this for ARGB8888 -> ARGBFFFF conversions by simply multiplying the width of the vImage_Buffer by 4 (for 4 channels)
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a allocated buffer to receive the result pixels.
 
 @param maxFloat
 A maximum float value.
 
 @param minFloat
 A minimum float value.
 
 @param flags
 \p kvImageNoFlags                      Default operation.
 \p kvImageDoNotTile                    Disable internal multithreading.
 \p kvImagePrintDiagnosticsToConsole    Directs the function to print diagnostic information to the console in the event of failure.
 
 @return kvImageNoError                     Success
 @return kvImageUnknownFlagsBit             Not all vImage flags are understood by this function. See description of flags parameter for supported flags.
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \note Does not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar8toPlanarF(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("float") float maxFloat, @Cast("float") float minFloat, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_PlanarFtoPlanar8
 
 \abstract Convert an array of floating point data to 8 bit integer data.
 
 \discussion For each pixel, do the following:
 <pre>{@code
 uint8_t result = SATURATED_CLIP_0_to_255( 255.0f * ( srcPixel - minFloat ) / (maxFloat - minFloat) + 0.5f );
 }</pre>
 
 You can use this for ARGBFFFF -> ARGB8888 conversions by simply multiplying the width of the vImage_Buffer by 4 (for 4 channels)
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a allocated buffer to receive the result pixels.
 
 @param maxFloat
 A maximum float value.
 
 @param minFloat
 A minimum float value.
 
 @param flags
 \p kvImageNoFlags      Default operation
 \p kvImageDoNotTile    Disable internal multithreading.  You should use this if you are doing your own threading / tiling.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_PlanarFtoPlanar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("float") float maxFloat, @Cast("float") float minFloat, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_PlanarFtoPlanar8_dithered
 
 \abstract Convert an array of floating point data to 8 bit integer data with dithering.
 
 \discussion For each pixel, do the following:
 <pre>{@code
 uint8_t result = SATURATED_CLIP_0_to_255( 255.0f * ( srcPixel - minFloat ) / (maxFloat - minFloat) + random_float[0,1) );
 }</pre>
 
 The \p dither parameter must be one of the following flags:
 \p kvImageConvert_DitherNone Same as vImageConvert_PlanarFtoPlanar8(). Rounds to nearest.
 
 \p kvImageConvert_DitherOrdered Pre-computed blue noise is added to the image before rounding to the values in
 the destination format.  The offset into this blue noise is randomized per-call to avoid visible artifacts
 if you do your own tiling or call the function on sequential frames of video.
 
 \p kvImageConvert_DitherOrderedReproducible Pre-computed blue noise is added to the image before rounding to the
 values in the destination format.  The offset into the blue noise is the same for every call to allow users
 to get reproducible results. Fine for still images. For video kvImageConvert_DitherOrdered is a better choice.
 
 The ordered dither methods may be further influenced by shaping the distribution of the noise using the gaussian and uniform options below.
 These options are OR-ed with kvImageConvert_DitherOrdered / kvImageConvert_DitherOrderedReproducible:
 
 \p kvImageConvert_OrderedGaussianBlue When using an ordered dither pattern, distribute the noise according to a gaussian
 distribution. This generally gives more pleasing images --  less noisy and perhaps a little more saturated -- but color
 fidelity can suffer. Its effect is between kvImageConvert_DitherNone and kvImageConvert_DitherOrdered | kvImageConvert_DitherUniform.
 This is the default for kvImageConvert_DitherOrdered and kvImageConvert_DitherOrderedReproducible.
 
 \p kvImageConvert_OrderedUniformBlue When using an ordered dither pattern, distribute the noise uniformly. This generally gives
 best color fidelity, but the resulting image is noisier and more obviously dithered. This is usually the best choice when low
 bitdepth content is drawn next to high bitdepth content and in other circumstances where subtle changes to color arising from the conversion
 could be easily noticed. It may be a poor choice when the image is likely to be enlarged -- this would cause the noise to become
 more evident-- and for very flat / synthetic content with little inherent noise. The enlargement problem may be avoided by enlarging
 first at high bitdepth, then convert to lower bitdepth.
 
 \note "Blue" noise does not look blue, nor does it operate solely on the blue color channel. Blue noise is monochrome noise that is added to all color
 channels equally. The name arises from blue light, which has a higher frequency than other colors of visible light. Thus, blue noise is noise which is
 weighted heavily towards high frequencies. Low frequency noise tends to have visible shapes in it that would become apparent in an image if it was added in,
 so it is excluded from the dither pattern.
 
 \warning Unlike vImageConvert_PlanarFtoPlanar8, vImageConvert_PlanarFtoPlanar8_dithered usually should not be used for
 multichannel data. Otherwise the dithering will occur in the chrominance dimensions and the noise will cause
 grain with varying hue.
 
 \note This function can work in place provided the following are true:
 If src overlaps with dest, src->data must be equal to dest->data and src->rowBytes >= dest->rowBytes.
 If an overlapping src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags.
 
 @param src               A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest              A pointer to a valid and initialized vImage_Buffer struct, that points to a allocated buffer to receive the result pixels.
 
 @param maxFloat          The encoding for 1.0 in the src buffer, full intensity. Typically, this is 1.0 for floating-point data in the range[0,1] but if your data is [0,65535] then you would pass 65535.0f here.
 
 @param minFloat          The encoding for 0.0 in the src buffer, no light.  Typically this is 0.0 for floating-point data in the range [0,1], but if your data is [-.5,0.5] then you would pass -0.5f here.
 
 @param dither            The type of random noise to use for the dither. See discussion for more details.
 
 @param flags                   The following flags are honored:
 \p kvImageNoFlags              Default operation.
 \p kvImageDoNotTile            Disable internal multithreading, if any.
 \p kvImageGetTempBufferSize    Returns 0. Does no work. Does not touch data.
 
 @return \p kvImageNoError                      Success
 @return \p kvImageRoiLargerThanInputBuffer     The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 @return \p kvImageUnknownFlagsBit              Not all vImage flags are understood by this function. See description of flags parameter for supported flags.
 @return \p kvImageInvalidParameter             An unknown / unsupported dithering mode was requested.
 
 \seealso vImageConvert_PlanarFtoPlanar8
 */
public static native @Cast("vImage_Error") long vImageConvert_PlanarFtoPlanar8_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("float") float maxFloat, @Cast("float") float minFloat, int dither, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_RGBFFFtoRGB888_dithered
 
 \abstract Convert an array of floating point data to 8 bit integer data with dithering.
 
 \discussion For each pixel, do the following:
 <pre>{@code
 // convert to uint8_t
 result[0] = SATURATED_CLIP_0_to_255( 255.0f * ( srcPixel[0] - minFloat[0] ) / (maxFloat[0] - minFloat[0]) + random_float[0,1) );
 result[1] = SATURATED_CLIP_0_to_255( 255.0f * ( srcPixel[1] - minFloat[1] ) / (maxFloat[1] - minFloat[1]) + random_float[0,1) );
 result[2] = SATURATED_CLIP_0_to_255( 255.0f * ( srcPixel[2] - minFloat[2] ) / (maxFloat[2] - minFloat[2]) + random_float[0,1) );
 }</pre>
 
 This function will work for other channel orders, such as BGR, and other colorspaces such as L*a*b*.
 If you need to change channel orders, please see vImagePermuteChannels_RGB888().
 
 The \p dither parameter must be one of the following flags:
 \p kvImageConvert_DitherNone Same as vImageConvert_PlanarFtoPlanar8(). Rounds to nearest.
 
 \p kvImageConvert_DitherOrdered Pre-computed blue noise is added to the image before rounding to the values in
 the destination format.  The offset into this blue noise is randomized per-call to avoid visible artifacts
 if you do your own tiling or call the function on sequential frames of video.
 
 \p kvImageConvert_DitherOrderedReproducible Pre-computed blue noise is added to the image before rounding to the
 values in the destination format.  The offset into the blue noise is the same for every call to allow users
 to get reproducible results. Fine for still images. For video kvImageConvert_DitherOrdered is a better choice.
 
 The ordered dither methods may be further influenced by shaping the distribution of the noise using the gaussian and uniform options below.
 These options are OR-ed with kvImageConvert_DitherOrdered / kvImageConvert_DitherOrderedReproducible:
 
 \p kvImageConvert_OrderedGaussianBlue When using an ordered dither pattern, distribute the noise according to a gaussian
 distribution. This generally gives more pleasing images --  less noisy and perhaps a little more saturated -- but color
 fidelity can suffer. Its effect is between kvImageConvert_DitherNone and kvImageConvert_DitherOrdered | kvImageConvert_DitherUniform.
 This is the default for kvImageConvert_DitherOrdered and kvImageConvert_DitherOrderedReproducible.
 
 \p kvImageConvert_OrderedUniformBlue When using an ordered dither pattern, distribute the noise uniformly. This generally gives
 best color fidelity, but the resulting image is noisier and more obviously dithered. This is usually the best choice when low
 bitdepth content is drawn next to high bitdepth content and in other circumstances where subtle changes to color arising from the conversion
 could be easily noticed. It may be a poor choice when the image is likely to be enlarged -- this would cause the noise to become
 more evident-- and for very flat / synthetic content with little inherent noise. The enlargement problem may be avoided by enlarging
 first at high bitdepth, then convert to lower bitdepth.
 
 \note "Blue" noise does not look blue, nor does it operate solely on the blue color channel. Blue noise is monochrome noise that is added to all color
 channels equally. The name arises from blue light, which has a higher frequency than other colors of visible light. Thus, blue noise is noise which is
 weighted heavily towards high frequencies. Low frequency noise tends to have visible shapes in it that would become apparent in an image if it was added in,
 so it is excluded from the dither pattern.
 
 \note This function can work in place provided the following are true:
 If src overlaps with dest, src->data must be equal to dest->data and src->rowBytes >= dest->rowBytes.
 If an overlapping src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param src               A pointer to a valid and initialized vImage_Buffer struct that points to a buffer containing the source pixels.
 
 @param dest              A pointer to a valid and initialized vImage_Buffer struct that points to a allocated buffer to receive the result pixels.
 
 @param maxFloat          The encoding for 1.0 in the src buffer, full intensity.
 Typically, this is 1.0 for floating-point data in the range[0,1]
 but if your data is [0,65535] then you would pass 65535.0f here.
 A separate value is provided for each of the three channels.
 
 @param minFloat          The encoding for 0.0 in the src buffer, no light.
 Typically this is 0.0 for floating-point data in the range [0,1],
 but if your data is [-.5,0.5] then you would pass -0.5f here.
 A separate value is provided for each of the three channels.
 
 @param dither            The type of random noise to use for the dither. See discussion for more details.
 
 @param flags                   The following flags are honored:
 \p kvImageNoFlags              Default operation.
 \p kvImageDoNotTile            Disable internal multithreading, if any.
 \p kvImageGetTempBufferSize    Returns 0. Does no work. Does not touch data.
 
 @return \p kvImageNoError                      Success
 @return \p kvImageRoiLargerThanInputBuffer     The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 @return \p kvImageUnknownFlagsBit              Not all vImage flags are understood by this function. See description of flags parameter for supported flags.
 @return \p kvImageInvalidParameter             An unknown / unsupported dithering mode was requested.
 
 \seealso vImageConvert_RGBFFFtoRGB888
 \seealso vImagePermuteChannels_RGB888
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBFFFtoRGB888_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const Pixel_F*") FloatPointer maxFloat, @Cast("const Pixel_F*") FloatPointer minFloat, int dither, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGBFFFFtoARGB8888_dithered
 
 \abstract Convert an array of floating point data to 8 bit integer data with dithering.
 
 \discussion For each pixel, do the following:
 <pre>{@code
 // convert to uint8_t
 Pixel_8888 temp;
 temp[0] = SATURATED_CLIP_0_to_255( 255.0f * ( srcPixel[0] - minFloat[0] ) / (maxFloat[0] - minFloat[0]) + random_float[0,1) );
 temp[1] = SATURATED_CLIP_0_to_255( 255.0f * ( srcPixel[1] - minFloat[1] ) / (maxFloat[1] - minFloat[1]) + random_float[0,1) );
 temp[2] = SATURATED_CLIP_0_to_255( 255.0f * ( srcPixel[2] - minFloat[2] ) / (maxFloat[2] - minFloat[2]) + random_float[0,1) );
 temp[3] = SATURATED_CLIP_0_to_255( 255.0f * ( srcPixel[3] - minFloat[3] ) / (maxFloat[3] - minFloat[3]) + random_float[0,1) );
 
 // place in requested output order
 Pixel_8888 result;
 result[0] = temp[permuteMap[0]];
 result[1] = temp[permuteMap[1]];
 result[2] = temp[permuteMap[2]];
 result[3] = temp[permuteMap[3]];
 }</pre>
 
 The \p dither parameter must be one of the following flags:
 \p kvImageConvert_DitherNone Same as vImageConvert_PlanarFtoPlanar8(). Rounds to nearest.
 
 \p kvImageConvert_DitherOrdered Pre-computed blue noise is added to the image before rounding to the values in
 the destination format.  The offset into this blue noise is randomized per-call to avoid visible artifacts
 if you do your own tiling or call the function on sequential frames of video.
 
 \p kvImageConvert_DitherOrderedReproducible Pre-computed blue noise is added to the image before rounding to the
 values in the destination format.  The offset into the blue noise is the same for every call to allow users
 to get reproducible results. Fine for still images. For video kvImageConvert_DitherOrdered is a better choice.
 
 The ordered dither methods may be further influenced by shaping the distribution of the noise using the gaussian and uniform options below.
 These options are OR-ed with kvImageConvert_DitherOrdered / kvImageConvert_DitherOrderedReproducible:
 
 \p kvImageConvert_OrderedGaussianBlue When using an ordered dither pattern, distribute the noise according to a gaussian
 distribution. This generally gives more pleasing images --  less noisy and perhaps a little more saturated -- but color
 fidelity can suffer. Its effect is between kvImageConvert_DitherNone and kvImageConvert_DitherOrdered | kvImageConvert_DitherUniform.
 This is the default for kvImageConvert_DitherOrdered and kvImageConvert_DitherOrderedReproducible.
 
 \p kvImageConvert_OrderedUniformBlue When using an ordered dither pattern, distribute the noise uniformly. This generally gives
 best color fidelity, but the resulting image is noisier and more obviously dithered. This is usually the best choice when low
 bitdepth content is drawn next to high bitdepth content and in other circumstances where subtle changes to color arising from the conversion
 could be easily noticed. It may be a poor choice when the image is likely to be enlarged -- this would cause the noise to become
 more evident-- and for very flat / synthetic content with little inherent noise. The enlargement problem may be avoided by enlarging
 first at high bitdepth, then convert to lower bitdepth.
 
 \note "Blue" noise does not look blue, nor does it operate solely on the blue color channel. Blue noise is monochrome noise that is added to all color
 channels equally. The name arises from blue light, which has a higher frequency than other colors of visible light. Thus, blue noise is noise which is
 weighted heavily towards high frequencies. Low frequency noise tends to have visible shapes in it that would become apparent in an image if it was added in,
 so it is excluded from the dither pattern.
 
 \note This function will work for other channel orders, such as RGBA and BGRA.
 
 \note This function can work in place provided the following are true:
 If src overlaps with dest, src->data must be equal to dest->data and src->rowBytes >= dest->rowBytes
 If an overlapping src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param src         A pointer to a valid and initialized vImage_Buffer struct that points to a buffer containing the source pixels.
 
 @param dest        A pointer to a valid and initialized vImage_Buffer struct that points to a allocated buffer to receive the result pixels.
 
 @param maxFloat    The encoding for 1.0 in the src buffer, full intensity.
 Typically, this is 1.0 for floating-point data in the range[0,1]
 but if your data is [0,65535] then you would pass 65535.0f here.
 A separate value is provided for each of the three channels.
 
 @param minFloat    The encoding for 0.0 in the src buffer, no light.
 Typically this is 0.0 for floating-point data in the range [0,1],
 but if your data is [-.5,0.5] then you would pass -0.5f here.
 A separate value is provided for each of the three channels.
 
 @param dither      The type of random noise to use for the dither. See discussion for more details.
 
 @param permuteMap  A 4 element array giving the order of the result channels.
 This allows you to convert a ARGB float buffer to a BGRA result
 buffer by providing the order {3,2,1,0}.
 
 @param flags                   The following flags are honored:
 \p kvImageNoFlags              Default operation.
 \p kvImageDoNotTile            Disable internal multithreading, if any.
 \p kvImageGetTempBufferSize    Returns 0. Does no work. Does not touch data.
 
 @return \p kvImageNoError                      Success
 @return \p kvImageRoiLargerThanInputBuffer     The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 @return \p kvImageUnknownFlagsBit              Not all vImage flags are understood by this function. See description of flags parameter for supported flags.
 @return \p kvImageInvalidParameter             An unknown / unsupported dithering mode was requested.
 
 \seealso vImageConvert_RGBFFFtoRGB888
 \seealso vImagePermuteChannels_RGB888
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGBFFFFtoARGB8888_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const float*") FloatPointer maxFloat, @Cast("const float*") FloatPointer minFloat, int dither, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGBFFFFtoARGB8888_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const float*") FloatPointer maxFloat, @Cast("const float*") FloatPointer minFloat, int dither, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGBFFFFtoARGB8888_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const float*") FloatPointer maxFloat, @Cast("const float*") FloatPointer minFloat, int dither, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_Planar8toARGB8888
 
 \abstract Interleave 4 planar 8 bit integer buffers to make an interleaved 4 channel ARGB8888 buffer.
 
 \discussion For each pixel in { srcA, srcR, srcG, srcB }, do the following:
 <pre>{@code
 Pixel_88888 result = { pixelFromSrcA, pixelFromSrcR, pixelFromSrcG, pixelFromSrcB };
 }</pre>
 
 This function may be used to create other channel orderings such as RGBA8888 by passing in the planar8 images in the alternate order.
 
 @param srcA
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing A source pixels.
 
 @param srcR
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing R source pixels.
 
 @param srcG
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing G source pixels.
 
 @param srcB
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing B source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a allocated buffer to receive the result pixels.
 
 @param flags
 \p kvImageNoFlags      Default operation
 \p kvImageDoNotTile    Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \note Does not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar8toARGB8888(@Const vImage_Buffer srcA, @Const vImage_Buffer srcR, @Const vImage_Buffer srcG, @Const vImage_Buffer srcB, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_PlanarFtoARGBFFFF
 
 \abstract Interleave 4 planar floating point buffers to make an interleaved 4 channel ARGBFFFF buffer.
 
 \discussion For each pixel in { srcA, srcR, srcG, srcB }, do the following:
 <pre>{@code
 Pixel_FFFF result = { pixelFromSrcA, pixelFromSrcR, pixelFromSrcG, pixelFromSrcB };
 }</pre>
 
 This function may be used to create other channel orderings such as RGBAFFFF by passing in the planar8 images in the alternate order.
 
 @param srcA
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing A source pixels.
 
 @param srcR
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing R source pixels.
 
 @param srcG
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing G source pixels.
 
 @param srcB
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing B source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a allocated buffer to receive the result pixels.
 
 @param flags
 \p kvImageNoFlags      Default operation
 \p kvImageDoNotTile    Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \note Does not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_PlanarFtoARGBFFFF(@Const vImage_Buffer srcA, @Const vImage_Buffer srcR, @Const vImage_Buffer srcG, @Const vImage_Buffer srcB, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);

// #define vImageConvert_PlanarFtoRGBAFFFF(_red, _green, _blue, _alpha, _dest, _flags)
// vImageConvert_PlanarFtoARGBFFFF((_red), (_green), (_blue), (_alpha), (_dest), (_flags))
// #define vImageConvert_PlanarFtoBGRAFFFF(_blue, _green, _red, _alpha, _dest, _flags)
// vImageConvert_PlanarFtoARGBFFFF((_blue), (_green), (_red), (_alpha), (_dest), (_flags))

/**
 \function vImageConvert_ARGB8888toPlanar8
 
 \abstract Deinterleave an ARGB8888 interleaved vImage_Buffer to form 4 planar 8-bit integer buffers.
 
 \discussion For each pixel in srcARGB, do the following:
 <pre>{@code
 Pixel_8 destAResult = srcARGBPixel[0];
 Pixel_8 destRResult = srcARGBPixel[1];
 Pixel_8 destGResult = srcARGBPixel[2];
 Pixel_8 destBResult = srcARGBPixel[3];
 }</pre>
 
 This function may be used to deinterleave other channel orderings such as RGBA8888 by passing in the planar8 images in the alternate order.
 
 @param srcARGB
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixels.
 
 @param destA
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing A destination pixels.
 
 @param destR
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing R destination pixels.
 
 @param destG
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing G destination pixels.
 
 @param destB
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing B destination pixels.
 
 @param flags
 \p kvImageNoFlags      Default operation
 \p kvImageDoNotTile    Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \note Does not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888toPlanar8(@Const vImage_Buffer srcARGB, @Const vImage_Buffer destA, @Const vImage_Buffer destR, @Const vImage_Buffer destG, @Const vImage_Buffer destB, @Cast("vImage_Flags") long flags);
// #define vImageConvert_RGBA8888toPlanar8(_src, _red, _green, _blue, _alpha, _flags)
// vImageConvert_ARGB8888toPlanar8((_src), (_red), (_green), (_blue), (_alpha), (_flags))
// #define vImageConvert_BGRA8888toPlanar8(_src, _blue, _green, _red, _alpha, _flags)
// vImageConvert_ARGB8888toPlanar8((_src), (_blue), (_green), (_red), (_alpha), (_flags))

/**
 \function vImageConvert_ARGBFFFFtoPlanarF
 
 \abstract Deinterleave an ARGBFFFF interleaved vImage_Buffer to form 4 planar floating point buffers.
 
 \discussion For each pixel in srcARGB, do the following:
 <pre>{@code
 Pixel_F destAResult = srcARGBPixel[0];
 Pixel_F destRResult = srcARGBPixel[1];
 Pixel_F destGResult = srcARGBPixel[2];
 Pixel_F destBResult = srcARGBPixel[3];
 }</pre>
 
 This function may be used to deinterleave other channel orderings such as RGBAFFFF by passing in the planar8 images in the alternate order.
 
 @param srcARGB
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixels.
 
 @param destA
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing A destination pixels.
 
 @param destR
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing R destination pixels.
 
 @param destG
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing G destination pixels.
 
 @param destB
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing B destination pixels.
 
 @param flags
 \p kvImageNoFlags      Default operation
 \p kvImageDoNotTile    Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \note Does not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGBFFFFtoPlanarF(@Const vImage_Buffer srcARGB, @Const vImage_Buffer destA, @Const vImage_Buffer destR, @Const vImage_Buffer destG, @Const vImage_Buffer destB, @Cast("vImage_Flags") long flags);
// #define vImageConvert_RGBAFFFFtoPlanarF(_src, _red, _green, _blue, _alpha, _flags)
// vImageConvert_ARGBFFFFtoPlanarF((_src), (_red), (_green), (_blue), (_alpha), (_flags))
// #define vImageConvert_BGRAFFFFtoPlanarF(_src, _blue, _green, _red, _alpha, _flags)
// vImageConvert_ARGBFFFFtoPlanarF((_src), (_blue), (_green), (_red), (_alpha), (_flags))

/*
 vImageConvert_ChunkyToPlanar8
 vImageConvert_PlanarToChunky8
 vImageConvert_ChunkyToPlanarF
 vImageConvert_PlanarToChunkyF
 
 These functions convert between nearly arbitrary interleaved data formats that vImage
 doesn't support to/from planar data formats that it does support.
 N planar arrays are interleaved to make (or are made made by deinterleaving)
 a N channel packed interleaved buffer with pixels that are {srcStrideBytes, destStrideBytes}
 bytes in size. Valid data channels are assumed to be at the front of each interleaved pixel.
 
 Will not work in place
 
 Performance advisory:
 =====================
 These functions are too flexible to vectorize every case. When appropriate, it is suggested you use the other
 special purpose conversion functions. If you know what your data formats are ahead of time, it is
 likely you can write your own special purpose conversion function that is faster, even in scalar code.
 These functions are provided as a convenience.
 */
public static native @Cast("vImage_Error") long vImageConvert_ChunkyToPlanar8( @Cast("const void**") PointerPointer srcChannels, @Cast("const vImage_Buffer**") PointerPointer destPlanarBuffers, @Cast("unsigned int") int channelCount, @Cast("size_t") long srcStrideBytes, @Cast("vImagePixelCount") long srcWidth, @Cast("vImagePixelCount") long srcHeight, @Cast("size_t") long srcRowBytes, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_ChunkyToPlanar8( @Cast("const void**") @ByPtrPtr Pointer srcChannels, @Const @ByPtrPtr vImage_Buffer destPlanarBuffers, @Cast("unsigned int") int channelCount, @Cast("size_t") long srcStrideBytes, @Cast("vImagePixelCount") long srcWidth, @Cast("vImagePixelCount") long srcHeight, @Cast("size_t") long srcRowBytes, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_PlanarToChunky8( @Cast("const vImage_Buffer**") PointerPointer srcPlanarBuffers, @Cast("void**") PointerPointer destChannels, @Cast("unsigned int") int channelCount, @Cast("size_t") long destStrideBytes, @Cast("vImagePixelCount") long destWidth, @Cast("vImagePixelCount") long destHeight, @Cast("size_t") long destRowBytes, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_PlanarToChunky8( @Const @ByPtrPtr vImage_Buffer srcPlanarBuffers, @Cast("void**") @ByPtrPtr Pointer destChannels, @Cast("unsigned int") int channelCount, @Cast("size_t") long destStrideBytes, @Cast("vImagePixelCount") long destWidth, @Cast("vImagePixelCount") long destHeight, @Cast("size_t") long destRowBytes, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_ChunkyToPlanarF( @Cast("const void**") PointerPointer srcChannels, @Cast("const vImage_Buffer**") PointerPointer destPlanarBuffers, @Cast("unsigned int") int channelCount, @Cast("size_t") long srcStrideBytes, @Cast("vImagePixelCount") long srcWidth, @Cast("vImagePixelCount") long srcHeight, @Cast("size_t") long srcRowBytes, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_ChunkyToPlanarF( @Cast("const void**") @ByPtrPtr Pointer srcChannels, @Const @ByPtrPtr vImage_Buffer destPlanarBuffers, @Cast("unsigned int") int channelCount, @Cast("size_t") long srcStrideBytes, @Cast("vImagePixelCount") long srcWidth, @Cast("vImagePixelCount") long srcHeight, @Cast("size_t") long srcRowBytes, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_PlanarToChunkyF( @Cast("const vImage_Buffer**") PointerPointer srcPlanarBuffers, @Cast("void**") PointerPointer destChannels, @Cast("unsigned int") int channelCount, @Cast("size_t") long destStrideBytes, @Cast("vImagePixelCount") long destWidth, @Cast("vImagePixelCount") long destHeight, @Cast("size_t") long destRowBytes, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_PlanarToChunkyF( @Const @ByPtrPtr vImage_Buffer srcPlanarBuffers, @Cast("void**") @ByPtrPtr Pointer destChannels, @Cast("unsigned int") int channelCount, @Cast("size_t") long destStrideBytes, @Cast("vImagePixelCount") long destWidth, @Cast("vImagePixelCount") long destHeight, @Cast("size_t") long destRowBytes, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_16SToF
 
 \abstract Convert a planar vImage_Buffer of 16 bit signed integers to a buffer containing floating point values.
 
 \discussion For each 16 bit pixel in src, do the following:
 <pre>{@code
 float result = (float) srcPixel * scale + offset;
 }</pre>
 
 To convert 4 channel interleaved signed 16 bit data to ARGBFFFF, simply multiply the vImage_Buffer.width by 4.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param scale
 A scale value in the conversion.
 
 @param offset
 A offset value in the conversion.
 
 @param flags
 \p kvImageNoFlags                     Default operation
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                       Success
 @return kvImageRoiLargerThanInputBuffer      The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \note Does not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_16SToF( @Const vImage_Buffer src, @Const vImage_Buffer dest, float offset, float scale, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_16UToF
 
 \abstract Convert a planar vImage_Buffer of 16 bit unsigned integers to a buffer containing floating point values.
 
 \discussion For each 16 bit pixel in src, do the following:
 <pre>{@code
 float result = (float) srcPixel * scale + offset;
 }</pre>
 
 To convert 4 channel interleaved signed 16 bit data to ARGBFFFF, simply multiply the vImage_Buffer.width by 4.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param scale
 A scale value in the conversion.
 
 @param offset
 A offset value in the conversion.
 
 @param flags
 \p kvImageNoFlags                     Default operation
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                       Success
 @return kvImageRoiLargerThanInputBuffer      The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \note Does not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_16UToF( @Const vImage_Buffer src, @Const vImage_Buffer dest, float offset, float scale, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_FTo16S
 
 \abstract Convert a planar vImage_Buffer of floating point values to a buffer of 16 bit signed integers.
 
 \discussion For each floating point pixel in src, do the following:
 <pre>{@code
 int16_t result = SATURATED_CLIP_SHRT_MIN_to_SHRT_MAX( (srcPixel - offset) / scale  + 0.5f);
 }</pre>
 
 Programmer's note:
 The scale and offset here are designed to be the same offset and scale used for the vImageConvert_16SToF conversion.
 For a lossless round trip (within the limits of floating point precision), use the same scale and offset values
 in both directions:
 
 vImageConvert_16SToF( int16_buffer, float_buffer, myOffset, myScale, kvImageNoFlags );   //Convert to float
 vImageConvert_FTo16S( float_buffer, int16_buffer, myOffset, myScale, kvImageNoFlags );   //Convert back to int16_t
 
 \note Works in place, as long as src->data == dest->data and src->rowBytes == dest->rowBytes.
 \note To convert multichannel interleaved floating point formats (e.g. ARGBFFFF) to a multichannel 16-bit image format with the same channel ordering, simply multiply the vImage_Buffer.width by the number of channels.
 
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param scale             A scale value in the conversion.
 
 @param offset            A offset value in the conversion.
 
 @param flags
 \p kvImageNoFlags                     Default operation
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_FTo16S( @Const vImage_Buffer src, @Const vImage_Buffer dest, float offset, float scale, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_FTo16U
 
 \abstract Convert a planar vImage_Buffer of floating point values to a buffer of 16 bit unsigned integers.
 
 \discussion For each floating point pixel in src, do the following:
 <pre>{@code
 uint16_t result = SATURATED_CLIP_0_to_USHRT_MAX( (srcPixel - offset) / scale  + 0.5f);
 }</pre>
 
 Programmer's note:
 The scale and offset here are designed to be the same offset and scale used for the vImageConvert_16UToF conversion.
 For a lossless round trip (within the limits of floating point precision), use the same scale and offset values
 in both directions:
 
 vImageConvert_16UToF( int16_buffer, float_buffer, myOffset, myScale, kvImageNoFlags );   //Convert to float
 vImageConvert_FTo16U( float_buffer, int16_buffer, myOffset, myScale, kvImageNoFlags );   //Convert back to uint16_t
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param scale             A scale value in the conversion.
 
 @param offset            A offset value in the conversion.
 
 @param flags
 \p kvImageNoFlags                     Default operation.
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                     Success.
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \note Works in place, as long as src->data == dest->data and src->rowBytes == dest->rowBytes.
 
 \note To convert multichannel interleaved floating point formats (e.g. ARGBFFFF) to a multichannel 16-bit image format with the same channel ordering, simply multiply the vImage_Buffer.width by the number of channels.
 */
public static native @Cast("vImage_Error") long vImageConvert_FTo16U( @Const vImage_Buffer src, @Const vImage_Buffer dest, float offset, float scale, @Cast("vImage_Flags") long flags );


/**
 \function vImageConvert_16Uto16F
 
 \abstract Convert from 16 bit unsigned integer to 16 bit float format.
 
 \discussion For each floating point pixel in src, do the following:
 <pre>{@code
 destPixel[x] = ConvertToPlanar16F(srcPixel[x]);
 }</pre>
 
 The 16 bit floating point format is half-precision floating point
 (a.k.a.  IEEE-754 binary16, OpenCL half, GL_ARB_half_float_pixel, OpenEXR half).
 It has a layout as follows:
 
 16 bits:  seeeeemmmmmmmmmm
 
 1-bit sign | 5 bits of exponent, with a bias of 15 | 10 bits of significand
 (with 11 bits of significance due to the implicit 1 bit)
 
 NaNs, Infinities and denormals are supported.
 Per IEEE-754, all signaling NaNs are quieted during the conversion. (OpenEXR-1.2.1 converts SNaNs to SNaNs.)
 To set/inspect the current IEEE-754 rounding mode, please see appropriate utilities in fenv.h.
 
 @param src
 A pointer to a vImage_Buffer that references the source pixels.
 
 @param dest
 A pointer to a vImage_Buffer that references the destination pixels.
 
 @param flags
 \p kvImageDoNotTile    Turns off internal multithreading.
 
 @return \p kvImageNoError                      Success!
 @return \p kvImageRoiLargerThanInputBuffer     The source buffer must have a height and
 width at least as large as the destination buffer.
 @return \p kvImageNullPointerArgument          src or dest pointer is NULL.
 @return \p kvImageUnknownFlagsBit              Unknown flag was passed.
 
 \note This routine will work in place provided that src.data == dest.data
 and src.rowBytes >= dest.rowBytes. However, when src.rowBytes > dest.rowBytes
 in-place will only work if you pass kvImageDoNotTile.
 
 \note To use this with interleaved data, multiply vImage_Buffer.width by 4.
 */
public static native @Cast("vImage_Error") long vImageConvert_16Uto16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_16Fto16U
 
 \abstract Convert from 16 bit float to 16 bit unsigned integer format.
 
 \discussion For each floating point pixel in src, do the following:
 <pre>{@code
 destPixel[x] = ConvertToPlanar16U(srcPixel[x]);
 }</pre>
 
 The 16 bit floating point format is half-precision floating point
 (a.k.a.  IEEE-754 binary16, OpenCL half, GL_ARB_half_float_pixel, OpenEXR half).
 It has a layout as follows:
 
 16 bits:  seeeeemmmmmmmmmm
 
 1-bit sign | 5 bits of exponent, with a bias of 15 | 10 bits of significand
 (with 11 bits of significance due to the implicit 1 bit)
 
 NaNs, Infinities and denormals are supported.
 Per IEEE-754, all signaling NaNs are quieted during the conversion. (OpenEXR-1.2.1 converts SNaNs to SNaNs.)
 To set/inspect the current IEEE-754 rounding mode, please see appropriate utilities in fenv.h
 
 @param src
 A pointer to a vImage_Buffer that references the source pixels.
 
 @param dest
 A pointer to a vImage_Buffer that references the destination pixels.
 
 @param flags
 \p kvImageDoNotTile    Turns off internal multithreading.
 
 @return \p kvImageNoError              Success!
 @return \p kvImageRoiLargerThanInputBuffer   The source buffer must have a height and
 width at least as large as the destination buffer.
 @return \p kvImageNullPointerArgument  src or dest pointer is NULL.
 @return \p kvImageUnknownFlagsBit      Unknown flag was passed.
 
 \note This routine will work in place provided that src.data == dest.data
 and src.rowBytes >= dest.rowBytes. However, when src.rowBytes > dest.rowBytes
 in-place will only work if you pass kvImageDoNotTile.
 
 \note To use this with interleaved data, multiply vImage_Buffer.width by 4
 */
public static native @Cast("vImage_Error") long vImageConvert_16Fto16U( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );


/**
 \function vImageConvert_12UTo16U
 
 \abstract Converts 12U to 16U
 
 \discussion For each floating point pixel in src, do the following:
 <pre>{@code
 uint8_t *srcRow = srcData;
 uint16_t *destRow = destData;
 
 //Load 2 12-bit values
 t0 = (srcRow[0] << 16) | (srcRow[1] << 8) | srcRow [2];
 srcRow += 3;
 
 //Separate each of 12-bit
 t1 = t0 & 0xfff;
 t0 >>= 12;
 
 //Convert and store
 destRow[0] = (t0 * 65535U + (t0 << 4) + 2055U) >> 12;
 destRow[1] = (t1 * 65535U + (t1 << 4) + 2055U) >> 12;
 destRow += 2;
 }</pre>
 
 @param src
 A pointer to a vImage_Buffer that references 12-bit source pixels
 
 @param dest
 A pointer to a vImage_Buffer that references 16-bit destination pixels.
 
 @param flags
 \p kvImageDoNotTile    Turns off internal multithreading.
 
 @return \p kvImageNoError                      Success!
 @return \p kvImageRoiLargerThanInputBuffer     The source buffer must have a height and
 width at least as large as the destination buffer.
 @return \p kvImageNullPointerArgument          src, dest or table pointer is NULL.
 
 \note This routine will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_12UTo16U( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_16UTo12U
 
 \abstract Converts 16U to 12U
 
 \discussion For each floating point pixel in src, do the following:
 <pre>{@code
 uint16_t *srcRow = srcData;
 uint8_t *destRow = destData;
 
 // 2 16-bit in 4-bytes
 t0 = srcRow[0];
 t1 = srcRow[1];
 srcRow += 2;
 
 t0 = (t0 * 4095 + 32767 + (t0 >> 4)) >> 16;
 t1 = (t1 * 4095 + 32767 + (t1 >> 4)) >> 16;
 
 t0 <<= 12;
 t0 |= t1;
 
 // 2 12-bit in 3-bytes
 destRow[0] = t0 >> 16;
 destRow[1] = t0 >> 8;
 destRow[2] = t0;
 destRow += 3;
 }</pre>
 
 @param src
 A pointer to a vImage_Buffer that references 12-bit source pixels
 
 @param dest
 A pointer to a vImage_Buffer that references 16-bit destination pixels.
 
 @param flags
 \p kvImageDoNotTile         Turns off internal multithreading.
 
 @return \p kvImageNoError                      Success!
 @return \p kvImageRoiLargerThanInputBuffer     The source buffer must have a height and
 width at least as large as the destination buffer.
 @return \p kvImageNullPointerArgument          src, dest or table pointer is NULL.
 
 \note This routine will not work in place.
 
 */
public static native @Cast("vImage_Error") long vImageConvert_16UTo12U( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 \function vImageTableLookUp_ARGB8888
 
 \abstract Transforms an ARGB8888 image by substituting pixel values with pixel values provided by four lookup tables.
 
 \discussion For each pixel in src, do the following:
 Use a lookup table to remap 0...255 values in the source image to a different set of 0...255 values in the destination.
 A different lookup table is used for each channel in the ARGB image.
 
 This function can work in place provided the following are true:
 If src overlaps with dest, src->data must be equal to dest->data and src->rowBytes >= dest->rowBytes
 If an overlapping src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 \note This function may be used to do table lookups on other 4 channel 8-bit/channel formats (e.g. RGBA8888) by adjusting the order of the tables
 passed into the function accordingly.
 
 \note Performance Advisory:   For 8-bit monochrome -> ARGB8888  or 8-bit indexed -> ARGB8888 conversions,
 it is likely significantly faster to use vImageLookupTable_Planar8toPlanarF. Use the desired
 ARGB8888 (32 bits/pixel) pixels in place of the planar 32-bit floats in the lookup table.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param alphaTable
 A table to remap A values.
 
 @param redTable
 A table to remap R values.
 
 @param greenTable
 A table to remap G values.
 
 @param blueTable
 A table to remap B values.
 
 @param flags
 \p kvImageNoFlags                     Default operation
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageTableLookUp_ARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const Pixel_8*") BytePointer alphaTable, @Cast("const Pixel_8*") BytePointer redTable, @Cast("const Pixel_8*") BytePointer greenTable, @Cast("const Pixel_8*") BytePointer blueTable, @Cast("vImage_Flags") long flags);

/**
 \function vImageTableLookUp_ARGB8888
 
 \abstract Transforms an Planar8 image by substituting pixel values with pixel values provided by four lookup tables.
 
 \discussion For each pixel in src, do the following:
 Use a lookup table to remap 0...255 values in the source image to a different set of 0...255 values in the destination.
 
 This function can work in place provided the following are true:
 If src overlaps with dest, src->data must be equal to dest->data and src->rowBytes >= dest->rowBytes
 If an overlapping src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param table
 A table to remap the values in src.
 
 @param flags
 \p kvImageNoFlags                     Default operation
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageTableLookUp_Planar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const Pixel_8*") BytePointer table, @Cast("vImage_Flags") long flags);

/*
 Additional Lookup table functions are available in Transform.h :
 vImageLookupTable_Planar8toPlanar16,
 vImageLookupTable_Planar8toPlanarF,
 vImageLookupTable_8to64U,
 vImageLookupTable_PlanarFtoPlanar8
 */

/**
 \function vImageOverwriteChannels_ARGB8888
 
 \abstract Overwrites one or more planes of an ARGB8888 image buffer with the provided planar buffer.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 // Set up a uint32_t mask - 0xFF where the pixels should be conserved
 // Load and splat the src pixel
 uint32_t srcPixel = newSrc->data[x];
 uint32_t result = origSrc->data[x];
 srcPixel |= srcPixel << 8;
 srcPixel |= srcPixel << 16;
 
 // Select for the channels based on the mask
 srcPixel &= ~mask;
 result &= mask;
 
 // combine the two and store
 dest->data[x] = srcPixel | result;
 }</pre>
 
 origSrc and dest may overlap, if they share the same origin.
 origSrc should be at least as big as dest
 
 origSrc and dest can be the same buffer
 This function may be used with other channel orderings (e.g. origSrc -> a RGBA8888 buffer) by adjusting the order of the bits in the copyMask.
 
 This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data.
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags.
 
 @param newSrc
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing planar source pixel that we will overwrite with.
 
 @param origSrc
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel that we will overwrite into.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannels_ARGB8888(    @Const vImage_Buffer newSrc,
                                                        @Const vImage_Buffer origSrc,
                                                        @Const vImage_Buffer dest,
                                                        @Cast("uint8_t") byte copyMask,
                                                        @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannels_ARGBFFFF
 
 \abstract Overwrites one or more planes of an ARGBFFFF image buffer with the provided planar buffer.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 // Set up a uint32_t mask for which channels to use -1U where the pixels should not be conserved
 uint32_t    a = origSrc->data[0] & maskA;
 uint32_t    r = origSrc->data[1] & maskR;
 uint32_t    g = origSrc->data[2] & maskG;
 uint32_t    b = origSrc->data[3] & maskB;
 uint32_t    colorA = newSrc->data[0];
 uint32_t    colorR = colorA & ~maskR;
 uint32_t    colorG = colorA & ~maskG;
 uint32_t    colorB = colorA & ~maskB;
 colorA &= ~maskA;
 
 dest->data[0] = colorA | a;
 dest->data[1] = colorR | r;
 dest->data[2] = colorG | g;
 dest->data[3] = colorB | b;
 }</pre>
 
 origSrc and dest may overlap, if they share the same origin.
 origSrc should be at least as big as dest
 
 origSrc and dest can be the same buffer
 This function may be used with other channel orderings (e.g. origSrc -> a RGBAFFFF buffer) by adjusting the order of the bits in the copyMask.
 
 This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data.
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags.
 
 @param newSrc
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing planar source pixel that we will overwrite with.
 
 @param origSrc
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel that we will overwrite into.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannels_ARGBFFFF(    @Const vImage_Buffer newSrc,
                                                        @Const vImage_Buffer origSrc,
                                                        @Const vImage_Buffer dest,
                                                        @Cast("uint8_t") byte copyMask,
                                                        @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannelsWithScalar_Planar8
 
 \abstract Fill the dest buffer with the scalar value.
 
 @param scalar
 A scalar value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithScalar_Planar8(    @Cast("uint8_t") byte scalar,
                                                                 @Const vImage_Buffer dest,
                                                                 @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannelsWithScalar_PlanarF
 
 \abstract Fill the dest buffer with the scalar value.
 
 @param scalar
 A scalar value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithScalar_PlanarF( @Cast("float") float scalar,
                                                                 @Const vImage_Buffer dest,
                                                                 @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannelsWithScalar_Planar16S
 
 \abstract Fill the dest buffer with the scalar value.
 
 @param scalar
 A scalar value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithScalar_Planar16S(    @Cast("Pixel_16S") short scalar,
                                                                   @Const vImage_Buffer dest,
                                                                   @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannelsWithScalar_Planar16U
 
 \abstract Fill the dest buffer with the scalar value.
 
 @param scalar
 A scalar value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithScalar_Planar16U(    @Cast("Pixel_16U") short scalar,
                                                                   @Const vImage_Buffer dest,
                                                                   @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannelsWithScalar_Planar16F
 
 \abstract Fill the dest buffer with the scalar value.
 
 @param scalar
 A scalar value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithScalar_Planar16F(    @Cast("Pixel_16F") short scalar,
                                                                   @Const vImage_Buffer dest,
                                                                   @Cast("vImage_Flags") long flags );


/**
 \function vImageExtractChannel_ARGB8888
 
 \abstract Extract one channel from a 4-channel interleaved 8-bit per component buffer
 
 \discussion  This is the opposite operation from vImageOverwriteChannels_ARGB8888. It reads one component
 from the four channel 8-bit per component buffer and writes it into a Planar8 buffer.
 
 For each pixel i in src:
 <pre>{@code
 Pixel_8888 *src_pixel;
 Pixel_8 *dest_pixel;
 
 dest_pixel[i] = src_pixel[i][channelIndex];
 }</pre>
 
 @param src
 A valid pointer to a vImage_Buffer struct which describes a 8-bit per component, four channel buffer.
 It does not have to be ARGB8888. It can be BGRA, RGBA, CMYK, etc.
 
 @param dest
 A valid pointer to a vImage_Buffer struct which describes a 8-bit per component, one channel buffer.
 The buffer pointed to by dest should be allocated by you. It will be overwritten with one of the
 channels.  This function does work in place, so long as the rowBytes is the same for src and dest
 images and the start address also matches.
 
 @param channelIndex
 The index of the channel to extract. For alpha in a ARGB image, this is 0.  For alpha in a BGRA image, this is 3.
 
 @param flags
 \p kvImageDoNotTile
 \p kvImageGetTempBufferSize
 \p kvImagePrintDiagnosticsToConsole
 
 @return \p kvImageNoError                      Success. However, see also 0 below, if the kvImageGetTempBufferSize flag is passed.
 @return \p 0                                   If the kvImageGetTempBufferSize flag is passed, this function returns 0 and does no work.
 @return \p kvImageRoiLargerThanInputBuffer     The destination height or width is larger than the src height or width, respectively.
 @return \p kvImageUnknownFlagsBit              A flag was used which was not among the approved set of flags. See flags param description above.
 @return \p kvImageInvalidParameter             channelIndex must be in the range [0,3]
 */
public static native @Cast("vImage_Error") long vImageExtractChannel_ARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, long channelIndex, @Cast("vImage_Flags") long flags );

/**
 \function vImageExtractChannel_ARGB16U
 
 \abstract Extract one channel from a 4-channel interleaved 16-bit per component buffer.
 
 \discussion  vImageExtractChannel_ARGB16U reads one component from the four channel 16-bit per component buffer
 and writes it into a Planar16U buffer.  Since this just copies data around, the data may be any
 16-bit per component data type, including signed 16 bit integers and half-precision floating point,
 of any endianness. Likewise, the channel order does not need to be ARGB. RGBA, BGRA, CMYK, etc. all work.
 
 For each pixel i in src:
 <pre>{@code
 Pixel_ARGB_16U *src_pixel;
 Pixel_16U *dest_pixel;
 
 dest_pixel[i] = src_pixel[i][channelIndex];
 }</pre>
 
 @param src
 A valid pointer to a vImage_Buffer struct which describes a 16-bit per component, four channel buffer.
 It does not have to be ARGB16U. It can be BGRA, RGBA, CMYK, etc. The data can be any 16-bit per component
 type such as int16_t or half-precision floating-point. Data must be at least 2-byte aligned.
 
 @param dest
 A valid pointer to a vImage_Buffer struct which describes a 16-bit per component, one channel buffer.
 The buffer pointed to by dest should be allocated by you. It will be overwritten with one of the
 channels.  This function does work in place, so long as the rowBytes is the same for src and dest
 images and the start address also matches. The data returned will be in the same format (uint16_t,
 int16_t, half-float, etc.) as the data provided in the src format, except that only a single channel
 is present. Data must be at least 2-byte aligned.
 
 @param channelIndex
 The index of the channel to extract. For alpha in a ARGB image, this is 0.  For alpha in a BGRA image, this is 3.
 
 @param flags
 The following flags are allowed:  kvImageDoNotTile, kvImageGetTempBufferSize, kvImageNoFlags, kvImagePrintDiagnosticsToConsole
 
 @return kvImageNoError                     Success. However, see also 0 below, if the kvImageGetTempBufferSize flag is passed.
 @return 0                                  If the kvImageGetTempBufferSize flag is passed, this function returns 0 and does no work.
 @return kvImageRoiLargerThanInputBuffer    The destination height or width is larger than the src height or width, respectively.
 @return kvImageUnknownFlagsBit             A flag was used which was not among the approved set of flags. See flags param description above.
 @return kvImageInvalidParameter            channelIndex must be in the range [0,3]
 */
public static native @Cast("vImage_Error") long vImageExtractChannel_ARGB16U( @Const vImage_Buffer src, @Const vImage_Buffer dest, long channelIndex, @Cast("vImage_Flags") long flags );

/**
 \function vImageExtractChannel_ARGBFFFF
 
 \abstract Extract one channel from a 4-channel interleaved 32-bit per component buffer
 
 \discussion  This is the opposite operation from vImageOverwriteChannels_ARGBFFFF. It reads one component
 from the four channel 32-bit per component buffer and writes it into a PlanarF buffer. NaNs and
 and sNaNs are not modified. Sign of zero shall be preserved.
 
 For each pixel i in src:
 <pre>{@code
 Pixel_FFFF *src_pixel;
 Pixel_F *dest_pixel;
 
 dest_pixel[i] = src_pixel[i][channelIndex];
 }</pre>
 
 @param src
 A valid pointer to a vImage_Buffer struct which describes a 32-bit per component, four channel buffer.
 It does not have to be ARGBFFFF. It can be BGRA, RGBA, CMYK, etc. of any endianness. Data must be at
 least 4-byte aligned.
 
 @param dest
 A valid pointer to a vImage_Buffer struct which describes a 32-bit per component, one channel buffer.
 The buffer pointed to by dest should be allocated by you. It will be overwritten with one of the
 channels.  This function does work in place, so long as the rowBytes is the same for src and dest
 images and the start address also matches. Data must be at least 4 byte aligned.
 
 @param channelIndex
 The index of the channel to extract. For alpha in a ARGB image, this is 0.  For alpha in a BGRA image, this is 3.
 
 @param flags
 The following flags are allowed:  kvImageDoNotTile, kvImageGetTempBufferSize, kvImageNoFlags, kvImagePrintDiagnosticsToConsole
 
 @return kvImageNoError                     Success. However, see also 0 below, if the kvImageGetTempBufferSize flag is passed.
 @return 0                                  If the kvImageGetTempBufferSize flag is passed, this function returns 0 and does no work.
 @return kvImageRoiLargerThanInputBuffer    The destination height or width is larger than the src height or width, respectively.
 @return kvImageUnknownFlagsBit             A flag was used which was not among the approved set of flags. See flags param description above.
 @return kvImageInvalidParameter            channelIndex must be in the range [0,3]
 */
public static native @Cast("vImage_Error") long vImageExtractChannel_ARGBFFFF( @Const vImage_Buffer src, @Const vImage_Buffer dest, long channelIndex, @Cast("vImage_Flags") long flags );


/*
 * Fill a buffer with a color. Use vImageOverwriteChannelsWithScalar_* to fill planar buffers with a color.
 * These functions work for any 2-channel, 4-channel 8-bit/channel, 16-bit/channel or floating-point format, such as RGBAFFFF or BGRA8888.
 */

/**
 \function vImageBufferFill_ARGB8888
 
 \abstract Fill the dest buffer with the pixel value.
 
 @param color
 A pixel value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                    Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageBufferFill_ARGB8888( @Const vImage_Buffer dest, @Cast("const uint8_t*") BytePointer color, @Cast("vImage_Flags") long flags );

/**
 \function vImageBufferFill_ARGB16U
 
 \abstract Fill the dest buffer with the pixel value.
 
 @param color
 A pixel value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageBufferFill_ARGB16U( @Const vImage_Buffer dest, @Cast("const uint16_t*") ShortPointer color, @Cast("vImage_Flags") long flags );

/**
 \function vImageBufferFill_ARGB16S
 
 \abstract Fill the dest buffer with the pixel value.
 
 @param color
 A pixel value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                    Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageBufferFill_ARGB16S( @Const vImage_Buffer dest, @Cast("const int16_t*") ShortPointer color, @Cast("vImage_Flags") long flags );

/**
 \function vImageBufferFill_ARGBFFFF
 
 \abstract Fill the dest buffer with the pixel value.
 
 @param color
 A pixel value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                    Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageBufferFill_ARGBFFFF( @Const vImage_Buffer dest, @Cast("const float*") FloatPointer color, @Cast("vImage_Flags") long flags );

/**
 \function vImageBufferFill_ARGB16F
 
 \abstract Fill the dest buffer with the pixel value.
 
 @param color
 A pixel value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageBufferFill_ARGB16F( @Const vImage_Buffer dest, @Cast("const uint16_t*") ShortPointer color, @Cast("vImage_Flags") long flags );

/**
 \function vImageBufferFill_CbCr8
 
 \abstract Fill the dest buffer with the pixel value.
 
 @param color
 A pixel value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageBufferFill_CbCr8(
                       @Const vImage_Buffer dest,
                       @Cast("const uint8_t*") BytePointer color,
                       @Cast("vImage_Flags") long flags );

/**
 \function vImageBufferFill_CbCr16U
 
 \abstract Fill the dest buffer with the pixel value.
 
 @param color
 A pixel value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageBufferFill_CbCr16U(
                         @Const vImage_Buffer dest,
                         @Cast("const uint16_t*") ShortPointer color,
                         @Cast("vImage_Flags") long flags );

/**
 \function vImageBufferFill_CbCr16S
 
 \abstract Fill the dest buffer with the pixel value.
 
 @param color
 A pixel value to fill the destination buffer.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageBufferFill_CbCr16S(
                         @Const vImage_Buffer dest,
                         @Cast("const int16_t*") ShortPointer color,
                         @Cast("vImage_Flags") long flags );


/**
 \function vImageOverwriteChannelsWithScalar_ARGB8888
 
 \abstract Overwrites the pixels of one or more planes of an ARGB8888 image buffer with the provided scalar value.
 
 \discussion Fill the color channels (as indicated by copyMask) with the scalar value.
 
 For each pixel in src:
 <pre>{@code
 Pixel_8888 srcPixel, destPixel;
 int mask;
 int i;
 
 mask = 0x8;
 for( i = 0; i < 4; i++ )
 {
 if( copyMask & mask )
 destPixel[i] = scalar;
 else
 destPixel[i] = srcPixel[i]
 
 mask = mask >> 1;
 }
 }</pre>
 
 Bits 0-27 of copyMask must be 0.
 This function can work in place provided the following are true:
 src->data must be equal to dest->data and src->rowBytes >= dest->rowBytes
 If overlapping src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 \note These functions may be used for images with other channel orderings such as RGBA8888 by adjusting the ordering of the bits in copyMask.
 
 @param scalar
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing scalar value that we will overwrite with.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel that we will overwrite into.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.  You should use this if you are doing your own threading / tiling.
 
 @return kvImageNoError                         Success
 @return kvImageInvalidParameter                When copyMask > 15 which is invalid.
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \seealso vImageOverwriteChannelsWithPixel_ARGB8888
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithScalar_ARGB8888(    @Cast("uint8_t") byte scalar,
                                                                  @Const vImage_Buffer src,
                                                                  @Const vImage_Buffer dest,
                                                                  @Cast("uint8_t") byte copyMask,
                                                                  @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannelsWithScalar_ARGBFFFF
 
 \abstract Overwrites the pixels of one or more planes of an ARGBFFFF image buffer with the provided scalar value.
 
 \discussion Fill the color channels (as indicated by copyMask) with the scalar value.
 
 For each pixel in src:
 <pre>{@code
 Pixel_FFFF srcPixel, destPixel;
 int mask;
 int i;
 
 mask = 0x8;
 for( i = 0; i < 4; i++ )
 {
 if( copyMask & mask )
 destPixel[i] = scalar;
 else
 destPixel[i] = srcPixel[i]
 
 mask = mask >> 1;
 }
 }</pre>
 
 Bits 0-27 of copyMask must be 0.
 This function can work in place provided the following are true:
 src->data must be equal to dest->data and src->rowBytes >= dest->rowBytes
 If overlapping src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 \note These functions may be used for images with other channel orderings such as RGBAFFFF by adjusting the ordering of the bits in copyMask.
 
 @param scalar
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing scalar value that we will overwrite with.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel that we will overwrite into.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.  You should use this if you are doing your own threading / tiling.
 
 @return kvImageNoError                         Success
 @return kvImageInvalidParameter                When copyMask > 15 which is invalid.
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \seealso vImageOverwriteChannelsWithPixel_ARGBFFFF
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithScalar_ARGBFFFF(    @Cast("float") float scalar,
                                                                  @Const vImage_Buffer src,
                                                                  @Const vImage_Buffer dest,
                                                                  @Cast("uint8_t") byte copyMask,
                                                                  @Cast("vImage_Flags") long flags );

/**
 \function vImagePermuteChannels_ARGB8888
 
 \abstract Reorder color channels within the buffer according to the permute map.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 Pixel_8888 srcPixel, result;
 for( int i = 0; i < 4; i++ )
 result[i] = srcPixel[ permuteMap[i] ];
 }</pre>
 
 The src buffer must be at least as large as the dest buffer in each dimension. (src.height >= dest.height && src.width >= dest.width)
 
 This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 This function may be used with any 4 channel 8-bit/channel format, such as RGBA8888, BGRA8888 or AYUV8888.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param permuteMap
 The map describing the permutation of the 4 color channels.
 Each value in the map must be 0,1,2, or 3.  A map of 0,1,2,3
 is a copy from src->dest while a map of 3,2,1,0 is permutes
 ARGB -> BGRA.  Providing a map value greater than 3 will
 result in the return of error kvImageInvalidParameter.
 
 @param flags
 \p kvImageNoFlags                     Default operation
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageInvalidParameter            When permuteMap > 3, which is invalid.
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGB8888(    @Const vImage_Buffer src,
                                                      @Const vImage_Buffer dest,
                                                      @Cast("const uint8_t*") BytePointer permuteMap,
                                                      @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGB8888(    @Const vImage_Buffer src,
                                                      @Const vImage_Buffer dest,
                                                      @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                      @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGB8888(    @Const vImage_Buffer src,
                                                      @Const vImage_Buffer dest,
                                                      @Cast("const uint8_t*") byte[] permuteMap,
                                                      @Cast("vImage_Flags") long flags );

/**
 \function vImagePermuteChannels_ARGB16U
 
 \abstract Reorder color channels within the buffer according to the permute map.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 Pixel_ARGB_16U srcPixel, result;
 for( int i = 0; i < 4; i++ )
 result[i] = srcPixel[ permuteMap[i] ];
 }</pre>
 
 The src buffer must be at least as large as the dest buffer in each dimension. (src.height >= dest.height && src.width >= dest.width)
 
 This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 This function may be used with any 4 channel 16-bit/channel format, such as RGBA16U, BGRA16U or AYUV16U.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param permuteMap
 The map describing the permutation of the 4 color channels.
 Each value in the map must be 0,1,2, or 3.  A map of 0,1,2,3
 is a copy from src->dest while a map of 3,2,1,0 is permutes
 ARGB -> BGRA.  Providing a map value greater than 3 will
 result in the return of error kvImageInvalidParameter.
 
 @param flags
 \p kvImageNoFlags                     Default operation
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageInvalidParameter            When permuteMap > 3, which is invalid.
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGB16U(     @Const vImage_Buffer src,
                                                     @Const vImage_Buffer dest,
                                                     @Cast("const uint8_t*") BytePointer permuteMap,
                                                     @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGB16U(     @Const vImage_Buffer src,
                                                     @Const vImage_Buffer dest,
                                                     @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                     @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGB16U(     @Const vImage_Buffer src,
                                                     @Const vImage_Buffer dest,
                                                     @Cast("const uint8_t*") byte[] permuteMap,
                                                     @Cast("vImage_Flags") long flags );


/**
 \function vImagePermuteChannels_ARGBFFFF
 
 \abstract Reorder color channels within the buffer according to the permute map.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 Pixel_FFFF srcPixel, result;
 for( int i = 0; i < 4; i++ )
 result[i] = srcPixel[ permuteMap[i] ];
 }</pre>
 
 The src buffer must be at least as large as the dest buffer in each dimension. (src.height >= dest.height && src.width >= dest.width)
 
 This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 This function may be used with any 4 channel 32-bit/channel format, such as 16S and 16F.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param permuteMap
 The map describing the permutation of the 4 color channels.
 Each value in the map must be 0,1,2, or 3.  A map of 0,1,2,3
 is a copy from src->dest while a map of 3,2,1,0 is permutes
 ARGB -> BGRA.  Providing a map value greater than 3 will
 result in the return of error kvImageInvalidParameter.
 
 @param flags
 \p kvImageNoFlags                     Default operation
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageInvalidParameter            When permuteMap > 3, which is invalid.
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGBFFFF(    @Const vImage_Buffer src,
                                                      @Const vImage_Buffer dest,
                                                      @Cast("const uint8_t*") BytePointer permuteMap,
                                                      @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGBFFFF(    @Const vImage_Buffer src,
                                                      @Const vImage_Buffer dest,
                                                      @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                      @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGBFFFF(    @Const vImage_Buffer src,
                                                      @Const vImage_Buffer dest,
                                                      @Cast("const uint8_t*") byte[] permuteMap,
                                                      @Cast("vImage_Flags") long flags );

/**
 \function vImagePermuteChannels_ARGB16F
 
 \abstract Reorder color channels within the buffer according to the permute map.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 Pixel_ARGB_16F srcPixel, result;
 for( int i = 0; i < 4; i++ )
 result[i] = srcPixel[ permuteMap[i] ];
 }</pre>
 
 The src buffer must be at least as large as the dest buffer in each dimension. (src.height >= dest.height && src.width >= dest.width)
 
 This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 This function may be used with any 4 channel 16-bit/channel format, such as RGBA16F, BGRA16F or AYUV16F.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param permuteMap
 The map describing the permutation of the 4 color channels.
 Each value in the map must be 0,1,2, or 3.  A map of 0,1,2,3
 is a copy from src->dest while a map of 3,2,1,0 is permutes
 ARGB -> BGRA.  Providing a map value greater than 3 will
 result in the return of error kvImageInvalidParameter.
 
 @param flags
 \p kvImageNoFlags                     Default operation
 \p kvImageDoNotTile                   Disable internal multithreading.
 
 @return kvImageNoError                     Success
 @return kvImageInvalidParameter            When permuteMap > 3, which is invalid.
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGB16F(@Const vImage_Buffer src,
                                                     @Const vImage_Buffer dest,
                                                     @Cast("const uint8_t*") BytePointer permuteMap,
                                                     @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGB16F(@Const vImage_Buffer src,
                                                     @Const vImage_Buffer dest,
                                                     @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                     @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannels_ARGB16F(@Const vImage_Buffer src,
                                                     @Const vImage_Buffer dest,
                                                     @Cast("const uint8_t*") byte[] permuteMap,
                                                     @Cast("vImage_Flags") long flags );

/**
 \function vImagePermuteChannelsWithMaskedInsert_ARGB8888
 
 \discussion This is in principle vImagePermuteChannels_ARGB8888, followed by vImageOverwriteChannelsWithScalar_ARGB8888.  The fused operation is
 provided because it allows you to set different channels to different values (a weakness in vImageOverwriteChannelsWithScalar_ARGB8888)
 and because neither the Permute or Overwrite functions alone saturate the vector ALU on most architectures, so we think we can get
 the extra work done in the compound operation for free.
 
 For each pixel in src, do the following:
 <pre>{@code
 Pixel_8888 srcPixel,  destPixel;
 uint8_t mask = 0x8;
 
 for( int i = 0; i < 4; i++ )
 {
 result[i] = srcPixel[ permuteMap[i] ];
 if( mask & copyMask )
 result[i] = backgroundColor[i];
 mask = mask >> 1;
 }
 }</pre>
 
 If you intend to just set the entire image to just the backgroundColor, we will detect this case and reroute to vImageBufferFill_ARGB8888.
 If it isn't obvious, this will of course work with other non-ARGB channel orderings. You'll need to adjust copyMask accordingly. The
 backgroundColor should be in the output format.
 
 This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest,
 buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param permuteMap
 The map describing the permutation of the 4 color channels.
 Each value in the map must be 0,1,2, or 3.  A map of 0,1,2,3
 is a copy from src->dest while a map of 3,2,1,0 is permutes
 ARGB -> BGRA.  Providing a map value greater than 3 will
 result in the return of error kvImageInvalidParameter.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param   flags
 \p kvImageNoFlags                  Default operation
 \p kvImageDoNotTile                Disable internal multithreading.
 \p kvImageGetTempBufferSize        Does no work and returns zero, as this function does not use a temp buffer.
 
 @return kvImageNoError                     Success
 @return kvImageInvalidParameter            When permuteMap > 3 which is invalid.
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImagePermuteChannelsWithMaskedInsert_ARGB8888(    @Const vImage_Buffer src,
                                                                      @Const vImage_Buffer dest,
                                                                      @Cast("const uint8_t*") BytePointer permuteMap,
                                                                      @Cast("uint8_t") byte copyMask,
                                                                      @Cast("const uint8_t*") BytePointer backgroundColor,
                                                                      @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannelsWithMaskedInsert_ARGB8888(    @Const vImage_Buffer src,
                                                                      @Const vImage_Buffer dest,
                                                                      @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                                      @Cast("uint8_t") byte copyMask,
                                                                      @Cast("const uint8_t*") BytePointer backgroundColor,
                                                                      @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannelsWithMaskedInsert_ARGB8888(    @Const vImage_Buffer src,
                                                                      @Const vImage_Buffer dest,
                                                                      @Cast("const uint8_t*") byte[] permuteMap,
                                                                      @Cast("uint8_t") byte copyMask,
                                                                      @Cast("const uint8_t*") BytePointer backgroundColor,
                                                                      @Cast("vImage_Flags") long flags );

/**
 \function vImagePermuteChannelsWithMaskedInsert_ARGB16U
 
 \discussion This is in principle vImagePermuteChannels_ARGB16U, followed by vImageOverwriteChannelsWithScalar_ARGB16U.  The fused operation is
 provided because it allows you to set different channels to different values (a weakness in vImageOverwriteChannelsWithScalar_ARGB16U)
 and because neither the Permute or Overwrite functions alone saturate the vector ALU on most architectures, so we think we can get
 the extra work done in the compound operation for free.
 
 For each pixel in src, do the following:
 <pre>{@code
 Pixel_ARGB_16U srcPixel,  destPixel;
 uint8_t mask = 0x8;
 
 for( int i = 0; i < 4; i++ )
 {
 result[i] = srcPixel[ permuteMap[i] ];
 if( mask & copyMask )
 result[i] = backgroundColor[i];
 mask = mask >> 1;
 }
 }</pre>
 
 If you intend to just set the entire image to just the backgroundColor, we will detect this case and reroute to vImageBufferFill_ARGB16U.
 If it isn't obvious, this will of course work with other non-ARGB channel orderings. You'll need to adjust copyMask accordingly. The
 backgroundColor should be in the output format.
 
 This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest,
 buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param permuteMap
 The map describing the permutation of the 4 color channels.
 Each value in the map must be 0,1,2, or 3.  A map of 0,1,2,3
 is a copy from src->dest while a map of 3,2,1,0 is permutes
 ARGB -> BGRA.  Providing a map value greater than 3 will
 result in the return of error kvImageInvalidParameter.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param   flags
 \p kvImageNoFlags                  Default operation
 \p kvImageDoNotTile                Disable internal multithreading.
 \p kvImageGetTempBufferSize        Does no work and returns zero, as this function does not use a temp buffer.
 
 @return kvImageNoError                     Success
 @return kvImageInvalidParameter            When permuteMap > 3 which is invalid.
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImagePermuteChannelsWithMaskedInsert_ARGB16U(@Const vImage_Buffer src,
                                                                     @Const vImage_Buffer dest,
                                                                     @Cast("const uint8_t*") BytePointer permuteMap,
                                                                     @Cast("uint8_t") byte copyMask,
                                                                     @Cast("const uint16_t*") ShortPointer backgroundColor,
                                                                     @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannelsWithMaskedInsert_ARGB16U(@Const vImage_Buffer src,
                                                                     @Const vImage_Buffer dest,
                                                                     @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                                     @Cast("uint8_t") byte copyMask,
                                                                     @Cast("const uint16_t*") ShortPointer backgroundColor,
                                                                     @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannelsWithMaskedInsert_ARGB16U(@Const vImage_Buffer src,
                                                                     @Const vImage_Buffer dest,
                                                                     @Cast("const uint8_t*") byte[] permuteMap,
                                                                     @Cast("uint8_t") byte copyMask,
                                                                     @Cast("const uint16_t*") ShortPointer backgroundColor,
                                                                     @Cast("vImage_Flags") long flags );

/**
 \function vImagePermuteChannelsWithMaskedInsert_ARGBFFFF
 
 \discussion This is in principle vImagePermuteChannels_ARGBFFFF, followed by vImageOverwriteChannelsWithScalar_ARGBFFFF.  The fused operation is
 provided because it allows you to set different channels to different values (a weakness in vImageOverwriteChannelsWithScalar_ARGBFFFF)
 and because neither the Permute or Overwrite functions alone saturate the vector ALU on most architectures, so we think we can get
 the extra work done in the compound operation for free.
 
 For each pixel in src, do the following:
 <pre>{@code
 Pixel_FFFF srcPixel,  destPixel;
 uint8_t mask = 0x8;
 
 for( int i = 0; i < 4; i++ )
 {
 result[i] = srcPixel[ permuteMap[i] ];
 if( mask & copyMask )
 result[i] = backgroundColor[i];
 mask = mask >> 1;
 }
 }</pre>
 
 If you intend to just set the entire image to just the backgroundColor, we will detect this case and reroute to vImageBufferFill_ARGBFFFF.
 If it isn't obvious, this will of course work with other non-ARGB channel orderings. You'll need to adjust copyMask accordingly. The
 backgroundColor should be in the output format.
 
 This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest,
 buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing the source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param permuteMap
 The map describing the permutation of the 4 color channels.
 Each value in the map must be 0,1,2, or 3.  A map of 0,1,2,3
 is a copy from src->dest while a map of 3,2,1,0 is permutes
 ARGB -> BGRA.  Providing a map value greater than 3 will
 result in the return of error kvImageInvalidParameter.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param   flags
 \p kvImageNoFlags                  Default operation
 \p kvImageDoNotTile                Disable internal multithreading.
 \p kvImageGetTempBufferSize        Does no work and returns zero, as this function does not use a temp buffer.
 
 @return kvImageNoError                     Success
 @return kvImageInvalidParameter            When permuteMap > 3 which is invalid.
 @return kvImageRoiLargerThanInputBuffer    The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImagePermuteChannelsWithMaskedInsert_ARGBFFFF(    @Const vImage_Buffer src,
                                                                      @Const vImage_Buffer dest,
                                                                      @Cast("const uint8_t*") BytePointer permuteMap,
                                                                      @Cast("uint8_t") byte copyMask,
                                                                      @Cast("const float*") FloatPointer backgroundColor,
                                                                      @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannelsWithMaskedInsert_ARGBFFFF(    @Const vImage_Buffer src,
                                                                      @Const vImage_Buffer dest,
                                                                      @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                                      @Cast("uint8_t") byte copyMask,
                                                                      @Cast("const float*") FloatPointer backgroundColor,
                                                                      @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImagePermuteChannelsWithMaskedInsert_ARGBFFFF(    @Const vImage_Buffer src,
                                                                      @Const vImage_Buffer dest,
                                                                      @Cast("const uint8_t*") byte[] permuteMap,
                                                                      @Cast("uint8_t") byte copyMask,
                                                                      @Cast("const float*") FloatPointer backgroundColor,
                                                                      @Cast("vImage_Flags") long flags );


/**
 \function vImageConvert_ARGB8888toPlanarF
 
 \abstract Convert a packed (interleaved) 4-channel 8-bit unsigned buffer to planar float buffers.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 float  alpha = (maxFloat[0] - minFloat[0]) * (float) src[0] / 255.0  + minFloat[0];
 float    red = (maxFloat[1] - minFloat[1]) * (float) src[1] / 255.0  + minFloat[1];
 float  green = (maxFloat[2] - minFloat[2]) * (float) src[2] / 255.0  + minFloat[2];
 float   blue = (maxFloat[3] - minFloat[3]) * (float) src[3] / 255.0  + minFloat[3];
 }</pre>
 
 \note This routine will not work in place.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param alpha
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing A destination pixels.
 
 @param red
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing R destination pixels.
 
 @param green
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing G destination pixels.
 
 @param blue
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing B destination pixels.
 
 @param maxFloat
 A maxFloat value in the above formula.
 
 @param minFloat
 A minFloat value in the above formula.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageBufferSizeMismatch              When the dimension of alpha / red / green / blue are not same.
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888toPlanarF(
                                                          @Const vImage_Buffer src,
                                                          @Const vImage_Buffer alpha,
                                                          @Const vImage_Buffer red,
                                                          @Const vImage_Buffer green,
                                                          @Const vImage_Buffer blue,
                                                          @Cast("const float*") FloatPointer maxFloat,
                                                          @Cast("const float*") FloatPointer minFloat,
                                                          @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_ARGBFFFFtoPlanar8
 
 \abstract Convert a packed (interleaved) 4-channel floating point buffer to planar 8-bit unsigned integer buffers.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 uint8_t alpha = ROUND_TO_INTEGER( CLAMP(0, 255.0f * ( src[0] - minFloat[0], 255 ) / (maxFloat[0] - minFloat[0]) ));
 uint8_t   red = ROUND_TO_INTEGER( CLAMP(0, 255.0f * ( src[1] - minFloat[1], 255 ) / (maxFloat[1] - minFloat[1]) ));
 uint8_t green = ROUND_TO_INTEGER( CLAMP(0, 255.0f * ( src[2] - minFloat[2], 255 ) / (maxFloat[2] - minFloat[2]) ));
 uint8_t  blue = ROUND_TO_INTEGER( CLAMP(0, 255.0f * ( src[3] - minFloat[3], 255 ) / (maxFloat[3] - minFloat[3]) ));
 }</pre>
 
 \note This routine will not work in place.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param alpha
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing A destination pixels.
 
 @param red
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing R destination pixels.
 
 @param green
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing G destination pixels.
 
 @param blue
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing B destination pixels.
 
 @param maxFloat
 A maxFloat value in the above formula.
 
 @param minFloat
 A minFloat value in the above formula.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageBufferSizeMismatch              When the dimension of alpha / red / green / blue are not same.
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGBFFFFtoPlanar8(
                                                          @Const vImage_Buffer src,
                                                          @Const vImage_Buffer alpha,
                                                          @Const vImage_Buffer red,
                                                          @Const vImage_Buffer green,
                                                          @Const vImage_Buffer blue,
                                                          @Cast("const float*") FloatPointer maxFloat,
                                                          @Cast("const float*") FloatPointer minFloat,
                                                          @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_ARGBFFFFtoRGBFFF
 
 \abstract Convert 4-channel ARGB buffer to a 3-channel RGB one, by removing the alpha (1st) channel.
 \note This routine will work in place.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGBFFFFtoRGBFFF(
                                                         @Const vImage_Buffer src,
                                                         @Const vImage_Buffer dest,
                                                         @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_RGBAFFFFtoRGBFFF
 
 \abstract Convert 4-channel RGBA buffer to a 3-channel RGB one, by removing the alpha (last) channel.
 \note This routine will work in place.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBAFFFFtoRGBFFF(
                                                         @Const vImage_Buffer src,
                                                         @Const vImage_Buffer dest,
                                                         @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_BGRAFFFFtoRGBFFF
 
 \abstract Convert 4-channel BGRA buffer to a 3-channel RGB one, by removing the alpha (last) channel and reordering the remaining..
 \note This routine will work in place.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing source pixels.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_BGRAFFFFtoRGBFFF(
                                                         @Const vImage_Buffer src,
                                                         @Const vImage_Buffer dest,
                                                         @Cast("vImage_Flags") long flags );



/**
 \function vImageConvert_RGBFFFtoARGBFFFF
 
 \abstract Convert/pack a float RGB buffer with a corresponding alpha channel buffer or an alpha factor into a ARGB buffer.
 
 \discussion
 a = a corresponding pixel from the alpha channel buffer, if it exists, or a fixed factor
 For each pixel (r,g,b) in src with alpha a, do the following:
 <pre>{@code
 if (premultiply!=0) dest = (a,r*a,g*a,b*a);
 else dest = (a,r,g,b);
 }</pre>
 
 @param rgbSrc
 A pointer to a vImage_Buffer that references the source RGB pixels.  Unchanged on exit.
 
 @param aSrc
 A pointer to a vImage_Buffer that references the source alpha channel. Unchanged on exit.
 
 @param alpha
 If aSrc is non-NULL, this parameter is ignored.
 If aSrc is NULL, the value is used for the alpha channel of every pixel.
 
 @param argbDest
 A pointer to a vImage_Buffer that references where to write the converted ARGB data.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                     Success!
 @return kvImageNullPointerArgument         rgbSrc or argbDest is NULL.
 @return kvImageUnknownFlagsBit             Unknown flag was passed to the function.
 @return kvImageRoiLargerThanInputBuffer    The source buffer must have a size (in both height and width)
 no less than the destination buffers.
 
 \note This routine will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBFFFtoARGBFFFF(
                               @Const vImage_Buffer arg0,
                               @Const vImage_Buffer arg1,
                               @Cast("float") float arg2,
                               @Const vImage_Buffer arg3,
                               @Cast("bool") boolean arg4,
                               @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_RGBFFFtoRGBAFFFF
 
 \abstract Convert/pack a float RGB buffer with a corresponding alpha channel buffer or an alpha factor into a RGBA buffer.
 
 \discussion
 a = a corresponding pixel from the alpha channel buffer, if it exists, or a fixed factor
 For each pixel (r,g,b) in src with alpha a, do the following:
 <pre>{@code
 if (premultiply!=0) dest = (r*a,g*a,b*a,a);
 else dest = (r,g,b,a);
 }</pre>
 
 @param rgbSrc
 A pointer to a vImage_Buffer that references the source RGB pixels.  Unchanged on exit.
 
 @param aSrc
 A pointer to a vImage_Buffer that references the source alpha channel. Unchanged on exit.
 
 @param alpha
 If aSrc is non-NULL, this parameter is ignored.
 If aSrc is NULL, the value is used for the alpha channel of every pixel.
 
 @param rgbaDest
 A pointer to a vImage_Buffer that references where to write the converted RGBA data.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                     Success!
 @return kvImageNullPointerArgument         rgbSrc or rgbaDest is NULL.
 @return kvImageUnknownFlagsBit             Unknown flag was passed to the function.
 @return kvImageRoiLargerThanInputBuffer    The source buffer must have a size (in both height and width)
 no less than the destination buffers.
 
 \note This routine will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBFFFtoRGBAFFFF(
                               @Const vImage_Buffer arg0,
                               @Const vImage_Buffer arg1,
                               @Cast("float") float arg2,
                               @Const vImage_Buffer arg3,
                               @Cast("bool") boolean arg4,
                               @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_RGBFFFtoBGRAFFFF
 
 \abstract Convert/pack a float RGB buffer with a corresponding alpha channel buffer or an alpha factor into a BGRA buffer.
 
 \discussion
 a = a corresponding pixel from the alpha channel buffer, if it exists, or a fixed factor
 For each pixel (r,g,b) in src with alpha a, do the following:
 <pre>{@code
 if (premultiply!=0) dest = (b*a,g*a,r*a,a);
 else dest = (b,g,r,a);
 }</pre>
 
 @param rgbSrc
 A pointer to a vImage_Buffer that references the source RGB pixels.  Unchanged on exit.
 
 @param aSrc
 A pointer to a vImage_Buffer that references the source alpha channel. Unchanged on exit.
 
 @param alpha
 If aSrc is non-NULL, this parameter is ignored.
 If aSrc is NULL, the value is used for the alpha channel of every pixel.
 
 @param bgraDest
 A pointer to a vImage_Buffer that references where to write the converted BGRA data.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                     Success!
 @return kvImageNullPointerArgument         rgbSrc or bgraDest is NULL.
 @return kvImageUnknownFlagsBit             Unknown flag was passed to the function.
 @return kvImageRoiLargerThanInputBuffer    The source buffer must have a size (in both height and width)
 no less than the destination buffers.
 
 \note This routine will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBFFFtoBGRAFFFF(
                               @Const vImage_Buffer arg0,
                               @Const vImage_Buffer arg1,
                               @Cast("float") float arg2,
                               @Const vImage_Buffer arg3,
                               @Cast("bool") boolean arg4,
                               @Cast("vImage_Flags") long flags );

// #define vImageConvert_BGRFFFtoBGRAFFFF( _bgrSrc, _aSrc, _alpha, _bgraDest, _premultiply, _flags )
// vImageConvert_RGBFFFtoRGBAFFFF((_bgrSrc), (_aSrc), (_alpha), (_bgraDest), (_premultiply), (_flags) )
// #define vImageConvert_BGRFFFtoRGBAFFFF( _bgrSrc, _aSrc, _alpha, _rgbaDest, _premultiply, _flags )
// vImageConvert_RGBFFFtoBGRAFFFF((_bgrSrc), (_aSrc), (_alpha), (_rgbaDest), (_premultiply), (_flags) )


/**
 \function vImageConvert_ARGB1555toPlanar8
 
 \abstract Convert from 16 bit/pixel ARGB1555 to 8-bit/channel Planar8 format.
 
 \discussion
 For each pixel x in src->data:
 <pre>{@code
 destA->data[x] =  1bitAlphaChannel * 255;
 destR->data[x] = (5bitRedChannel   * 255 + 15) / 31;
 destG->data[x] = (5bitGreenChannel * 255 + 15) / 31;
 destB->data[x] = (5bitBlueChannel  * 255 + 15) / 31;
 }</pre>
 
 \note This function will not work in place.
 
 @param src
 A pointer to a vImage_Buffer that references the ARGB source channels.
 
 @param destA
 A pointer to a vImage_Buffer that references the destination planar 8-bit alpha channel.
 
 @param destR
 A pointer to a vImage_Buffer that references the destination planar 8-bit R channel.
 
 @param destG
 A pointer to a vImage_Buffer that references the destination planar 8-bit G channel.
 
 @param destB
 A pointer to a vImage_Buffer that references the destination planar 8-bit B channel.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageBufferSizeMismatch              When the dimension of alpha / red / green / blue are not same.
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB1555toPlanar8( @Const vImage_Buffer src, @Const vImage_Buffer destA, @Const vImage_Buffer destR, @Const vImage_Buffer destG, @Const vImage_Buffer destB, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_ARGB1555toARGB8888
 
 \abstract Convert from 16 bit/pixel ARGB1555 to 32 bit/pixel ARGB8888 format.
 
 \discussion
 For each pixel x in src:
 <pre>{@code
 Pixel8 alpha =  1bitAlphaChannel * 255;
 Pixel8 red   = (5bitRedChannel   * 255 + 15) / 31;
 Pixel8 green = (5bitGreenChannel * 255 + 15) / 31;
 Pixel8 blue  = (5bitBlueChannel  * 255 + 15) / 31;
 dest->data[x] = {alpha, red, green, blue};
 }</pre>
 
 \note This function will not work in place.
 
 @param src
 A pointer to a vImage_Buffer that references the ARGB source channels.
 
 @param dest
 A pointer to a vImage_Buffer that references the destination ARGB channels.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB1555toARGB8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_Planar8toARGB1555
 
 \abstract Convert from 8-bit/channel Planar8 to 16 bit/pixel ARGB1555 format.
 
 \discussion
 For each pixel x:
 <pre>{@code
 uint32_t alpha = (srcA->data[x]      + 127) / 255;
 uint32_t red   = (srcR->data[x] * 31 + 127) / 255;
 uint32_t green = (srcG->data[x] * 31 + 127) / 255;
 uint32_t blue  = (srcB->data[x] * 31 + 127) / 255;
 dest->data[x] =  (alpha << 15) | (red << 10) | (green << 5) | blue;
 }</pre>
 
 \note This function will not work in place.
 
 @param srcA
 A pointer to a vImage_Buffer that references the 8-bit alpha source channel.
 
 @param srcR
 A pointer to a vImage_Buffer that references the 8-bit R source channel.
 
 @param srcG
 A pointer to a vImage_Buffer that references the 8-bit G source channel.
 
 @param srcB
 A pointer to a vImage_Buffer that references the 8-bit B source channel.
 
 @param dest
 A pointer to a vImage_Buffer that references the ARGB destination channels.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageBufferSizeMismatch              When the dimension of alpha / red / green / blue are not same.
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar8toARGB1555( @Const vImage_Buffer srcA, @Const vImage_Buffer srcR, @Const vImage_Buffer srcG, @Const vImage_Buffer srcB, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_ARGB8888toARGB1555
 
 \abstract Convert between 32 bit/pixel ARGB8888 to 16 bit/pixel ARGB1555 format.
 
 \discussion
 For each pixel x in src:
 <pre>{@code
 uint32_t alpha = (8bitAlphaChannel      + 127) / 255;
 uint32_t red   = (8bitRedChannel   * 31 + 127) / 255;
 uint32_t green = (8bitGreenChannel * 31 + 127) / 255;
 uint32_t blue  = (8bitBlueChannel  * 31 + 127) / 255;
 dest->data[x] =  (alpha << 15) | (red << 10) | (green << 5) | blue;
 }</pre>
 
 \note This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes.
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags.
 
 @param src
 A pointer to a vImage_Buffer that references the source channels.
 
 @param dest
 A pointer to a vImage_Buffer that references the destination channels.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888toARGB1555( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_RGBA5551toRGBA8888
 
 \abstract Convert from 16 bit/pixel RGBA5551 to 32 bit/pixel RGBA8888 format.
 
 \discussion
 For each pixel x in src:
 <pre>{@code
 Pixel8 red   = (5bitRedChannel   * 255 + 15) / 31;
 Pixel8 green = (5bitGreenChannel * 255 + 15) / 31;
 Pixel8 blue  = (5bitBlueChannel  * 255 + 15) / 31;
 Pixel8 alpha =  1bitAlphaChannel * 255;
 dest->data[x] = {red, green, blue, alpha};
 }</pre>
 
 \note This function will not work in place.
 
 @param src
 A pointer to a vImage_Buffer that references the RGBA source channels.
 
 @param dest
 A pointer to a vImage_Buffer that references the destination RGBA channels.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBA5551toRGBA8888( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImageConvert_BGRA5551toBGRA8888( _src, _dest, _flags)  vImageConvert_RGBA5551toRGBA8888( _src, _dest, _flags )

/**
 \function vImageConvert_RGBA8888toRGBA5551
 
 \abstract Convert between 32 bit/pixel RGBA8888 to 16 bit/pixel RGBA5551 format.
 
 \discussion
 For each pixel x in src:
 <pre>{@code
 uint32_t red   = (8bitRedChannel   * 31 + 127) / 255;
 uint32_t green = (8bitGreenChannel * 31 + 127) / 255;
 uint32_t blue  = (8bitBlueChannel  * 31 + 127) / 255;
 uint32_t alpha = (8bitAlphaChannel      + 127) / 255;
 dest->data[x] =  (red << 11) | (green << 6) | (blue << 1) | alpha;
 }</pre>
 
 \note This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes.
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags.
 
 @param src
 A pointer to a vImage_Buffer that references the source channels.
 
 @param dest
 A pointer to a vImage_Buffer that references the destination channels.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBA8888toRGBA5551( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImageConvert_BGRA8888toBGRA5551( _src, _dest, _flags)  vImageConvert_RGBA8888toRGBA5551( _src, _dest, _flags )

/**
 \function vImageConvert_ARGB8888toARGB1555_dithered
 
 \abstract Convert between 32 bit/pixel ARGB8888 to 16 bit/pixel ARGB1555 format with dithering.
 
 \discussion Similar to vImageConvert_ARGB8888toARGB1555, except the result is dithered instead of round to nearest.
 This method should provide more accurate (overall) color reproduction and less banding in low-frequency regions of the image.
 
 \note This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes.
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags.
 
 @param src
 A pointer to a vImage_Buffer that references the source channels.
 
 @param dest
 A pointer to a vImage_Buffer that references the destination channels.
 
 @param dither
 A dithering method which should be kvImageConvert_DitherOrdered or kvImageConvert_DitherOrderedReproducible.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 
 \seealso vImageConvert_ARGB8888toARGB1555
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888toARGB1555_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, int dither, @Cast("const vImage_Flags") long flags);

/**
 \function vImageConvert_RGBA8888toRGBA5551_dithered
 
 \abstract Convert between 32 bit/pixel RGBA8888 to 16 bit/pixel RGBA5551 format with dithering.
 
 \discussion Similar to vImageConvert_RGBA8888toRGBA5551, except the result is dithered instead of round to nearest.
 This method should provide more accurate (overall) color reproduction and less banding in low-frequency regions of the image.
 
 \note This function can work in place provided the following are true:
 For each buffer "buf" that overlaps with dest, buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes.
 If an overlapping buffer has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags.
 
 @param src
 A pointer to a vImage_Buffer that references the source channels.
 
 @param dest
 A pointer to a vImage_Buffer that references the destination channels.
 
 @param dither
 A dithering method which should be kvImageConvert_DitherOrdered or kvImageConvert_DitherOrderedReproducible.
 
 @param flags
 \p kvImageDoNotTile            Turns off internal multithreading.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBA8888toRGBA5551_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, int dither, @Cast("const vImage_Flags") long flags);
// #define      vImageConvert_BGRA8888toBGRA5551_dithered( _src, _dest, _tempBuffer, _dither, _flags)  vImageConvert_RGBA8888toRGBA5551_dithered( _src, _dest, _tempBuffer, _dither, _flags )

/*  Convert from 16 bit/pixel RGB565 to 32 bit/pixel ARGB8888 or RGBA8888 or
 BGRA8888 formats.  For each pixel:
 
 Pixel8 alpha = alpha;
 Pixel8 red   = (5bitRedChannel   * 255 + 15) / 31;
 Pixel8 green = (6bitGreenChannel * 255 + 31) / 63;
 Pixel8 blue  = (5bitBlueChannel  * 255 + 15) / 31;
 
 The following flags are allowed:
 kvImageDoNotTile            Disables internal threading.  You may want
 to use this if you have your own threading
 scheme and need to avoid interference.
 
 kvImageGetTempBufferSize    Does no work and returns zero, as this
 function does not use a temp buffer.
 
 Return values:
 kvImageNoError              Success
 kvImageUnknownFlagsBit      No work was done because an unknown bit was
 set in the flags parameter.
 kvImageBufferSizeMismatch   No work was done because the source
 image isn't large enough to cover the
 destination image.
 
 
 These functions do not operate in place.
 */

public static native @Cast("vImage_Error") long vImageConvert_RGB565toARGB8888(@Cast("uint8_t") byte alpha, @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGB565toRGBA8888(@Cast("uint8_t") byte alpha, @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGB565toBGRA8888(@Cast("uint8_t") byte alpha, @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGB565toRGB888( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/*  Convert from 32 bit/pixel ARGB8888 or RGBA8888 or BGRA8888 formats
 to 16 bit/pixel RGB565. for each pixel:
 
 uint32_t red   = (8bitRedChannel   * 31 + 127) / 255;
 uint32_t green = (8bitGreenChannel * 63 + 127) / 255;
 uint32_t blue  = (8bitBlueChannel  * 31 + 127) / 255;
 uint16_t RGB565pixel =  (red << 11) | (green << 5) | blue;
 
 The following flags are allowed:
 kvImageDoNotTile            Disables internal threading.  You may want
 to use this if you have your own threading
 scheme and need to avoid interference.
 
 kvImageGetTempBufferSize    Does no work and returns zero, as this
 function does not use a temp buffer.
 
 Return values:
 kvImageNoError                     Success
 kvImageUnknownFlagsBit             No work was done because an unknown bit was
 set in the flags parameter.
 kvImageRoiLargerThanInputBuffer    No work was done because the source
 image isn't large enough to cover the
 destination image.
 
 These functions operate in place, provided that src->data == dest->data,
 src->rowBytes >= dest->rowBytes, and the kvImageDoNotTile flag is used
 if src->rowBytes > dest->rowBytes.
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888toRGB565(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGBA8888toRGB565(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_BGRA8888toRGB565(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);

/*
 vImageConvert_RGB888toRGB565_dithered
 vImageConvert_ARGB8888toRGB565_dithered
 vImageConvert_RGBA8888toRGB565_dithered
 vImageConvert_BGRA8888toRGB565_dithered
 
 @param dither     A dithering method which should be kvImageConvert_DitherOrdered or kvImageConvert_DitherOrderedReproducible.
 
 Convert from RGB888 or ARGB8888 or RGBA8888 or BGRA8888 formats
 to 16 bit/pixel RGB565 with dithering. For each pixel:
 
 uint32_t red   = (8bitRedChannel   * (31 << 8) + 127) / 255;
 uint32_t green = (8bitGreenChannel * (63 << 8) + 127) / 255;
 uint32_t blue  = (8bitBlueChannel  * (31 << 8) + 127) / 255;
 red   += dither_noise + (1 << 7);
 green += dither_noise + (1 << 7);
 blue  += dither_noise + (1 << 7);
 red    = red >> 8;
 green  = green >> 8;
 blue   = blue >> 8;
 uint16_t RGB565pixel =  (red << 11) | (green << 5) | blue;
 
 The following flags are allowed:
 kvImageDoNotTile            Disables internal threading.  You may want
 to use this if you have your own threading
 scheme and need to avoid interference.
 
 kvImageGetTempBufferSize    Does no work and returns zero, as this
 function does not use a temp buffer.
 
 Return values:
 kvImageNoError                     Success
 kvImageUnknownFlagsBit             No work was done because an unknown bit was
 set in the flags parameter.
 kvImageRoiLargerThanInputBuffer    No work was done because the source
 image isn't large enough to cover the
 destination image.
 
 These functions operate in place, provided that src->data == dest->data,
 src->rowBytes >= dest->rowBytes, and the kvImageDoNotTile flag is used
 if src->rowBytes > dest->rowBytes.
 */

public static native @Cast("vImage_Error") long vImageConvert_RGB888toRGB565_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, int dither, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888toRGB565_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, int dither, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGBA8888toRGB565_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, int dither, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_BGRA8888toRGB565_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, int dither, @Cast("const vImage_Flags") long flags);

/*  Convert between 16 bit/pixel RGB565 and Planar8 formats.  For the forward
 conversion, for each pixel:
 
 Pixel8 red   = (5bitRedChannel   * 255 + 15) / 31;
 Pixel8 green = (6bitGreenChannel * 255 + 31) / 63;
 Pixel8 blue  = (5bitBlueChannel  * 255 + 15) / 31;
 
 For the reverse conversion, for each pixel:
 
 uint32_t red   = (8bitRedChannel   * 31 + 127) / 255;
 uint32_t green = (8bitGreenChannel * 63 + 127) / 255;
 uint32_t blue  = (8bitBlueChannel  * 31 + 127) / 255;
 uint16_t RGB565pixel =  (red << 11) | (green << 5) | blue;
 
 The following flags are allowed:
 kvImageDoNotTile            Disables internal threading.  You may want
 to use this if you have your own threading
 scheme and need to avoid interference.
 
 kvImageGetTempBufferSize    Does no work and returns zero, as this
 function does not use a temp buffer.
 
 Return values:
 kvImageNoError                     Success
 kvImageUnknownFlagsBit             No work was done because an unknown bit was
 set in the flags parameter.
 kvImageRoiLargerThanInputBuffer    No work was done because the source
 image isn't large enough to cover the
 destination image.
 
 These functions do not operate in place.
 */

public static native @Cast("vImage_Error") long vImageConvert_RGB565toPlanar8(@Const vImage_Buffer src, @Const vImage_Buffer destR, @Const vImage_Buffer destG, @Const vImage_Buffer destB, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Planar8toRGB565(@Const vImage_Buffer srcR, @Const vImage_Buffer srcG, @Const vImage_Buffer srcB, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_RGBA5551toRGB565
 \abstract Convert from RGBA5551 to RGB565 image format
 \discussion  Convert (with loss of alpha) from RGBA5551 to RGB565 format.
 If you need something fancier done with alpha first, such as unpremultiplication or flattening, convert to 8 bit per channel first.
 Both RGB565 and RGBA5551 are defined by vImage to be host-endian formats. On Intel and ARM and other little endian systems, these are
 little endian uint16_t's in memory. On a big endian system, these are big endian uint16_t's.
 
 @param src           A pointer to a vImage_Buffer struct which describes a memory region full of RGBA5551 pixels
 
 @param dest          A pointer to a vImage_Buffer struct which describes a preallocated memory region to be overwritten by RGB565 pixels
 
 @param flags           The following flags are understood by this function:
 
 <pre>
 \textblock
 kvImageNoFlags                      Default operation.
 
 kvImageDoNotTile                    Turn internal multithreading off. This may be helpful in cases where you already have
 many such operations going concurrently, and in cases where it is desirable to keep
 CPU utilization to a single core.
 
 kvImageGetTempBufferSize            Returns 0.  Reads and writes no pixels.
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                         Success
 
 kvImageRoiLargerThanInputBuffer        dest->height > src->height OR dest->width > src->width.  There are not enough pixels to fill the destination buffer.
 \/textblock
 </pre>
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBA5551toRGB565( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_ARGB1555toRGB565
 \abstract Convert from ARGB1555 to RGB565 image format
 \discussion  Convert (with loss of alpha) from ARGB1555 to RGB565 format.
 If you need something fancier done with alpha first, such as unpremultiplication or flattening, convert to 8 bit per channel first.
 Both RGB565 and ARGB1555 are defined by vImage to be host-endian formats. On Intel and ARM and other little endian systems, these are
 little endian uint16_t's in memory. On a big endian system, these are big endian uint16_t's.
 
 @param src           A pointer to a vImage_Buffer struct which describes a memory region full of ARGB1555 pixels
 
 @param dest          A pointer to a vImage_Buffer struct which describes a preallocated memory region to be overwritten by RGB565 pixels
 
 @param flags           The following flags are understood by this function:
 
 <pre>
 \textblock
 kvImageNoFlags                      Default operation.
 
 kvImageDoNotTile                    Turn internal multithreading off. This may be helpful in cases where you already have
 many such operations going concurrently, and in cases where it is desirable to keep
 CPU utilization to a single core.
 
 kvImageGetTempBufferSize            Returns 0.  Reads and writes no pixels.
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                         Success
 
 kvImageRoiLargerThanInputBuffer        dest->height > src->height OR dest->width > src->width.  There are not enough pixels to fill the destination buffer.
 \/textblock
 </pre>
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB1555toRGB565( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_RGB565toRGBA5551
 \abstract Convert from RGB565 to RGBA5551 image format
 \discussion  Convert from RGB565 to RGBA5551 format.  The new alpha is set to 1.
 Both RGB565 and RGBA5551 are defined by vImage to be host-endian formats. On Intel and ARM and other little endian systems, these are
 little endian uint16_t's in memory. On a big endian system, these are big endian uint16_t's.
 
 @param src           A pointer to a vImage_Buffer struct which describes a memory region full of RGB565 pixels
 
 @param dest          A pointer to a vImage_Buffer struct which describes a preallocated memory region to be overwritten by RGBA5551 pixels
 
 @param dither        A dithering method for the green channel.   Options:
 
 kvImageConvert_DitherNone - apply no dithering; input values
 are rounded to the nearest value representable in the
 destination format.
 kvImageConvert_DitherOrdered - pre-computed blue noise is
 added to the image before rounding to the values in
 the destination format.  The offset into this blue
 noise is randomized per-call to avoid visible artifacts
 if you do your own tiling or call the function on
 sequential frames of video.
 kvImageConvert_DitherOrderedReproducible - pre-computed
 blue noise is added to the image before rounding to the
 values in the destination format.  The offset into the
 blue noise is the same for every call to allow users
 to get reproducible results.
 
 The ordered dither methods may be further influenced by shaping the
 distribution of the noise using the gaussian and uniform options below.
 These options are OR-ed with kvImageConvert_DitherOrdered / kvImageCon-
 vert_DitherOrderedReproducible:
 
 kvImageConvert_OrderedGaussianBlue - when using an ordered dither
 pattern, distribute the noise according to a gaussian
 distribution. This generally gives more pleasing images --
 less noisy and perhaps a little more saturated -- but color
 fidelity can suffer. Its effect is between kvImageConvert_DitherNone
 and kvImageConvert_DitherOrdered | kvImageConvert_DitherUniform.
 This is the default for kvImageConvert_DitherOrdered and
 kvImageConvert_DitherOrderedReproducible.
 
 kvImageConvert_OrderedUniformBlue - when using an ordered dither
 pattern, distribute the noise uniformly. This generally gives
 best color fidelity, but the resulting image is noisier and more
 obviously dithered. This is usually the best choice when low
 bitdepth content is drawn next to high bitdepth content and in other
 circumstances where subtle changes to color arising from the conversion
 could be easily noticed. It may be a poor choice when the image
 is likely to be enlarged -- this would cause the noise to become
 more evident-- and for very flat / synthetic content with little
 inherent noise. The enlargement problem may be avoided by enlarging
 first at high bitdepth, then convert to lower bitdepth.
 
 To clarify: "Blue" noise is not blue, nor does it operate solely on the blue
 color channel. Blue noise is monochrome noise that is added to all color
 channels equally. The name arises from blue light, which has a higher frequency
 than other colors of visible light. Thus, blue noise is noise which is
 weighted heavily towards high frequencies. Low frequency noise tends to have
 visible shapes in it that would become apparent in an image if it was added in,
 so it is excluded from the dither pattern.
 
 @param flags           The following flags are understood by this function:
 
 <pre>
 \textblock
 kvImageNoFlags                      Default operation.
 
 kvImageDoNotTile                    Turn internal multithreading off. This may be helpful in cases where you already have
 many such operations going concurrently, and in cases where it is desirable to keep
 CPU utilization to a single core.
 
 kvImageGetTempBufferSize            Returns 0.  Reads and writes no pixels.
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                          Success
 
 kvImageRoiLargerThanInputBuffer         dest->height > src->height OR dest->width > src->width.  There are not enough pixels to fill the destination buffer.
 
 kvImageInvalidParameter                 Invalid / unknown dither value
 \/textblock
 </pre>
 */
public static native @Cast("vImage_Error") long vImageConvert_RGB565toRGBA5551( @Const vImage_Buffer src, @Const vImage_Buffer dest, int dither, @Cast("vImage_Flags") long flags );

/**
 \function vImageConvert_RGB565toARGB1555
 \abstract Convert from RGB565 to ARGB1555 image format
 \discussion  Convert from RGB565 to ARGB1555 format.  The new alpha is set to 1.
 Both RGB565 and ARGB1555 are defined by vImage to be host-endian formats. On Intel and ARM and other little endian systems, these are
 little endian uint16_t's in memory. On a big endian system, these are big endian uint16_t's.
 
 @param src           A pointer to a vImage_Buffer struct which describes a memory region full of RGB565 pixels
 
 @param dest          A pointer to a vImage_Buffer struct which describes a preallocated memory region to be overwritten by ARGB1555 pixels
 
 @param dither        A dithering method for the green channel.   Options:
 
 kvImageConvert_DitherNone - apply no dithering; input values
 are rounded to the nearest value representable in the
 destination format.
 kvImageConvert_DitherOrdered - pre-computed blue noise is
 added to the image before rounding to the values in
 the destination format.  The offset into this blue
 noise is randomized per-call to avoid visible artifacts
 if you do your own tiling or call the function on
 sequential frames of video.
 kvImageConvert_DitherOrderedReproducible - pre-computed
 blue noise is added to the image before rounding to the
 values in the destination format.  The offset into the
 blue noise is the same for every call to allow users
 to get reproducible results.
 
 The ordered dither methods may be further influenced by shaping the
 distribution of the noise using the gaussian and uniform options below.
 These options are OR-ed with kvImageConvert_DitherOrdered / kvImageCon-
 vert_DitherOrderedReproducible:
 
 kvImageConvert_OrderedGaussianBlue - when using an ordered dither
 pattern, distribute the noise according to a gaussian
 distribution. This generally gives more pleasing images --
 less noisy and perhaps a little more saturated -- but color
 fidelity can suffer. Its effect is between kvImageConvert_DitherNone
 and kvImageConvert_DitherOrdered | kvImageConvert_DitherUniform.
 This is the default for kvImageConvert_DitherOrdered and
 kvImageConvert_DitherOrderedReproducible.
 
 kvImageConvert_OrderedUniformBlue - when using an ordered dither
 pattern, distribute the noise uniformly. This generally gives
 best color fidelity, but the resulting image is noisier and more
 obviously dithered. This is usually the best choice when low
 bitdepth content is drawn next to high bitdepth content and in other
 circumstances where subtle changes to color arising from the conversion
 could be easily noticed. It may be a poor choice when the image
 is likely to be enlarged -- this would cause the noise to become
 more evident-- and for very flat / synthetic content with little
 inherent noise. The enlargement problem may be avoided by enlarging
 first at high bitdepth, then convert to lower bitdepth.
 
 To clarify: "Blue" noise is not blue, nor does it operate solely on the blue
 color channel. Blue noise is monochrome noise that is added to all color
 channels equally. The name arises from blue light, which has a higher frequency
 than other colors of visible light. Thus, blue noise is noise which is
 weighted heavily towards high frequencies. Low frequency noise tends to have
 visible shapes in it that would become apparent in an image if it was added in,
 so it is excluded from the dither pattern.
 
 @param flags           The following flags are understood by this function:
 
 <pre>
 \textblock
 kvImageNoFlags                      Default operation.
 
 kvImageDoNotTile                    Turn internal multithreading off. This may be helpful in cases where you already have
 many such operations going concurrently, and in cases where it is desirable to keep
 CPU utilization to a single core.
 
 kvImageGetTempBufferSize            Returns 0.  Reads and writes no pixels.
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                          Success
 
 kvImageRoiLargerThanInputBuffer               dest->height > src->height OR dest->width > src->width.  There are not enough pixels to fill the destination buffer.
 
 kvImageInvalidParameter                 Invalid / unknown dither value
 \/textblock
 </pre>
 */
public static native @Cast("vImage_Error") long vImageConvert_RGB565toARGB1555( @Const vImage_Buffer src, @Const vImage_Buffer dest, int dither, @Cast("vImage_Flags") long flags );

/*
 Convert between 16 bit floats to 32 bit float format.
 The 16 bit floating point format is identical to OpenEXR. It has a layout as follows:
 
 16 bits:  seeeeemmmmmmmmmm
 
 1-bit sign | 5 bits of exponent, with a bias of 15 | 10 bits of significand (with 11 bits of significance due to the implicit 1 bit)
 
 NaNs, Infinities and denormals are supported.
 Per IEEE-754, all signaling NaNs are quieted during the conversion. (OpenEXR-1.2.1 converts SNaNs to SNaNs.)
 In the float->16 bit float direction, rounding occurs according to the IEEE-754 standard and current IEEE-754 rounding mode.
 To set/inspect the current IEEE-754 rounding mode, please see appropriate utilities in fenv.h
 
 vImageConvert_Planar16FtoPlanarF does not work in place.
 vImageConvert_PlanarFtoPlanar16F does work in place, though the contents of the unused half of the buffer are undefined
 In which case:
 src->data must be equal to dest->data  and src->rowBytes >= dest->rowBytes
 If src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 These functions may also be used with multichannel images formats, such as RGBAFFFF by scaling the width by the number of channels.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar16FtoPlanarF( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_PlanarFtoPlanar16F( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );


/*
 vImageConvert_Planar8toPlanar16F
 
 Convert from 8 bit integer to 16 bit float format.
 
 destPixel[x] = ConvertToPlanar16F(srcPixel[x]);
 
 The range for conversion is [0,255] -> (half) [0.0, 1.0]
 
 The 16 bit floating point format is half-precision floating point
 (a.k.a.  IEEE-754 binary16, OpenCL half, GL_ARB_half_float_pixel, OpenEXR half).
 It has a layout as follows:
 
 16 bits:  seeeeemmmmmmmmmm
 
 1-bit sign | 5 bits of exponent, with a bias of 15 | 10 bits of significand
 (with 11 bits of significance due to the implicit 1 bit)
 
 Operands:
 ---------
 src             A pointer to a vImage_Buffer that references the source pixels
 
 dest            A pointer to a vImage_Buffer that references the destination pixels
 
 flags           The following flags are allowed:
 
 kvImageDoNotTile            Turns off internal multithreading. You may
 wish to do this if you have your own
 multithreading scheme to avoid having the
 two interfere with one another.
 
 Return Value:
 -------------
 kvImageNoError                  Success!
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height.
 kvImageNullPointerArgument      src or dest pointer is NULL.
 kvImageUnknownFlagsBit            Unexpected flag was passed.
 
 This routine will work in place as long as the scan lines overlap exactly.
 
 You can use this for ARGB8888 -> ARGB16F conversions by simply multiplying
 the width of the vImage_Buffer by 4 (for 4 channels)
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar8toPlanar16F(
                                 @Const vImage_Buffer src,
                                 @Const vImage_Buffer dest,
                                 @Cast("vImage_Flags") long flags );

/*
 vImageConvert_Planar16FtoPlanar8
 
 Convert from 16 bit float to 8 bit integer format.
 
 destPixel[x] = ROUND_TO_INTEGER( SATURATED_CLAMP_0_to_255( 255.0f * (srcPixel[x])));
 
 The ROUND_TO_INTEGER function is round to nearest integer (ties go to the even result).
 
 The 16 bit floating point format is half-precision floating point
 (a.k.a.  IEEE-754 binary16, OpenCL half, GL_ARB_half_float_pixel, OpenEXR half).
 It has a layout as follows:
 
 16 bits:  seeeeemmmmmmmmmm
 
 1-bit sign | 5 bits of exponent, with a bias of 15 | 10 bits of significand
 (with 11 bits of significance due to the implicit 1 bit)
 
 All NaNs are converted to 0.
 To set/inspect the current IEEE-754 rounding mode, please see appropriate utilities in fenv.h
 
 Operands:
 ---------
 src             A pointer to a vImage_Buffer that references the source pixels
 
 dest            A pointer to a vImage_Buffer that references the destination pixels
 
 flags           The following flags are allowed:
 
 kvImageDoNotTile            Turns off internal multithreading. You may
 wish to do this if you have your own
 multithreading scheme to avoid having the
 two interfere with one another.
 
 Return Value:
 -------------
 kvImageNoError                  Success!
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height.
 kvImageNullPointerArgument      src or dest pointer is NULL.
 kvImageUnknownFlagsBit            Unexpected flag was passed.
 
 This routine will work in place as long as the scan lines overlap exactly.
 
 You can use this for ARGB16F -> ARGB8888 conversions by simply multiplying
 the width of the vImage_Buffer by 4 (for 4 channels)
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar16FtoPlanar8(
                                 @Const vImage_Buffer src,
                                 @Const vImage_Buffer dest,
                                 @Cast("vImage_Flags") long flags );


/*
 vImageConvert_16UToPlanar8
 Convert a planar (or interleaved -- multiply vImage_Buffer.width by 4) vImage_Buffer of 16 bit unsigned shorts to a buffer containing 8 bit integer values.
 For each 16 bit pixel in src:
 
 uint8_t result = (srcPixel * 255 + 32767) / 65535;
 
 To convert 4 channel interleaved unsigned 16 bit data to ARGB_8888, simply multiply the vImage_Buffer.width by 4.
 
 This can work in place, though the contents of the unused half of the buffer are undefined
 In which case:
 src->data must be equal to dest->data  and src->rowBytes >= dest->rowBytes
 If src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 This function may also be used with multichannel images formats, such as RGBA16U -> RGBA8888 by scaling the width by the number of channels.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_16UToPlanar8( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/*
 vImageConvert_Planar8To16U:
 Convert a planar (or interleaved -- multiply vImage_Buffer.width by 4) vImage_Buffer of 8-bit integer values to a buffer of 16 bit unsigned ints.
 For each 8-bit pixel in src:
 
 uint16_t result = (srcPixel * 65535 + 127 ) / 255;
 
 will not work in place.
 This function may also be used with multichannel images formats, such as RGBA8888 -> RGBA16U  by scaling the width by the number of channels.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar8To16U( @Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );

/*
 Convert RGB to ARGB
 
 If premultiply != 0, then
 
 r = (a * r + 127) / 255
 g = (a * g + 127) / 255
 b = (a * b + 127) / 255
 
 will not work in place.
 Pass NULL for aSrc to use alpha instead.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGB888toARGB8888(   @Const vImage_Buffer arg0,
                                                      @Const vImage_Buffer arg1,
                                                      @Cast("uint8_t") byte arg2,
                                                      @Const vImage_Buffer arg3,
                                                      @Cast("bool") boolean arg4,
                                                      @Cast("vImage_Flags") long arg5 );
public static native @Cast("vImage_Error") long vImageConvert_RGB888toRGBA8888(    @Const vImage_Buffer arg0,
                                                      @Const vImage_Buffer arg1,
                                                      @Cast("uint8_t") byte arg2,
                                                      @Const vImage_Buffer arg3,
                                                      @Cast("bool") boolean arg4,
                                                      @Cast("vImage_Flags") long arg5 );
public static native @Cast("vImage_Error") long vImageConvert_RGB888toBGRA8888(    @Const vImage_Buffer arg0,
                                                      @Const vImage_Buffer arg1,
                                                      @Cast("uint8_t") byte arg2,
                                                      @Const vImage_Buffer arg3,
                                                      @Cast("bool") boolean arg4,
                                                      @Cast("vImage_Flags") long arg5 );
// #define vImageConvert_BGR888toBGRA8888( _bgrSrc, _aSrc, _alpha, _bgraDest, _premultiply, _flags )   vImageConvert_RGB888toRGBA8888((_bgrSrc), (_aSrc), (_alpha), (_bgraDest), (_premultiply), (_flags) )
// #define vImageConvert_BGR888toRGBA8888( _bgrSrc, _aSrc, _alpha, _rgbaDest, _premultiply, _flags )   vImageConvert_RGB888toBGRA8888((_bgrSrc), (_aSrc), (_alpha), (_rgbaDest), (_premultiply), (_flags) )

/*
 Convert 4 channel buffer to a 3 channel one, by removing the 1st channel.
 The R,G and B channels are simply copied into the new buffer.
 
 This can work in place, though the contents of the unused half of the buffer are undefined
 In which case:
 src->data must be equal to dest->data  and src->rowBytes >= dest->rowBytes
 If src has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888toRGB888(    @Const vImage_Buffer arg0,
                                                      @Const vImage_Buffer arg1,
                                                      @Cast("vImage_Flags") long arg2 );
public static native @Cast("vImage_Error") long vImageConvert_RGBA8888toRGB888(    @Const vImage_Buffer arg0,
                                                      @Const vImage_Buffer arg1,
                                                      @Cast("vImage_Flags") long arg2 );
public static native @Cast("vImage_Error") long vImageConvert_BGRA8888toRGB888(    @Const vImage_Buffer arg0,
                                                      @Const vImage_Buffer arg1,
                                                      @Cast("vImage_Flags") long arg2 );
// #define vImageConvert_RGBA8888toBGR888( _rgbaSrc, _bgrDest, _flags )    vImageConvert_BGRA8888toRGB888((_rgbaSrc), (_bgrDest), (_flags))
// #define vImageConvert_BGRA8888toBGR888( _bgraSrc, _bgrDest, _flags )    vImageConvert_RGBA8888toRGB888((_bgraSrc), (_bgrDest), (_flags))

/*
 Flatten a ARGB8888 image to a RGB888 image against an opaque background of a certain color.
 The calculation for each {R,G,B} channel is done as:
 
 8-bit:
 if( isImagePremultiplied )
 color = (color * 255 + (255 - alpha) * backgroundColor + 127) / 255
 else
 color = (color * alpha + (255 - alpha) * backgroundColor + 127) / 255
 
 floating point:
 if( isImagePremultiplied )
 color = color + (1.0f - alpha) * backgroundColor
 else
 color = color * alpha + (1.0f - alpha) * backgroundColor
 
 backgroundColor.alpha is ignored.
 These functions will work in place provided that rowBytes and the position of row starts is the same between src and dest images.
 
 Note: that regardless of the value of isImagePremultiplied, the result image is premultiplied by alpha. If the backgroundColor
 was not opaque and you want a non-premultiplied image, you will still need to unpremultiply the result.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageNullPointerArgument             If src or dest == NULL
 kvImageUnknownFlagsBit                 kvImageDoNotTile and kvImageNoFlags are only flags allowed for these function.
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageFlatten_ARGB8888ToRGB888(
                                                       @Const vImage_Buffer arg0,
                                                       @Const vImage_Buffer arg1,
                                                       @Cast("const uint8_t*") BytePointer arg2,
                                                       @Cast("bool") boolean arg3,
                                                       @Cast("vImage_Flags") long arg4
);
public static native @Cast("vImage_Error") long vImageFlatten_ARGBFFFFToRGBFFF(
                                                       @Const vImage_Buffer arg0,
                                                       @Const vImage_Buffer arg1,
                                                       @Cast("const float*") FloatPointer arg2,
                                                       @Cast("bool") boolean arg3,
                                                       @Cast("vImage_Flags") long arg4
);
public static native @Cast("vImage_Error") long vImageFlatten_RGBA8888ToRGB888(
                                                       @Const vImage_Buffer arg0,
                                                       @Const vImage_Buffer arg1,
                                                       @Cast("const uint8_t*") BytePointer arg2,
                                                       @Cast("bool") boolean arg3,
                                                       @Cast("vImage_Flags") long arg4
);
public static native @Cast("vImage_Error") long vImageFlatten_RGBAFFFFToRGBFFF(
                                                       @Const vImage_Buffer arg0,
                                                       @Const vImage_Buffer arg1,
                                                       @Cast("const float*") FloatPointer arg2,
                                                       @Cast("bool") boolean arg3,
                                                       @Cast("vImage_Flags") long arg4
);
public static native @Cast("vImage_Error") long vImageFlatten_BGRA8888ToRGB888(
                                                       @Const vImage_Buffer arg0,
                                                       @Const vImage_Buffer arg1,
                                                       @Cast("const uint8_t*") BytePointer arg2,
                                                       @Cast("bool") boolean arg3,
                                                       @Cast("vImage_Flags") long arg4
);
public static native @Cast("vImage_Error") long vImageFlatten_BGRAFFFFToRGBFFF(
                                                       @Const vImage_Buffer arg0,
                                                       @Const vImage_Buffer arg1,
                                                       @Cast("const float*") FloatPointer arg2,
                                                       @Cast("bool") boolean arg3,
                                                       @Cast("vImage_Flags") long arg4
);
// #define vImageFlatten_BGRA8888ToBGR888( _bgra8888Src, _bgr888Dest, _backgroundColor, _isImagePremultiplied, _flags )
// vImageFlatten_RGBA8888ToRGB888( (_bgra8888Src), (_bgr888Dest), (_backgroundColor), (_isImagePremultiplied), (_flags) )
// #define vImageFlatten_RGBA8888ToBGR888( _rgba8888Src, _bgr888Dest, _backgroundColor, _isImagePremultiplied, _flags )
// vImageFlatten_BGRA8888ToRGB888( (_rgba8888Src), (_bgr888Dest), (_backgroundColor), (_isImagePremultiplied), (_flags) )
// #define vImageFlatten_BGRAFFFFToBGRFFF( _bgraFFFFSrc, _bgrFFFDest, _backgroundColor, _isImagePremultiplied, _flags )
// vImageFlatten_RGBAFFFFToRGBFFF( (_bgraFFFFSrc), (_bgrFFFDest), (_backgroundColor), (_isImagePremultiplied), (_flags) )
// #define vImageFlatten_RGBAFFFFToBGRFFF( _rgbaFFFFSrc, _bgrFFFDest, _backgroundColor, _isImagePremultiplied, _flags )
// vImageFlatten_BGRAFFFFToRGBFFF( (_rgbaFFFFSrc), (_bgrFFFDest), (_backgroundColor), (_isImagePremultiplied), (_flags) )


/*
 Convert 3 planar buffers to a 3 channel interleave buffer.
 
 Does not work in place
 This may be used to produce other channel orderings by changing the order of the planar buffers passed into the function.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar8toRGB888( @Const vImage_Buffer planarRed, @Const vImage_Buffer planarGreen, @Const vImage_Buffer planarBlue, @Const vImage_Buffer rgbDest, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_PlanarFtoRGBFFF( @Const vImage_Buffer planarRed, @Const vImage_Buffer planarGreen, @Const vImage_Buffer planarBlue, @Const vImage_Buffer rgbDest, @Cast("vImage_Flags") long flags );

/*
 Convert a 3 channel interleave buffer to 3 planar buffers.
 
 Does not work in place
 This may be used to consume other channel orderings by changing the order of the planar buffers passed into the function.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGB888toPlanar8( @Const vImage_Buffer rgbSrc, @Const vImage_Buffer redDest, @Const vImage_Buffer greenDest, @Const vImage_Buffer blueDest, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_RGBFFFtoPlanarF( @Const vImage_Buffer rgbSrc, @Const vImage_Buffer redDest, @Const vImage_Buffer greenDest, @Const vImage_Buffer blueDest, @Cast("vImage_Flags") long flags );


/**
 \function vImageSelectChannels_ARGB8888
 
 \abstract Does the same thing as vImageOverwriteChannels_ARGB8888 except that the newSrc buffer is in ARGB8888.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 // Generate intMask to be 0xff for the channels that we want copy from newSrc to origSrc.
 uint32_t    t = *(uint32_t*)newSrc;
 uint32_t    b = *(uint32_t*)origSrc;
 
 t  = (t & intMask ) | (b & ~intMask );
 
 *(uint32_t*)dest = t;
 }</pre>
 
 If the appropriate copyMask bit is set, then the color channel from newSrc is used. Otherwise the color channel from origSrc is used.
 We note that functions of this kind only exist for interleaved buffers. If you had been using planar data, this would just be a pointer swap.
 This will work for other channel orderings, such as RGBA8888.  You need to adjust the ordering of the bits in copyMask to compensate.
 This can work in place provided that for each buffer "buf" that overlaps with dest:
 buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If buf has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param newSrc
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel that we will overwrite with.
 
 @param origSrc
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel that we will overwrite into.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.  You should use this if you are doing your own threading / tiling.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageSelectChannels_ARGB8888( @Const vImage_Buffer newSrc,
                                                        @Const vImage_Buffer origSrc,
                                                        @Const vImage_Buffer dest,
                                                        @Cast("uint8_t") byte copyMask,
                                                        @Cast("vImage_Flags") long flags );

/**
 \function vImageSelectChannels_ARGBFFFF
 
 \abstract Does the same thing as vImageOverwriteChannels_ARGBFFFF except that the newSrc buffer is in ARGBFFFF
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 // Generate intMask to be 0xffffffff for the channels that we want copy from newSrc to origSrc.
 float    t = *(float*)newSrc;
 float    b = *(float*)origSrc;
 
 t  = (t & intMask ) | (b & ~intMask );
 
 *(float*)dest = t;
 }</pre>
 
 If the appropriate copyMask bit is set, then the color channel from newSrc is used. Otherwise the color channel from origSrc is used.
 We note that functions of this kind only exist for interleaved buffers. If you had been using planar data, this would just be a pointer swap.
 This will work for other channel orderings, such as RGBAFFFF.  You need to adjust the ordering of the bits in copyMask to compensate.
 This can work in place provided that for each buffer "buf" that overlaps with dest:
 buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If buf has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param newSrc
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel that we will overwrite with.
 
 @param origSrc
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel that we will overwrite into.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing destination pixels.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.  You should use this if you are doing your own threading / tiling.
 
 @return kvImageNoError                         Success
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageSelectChannels_ARGBFFFF( @Const vImage_Buffer newSrc,
                                                        @Const vImage_Buffer origSrc,
                                                        @Const vImage_Buffer dest,
                                                        @Cast("uint8_t") byte copyMask,
                                                        @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannelsWithPixel_ARGB8888
 
 \abstract Like vImageOverwriteChannelsWithScalar_ARGB8888, with a ARGB input pixel, instead of a planar one.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 // Set up a uint32_t mask - 0xFF where the pixels should be conserved
 destRow[x] = (srcRow[x] & mask) | the_pixel;
 }</pre>
 
 This will work for other channel orderings, such as RGBA8888. You will need to adjust the ordering of bits in copyMask to compensate.
 This can work in place provided that for each buffer "buf" that overlaps with dest:
 buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If buf has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param the_pixel
 A pointer to Pixel_8888 that references ARGB pixel.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB destination pixels.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.  You should use this if you are doing your own threading / tiling.
 
 @return kvImageNoError                         Success
 @return kvImageInvalidParameter                When copyMask > 0x0F
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithPixel_ARGB8888( @Cast("const uint8_t*") BytePointer the_pixel,
                                                                 @Const vImage_Buffer src,
                                                                 @Const vImage_Buffer dest,
                                                                 @Cast("uint8_t") byte copyMask,
                                                                 @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannelsWithPixel_ARGB16U
 
 \abstract Like vImageOverwriteChannelsWithScalar_ARGB16U, with a ARGB input pixel, instead of a planar one.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 // Set up a uint32_t mask - 0xFFFF where the pixels should be conserved
 destRow[x] = (srcRow[x] & mask) | the_pixel;
 }</pre>
 
 This will work for other channel orderings, such as RGBA16U. You will need to adjust the ordering of bits in copyMask to compensate.
 This can work in place provided that for each buffer "buf" that overlaps with dest:
 buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If buf has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param the_pixel
 A pointer to Pixel_ARGB_16U that references ARGB pixel.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB destination pixels.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.  You should use this if you are doing your own threading / tiling.
 
 @return kvImageNoError                         Success
 @return kvImageInvalidParameter                When copyMask > 0x0F
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithPixel_ARGB16U( @Cast("const uint16_t*") ShortPointer the_pixel,
                                                                @Const vImage_Buffer src,
                                                                @Const vImage_Buffer dest,
                                                                @Cast("uint8_t") byte copyMask,
                                                                @Cast("vImage_Flags") long flags );

/**
 \function vImageOverwriteChannelsWithPixel_ARGBFFFF
 
 \abstract Like vImageOverwriteChannelsWithScalar_ARGBFFFF, with a ARGB input pixel, instead of a planar one.
 
 \discussion For each pixel in src, do the following:
 <pre>{@code
 // Set up a uint32_t mask - 0xFFFFFFFF where the pixels should be conserved
 destRow[x] = (srcRow[x] & mask) | the_pixel;
 }</pre>
 
 This will work for other channel orderings, such as RGBAFFFF. You will need to adjust the ordering of bits in copyMask to compensate.
 This can work in place provided that for each buffer "buf" that overlaps with dest:
 buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If buf has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 @param the_pixel
 A pointer to Pixel_FFFF that references ARGB pixel.
 
 @param src
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB source pixel.
 
 @param dest
 A pointer to a valid and initialized vImage_Buffer struct, that points to a buffer containing ARGB destination pixels.
 
 @param copyMask
 A mask to copy plane : 0x8  -- alpha, 0x4 -- red, 0x2 --- green, 0x1 --- blue
 
 @param flags
 \p kvImageNoFlags          Default operation
 \p kvImageDoNotTile        Disable internal multithreading.  You should use this if you are doing your own threading / tiling.
 
 @return kvImageNoError                         Success
 @return kvImageInvalidParameter                When copyMask > 0x0F
 @return kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageOverwriteChannelsWithPixel_ARGBFFFF( @Cast("const float*") FloatPointer the_pixel,
                                                                 @Const vImage_Buffer src,
                                                                 @Const vImage_Buffer dest,
                                                                 @Cast("uint8_t") byte copyMask,
                                                                 @Cast("vImage_Flags") long flags );


/*
 The following functions interleave the planar buffers pointed to by red, green and blue, with the scalar value in alpha, to
 create a ARGB, BGRA or RGBA  four channel interleaved buffer.  These functions do not work in place.  Per all vImage functions
 channel order is defined as memory order.
 
 Flags:
 kvImageGetTempBufferSize    returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Other flags cause the function to return kvImageUnknownFlagsBit.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar8ToXRGB8888( @Cast("uint8_t") byte alpha, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_Planar8ToBGRX8888( @Const vImage_Buffer blue, @Const vImage_Buffer green, @Const vImage_Buffer red, @Cast("uint8_t") byte alpha, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImageConvert_Planar8ToRGBX8888( _red, _green, _blue, _alpha, _dest, _flags )   vImageConvert_Planar8ToBGRX8888((_red), (_green), (_blue), (_alpha), (_dest), (_flags))
public static native @Cast("vImage_Error") long vImageConvert_PlanarFToXRGBFFFF( @Cast("float") float alpha, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_PlanarFToBGRXFFFF( @Const vImage_Buffer blue, @Const vImage_Buffer green, @Const vImage_Buffer red, @Cast("float") float alpha, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags );
// #define         vImageConvert_PlanarFToRGBXFFFF( _red, _green, _blue, _alpha, _dest, _flags )   vImageConvert_PlanarFToBGRXFFFF( (_red), (_green), (_blue), (_alpha), (_dest), (_flags))

/*
 The following functions de-interleave a XRGB, BGRX, or RGBX four-channel
 buffer to create three planar buffers red, green, and blue, discarding
 the fourth channel.  These functions do not work in place.  As with all
 vImage functions, channel order is memory order.
 
 Flags:
 kvImageGetTempBufferSize    Returns 0, does nothing.
 kvImageDoNotTile            Disables internal multithreading.
 
 Other flags cause the function to return kvImageUnknownFlagsBit.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageBufferSizeMismatch              When the size of destination dimensions are different.
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */

public static native @Cast("vImage_Error") long vImageConvert_XRGB8888ToPlanar8(@Const vImage_Buffer src,
                                                       @Const vImage_Buffer red,
                                                       @Const vImage_Buffer green,
                                                       @Const vImage_Buffer blue,
                                                       @Cast("vImage_Flags") long flags);

public static native @Cast("vImage_Error") long vImageConvert_BGRX8888ToPlanar8(@Const vImage_Buffer src,
                                                       @Const vImage_Buffer blue,
                                                       @Const vImage_Buffer green,
                                                       @Const vImage_Buffer red,
                                                       @Cast("vImage_Flags") long flags);

// #define vImageConvert_RGBX8888ToPlanar8(_src, _red, _green, _blue, _flags)
// vImageConvert_BGRX8888ToPlanar8((_src), (_red), (_green), (_blue), (_flags))

public static native @Cast("vImage_Error") long vImageConvert_XRGBFFFFToPlanarF(@Const vImage_Buffer src,
                                                       @Const vImage_Buffer red,
                                                       @Const vImage_Buffer green,
                                                       @Const vImage_Buffer blue,
                                                       @Cast("vImage_Flags") long flags);

public static native @Cast("vImage_Error") long vImageConvert_BGRXFFFFToPlanarF(@Const vImage_Buffer src,
                                                       @Const vImage_Buffer blue,
                                                       @Const vImage_Buffer green,
                                                       @Const vImage_Buffer red,
                                                       @Cast("vImage_Flags") long flags);

// #define vImageConvert_RGBXFFFFToPlanarF(_src, _red, _green, _blue, _flags)
// vImageConvert_BGRXFFFFToPlanarF((_src), (_red), (_green), (_blue), (_flags))

/*
 vImageConvert_Planar8ToARGBFFFF
 
 Conversion routines to convert planar 8-bit buffers to packed (interleaved) 4 channel floating point format.
 
 The meaning of maxFloat and minFloat here is substatially the same as for vImageConvert_Planar8toPlanarF. The difference is that since this is a four channel
 image, we use four channel min and max values so that different mins and maxes can be used for each channel. The channels in minFloat and maxFloat are in the
 same order as the output pixels. MaxFloat is allowed to be less than MinFloat, in which case the image will come out looking like a photographic negative.
 (That is, you get a free contrast + brightness adjustment as part of this conversion.)
 
 The vImageConvert_Planar8ToARGBFFFF function is the workhorse of this family. The other three are provided as a convenience. You can actually substitute
 any of the channels with a constant by replacing the vImage_Buffer passed in for that channel with one from another color channel, and set
 maxFloat.color = minFloat.color = desired color for that channel. (In the particular case where you want all four channels to be constant, please call
 vImageBufferFill_ARGBFFFF instead.) Likewise, though these API names appear to correspond to particular color channel orders, vImage has no way of knowing what
 is actually red or green or cyan, so you can use them for other color spaces and other packing orders. Thus, vImageConvert_Planar8ToARGBFFFF should be
 properly considered a somewhat color space agnostic <=4 planar 8-bit channel to 4 channel packed float conversion function.
 
 Performance data on Intel Core2 and G5 suggest that like most simple conversion functions, these functions only perform well if the data is already in the cache.
 Optimum tile sizes are between ~200 pixels and somewhere in the 50000 to 200000 pixel range, depending on cache size. If the image is larger than that, this
 function is limited by the throughput of the machine's front side bus and will run anywhere from 3 to 10 times slower. For well sized images / times, we observe
 that the vector code is 3-12x faster than scalar code. For images that don't fit in cache or that are not in cache, the vector code is perhaps only 10% faster
 than scalar.
 
 Flags:
 kvImageGetTempBufferSize    returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Other flags cause the function to return kvImageUnknownFlagsBit.
 
 These routines do not work in place.
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar8ToARGBFFFF( @Const vImage_Buffer alpha, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("const float*") FloatPointer maxFloat, @Cast("const float*") FloatPointer minFloat, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_Planar8ToXRGBFFFF( @Cast("float") float alpha, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("const float*") FloatPointer maxFloat, @Cast("const float*") FloatPointer minFloat, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_Planar8ToBGRXFFFF(@Const vImage_Buffer blue, @Const vImage_Buffer green, @Const vImage_Buffer red, @Cast("float") float alpha, @Const vImage_Buffer dest, @Cast("const float*") FloatPointer maxFloat, @Cast("const float*") FloatPointer minFloat, @Cast("vImage_Flags") long flags );
// #define         vImageConvert_Planar8ToRGBXFFFF(_red, _green, _blue, _alpha, _dest, _maxFloat, _minFloat, _flags)  vImageConvert_Planar8ToBGRXFFFF((_red), (_green), (_blue), (_alpha), (_dest), (_maxFloat), (_minFloat), (_flags))

/*
 vImageConvert_PlanarFToARGB8888
 
 Conversion routines to convert planar float buffers to packed (interleaved) 4 channel 8-bit unsigned format.
 
 The meaning of maxFloat and minFloat here is similar to vImageConvert_PlanarFtoPlanar8. That is, the max and min define the pixel values for
 100% and 0% light saturation respectively. (Pixel values outside that range are clamped into that range before we do arithmetic.) Since this function works on
 multichannel data, we pass in multichannel maxes and mins. The channel order in maxFloat and minFloat is the same as for the desired result pixel. The calculation
 is as follows for each channel:
 
 uint8_t result = ROUND_TO_INTEGER( SATURATED_CLAMP_0_to_255( 255.0f * ( srcPixel[channel] - minFloat[channel] ) / (maxFloat[channel] - minFloat[channel]) ));
 
 The ROUND_TO_INTEGER function here behaves identically to the C99 lrintf() function. It rounds to integer using the prevailing floating point rounding mode.
 By default, that is round to nearest integer (ties go to the even result).  You can change the rounding mode using interfaces in fenv.h, specfically fesetround()
 and fegetround(), if you prefer that the calculation round up, or down.
 
 It is allowed that maxFloat[channel] < minFloat[channel], in which case you'll get an image that appears a bit like a photgraphic negative. The astute reader will
 note that these routines provide a free per-channel brightness and contrast adjustment.
 
 In the special case that maxFloat[channel] == minFloat[channel], then the calculation is instead as follows:
 
 uint8_t result = ROUND_TO_INTEGER( SATURATED_CLIP_0_to_255( 255.0f * maxFloat[channel] ) );
 
 This serves two purposes. It guarantees we can't get a division by zero. It also provides a way to set certain channels to a constant, rather than use
 a source buffer. You'll still need to pass in a source buffer for that channel, the data also needs to be valid, but it wont actually affect the result. It should
 be sufficient to substitute one of the other source buffers in for the color channel that you wish to be constant. If you intend to produce a buffer full of a
 solid color, please use vImageBufferFill_ARGB8888 instead. Two special purpose routines are provided for constant alpha in either the first or last position
 in the pixel, vImageConvert_PlanarFToXRGB8888, vImageConvert_PlanarFToBGRX8888. On some platforms, these may be a little bit faster.
 
 Numerics note: We don't actually do the full caculation described above. The constant terms are precalculated. We are really doing the following:
 
 float a = 255.0f / (maxFloat[channel] - minFloat[channel]);
 float b = minFloat[channel] * -a;
 
 uint8_t result = ROUND_TO_INTEGER( SATURATED_CLAMP( srcPixel[channel], minFloat[channel], maxFloat[channel]) * a  + b ));
 
 This may cause slightly different rounding when scaling the pixel to the 0..255 range. In very rare cases, that may produce a result pixel that differs from the
 true calculation by 1. NaNs produce 0.
 
 Flags:
 kvImageGetTempBufferSize    returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Other flags cause the function to return kvImageUnknownFlagsBit.
 
 These can work in place provided that for each buffer "buf" that overlaps with dest:
 buf->data must be equal to dest->data and buf->rowBytes >= dest->rowBytes
 If buf has a different rowBytes from dest, kvImageDoNotTile must be also passed in the flags
 
 Return Value:
 -------------
 kvImageNoError                         Success
 kvImageRoiLargerThanInputBuffer        The height and width of the destination must be less than or equal to the height and width of the src buffer, respectively.
 */
public static native @Cast("vImage_Error") long vImageConvert_PlanarFToARGB8888( @Const vImage_Buffer alpha, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("const float*") FloatPointer maxFloat, @Cast("const float*") FloatPointer minFloat, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_PlanarFToXRGB8888( @Cast("uint8_t") byte alpha, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("const float*") FloatPointer maxFloat, @Cast("const float*") FloatPointer minFloat, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_PlanarFToBGRX8888( @Const vImage_Buffer blue, @Const vImage_Buffer green, @Const vImage_Buffer red, @Cast("uint8_t") byte alpha, @Const vImage_Buffer dest, @Cast("const float*") FloatPointer maxFloat, @Cast("const float*") FloatPointer minFloat, @Cast("vImage_Flags") long flags );
// #define         vImageConvert_PlanarFToRGBX8888( _red, _green, _blue, _alpha, _dest, _maxFloat, _minFloat, _flags )     vImageConvert_PlanarFToBGRX8888((_red), (_green), (_blue), (_alpha), (_dest), (_maxFloat), (_minFloat), (_flags))

/*
 vImageConvert_RGB16UtoARGB16U
 
 Convert RGB16U -> ARGB16U
 
 
 vImageConvert_RGB16UtoRGBA16U
 
 Convert RGB16U -> RGBA16U
 
 
 vImageConvert_RGB16UtoBGRA16U
 
 Convert RGB16U -> BGRA16U
 
 
 Each channel is 16 bit unsigned.
 3-channel interleaved pixel buffers that contains RGB and 1 planar pixel buffer for A or
 'alpha' value are combined to create 4-channel interleaved pixel buffer.
 'premultiply' determines if this function will premultiply alpha value(s) to RGB values.
 
 if (aSrc != NULL)
 {
 if (premultiply)
 {
 r = (aSrc[i] * rgb[i*3+0] + 32767) / 65535
 g = (aSrc[i] * rgb[i*3+1] + 32767) / 65535
 b = (aSrc[i] * rgb[i*3+2] + 32767) / 65535
 
 argbDest[i*4+0] = aSrc[i];
 argbDest[i*4+1] = r;
 argbDest[i*4+2] = g;
 argbDest[i*4+3] = b;
 }
 else
 {
 argbDest[i*4+0] = aSrc[i];
 argbDest[i*4+1] = rgb[i*3+0];
 argbDest[i*4+2] = rgb[i*3+1];
 argbDest[i*4+3] = rgb[i*3+2];
 }
 }
 else
 {
 if (premultiply)
 {
 r = (alpha * rgb[i*3+0] + 32767) / 65535
 g = (alpha * rgb[i*3+1] + 32767) / 65535
 b = (alpha * rgb[i*3+2] + 32767) / 65535
 
 argbDest[i*4+0] = alpha;
 argbDest[i*4+1] = r;
 argbDest[i*4+2] = g;
 argbDest[i*4+3] = b;
 }
 else
 {
 argbDest[i*4+0] = alpha;
 argbDest[i*4+1] = rgb[i*3+0];
 argbDest[i*4+2] = rgb[i*3+1];
 argbDest[i*4+3] = rgb[i*3+2];
 }
 }
 
 Operands:
 ---------
 rgbSrc : A pointer to vImage_Buffer that references RGB interleaved source pixels
 
 aSrc : A pointer to vImage_Buffer that references A planar source pixels
 
 alpha : A single alpha value
 
 argbDest / rgbaDest / bgraDest : A pointer to vImage_Buffer that references ARGB / RGBA / BGRA interleaved destination pixels
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when src.width < dest.width || src.height < dest.height.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 
 This function will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGB16UtoARGB16U( @Const vImage_Buffer rgbSrc, @Const vImage_Buffer aSrc, @Cast("Pixel_16U") short alpha, @Const vImage_Buffer argbDest, @Cast("bool") boolean premultiply, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_RGB16UtoRGBA16U( @Const vImage_Buffer rgbSrc, @Const vImage_Buffer aSrc, @Cast("Pixel_16U") short alpha, @Const vImage_Buffer rgbaDest, @Cast("bool") boolean premultiply, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_RGB16UtoBGRA16U( @Const vImage_Buffer rgbSrc, @Const vImage_Buffer aSrc, @Cast("Pixel_16U") short alpha, @Const vImage_Buffer bgraDest, @Cast("bool") boolean premultiply, @Cast("vImage_Flags") long flags );

/*
 vImageConvert_ARGB16UtoRGB16U
 
 Convert ARGB16U -> RGB16U
 
 
 vImageConvert_RGBA16UtoRGB16U
 
 Convert RGBA16U -> RGB16U
 
 
 vImageConvert_BGRA16UtoRGB16U
 
 Convert BGRA16U -> RGB16U
 
 
 Each channel is 16-bit unsigned
 4-channel interleaved pixel buffer becomes 3-channel interleaved pixel buffer by skipping to copy
 the first channel in 4-channel interleaved pixel buffer.
 
 rgbDest[i*3+0] = argbSrc[i*4+1];
 rgbDest[i*3+1] = argbSrc[i*4+2];
 rgbDest[i*3+2] = argbSrc[i*4+3];
 
 Operands:
 ---------
 argbSrc / rgbaSrc / bgraSrc : A pointer to vImage_Buffer that references ARGB / RGBA / BGRA interleaved source pixels
 
 rgbDest : A pointer to vImage_Buffer that references RGB interleaved destination pixels
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when src.width < dest.width || src.height < dest.height.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 
 vImageConvert_RGBA16UtoRGB16U() can work in place if (argbSrc.data == rgbDest.data) && (argbSrc.rowBytes == rgbDest.rowBytes)
 Rest of cases in these 3 functions will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UtoRGB16U( @Const vImage_Buffer argbSrc, @Const vImage_Buffer rgbDest, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_RGBA16UtoRGB16U( @Const vImage_Buffer rgbaSrc, @Const vImage_Buffer rgbDest, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_BGRA16UtoRGB16U( @Const vImage_Buffer bgraSrc, @Const vImage_Buffer rgbDest, @Cast("vImage_Flags") long flags );

/*
 vImageConvert_Planar16UtoARGB16U
 
 Convert Planar16U -> ARGB16U
 
 
 Each channel is 16-bit unsigned
 4 planar pixel buffers are combined to create 4-channel interleaved pixel buffers.
 
 argbDest[i*4+0] = aSrc[i];
 argbDest[i*4+1] = rSrc[i];
 argbDest[i*4+2] = gSrc[i];
 argbDest[i*4+3] = bSrc[i];
 
 This function can be used to create any channel order from 4 planar pixel buffers to interleaved
 pixel buffers.
 
 Operands:
 ---------
 aSrc : A pointer to vImage_Buffer that references A planar source pixels
 
 rSrc : A pointer to vImage_Buffer that references R planar source pixels
 
 gSrc : A pointer to vImage_Buffer that references G planar source pixels
 
 bSrc : A pointer to vImage_Buffer that references B planar source pixels
 
 argbDest : A pointer to vImage_Buffer that references ARGB interleaved destination pixels
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when src.width < dest.width || src.height < dest.height.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 
 This function will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar16UtoARGB16U(@Const vImage_Buffer aSrc, @Const vImage_Buffer rSrc, @Const vImage_Buffer gSrc, @Const vImage_Buffer bSrc, @Const vImage_Buffer argbDest, @Cast("vImage_Flags") long flags);

/*
 vImageConvert_ARGB16UtoPlanar16U
 
 Convert ARGB16U -> Planar16U
 
 
 Each channel is 16-bit unsigned
 Each channel of 4-channel interleaved pixel buffer are copied into its planar pixel buffer.
 
 aDest[i] = argbSrc[i*4+0];
 rDest[i] = argbSrc[i*4+1];
 gDest[i] = argbSrc[i*4+2];
 bDest[i] = argbSrc[i*4+3];
 
 This function can be used to create any channel order from interleaved pixel buffers to 4 planar
 pixel buffers.
 
 Operands:
 ---------
 argbSrc : A pointer to vImage_Buffer that references ARGB interleaved source pixels
 
 aDest : A pointer to vImage_Buffer that references A planar destination pixels
 
 rDest : A pointer to vImage_Buffer that references R planar destination pixels
 
 gDest : A pointer to vImage_Buffer that references G planar destination pixels
 
 bDest : A pointer to vImage_Buffer that references B planar destination pixels
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 vImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when src.width < dest.width || src.height < dest.height.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 
 This function will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UtoPlanar16U(@Const vImage_Buffer argbSrc, @Const vImage_Buffer aDest, @Const vImage_Buffer rDest, @Const vImage_Buffer gDest, @Const vImage_Buffer bDest, @Cast("vImage_Flags") long flags);


/*
 vImageConvert_Planar16UtoRGB16U
 
 Planar16U -> RGB16U
 
 
 Each channel is 16-bit unsigned
 3 planar pixel buffers are combined to create 3-channel interleaved pixel buffer.
 
 rgbDest[i*3+0] = rSrc[i];
 rgbDest[i*3+1] = gSrc[i];
 rgbDest[i*3+2] = bSrc[i];
 
 This function can be used to create any channel order from 3 planar pixel buffers to interleaved
 pixel buffers.
 
 Operands:
 ---------
 rSrc : A pointer to vImage_Buffer that references R planar source pixels
 
 gSrc : A pointer to vImage_Buffer that references G planar source pixels
 
 bSrc : A pointer to vImage_Buffer that references B planar source pixels
 
 rgbDest : A pointer to vImage_Buffer that references RGB interleaved destination pixels
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when src.width < dest.width || src.height < dest.height.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 
 This function will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar16UtoRGB16U( @Const vImage_Buffer rSrc, @Const vImage_Buffer gSrc, @Const vImage_Buffer bSrc, @Const vImage_Buffer rgbDest, @Cast("vImage_Flags") long flags );

/*
 vImageConvert_RGB16UtoPlanar16U
 
 Planar16U <- RGB16U
 
 Each channel is 16-bit unsigned
 Each channel of 3-channel interleaved pixel buffer are copied into its planar pixel buffer.
 
 rDest[i] = rgbSrc[i*3+0];
 gDest[i] = rgbSrc[i*3+1];
 bDest[i] = rgbSrc[i*3+2];
 
 This function can be used to create any channel order from interleaved pixel buffers to 3 planar
 pixel buffers.
 
 Operands:
 ---------
 rgbSrc : A pointer to vImage_Buffer that references RGB interleaved source pixels
 
 rDest : A pointer to vImage_Buffer that references R planar destination pixels
 
 gDest : A pointer to vImage_Buffer that references G planar destination pixels
 
 bDest : A pointer to vImage_Buffer that references B planar destination pixels
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 
 This function will not work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGB16UtoPlanar16U( @Const vImage_Buffer rgbSrc, @Const vImage_Buffer rDest, @Const vImage_Buffer gDest, @Const vImage_Buffer bDest, @Cast("vImage_Flags") long flags );


public static native @Cast("vImage_Error") long vImageConvert_Planar16UtoPlanar8_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, int dither, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGB16UtoRGB888_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, int dither, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UtoARGB8888_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, int dither, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UtoARGB8888_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, int dither, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UtoARGB8888_dithered(@Const vImage_Buffer src, @Const vImage_Buffer dest, int dither, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/*
 vImageConvert_ARGB16UToARGB8888
 
 This function does 3 things.
 1. Converts 16-bit unsigned ARGB interleaved pixels into 8-bit unsigned ARGB interleaved pixels.
 2. Changes the order of channels according to permuteMap
 3. Selects between the result pixel and the backgroundColor according to the bits in copyMask.
 
 permuteMap[i] = 0, 1, 2, or 3 to specify how we permute each channel.
 
 permuteMap[0] tells which channel in ARGB16U will be used as the 1st channel (A) in the result ARGB8888.
 permuteMap[1] tells which channel in ARGB16U will be used as the 2nd channel (R) in the result ARGB8888.
 permuteMap[2] tells which channel in ARGB16U will be used as the 3rd channel (G) in the result ARGB8888.
 permuteMap[3] tells which channel in ARGB16U will be used as the 4th channel (B) in the result ARGB8888.
 
 copyMask = _ _ _ _  ; 4 digit binary
 1000 tells if we want to use 1st channel in backgroundColor as the value of channel A in the result.
 0100 tells if we want to use 2nd channel in backgroundColor as the value of channel R in the result.
 0010 tells if we want to use 3rd channel in backgroundColor as the value of channel G in the result.
 0001 tells if we want to use 4th channel in backgroundColor as the value of channel B in the result.
 
 The per-pixel operation is:
 
 Pixel_16U *srcPixel;
 Pixel_8888 *destPixel;
 uint16_t result16;
 uint8_t result[4];
 uint8_t mask = 0x8;
 
 for( int i = 0; i < 4; i++ )
 {
 result16 = srcPixel[ permuteMap[i] ];
 result[i] = (result16 * 255U + 32767U) / 65535U;
 if( mask & copyMask )
 result[i] = backgroundColor[i];
 mask = mask >> 1;
 }
 srcPixel += 4;
 
 destPixel[0] = result[0];
 destPixel[1] = result[1];
 destPixel[2] = result[2];
 destPixel[3] = result[3];
 destPixel += 4;
 
 Operands:
 ---------
 src : A pointer to vImage_Buffer that references 16-bit ARGB interleaved source pixels.
 dest : A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 permuteMap : Values that can be used to switch the channel order as the above example.
 copyMask : A mask to choose between the result and backgroundColor.
 backgroudColor : A pointer to Pixel_8888 that references 8-bit ARGB values which can replace the result pixels with. Pixel_8888 backgroundColor = {alpha, red, green, blue};
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageInvalidParameter            Is returned when the values in permuteMap[i] is not one of 0, 1, 2, or 3.
 kvImageNullPointerArgument         Is returned when backgroundColorPtr is NULL.
 
 This function can work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") byte[] permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );


/*
 vImageConvert_ARGB8888ToARGB16U
 
 This function does 3 things.
 1. Converts 8-bit unsigned ARGB interleaved pixels into 16-bit unsigned ARGB interleaved pixels.
 2. Changes the order of channels according to permuteMap
 3. Selects between the result pixel and the backgroundColor according to the bits in copyMask.
 
 permuteMap[i] = 0, 1, 2, or 3 to specify how we permute each channel.
 
 permuteMap[0] tells which channel in ARGB8888 will be used as the 1st channel (A) in the result ARGB16U.
 permuteMap[1] tells which channel in ARGB8888 will be used as the 2nd channel (R) in the result ARGB16U.
 permuteMap[2] tells which channel in ARGB8888 will be used as the 3rd channel (G) in the result ARGB16U.
 permuteMap[3] tells which channel in ARGB8888 will be used as the 4th channel (B) in the result ARGB16U.
 
 copyMask = _ _ _ _  ; 4 digit binary
 1000 tells if we want to use 1st channel in backgroundColor as the value of channel A in the result.
 0100 tells if we want to use 2nd channel in backgroundColor as the value of channel R in the result.
 0010 tells if we want to use 3rd channel in backgroundColor as the value of channel G in the result.
 0001 tells if we want to use 4th channel in backgroundColor as the value of channel B in the result.
 
 The per-pixel operation is:
 
 Pixel_8888 *srcPixel;
 Pixel_16U *destPixel;
 uint8_t result8;
 uint16_t result[4];
 uint8_t mask = 0x8;
 
 for( int i = 0; i < 4; i++ )
 {
 result8 = srcPixel[ permuteMap[i] ];
 result[i] = (result8 * 65535U + 127U) / 255U;
 if( mask & copyMask )
 result[i] = backgroundColor[i];
 mask = mask >> 1;
 }
 srcPixel += 4;
 
 destPixel[0] = result[0];
 destPixel[1] = result[1];
 destPixel[2] = result[2];
 destPixel[3] = result[3];
 destPixel += 4;
 
 Operands:
 ---------
 src : A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 dest : A pointer to vImage_Buffer that references 16-bit ARGB interleaved destination pixels.
 permuteMap : Values that can be used to switch the channel order as the above example.
 copyMask : A mask to choose between the result and backgroundColor.
 backgroundColor : A pointer to Pixel_ARGB_16U that references 16-bit ARGB values which can replace the result pixels with. Pixel_ARGB_16U backgroundColor = {alpha, red, green, blue};
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageInvalidParameter            Is returned when the values in permuteMap[i] is not one of 0, 1, 2, or 3.
 kvImageNullPointerArgument         Is returned when backgroundColorPtr is NULL.
 
 This function doesn't work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const uint16_t*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const uint16_t*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") byte[] permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const uint16_t*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );


/*
 vImageConvert_RGB16UToARGB8888
 
 This function does 3 things.
 1. Converts 16-bit unsigned RGB interleaved pixels into 8-bit unsigned ARGB interleaved pixels. (255 or A from backgroundColor will be used as A.)
 2. Changes the order of channels according to permuteMap.
 3. Selects between the result pixel and the backgroundColor according to the bits in copyMask.
 
 permuteMap[x] = 0, 1, or 2 to specify how we permute each channel.
 
 255 will be used as a default alpha value.
 permuteMap[0] tells which channel in 255RGB16U will be used as the 1st channel (A) in the result ARGB8888.
 permuteMap[1] tells which channel in 255RGB16U will be used as the 2nd channel (R) in the result ARGB8888.
 permuteMap[2] tells which channel in 255RGB16U will be used as the 3rd channel (G) in the result ARGB8888.
 permuteMap[3] tells which channel in 255RGB16U will be used as the 4th channel (B) in the result ARGB8888.
 
 copyMask = _ _ _ _  ; 4 digit binary
 1000 tells if we want to use 1st channel in backgroundColor which can be A in this function.
 0100 tells if we want to use 2nd channel in backgroundColor which can be R in this function.
 0010 tells if we want to use 3rd channel in backgroundColor which can be G in this function.
 0001 tells if we want to use 4th channel in backgroundColor which can be B in this function.
 
 The per-pixel operation is:
 
 Pixel_16U  *srcPixel;
 Pixel_8888 *destPixel;
 uint16_t   r16, g16, b16;
 uint8_t    result[4], a, r, g, b;
 uint8_t    mask = 0x8;
 
 r16 = srcPixel[0];
 g16 = srcPixel[1];
 b16 = srcPixel[2];
 srcPixel += 3;
 
 //Convert
 result[0] = 255;
 result[1] = (r16 * 255U + 32767U) / 65535U;
 result[2] = (g16 * 255U + 32767U) / 65535U;
 result[3] = (b16 * 255U + 32767U) / 65535U;
 
 //Permute
 a = result[permuteMap[0]];
 r = result[permuteMap[1]];
 g = result[permuteMap[2]];
 b = result[permuteMap[3]];
 
 //Select
 if( mask & copyMask )
 a = backgroundColor[0];
 mask = mask >> 1;
 if( mask & copyMask )
 r = backgroundColor[1];
 mask = mask >> 1;
 if( mask & copyMask )
 g = backgroundColor[2];
 mask = mask >> 1;
 if( mask & copyMask )
 b = backgroundColor[3];
 
 destPixel[0] = a;
 destPixel[1] = r;
 destPixel[2] = g;
 destPixel[3] = b;
 destPixel += 4;
 
 Operands:
 ---------
 src : A pointer to vImage_Buffer that references 16-bit RGB interleaved source pixels.
 dest : A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 permuteMap : Values that can be used to switch the channel order as the above example. permuteMap[0] is for A in the dest ARGB8888, permuteMap[1] is for R in the dest ARGB8888,  permuteMap[2] is for G in the dest ARGB8888, and  permuteMap[3] is for B in the dest ARGB8888.
 copyMask : A mask to choose between the result and backgroundColor.
 backgroudColor : A pointer to Pixel_8888 that references 8-bit ARGB values which can replace the result pixels with. Pixel_8888 backgroundColor = {alpha, red, green, blue};
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageInvalidParameter            Is returned when the values in permuteMap[i] is not one of 0, 1, 2, or 3.
 kvImageNullPointerArgument         Is returned when backgroundColorPtr is NULL.
 
 This function can work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGB16UToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_RGB16UToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_RGB16UToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") byte[] permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const uint8_t*") BytePointer backgroundColor, @Cast("vImage_Flags") long flags );


/*
 vImageConvert_ARGB8888ToRGB16U
 
 This function does 3 things.
 1. Converts 8-bit unsigned ARGB interleaved pixels into 16-bit unsigned RGB interleaved pixels.
 2. Changes the order of channels according to permuteMap.
 3. Selects between the result pixel and the backgroundColor according to the bits in copyMask.
 
 permuteMap[i] = 0, 1, 2, or 3 to specify how we permute each channel.
 
 permuteMap[0] tells which channel in ARGB8888 will be used as the 1st channel (R) in the result RGB16U.
 permuteMap[1] tells which channel in ARGB8888 will be used as the 2nd channel (G) in the result RGB16U.
 permuteMap[2] tells which channel in ARGB8888 will be used as the 3rd channel (B) in the result RGB16U.
 
 copyMask = _ _ _ _  ; 3 digit binary
 100 tells if we want to use 1st channel in backgroundColor as the value of channel R in the result.
 010 tells if we want to use 2nd channel in backgroundColor as the value of channel G in the result.
 001 tells if we want to use 3rd channel in backgroundColor as the value of channel B in the result.
 
 The per-pixel operation is:
 
 Pixel_8888 *srcPixel;
 Pixel_16U *destPixel;
 uint8_t result8, r8, g8, b8;
 uint16_t result[3];
 uint8_t mask = 0x4;
 
 //Permute
 r8 = srcPixel[permuteMap[0]];
 g8 = srcPixel[permuteMap[1]];
 b8 = srcPixel[permuteMap[2]];
 srcPixel += 4;
 
 //Convert
 result[0] = (r8 * 65535U + 127U) / 255U;
 result[1] = (g8 * 65535U + 127U) / 255U;
 result[2] = (b8 * 65535U + 127U) / 255U;
 
 //Select
 if( mask & copyMask )
 result[0] = backgroundColor[0];
 mask = mask >> 1;
 if( mask & copyMask )
 result[1] = backgroundColor[1];
 mask = mask >> 1;
 if( mask & copyMask )
 result[2] = backgroundColor[2];
 
 destPixel[0] = result[0];
 destPixel[1] = result[1];
 destPixel[2] = result[2];
 destPixel += 3;
 
 Operands:
 ---------
 src : A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 dest : A pointer to vImage_Buffer that references 16-bit RGB interleaved destination pixels.
 permuteMap : Values that can be used to switch the channel order as the above example. permuteMap[0] is for R in the dest ARGB8888,  permuteMap[1] is for G in the dest ARGB8888, and  permuteMap[2] is for B in the dest ARGB8888.
 copyMask : A mask to choose between the result and backgroundColor.
 backgroudColor : A pointer to Pixel_16U that references 16-bit ARGB values which can replace the result pixels with. Pixel_16U backgroundColor[3] = {red, green, blue};
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageInvalidParameter            Is returned when the values in permuteMap[i] is not one of 0, 1, 2, or 3.
 kvImageNullPointerArgument         Is returned when backgroundColorPtr is NULL.
 
 This function doesn't work in place.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToRGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const Pixel_16U*") ShortPointer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToRGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const Pixel_16U*") ShortBuffer backgroundColor, @Cast("vImage_Flags") long flags );
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToRGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") byte[] permuteMap, @Cast("uint8_t") byte copyMask, @Cast("const Pixel_16U*") short[] backgroundColor, @Cast("vImage_Flags") long flags );


/*
 vImageByteSwap_Planar16U
 
 This function does byteswap 16-bit pixel.
 
 Operands:
 ---------
 src  : A pointer to vImage_Buffer that references 16-bit source pixels.
 dest : A pointer to vImage_Buffer that references 16-bit destination pixels.
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 
 This function can work in place.
 */

public static native @Cast("vImage_Error") long vImageByteSwap_Planar16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);



/*
 vImageFlatten_ARGB8888
 
 This function does a flattening operation on ARGB8888.
 A flattening operation is an alpha composite against a solid background color.
 
 The per-pixel operation is:
 
 resultAlpha = (pixelAlpha * 255 + (255 - pixelAlpha) * backgroundAlpha + 127) / 255
 if(isImagePremultiplied)
 {
 resultColor = (pixelColor * 255 + (255 - pixelAlpha) * backgroundColor + 127) / 255
 }
 else
 {
 resultColor = (pixelColor * pixelAlpha + (255 - pixelAlpha) * backgroundColor + 127) / 255
 }
 
 Operands:
 ---------
 src  : A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 dest : A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 backgroudColorPtr : A pointer to Pixel_8888 that references 8-bit premultiplied ARGB background color.
 isImagePremultiplied : True means input colors are premultiplied. False means input colors are not premultiplied.
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageNullPointerArgument         Is returned when argbBackgroundColorPtr is NULL.
 
 This function can work in place.
 */

public static native @Cast("vImage_Error") long vImageFlatten_ARGB8888(@Const vImage_Buffer argbSrc, @Const vImage_Buffer argbDst, @Cast("const uint8_t*") BytePointer argbBackgroundColorPtr, @Cast("bool") boolean isImagePremultiplied, @Cast("vImage_Flags") long flags);

/*
 vImageFlatten_RGBA8888
 
 This function does flattening operation on RGBA8888.
 A flattening operation is an alpha composite against a solid background color.
 
 The per-pixel operation is:
 
 resultAlpha = (pixelAlpha * 255 + (255 - pixelAlpha) * backgroundAlpha + 127) / 255
 if(isImagePremultiplied)
 {
 resultColor = (pixelColor * 255 + (255 - pixelAlpha) * backgroundColor + 127) / 255
 }
 else
 {
 resultColor = (pixelColor * pixelAlpha + (255 - pixelAlpha) * backgroundColor + 127) / 255
 }
 
 Operands:
 ---------
 src  : A pointer to vImage_Buffer that references 8-bit RGBA interleaved source pixels.
 dest : A pointer to vImage_Buffer that references 8-bit RGBA interleaved destination pixels.
 backgroudColorPtr : A pointer to Pixel_8888 that references 8-bit premultiplied RGBA background color.
 isImagePremultiplied : True means input colors are premultiplied. False means input colors are not premultiplied.
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageNullPointerArgument         Is returned when rgbaBackgroundColorPtr is NULL.
 
 This function can work in place.
 BGRA format can be used as well.
 */

public static native @Cast("vImage_Error") long vImageFlatten_RGBA8888(@Const vImage_Buffer rgbaSrc, @Const vImage_Buffer rgbaDst, @Cast("const uint8_t*") BytePointer rgbaBackgroundColorPtr, @Cast("bool") boolean isImagePremultiplied, @Cast("vImage_Flags") long flags);

/*
 vImageFlatten_ARGB16U
 
 This function does flattening operation on ARGB16U.
 A flattening operation is an alpha composite against a solid background color.
 
 The per-pixel operation is:
 
 resultAlpha = (pixelAlpha * 65535 + (65535 - pixelAlpha) * backgroundAlpha + 32767) / 65535
 if(isImagePremultiplied)
 {
 resultColor = (pixelColor * 65535 + (65535 - pixelAlpha) * backgroundColor + 32767) / 65535
 }
 else
 {
 resultColor = (pixelColor * pixelAlpha + (65535 - pixelAlpha) * backgroundColor + 32767) / 65535
 }
 
 Operands:
 ---------
 src  : A pointer to vImage_Buffer that references 16-bit ARGB interleaved source pixels.
 dest : A pointer to vImage_Buffer that references 16-bit ARGB interleaved destination pixels.
 backgroudColorPtr : A pointer to Pixel_ARGB_16U that references 16-bit ARGB premultiplied background color.
 isImagePremultiplied : True means input colors are premultiplied. False means input colors are not premultiplied.
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageNullPointerArgument         Is returned when argbBackgroundColorPtr is NULL.
 
 This function can work in place.
 */

public static native @Cast("vImage_Error") long vImageFlatten_ARGB16U(@Const vImage_Buffer argbSrc, @Const vImage_Buffer argbDst, @Cast("const uint16_t*") ShortPointer argbBackgroundColorPtr, @Cast("bool") boolean isImagePremultiplied, @Cast("vImage_Flags") long flags);

/*
 vImageFlatten_RGBA16U
 
 This function does flattening operation on RGBA16U.
 A flattening operation is an alpha composite against a solid background color.
 
 The per-pixel operation is:
 
 resultAlpha = (pixelAlpha * 65535 + (65535 - pixelAlpha) * backgroundAlpha + 32767) / 65535
 if(isImagePremultiplied)
 {
 resultColor = (pixelColor * 65535 + (65535 - pixelAlpha) * backgroundColor + 32767) / 65535
 }
 else
 {
 resultColor = (pixelColor * pixelAlpha + (65535 - pixelAlpha) * backgroundColor + 32767) / 65535
 }
 
 Operands:
 ---------
 src  : A pointer to vImage_Buffer that references 16-bit RGBA interleaved source pixels.
 dest : A pointer to vImage_Buffer that references 16-bit RGBA interleaved destination pixels.
 backgroudColorPtr : A pointer to Pixel_ARGB_16U that references 16-bit RGBA premultiplied background color.
 isImagePremultiplied : True means input colors are premultiplied. False means input colors are not premultiplied.
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageNullPointerArgument         Is returned when rgbaBackgroundColorPtr is NULL.
 
 This function can work in place.
 BGRA format can be used as well.
 */

public static native @Cast("vImage_Error") long vImageFlatten_RGBA16U(@Const vImage_Buffer rgbaSrc, @Const vImage_Buffer rgbaDst, @Cast("const uint16_t*") ShortPointer rgbaBackgroundColorPtr, @Cast("bool") boolean isImagePremultiplied, @Cast("vImage_Flags") long flags);



/*
 vImageFlatten_ARGB16Q12
 
 This function does flattening operation on ARGB16Q12.
 A flattening operation is an alpha composite against a solid background color.
 
 The per-pixel operation is:
 
 pixelAlpha = CLAMP( 0, pixelAlpha, 4096);
 resultAlpha = (pixelAlpha * 4096 + (4096 - pixelAlpha) * backgroundAlpha + 2048) >> 12;
 if(isImagePremultiplied)
 {
 resultColor = (pixelColor * 4096 + (4096 - pixelAlpha) * backgroundColor + 2048) >> 12
 }
 else
 {
 resultColor = (pixelColor * pixelAlpha + (4096 - pixelAlpha) * backgroundColor + 2048) >> 12
 }
 
 Whether the function attempts to clamp the case when the |resultColor| >= 8.0 is undefined.
 
 Operands:
 ---------
 src  : A pointer to vImage_Buffer that references 16Q12 ARGB interleaved source pixels.
 dest : A pointer to vImage_Buffer that references 16Q12 ARGB interleaved destination pixels.
 backgroudColorPtr : A pointer to Pixel_ARGB_16S that references 16-bit ARGB16Q12 premultiplied background color.
 isImagePremultiplied : True means input colors are premultiplied. False means input colors are not premultiplied.
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageNullPointerArgument         Is returned when argbBackgroundColorPtr is NULL.
 
 This function can work in place. Pixels are assumed to be in native-endian byte order.
 */
public static native @Cast("vImage_Error") long vImageFlatten_ARGB16Q12(@Const vImage_Buffer argbSrc, @Const vImage_Buffer argbDst, @Cast("const int16_t*") ShortPointer argbBackgroundColorPtr, @Cast("bool") boolean isImagePremultiplied, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageFlatten_RGBA16Q12(@Const vImage_Buffer argbSrc, @Const vImage_Buffer argbDst, @Cast("const int16_t*") ShortPointer argbBackgroundColorPtr, @Cast("bool") boolean isImagePremultiplied, @Cast("vImage_Flags") long flags);



/*
 vImageFlatten_ARGBFFFF
 
 This function does flattening operation on ARGBFFFF.
 A flattening operation is an alpha composite against a solid background color.
 
 The per-pixel operation is:
 
 resultAlpha = pixelAlpha + (1 - pixelAlpha) * backgroundAlpha
 if(isImagePremultiplied)
 {
 resultColor = pixelColor + (1 - pixelAlpha) * backgroundColor
 }
 else
 {
 resultColor = pixelColor * pixelAlpha + (1 - pixelAlpha) * backgroundColor
 }
 
 Operands:
 ---------
 src  : A pointer to vImage_Buffer that references float ARGB interleaved source pixels.
 dest : A pointer to vImage_Buffer that references float ARGB interleaved destination pixels.
 backgroudColorPtr : A pointer to Pixel_FFFF that references float premultiplied ARGB background color.
 isImagePremultiplied : True means input colors are premultiplied. False means input colors are not premultiplied.
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageNullPointerArgument         Is returned when argbBackgroundColorPtr is NULL.
 
 This function can work in place.
 */

public static native @Cast("vImage_Error") long vImageFlatten_ARGBFFFF(@Const vImage_Buffer argbSrc, @Const vImage_Buffer argbDst, @Cast("const float*") FloatPointer argbBackgroundColorPtr, @Cast("bool") boolean isImagePremultiplied, @Cast("vImage_Flags") long flags);

/*
 vImageFlatten_RGBAFFFF
 
 This function does flattening operation on RGBAFFFF.
 A flattening operation is an alpha composite against a solid background color.
 
 The per-pixel operation is:
 
 resultAlpha = pixelAlpha + (1 - pixelAlpha) * backgroundAlpha
 if(isImagePremultiplied)
 {
 resultColor = pixelColor + (1 - pixelAlpha) * backgroundColor
 }
 else
 {
 resultColor = pixelColor * pixelAlpha + (1 - pixelAlpha) * backgroundColor
 }
 
 Operands:
 ---------
 src  : A pointer to vImage_Buffer that references float RGBA interleaved source pixels.
 dest : A pointer to vImage_Buffer that references float RGBA interleaved destination pixels.
 backgroudColorPtr : A pointer to Pixel_FFFF that references float RGBA premultiplied background color.
 isImagePremultiplied : True means input colors are premultiplied. False means input colors are not premultiplied.
 
 Flags:
 ------
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 Return Value:
 -------------
 kvImageNoError                     Is returned when there was no error.
 kvImageRoiLargerThanInputBuffer    Is returned when the height and width of the source are less than the height and width of the destination buffer, respectively.
 kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 kvImageNullPointerArgument         Is returned when rgbaBackgroundColorPtr is NULL.
 
 This function can work in place.
 BGRA format can be used as well.
 */

public static native @Cast("vImage_Error") long vImageFlatten_RGBAFFFF(@Const vImage_Buffer rgbaSrc, @Const vImage_Buffer rgbaDst, @Cast("const float*") FloatPointer rgbaBackgroundColorPtr, @Cast("bool") boolean isImagePremultiplied, @Cast("vImage_Flags") long flags);

/*
 vImageConvert_Planar1toPlanar8
 vImageConvert_Planar2toPlanar8
 vImageConvert_Planar4toPlanar8
 
 These functions convert from 1-, 2-, or 4-bit per pixel to 8-bit per pixel
 planar formats.
 
 Function Arguments:
 -------------------
 src         Pointer to the source vImage_Buffer object.  Because the
 source pixel format is smaller than a byte, there are
 multiple pixels in each byte of the data buffer.  These
 pixels are interpreted as being in big endian order (i.e.
 the low-indexed pixel is in the high-order bits of the
 byte).
 
 Sub-byte indexing of scanlines is unsupported, because the
 data and rowBytes fields of the buffer are specified in
 whole bytes.
 
 Widths, however, are measured in pixels, so a scanline may
 end in the middle of a byte.  If this occurs, the contents
 of any unused bits of the final byte are ignored.
 
 dest        Pointer to the destination vImage_Buffer object.
 
 flags       The following flags are allowed:
 
 kvImageDoNotTile - disables internal threading.  You may
 want to specify this if you have your own threading
 scheme and need to avoid interference.
 
 kvImageGetTempBufferSize - does no work and returns zero,
 as these functions do not use temp buffers.
 
 Operation:
 ----------
 For each pixel in the destination image, the resulting value is the
 corresponding pixel value from the source image multiplied by 255, 85,
 or 17 (for Planar1, Planar2, or Planar4, respectively).
 
 
 Return values:
 --------------
 kvImageNoError                     Success
 kvImageUnknownFlagsBit             No work was done because an unknown bit was
 set in the flags parameter.
 kvImageRoiLargerThanInputBuffer    No work was done because the source
 image isn't large enough to cover the
 destination image.
 
 These functions do not work in place.
 */

public static native @Cast("vImage_Error") long vImageConvert_Planar1toPlanar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Planar2toPlanar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Planar4toPlanar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const vImage_Flags") long flags);

/*
 vImageConvert_Indexed1toPlanar8
 vImageConvert_Indexed2toPlanar8
 vImageConvert_Indexed4toPlanar8
 
 These functions convert from 1-, 2-, or 4-bit per pixel indexed to 8-bit
 per pixel planar format.
 
 Function Arguments:
 -------------------
 src         Pointer to the source vImage_Buffer object.  Because the
 source pixel format is smaller than a byte, there are
 multiple pixels in each byte of the data buffer.  These
 pixels are interpreted as being in big endian order (i.e.
 the low-indexed pixel is in the high-order bits of the
 byte).
 
 Sub-byte indexing of scanlines is unsupported, because the
 data and rowBytes fields of the buffer are specified in
 whole bytes.
 
 Widths, however, are measured in pixels, so a scanline may
 end in the middle of a byte.  If this occurs, the contents
 of any unused bits of the final byte are ignored.
 
 dest        Pointer to the destination vImage_Buffer object.
 
 colors      Color table in which to lookup pixel values for destination
 image.
 
 flags       The following flags are allowed:
 
 kvImageDoNotTile - disables internal threading.  You may
 want to specify this if you have your own threading
 scheme and need to avoid interference.
 
 kvImageGetTempBufferSize - does no work and returns zero,
 as these functions do not use temp buffers.
 
 Operation:
 ----------
 For each pixel in the destination image, the value is looked up in the
 color table using the corresponding pixel value from the source image
 as an index.
 
 Return values:
 --------------
 kvImageNoError                     Success
 kvImageUnknownFlagsBit             No work was done because an unknown bit was
 set in the flags parameter.
 kvImageRoiLargerThanInputBuffer    No work was done because the source
 image isn't large enough to cover the
 destination image.
 
 These functions do not work in place.
 */


public static native @Cast("vImage_Error") long vImageConvert_Indexed1toPlanar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const Pixel_8*") BytePointer colors, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Indexed2toPlanar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const Pixel_8*") BytePointer colors, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Indexed4toPlanar8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const Pixel_8*") BytePointer colors, @Cast("const vImage_Flags") long flags);

/*
 vImageConvert_Planar8toPlanar1
 vImageConvert_Planar8toPlanar2
 vImageConvert_Planar8toPlanar4
 
 These functions convert from 8-bit per pixel to 1-, 2-, or 4-bit per pixel
 planar formats.
 
 Function Arguments:
 -------------------
 src         Pointer to the source vImage_Buffer object
 
 dest        Pointer to the destination vImage_Buffer object.  Because
 the destination pixel format is smaller than a byte, there
 are multiple pixels in each byte of the data buffer.  These
 pixels are interpreted as being in big endian order (i.e.
 the low-indexed pixel is in the high-order bits of the
 byte).
 
 Sub-byte indexing of scanlines is unsupported, because the
 data and rowBytes fields of the buffer are specified in
 whole bytes.
 
 Widths, however, are measured in pixels, so a scanline may
 end in the middle of a byte.  If this occurs, the contents
 of any unused bits of the final byte are unspecified.
 
 tempBuffer  Pointer to temporary buffer for the routine to use for
 scratch space.  If non-NULL, the buffer must be at least
 as large as the value returned by calling this function
 with the kvImageGetTempBufferSize flag.  If NULL, this
 function will still work, but may allocate and free a
 scratch buffer internally.
 
 dither      Type of dithering to apply to the image, if any.  Options:
 
 kvImageConvert_DitherNone - apply no dithering; input values
 are rounded to the nearest value representable in the
 destination format.
 kvImageConvert_DitherOrdered - pre-computed blue noise is
 added to the image before rounding to the values in
 the destination format.  The offset into this blue
 noise is randomized per-call to avoid visible artifacts
 if you do your own tiling or call the function on
 sequential frames of video.
 kvImageConvert_DitherOrderedReproducible - pre-computed
 blue noise is added to the image before rounding to the
 values in the destination format.  The offset into the
 blue noise is the same for every call to allow users
 to get reproducible results.
 kvImageConvert_DitherFloydSteinberg - Floyd-Steinberg
 dithering is applied to the image.
 kvImageConvert_DitherAtkinson - Atkinson dithering is
 applied to the image, for the old timers.
 
 The ordered dither methods may be further influenced by shaping the
 distribution of the noise using the gaussian and uniform options below.
 These options are OR-ed with kvImageConvert_DitherOrdered / kvImageCon-
 vert_DitherOrderedReproducible:
 
 kvImageConvert_OrderedGaussianBlue - when using an ordered dither
 pattern, distribute the noise according to a gaussian
 distribution. This generally gives more pleasing images --
 less noisy and perhaps a little more saturated -- but color
 fidelity can suffer. Its effect is between kvImageConvert_DitherNone
 and kvImageConvert_DitherOrdered | kvImageConvert_DitherUniform.
 This is the default for kvImageConvert_DitherOrdered and
 kvImageConvert_DitherOrderedReproducible.
 
 kvImageConvert_OrderedUniformBlue - when using an ordered dither
 pattern, distribute the noise uniformly. This generally gives
 best color fidelity, but the resulting image is noisier and more
 obviously dithered. This is usually the best choice when low
 bitdepth content is drawn next to high bitdepth content and in other
 circumstances where subtle changes to color arising from the conversion
 could be easily noticed. It may be a poor choice when the image
 is likely to be enlarged -- this would cause the noise to become
 more evident-- and for very flat / synthetic content with little
 inherent noise. The enlargement problem may be avoided by enlarging
 first at high bitdepth, then convert to lower bitdepth.
 
 To clarify: "Blue" noise is not blue, nor does it operate solely on the blue
 color channel. Blue noise is monochrome noise that is added to all color
 channels equally. The name arises from blue light, which has a higher frequency
 than other colors of visible light. Thus, blue noise is noise which is
 weighted heavily towards high frequencies. Low frequency noise tends to have
 visible shapes in it that would become apparent in an image if it was added in,
 so it is excluded from the dither pattern.
 
 flags       The following flags are allowed:
 
 kvImageDoNotTile - disables internal threading.  You may
 want to specify this if you have your own threading
 scheme and need to avoid interference.
 
 kvImageGetTempBufferSize - does no work, but returns the
 required size of tempBuffer for this routine.
 
 Operation:
 ----------
 For a brief description of each dither method, see dither above.
 
 Notes:
 The results for Floyd-Steinberg and Atkinson dithering methods depend on the results
 of pixels around each result pixel. Consequently, these methods do not tile well. (Tiling
 can cause visible artifacts at tile boundaries because residuals are not propagated to the
 next tile in a manner consistent with how it is propagated within a tile.) You should pass
 the entire image in a single call for good results with Atkinson and Floyd-Steinberg.
 
 The ordered dithering method is suitable for tiled / multithreaded / scanline-at-a-time
 execution. In addition to being spatially random, the ordered dithering pattern is also
 temporally random. This is necessary to prevent stripes when it is invoked scanline-at-a-time.
 Temporal randomness also prevents visible walking of the dither pattern across the image
 when used for video. Because it is temporally random, results from this filter are not
 reproducible.
 
 To get reproducible results with ordered dithering, use the OrderedReproducible
 dithering attribute.
 
 The dither none option will produce reproducible results in all calling contexts, but
 is prone to obvious banding in images, especially in regions of an image with a smooth
 gradient.
 
 Return values:
 --------------
 kvImageNoError                     Success
 kvImageUnknownFlagsBit             No work was done because an unknown bit was
 set in the flags parameter.
 kvImageRoiLargerThanInputBuffer    No work was done because the source
 image isn't large enough to cover the
 destination image.
 kvImageInvalidParameter            An unrecognized or unsupported value was
 specified for dither.
 
 These functions do not work in place.
 */

/* See description above for the meaning of these contants */
/** enum  */
public static final int
    kvImageConvert_DitherNone                   = 0,         /* __OSX_AVAILABLE_STARTING(__MAC_10_9, __IPHONE_7_0) */
    kvImageConvert_DitherOrdered                = 1,         /* __OSX_AVAILABLE_STARTING(__MAC_10_9, __IPHONE_7_0) */
    kvImageConvert_DitherOrderedReproducible    = 2,         /* __OSX_AVAILABLE_STARTING(__MAC_10_9, __IPHONE_7_0) */
    kvImageConvert_DitherFloydSteinberg         = 3,         /* __OSX_AVAILABLE_STARTING(__MAC_10_9, __IPHONE_7_0) */
    kvImageConvert_DitherAtkinson               = 4,         /* __OSX_AVAILABLE_STARTING(__MAC_10_9, __IPHONE_7_0) */
    
    /* Gaussian vs. uniform distribution for ordered dithering patterns. By default ordered dithering uses gaussian blue noise. */
    kvImageConvert_OrderedGaussianBlue          = 0,         /* __OSX_AVAILABLE_STARTING(__MAC_10_9, __IPHONE_7_0) */
    kvImageConvert_OrderedUniformBlue           = (1<<28),   /* __OSX_AVAILABLE_STARTING(__MAC_10_9, __IPHONE_7_0) */
    kvImageConvert_OrderedNoiseShapeMask        = (0xf<<28); /* __OSX_AVAILABLE_STARTING(__MAC_10_9, __IPHONE_7_0) */

public static native @Cast("vImage_Error") long vImageConvert_Planar8toPlanar1(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, int dither, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Planar8toPlanar2(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, int dither, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Planar8toPlanar4(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, int dither, @Cast("const vImage_Flags") long flags);

/*
 vImageConvert_Planar8toIndexed1
 vImageConvert_Planar8toIndexed2
 vImageConvert_Planar8toIndexed4
 
 These functions convert from 8-bit per pixel planar to 1-, 2-, or 4-bit
 per pixel indexed formats.
 
 Function Arguments:
 -------------------
 src         Pointer to the source vImage_Buffer object
 
 dest        Pointer to the destination vImage_Buffer object.  Because
 the destination pixel format is smaller than a byte, there
 are multiple pixels in each byte of the data buffer.  These
 pixels are interpreted as being in big endian order (i.e.
 the low-indexed pixel is in the high-order bits of the
 byte).
 
 Sub-byte indexing of scanlines is unsupported, because the
 data and rowBytes fields of the buffer are specified in
 whole bytes.
 
 Widths, however, are measured in pixels, so a scanline may
 end in the middle of a byte.  If this occurs, the contents
 of any unused bits of the final byte are unspecified.
 
 tempBuffer  Pointer to temporary buffer for the routine to use for
 scratch space.  If non-NULL, the buffer must be at least
 as large as the value returned by calling this function
 with the kvImageGetTempBufferSize flag.  If NULL, this
 function will still work, but may allocate and free a
 scratch buffer internally.
 
 colors      Color table to use for the destination.
 
 If you want us to compute a color table for you, initialize
 the table to all zeros:
 
 Pixel_8 colors[4] = { 0 };
 vImageConvert_Planar8toIndexed2(src, dest, colors, dither, flags);
 
 We will then compute an appropriate color table for the
 image before performing the conversion.
 
 dither      Type of dithering to apply to the image, if any.  See the
 discussion for vImageConvert_Planar8toPlanar1 for more
 details.
 
 flags       The following flags are allowed:
 
 kvImageDoNotTile - disables internal threading.  You may
 want to specify this if you have your own threading
 scheme and need to avoid interference.
 
 kvImageGetTempBufferSize - does no work, but returns the
 required size of tempBuffer for this routine.
 
 Operation:
 ----------
 See dither above.
 
 Return values:
 --------------
 kvImageNoError                     Success
 kvImageUnknownFlagsBit             No work was done because an unknown bit was
 set in the flags parameter.
 kvImageRoiLargerThanInputBuffer    No work was done because the source
 image isn't large enough to cover the
 destination image.
 kvImageInvalidParameter            A non-zero color table was not ordered
 correctly, or an unrecognized or
 unsupported value was specified for dither.
 
 These functions do not work in place.
 */

public static native @Cast("vImage_Error") long vImageConvert_Planar8toIndexed1(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("Pixel_8*") BytePointer colors, int dither, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Planar8toIndexed2(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("Pixel_8*") BytePointer colors, int dither, @Cast("const vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Planar8toIndexed4(@Const vImage_Buffer src, @Const vImage_Buffer dest, Pointer tempBuffer, @Cast("Pixel_8*") BytePointer colors, int dither, @Cast("const vImage_Flags") long flags);

/*  vImageConvert_8to16Q12
 vImageConvert_RGB888toPlanar16Q12
 vImageConvert_ARGB8888toPlanar16Q12
 
 All three functions convert 8-bit pixel format to 16-bit format with 12
 fractional bits.  The conversion is performed as follows:
 
 uint16_t dest = ((src << 12) + 127)/255;
 
 Source pixel values of 0 are mapped to 0, and source pixel values of 255
 are mapped to 0x1000 (4096).  No larger values are produced by this
 conversion, which provides some headroom to help subsequent operations
 avoid overflow or clipping.
 
 vImageConvert_8to16Q12 takes a single source buffer and a single
 destination buffer and simply does the conversion.
 
 vImageConvert_RGB888toPlanar16Q12 has three destination buffers, and
 de-interleaves while it converts.
 
 vImageConvert_ARGB8888toPlanar16Q12 takes four destination buffers, and
 also de-interleaves.  Any channel order may be handled by the latter two
 functions by permuting the order in which the destination buffers are
 passed as arguments.
 
 
 
 The only supported flags are:
 
 kvImageDoNotTile            Turns off internal multithreading. You may
 wish to do this if you have your own
 multithreading scheme to avoid having the
 two interfere with one another.
 
 kvImageGetTempBufferSize    Returns zero, as the routine does not use
 a temp buffer.
 
 Passing any other flag will result in no work being done and an error
 code being returned.
 
 Return Value:
 -------------
 kvImageNoError                  is returned when there was no error.
 kvImageBufferSizeMismatch       the destination buffers do not have the
 same size as each other
 kvImageRoiLargerThanInputBuffer The destination buffers are larger than the
 source buffer.
 kvImageUnknownFlagsBit          is returned when there is a unknown flag.
 
 This function will not operate in place.
 */

public static native @Cast("vImage_Error") long vImageConvert_8to16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGB888toPlanar16Q12(@Const vImage_Buffer src, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888toPlanar16Q12(@Const vImage_Buffer src, @Const vImage_Buffer alpha, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Cast("vImage_Flags") long flags);

/*  vImageConvert_16Q12to8
 vImageConvert_Planar16Q12toRGB888
 vImageConvert_Planar16Q12toARGB8888
 
 All three functions convert 16-bit format with 12 fractional bits to 8-bit.
 The conversion is performed as follows:
 
 uint8_t dest = clamp(src, 0, 4096)*255 + 2048 >> 12
 
 Source pixel values of 0 are mapped to 0, and source pixel values of 4088
 or greater are mapped to 255.
 
 vImageConvert_Planar16Q12toRGB888 and vImageConvert_Planar16Q12toARGB8888
 interleave data from three or four buffers respectively while performing
 the conversion.
 
 The only supported flags are:
 
 kvImageDoNotTile            Turns off internal multithreading. You may
 wish to do this if you have your own
 multithreading scheme to avoid having the
 two interfere with one another.
 
 kvImageGetTempBufferSize    Returns zero, as the routine does not use
 a temp buffer.
 
 Passing any other flag will result in no work being done and an error
 code being returned.
 
 Return Value:
 -------------
 kvImageNoError                  is returned when there was no error.
 kvImageBufferSizeMismatch       the destination buffers do not have the
 same size as each other
 kvImageRoiLargerThanInputBuffer The destination buffers are larger than the
 source buffer.
 kvImageUnknownFlagsBit          is returned when there is a unknown flag.
 
 This function will not operate in place.
 */

public static native @Cast("vImage_Error") long vImageConvert_16Q12to8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Planar16Q12toRGB888(@Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Planar16Q12toARGB8888(@Const vImage_Buffer alpha, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);


/**
 \function vImageConvert_16Q12to16F
 \abstract Convert 16Q12 (16-bit format with 12 fractional bits) to half-precision floating-point.
 
 \discussion Source pixel values of 0 are mapped to 0, and source pixel values of (Pixel_16Q12) 4096
 are mapped to (Pixel_16F) 1.0f.
 \note Works in place provided that src->data == dest->data && src->rowBytes == dest->rowBytes.
 
 @param src              The input image.
 @param dest             A pointer to a preallocated vImage_Buffer to receive the resulting image.
 
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 \p kvImageGetTempBufferSize    Returns zero, as the routine does not use a temp buffer.
 
 @return kvImageNoError                      There was no error.
 @return kvImageBufferSizeMismatch           The destination buffers do not have the
 same size as each other
 @return kvImageRoiLargerThanInputBuffer     The destination buffers are larger than the
 source buffer.
 @return kvImageUnknownFlagsBit              Unknown flag(s) provided.
 */
public static native @Cast("vImage_Error") long vImageConvert_16Q12to16F(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_16Q12toRGB16F
 \abstract Convert 16Q12 and interleave (16-bit format with 12 fractional bits) to half-precision floating-point.
 
 \discussion Interleaves data from three source buffers while performing the format conversion.
 Source pixel values of 0 are mapped to 0, and source pixel values of (Pixel_16Q12) 4096
 are mapped to (Pixel_16F) 1.0f.
 \note Does not work in place.
 
 @param red              The red channel of the input image.
 @param green            The green channel of the input image.
 @param blue             The blue channel of the input image.
 @param dest             A pointer to a preallocated vImage_Buffer to receive the resulting chunky image.
 
 @param flags
 \p kvImageDoNotTile             Disables internal multithreading, if any.
 \p kvImageGetTempBufferSize     Returns zero, as the routine does not use a temp buffer.
 
 @return kvImageNoError                      There was no error.
 @return kvImageBufferSizeMismatch           The destination buffers do not have the
 same size as each other
 @return kvImageRoiLargerThanInputBuffer     The destination buffers are larger than the
 source buffer.
 @return kvImageUnknownFlagsBit              Unknown flag(s) provided.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar16Q12toRGB16F(@Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_Planar16Q12toARGB16F
 \abstract Convert and interleave 16Q12 (16-bit format with 12 fractional bits) to half-precision floating-point.
 
 \discussion Interleaves data from four source buffers while performing the format conversion.
 Source pixel values of 0 are mapped to 0, and source pixel values of (Pixel_16Q12) 4096
 are mapped to (Pixel_16F) 1.0f.
 \note Does not work in place.
 
 @param alpha            The alpha channel of the input image.
 @param red              The red channel of the input image.
 @param green            The green channel of the input image.
 @param blue             The blue channel of the input image.
 @param dest             A pointer to a preallocated vImage_Buffer to receive the resulting chunky image.
 
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 \p kvImageGetTempBufferSize    Returns zero, as the routine does not use a temp buffer.
 
 @return kvImageNoError                      There was no error.
 @return kvImageBufferSizeMismatch           The destination buffers do not have the
 same size as each other
 @return kvImageRoiLargerThanInputBuffer     The destination buffers are larger than the
 source buffer.
 @return kvImageUnknownFlagsBit              Unknown flag(s) provided.
 */
public static native @Cast("vImage_Error") long vImageConvert_Planar16Q12toARGB16F(@Const vImage_Buffer alpha, @Const vImage_Buffer red, @Const vImage_Buffer green, @Const vImage_Buffer blue, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_16Fto16Q12
 \abstract Convert half-precision floating-point to 16Q12 (16-bit format with 12 fractional bits).
 
 \discussion Source pixel values of 0 are mapped to 0, and source pixel values of (Pixel_16F) 1.0f
 are mapped to (Pixel_16Q12) 4096.
 \note Works in place provided that src->data == dest->data && src->rowBytes == dest->rowBytes.
 
 @param src              The input image.
 @param dest             A pointer to a preallocated vImage_Buffer to receive the resulting image.
 
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 \p kvImageGetTempBufferSize    Returns zero, as the routine does not use a temp buffer.
 
 @return kvImageNoError                      There was no error.
 @return kvImageBufferSizeMismatch           The destination buffers do not have the
 same size as each other
 @return kvImageRoiLargerThanInputBuffer     The destination buffers are larger than the
 source buffer.
 @return kvImageUnknownFlagsBit              Unknown flag(s) provided.
 */
public static native @Cast("vImage_Error") long vImageConvert_16Fto16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);


/*
 vImageConvert_16Q12toF
 vImageConvert_Fto16Q12
 
 Convert 16-bit format with 12 fractional bits to floating-point.
 The conversion is performed as follows:
 
 float vImageConvert_16Q12toF_result = sample_16Q12 / 4096.0f
 Pixel_16Q12 vImageConvert_Fto16Q12_result = CLAMP( -32768, lrintf(sample_float * 4096.0f), 32767)
 
 Source pixel values of 0 are mapped to 0, and source pixel values of (Pixel_16Q12) 4096
 is mapped to (Pixel_F) 1.0f.
 
 The only supported flags are:
 
 kvImageDoNotTile            Turns off internal multithreading. You may
 wish to do this if you have your own
 multithreading scheme to avoid having the
 two interfere with one another.
 
 kvImageGetTempBufferSize    Returns zero, as the routine does not use
 a temp buffer. Does no work
 
 Passing any other flag will result in no work being done and an error
 code being returned.
 
 Return Value:
 -------------
 kvImageNoError                  is returned when there was no error.
 kvImageRoiLargerThanInputBuffer one or more source buffers is smaller than the destination buffer.
 kvImageUnknownFlagsBit          is returned when there is a unknown flag.
 
 These functions will operate in place provided that src->data == dest->data && src->rowBytes == dest->rowBytes.
 
 */

public static native @Cast("vImage_Error") long vImageConvert_16Q12toF(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_Fto16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);

/*
 vImageConvert_16Q12to16U
 vImageConvert_16Uto16Q12
 
 Convert 16-bit format with 12 fractional bits to floating-point.
 The conversion is performed as follows:
 
 Pixel_16U vImageConvert_16Q12to16U_result = CLAMP( 0, (sample_16Q12 * 65535 + 2048) >> 12, 65535 )
 Pixel_16Q12 vImageConvert_16Uto16Q12_result = (sample_16U * 4096 + 32767) / 65535;
 
 Source pixel values of 0 are mapped to 0, and source pixel values of (Pixel_16Q12) 4096
 is mapped to (Pixel_16U) 65535.
 
 The only supported flags are:
 
 kvImageDoNotTile            Turns off internal multithreading. You may
 wish to do this if you have your own
 multithreading scheme to avoid having the
 two interfere with one another.
 
 kvImageGetTempBufferSize    Returns zero, as the routine does not use
 a temp buffer. Does no work
 
 Passing any other flag will result in no work being done and an error
 code being returned.
 
 Return Value:
 -------------
 kvImageNoError                  is returned when there was no error.
 kvImageRoiLargerThanInputBuffer one or more source buffers is smaller than the destination buffer.
 kvImageUnknownFlagsBit          is returned when there is a unknown flag.
 
 These functions will operate in place provided that src->data == dest->data && src->rowBytes == dest->rowBytes.
 
 */

public static native @Cast("vImage_Error") long vImageConvert_16Q12to16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_16Uto16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("vImage_Flags") long flags);


/*
 
 YpCbCr image formats:
 =====================
 Some details about video formats are provided below to provide some context for interpreting parameters passed to YpCbCr conversion functions.
 
 Luminance and Chrominance
 -------------------------
 Luminance is the brightness in an image. An example might be the image visible on a black and white television. Luminance (Y, Y' or Yp)
 is defined as a weighted sum of the color components, usually weighted according to the relative ability of red, green and blue to cause
 perceived brightness changes in an image. For example for ITU-Recommendation BT.709 images, the Y component is given as:
 
 Y = 0.2126*R + 0.7152*G + 0.0722*B
 
 Chrominance (Cb and Cr) is the correction applied to the luminance to add color information. For ITU-R BT.709 they would be:
 
 Cb  = 0.5389*(B-Y)
 Cr  = 0.6350*(R-Y)
 
 Together, these can be written as an invertible 3x3 color matrix that converts {R,G,B} to {Yp, Cb, Cr}.
 
 Since chrominance is calculated as the difference between two unsigned values, it itself is signed. Typically, a large bias is added to
 the chrominance value when it is encoded as an unsigned integer to make negative values representable. For example, 8-bit chrominance
 values typically have an implicit +128 in them. To convert a full range 8-bit chroma value to an unbiased floating point representation,
 it would be:
 
 Pb = (Cb - 128) / 127
 
 and so a full range chrominance value actually varies in the range [1,255] indicating [-1.0, 1.0]. See also Video Range.
 
 YpCbCr video color representations are typically specified in terms of a RGB colorspace and a typically 3x3 matrix to convert RGB to YpCbCr.
 The RGB colorspace itself is also defined relative to an absolute XYZ colorspace.  This is typically done using some x,y,z (little xyz!)
 primaries defining the size of the color cube and a transfer function that describes the conversion from linear color to non-linear RGB. The
 transfer function is usually of a form that can be evaluated with vImagePiecewiseGamma_<fmt> (see vImage/Transform.h). It should be noted that
 both of these are customarily defined in the opposite direction from an ICC profile. Whereas an ICC profile is conversion from display colorspace
 to linear XYZ, video formats are from XYZ to YpCbCr. Thus, the matrices and the gamma are inverted.
 
 Chroma subsampling
 ------------------
 Since the human eye is better at getting positional information from luminance changes than chrominance changes, the chrominance signal is
 often subsampled relative to luminance. (For each chrominance sample, there may be 2 or 4 luminance ones.) This saves memory. See
 [sampling ratio] below.
 
 Chroma Siting
 -------------
 Chroma subsampling also brings with it the possibility of differences in how the chroma samples are positioned relative to the luminance samples.
 For example for 422, they may overlap the left one, or the right one, or be positioned between them. This is called chroma siting. Many video
 formats are available for a diversity of siting options. However, for OS X.10 and iOS 8, vImage does only the centered variant
 (kCVImageBufferChromaLocation_Center). Please file a bug report to request other siting modes where they are found to be necessary.
 
 Video Range
 -----------
 Video formats commonly do not use the entire representable range available to them to encode video data. A 8-bit video range signal may use
 the range [16,235] instead of [0,255] to represent the range of signal strengths [0,1.0] for luminance, and [16,240] for chroma. A video signal
 that uses the full [0,255] ([1,255] for chroma) is said to be full range.
 
 Pixel Blocks
 -------------
 Since some channels are sampled at a higher rate than other channels, it is common to group multiple pixels together in a block which is
 encoded or decoded as a unit. Blocks are useful because they are an integer multiple of a byte in size and describe a particular
 repeating component order that can be serviced in a loop. See [sampling ratio] below for common ways in which multiple YpCbCr pixels fit
 together in a block. An example might be a 2vuy image (422CbYpCrYp8 to vImage) which has luminance and chrominance for two pixels packed
 together in a block as {Cb, Yp, Cr, Yp}.  The chrominance is shared between the two pixels, but each has its own luminance.
 
 In all cases, the beginning of a scanline must also be the beginning of a block, and must be at least byte aligned.  We do not support cases where
 a block spans multiple block rows. If the width of an image is not a multiple of the block width (or height is not a multiple of a block height)
 and you are writing to a YpCbCr format, then the edge pixels are in effect duplicated (see kvImageEdgeExtend) until the image is a multiple of
 the block size and the larger image is encoded to YpCbCr. If you are converting from a subsampled YpCbCr image to a non-subsampled format, then
 we only write out the pixels that fit in the vImage_Buffer.height and vImage_Buffer.width provided. You should be careful to keep the original
 height and width, since edges of the wider images may look like image artifacts if they appear onscreen.
 
 Nomenclature used in vImage
 ---------------------------
 To cover the many different packing orders, chroma subsamplings and separate image planes, we adopt the following naming convention here
 as an extension of that commonly used here for RGB images:
 
 [sampling ratio][order of appearance of components in block][bitdepth](_[sampling ratio][order of appearance of components in block] for plane 2)...
 
 Examples:
 
 444YpCbCrA8        Each chunk is one pixel. Channels are 8-bit interleaved in the order A, Yp, Cb, Cr.  kCVPixelFormatType_4444YpCbCrA8
 422CbYpCrYp8        Each chunk is two horizontally adjacent pixels. Channels are 8-bit interleaved in the order Cb, Yp0, Cr, Yp0. (2vuy)
 422CbYpCrYp8_AA8   Like 422CbYpCrYp8 but with a separate alpha channel added. (kCVPixelFormatType_422YpCbCr_4A_8BiPlanar)
 
 The fields and behavior details of such formats are described below:
 
 [sampling ratio]
 ----------------
 The format begins with a three digit code commonly used for video formats that describes the relative frequencies with which luminance
 (Yp) and chrominance (Cb, Cr) are sampled, to enable rapid indexing of the formats for experienced professionals. For the rest of us,
 these are:
 
 444  Luminance and chrominance are sampled at the same rate
 422  Luminance is sampled at twice the rate of chrominance components in the horizontal dimension
 420  Luminance is sampled at twice the rate of chrominance components in both dimensions.
 ...
 
 If there is an alpha channel, it is assumed to be sampled at the same rate as luminance.
 
 [order of appearance of components in block]:
 --------------------------------------------
 For a 444 block, each component appears once and the block holds one pixel, so you
 just see the order of the components such as AYpCbCr much like we write ARGB. For a 422 block, there are two luminance for each Cb or Cr, so
 you will see a block order like YpCbYpCr and the block represents two pixels in a fully decoded image. Noticed that Yp is repeated twice.
 The pixels have different luminance but share the same chrominance values. In the case of 420 and 411, there is also vertical subsampling.
 In this case, the vImage_Buffer.rowBytes describes the stride from one block row to the next. (Each block row is two pixels tall.)
 
 In extreme cases with blocks that span more than two pixels, the block packing can become complicated, resulting in an exceptionally long name.
 This can happen for bit depths that are not a multiple of a byte, where the block size not only accommodates subsampling, but also byte alignment.
 Such cases may be abbreviated with the 'P' character, indicating Packed. An example is 422PCbYpCrYp10, which would otherwise have to be named
 422CrYpCbYpCbYpCbYpCrYpCrYp10. In such cases, the actual layout is given in the comments.
 
 
 [bitdepth]
 ----------
 This is the number of bits per component. Typically, all the channels have the same bit depth so it just appears at the end of the plane name.
 If there is a heterogeneous format, the bit depths are inserted between the channels where they change (e.g. 444Yp12CbCr10) for 12 bit Yp and
 10 bit CbCr in a 32-bit 444 block.
 
 [additional planes]
 -------------------
 Some YpCbCr formats have multiple planes. (That is, multiple vImage_Buffers.) It is common to have the Y data in one plane and CbCr packed in
 another plane, or perhaps alpha stored  separately. An underbar '_' shall separate the planes and the new plane will be named according to order
 of appearance of the block components. Subsampling may cause components in a plane to appear multiple times.  For example: 411YpYpCbYpYpCr8_AAAA8
 is a 411 format with alpha in a separate plane.  We see AAAA instead of A because each block holds 4 pixels and so the block contains alpha four
 times in that plane. Blocks in all planes have the same height and width for a particular format.
 
 
 Conversion to RGB and other colorspaces
 ----------------------------------------
 
 Unfortunately, the RGB colorspaces that commonly underlie YpCbCr formats are generally not the same as ones commonly used for RGB imaging in
 CoreGraphics. For example, ITU-R BT.709 is similar to sRGB but not the same. Consequently, simple conversion from YpCbCr data to RGB using
 the matrix functions provided here may not be the only step required for good color fidelity. A RGB -> RGB colorspace conversion may be
 required too.  Typically, this involves converting to linear color, applying a RGB->RGB conversion matrix, and then applying the new gamma.
 This can be done using vImagePiecewiseGamma_<fmt> and vImageMatrixMultiply_<fmt>. (We recommend planar 16Q12 for 8- and 10-bpc formats and
 floating point for higher bit depths.) However, some may find it simpler to use the interfaces on vImage_CVUtilities.h instead, which handle
 such details for you.
 
 */


/**
 \function vImageConvert_YpCbCrToARGB_GenerateConversion
 
 \abstract Generates the conversion from a YpCbCr to a ARGB pixel format.
 
 @param matrix
 A pointer to vImage_YpCbCrToARGBMatrix that contains the matrix coefficients for the conversion
 from a YpCbCr to a ARGB pixel format.
 
 @param pixelRange
 A pointer to vImage_YpCbCrPixelRange that contains the pixel range information for the conversion
 from a YpCbCr to a ARGB pixel format.
 
 @param outInfo
 A pointer to vImage_YpCbCrToRGB will be initialized with the information for the conversion function
 will use later.
 
 @param inYpCbCrType
 A YpCbCrType to specify the input YpCbCr format.
 
 @param outARGBType
 A ARGBType to specify the output ARGB format.
 
 @param flags
 kvImagePrintDiagnosticsToConsole   Directs the function to print diagnostic information to the console in the event of failure.
 
 \discussion This function is used to create the vImage_YpCbCrToARGB conversion information necessary for all
 of YUV -> RGB conversion functions.
 
 For example, if we want to prepare for the conversion from 'yuvs' with ITU 601 video range to ARGB8888, then we
 need to do the following:
 
 <pre> \textblock
 VIMAGE_PF vImage_Error err = kvImageNoError;
 vImage_Flags flags = kvImageNoFlags;
 vImage_YpCbCrPixelRange pixelRange;
 vImage_YpCbCrToARGB outInfo;
 
 pixelRange.Yp_bias         =   16;     // encoding for Y' = 0.0
 pixelRange.CbCr_bias       =  128;     // encoding for CbCr = 0.0
 pixelRange.YpRangeMax      =  235;     // encoding for Y'= 1.0
 pixelRange.CbCrRangeMax    =  240;     // encoding for CbCr = 0.5
 pixelRange.YpMax           =  255;     // a clamping limit above which the value is not allowed to go. 255 is fastest. Use pixelRange.YpRangeMax if you don't want Y' > 1.
 pixelRange.YpMin           =    0;     // a clamping limit below which the value is not allowed to go. 0 is fastest. Use pixelRange.Yp_bias if you don't want Y' < 0.
 pixelRange.CbCrMax         =  255;     // a clamping limit above which the value is not allowed to go. 255 is fastest.  Use pixelRange.CbCrRangeMax, if you don't want CbCr > 0.5
 pixelRange.CbCrMin         =    0;     // a clamping limit above which the value is not allowed to go. 0 is fastest.  Use (2*pixelRange.CbCr_bias - pixelRange.CbCrRangeMax), if you don't want CbCr < -0.5
 //                ( pixelRange.CbCr_bias - (pixelRange.CbCrRangeMax - pixelRange.CbCr_bias) = 2*pixelRange.CbCr_bias - pixelRange.CbCrRangeMax )
 
 err = vImageConvert_YpCbCrToARGB_GenerateConversion(kvImageITU601_YpCbCrToARGBMatrix, &pixelRange, &outInfo, kvImage422YpCbYpCr8, kvImageARGB8888, flags);
 \/textblock </pre>
 
 If we want to define our own conversion coefficents, then we can do
 
 <pre> \textblock
 vImage_YpCbCrToARGBMatrix matrix;
 vImage_YpCbCrPixelRange pixelRange;
 
 matrix.Yp                  =  1.0f;
 matrix.Cb_G                = -0.3441f;
 matrix.Cb_B                =  1.772f;
 matrix.Cr_R                =  1.402f;
 matrix.Cr_G                = -0.7141f;
 
 pixelRange.Yp_bias         =   16;     // encoding for Y' = 0.0
 pixelRange.CbCr_bias       =  128;     // encoding for CbCr = 0.0
 pixelRange.YpRangeMax      =  235;     // encoding for Y'= 1.0
 pixelRange.CbCrRangeMax    =  240;     // encoding for CbCr = 0.5
 pixelRange.YpMax           =  255;     // a clamping limit above which the value is not allowed to go. 255 is fastest. Use pixelRange.YpRangeMax if you don't want Y' > 1.
 pixelRange.YpMin           =    0;     // a clamping limit below which the value is not allowed to go. 0 is fastest. Use pixelRange.Yp_bias if you don't want Y' < 0.
 pixelRange.CbCrMax         =  255;     // a clamping limit above which the value is not allowed to go. 255 is fastest.  Use pixelRange.CbCrRangeMax, if you don't want CbCr > 0.5
 pixelRange.CbCrMin         =    0;     // a clamping limit above which the value is not allowed to go. 0 is fastest.  Use (2*pixelRange.CbCr_bias - pixelRange.CbCrRangeMax), if you don't want CbCr < -0.5
 //                ( pixelRange.CbCr_bias - (pixelRange.CbCrRangeMax - pixelRange.CbCr_bias) = 2*pixelRange.CbCr_bias - pixelRange.CbCrRangeMax )
 
 err = vImageConvert_YpCbCrToARGB_GenerateConversion(&matrix, &pixelRange, &outInfo, kvImage422YpCbYpCr8, kvImageARGB8888, flags).
 \/textblock </pre>
 
 
 vImage_YpCbCrToARGB created may be reused multiple times from multiple threads concurrently.
 
 Here are the conversions available currently.
 
 <pre>
 \textblock
 RGB8   RGB16Q12    RGB16
 YUV8     Y        N          N
 YUV10    Y        Y          N
 YUV12    Y        Y          N
 YUV14    Y        N          Y
 YUV16    Y        N          Y
 \/textblock
 </pre>
 
 @return  The following return codes may occur:
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageUnsupportedConversion    Is returned when there is no conversion in vImage for inYpCbCrType & outARGBType.
 \/textblock  </pre>
 
 */

public static native @Cast("vImage_Error") long vImageConvert_YpCbCrToARGB_GenerateConversion(@Const vImage_YpCbCrToARGBMatrix matrix, @Const vImage_YpCbCrPixelRange pixelRange, vImage_YpCbCrToARGB outInfo, @Cast("vImageYpCbCrType") int inYpCbCrType, @Cast("vImageARGBType") int outARGBType, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGBToYpCbCr_GenerateConversion
 
 \abstract Generates the conversion from a ARGB to a YpCbCr pixel format.
 
 @param matrix
 A pointer to vImage_ARGBToYpCbCrMatrix that contains the matrix coefficients for the conversion
 from a ARGB to a YpCbCr pixel format.
 
 @param pixelRange
 A pointer to vImage_YpCbCrPixelRange that contains the pixel range information for the conversion
 from a ARGB to a YpCbCr pixel format.
 
 @param outInfo
 A pointer to vImage_ARGBToYpCbCr will be initialized with the information for the conversion function
 will use later.
 
 @param inARGBType
 A ARGBType to specify the output ARGB format.
 
 @param outYpCbCrType
 A YpCbCrType to specify the input YpCbCr format.
 
 @param flags
 kvImagePrintDiagnosticsToConsole   Directs the function to print diagnostic information to the console in the event of failure.
 
 \discussion This function is used to create the vImage_ARGBToYpCbCr conversion information necessary for all
 of RGB -> YUV conversion functions.
 
 For example, if we want to prepare for the conversion from ARGB8888 'yuvs' with ITU 601 video range, then we
 need to do the following:
 
 <pre> \textblock
 VIMAGE_PF vImage_Error err = kvImageNoError;
 vImage_Flags flags = kvImageNoFlags;
 vImage_YpCbCrPixelRange pixelRange;
 vImage_ARGBToYpCbCr outInfo;
 
 pixelRange.Yp_bias         =   16;     // encoding for Y' = 0.0
 pixelRange.CbCr_bias       =  128;     // encoding for CbCr = 0.0
 pixelRange.YpRangeMax      =  235;     // encoding for Y'= 1.0
 pixelRange.CbCrRangeMax    =  240;     // encoding for CbCr = 0.5
 pixelRange.YpMax           =  255;     // a clamping limit above which the value is not allowed to go. 255 is fastest. Use pixelRange.YpRangeMax if you don't want Y' > 1.
 pixelRange.YpMin           =    0;     // a clamping limit below which the value is not allowed to go. 0 is fastest. Use pixelRange.Yp_bias if you don't want Y' < 0.
 pixelRange.CbCrMax         =  255;     // a clamping limit above which the value is not allowed to go. 255 is fastest.  Use pixelRange.CbCrRangeMax, if you don't want CbCr > 0.5
 pixelRange.CbCrMin         =    0;     // a clamping limit above which the value is not allowed to go. 0 is fastest.  Use (2*pixelRange.CbCr_bias - pixelRange.CbCrRangeMax), if you don't want CbCr < -0.5
 
 err = vImageConvert_ARGBToYpCbCr_GenerateConversion(kvImage_ARGBToYpCbCrMatrix_ITU_R_601_4, &pixelRange, &outInfo, kvImageARGB8888, kvImage422YpCbYpCr8, flags);
 
 
 If we want to define our own conversion coefficents, then we can do
 
 vImage_ARGBToYpCbCrMatrix matrix;;
 vImage_YpCbCrPixelRange pixelRange;
 
 matrix.R_Yp          =  0.2989f;
 matrix.G_Yp          =  0.5866f;
 matrix.B_Yp          =  0.1144f;
 matrix.R_Cb          = -0.1688f;
 matrix.G_Cb          = -0.3312f;
 matrix.B_Cb_R_Cr     =  0.5f;
 matrix.G_Cr          = -0.4183f;
 matrix.B_Cr          = -0.0816f;
 pixelRange.Yp_bias         =   16;     // encoding for Y' = 0.0
 pixelRange.CbCr_bias       =  128;     // encoding for CbCr = 0.0
 pixelRange.YpRangeMax      =  235;     // encoding for Y'= 1.0
 pixelRange.CbCrRangeMax    =  240;     // encoding for CbCr = 0.5
 pixelRange.YpMax           =  255;     // a clamping limit above which the value is not allowed to go. 255 is fastest. Use pixelRange.YpRangeMax if you don't want Y' > 1.
 pixelRange.YpMin           =    0;     // a clamping limit below which the value is not allowed to go. 0 is fastest. Use pixelRange.Yp_bias if you don't want Y' < 0.
 pixelRange.CbCrMax         =  255;     // a clamping limit above which the value is not allowed to go. 255 is fastest.  Use pixelRange.CbCrRangeMax, if you don't want CbCr > 0.5
 pixelRange.CbCrMin         =    0;     // a clamping limit above which the value is not allowed to go. 0 is fastest.  Use (2*pixelRange.CbCr_bias - pixelRange.CbCrRangeMax), if you don't want CbCr < -0.5
 
 err = vImageConvert_ARGBToYpCbCr_GenerateConversion(&matrix, &pixelRange, &outInfo, kvImageARGB8888, kvImage422YpCbYpCr8, flags);
 
 
 vImage_ARGBToYpCbCr created may be reused multiple times from multiple threads concurrently.
 
 Here are the conversions available currently.
 
 RGB8   RGB16Q12    RGB16
 YUV8     Y        N          N
 YUV10    Y        Y          N
 YUV12    Y        Y          N
 YUV14    Y        N          Y
 YUV16    Y        N          Y
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageUnsupportedConversion    Is returned when there is no conversion in vImage for inARGBType & outYpCbCrType.
 \/textblock </pre>
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGBToYpCbCr_GenerateConversion(@Const vImage_ARGBToYpCbCrMatrix matrix, @Const vImage_YpCbCrPixelRange pixelRange, vImage_ARGBToYpCbCr outInfo, @Cast("vImageARGBType") int inARGBType, @Cast("vImageYpCbCrType") int outYpCbCrType, @Cast("vImage_Flags") long flags);


/** \functiongroup 422YpCbYpCr8 ('yuvs' and 'yuvf') */

/**
 \function vImageConvert_422YpCbYpCr8ToARGB8888
 
 \abstract Convert YUV 422YpCbYpCr8 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 422YpCbYpCr8 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 
 \discussion Convert YUV 422YpCbYpCr8 format to ARGB8888
 
 
 Yp0 Cb0 Yp1 Cr0  =>  A0 R0 G0 B0  A1 R1 G1 B1
 
 
 YUV 422YpCbYpCr8 can be used for 'yuvs' and 'yuvf' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'yuvs' with ITU 601 video range, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion().
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 
 <pre>
 \textblock
 uint8_t *srcPixel = src.data;
 Yp0 = srcPixel[0];
 Cb0 = srcPixel[1];
 Yp1 = srcPixel[2];
 Cr0 = srcPixel[3];
 srcPixel += 4;
 
 A0 = alpha
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                              ), 255 )
 A1 = alpha
 R1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                              ), 255 )
 
 uint8_t ARGB[8];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 ARGB[4] = A1;
 ARGB[5] = R1;
 ARGB[6] = G1;
 ARGB[7] = B1;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel[4] = ARGB[permuteMap[0]+4];
 destPixel[5] = ARGB[permuteMap[1]+4];
 destPixel[6] = ARGB[permuteMap[2]+4];
 destPixel[7] = ARGB[permuteMap[3]+4];
 destPixel += 8;
 \/textblock
 </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_422YpCbYpCr8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422YpCbYpCr8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422YpCbYpCr8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To422YpCbYpCr8
 
 \abstract Convert ARGB8888 to YUV 422YpCbYpCr8 format.
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 422YpCbYpCr8 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel appears only once.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 422YpCbYpCr8 format
 
 A0 R0 G0 B0  A1 R1 G1 B1 => Yp0 Cb0 Yp1 Cr0
 
 
 YUV 422YpCbYpCr8 can be used for 'yuvs' and 'yuvf' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'yuvs' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 
 <pre>
 \textblock
 uint8_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A1 = srcPixel[permuteMap[0]];
 R1 = srcPixel[permuteMap[1]];
 G1 = srcPixel[permuteMap[2]];
 B1 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Yp1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R1 * R_Yp      + G1 * G_Yp + B1 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr
 +   R1 * R_Cb      + G1 * G_Cb + B1 * B_Cb_R_Cr) / 2 )
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr
 +   R1 * B_Cb_R_Cr + G1 * G_Cr + B1 * B_Cr     ) / 2 )
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = Yp0;
 destPixel[1] = Cb0;
 destPixel[2] = Yp1;
 destPixel[3] = Cr0;
 destPixel += 4;
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 Results are guaranteed to be faithfully rounded.
 Chroma is sampled at center by default.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422YpCbYpCr8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422YpCbYpCr8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422YpCbYpCr8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);


/** \functiongroup 422CbYpCrYp8 ('2vuy' and '2vuf') */

/**
 \function vImageConvert_422CbYpCrYp8ToARGB8888
 
 \abstract Convert YUV 422CbYpCrYp8 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 422CbYpCrYp8 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 422CbYpCrYp8 format to ARGB8888
 
 
 Cb0 Yp0 Cr0 Yp1  =>  A0 R0 G0 B0  A1 R1 G1 B1
 
 
 YUV 422CbYpCrYp8 can be used for '2vuy' and '2vuf' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert '2vuy' with ITU 601 video range to ARGB8888, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 
 <pre>
 \textblock
 uint8_t *srcPixel = src.data;
 Cb0 = srcPixel[0];
 Yp0 = srcPixel[1];
 Cr0 = srcPixel[2];
 Yp1 = srcPixel[3];
 srcPixel += 4;
 
 A0 = alpha
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 A1 = alpha
 R1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                            ), 255 )
 
 uint8_t ARGB[8];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 ARGB[4] = A1;
 ARGB[5] = R1;
 ARGB[6] = G1;
 ARGB[7] = B1;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel[4] = ARGB[permuteMap[0]+4];
 destPixel[5] = ARGB[permuteMap[1]+4];
 destPixel[6] = ARGB[permuteMap[2]+4];
 destPixel[7] = ARGB[permuteMap[3]+4];
 destPixel += 8;
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 Note: Results are guaranteed to be faithfully rounded.
 
 
 */
public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);


/**
 \function vImageConvert_ARGB8888To422CbYpCrYp8
 
 \abstract Convert ARGB8888 to YUV 422CbYpCrYp8 format
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 422CbYpCrYp8 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel appears only once in the ordering.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 422CbYpCrYp8 format. Can be used for 2vuy.
 
 
 A0 R0 G0 B0  A1 R1 G1 B1 => Cb0 Yp0 Cr0 Yp1
 
 
 YUV 422CbYpCrYp8 can be used for '2vuy' and '2vuf' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to '2vuy' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 
 The per-pixel operation is:
 
 <pre>
 \textblock
 uint8_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A1 = srcPixel[permuteMap[0]];
 R1 = srcPixel[permuteMap[1]];
 G1 = srcPixel[permuteMap[2]];
 B1 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Yp1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R1 * R_Yp      + G1 * G_Yp + B1 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr
 +   R1 * R_Cb      + G1 * G_Cb + B1 * B_Cb_R_Cr) / 2 )
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr
 +   R1 * B_Cb_R_Cr + G1 * G_Cr + B1 * B_Cr     ) / 2 )
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = Cb0;
 destPixel[1] = Yp0;
 destPixel[2] = Cr0;
 destPixel[3] = Yp1;
 destPixel += 4;
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 Results are guaranteed to be faithfully rounded.
 Chroma is sampled at center by default.
 
 
 */


public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CbYpCrYp8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CbYpCrYp8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CbYpCrYp8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/** \functiongroup 422CbYpCrYp8_AA8 ('a2vy') */

/**
 \function vImageConvert_422CbYpCrYp8_AA8ToARGB8888
 
 \abstract Convert YUV 422CbYpCrYp8_AA8 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 422CbYpCrYp8_AA8 source pixels.
 
 @param srcA
 A pointer to vImage_Buffer that references 8-bit alpha source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 422CbYpCrYp8_AA8 format to ARGB8888
 
 
 Cb0 Yp0 Cr0 Yp1  =>  A0 R0 G0 B0  A1 R1 G1 B1
 
 A0 A1
 
 
 YUV 422CbYpCrYp8_AA8 can be used for 'a2vy' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert 'a2vy' with ITU 601 video range to ARGB8888, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 
 <pre>
 \textblock
 uint8_t *srcPixel = src.data;
 Cb0 = srcPixel[0];
 Yp0 = srcPixel[1];
 Cr0 = srcPixel[2];
 Yp1 = srcPixel[3];
 srcPixel += 4;
 
 uint8_t *alpha = srcA.data;
 A0 = alpha[0];
 A1 = alpha[1];
 alpha += 2;
 
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 R1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 
 uint8_t ARGB[8];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 ARGB[4] = A1;
 ARGB[5] = R1;
 ARGB[6] = G1;
 ARGB[7] = B1;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel[4] = ARGB[permuteMap[0]+4];
 destPixel[5] = ARGB[permuteMap[1]+4];
 destPixel[6] = ARGB[permuteMap[2]+4];
 destPixel[7] = ARGB[permuteMap[3]+4];
 destPixel += 8;
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp8_AA8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer srcA, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp8_AA8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer srcA, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp8_AA8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer srcA, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To422CbYpCrYp8_AA8
 
 \abstract Convert ARGB8888 to YUV 422CbYpCrYp8_AA8 format
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 422CbYpCrYp8_AA8 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel appears exactly once.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 422CbYpCrYp8_AA8 format
 
 
 A0 R0 G0 B0  A1 R1 G1 B1 => Cb0 Yp0 Cr0 Yp1
 
 A0 A1
 
 
 For example, if we want to use this function to convert ARGB8888 to 'a2vy' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 
 <pre>
 \textblock
 
 uint8_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A1 = srcPixel[permuteMap[0]];
 R1 = srcPixel[permuteMap[1]];
 G1 = srcPixel[permuteMap[2]];
 B1 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Yp1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R1 * R_Yp      + G1 * G_Yp + B1 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr
 +   R1 * R_Cb      + G1 * G_Cb + B1 * B_Cb_R_Cr) / 2 )
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr
 +   R1 * B_Cb_R_Cr + G1 * G_Cr + B1 * B_Cr     ) / 2 )
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = Cb0;
 destPixel[1] = Yp0;
 destPixel[2] = Cr0;
 destPixel[3] = Yp1;
 destPixel += 4;
 
 uint8_t *alpha = destA.data;
 alpha[0] = A0;
 alpha[1] = A1;
 alpha += 2;
 
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 <pre>
 
 Results are guaranteed to be faithfully rounded.
 Chroma is sampled at center by default.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CbYpCrYp8_AA8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_Buffer destA, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CbYpCrYp8_AA8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_Buffer destA, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CbYpCrYp8_AA8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_Buffer destA, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/** \functiongroup 444AYpCbCr8 ('r408' and 'y408') */

/**
 \function vImageConvert_444AYpCbCr8ToARGB8888
 
 \abstract Convert YUV 444AYpCbCr8 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 444AYpCbCr8 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 444AYpCbCr8 format to ARGB8888
 
 
 A0 Yp0 Cb0 Cr0  =>  A0 R0 G0 B0
 
 
 YUV 444AYpCbCr8 can be used for 'r408' and 'y408' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert 'y408' with ITU 601 video range to ARGB8888, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 
 <pre>
 \textblock
 
 uint8_t *srcPixel = src.data;
 A0  = srcPixel[0];
 Yp0 = srcPixel[1];
 Cb0 = srcPixel[2];
 Cr0 = srcPixel[3];
 srcPixel += 4;
 
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 
 uint8_t ARGB[4];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 
 \/textblock
 <pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 Results are guaranteed to be faithfully rounded.
 This function can work in place.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_444AYpCbCr8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444AYpCbCr8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444AYpCbCr8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To444AYpCbCr8
 
 \abstract Convert ARGB8888 to YUV 444AYpCbCr8 format
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 444AYpCbCr8 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel appears exactly once.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 444AYpCbCr8 format
 
 
 A0 R0 G0 B0  =>  A0 Yp0 Cb0 Cr0
 
 
 YUV 444AYpCbCr8 can be used for 'r408' and 'y408' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'y408' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 
 <pre>
 \textblock
 uint8_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   + R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr)
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr     )
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = A0;
 destPixel[1] = Yp0;
 destPixel[2] = Cb0;
 destPixel[3] = Cr0;
 destPixel += 4;
 \/textblock
 </pre>
 
 
 @return
 <pre>
 \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 <pre>
 
 Results are guaranteed to be faithfully rounded.
 This function can work in place.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444AYpCbCr8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444AYpCbCr8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444AYpCbCr8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);


/** \functiongroup 444CbYpCrA8 ('v408') */
/**
 \function vImageConvert_444CbYpCrA8ToARGB8888
 
 \abstract Convert YUV 444CbYpCrA8 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 444CbYpCrA8 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 444CbYpCrA8 format to ARGB8888
 
 
 Cb0 Yp0 Cr0 A0  =>  A0 R0 G0 B0
 
 
 YUV 444CbYpCrA8 can be used for 'v408' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert 'v408' with ITU 601 video range to ARGB8888, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 
 <pre> \textblock
 uint8_t *srcPixel = src.data;
 Cb0 = srcPixel[0];
 Yp0 = srcPixel[1];
 Cr0 = srcPixel[2];
 A0  = srcPixel[3];
 srcPixel += 4;
 
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 
 uint8_t ARGB[4];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 \/textblock    </pre>
 
 
 @return
 <pre>
 \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 Results are guaranteed to be faithfully rounded.
 This function can work in place.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_444CbYpCrA8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444CbYpCrA8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444CbYpCrA8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To444CbYpCrA8
 
 \abstract Convert ARGB8888 to YUV 444CbYpCrA8 format
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 444CbYpCrA8 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, provided that each channel appears only once.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 444CbYpCrA8 format
 
 
 A0 R0 G0 B0  =>  Cb0 Yp0 Cr0 A0
 
 
 YUV 444CbYpCrA8 can be used for 'v408' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'v408' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 
 <pre> \textblock
 uint8_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   + R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr)
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr     )
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = Cb0;
 destPixel[1] = Yp0;
 destPixel[2] = Cr0;
 destPixel[3] = A0;
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 This function can work in place.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444CbYpCrA8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444CbYpCrA8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444CbYpCrA8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/** \functiongroup 444CrYpCb8 ('v308')  */

/**
 \function vImageConvert_444CrYpCb8ToARGB8888
 
 \abstract Convert YUV 444CrYpCb8 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 444CrYpCb8 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 444CrYpCb8 format to ARGB8888
 
 
 Cr0 Yp0 Cb0  =>  A0 R0 G0 B0
 
 
 YUV 444CrYpCb8 can be used for 'v308' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert 'v308' with ITU 601 video range to ARGB8888, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre>
 \textblock
 
 uint8_t *srcPixel = src.data;
 Cr0 = srcPixel[0];
 Yp0 = srcPixel[1];
 Cb0 = srcPixel[2];
 srcPixel += 3;
 
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 
 uint8_t ARGB[4];
 ARGB[0] = alpha;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 \/textblock
 </pre>
 
 
 @return
 <pre>
 \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_444CrYpCb8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444CrYpCb8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444CrYpCb8ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To444CrYpCb8
 
 \abstract Convert ARGB8888 to YUV 444CrYpCb8 format
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 444CrYpCb8 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, provided that each channel appears only once.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 444CrYpCb8 format
 
 
 A0 R0 G0 B0  =>  Cr0 Yp0 Cb0
 
 
 YUV 444CrYpCb8 can be used for 'v308' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'v308' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 
 The per-pixel operation is:
 
 <pre>
 \textblock
 uint8_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   + R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr)
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr     )
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = Cr0;
 destPixel[1] = Yp0;
 destPixel[2] = Cb0;
 destPixel += 3;
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 Note: Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444CrYpCb8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444CrYpCb8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444CrYpCb8(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/** \functiongroup 420Yp8_Cb8_Cr8 ('y420' and 'f420') */

/**
 \function vImageConvert_420Yp8_Cb8_Cr8ToARGB8888
 
 \abstract Convert YUV 420Yp8_Cb8_Cr8 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 420Yp8_Cb8_Cr8 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 420Yp8_Cb8_Cr8 format to ARGB8888
 
 
 Ypt0 Ypt1  =>  At0 Rt0 Gt0 Bt0  At1 Rt1 Gt1 Bt1
 
 Ypb0 Ypb1      Ab0 Rb0 Gb0 Bb0  Ab1 Rb1 Gb1 Bb1
 
 Cb0
 
 Cr0
 
 
 YUV 420Yp8_Cb8_Cr8 can be used for 'y420' and 'f420' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert 'y420' with ITU 601 video range to ARGB8888, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre>
 \textblock
 
 uint8_t *srcYtPixel = srcY.data;
 uint8_t *srcYbPixel = srcY.data + srcY.rowBytes;
 Ypt0 = srcYtPixel[0];
 Ypt1 = srcYtPixel[1];
 srcYtPixel += 2;
 Ypb0 = srcYbPixel[0];
 Ypb1 = srcYbPixel[1];
 srcYbPixel += 2;
 
 uint8_t *srcCbPixel = srcCb.data;
 uint8_t *srcCrPixel = srcCr.data;
 Cb0 = srcCbPixel[0];
 srcCbPixel += 1;
 Cr0 = srcCrPixel[0];
 srcCrPixel += 1;
 
 At0 = alpha
 Rt0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt0 + Yp_bias) * Yp                               + (Cr0 + CbCr_bias) * Cr_R), 255 )
 Gt0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt0 + Yp_bias) * Yp + (Cb0 + CbCr_bias) * Cb_G + (Cr0 + CbCr_bias) * Cr_G), 255 )
 Bt0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt0 + Yp_bias) * Yp + (Cb0 + CbCr_bias) * Cb_B                              ), 255 )
 At1 = alpha
 Rt1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt1 + Yp_bias) * Yp                               + (Cr0 + CbCr_bias) * Cr_R), 255 )
 Gt1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt1 + Yp_bias) * Yp + (Cb0 + CbCr_bias) * Cb_G + (Cr0 + CbCr_bias) * Cr_G), 255 )
 Bt1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt1 + Yp_bias) * Yp + (Cb0 + CbCr_bias) * Cb_B                              ), 255 )
 Ab0 = alpha
 Rb0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb0 + Yp_bias) * Yp                               + (Cr0 + CbCr_bias) * Cr_R), 255 )
 Gb0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb0 + Yp_bias) * Yp + (Cb0 + CbCr_bias) * Cb_G + (Cr0 + CbCr_bias) * Cr_G), 255 )
 Bb0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb0 + Yp_bias) * Yp + (Cb0 + CbCr_bias) * Cb_B                              ), 255 )
 Ab1 = alpha
 Rb1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb1 + Yp_bias) * Yp                               + (Cr0 + CbCr_bias) * Cr_R), 255 )
 Gb1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb1 + Yp_bias) * Yp + (Cb0 + CbCr_bias) * Cb_G + (Cr0 + CbCr_bias) * Cr_G), 255 )
 Bb1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb1 + Yp_bias) * Yp + (Cb0 + CbCr_bias) * Cb_B                              ), 255 )
 
 uint8_t ARGB[16];
 ARGB[0]  = At0;
 ARGB[1]  = Rt0;
 ARGB[2]  = Gt0;
 ARGB[3]  = Bt0;
 ARGB[4]  = At1;
 ARGB[5]  = Rt1;
 ARGB[6]  = Gt1;
 ARGB[7]  = Bt1;
 ARGB[8]  = Ab0;
 ARGB[9]  = Rb0;
 ARGB[10] = Gb0;
 ARGB[11] = Bb0;
 ARGB[12] = Ab1;
 ARGB[13] = Rb1;
 ARGB[14] = Gb1;
 ARGB[15] = Bb1;
 
 uint8_t *destTPixel = dest.data;
 destTPixel[0]  = ARGB[permuteMap[0]];
 destTPixel[1]  = ARGB[permuteMap[1]];
 destTPixel[2]  = ARGB[permuteMap[2]];
 destTPixel[3]  = ARGB[permuteMap[3]];
 destTPixel[4]  = ARGB[permuteMap[0]+4];
 destTPixel[5]  = ARGB[permuteMap[1]+4];
 destTPixel[6]  = ARGB[permuteMap[2]+4];
 destTPixel[7]  = ARGB[permuteMap[3]+4];
 destTPixel += 8;
 uint8_t *destBPixel = dest.data + dest.rowBytes;
 destBPixel[0]  = ARGB[permuteMap[0]+8];
 destBPixel[1]  = ARGB[permuteMap[1]+8];
 destBPixel[2]  = ARGB[permuteMap[2]+8];
 destBPixel[3]  = ARGB[permuteMap[3]+8];
 destBPixel[4]  = ARGB[permuteMap[0]+12];
 destBPixel[5]  = ARGB[permuteMap[1]+12];
 destBPixel[6]  = ARGB[permuteMap[2]+12];
 destBPixel[7]  = ARGB[permuteMap[3]+12];
 destBPixel += 8;
 
 \/textblock
 </pre>
 
 @return
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 
 Note: Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_420Yp8_Cb8_Cr8ToARGB8888(@Const vImage_Buffer srcYp, @Const vImage_Buffer srcCb, @Const vImage_Buffer srcCr, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_420Yp8_Cb8_Cr8ToARGB8888(@Const vImage_Buffer srcYp, @Const vImage_Buffer srcCb, @Const vImage_Buffer srcCr, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_420Yp8_Cb8_Cr8ToARGB8888(@Const vImage_Buffer srcYp, @Const vImage_Buffer srcCb, @Const vImage_Buffer srcCr, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To420Yp8_Cb8_Cr8
 
 \abstract Convert ARGB8888 to YUV 420Yp8_Cb8_Cr8 format.
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 420Yp8_Cb8_Cr8 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, provided that each channel appears only once.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 420Yp8_Cb8_Cr8 format
 
 
 <pre> \textblock
 At0 Rt0 Gt0 Bt0  At1 Rt1 Gt1 Bt1  =>  Ypt0 Ypt1
 
 Ab0 Rb0 Gb0 Bb0  Ab1 Rb1 Gb1 Bb1      Ypb0 Ypb1
 
 Cb0
 
 Cr0
 
 \/textblock </pre>
 
 YUV 420Yp8_Cb8_Cr8 can be used for 'y420' and 'f420' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'y420' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 <pre>
 \textblock
 uint8_t *srcTPixel = src.data;
 At0 = srcTPixel[permuteMap[0]];
 Rt0 = srcTPixel[permuteMap[1]];
 Gt0 = srcTPixel[permuteMap[2]];
 Bt0 = srcTPixel[permuteMap[3]];
 srcTPixel += 4;
 At1 = srcTPixel[permuteMap[0]];
 Rt1 = srcTPixel[permuteMap[1]];
 Gt1 = srcTPixel[permuteMap[2]];
 Bt1 = srcTPixel[permuteMap[3]];
 srcTPixel += 4;
 uint8_t *srcBPixel = src.data + src.rowBytes;
 Ab0 = srcBPixel[permuteMap[0]];
 Rb0 = srcBPixel[permuteMap[1]];
 Gb0 = srcBPixel[permuteMap[2]];
 Bb0 = srcBPixel[permuteMap[3]];
 srcBPixel += 4;
 Ab1 = srcBPixel[permuteMap[0]];
 Rb1 = srcBPixel[permuteMap[1]];
 Gb1 = srcBPixel[permuteMap[2]];
 Bb1 = srcBPixel[permuteMap[3]];
 srcBPixel += 4;
 
 Ypt0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   Rt0 * R_Yp      + Gt0 * G_Yp + Bt0 * B_Yp     )
 Ypt1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   Rt1 * R_Yp      + Gt1 * G_Yp + Bt1 * B_Yp     )
 Ypb0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   Rb0 * R_Yp      + Gb0 * G_Yp + Bb0 * B_Yp     )
 Ypb1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   Rb1 * R_Yp      + Gb1 * G_Yp + Bb1 * B_Yp     )
 Cb0  = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( Rt0 * R_Cb      + Gt0 * G_Cb + Bt0 * B_Cb_R_Cr
 +   Rt1 * R_Cb      + Gt1 * G_Cb + Bt1 * B_Cb_R_Cr
 +   Rb0 * R_Cb      + Gb0 * G_Cb + Bb0 * B_Cb_R_Cr
 +   Rb1 * R_Cb      + Gb1 * G_Cb + Bb1 * B_Cb_R_Cr) / 4 )
 Cr0  = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( Rt0 * B_Cb_R_Cr + Gt0 * G_Cr + Bt0 * B_Cr
 +   Rt1 * B_Cb_R_Cr + Gt1 * G_Cr + Bt1 * B_Cr
 +   Rb0 * B_Cb_R_Cr + Gb0 * G_Cr + Bb0 * B_Cr
 +   Rb1 * B_Cb_R_Cr + Gb1 * G_Cr + Bb1 * B_Cr     ) / 4 )
 
 uint8_t *destYptPixel = destYp.data;
 uint8_t *destYpbPixel = destYp.data + destYp.rowBytes;
 destYptPixel[0] = Ypt0;
 destYptPixel[1] = Ypt1;
 destYpbPixel[0] = Ypb0;
 destYpbPixel[1] = Ypb1;
 destYptPixel += 2;
 destYpbPixel += 2;
 
 uint8_t *destCbPixel = destCb.data;
 uint8_t *destCrPixel = destCr.data;
 destCbPixel[0] = Cb0;
 destCrPixel[0] = Cr0;
 destCbPixel += 1;
 destCrPixel += 1;
 \/textblock
 </pre>
 
 @return
 <pre>
 \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 Results are guaranteed to be faithfully rounded.
 Chroma is sampled at center by default.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To420Yp8_Cb8_Cr8(@Const vImage_Buffer src, @Const vImage_Buffer destYp, @Const vImage_Buffer destCb, @Const vImage_Buffer destCr, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To420Yp8_Cb8_Cr8(@Const vImage_Buffer src, @Const vImage_Buffer destYp, @Const vImage_Buffer destCb, @Const vImage_Buffer destCr, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To420Yp8_Cb8_Cr8(@Const vImage_Buffer src, @Const vImage_Buffer destYp, @Const vImage_Buffer destCb, @Const vImage_Buffer destCr, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/** \functiongroup 420Yp8_CbCr8 ('420v' and '420f') */

/**
 \function vImageConvert_420Yp8_CbCr8ToARGB8888
 
 \abstract Convert YUV 420Yp8_CbCr8 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 420Yp8_CbCr8 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 420Yp8_CbCr8 format to ARGB8888
 
 
 Ypt0 Ypt1  =>  At0 Rt0 Gt0 Bt0  At1 Rt1 Gt1 Bt1
 
 Ypb0 Ypb1      Ab0 Rb0 Gb0 Bb0  Ab1 Rb1 Gb1 Bb1
 
 Cb0 Cr0
 
 
 YUV 420Yp8_CbCr8 can be used for '420v' and '420f' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert '420v' with ITU 601 video range to ARGB8888, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre>
 \textblock
 
 uint8_t *srcYtPixel = srcY.data;
 uint8_t *srcYbPixel = srcY.data + srcY.rowBytes;
 Ypt0 = srcYtPixel[0];
 Ypt1 = srcYtPixel[1];
 srcYtPixel += 2;
 Ypb0 = srcYbPixel[0];
 Ypb1 = srcYbPixel[1];
 srcYbPixel += 2;
 
 uint8_t *srcCbCrPixel = srcCbCr.data;
 Cb0 = srcCbCrPixel[0];
 Cr0 = srcCbCrPixel[1];
 srcCrPixel += 2;
 
 At0 = alpha
 Rt0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 Gt0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 Bt0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                              ), 255 )
 At1 = alpha
 Rt1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt1 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 Gt1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 Bt1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypt1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                              ), 255 )
 Ab0 = alpha
 Rb0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 Gb0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 Bb0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                              ), 255 )
 Ab1 = alpha
 Rb1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb1 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 Gb1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 Bb1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Ypb1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                              ), 255 )
 
 uint8_t ARGB[16];
 ARGB[0]  = At0;
 ARGB[1]  = Rt0;
 ARGB[2]  = Gt0;
 ARGB[3]  = Bt0;
 ARGB[4]  = At1;
 ARGB[5]  = Rt1;
 ARGB[6]  = Gt1;
 ARGB[7]  = Bt1;
 ARGB[8]  = Ab0;
 ARGB[9]  = Rb0;
 ARGB[10] = Gb0;
 ARGB[11] = Bb0;
 ARGB[12] = Ab1;
 ARGB[13] = Rb1;
 ARGB[14] = Gb1;
 ARGB[15] = Bb1;
 
 uint8_t *destTPixel = dest.data;
 destTPixel[0]  = ARGB[permuteMap[0]];
 destTPixel[1]  = ARGB[permuteMap[1]];
 destTPixel[2]  = ARGB[permuteMap[2]];
 destTPixel[3]  = ARGB[permuteMap[3]];
 destTPixel[4]  = ARGB[permuteMap[0]+4];
 destTPixel[5]  = ARGB[permuteMap[1]+4];
 destTPixel[6]  = ARGB[permuteMap[2]+4];
 destTPixel[7]  = ARGB[permuteMap[3]+4];
 destTPixel += 8;
 uint8_t *destBPixel = dest.data + dest.rowBytes;
 destBPixel[0]  = ARGB[permuteMap[0]+8];
 destBPixel[1]  = ARGB[permuteMap[1]+8];
 destBPixel[2]  = ARGB[permuteMap[2]+8];
 destBPixel[3]  = ARGB[permuteMap[3]+8];
 destBPixel[4]  = ARGB[permuteMap[0]+12];
 destBPixel[5]  = ARGB[permuteMap[1]+12];
 destBPixel[6]  = ARGB[permuteMap[2]+12];
 destBPixel[7]  = ARGB[permuteMap[3]+12];
 destBPixel += 8;
 
 \/textblock
 </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_420Yp8_CbCr8ToARGB8888(@Const vImage_Buffer srcYp, @Const vImage_Buffer srcCbCr, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_420Yp8_CbCr8ToARGB8888(@Const vImage_Buffer srcYp, @Const vImage_Buffer srcCbCr, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_420Yp8_CbCr8ToARGB8888(@Const vImage_Buffer srcYp, @Const vImage_Buffer srcCbCr, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To420Yp8_CbCr8
 
 \abstract Convert ARGB8888 to YUV 420Yp8_CbCr8 format.
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 420Yp8_CbCr8 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as the channels don't repeat. For example, the pirate colorspace {0,1,1,1} (ARRR) is not supported, because the red channel appears more than once. (Pirates see red.)
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 420Yp8_CbCr8 format
 
 
 <pre> \textblock
 At0 Rt0 Gt0 Bt0  At1 Rt1 Gt1 Bt1  =>  Ypt0 Ypt1
 
 Ab0 Rb0 Gb0 Bb0  Ab1 Rb1 Gb1 Bb1      Ypb0 Ypb1
 
 Cb0 Cr0
 \/textblock </pre>
 
 
 YUV 420Yp8_CbCr8 can be used for '420v' and '420f' that are defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to '420v' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 <pre> \textblock
 uint8_t *srcTPixel = src.data;
 At0 = srcTPixel[permuteMap[0]];
 Rt0 = srcTPixel[permuteMap[1]];
 Gt0 = srcTPixel[permuteMap[2]];
 Bt0 = srcTPixel[permuteMap[3]];
 srcTPixel += 4;
 At1 = srcTPixel[permuteMap[0]];
 Rt1 = srcTPixel[permuteMap[1]];
 Gt1 = srcTPixel[permuteMap[2]];
 Bt1 = srcTPixel[permuteMap[3]];
 srcTPixel += 4;
 uint8_t *srcBPixel = src.data + src.rowBytes;
 Ab0 = srcBPixel[permuteMap[0]];
 Rb0 = srcBPixel[permuteMap[1]];
 Gb0 = srcBPixel[permuteMap[2]];
 Bb0 = srcBPixel[permuteMap[3]];
 srcBPixel += 4;
 Ab1 = srcBPixel[permuteMap[0]];
 Rb1 = srcBPixel[permuteMap[1]];
 Gb1 = srcBPixel[permuteMap[2]];
 Bb1 = srcBPixel[permuteMap[3]];
 srcBPixel += 4;
 
 Ypt0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   Rt0 * R_Yp      + Gt0 * G_Yp + Bt0 * B_Yp     )
 Ypt1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   Rt1 * R_Yp      + Gt1 * G_Yp + Bt1 * B_Yp     )
 Ypb0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   Rb0 * R_Yp      + Gb0 * G_Yp + Bb0 * B_Yp     )
 Ypb1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   Rb1 * R_Yp      + Gb1 * G_Yp + Bb1 * B_Yp     )
 Cb0  = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( Rt0 * R_Cb      + Gt0 * G_Cb + Bt0 * B_Cb_R_Cr
 +   Rt1 * R_Cb      + Gt1 * G_Cb + Bt1 * B_Cb_R_Cr
 +   Rb0 * R_Cb      + Gb0 * G_Cb + Bb0 * B_Cb_R_Cr
 +   Rb1 * R_Cb      + Gb1 * G_Cb + Bb1 * B_Cb_R_Cr) / 4 )
 Cr0  = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( Rt0 * B_Cb_R_Cr + Gt0 * G_Cr + Bt0 * B_Cr
 +   Rt1 * B_Cb_R_Cr + Gt1 * G_Cr + Bt1 * B_Cr
 +   Rb0 * B_Cb_R_Cr + Gb0 * G_Cr + Bb0 * B_Cr
 +   Rb1 * B_Cb_R_Cr + Gb1 * G_Cr + Bb1 * B_Cr     ) / 4 )
 
 uint8_t *destYptPixel = destYp.data;
 uint8_t *destYpbPixel = destYp.data + destYp.rowBytes;
 destYptPixel[0] = Ypt0;
 destYptPixel[1] = Ypt1;
 destYpbPixel[0] = Ypb0;
 destYpbPixel[1] = Ypb1;
 destYptPixel += 2;
 destYpbPixel += 2;
 
 uint8_t *destCbCrPixel = destCbCr.data;
 destCbCrPixel[0] = Cb0;
 destCbCrPixel[1] = Cr0;
 destCbCrPixel += 2;
 \/textblock </pre>
 
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock
 </pre>
 
 
 Results are guaranteed to be faithfully rounded.
 Chroma is sampled at center by default.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To420Yp8_CbCr8(@Const vImage_Buffer src, @Const vImage_Buffer destYp, @Const vImage_Buffer destCbCr, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To420Yp8_CbCr8(@Const vImage_Buffer src, @Const vImage_Buffer destYp, @Const vImage_Buffer destCbCr, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To420Yp8_CbCr8(@Const vImage_Buffer src, @Const vImage_Buffer destYp, @Const vImage_Buffer destCbCr, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);


/** \functiongroup 444AYpCbCr16 ('y416') */

/**
 \function vImageConvert_444AYpCbCr16ToARGB8888
 
 \abstract Convert YUV 444AYpCbCr16 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 444AYpCbCr16 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 444AYpCbCr16 format to ARGB8888
 
 
 A0 Yp0 Cb0 Cr0  =>  A0 R0 G0 B0
 
 
 YUV 444AYpCbCr8 can be used for 'y416' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert 'y416' with ITU 601 video range to ARGB8888, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre> \textblock
 uint16_t *srcPixel = src.data;
 A0  = srcPixel[0];
 Yp0 = srcPixel[1];
 Cb0 = srcPixel[2];
 Cr0 = srcPixel[3];
 srcPixel += 4;
 
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 
 uint8_t ARGB[4];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_444AYpCbCr16ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444AYpCbCr16ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444AYpCbCr16ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To444AYpCbCr16
 
 \abstract Convert ARGB8888 to YUV 444AYpCbCr16 format
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 444AYpCbCr16 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as the values are unique.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 444AYpCbCr16 format
 
 
 A0 R0 G0 B0  =>  A0 Yp0 Cb0 Cr0
 
 
 YUV 444AYpCbCr8 can be used for 'y416' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'y416' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 
 The per-pixel operation is:
 <pre> \textblock
 uint8_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   + R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr)
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr     )
 
 uint16_t *destPixel = dest.data;
 destPixel[0] = A0;
 destPixel[1] = Yp0;
 destPixel[2] = Cb0;
 destPixel[3] = Cr0;
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444AYpCbCr16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444AYpCbCr16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444AYpCbCr16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_444AYpCbCr16ToARGB16U
 
 \abstract Convert YUV 444AYpCbCr16 format to ARGB16U
 
 @param src
 A pointer to vImage_Buffer that references YUV 444AYpCbCr16 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 16-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16U.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16U.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 444AYpCbCr16 format to ARGB16U
 
 
 A0 Yp0 Cb0 Cr0  =>  A0 R0 G0 B0
 
 
 YUV 444AYpCbCr8 can be used for 'y416' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert 'y416' with ITU 601 video range to ARGB16U, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre> \textblock
 uint16_t *srcPixel = src.data;
 A0  = srcPixel[0];
 Yp0 = srcPixel[1];
 Cb0 = srcPixel[2];
 Cr0 = srcPixel[3];
 srcPixel += 4;
 
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 65535 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 65535 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 65535 )
 
 uint16_t ARGB[4];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 
 uint16_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 This function can work in place.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_444AYpCbCr16ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444AYpCbCr16ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444AYpCbCr16ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB16UTo444AYpCbCr16
 
 \abstract Convert ARGB8888 to YUV 444AYpCbCr16 format
 
 @param src
 A pointer to vImage_Buffer that references 16-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 444AYpCbCr16 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16U.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16U.
 Any ordering of channels is supported as long as each channel appears only once.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB16U to YUV 444AYpCbCr16 format
 
 
 A0 R0 G0 B0  =>  A0 Yp0 Cb0 Cr0
 
 
 YUV 444AYpCbCr8 can be used for 'y416' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB16U to 'y416' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 
 The per-pixel operation is:
 <pre> \textblock
 uint16_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   + R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr)
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr     )
 
 uint16_t *destPixel = dest.data;
 destPixel[0] = A0;
 destPixel[1] = Yp0;
 destPixel[2] = Cb0;
 destPixel[3] = Cr0;
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 This function can work in place.
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB16UTo444AYpCbCr16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UTo444AYpCbCr16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UTo444AYpCbCr16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/** \functiongroup 444CrYpCb10 ('v410') */

/**
 \function vImageConvert_444CrYpCb10ToARGB8888
 
 \abstract Convert YUV 444CrYpCb10 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 444CrYpCb10 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 444CrYpCb10 format to ARGB8888
 
 
 3 10-bit unsigned components are packed into a 32-bit little-endian word.
 
 <pre> \textblock
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cr            10-bit Yp            10-bit Cb                   =>  A0 R0 G0 B0
 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  X X
 \/textblock </pre>
 
 
 YUV 444CrYpCb10 can be used for 'v410' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert 'v410' with ITU 601 video range to ARGB8888, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre> \textblock
 uint32_t *srcPixel = src.data;
 uint32_t pixel = *srcPixel;
 srcPixel += 1;
 
 Yp0 = getYpFromv410(pixel);
 Cb0 = getCbFromv410(pixel);
 Cr0 = getCrFromv410(pixel);
 
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 
 uint8_t ARGB[4];
 ARGB[0] = alpha;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 
 Results are guaranteed to be faithfully rounded.
 This function can work in place.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_444CrYpCb10ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444CrYpCb10ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444CrYpCb10ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To444CrYpCb10
 
 \abstract Convert ARGB8888 to YUV 444CrYpCb10 format
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 444CrYpCb10 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel appears only once.
 
 @param flags
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 
 \discussion Convert ARGB8888 to YUV 444CrYpCb10 format
 
 
 3 10-bit unsigned components are packed into a 32-bit little-endian word.
 
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 A0 R0 G0 B0  =>  10-bit Cr            10-bit Yp            10-bit Cb
 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  X X
 
 
 YUV 444CrYpCb10 can be used for 'v410' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'v410' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 
 The per-pixel operation is:
 <pre> \textblock
 uint8_t *srcPixel = src.data;
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   + R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr)
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr     )
 
 pixel = makev410(Yp0, Cb0, Cr0);
 
 uint32_t *destPixel = dest.data;
 *destPixel = pixel;
 destPixel += 1;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 
 Results are guaranteed to be faithfully rounded.
 This function can work in place.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444CrYpCb10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444CrYpCb10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To444CrYpCb10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_444CrYpCb10ToARGB16Q12
 
 \abstract Convert YUV 444CrYpCb10 format to ARGB16Q12
 
 @param src
 A pointer to vImage_Buffer that references YUV 444CrYpCb10 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 16Q12 ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16Q12.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16Q12.
 
 @param alpha
 A 16Q12 value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 444CrYpCb10 format to ARGB16Q12
 
 
 3 10-bit unsigned components are packed into a 32-bit little-endian word.
 
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cr            10-bit Yp            10-bit Cb                   =>  A0 R0 G0 B0
 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  X X
 
 
 YUV 444CrYpCb10 can be used for 'v410' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert 'v410' with ITU 601 video range to ARGB16Q12, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre> \textblock
 uint32_t *srcPixel = src.data;
 uint32_t pixel = *srcPixel;
 srcPixel += 1;
 
 Yp0 = getYpFromv410(pixel);
 Cb0 = getCbFromv410(pixel);
 Cr0 = getCrFromv410(pixel);
 
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 4096 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 4096 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                            ), 4096 )
 
 uint16_t ARGB[4];
 ARGB[0] = alpha;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 
 uint16_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_444CrYpCb10ToARGB16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const Pixel_16Q12") short alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444CrYpCb10ToARGB16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const Pixel_16Q12") short alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_444CrYpCb10ToARGB16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const Pixel_16Q12") short alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB16Q12To444CrYpCb10
 
 \abstract Convert ARGB16Q12 to YUV 444CrYpCb10 format
 
 @param src
 A pointer to vImage_Buffer that references 16Q12 ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 444CrYpCb10 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16Q12.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16Q12.
 Any ordering of channels is supported as long as each channel appears only once.
 
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB16Q12 to YUV 444CrYpCb10 format
 
 
 3 10-bit unsigned components are packed into a 32-bit little-endian word.
 <pre> \textblock
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 A0 R0 G0 B0  =>  10-bit Cr            10-bit Yp            10-bit Cb
 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  X X
 \/textblock </pre>
 
 
 YUV 444CrYpCb10 can be used for 'v410' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB16Q12 to 'v410' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 
 The per-pixel operation is:
 <pre> \textblock
 uint16_t *srcPixel = src.data;
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   + R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr)
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr     )
 
 pixel = makev410(Yp0, Cb0, Cr0);
 
 uint32_t *destPixel = dest.data;
 destPixel[0] = pixel;
 destPixel += 1;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12To444CrYpCb10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12To444CrYpCb10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12To444CrYpCb10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);


/** \functiongroup 422CrYpCbYpCbYpCbYpCrYpCrYp10 ('v210')   */

/**
 \function vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB8888
 
 \abstract Convert YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 format to ARGB8888
 
 
 6 packed YUV pixels are getting mapped into 6 ARGB8888 pixels.
 
 12 10-bit unsigned components are packed into 4 32-bit little-endian words.
 <pre> \textblock
 
 Word0
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cr0           10-bit Y0            10-bit Cb0
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word1
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Y2            10-bit Cb1           10-bit Y1
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word2
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cb2           10-bit Y3            10-bit Cr1
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word3
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Y5            10-bit Cr2           10-bit Y4
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 
 =>  A0 R0 G0 B0  A1 R1 G1 B1  A2 R2 G2 B2  A3 R3 G3 B3  A4 R4 G4 B4  A5 R5 G5 B5
 \/textblock </pre>
 
 YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 can be used for 'v210' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'v210' with ITU 601 video range, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre> \textblock
 uint32_t *srcPixel = src.data;
 pixel0 = srcPixel[0];
 pixel1 = srcPixel[1];
 pixel2 = srcPixel[2];
 pixel3 = srcPixel[3];
 srcPixel += 4;
 
 Yp0 = getYp0Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp1 = getYp1Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp2 = getYp2Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp3 = getYp3Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp4 = getYp4Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp5 = getYp5Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cb0 = getCb0Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cb1 = getCb1Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cb2 = getCb2Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cr0 = getCr0Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cr1 = getCr1Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cr2 = getCr2Fromv210(pixel0, pixel1, pixel2, pixel3);
 
 A0 = alpha
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 A1 = alpha
 R1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 A2 = alpha
 R2 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp2 - Yp_bias) * Yp                            + (Cr1 - CbCr_bias) * Cr_R), 255 )
 G2 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp2 - Yp_bias) * Yp + (Cb1 - CbCr_bias) * Cb_G + (Cr1 - CbCr_bias) * Cr_G), 255 )
 B2 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp2 - Yp_bias) * Yp + (Cb1 - CbCr_bias) * Cb_B                           ), 255 )
 A3 = alpha
 R3 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp3 - Yp_bias) * Yp                            + (Cr1 - CbCr_bias) * Cr_R), 255 )
 G3 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp3 - Yp_bias) * Yp + (Cb1 - CbCr_bias) * Cb_G + (Cr1 - CbCr_bias) * Cr_G), 255 )
 B3 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp3 - Yp_bias) * Yp + (Cb1 - CbCr_bias) * Cb_B                           ), 255 )
 A4 = alpha
 R4 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp4 - Yp_bias) * Yp                            + (Cr2 - CbCr_bias) * Cr_R), 255 )
 G4 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp4 - Yp_bias) * Yp + (Cb2 - CbCr_bias) * Cb_G + (Cr2 - CbCr_bias) * Cr_G), 255 )
 B4 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp4 - Yp_bias) * Yp + (Cb2 - CbCr_bias) * Cb_B                           ), 255 )
 A5 = alpha
 R5 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp5 - Yp_bias) * Yp                            + (Cr2 - CbCr_bias) * Cr_R), 255 )
 G5 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp5 - Yp_bias) * Yp + (Cb2 - CbCr_bias) * Cb_G + (Cr2 - CbCr_bias) * Cr_G), 255 )
 B5 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp5 - Yp_bias) * Yp + (Cb2 - CbCr_bias) * Cb_B                           ), 255 )
 
 uint8_t ARGB[24];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 ARGB[4] = A1;
 ARGB[5] = R1;
 ARGB[6] = G1;
 ARGB[7] = B1;
 ARGB[8] = A2;
 ARGB[9] = R2;
 ARGB[10] = G2;
 ARGB[11] = B2;
 ARGB[12] = A3;
 ARGB[13] = R3;
 ARGB[14] = G3;
 ARGB[15] = B3;
 ARGB[16] = A4;
 ARGB[17] = R4;
 ARGB[18] = G4;
 ARGB[19] = B4;
 ARGB[20] = A5;
 ARGB[21] = R5;
 ARGB[22] = G5;
 ARGB[23] = B5;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel[4] = ARGB[permuteMap[0]+4];
 destPixel[5] = ARGB[permuteMap[1]+4];
 destPixel[6] = ARGB[permuteMap[2]+4];
 destPixel[7] = ARGB[permuteMap[3]+4];
 destPixel[8] = ARGB[permuteMap[0]+8];
 destPixel[9] = ARGB[permuteMap[1]+8];
 destPixel[10] = ARGB[permuteMap[2]+8];
 destPixel[11] = ARGB[permuteMap[3]+8];
 destPixel[12] = ARGB[permuteMap[0]+12];
 destPixel[13] = ARGB[permuteMap[1]+12];
 destPixel[14] = ARGB[permuteMap[2]+12];
 destPixel[15] = ARGB[permuteMap[3]+12];
 destPixel[16] = ARGB[permuteMap[0]+16];
 destPixel[17] = ARGB[permuteMap[1]+16];
 destPixel[18] = ARGB[permuteMap[2]+16];
 destPixel[19] = ARGB[permuteMap[3]+16];
 destPixel[20] = ARGB[permuteMap[0]+20];
 destPixel[21] = ARGB[permuteMap[1]+20];
 destPixel[22] = ARGB[permuteMap[2]+20];
 destPixel[23] = ARGB[permuteMap[3]+20];
 destPixel += 24;
 \/textblock </pre>
 
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To422CrYpCbYpCbYpCbYpCrYpCrYp10
 
 \abstract Convert ARGB8888 to YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 format.
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel appears only once.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 format
 
 
 6 ARGB8888 pixels are getting mapped into 6 packed YUV pixels.
 
 A0 R0 G0 B0  A1 R1 G1 B1  A2 R2 G2 B2  A3 R3 G3 B3  A4 R4 G4 B4  A5 R5 G5 B5  =>
 
 12 10-bit unsigned components are packed into 4 32-bit little-endian words.
 
 <pre> \textblock
 Word0
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cr0           10-bit Y0            10-bit Cb0
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word1
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Y2            10-bit Cb1           10-bit Y1
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word2
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cb2           10-bit Y3            10-bit Cr1
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word3
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Y5            10-bit Cr2           10-bit Y4
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 \/textblock </pre>
 
 YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 can be used for 'v210' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 'v210' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 <pre> \textblock
 uint8_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A1 = srcPixel[permuteMap[0]];
 R1 = srcPixel[permuteMap[1]];
 G1 = srcPixel[permuteMap[2]];
 B1 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A2 = srcPixel[permuteMap[0]];
 R2 = srcPixel[permuteMap[1]];
 G2 = srcPixel[permuteMap[2]];
 B2 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A3 = srcPixel[permuteMap[0]];
 R3 = srcPixel[permuteMap[1]];
 G3 = srcPixel[permuteMap[2]];
 B3 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A4 = srcPixel[permuteMap[0]];
 R4 = srcPixel[permuteMap[1]];
 G4 = srcPixel[permuteMap[2]];
 B4 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A5 = srcPixel[permuteMap[0]];
 R5 = srcPixel[permuteMap[1]];
 G5 = srcPixel[permuteMap[2]];
 B5 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Yp1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R1 * R_Yp      + G1 * G_Yp + B1 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr
 +   R1 * R_Cb      + G1 * G_Cb + B1 * B_Cb_R_Cr) / 2 )
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr
 +   R1 * B_Cb_R_Cr + G1 * G_Cr + B1 * B_Cr     ) / 2 )
 Yp2 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R2 * R_Yp      + G2 * G_Yp + B2 * B_Yp     )
 Yp3 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R3 * R_Yp      + G3 * G_Yp + B3 * B_Yp     )
 Cb1 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R2 * R_Cb      + G2 * G_Cb + B2 * B_Cb_R_Cr
 +   R3 * R_Cb      + G3 * G_Cb + B3 * B_Cb_R_Cr) / 2 )
 Cr1 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R2 * B_Cb_R_Cr + G2 * G_Cr + B2 * B_Cr
 +   R3 * B_Cb_R_Cr + G3 * G_Cr + B3 * B_Cr     ) / 2 )
 Yp4 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R4 * R_Yp      + G4 * G_Yp + B4 * B_Yp     )
 Yp5 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R5 * R_Yp      + G5 * G_Yp + B5 * B_Yp     )
 Cb2 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R4 * R_Cb      + G4 * G_Cb + B4 * B_Cb_R_Cr
 +   R5 * R_Cb      + G5 * G_Cb + B5 * B_Cb_R_Cr) / 2 )
 Cr2 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R4 * B_Cb_R_Cr + G4 * G_Cr + B4 * B_Cr
 +   R5 * B_Cb_R_Cr + G5 * G_Cr + B5 * B_Cr     ) / 2 )
 
 uint32_t *destPixel = dest.data;
 packv210AndStore(destPixel, Yp0, Yp1, Yp2, Yp3, Yp4, Yp5, Cb0, Cb1, Cb2, Cr0, Cr1, Cr2);
 destPixel += 4;
 \/textblock </pre>
 
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 Chroma is sampled at center by default.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CrYpCbYpCbYpCbYpCrYpCrYp10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CrYpCbYpCbYpCbYpCrYpCrYp10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CrYpCbYpCbYpCbYpCrYpCrYp10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB16Q12
 
 \abstract Convert YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 format to ARGB16Q12
 
 @param src
 A pointer to vImage_Buffer that references YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 16Q12 ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16Q12.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16Q12.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 format to ARGB16Q12
 
 
 6 packed YUV pixels are getting mapped into 6 ARGB16Q12 pixels.
 
 12 10-bit unsigned components are packed into 4 32-bit little-endian words.
 <pre> \textblock
 Word0
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cr0           10-bit Y0            10-bit Cb0
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word1
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Y2            10-bit Cb1           10-bit Y1
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word2
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cb2           10-bit Y3            10-bit Cr1
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word3
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Y5            10-bit Cr2           10-bit Y4
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 
 =>  A0 R0 G0 B0  A1 R1 G1 B1  A2 R2 G2 B2  A3 R3 G3 B3  A4 R4 G4 B4  A5 R5 G5 B5
 \/textblock </pre>
 
 YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 can be used for 'v210' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB16Q12 to 'v210' with ITU 601 video range, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre> \textblock
 
 uint32_t *srcPixel = src.data;
 pixel0 = srcPixel[0];
 pixel1 = srcPixel[1];
 pixel2 = srcPixel[2];
 pixel3 = srcPixel[3];
 srcPixel += 4;
 
 Yp0 = getYp0Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp1 = getYp1Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp2 = getYp2Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp3 = getYp3Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp4 = getYp4Fromv210(pixel0, pixel1, pixel2, pixel3);
 Yp5 = getYp5Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cb0 = getCb0Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cb1 = getCb1Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cb2 = getCb2Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cr0 = getCr0Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cr1 = getCr1Fromv210(pixel0, pixel1, pixel2, pixel3);
 Cr2 = getCr2Fromv210(pixel0, pixel1, pixel2, pixel3);
 
 A0 = alpha
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 4096 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 4096 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 4096 )
 A1 = alpha
 R1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 4096 )
 G1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 4096 )
 B1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 4096 )
 A2 = alpha
 R2 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp2 - Yp_bias) * Yp                            + (Cr1 - CbCr_bias) * Cr_R), 4096 )
 G2 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp2 - Yp_bias) * Yp + (Cb1 - CbCr_bias) * Cb_G + (Cr1 - CbCr_bias) * Cr_G), 4096 )
 B2 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp2 - Yp_bias) * Yp + (Cb1 - CbCr_bias) * Cb_B                           ), 4096 )
 A3 = alpha
 R3 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp3 - Yp_bias) * Yp                            + (Cr1 - CbCr_bias) * Cr_R), 4096 )
 G3 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp3 - Yp_bias) * Yp + (Cb1 - CbCr_bias) * Cb_G + (Cr1 - CbCr_bias) * Cr_G), 4096 )
 B3 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp3 - Yp_bias) * Yp + (Cb1 - CbCr_bias) * Cb_B                           ), 4096 )
 A4 = alpha
 R4 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp4 - Yp_bias) * Yp                            + (Cr2 - CbCr_bias) * Cr_R), 4096 )
 G4 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp4 - Yp_bias) * Yp + (Cb2 - CbCr_bias) * Cb_G + (Cr2 - CbCr_bias) * Cr_G), 4096 )
 B4 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp4 - Yp_bias) * Yp + (Cb2 - CbCr_bias) * Cb_B                           ), 4096 )
 A5 = alpha
 R5 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp5 - Yp_bias) * Yp                            + (Cr2 - CbCr_bias) * Cr_R), 4096 )
 G5 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp5 - Yp_bias) * Yp + (Cb2 - CbCr_bias) * Cb_G + (Cr2 - CbCr_bias) * Cr_G), 4096 )
 B5 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp5 - Yp_bias) * Yp + (Cb2 - CbCr_bias) * Cb_B                           ), 4096 )
 
 uint16_t ARGB[24];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 ARGB[4] = A1;
 ARGB[5] = R1;
 ARGB[6] = G1;
 ARGB[7] = B1;
 ARGB[8] = A2;
 ARGB[9] = R2;
 ARGB[10] = G2;
 ARGB[11] = B2;
 ARGB[12] = A3;
 ARGB[13] = R3;
 ARGB[14] = G3;
 ARGB[15] = B3;
 ARGB[16] = A4;
 ARGB[17] = R4;
 ARGB[18] = G4;
 ARGB[19] = B4;
 ARGB[20] = A5;
 ARGB[21] = R5;
 ARGB[22] = G5;
 ARGB[23] = B5;
 
 uint16_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel[4] = ARGB[permuteMap[0]+4];
 destPixel[5] = ARGB[permuteMap[1]+4];
 destPixel[6] = ARGB[permuteMap[2]+4];
 destPixel[7] = ARGB[permuteMap[3]+4];
 destPixel[8] = ARGB[permuteMap[0]+8];
 destPixel[9] = ARGB[permuteMap[1]+8];
 destPixel[10] = ARGB[permuteMap[2]+8];
 destPixel[11] = ARGB[permuteMap[3]+8];
 destPixel[12] = ARGB[permuteMap[0]+12];
 destPixel[13] = ARGB[permuteMap[1]+12];
 destPixel[14] = ARGB[permuteMap[2]+12];
 destPixel[15] = ARGB[permuteMap[3]+12];
 destPixel[16] = ARGB[permuteMap[0]+16];
 destPixel[17] = ARGB[permuteMap[1]+16];
 destPixel[18] = ARGB[permuteMap[2]+16];
 destPixel[19] = ARGB[permuteMap[3]+16];
 destPixel[20] = ARGB[permuteMap[0]+20];
 destPixel[21] = ARGB[permuteMap[1]+20];
 destPixel[22] = ARGB[permuteMap[2]+20];
 destPixel[23] = ARGB[permuteMap[3]+20];
 destPixel += 24;
 \/textblock </pre>
 
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Note: Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const Pixel_16Q12") short alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const Pixel_16Q12") short alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const Pixel_16Q12") short alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB16Q12To422CrYpCbYpCbYpCbYpCrYpCrYp10
 
 \abstract Convert ARGB16Q12 to YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 format.
 
 @param src
 A pointer to vImage_Buffer that references 16Q12 ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16Q12.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16Q12.
 Any ordering of channels is supported as long as each channel appears only once.
 
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB16Q12 to YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 format
 
 
 6 ARGB16Q12 pixels are getting mapped into 6 packed YUV pixels.
 <pre> \textblock
 
 A0 R0 G0 B0  A1 R1 G1 B1  A2 R2 G2 B2  A3 R3 G3 B3  A4 R4 G4 B4  A5 R5 G5 B5  =>
 
 12 10-bit unsigned components are packed into 4 32-bit little-endian words.
 
 Word0
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cr0           10-bit Y0            10-bit Cb0
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word1
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Y2            10-bit Cb1           10-bit Y1
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word2
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Cb2           10-bit Y3            10-bit Cr1
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 
 Word3
 Decreasing Address order (32-bit little-endian)
 byte3           byte2            byte1            byte0
 10-bit Y5            10-bit Cr2           10-bit Y4
 X X 9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0  9 8 7 6 5 4 3 2 1 0
 \/textblock </pre>
 
 YUV 422CrYpCbYpCbYpCbYpCrYpCrYp10 can be used for 'v210' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB16Q12 to 'v210' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 
 <pre> \textblock
 
 uint16_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A1 = srcPixel[permuteMap[0]];
 R1 = srcPixel[permuteMap[1]];
 G1 = srcPixel[permuteMap[2]];
 B1 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A2 = srcPixel[permuteMap[0]];
 R2 = srcPixel[permuteMap[1]];
 G2 = srcPixel[permuteMap[2]];
 B2 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A3 = srcPixel[permuteMap[0]];
 R3 = srcPixel[permuteMap[1]];
 G3 = srcPixel[permuteMap[2]];
 B3 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A4 = srcPixel[permuteMap[0]];
 R4 = srcPixel[permuteMap[1]];
 G4 = srcPixel[permuteMap[2]];
 B4 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A5 = srcPixel[permuteMap[0]];
 R5 = srcPixel[permuteMap[1]];
 G5 = srcPixel[permuteMap[2]];
 B5 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Yp1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R1 * R_Yp      + G1 * G_Yp + B1 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr
 +   R1 * R_Cb      + G1 * G_Cb + B1 * B_Cb_R_Cr) / 2 )
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr
 +   R1 * B_Cb_R_Cr + G1 * G_Cr + B1 * B_Cr     ) / 2 )
 Yp2 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R2 * R_Yp      + G2 * G_Yp + B2 * B_Yp     )
 Yp3 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R3 * R_Yp      + G3 * G_Yp + B3 * B_Yp     )
 Cb1 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R2 * R_Cb      + G2 * G_Cb + B2 * B_Cb_R_Cr
 +   R3 * R_Cb      + G3 * G_Cb + B3 * B_Cb_R_Cr) / 2 )
 Cr1 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R2 * B_Cb_R_Cr + G2 * G_Cr + B2 * B_Cr
 +   R3 * B_Cb_R_Cr + G3 * G_Cr + B3 * B_Cr     ) / 2 )
 Yp4 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R4 * R_Yp      + G4 * G_Yp + B4 * B_Yp     )
 Yp5 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R5 * R_Yp      + G5 * G_Yp + B5 * B_Yp     )
 Cb2 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R4 * R_Cb      + G4 * G_Cb + B4 * B_Cb_R_Cr
 +   R5 * R_Cb      + G5 * G_Cb + B5 * B_Cb_R_Cr) / 2 )
 Cr2 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R4 * B_Cb_R_Cr + G4 * G_Cr + B4 * B_Cr
 +   R5 * B_Cb_R_Cr + G5 * G_Cr + B5 * B_Cr     ) / 2 )
 
 uint32_t *destPixel = dest.data;
 packv210AndStore(destPixel, Yp0, Yp1, Yp2, Yp3, Yp4, Yp5, Cb0, Cb1, Cb2, Cr0, Cr1, Cr2);
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 Chroma is sampled at center by default.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12To422CrYpCbYpCbYpCbYpCrYpCrYp10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12To422CrYpCbYpCbYpCbYpCrYpCrYp10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12To422CrYpCbYpCbYpCbYpCrYpCrYp10(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);


/** \functiongroup 422CbYpCrYp16(bitdepth) ('v216')    */

/**
 \function vImageConvert_422CbYpCrYp16ToARGB8888
 
 \abstract Convert YUV 422CbYpCrYp16 format to ARGB8888
 
 @param src
 A pointer to vImage_Buffer that references YUV 422CbYpCrYp16 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param alpha
 A value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 
 \discussion Convert YUV 422CbYpCrYp16 format to ARGB8888
 <pre> \textblock
 
 pixel0-1
 byte0 byte1   byte2 byte3   byte4 byte5   byte6 byte7
 LE-16-bit-Cb  LE-16-bit-Y0  LE-16-bit-Cr  LE-16-bit-Y1  =>  A0 R0 G0 B0  A1 R1 G1 B1
 
 (LE and left-justified 16-bit-per-component)
 \/textblock </pre>
 
 YUV 422CbYpCrYp16 can be used for 16-bit 'v216' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 16-bit 'v216' with ITU 601 video range, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre> \textblock
 
 uint64_t *srcPixel = src.data;
 uint64_t pixel = *srcPixel;
 Yp0 = getYp0From16bitv216(pixel);
 Cb0 = getCb0From16bitv216(pixel);
 Yp1 = getYp1From16bitv216(pixel);
 Cr0 = getCr0From16bitv216(pixel);
 srcPixel += 1;
 
 A0 = alpha
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 A1 = alpha
 R1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 255 )
 G1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 255 )
 B1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 255 )
 
 uint8_t ARGB[8];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 ARGB[4] = A1;
 ARGB[5] = R1;
 ARGB[6] = G1;
 ARGB[7] = B1;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel[4] = ARGB[permuteMap[0]+4];
 destPixel[5] = ARGB[permuteMap[1]+4];
 destPixel[6] = ARGB[permuteMap[2]+4];
 destPixel[7] = ARGB[permuteMap[3]+4];
 destPixel += 8;
 \/textblock </pre>
 
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock <pre>
 
 Results are guaranteed to be faithfully rounded.
 This function can work in place.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp16ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp16ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp16ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const uint8_t") byte alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888To422CbYpCrYp16
 
 \abstract Convert ARGB8888 to YUV 422CbYpCrYp16 format.
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 422CbYpCrYp16 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel appears only once.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB8888 to YUV 422CbYpCrYp16 format
 <pre> \textblock
 
 pixel0-1
 byte0 byte1   byte2 byte3   byte4 byte5   byte6 byte7
 A0 R0 G0 B0  A1 R1 G1 B1  =>  LE-16-bit-Cb  LE-16-bit-Y0  LE-16-bit-Cr  LE-16-bit-Y1
 
 (LE and left-justified 16-bit-per-component)
 \/textblock </pre>
 
 YUV 422CbYpCrYp16 can be used for 16-bit 'v216' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB8888 to 16-bit 'v216' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 <pre> \textblock
 
 uint8_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A1 = srcPixel[permuteMap[0]];
 R1 = srcPixel[permuteMap[1]];
 G1 = srcPixel[permuteMap[2]];
 B1 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R0 * R_Yp      + G0 * G_Yp + B0 * B_Yp     )
 Yp1 = ROUND_TO_NEAREST_INTEGER( Yp_bias   +   R1 * R_Yp      + G1 * G_Yp + B1 * B_Yp     )
 Cb0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * R_Cb      + G0 * G_Cb + B0 * B_Cb_R_Cr
 +   R1 * R_Cb      + G1 * G_Cb + B1 * B_Cb_R_Cr) / 2 )
 Cr0 = ROUND_TO_NEAREST_INTEGER( CbCr_bias + ( R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr
 +   R1 * B_Cb_R_Cr + G1 * G_Cr + B1 * B_Cr     ) / 2 )
 
 uint64_t *destPixel = dest.data;
 pack16bitv216AndStore(destPixel, Yp0, Yp1, Cb0, Cr0);
 destPixel += 1;
 
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 Chroma is sampled at center by default.
 This function can work in place.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CbYpCrYp16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CbYpCrYp16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888To422CbYpCrYp16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_422CbYpCrYp16ToARGB16U
 
 \abstract Convert YUV 422CbYpCrYp16 format to ARGB16U
 
 @param src
 A pointer to vImage_Buffer that references YUV 422CbYpCrYp16 source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 16-bit ARGB interleaved destination pixels.
 
 @param info
 A pointer to vImage_YpCbCrToARGB which contains info coeffcient and preBias values.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16U.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16U.
 
 @param alpha
 A 16-bit value for alpha channel in dest.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 
 \discussion Convert YUV 422CbYpCrYp16 format to ARGB16U
 <pre> \textblock
 
 pixel0-1
 byte0 byte1   byte2 byte3   byte4 byte5   byte6 byte7
 LE-16-bit-Cb  LE-16-bit-Y0  LE-16-bit-Cr  LE-16-bit-Y1  =>  A0 R0 G0 B0  A1 R1 G1 B1
 
 (LE and left-justified 16-bit-per-component)
 \/textblock </pre>
 
 YUV 422CbYpCrYp16 can be used for 16-bit 'v216' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB16U to 16-bit 'v216' with ITU 601 video range, then we need
 generate vImage_YpCbCrToARGB by vImageConvert_YpCbCrToARGB_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, Yp, Cr_R, Cb_G, Cr_G, and Cb_B are calculated and converted into the right
 format by vImageConvert_YpCbCrToARGB_GenerateConversion() inside of vImage_YpCbCrToARGB.
 
 
 The per-pixel operation is:
 <pre> \textblock
 
 uint64_t *srcPixel = src.data;
 uint64_t pixel = *srcPixel;
 Yp0 = getYp0From16bitv216(pixel);
 Cb0 = getCb0From16bitv216(pixel);
 Yp1 = getYp1From16bitv216(pixel);
 Cr0 = getCr0From16bitv216(pixel);
 srcPixel += 1;
 
 A0 = alpha
 R0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 65535 )
 G0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 65535 )
 B0 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp0 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 65535 )
 A1 = alpha
 R1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp                            + (Cr0 - CbCr_bias) * Cr_R), 65535 )
 G1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_G + (Cr0 - CbCr_bias) * Cr_G), 65535 )
 B1 = CLAMP(0, ROUND_TO_NEAREST_INTEGER((Yp1 - Yp_bias) * Yp + (Cb0 - CbCr_bias) * Cb_B                           ), 65535 )
 
 uint16_t ARGB[8];
 ARGB[0] = A0;
 ARGB[1] = R0;
 ARGB[2] = G0;
 ARGB[3] = B0;
 ARGB[4] = A1;
 ARGB[5] = R1;
 ARGB[6] = G1;
 ARGB[7] = B1;
 
 uint16_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel[4] = ARGB[permuteMap[0]+4];
 destPixel[5] = ARGB[permuteMap[1]+4];
 destPixel[6] = ARGB[permuteMap[2]+4];
 destPixel[7] = ARGB[permuteMap[3]+4];
 destPixel += 8;
 
 \/textblock </pre>
 
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp16ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("const uint16_t") short alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp16ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("const uint16_t") short alpha, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_422CbYpCrYp16ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_YpCbCrToARGB info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("const uint16_t") short alpha, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB16UTo422CbYpCrYp16
 
 \abstract Convert ARGB16U to YUV 422CbYpCrYp16 format.
 
 @param src
 A pointer to vImage_Buffer that references 16-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references YUV 422CbYpCrYp16 destination pixels.
 
 @param info
 A pointer to vImage_ARGBToYpCbCr which contains info coeffcient and postBias values.
 This is generated by vImageConvert_ARGBToYpCbCr_GenerateConversion().
 
 @param permuteMap
 Values that can be used to switch the channel order of src.
 permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16U.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16U.
 
 @param flags
 <pre> \textblock
 kvImageGetTempBufferSize    Returns 0. Does no work.
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 
 
 \discussion Convert ARGB16U to YUV 422CbYpCrYp16 format
 <pre> \textblock
 
 pixel0-1
 byte0 byte1   byte2 byte3   byte4 byte5   byte6 byte7
 A0 R0 G0 B0  A1 R1 G1 B1  =>  LE-16-bit-Cb  LE-16-bit-Y0  LE-16-bit-Cr  LE-16-bit-Y1
 
 (LE and left-justified 16-bit-per-component)
 \/textblock </pre>
 
 YUV 422CbYpCrYp16 can be used for 16-bit 'v216' that is defined in CVPixelBuffer.h.
 
 For example, if we want to use this function to convert ARGB16U to 16-bit 'v216' with ITU 601 video range, then we need
 generate vImage_ARGBToYpCbCr by vImageConvert_ARGBToYpCbCr_GenerateConversion() and call this function.
 
 Yp_bias, CbCr_bias, CbCr_bias, R_Yp, G_Yp, B_Yp, R_Cb, G_Cb, B_Cb_R_Cr, G_Cr and B_Cr are calculated and
 converted into the right format by vImageConvert_ARGBToYpCbCr_GenerateConversion() inside of vImage_ARGBToYpCbCr.
 
 The per-pixel operation is:
 <pre> \textblock
 
 uint16_t *srcPixel = src.data;
 A0 = srcPixel[permuteMap[0]];
 R0 = srcPixel[permuteMap[1]];
 G0 = srcPixel[permuteMap[2]];
 B0 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 A1 = srcPixel[permuteMap[0]];
 R1 = srcPixel[permuteMap[1]];
 G1 = srcPixel[permuteMap[2]];
 B1 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 Yp0 = Yp_bias + ROUND_TO_NEAREST_INTEGER( R0 * R_Yp + G0 * G_Yp + B0 * B_Yp )
 Yp1 = Yp_bias + ROUND_TO_NEAREST_INTEGER( R1 * R_Yp + G1 * G_Yp + B1 * B_Yp )
 R0 += R1;  G0 += G1;   B0 += B1;
 Cb0 = CbCr_bias + ROUND_TO_NEAREST_INTEGER( ( R0 * R_Cb + G0 * G_Cb + B0 * B_Cb_R_Cr) / 2 )
 Cr0 = CbCr_bias + ROUND_TO_NEAREST_INTEGER( ( R0 * B_Cb_R_Cr + G0 * G_Cr + B0 * B_Cr) / 2 )
 
 uint64_t *destPixel = dest.data;
 pack16bitv216AndStore(destPixel, Yp0, Yp1, Cb0, Cr0);
 destPixel += 1;
 
 \/textblock </pre>
 
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 Chroma is sampled at center by default.
 
 Note: vImage doesn't do anything with the alpha here. It is just thrown away. The operation is therefore best suited for kCGImageAlphaNoneSkip<First/Last>
 images.  If it has alpha, you may wish to composite against an opaque background first, before the transparency information is lost.
 If it is premultiplied by alpha, you at minimum should unpremultiply it first, or composite it against an opaque background. See
 vImageUnpremultiplyData_ARGB16U() and vImageFlatten_ARGB16U().
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB16UTo422CbYpCrYp16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UTo422CbYpCrYp16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UTo422CbYpCrYp16(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Const vImage_ARGBToYpCbCr info, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/** \functiongroup RGBA1010102    */

/**
 \function vImageConvert_RGBA1010102ToARGB8888
 
 \abstract Convert RGBA1010102 to ARGB8888 format.
 
 @param src
 A pointer to vImage_Buffer that references 10-bit RGB interleaved source pixels. Source pixels must be at least 4 byte aligned.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels. Destination pixels may have any alignment.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param flags
 \p kvImageDoNotTile        Disables internal multithreading, if any.
 
 \discussion
 RGBA1010102 is almost the same format that is defined in CVPixelBuffer.h as 'kCVPixelFormatType_30RGB'
 except that this format uses the least significant 2 bits for alpha channel.
 
 This format is 10-bit big endian 32-bit pixels.
 
 RGB101010RangeMax & RGB101010RangeMin are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 <pre>{@code
 RGB101010RangeMax  = 1023;
 RGB101010RangeMin  = 0;
 }</pre>
 
 The per-pixel operation is:
 <pre>{@code
 uint32_t *srcPixel = src.data;
 uint32_t pixel = ntohl(srcPixel[0]);
 srcPixel += 1;
 
 int32_t A2  = pixel & 0x3;
 int32_t R10 = (pixel >> 22) & 0x3ff;
 int32_t G10 = (pixel >> 12) & 0x3ff;
 int32_t B10 = (pixel >>  2) & 0x3ff;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 
 A2  = (A2 * UCHAR_MAX + 1) / 3;
 R10 = ((R10 - RGB101010RangeMin) * UCHAR_MAX + (range10 >> 1)) / range10;
 G10 = ((G10 - RGB101010RangeMin) * UCHAR_MAX + (range10 >> 1)) / range10;
 B10 = ((B10 - RGB101010RangeMin) * UCHAR_MAX + (range10 >> 1)) / range10;
 
 uint8_t R8, G8, B8;
 R8 = CLAMP(0, R10, UCHAR_MAX);
 G8 = CLAMP(0, G10, UCHAR_MAX);
 B8 = CLAMP(0, B10, UCHAR_MAX);
 
 uint8_t ARGB[4];
 ARGB[0] = A2;
 ARGB[1] = R8;
 ARGB[2] = G8;
 ARGB[3] = B8;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 }</pre>
 
 @return kvImageNoError                     Is returned when there was no error.
 @return kvImageUnknownFlagsBit             Is returned when there is a unknown flag.
 @return kvImageRoiLargerThanInputBuffer    Is returned when src.width < dest.width || src.height < dest.height
 @return kvImageInvalidParameter            Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax.
 
 \note Results are guaranteed to be faithfully rounded.
 */
public static native @Cast("vImage_Error") long vImageConvert_RGBA1010102ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGBA1010102ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGBA1010102ToARGB8888(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB8888ToRGBA1010102
 
 \abstract Convert ARGB8888 to RGBA1010102 format.
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels. Source pixels may have any alignment.
 
 @param dest
 A pointer to vImage_Buffer that references 10-bit RGB interleaved destination pixels.  Destination pixels must be at least 4 byte aligned.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of src.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param flags
 \p kvImageDoNotTile    Disables internal multithreading, if any.
 
 \discussion
 RGBA1010102 is almost the same format that is defined in CVPixelBuffer.h as 'kCVPixelFormatType_30RGB'
 except that this format uses the least significant 2 bits for alpha channel.
 
 This format is 10-bit big endian 32-bit pixels.
 
 RGB101010RangeMax & RGB101010RangeMin are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 <pre>{@code
 RGB101010RangeMax  = 1023;
 RGB101010RangeMin  = 0;
 }</pre>
 
 The per-pixel operation is:
 <pre>{@code
 uint8_t *srcPixel = src.data;
 A8 = srcPixel[permuteMap[0]];
 R8 = srcPixel[permuteMap[1]];
 G8 = srcPixel[permuteMap[2]];
 B8 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 int32_t R10, G10, B10;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 int32_t rounding = UCHAR_MAX >> 1;
 R10 = ((R8 * range10 + rounding) / UCHAR_MAX) + RGB101010RangeMin;
 G10 = ((G8 * range10 + rounding) / UCHAR_MAX) + RGB101010RangeMin;
 B10 = ((B8 * range10 + rounding) / UCHAR_MAX) + RGB101010RangeMin;
 A10 = ((A10 * 3 + rounding) / UCHAR_MAX);
 
 uint32_t *destPixel = dest.data;
 destPixel[0] = htonl((R10 << 22) | (G10 << 12) | (B10 << 2) | A10);
 destPixel += 1;
 }</pre>
 
 @return kvImageNoError                  Is returned when there was no error.
 @return kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 @return kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 @return kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax.
 
 \note Results are guaranteed to be faithfully rounded.
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToRGBA1010102(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToRGBA1010102(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToRGBA1010102(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_RGBA1010102ToARGB16Q12
 
 \abstract Convert RGBA1010102 to ARGB16Q12 format.
 
 @param src
 A pointer to vImage_Buffer that references 10-bit RGB interleaved source pixels.  Samples must be at least 4 byte aligned.
 
 @param dest
 A pointer to vImage_Buffer that references 16Q12 ARGB interleaved destination pixels.  Samples must be at least 2 byte aligned.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16Q12.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16Q12.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel is unique.  That is, ARRG is not an allowed order
 because R is repeated.
 
 @param flags
 <pre> \textblock
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 
 \discussion Convert RGBA1010102 to ARGB16Q12 format
 
 RGBA1010102 is almost the same format that is defined in CVPixelBuffer.h as 'kCVPixelFormatType_30RGB'
 except that this format uses the least significant 2 bits for alpha channel.
 
 This format is 10-bit big endian 32-bit pixels.
 
 RGB101010RangeMax & RGB101010RangeMin are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 
 <pre> \textblock
 RGB101010RangeMax  = 1023;
 RGB101010RangeMin  = 0;
 \/textblock </pre>
 
 The per-pixel operation is:
 
 <pre> \textblock
 uint32_t *srcPixel = src.data;
 uint32_t pixel = ntohl(srcPixel[0]);
 srcPixel += 1;
 
 int32_t A2  = pixel & 0x3;
 int32_t R10 = (pixel >> 22) & 0x3ff;
 int32_t G10 = (pixel >> 12) & 0x3ff;
 int32_t B10 = (pixel >>  2) & 0x3ff;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 
 int16_t R16, G16, B16;
 A2  = (A2 * 4096 + 1) / 3;
 R16 = ((R10 - RGB101010RangeMin) * 4096 + (range10 >> 1)) / range10;
 G16 = ((G10 - RGB101010RangeMin) * 4096 + (range10 >> 1)) / range10;
 B16 = ((B10 - RGB101010RangeMin) * 4096 + (range10 >> 1)) / range10;
 
 R16 = CLAMP(INT16_MIN, R16, INT16_MAX);
 G16 = CLAMP(INT16_MIN, G16, INT16_MAX);
 B16 = CLAMP(INT16_MIN, B16, INT16_MAX);
 
 int16_t ARGB[4];
 ARGB[0] = A2;
 ARGB[1] = R16;
 ARGB[2] = G16;
 ARGB[3] = B16;
 
 int16_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax.
 \/textblock </pre>
 
 Note: Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_RGBA1010102ToARGB16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGBA1010102ToARGB16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGBA1010102ToARGB16Q12(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB16Q12ToRGBA1010102
 
 \abstract Convert ARGB16Q12 to RGBA1010102 format.
 
 @param src
 A pointer to vImage_Buffer that references 16Q12 ARGB interleaved source pixels.   ARGB16Q12 pixels must be at least 2 byte aligned.
 
 @param dest
 A pointer to vImage_Buffer that references 10-bit RGB interleaved destination pixels.  RGBA1010102 pixels must be at least 4 byte aligned.
 
 @param RGB101010RangeMax
 A maximum value for the range of 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for the range of 10-bit RGB pixel.
 
 @param RGB101010Max
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010Min
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16Q12.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16Q12.
 
 @param flags
 <pre> \textblock
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB16Q12 to RGBA1010102 format.
 
 RGBA1010102 is almost the same format that is defined in CVPixelBuffer.h as 'kCVPixelFormatType_30RGB'
 except that this format uses the least significant 2 bits for alpha channel.
 
 This format is 10-bit big endian 32-bit pixels.
 
 RGB101010RangeMax & RGB101010RangeMin are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 
 <pre> \textblock
 RGB101010RangeMax  = 1023;
 RGB101010RangeMin  = 0;
 \/textblock </pre>
 
 RGB101010Max & RGB101010Min are available to specify the min / max of the representation.
 This will be used as clipping the results.
 
 <pre> \textblock
 RGB101010Max  = 1023;
 RGB101010Min  = 0;
 \/textblock </pre>
 
 This is needed because 16Q12 has a chance to be outside of [0.0, 1.0] range and we are converting those
 values into video-range. Then, there will be some numbers outside of 10-bit video-range and we want those
 values to be representable as much as possible.
 
 The per-pixel operation is:
 <pre> \textblock
 
 int16_t *srcPixel = src.data;
 A16 = srcPixel[permuteMap[0]];
 R16 = srcPixel[permuteMap[1]];
 G16 = srcPixel[permuteMap[2]];
 B16 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 int32_t R10, G10, B10;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 R10 = CLAMP(RGB101010Min, ((R16 * range10 + 2048) >> 12) + RGB101010RangeMin, RGB101010Max);
 G10 = CLAMP(RGB101010Min, ((G16 * range10 + 2048) >> 12) + RGB101010RangeMin, RGB101010Max);
 B10 = CLAMP(RGB101010Min, ((B16 * range10 + 2048) >> 12) + RGB101010RangeMin, RGB101010Max);
 A10 = CLAMP( 0, (A16 * 3 + 2048) >> 12), 3);
 
 uint32_t *destPixel = dest.data;
 destPixel[0] = htonl((R10 << 22) | (G10 << 12) | (B10 << 2) | A10);
 destPixel += 1;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 kvImageInvalidParameter         Is returned when RGB101010Min > RGB101010Max || RGB101010RangeMin > RGB101010RangeMax
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12ToRGBA1010102(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, int RGB101010Min, int RGB101010Max, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12ToRGBA1010102(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, int RGB101010Min, int RGB101010Max, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12ToRGBA1010102(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, int RGB101010Min, int RGB101010Max, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);


/**
 \function vImageConvert_RGBA1010102ToARGB16U
 
 \abstract Convert RGBA1010102 to ARGB16U format.
 
 @param src
 A pointer to vImage_Buffer that references 10-bit RGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 16-bit ARGB interleaved destination pixels.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16U.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16U.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3.
 
 @param flags
 <pre> \textblock
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert RGBA1010102 to ARGB16U format
 
 RGBA1010102 is almost the same format that is defined in CVPixelBuffer.h as 'kCVPixelFormatType_30RGB'
 except that this format uses the least significant 2 bits for alpha channel.
 
 This format is 10-bit big endian 32-bit pixels.
 
 RGB101010RangeMax & RGB101010RangeMin are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 
 <pre> \textblock
 RGB101010RangeMax  = 1023;
 RGB101010RangeMin  = 0;
 \/textblock </pre>
 
 The per-pixel operation is:
 <pre> \textblock
 
 uint32_t *srcPixel = src.data;
 uint32_t pixel = ntohl(srcPixel[0]);
 srcPixel += 1;
 
 int32_t A2  = pixel & 0x3;
 int32_t R10 = (pixel >> 22) & 0x3ff;
 int32_t G10 = (pixel >> 12) & 0x3ff;
 int32_t B10 = (pixel >>  2) & 0x3ff;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 
 A2  = (A2 * USHRT_MAX + 1) / 3;
 R10 = ((R10 - RGB101010RangeMin) * USHRT_MAX + (range10 >> 1)) / range10;
 G10 = ((G10 - RGB101010RangeMin) * USHRT_MAX + (range10 >> 1)) / range10;
 B10 = ((B10 - RGB101010RangeMin) * USHRT_MAX + (range10 >> 1)) / range10;
 
 uint16_t R16, G16, B16;
 R16 = CLAMP(0, R10, USHRT_MAX);
 G16 = CLAMP(0, G10, USHRT_MAX);
 B16 = CLAMP(0, B10, USHRT_MAX);
 
 uint16_t ARGB[4];
 ARGB[0] = A2;
 ARGB[1] = R16;
 ARGB[2] = G16;
 ARGB[3] = B16;
 
 uint16_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 \/textblock </pre>
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax.
 \/textblock </pre>
 
 Note: Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_RGBA1010102ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGBA1010102ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_RGBA1010102ToARGB16U(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB16UToRGBA1010102
 
 \abstract Convert ARGB16U to RGBA1010102 format.
 
 @param src
 A pointer to vImage_Buffer that references 16-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 10-bit RGB interleaved destination pixels.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16U.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16U.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel appears only once.
 
 @param flags
 <pre> \textblock
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock </pre>
 \discussion Convert ARGB16U to RGB101010 format.
 
 RGB101010 is almost the same format that is defined in CVPixelBuffer.h as 'kCVPixelFormatType_30RGB'
 except that this format uses the least significant 2 bits for alpha channel.
 
 This format is 10-bit big endian 32-bit pixels.
 
 RGB101010RangeMax & RGB101010RangeMin are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 
 RGB101010RangeMax  = 1023;
 RGB101010RangeMin  = 0;
 
 The per-pixel operation is:
 
 uint16_t *srcPixel = src.data;
 A16 = srcPixel[permuteMap[0]];
 R16 = srcPixel[permuteMap[1]];
 G16 = srcPixel[permuteMap[2]];
 B16 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 int32_t R10, G10, B10;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 R10 = ((R16 * range10 + (USHRT_MAX >> 1)) / USHRT_MAX) + RGB101010RangeMin;
 G10 = ((G16 * range10 + (USHRT_MAX >> 1)) / USHRT_MAX) + RGB101010RangeMin;
 B10 = ((B16 * range10 + (USHRT_MAX >> 1)) / USHRT_MAX) + RGB101010RangeMin;
 A10 = ((A16 * 3 + (USHRT_MAX >> 1)) / USHRT_MAX);
 
 uint32_t *destPixel = dest.data;
 destPixel[0] = htonl((R10 << 22) | (G10 << 12) | (B10 << 2) | A10);
 destPixel += 1;
 
 @return
 <pre> \textblock
 kvImageNoError                  Is returned when there was no error.
 kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax.
 \/textblock </pre>
 
 Results are guaranteed to be faithfully rounded.
 
 
 */

public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToRGBA1010102(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToRGBA1010102(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToRGBA1010102(@Const vImage_Buffer src, @Const vImage_Buffer dest, int RGB101010RangeMin, int RGB101010RangeMax, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);

/** \functiongroup RGB888 */

/**
 \function vImagePermuteChannels_RGB888
 
 \abstract Reorder 3 color channels within the buffer according to the permute map.
 
 @param src
 A pointer to vImage_Buffer that references 8-bit 3-channel interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit 3-channel interleaved destination pixels.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For exmaple, permuteMap[3] = {0, 1, 2} or NULL will produce the same dest pixels as the src.
 permuteMap[3] = {2, 1, 0} is the reverse ordered dest pixels from the dest.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, or 2.
 
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 
 \discussion This function can be used to reorder 3 color channel buffer.
 
 The per-pixel operation is:
 
 <pre>{@code
 uint8_t *srcRow = src.data;
 uint8_t *destRow = dest.data;
 
 R = srcRow[permuteMap[0]];
 G = srcRow[permuteMap[1]];
 B = srcRow[permuteMap[2]];
 srcRow += 3;
 
 destRow[0] = R;
 destRow[1] = G;
 destRow[2] = B;
 destRow += 3;
 }</pre>
 
 @return kvImageNoError                  Is returned when there was no error.
 @return kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 @return kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 
 \note Works in place.
 */

public static native @Cast("vImage_Error") long vImagePermuteChannels_RGB888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") BytePointer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImagePermuteChannels_RGB888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") ByteBuffer permuteMap, @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImagePermuteChannels_RGB888(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("const uint8_t*") byte[] permuteMap, @Cast("vImage_Flags") long flags);


/**
 \functiongroup Format agnostic
 */

/**
 \function vImageCopyBuffer
 
 \abstract Copy vImage buffer from src to dest.
 
 @param src
 A pointer to source vImage_Buffer.
 
 @param dest
 A pointer to destination vImage_Buffer.
 
 @param pixelSize
 Number of bytes for one pixel.
 
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 \p kvImageGetTempBufferSize    Returns 0. Does no work.
 
 @return \p kvImageNoError                      Is returned when there was no error.
 @return \p kvImageRoiLargerThanInputBuffer     Is returned when src.width < dest.width || src.height < dest.height
 
 \seealso vImage_Buffer
 */

public static native @Cast("vImage_Error") long vImageCopyBuffer(@Const vImage_Buffer src, @Const vImage_Buffer dest, @Cast("size_t") long pixelSize, @Cast("vImage_Flags") long flags );


/**  \functiongroup XRGB2101010  */
/**
 \function vImageConvert_XRGB2101010ToARGB8888
 
 \abstract Convert XRGB2101010 to ARGB8888 format.
 
 @param src
 A pointer to vImage_Buffer that references 10-bit RGB interleaved source pixels.
 XRGB2101010 pixels must be at least 4 byte aligned.
 
 @param dest
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved destination pixels.
 ARGB8888 pixels may have any alignment.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For example, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3, as long as each channel appears only once.
 
 @param flags
 <pre> \textblock
 kvImageDoNotTile            Disables internal multithreading, if any.
 \/textblock <pre>
 
 \discussion
 This format is 10-bit little endian 32-bit pixels. The 2 MSB are zero.
 
 RGB101010RangeMin & RGB101010RangeMax are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 <pre>{@code
 RGB101010RangeMin  = 0;
 RGB101010RangeMax  = 1023;
 }</pre>
 
 The per-pixel operation is:
 
 <pre>{@code
 uint32_t *srcPixel = src.data;
 uint32_t pixel = srcPixel[0];
 srcPixel += 1;
 
 int32_t R10 = (pixel >> 20) & 0x3ff;
 int32_t G10 = (pixel >> 10) & 0x3ff;
 int32_t B10 = (pixel >>  0) & 0x3ff;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 
 R10 = ((R10 - RGB101010RangeMin) * UCHAR_MAX + (range10 >> 1)) / range10;
 G10 = ((G10 - RGB101010RangeMin) * UCHAR_MAX + (range10 >> 1)) / range10;
 B10 = ((B10 - RGB101010RangeMin) * UCHAR_MAX + (range10 >> 1)) / range10;
 
 uint8_t R8, G8, B8;
 R8 = CLAMP(0, R10, UCHAR_MAX);
 G8 = CLAMP(0, G10, UCHAR_MAX);
 B8 = CLAMP(0, B10, UCHAR_MAX);
 
 uint8_t ARGB[4];
 ARGB[0] = alpha;
 ARGB[1] = R8;
 ARGB[2] = G8;
 ARGB[3] = B8;
 
 uint8_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 }</pre>
 
 @return \p kvImageNoError                  Is returned when there was no error.
 @return \p kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 @return \p kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 @return \p kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax
 or when RGB101010RangeMin < 0 || RGB101010RangeMax > 1023.
 
 \note Results are guaranteed to be faithfully rounded.
 
 \seealso vImageConvert_ARGB2101010ToARGB8888
 */
public static native @Cast("vImage_Error") long vImageConvert_XRGB2101010ToARGB8888(@Const vImage_Buffer src, @Cast("uint8_t") byte alpha,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") BytePointer permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_XRGB2101010ToARGB8888(@Const vImage_Buffer src, @Cast("uint8_t") byte alpha,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_XRGB2101010ToARGB8888(@Const vImage_Buffer src, @Cast("uint8_t") byte alpha,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") byte[] permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB2101010ToARGB8888(@Const vImage_Buffer src,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") BytePointer permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB2101010ToARGB8888(@Const vImage_Buffer src,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB2101010ToARGB8888(@Const vImage_Buffer src,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") byte[] permuteMap,
                                                           @Cast("vImage_Flags") long flags);


/**
 \function vImageConvert_ARGB8888ToXRGB2101010
 
 \abstract Convert ARGB8888 to XRGB2101010 format.
 
 @param src
 A pointer to vImage_Buffer that references 8-bit ARGB interleaved source pixels.
 ARGB8888 pixels may have any alignment.
 
 @param dest
 A pointer to vImage_Buffer that references 10-bit RGB interleaved destination pixels.
 XRGB2101010 pixels must be at least 4 byte aligned.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of src.
 For example, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB8888.
 permuteMap[4] = {3, 2, 1, 0} is BGRA8888.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3,
 as long as each channel appears only once.
 
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 
 \discussion
 This format is 10-bit little endian 32-bit pixels. The 2 MSB are zero.
 
 RGB101010RangeMin & RGB101010RangeMax are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 <pre>{@code
 RGB101010RangeMin  = 0;
 RGB101010RangeMax  = 1023;
 }</pre>
 
 The per-pixel operation is:
 
 <pre>{@code
 uint8_t *srcPixel = src.data;
 R8 = srcPixel[permuteMap[1]];
 G8 = srcPixel[permuteMap[2]];
 B8 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 int32_t R10, G10, B10;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 int32_t rounding = UCHAR_MAX >> 1;
 R10 = ((R8 * range10 + rounding) / UCHAR_MAX) + RGB101010RangeMin;
 G10 = ((G8 * range10 + rounding) / UCHAR_MAX) + RGB101010RangeMin;
 B10 = ((B8 * range10 + rounding) / UCHAR_MAX) + RGB101010RangeMin;
 
 uint32_t *destPixel = dest.data;
 destPixel[0] = (R10 << 20) | (G10 << 10) | (B10 << 0);
 destPixel += 1;
 }</pre>
 
 @return \p kvImageNoError                  Is returned when there was no error.
 @return \p kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 @return \p kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 @return \p kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax
 or when RGB101010RangeMin < 0 || RGB101010RangeMax > 1023.
 
 \note Results are guaranteed to be faithfully rounded.
 
 \seealso vImageConvert_ARGB8888ToARGB2101010
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToXRGB2101010(@Const vImage_Buffer src,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") BytePointer permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToXRGB2101010(@Const vImage_Buffer src,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToXRGB2101010(@Const vImage_Buffer src,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") byte[] permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToARGB2101010(@Const vImage_Buffer src,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") BytePointer permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToARGB2101010(@Const vImage_Buffer src,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                           @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB8888ToARGB2101010(@Const vImage_Buffer src,
                                                           @Const vImage_Buffer dest,
                                                           int RGB101010RangeMin, int RGB101010RangeMax,
                                                           @Cast("const uint8_t*") byte[] permuteMap,
                                                           @Cast("vImage_Flags") long flags);


/**
 \function vImageConvert_XRGB2101010ToARGB16Q12
 
 \abstract Convert XRGB2101010 to ARGB16Q12 format.
 
 @param src
 A pointer to vImage_Buffer that references 10-bit RGB interleaved source pixels.
 XRGB2101010 pixels must be at least 4 byte aligned.
 
 @param dest
 A pointer to vImage_Buffer that references 16Q12 ARGB interleaved destination pixels.
 ARGB16Q12 ixels must be at least 2 byte aligned.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For example, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16Q12.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16Q12.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3,
 as long as each channel appears only once.
 
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 
 \discussion
 This format is 10-bit little endian 32-bit pixels. The 2 MSB are zero.
 
 RGB101010RangeMin & RGB101010RangeMax are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 <pre>{@code
 RGB101010RangeMin  = 0;
 RGB101010RangeMax  = 1023;
 }</pre>
 
 The per-pixel operation is:
 
 <pre>{@code
 uint32_t *srcPixel = src.data;
 srcPixel += 1;
 
 int32_t R10 = (pixel >> 20) & 0x3ff;
 int32_t G10 = (pixel >> 10) & 0x3ff;
 int32_t B10 = (pixel >>  0) & 0x3ff;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 
 int16_t R16, G16, B16;
 R16 = ((R10 - RGB101010RangeMin) * 4096 + (range10 >> 1)) / range10;
 G16 = ((G10 - RGB101010RangeMin) * 4096 + (range10 >> 1)) / range10;
 B16 = ((B10 - RGB101010RangeMin) * 4096 + (range10 >> 1)) / range10;
 
 R16 = CLAMP(INT16_MIN, R16, INT16_MAX);
 G16 = CLAMP(INT16_MIN, G16, INT16_MAX);
 B16 = CLAMP(INT16_MIN, B16, INT16_MAX);
 
 int16_t ARGB[4];
 ARGB[0] = alpha;
 ARGB[1] = R16;
 ARGB[2] = G16;
 ARGB[3] = B16;
 
 int16_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 }</pre>
 
 @return \p kvImageNoError                  Is returned when there was no error.
 @return \p kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 @return \p kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 @return \p kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax
 or when RGB101010RangeMin < 0 || RGB101010RangeMax > 1023.
 
 \note Results are guaranteed to be faithfully rounded.
 
 \seealso vImageConvert_ARGB2101010ToARGB16Q12
 */
public static native @Cast("vImage_Error") long vImageConvert_XRGB2101010ToARGB16Q12(@Const vImage_Buffer src, @Cast("Pixel_16Q12") short alpha,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            @Cast("const uint8_t*") BytePointer permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_XRGB2101010ToARGB16Q12(@Const vImage_Buffer src, @Cast("Pixel_16Q12") short alpha,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_XRGB2101010ToARGB16Q12(@Const vImage_Buffer src, @Cast("Pixel_16Q12") short alpha,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            @Cast("const uint8_t*") byte[] permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB2101010ToARGB16Q12(@Const vImage_Buffer src,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            @Cast("const uint8_t*") BytePointer permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB2101010ToARGB16Q12(@Const vImage_Buffer src,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB2101010ToARGB16Q12(@Const vImage_Buffer src,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            @Cast("const uint8_t*") byte[] permuteMap,
                                                            @Cast("vImage_Flags") long flags);


/**
 \function vImageConvert_ARGB16Q12ToXRGB2101010
 
 \abstract Convert ARGB16Q12 to XRGB2101010 format.
 
 @param src
 A pointer to vImage_Buffer that references 16Q12 ARGB interleaved source pixels.
 ARGB16Q12 pixels must be at least 2 byte aligned.
 
 @param dest
 A pointer to vImage_Buffer that references 10-bit RGB interleaved destination pixels.
 XRGB2101010 pixels must be at least 4 byte aligned.
 
 @param RGB101010RangeMax
 A maximum value for the range of 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for the range of 10-bit RGB pixel.
 
 @param RGB101010Max
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010Min
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For example, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16Q12.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16Q12.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3,
 as long as each channel appears only once.
 
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 
 \discussion
 This format is 10-bit little endian 32-bit pixels. The 2 MSB are zero.
 
 RGB101010RangeMin & RGB101010RangeMax are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 <pre>{@code
 RGB101010RangeMin  = 0;
 RGB101010RangeMax  = 1023;
 }</pre>
 
 This is needed because 16Q12 has a chance to be outside of [0.0, 1.0] range and we are converting those
 values into video-range. In that case, there will be some numbers outside of 10-bit video-range and we
 want those values to be representable as much as possible.
 
 The per-pixel operation is:
 <pre>{@code
 
 int16_t *srcPixel = src.data;
 R16 = srcPixel[permuteMap[1]];
 G16 = srcPixel[permuteMap[2]];
 B16 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 int32_t R10, G10, B10;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 R10 = CLAMP(RGB101010Min, ((R16 * range10 + 2048) >> 12) + RGB101010RangeMin, RGB101010Max);
 G10 = CLAMP(RGB101010Min, ((G16 * range10 + 2048) >> 12) + RGB101010RangeMin, RGB101010Max);
 B10 = CLAMP(RGB101010Min, ((B16 * range10 + 2048) >> 12) + RGB101010RangeMin, RGB101010Max);
 A10 = CLAMP( 0, (A16 * 3 + 2048) >> 12), 3);
 
 uint32_t *destPixel = dest.data;
 destPixel[0] = (R10 << 20) | (G10 << 10) | (B10 << 0);
 destPixel += 1;
 }</pre>
 
 @return \p kvImageNoError                  Is returned when there was no error.
 @return \p kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 @return \p kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 @return \p kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax
 or when RGB101010RangeMin < 0 || RGB101010RangeMax > 1023.
 
 \note Results are guaranteed to be faithfully rounded.
 
 \seealso vImageConvert_ARGB16Q12ToARGB2101010
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12ToXRGB2101010(@Const vImage_Buffer src,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            int RGB101010Min, int RGB101010Max,
                                                            @Cast("const uint8_t*") BytePointer permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12ToXRGB2101010(@Const vImage_Buffer src,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            int RGB101010Min, int RGB101010Max,
                                                            @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12ToXRGB2101010(@Const vImage_Buffer src,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            int RGB101010Min, int RGB101010Max,
                                                            @Cast("const uint8_t*") byte[] permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12ToARGB2101010(@Const vImage_Buffer src,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            int RGB101010Min, int RGB101010Max,
                                                            @Cast("const uint8_t*") BytePointer permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12ToARGB2101010(@Const vImage_Buffer src,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            int RGB101010Min, int RGB101010Max,
                                                            @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                            @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16Q12ToARGB2101010(@Const vImage_Buffer src,
                                                            @Const vImage_Buffer dest,
                                                            int RGB101010RangeMin, int RGB101010RangeMax,
                                                            int RGB101010Min, int RGB101010Max,
                                                            @Cast("const uint8_t*") byte[] permuteMap,
                                                            @Cast("vImage_Flags") long flags);


/**
 \function vImageConvert_XRGB2101010ToARGB16U
 
 \abstract Convert XRGB2101010 to ARGB16U format.
 
 @param src
 A pointer to vImage_Buffer that references 10-bit RGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 16-bit ARGB interleaved destination pixels.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For example, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16U.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16U.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3,
 as long as each channel appears only once.
 
 @param flags
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 
 \discussion
 This format is 10-bit little endian 32-bit pixels. The 2 MSB are zero.
 
 RGB101010RangeMin & RGB101010RangeMax are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 <pre>{@code
 RGB101010RangeMin  = 0;
 RGB101010RangeMax  = 1023;
 }</pre>
 
 The per-pixel operation is:
 <pre>{@code
 uint32_t *srcPixel = src.data;
 uint32_t pixel = ntohl(srcPixel[0]);
 srcPixel += 1;
 
 int32_t R10 = (pixel >> 20) & 0x3ff;
 int32_t G10 = (pixel >> 10) & 0x3ff;
 int32_t B10 = (pixel >>  0) & 0x3ff;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 
 R10 = ((R10 - RGB101010RangeMin) * USHRT_MAX + (range10 >> 1)) / range10;
 G10 = ((G10 - RGB101010RangeMin) * USHRT_MAX + (range10 >> 1)) / range10;
 B10 = ((B10 - RGB101010RangeMin) * USHRT_MAX + (range10 >> 1)) / range10;
 
 uint16_t R16, G16, B16;
 R16 = CLAMP(0, R10, USHRT_MAX);
 G16 = CLAMP(0, G10, USHRT_MAX);
 B16 = CLAMP(0, B10, USHRT_MAX);
 
 uint16_t ARGB[4];
 ARGB[0] = alpha;
 ARGB[1] = R16;
 ARGB[2] = G16;
 ARGB[3] = B16;
 
 uint16_t *destPixel = dest.data;
 destPixel[0] = ARGB[permuteMap[0]];
 destPixel[1] = ARGB[permuteMap[1]];
 destPixel[2] = ARGB[permuteMap[2]];
 destPixel[3] = ARGB[permuteMap[3]];
 destPixel += 4;
 }</pre>
 
 @return \p kvImageNoError                  Is returned when there was no error.
 @return \p kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 @return \p kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 @return \p kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax
 or when RGB101010RangeMin < 0 || RGB101010RangeMax > 1023.
 
 \note Results are guaranteed to be faithfully rounded.
 
 \seealso vImageConvert_ARGB2101010ToARGB16U
 */
public static native @Cast("vImage_Error") long vImageConvert_XRGB2101010ToARGB16U(@Const vImage_Buffer src, @Cast("uint16_t") short alpha,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") BytePointer permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_XRGB2101010ToARGB16U(@Const vImage_Buffer src, @Cast("uint16_t") short alpha,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_XRGB2101010ToARGB16U(@Const vImage_Buffer src, @Cast("uint16_t") short alpha,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") byte[] permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB2101010ToARGB16U(@Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") BytePointer permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB2101010ToARGB16U(@Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB2101010ToARGB16U(@Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") byte[] permuteMap,
                                                          @Cast("vImage_Flags") long flags);

/**
 \function vImageConvert_ARGB16UToXRGB2101010
 
 \abstract Convert ARGB16U to XRGB2101010 format.
 
 @param src
 A pointer to vImage_Buffer that references 16-bit ARGB interleaved source pixels.
 
 @param dest
 A pointer to vImage_Buffer that references 10-bit RGB interleaved destination pixels.
 
 @param RGB101010RangeMax
 A maximum value for 10-bit RGB pixel.
 
 @param RGB101010RangeMin
 A minimum value for 10-bit RGB pixel.
 
 @param permuteMap
 Values that can be used to switch the channel order of dest.
 For example, permuteMap[4] = {0, 1, 2, 3} or NULL are ARGB16U.
 permuteMap[4] = {3, 2, 1, 0} is BGRA16U.
 Any order of permuteMap is allowed when each permuteMap value is 0, 1, 2, or 3,
 as long as each channel appears only once.
 
 @param flags
 \p kvImageDoNotTile            Disables internal multithreading, if any.
 
 \discussion
 This format is 10-bit big endian 32-bit pixels.
 
 RGB101010RangeMin & RGB101010RangeMax are available for non-full-range pixel values.
 For full-range pixel values, the user can set these as
 
 <pre>{@code
 RGB101010RangeMin  = 0;
 RGB101010RangeMax  = 1023;
 }</pre>
 
 The per-pixel operation is:
 <pre>{@code
 
 uint16_t *srcPixel = src.data;
 R16 = srcPixel[permuteMap[1]];
 G16 = srcPixel[permuteMap[2]];
 B16 = srcPixel[permuteMap[3]];
 srcPixel += 4;
 
 int32_t R10, G10, B10;
 int32_t range10 = RGB101010RangeMax - RGB101010RangeMin;
 R10 = ((R16 * range10 + (USHRT_MAX >> 1)) / USHRT_MAX) + RGB101010RangeMin;
 G10 = ((G16 * range10 + (USHRT_MAX >> 1)) / USHRT_MAX) + RGB101010RangeMin;
 B10 = ((B16 * range10 + (USHRT_MAX >> 1)) / USHRT_MAX) + RGB101010RangeMin;
 
 uint32_t *destPixel = dest.data;
 destPixel[0] = (R10 << 20) | (G10 << 10) | (B10 << 0);
 destPixel += 1;
 }</pre>
 
 @return \p kvImageNoError                  Is returned when there was no error.
 @return \p kvImageUnknownFlagsBit          Is returned when there is a unknown flag.
 @return \p kvImageRoiLargerThanInputBuffer Is returned when src.width < dest.width || src.height < dest.height
 @return \p kvImageInvalidParameter         Is returned when RGB101010RangeMin is bigger than RGB101010RangeMax
 or when RGB101010RangeMin < 0 || RGB101010RangeMax > 1023.
 
 \note Results are guaranteed to be faithfully rounded.
 
 \seealso vImageConvert_ARGB16UToARGB2101010
 */
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToXRGB2101010(@Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") BytePointer permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToXRGB2101010(@Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToXRGB2101010(@Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") byte[] permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToARGB2101010(@Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") BytePointer permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToARGB2101010(@Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_t*") ByteBuffer permuteMap,
                                                          @Cast("vImage_Flags") long flags);
public static native @Cast("vImage_Error") long vImageConvert_ARGB16UToARGB2101010(@Const vImage_Buffer src,
                                                          @Const vImage_Buffer dest,
                                                          int RGB101010RangeMin, int RGB101010RangeMax,
                                                          @Cast("const uint8_