// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package uncomplicate.javacpp.accelerate.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class vforce extends uncomplicate.javacpp.accelerate.presets.vforce {
    static { Loader.load(); }

// Parsed from vForce.h

/*
vForce.h (from vecLib-1068.100)
Copyright (c) 1999-2025 by Apple Inc. All rights reserved.

@APPLE_LICENSE_HEADER_START@

This file contains Original Code and/or Modifications of Original Code
as defined in and that are subject to the Apple Public Source License
Version 2.0 (the 'License'). You may not use this file except in
compliance with the License. Please obtain a copy of the License at
http://www.opensource.apple.com/apsl/ and read it before using this
file.

The Original Code and all software distributed under the License are
distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
Please see the License for the specific language governing rights and
limitations under the License.

@APPLE_LICENSE_HEADER_END@
*/

/** \header
 *  vForce provides fast mathematical operations on large arrays.
 *
 *  There are several differences between vForce and the similar functions
 *  available in libm. They are:
 *  1) vForce can operate on arrays of any size (libm only works on scalars,
 *     and simd.h on small fixed size vectors).
 *  2) vForce may treat some or all denormal numbers as zero.
 *  3) vForce does not guarantee to set floating point flags correctly.
 *
 *  However, unlike some fast math alternatives, vForce respects the closure of
 *  the number system, therefore infinities and NaNs are correctly processed.
 *
 *  Developers should assume that the exact value returned and treatment of
 *  denormal values will vary across different microarchitectures and versions
 *  of the operating system.
 *
 *  For very small vectors, users may wish to consider using simd.h for
 *  increased performance.
 */

// #ifndef __VFORCE_H
// #define __VFORCE_H

// #ifdef __cplusplus
// 	#include <ciso646>	// Get library version.
// 	#if	defined _LIBCPP_VERSION
		// When using libc++, include <complex>.
// 		#include <complex>
// 	#else
		// When not using libc++, try using definition as given in C++ 98.
// 	#endif
// #else
// #endif

// #include <math.h>

// #ifdef __cplusplus
// #endif

// #if __has_include(<os/availability.h>)
// #  include <os/availability.h>
// #else // __has_include(<os/availability.h>)
// 	#if !defined API_AVAILABLE
// 	#define API_AVAILABLE(...)
// 	#endif
// #endif // __has_include(<os/availability.h>)


// #if !defined __has_feature
//     #define __has_feature(f)    0
// #endif
// #if __has_feature(assume_nonnull)
// #endif



/** \abstract Calculates the reciprocal for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to 1/x[i].
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
    public static native void vvrecf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
    public static native void vvrecf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
    public static native void vvrecf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the reciprocal for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to 1/x[i].
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvrec(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvrec(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvrec(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the quotient of the two source vectors.
 *
 *  @param z (output) Output vector of size *n. z[i] is set to y[i]/x[i].
 *
 *  @param y (input)  Input vector of size *n, numerators in division.
 *
 *  @param x (input)  Input vector of size *n, denominators in division.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvdivf(FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2, @Const IntPointer arg3);
public static native void vvdivf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const FloatBuffer arg2, @Const IntBuffer arg3);
public static native void vvdivf(float[] arg0, @Const float[] arg1, @Const float[] arg2, @Const int[] arg3);
/** \abstract Calculates the quotient of the two source vectors.
 *
 *  @param z (output) Output vector of size *n. z[i] is set to y[i]/x[i].
 *
 *  @param y (input)  Input vector of size *n, numerators in division.
 *
 *  @param x (input)  Input vector of size *n, denominators in division.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvdiv(DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2, @Const IntPointer arg3);
public static native void vvdiv(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const DoubleBuffer arg2, @Const IntBuffer arg3);
public static native void vvdiv(double[] arg0, @Const double[] arg1, @Const double[] arg2, @Const int[] arg3);

/** \abstract Calculates the square root for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to sqrt(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsqrtf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvsqrtf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvsqrtf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the square root for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to sqrt(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsqrt(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvsqrt(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvsqrt(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the cube root for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cbrt(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcbrtf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvcbrtf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvcbrtf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the cube root for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cbrt(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcbrt(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvcbrt(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvcbrt(double[] arg0, @Const double[] arg1, @Const int[] arg2);
    
/** \abstract Calculates the reciprocal square root for each element of a
 *            vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to 1/sqrt(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvrsqrtf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvrsqrtf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvrsqrtf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the reciprocal square root for each element of a
 *            vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to 1/sqrt(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvrsqrt(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvrsqrt(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvrsqrt(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the exponential function e**x for each element of a
 *            vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to exp(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvexpf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvexpf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvexpf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the exponential function e**x for each element of a
 *            vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to exp(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvexp(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvexp(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvexp(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the base 2 exponential function 2**x for each element
 *            of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to exp2(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvexp2f(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvexp2f(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvexp2f(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the base 2 exponential function 2**x for each element
 *            of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to exp2(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvexp2(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvexp2(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvexp2(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates (e**x) - 1 for each element of a vector, with high
 *            accuracy around x=0.
 *
 *  \discussion
 *  If x is nearly zero, then the common expression exp(x) - 1.0 will suffer
 *  from catastrophic cancellation and the result will have little or no
 *  precision.  This function provides an alternative means to do this
 *  calculation without the risk of significant loss of precision.
 *
 *  \seealso log1pf
 *
 *  @param y (output) Output vector of size *n. y[i] is set to expm1(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvexpm1f(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvexpm1f(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvexpm1f(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates (e**x) - 1 for each element of a vector, with high
 *            accuracy around x=0.
 *
 *  \discussion
 *  If x is nearly zero, then the common expression exp(x) - 1.0 will suffer
 *  from catastrophic cancellation and the result will have little or no
 *  precision.  This function provides an alternative means to do this
 *  calculation without the risk of significant loss of precision.
 *
 *  \seealso log1p
 *
 *  @param y (output) Output vector of size *n. y[i] is set to expm1(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvexpm1(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvexpm1(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvexpm1(double[] arg0, @Const double[] arg1, @Const int[] arg2);
	
/** \abstract Calculates the natural logarithm for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlogf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvlogf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvlogf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the natural logarithm for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlog(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvlog(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvlog(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the logarithm base 10 for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log10(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlog10f(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvlog10f(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvlog10f(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the logarithm base 10 for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log10(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlog10(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvlog10(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvlog10(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates log(1+x) for each element of a vector, with high
 *            accuracy around x=0.
 *
 *  \discussion
 *  If x is nearly zero, the expression log(1+x) will be highly inaccurate
 *  due to floating point rounding errors in (1+x).
 *  This function provides an alternative means to calculate this value with
 *  higher accuracy.
 *
 *  \seealso expm1f
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log1p(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlog1pf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvlog1pf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvlog1pf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates log(1+x) for each element of a vector, with high
 *            accuracy around x=0.
 *
 *  \discussion
 *  If x is nearly zero, the expression log(1+x) will be highly inaccurate
 *  due to floating point rounding errors in (1+x).
 *  This function provides an alternative means to calculate this value with
 *  higher accuracy.
 *
 *  \seealso expm1
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log1p(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlog1p(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvlog1p(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvlog1p(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the base 2 logarithm for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log2(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlog2f(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvlog2f(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvlog2f(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the base 2 logarithm for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log2(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlog2(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvlog2(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvlog2(double[] arg0, @Const double[] arg1, @Const int[] arg2);
	
/** \abstract Returns, as a floating-point value, the unbiased floating-point
 *            exponent for each element of a vector.
 *
 *  \discussion
 *  For a non-zero finite floating-point number f, logb is defined to be the
 *  integer that satisfies abs(f) = significand * 2**logb(f), with significand
 *  in [1,2).
 *
 *  If x is +/-0, then y is set to -inf.
 *  If x is +/-inf, then y is set to +inf.
 *  If x is NaN, then y is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log10(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlogbf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvlogbf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvlogbf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Returns, as a floating-point value, the unbiased floating-point
 *            exponent for each element of a vector.
 *
 *  \discussion
 *  For a non-zero finite floating-point number f, logb is defined to be the
 *  integer that satisfies abs(f) = significand * 2**logb(f), with significand
 *  in [1,2).
 *
 *  If x is +/-0, then y is set to -inf.
 *  If x is +/-inf, then y is set to +inf.
 *  If x is NaN, then y is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to log10(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvlogb(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvlogb(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvlogb(double[] arg0, @Const double[] arg1, @Const int[] arg2);
	
/** \abstract Returns the absolute value for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to fabs(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvfabsf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvfabsf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvfabsf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Returns the absolute value for each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to fabs(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvfabs(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvfabs(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvfabs(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates, elementwise, x**y for two vectors x and y.
 *
 *  \discussion
 *  The following special values of x and y produce the given value of z:
 *         y            x         z
 *  ==============   =======   =======
 *  odd integer,<0    +/-0     +/-inf
 *  odd integer,>0    +/-0     +/-0
 *  otherwise,  <0    +/-0       +inf
 *  otherwise,  >0    +/-0       +0
 *      +/-inf          -1        1
 *       NaN            +1        1
 *      +/-0           NaN        1
 *        -inf        |x|<1      +inf
 *        -inf        |x|>1      +0
 *        +inf        |x|<1      +0
 *        +inf        |x|>1      +inf
 *  odd integer,<0     -inf      -0
 *  odd integer,>0     -inf      -inf
 *  otherwise,  <0     -inf      +0
 *  otherwise,  >0     -inf      +inf
 *        <0           +inf      +0
 *        >0           +inf      +inf
 *    non-integer       <0       NaN
 *
 *  @param z (output) Output vector of size *n. z[i] is set to pow(x[i], y[i]).
 *
 *  @param y (input)  Input vector of size *n, exponent in calculation.
 *
 *  @param x (input)  Input vector of size *n, base in calculation.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.
 */
public static native void vvpowf(FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2, @Const IntPointer arg3);
public static native void vvpowf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const FloatBuffer arg2, @Const IntBuffer arg3);
public static native void vvpowf(float[] arg0, @Const float[] arg1, @Const float[] arg2, @Const int[] arg3);
/** \abstract Calculates, elementwise, x**y for two vectors x and y.
 *
 *  \discussion
 *  The following special values of x and y produce the given value of z:
 *         y            x         z
 *  ==============   =======   =======
 *  odd integer,<0    +/-0     +/-inf
 *  odd integer,>0    +/-0     +/-0
 *  otherwise,  <0    +/-0       +inf
 *  otherwise,  >0    +/-0       +0
 *      +/-inf          -1        1
 *       NaN            +1        1
 *      +/-0           NaN        1
 *        -inf        |x|<1      +inf
 *        -inf        |x|>1      +0
 *        +inf        |x|<1      +0
 *        +inf        |x|>1      +inf
 *  odd integer,<0     -inf      -0
 *  odd integer,>0     -inf      -inf
 *  otherwise,  <0     -inf      +0
 *  otherwise,  >0     -inf      +inf
 *        <0           +inf      +0
 *        >0           +inf      +inf
 *    non-integer       <0       NaN
 *
 *  @param z (output) Output vector of size *n. z[i] is set to pow(x[i], y[i]).
 *
 *  @param y (input)  Input vector of size *n, exponent in calculation.
 *
 *  @param x (input)  Input vector of size *n, base in calculation.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.
 */
public static native void vvpow(DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2, @Const IntPointer arg3);
public static native void vvpow(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const DoubleBuffer arg2, @Const IntBuffer arg3);
public static native void vvpow(double[] arg0, @Const double[] arg1, @Const double[] arg2, @Const int[] arg3);

/** \abstract Calculates, elementwise, x**y for a vector x and a scalar y.
 *
 *  @param z (output) Output vector of size *n. z[i] is set to pow(x[i], y).
 *
 *  @param y (input)  Input scalar, exponent in calculation.
 *
 *  @param x (input)  Input vector of size *n, base in calculation.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvpowsf(FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2, @Const IntPointer arg3);
public static native void vvpowsf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const FloatBuffer arg2, @Const IntBuffer arg3);
public static native void vvpowsf(float[] arg0, @Const float[] arg1, @Const float[] arg2, @Const int[] arg3);
/** \abstract Calculates, elementwise, x**y for a vector x and a scalar y.
 *
 *  @param z (output) Output vector of size *n. z[i] is set to pow(x[i], y).
 *
 *  @param y (input)  Input scalar, exponent in calculation.
 *
 *  @param x (input)  Input vector of size *n, base in calculation.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvpows(DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2, @Const IntPointer arg3);
public static native void vvpows(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const DoubleBuffer arg2, @Const IntBuffer arg3);
public static native void vvpows(double[] arg0, @Const double[] arg1, @Const double[] arg2, @Const int[] arg3);

/** \abstract Returns the sine for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to sin(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsinf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvsinf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvsinf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Returns the sine for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to sin(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsin(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvsin(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvsin(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Returns the cosine for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-inf, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cos(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcosf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvcosf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvcosf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Returns the cosine for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-inf, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cos(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcos(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvcos(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvcos(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Returns the tangent for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to tan(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvtanf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvtanf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvtanf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Returns the tangent for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to tan(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvtan(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvtan(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvtan(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Returns the principal value of arc sine for each element of a
 *            vector.
 *
 *  \discussion
 *  The calculated values are in the range [-pi/2, +pi/2].
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If |x[i]| > 1, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to asin(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvasinf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvasinf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvasinf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Returns the principal value of arc sine for each element of a
 *            vector.
 *
 *  \discussion
 *  The calculated values are in the range [-pi/2, +pi/2].
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If |x[i]| > 1, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to asin(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvasin(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvasin(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvasin(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Returns the principal value of arc cosine for each element of a
 *            vector.
 *
 *  \discussion
 *  The calculated values are in the range [0, pi].
 *  If x[i] is 1, y[i] is set to +0.
 *  If |x[i]| > 1, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to acos(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvacosf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvacosf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvacosf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Returns the principal value of arc cosine for each element of a
 *            vector.
 *
 *  \discussion
 *  The calculated values are in the range [0, pi].
 *  If x[i] is 1, y[i] is set to +0.
 *  If |x[i]| > 1, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to acos(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvacos(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvacos(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvacos(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Returns the principal value of arc tangent for each element of a
 *            vector.
 *
 *  \discussion
 *  The calculated values are in the range [-pi/2, pi/2].
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to +/-pi/2.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to atan(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvatanf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvatanf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvatanf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Returns the principal value of arc tangent for each element of a
 *            vector.
 *
 *  \discussion
 *  The calculated values are in the range [-pi/2, pi/2].
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to +/-pi/2.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to atan(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvatan(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvatan(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvatan(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates, elementwise, the principal value of the arc tangent
 *            of y/x, for two vectors x and y.
 *
 *  \discusssion
 *  The signs of both arguments are used to determine the quadrant of the
 *  calculated value.
 *
 *  The following special values of x and y produce the given value of z:
 *     y         x         z
 *  =======   =======   =======
 *   +/-0       -0       +/-pi
 *   +/-0       +0       +/-0
 *   +/-0       <0       +/-pi
 *   +/-0       >0       +/-0
 *    >0       +/-0      +pi/2
 *    <0       +/-0      -pi/2
 *   +/-y      -inf      +/-pi       y>0, finite
 *   +/-y      +inf      +/-0        y>0, finite
 *  +/-inf      x       +/-pi/2      x finite
 *  +/-inf     -inf     +/-3pi/4
 *  +/-inf     +inf     +/-pi/4
 *
 *  @param z (output) Output vector of size *n. z[i] is set to atan2(y,x).
 *
 *  @param y (input)  Input vector of size *n.
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvatan2f(FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2, @Const IntPointer arg3);
public static native void vvatan2f(FloatBuffer arg0, @Const FloatBuffer arg1, @Const FloatBuffer arg2, @Const IntBuffer arg3);
public static native void vvatan2f(float[] arg0, @Const float[] arg1, @Const float[] arg2, @Const int[] arg3);
/** \abstract Calculates, elementwise, the principal value of the arc tangent
 *            of y/x, for two vectors x and y.
 *
 *  \discusssion
 *  The signs of both arguments are used to determine the quadrant of the
 *  calculated value.
 *
 *  The following special values of x and y produce the given value of z:
 *     y         x         z
 *  =======   =======   =======
 *   +/-0       -0       +/-pi
 *   +/-0       +0       +/-0
 *   +/-0       <0       +/-pi
 *   +/-0       >0       +/-0
 *    >0       +/-0      +pi/2
 *    <0       +/-0      -pi/2
 *   +/-y      -inf      +/-pi       y>0, finite
 *   +/-y      +inf      +/-0        y>0, finite
 *  +/-inf      x       +/-pi/2      x finite
 *  +/-inf     -inf     +/-3pi/4
 *  +/-inf     +inf     +/-pi/4
 *
 *  @param z (output) Output vector of size *n. z[i] is set to atan2(y,x).
 *
 *  @param y (input)  Input vector of size *n.
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvatan2(DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2, @Const IntPointer arg3);
public static native void vvatan2(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const DoubleBuffer arg2, @Const IntBuffer arg3);
public static native void vvatan2(double[] arg0, @Const double[] arg1, @Const double[] arg2, @Const int[] arg3);

/** \abstract Returns the sine and cosine for each element of a vector.
 *
 *  @param z (output) Output vector of size *n. z[i] is set to sin(x[i]).
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cos(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsincosf(FloatPointer arg0, FloatPointer arg1, @Const FloatPointer arg2, @Const IntPointer arg3);
public static native void vvsincosf(FloatBuffer arg0, FloatBuffer arg1, @Const FloatBuffer arg2, @Const IntBuffer arg3);
public static native void vvsincosf(float[] arg0, float[] arg1, @Const float[] arg2, @Const int[] arg3);
/** \abstract Returns the sine and cosine for each element of a vector.
 *
 *  @param z (output) Output vector of size *n. z[i] is set to sin(x[i]).
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cos(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsincos(DoublePointer arg0, DoublePointer arg1, @Const DoublePointer arg2, @Const IntPointer arg3);
public static native void vvsincos(DoubleBuffer arg0, DoubleBuffer arg1, @Const DoubleBuffer arg2, @Const IntBuffer arg3);
public static native void vvsincos(double[] arg0, double[] arg1, @Const double[] arg2, @Const int[] arg3);

/** \abstract Returns the complex number on the unit circle corresponding to
 *            the angle given by each element of a vector.
 *
 *  \discussion
 *  Sets the real part of C to the cosine of x, and the imaginary part to the
 *  sine of y.
 *
 *  The typedef __float_complex_t is defined on a per language basis, and the
 *  following types should be used:
 *  In C,   _Complex float
 *  In C++, std::complex<float>.
 *
 *  @param C (output) Output vector of size *n.
 *                    C[i] is set to cos(x[i]) + I*sin(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcosisinf(@Cast("__float_complex_t*") FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvcosisinf(@Cast("__float_complex_t*") FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvcosisinf(@Cast("__float_complex_t*") float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Returns the complex number on the unit circle corresponding to
 *            the angle given by each element of a vector.
 *
 *  \discussion
 *  Sets the real part of C to the cosine of x, and the imaginary part to the
 *  sine of y.
 *
 *  The typedef __double_complex_t is defined on a per language basis, and the
 *  following types should be used:
 *  In C,   _Complex double
 *  In C++, std::complex<double>.
 *
 *  @param C (output) Output vector of size *n.
 *                    C[i] is set to cos(x[i]) + I*sin(x[i]).
 *
 *  @param x (input)  Input vector of size *n, in radians.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcosisin(@Cast("__double_complex_t*") DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvcosisin(@Cast("__double_complex_t*") DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvcosisin(@Cast("__double_complex_t*") double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the hyperbolic sine for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to +/-inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to sinh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsinhf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvsinhf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvsinhf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the hyperbolic sine for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to +/-inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to sinh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsinh(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvsinh(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvsinh(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the hyperbolic cosine for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] is set to 1.
 *  If x[i] is +/-inf, y[i] is set to +inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cosh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcoshf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvcoshf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvcoshf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the hyperbolic cosine for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] is set to 1.
 *  If x[i] is +/-inf, y[i] is set to +inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cosh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcosh(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvcosh(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvcosh(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the hyperbolic tangent for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to +/-1.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to tanh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvtanhf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvtanhf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvtanhf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the hyperbolic tangent for each element of a vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to +/-1.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to tanh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvtanh(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvtanh(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvtanh(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the inverse hyperbolic sine for each element of a
 *            vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to +/-inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to asinh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvasinhf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvasinhf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvasinhf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the inverse hyperbolic sine for each element of a
 *            vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-inf, y[i] is set to +/-inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to asinh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvasinh(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvasinh(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvasinh(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the principal value of inverse hyperbolic cosine for
 *            each element of a vector.
 *
 *  \discussion
 *  The calculated values are in the range [0, +inf].
 *  If x[i] == 1, y[i] is set to +0.
 *  If x[i] < 1, y[i] is set to NaN.
 *  If x[i] == +inf, y[i] is set to +inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to acosh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvacoshf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvacoshf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvacoshf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the principal value of inverse hyperbolic cosine for
 *            each element of a vector.
 *
 *  \discussion
 *  The calculated values are in the range [0, +inf].
 *  If x[i] == 1, y[i] is set to +0.
 *  If x[i] < 1, y[i] is set to NaN.
 *  If x[i] == +inf, y[i] is set to +inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to acosh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvacosh(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvacosh(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvacosh(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the inverse hyperbolic tangent for each element of a
 *            vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-1, y[i] is set to +/-inf.
 *  If |x[i]|>1, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to atanh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvatanhf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvatanhf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvatanhf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the inverse hyperbolic tangent for each element of a
 *            vector.
 *
 *  \discussion
 *  If x[i] is +/-0, y[i] preserves the signed zero.
 *  If x[i] is +/-1, y[i] is set to +/-inf.
 *  If |x[i]|>1, y[i] is set to NaN.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to atanh(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvatanh(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvatanh(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvatanh(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the integer truncation for each element of a vector.
 *
 *  \discussion
 *  The behavior of this function is equivalent to the libm function truncf().
 *  It rounds x[i] to the nearest integer in the direction of zero,
 *  equivalent to the C typecast y[i] = (float) (int) x[i].
 *
 *  @param y (output) Output vector of size *n. y[i] is set to integer
 *                    trunction of x[i].
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvintf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvintf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvintf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the integer truncation for each element of a vector.
 *
 *  \discussion
 *  The behavior of this function is equivalent to the libm function trunc().
 *  It rounds x[i] to the nearest integer in the direction of zero,
 *  equivalent to the C typecast y[i] = (double) (int) x[i].
 *
 *  @param y (output) Output vector of size *n. y[i] is set to integer
 *                    trunction of x[i].
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvint(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvint(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvint(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the rounding to the nearest integer for each element
 *            of a vector.
 *
 *  \discussion
 *  Rounds x[i] to the nearest integer, with ties rounded to even.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to the nearest
 *                    integer to x[i].
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvnintf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvnintf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvnintf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the rounding to the nearest integer for each element
 *            of a vector.
 *
 *  \discussion
 *  Rounds x[i] to the nearest integer, with ties rounded to even.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to the nearest
 *                    integer to x[i].
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvnint(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvnint(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvnint(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the ceiling function for each element of a vector.
 *
 *  \discussion
 *  Rounds to smallest integral value not less than x[i]. That is to say,
 *  rounds towards +inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to ceil(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvceilf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvceilf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvceilf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the ceiling function for each element of a vector.
 *
 *  \discussion
 *  Rounds to smallest integral value not less than x[i]. That is to say,
 *  rounds towards +inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to ceil(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvceil(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvceil(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvceil(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the floor function for each element of a vector.
 *
 *  \discussion
 *  Rounds to smallest integral value not greater than x[i]. That is to say,
 *  rounds towards -inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to floor(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvfloorf(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvfloorf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvfloorf(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the floor function for each element of a vector.
 *
 *  \discussion
 *  Rounds to smallest integral value not greater than x[i]. That is to say,
 *  rounds towards -inf.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to floor(x[i]).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvfloor(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvfloor(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvfloor(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates, elementwise, the floating-point remainder of y/x,
 *            for two vectors x and y.
 *
 *  \discussion
 *  Specifically, the function calculates z=y-k*x, for some integer k such that,
 *  if x is non-zero, the result has the same sign as y, and magnitude less than
 *  that of x.
 *
 *  If y[i] is +/-0, and x[i] is not 0 or NaN, z[i] is set to +/-0.
 *  If y[i] is +/-inf, or x[i] is +/-0, z[i] is set to NaN.
 *  If x[i] is +/-inf, and y is finite, z[i] is set to y[i].
 *
 *  Note that argument labels are switched with respect to the libm function
 *  fmod().
 *
 *  \seealso vvremainderf
 *
 *  @param z (output) Output vector of size *n. z[i] is set to fmod(y[i], x[i]).
 *
 *  @param y (input)  Input vector of size *n, numerator in calculation.
 *
 *  @param x (input)  Input vector of size *n, denominator in calculation.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvfmodf(FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2, @Const IntPointer arg3);
public static native void vvfmodf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const FloatBuffer arg2, @Const IntBuffer arg3);
public static native void vvfmodf(float[] arg0, @Const float[] arg1, @Const float[] arg2, @Const int[] arg3);
/** \abstract Calculates, elementwise, the floating-point remainder of y/x,
 *            for two vectors x and y.
 *
 *  \discussion
 *  Specifically, the function calculates z=y-k*x, for some integer k such that,
 *  if x is non-zero, the result has the same sign as y, and magnitude less than
 *  that of x.
 *
 *  If y[i] is +/-0, and x[i] is not 0 or NaN, z[i] is set to +/-0.
 *  If y[i] is +/-inf, or x[i] is +/-0, z[i] is set to NaN.
 *  If x[i] is +/-inf, and y is finite, z[i] is set to y[i].
 *
 *  Note that argument labels are switched with respect to the libm function
 *  fmod().
 *
 *  \seealso vvremainder
 *
 *  @param z (output) Output vector of size *n. z[i] is set to fmod(y[i], x[i]).
 *
 *  @param y (input)  Input vector of size *n, numerator in calculation.
 *
 *  @param x (input)  Input vector of size *n, denominator in calculation.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvfmod(DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2, @Const IntPointer arg3);
public static native void vvfmod(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const DoubleBuffer arg2, @Const IntBuffer arg3);
public static native void vvfmod(double[] arg0, @Const double[] arg1, @Const double[] arg2, @Const int[] arg3);

/** \abstract Calculates, elementwise, the difference between k*x and y, where
 *            k is the nearest integer to y/x.
 *
 *  \discussion
 *  Specifically, the function calculates z=y-k*x, for the integer k nearest the
 *  exact value of y/x, with ties rounded to even.
 *  The result z satisfies abs(z) <= abs(x)/2.
 *
 *  If y-k*x is zero, it is given the same sign as y.
 *
 *  If y[i] is +/-inf, or x[i] is +/-0, z[i] is set to NaN.
 *  If x[i] is +/-inf, and y is finite, z[i] is set to y[i].
 *
 *  \seealso vvfmodf
 *
 *  @param z (output) Output vector of size *n. z[i] is set to y[i]-k[i]*x[i].
 *
 *  @param y (input)  Input vector of size *n, numerator in calculation.
 *
 *  @param x (input)  Input vector of size *n, denominator in calculation.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvremainderf(FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2, @Const IntPointer arg3);
public static native void vvremainderf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const FloatBuffer arg2, @Const IntBuffer arg3);
public static native void vvremainderf(float[] arg0, @Const float[] arg1, @Const float[] arg2, @Const int[] arg3);
/** \abstract Calculates, elementwise, the difference between k*x and y, where
 *            k is the nearest integer to y/x.
 *
 *  \discussion
 *  Specifically, the function calculates z=y-k*x, for the integer k nearest the
 *  exact value of y/x, with ties rounded to even.
 *  The result z satisfies abs(z) <= abs(x)/2.
 *
 *  If y-k*x is zero, it is given the same sign as y.
 *
 *  If y[i] is +/-inf, or x[i] is +/-0, z[i] is set to NaN.
 *  If x[i] is +/-inf, and y is finite, z[i] is set to y[i].
 *
 *  \seealso vvfmod
 *
 *  @param z (output) Output vector of size *n. z[i] is set to y[i]-k[i]*x[i].
 *
 *  @param y (input)  Input vector of size *n, numerator in calculation.
 *
 *  @param x (input)  Input vector of size *n, denominator in calculation.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvremainder(DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2, @Const IntPointer arg3);
public static native void vvremainder(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const DoubleBuffer arg2, @Const IntBuffer arg3);
public static native void vvremainder(double[] arg0, @Const double[] arg1, @Const double[] arg2, @Const int[] arg3);
	
/** \abstract Copies, elementwise, the sign of x with the value of y, for two
 *            vectors x and y.
 *
 *  @param z (output) Output vector of size *n.
 *                    z[i] is set to copysign(y[i], x[i]).
 *
 *  @param y (input)  Input vector of size *n, used for the magnitude.
 *
 *  @param x (input)  Input vector of size *n, used for the sign.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvcopysignf(FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2, @Const IntPointer arg3);
public static native void vvcopysignf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const FloatBuffer arg2, @Const IntBuffer arg3);
public static native void vvcopysignf(float[] arg0, @Const float[] arg1, @Const float[] arg2, @Const int[] arg3);
/** \abstract Copies, elementwise, the sign of x with the value of y, for two
 *            vectors x and y.
 *
 *  @param z (output) Output vector of size *n.
 *                    z[i] is set to copysign(y[i], x[i]).
 *
 *  @param y (input)  Input vector of size *n, used for the magnitude.
 *
 *  @param x (input)  Input vector of size *n, used for the sign.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvcopysign(DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2, @Const IntPointer arg3);
public static native void vvcopysign(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const DoubleBuffer arg2, @Const IntBuffer arg3);
public static native void vvcopysign(double[] arg0, @Const double[] arg1, @Const double[] arg2, @Const int[] arg3);

/** \abstract Determines, elementwise, the next machine representable number
 *            from y in the direction of x.
 *
 *  @param z (output) Output vector of size *n.
 *                    z[i] is set to nextafter(y[i], x[i]).
 *
 *  @param y (input)  Input vector of size *n, used for the magnitude.
 *
 *  @param x (input)  Input vector of size *n, used for the sign.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvnextafterf(FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2, @Const IntPointer arg3);
public static native void vvnextafterf(FloatBuffer arg0, @Const FloatBuffer arg1, @Const FloatBuffer arg2, @Const IntBuffer arg3);
public static native void vvnextafterf(float[] arg0, @Const float[] arg1, @Const float[] arg2, @Const int[] arg3);
/** \abstract Determines, elementwise, the next machine representable number
 *            from y in the direction of x.
 *
 *  @param z (output) Output vector of size *n.
 *                    z[i] is set to nextafter(y[i], x[i]).
 *
 *  @param y (input)  Input vector of size *n, used for the magnitude.
 *
 *  @param x (input)  Input vector of size *n, used for the sign.
 *
 *  @param n (input)  The number of elements in the vectors x, y and z.       */
public static native void vvnextafter(DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2, @Const IntPointer arg3);
public static native void vvnextafter(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const DoubleBuffer arg2, @Const IntBuffer arg3);
public static native void vvnextafter(double[] arg0, @Const double[] arg1, @Const double[] arg2, @Const int[] arg3);

/** \abstract Calculates the sine for pi times each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to sin(x[i]*PI).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsinpif(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvsinpif(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvsinpif(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the sine for pi times each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to sin(x[i]*PI).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvsinpi(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvsinpi(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvsinpi(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the cosine for pi times each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cos(x[i]*PI).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcospif(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvcospif(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvcospif(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the cosine for pi times each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to cos(x[i]*PI).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvcospi(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvcospi(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvcospi(double[] arg0, @Const double[] arg1, @Const int[] arg2);

/** \abstract Calculates the tangent for pi times each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to tan(x[i]*PI).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvtanpif(FloatPointer arg0, @Const FloatPointer arg1, @Const IntPointer arg2);
public static native void vvtanpif(FloatBuffer arg0, @Const FloatBuffer arg1, @Const IntBuffer arg2);
public static native void vvtanpif(float[] arg0, @Const float[] arg1, @Const int[] arg2);
/** \abstract Calculates the tangent for pi times each element of a vector.
 *
 *  @param y (output) Output vector of size *n. y[i] is set to tan(x[i]*PI).
 *
 *  @param x (input)  Input vector of size *n.
 *
 *  @param n (input)  The number of elements in the vectors x and y.          */
public static native void vvtanpi(DoublePointer arg0, @Const DoublePointer arg1, @Const IntPointer arg2);
public static native void vvtanpi(DoubleBuffer arg0, @Const DoubleBuffer arg1, @Const IntBuffer arg2);
public static native void vvtanpi(double[] arg0, @Const double[] arg1, @Const int[] arg2);

// #if __has_feature(assume_nonnull)
// #endif
	
// #ifdef __cplusplus
// #endif
// #endif /* __VFORCE_H */


}
