// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package uncomplicate.javacpp.accelerate.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class vdsp extends uncomplicate.javacpp.accelerate.presets.vdsp {
    static { Loader.load(); }

// Parsed from vDSP.h

/*
    File:       vecLib/vDSP.h

    Contains:   AltiVec DSP Interfaces

    Version:    vecLib-1068.100

    Copyright:  Copyright (c) 2000-2025 by Apple Inc. All rights reserved.

    For vDSP documentation, search for "vDSP" at <http://developer.apple.com>
    or search for one of the routine names below.

    Some documentation for vDSP routines is provided below.

    To report bugs, please use <http://developer.apple.com/bugreporter>.
*/
// #ifndef __VDSP__
// #define __VDSP__


// Tell compiler this file is idempotent (no need to process it more than once).
// #if PRAGMA_ONCE
//     #pragma once
// #endif


/*  Documentation conventions:

        Many of the routines below are documented with C-like pseudocode that
        describes what they do.  For example, vDSP_vadd is declared with:

            extern void vDSP_vadd(
                const float *__A,
                vDSP_Stride  __IA,
                const float *__B,
                vDSP_Stride  __IB,
                float       *__C,
                vDSP_Stride  __IC,
                vDSP_Length  __N)
 					API_AVAILABLE(macos(10.0), ios(4.0));

        and is described with:

            for (n = 0; n < N; ++n)
                C[n] = A[n] + B[n];

        The pseudocode uses two important simplifications:

            Names are shortened.

                The prefix "__" is removed.  This prefix is used in this
                header file so that Apple parameter names do not conflict with
                other developer macro names that might be used in source files
                that include this header, as when a program might use "#define
                N 1024" to set a preprocessor macro "N" to expand to "1024".

            Vectors are simplified by omitting strides.

                The parameters A and IA (with the prefix omitted) represent a
                vector with its elements at memory locations A[i*IA], for
                appropriate values of i.  In the pseudocode, the stride IA
                is omitted; the vector is treated as a simple mathematical
                vector with elements A[i].

                This default map is assumed for all vDSP routines unless stated
                otherwise.  An array without a stride parameter has unit
                stride.  Some routines have more complicated maps.  These are
                documented with each routine.

    Default maps:

        These default maps are used unless documented otherwise for a routine.
        For real vectors:

            Pseudocode:     Memory:
            C[n]            C[n*IC]

        For complex vectors:

            Pseudocode:     Memory:
            C[n]            C->realp[n*IC] + i * C->imagp[n*IC]

        Observe that C[n] in the pseudocode is a complex number, with a real
        component and an imaginary component.


    Pseudocode:

        The pseudo-code used to describe routines is largely C with some
        additions:

            e, pi, and i are the usual mathematical constants, approximately
            2.71828182845, 3.1415926535, and sqrt(-1).

            "**" is exponentiation.  3**4 is 81.

            Re and Im are the real and imaginary parts of a complex number.
            Re(3+4*i) is 3, and Im(3+4*i) is 4.

            sum(f(j), 0 <= j < N) is the sum of f(j) evaluated for each integer
            j from 0 (inclusive) to N (exclusive).  sum(j**2, 0 <= j < 4) is
            0 + 1 + 4 + 9 = 14.  Multiple dimensions may be used.  Thus,
            sum(f(j, k), 0 <= j < M, 0 <= k < N) is the sum of f(j, k)
            evaluated for each pair of integers (j, k) satisfying the
            constraints.

            conj(z) is the complex conjugate of z (the imaginary part is
            negated).

            |x| is the absolute value of x.

   Exactness, IEEE 754 conformance:

        vDSP routines are not expected to produce results identical to the
        pseudo-code in the descriptions, because vDSP routines are free to
        rearrange calculations for better performance.  These rearrangements
        are mathematical identities, so they would produce identical results
        if exact arithmetic were used.  However, floating-point arithmetic
        is approximate, and the rounding errors will often be different when
        operations are rearranged.

        Generally, vDSP routines are not expected to conform to IEEE 754.
        Notably, results may be not correctly rounded to the last bit even for
        elementary operations, and operations involving infinities and NaNs may
        be handled differently than IEEE 754 specifies.

    Const:

        vDSP does not modify the contents of input arrays (including input
        scalars passed by address).  If the specification of a routine does not
        state that it alters the memory that a parameter points to, then the
        routine does not alter that memory through that parameter.  (It may of
        course alter the same memory if it is also pointed to by an output
        parameter.  Such in-place operation is permitted for some vDSP routines
        and not for others.)

        Unfortunately, C semantics make it impractical to add "const" to
        pointers inside structs, because such structs are type-incompatible
        with structs containing pointers that are not const.  Thus, vDSP
        routines with complex parameters accept those parameters via
        DSPSplitComplex and DSPDoubleSplitComplex structs (among other types)
        and not via const versions of those structures.

    Strides:

        (Note:  This section introduces strides.  For an issue using strides
        with complex data, see "Complex strides" below.)

        Many vDSP routines use strides, which specify that the vector operated
        on is embedded in a larger array in memory.  Consider an array A of
        1024 elements.  Then:

            Passing a vDSP routine:     Says to operate on:

            Address A and stride 1      Each element A[j]

            Address A and stride 2      Every other element, A[j*2]

            Address A+1 and stride 2    Every other element, starting
                                        with A[1], so A[j*2+1]

        Strides may be used to operate on columns of multi-dimensional arrays.
        For example, consider a 32*64 element array, A[32][64].  Then passing
        address A+13 and stride 64 instructs vDSP to operate on the elements of
        column 13.

        When strides are used, generally there is some accompanying parameter
        that specifies the length of the operation.  This length is typically
        the number of elements to be processed, not the number in the larger
        array.  (Some vDSP routines have interactions between parameters so
        that the length may specify some number of output elements but requires
        a different numbe of input elements.  This is documented with each
        routine.)

    Complex strides:

        Strides with complex data (interleaved complex data, not split
        complex data) are complicated by a legacy issue.  Originally, complex
        data was regarded as an array of individual elements, so that memory
        containing values to represent complex numbers 2 + 3i, 4 + 5i, 6 + 7i,
        and so on, contained individual floating-point elements:

            A[0] A[1] A[2] A[3] A[4] A[5]…
             2    3    4    5    6    7  …

        This arrangement was said to have a stride of two, indicating that a
        new complex number starts every two elements.  In the modern view, we
        would regard this as an array of struct with a stride of one struct.
        Unfortunately, the vDSP interface is bound by requirements of backward
        compatibility and must retain the original use.

        Adding to this issue, a parameter is declared as a pointer to DSPComplex
        or DSPDoubleComplex (both structures of two floating-point elements),
        but its stride is still passed as a stride of floating-point elements.
        This means that, in C, to refer to complex element i of a vector C with
        stride IC, you must divide the stride by 2, using C[i*IC/2].
        Essentially, the floating-point element stride passed to the vDSP
        routine, IA, should be twice the complex-number struct stride.
*/


// For i386, translate new names to legacy names.
// #if defined __i386__ && !defined __vDSP_TRANSLATE__
// #include <vecLib/vDSP_translate.h>
// #endif


// #if __has_include(<os/availability.h>)
// #  include <os/availability.h>
// #else // __has_include(<os/availability.h>)
// 	#if !defined API_AVAILABLE
// 	#define API_AVAILABLE(...)
// 	#endif

// 	#if !defined API_DEPRECATED_WITH_REPLACEMENT
// 	#define API_DEPRECATED_WITH_REPLACEMENT(...)
// 	#endif
// #endif // __has_include(<os/availability.h>)

// #include <stdint.h>
// #include <stdbool.h>


// #ifdef __cplusplus
// #endif


// #include <TargetConditionals.h>
// #if !0 && !0 && (__STDC_HOSTED__ == 1)
// #else
// #define __vDSP_ENUM_GET_MACRO(_1, _2, NAME, ...) NAME
// #define __vDSP_NAMED_ENUM(_type, _name) _type _name; enum
// #define __vDSP_ANON_ENUM(_type) enum
// #define vDSP_ENUM(...) __vDSP_ENUM_GET_MACRO(__VA_ARGS__, __vDSP_NAMED_ENUM, __vDSP_ANON_ENUM)(__VA_ARGS__)
// #endif


// #if !defined __has_feature
//     #define __has_feature(f)    0
// #endif
// #if __has_feature(assume_nonnull)
// #else
//     #define __nullable
//     #define __nonnull
// #endif


// #pragma options align=power


/*  These symbols describe the vecLib version associated with this header.

    vDSP_Version0 is a major version number.
    vDSP_Version1 is a minor version number.
*/
public static final int vDSP_Version0 =   1068;
public static final int vDSP_Version1 =   100;


/*  Define types:

        vDSP_Length for numbers of elements in arrays and for indices of
        elements in arrays.  (It is also used for the base-two logarithm of
        numbers of elements, although a much smaller type is suitable for
        that.)

        vDSP_Stride for differences of indices of elements (which of course
        includes strides).
*/
// #if defined __arm64__ && !defined __LP64__
// #else
// #endif

/*  A DSPComplex or DSPDoubleComplex is a pair of float or double values that
    together represent a complex value.
*/
public static class DSPComplex extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public DSPComplex() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DSPComplex(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DSPComplex(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public DSPComplex position(long position) {
        return (DSPComplex)super.position(position);
    }
    @Override public DSPComplex getPointer(long i) {
        return new DSPComplex((Pointer)this).offsetAddress(i);
    }

    public native float real(); public native DSPComplex real(float setter);
    public native float imag(); public native DSPComplex imag(float setter);
}
public static class DSPDoubleComplex extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public DSPDoubleComplex() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DSPDoubleComplex(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DSPDoubleComplex(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public DSPDoubleComplex position(long position) {
        return (DSPDoubleComplex)super.position(position);
    }
    @Override public DSPDoubleComplex getPointer(long i) {
        return new DSPDoubleComplex((Pointer)this).offsetAddress(i);
    }

    public native double real(); public native DSPDoubleComplex real(double setter);
    public native double imag(); public native DSPDoubleComplex imag(double setter);
}


/*  A DSPSplitComplex or DSPDoubleSplitComplex is a structure containing
    two pointers, each to an array of float or double.  These represent arrays
    of complex values, with the real components of the values stored in one
    array and the imaginary components of the values stored in a separate
    array.
*/
public static class DSPSplitComplex extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public DSPSplitComplex() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DSPSplitComplex(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DSPSplitComplex(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public DSPSplitComplex position(long position) {
        return (DSPSplitComplex)super.position(position);
    }
    @Override public DSPSplitComplex getPointer(long i) {
        return new DSPSplitComplex((Pointer)this).offsetAddress(i);
    }

    public native FloatPointer realp(); public native DSPSplitComplex realp(FloatPointer setter);
    public native FloatPointer imagp(); public native DSPSplitComplex imagp(FloatPointer setter);
}
public static class DSPDoubleSplitComplex extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public DSPDoubleSplitComplex() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DSPDoubleSplitComplex(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DSPDoubleSplitComplex(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public DSPDoubleSplitComplex position(long position) {
        return (DSPDoubleSplitComplex)super.position(position);
    }
    @Override public DSPDoubleSplitComplex getPointer(long i) {
        return new DSPDoubleSplitComplex((Pointer)this).offsetAddress(i);
    }

    public native DoublePointer realp(); public native DSPDoubleSplitComplex realp(DoublePointer setter);
    public native DoublePointer imagp(); public native DSPDoubleSplitComplex imagp(DoublePointer setter);
}


/*  The following statements declare a few simple types and constants used by
    various vDSP routines.
*/
/** enum  */
public static final int
    kFFTDirection_Forward         = 1,
    kFFTDirection_Inverse         = -1;
/** enum  */
public static final int
    kFFTRadix2                    = 0,
    kFFTRadix3                    = 1,
    kFFTRadix5                    = 2;
/** enum  */
public static final int
    vDSP_HALF_WINDOW              = 1,
    vDSP_HANN_DENORM              = 0,
    vDSP_HANN_NORM                = 2;
    

/*  The following types define 24-bit data.
*/
public static class vDSP_uint24 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vDSP_uint24() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vDSP_uint24(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_uint24(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vDSP_uint24 position(long position) {
        return (vDSP_uint24)super.position(position);
    }
    @Override public vDSP_uint24 getPointer(long i) {
        return new vDSP_uint24((Pointer)this).offsetAddress(i);
    }
 public native @Cast("uint8_t") byte bytes(int i); public native vDSP_uint24 bytes(int i, byte setter);
@MemberGetter public native @Cast("uint8_t*") BytePointer bytes(); } // Unsigned 24-bit integer.
public static class vDSP_int24 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public vDSP_int24() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public vDSP_int24(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_int24(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public vDSP_int24 position(long position) {
        return (vDSP_int24)super.position(position);
    }
    @Override public vDSP_int24 getPointer(long i) {
        return new vDSP_int24((Pointer)this).offsetAddress(i);
    }
 public native @Cast("uint8_t") byte bytes(int i); public native vDSP_int24 bytes(int i, byte setter);
@MemberGetter public native @Cast("uint8_t*") BytePointer bytes(); }  // Signed 24-bit integer.


/*  The following types are pointers to structures that contain data used
    inside vDSP routines to assist FFT and biquad filter operations.  The
    contents of these structures may change from release to release, so
    applications should manipulate the values only via the corresponding vDSP
    setup and destroy routines.
*/
@Opaque public static class OpaqueFFTSetup extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public OpaqueFFTSetup() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OpaqueFFTSetup(Pointer p) { super(p); }
}
@Opaque public static class OpaqueFFTSetupD extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public OpaqueFFTSetupD() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OpaqueFFTSetupD(Pointer p) { super(p); }
}
@Opaque public static class vDSP_biquad_SetupStruct extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vDSP_biquad_SetupStruct() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_biquad_SetupStruct(Pointer p) { super(p); }
}
@Opaque public static class vDSP_biquad_SetupStructD extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vDSP_biquad_SetupStructD() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_biquad_SetupStructD(Pointer p) { super(p); }
}

    
/*  vDSP_biquadm_Setup or vDSP_biquadm_SetupD is a pointer to a filter object
    to be used with a multi-channel cascaded biquad IIR.  This object carries
    internal state which may be modified by any routine which uses it.  Upon
    creation, the state is initialized such that all delay elements are zero.
 
    Each filter object should only be used in a single thread at a time.
*/
@Opaque public static class vDSP_biquadm_SetupStruct extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vDSP_biquadm_SetupStruct() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_biquadm_SetupStruct(Pointer p) { super(p); }
}
@Opaque public static class vDSP_biquadm_SetupStructD extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vDSP_biquadm_SetupStructD() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_biquadm_SetupStructD(Pointer p) { super(p); }
}


/*  vDSP_create_fftsetup and vDSP_create_ffsetupD allocate memory and prepare
    constants used by single- and double-precision FFT routines, respectively.

    vDSP_destroy_fftsetup and vDSP_destroy_fftsetupD free the memory.  They
    may be passed a null pointer, in which case they have no effect.
*/
public static native OpaqueFFTSetup vDSP_create_fftsetup(
    @Cast("vDSP_Length") long __Log2n,
    @Cast("FFTRadix") int __Radix);

public static native void vDSP_destroy_fftsetup(OpaqueFFTSetup __setup);

public static native OpaqueFFTSetupD vDSP_create_fftsetupD(
    @Cast("vDSP_Length") long __Log2n,
    @Cast("FFTRadix") int __Radix);

public static native void vDSP_destroy_fftsetupD(OpaqueFFTSetupD __setup);


/*  vDSP_biquad_CreateSetup allocates memory and prepares the coefficients for
    processing a cascaded biquad IIR filter.

    vDSP_biquad_DestroySetup frees the memory allocated by
    vDSP_biquad_CreateSetup.
*/
public static native vDSP_biquad_SetupStruct vDSP_biquad_CreateSetup(
    @Const DoublePointer __Coefficients,
    @Cast("vDSP_Length") long __M);
public static native vDSP_biquad_SetupStruct vDSP_biquad_CreateSetup(
    @Const DoubleBuffer __Coefficients,
    @Cast("vDSP_Length") long __M);
public static native vDSP_biquad_SetupStruct vDSP_biquad_CreateSetup(
    @Const double[] __Coefficients,
    @Cast("vDSP_Length") long __M);
public static native vDSP_biquad_SetupStructD vDSP_biquad_CreateSetupD(
    @Const DoublePointer __Coefficients,
    @Cast("vDSP_Length") long __M);
public static native vDSP_biquad_SetupStructD vDSP_biquad_CreateSetupD(
    @Const DoubleBuffer __Coefficients,
    @Cast("vDSP_Length") long __M);
public static native vDSP_biquad_SetupStructD vDSP_biquad_CreateSetupD(
    @Const double[] __Coefficients,
    @Cast("vDSP_Length") long __M);

/*
    vDSP_biquad_SetCoefficientsDouble will
    update the filter coefficients within a valid vDSP_biquad_Setup object.

    Coefficients are specified in double precision.
 */
public static native void vDSP_biquad_SetCoefficientsDouble(
    vDSP_biquad_SetupStruct __setup,
    @Const DoublePointer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __nsec);
public static native void vDSP_biquad_SetCoefficientsDouble(
    vDSP_biquad_SetupStruct __setup,
    @Const DoubleBuffer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __nsec);
public static native void vDSP_biquad_SetCoefficientsDouble(
    vDSP_biquad_SetupStruct __setup,
    @Const double[] __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __nsec);

/*
    vDSP_biquad_SetCoefficientsSingle will
    update the filter coefficients within a valid vDSP_biquad_Setup object.

    Coefficients are specified in single precision.
 */
public static native void vDSP_biquad_SetCoefficientsSingle(
    vDSP_biquad_SetupStruct __setup,
    @Const FloatPointer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __nsec);
public static native void vDSP_biquad_SetCoefficientsSingle(
    vDSP_biquad_SetupStruct __setup,
    @Const FloatBuffer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __nsec);
public static native void vDSP_biquad_SetCoefficientsSingle(
    vDSP_biquad_SetupStruct __setup,
    @Const float[] __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __nsec);


public static native void vDSP_biquad_DestroySetup(
    vDSP_biquad_SetupStruct __setup);
public static native void vDSP_biquad_DestroySetupD(
    vDSP_biquad_SetupStructD __setup);


/*  vDSP_biquadm_CreateSetup (for float) or vDSP_biquadm_CreateSetupD (for
    double) allocates memory and prepares the coefficients for processing a
    multi-channel cascaded biquad IIR filter.  Delay values are set to zero.

    Unlike some other setup objects in vDSP, a vDSP_biquadm_Setup or
    vDSP_biquadm_SetupD contains data that is modified during a vDSP_biquadm or
    vDSP_biquadmD call, and it therefore may not be used more than once
    simultaneously, as in multiple threads.
 
    vDSP_biquadm_DestroySetup (for single) or vDSP_biquadm_DestroySetupD (for
    double) frees the memory allocated by the corresponding create-setup
    routine.
*/
public static native vDSP_biquadm_SetupStruct vDSP_biquadm_CreateSetup(
    @Const DoublePointer __coeffs,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native vDSP_biquadm_SetupStruct vDSP_biquadm_CreateSetup(
    @Const DoubleBuffer __coeffs,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native vDSP_biquadm_SetupStruct vDSP_biquadm_CreateSetup(
    @Const double[] __coeffs,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native vDSP_biquadm_SetupStructD vDSP_biquadm_CreateSetupD(
    @Const DoublePointer __coeffs,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native vDSP_biquadm_SetupStructD vDSP_biquadm_CreateSetupD(
    @Const DoubleBuffer __coeffs,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native vDSP_biquadm_SetupStructD vDSP_biquadm_CreateSetupD(
    @Const double[] __coeffs,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadm_DestroySetup(
    vDSP_biquadm_SetupStruct __setup);
public static native void vDSP_biquadm_DestroySetupD(
    vDSP_biquadm_SetupStructD __setup);

/*  vDSP_biquadm_CopyState (for float) or vDSP_biquadm_CopyStateD (for double)
    copies the current state between two biquadm setup objects.  The two
    objects must have been created with the same number of channels and
    sections.
 
    vDSP_biquadm_ResetState (for float) or vDSP_biquadm_ResetStateD (for
    double) sets the delay values of a biquadm setup object to zero.
*/
public static native void vDSP_biquadm_CopyState(
    vDSP_biquadm_SetupStruct __dest,
    @Const vDSP_biquadm_SetupStruct __src);
public static native void vDSP_biquadm_CopyStateD(
    vDSP_biquadm_SetupStructD __dest,
    @Const vDSP_biquadm_SetupStructD __src);
public static native void vDSP_biquadm_ResetState(vDSP_biquadm_SetupStruct __setup);
public static native void vDSP_biquadm_ResetStateD(vDSP_biquadm_SetupStructD __setup);

/*
    vDSP_biquadm_SetCoefficientsDouble will
    update the filter coefficients within a valid vDSP_biquadm_Setup object.
 */
    
public static native void vDSP_biquadm_SetCoefficientsDouble(
    vDSP_biquadm_SetupStruct __setup,
    @Const DoublePointer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetCoefficientsDouble(
    vDSP_biquadm_SetupStruct __setup,
    @Const DoubleBuffer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetCoefficientsDouble(
    vDSP_biquadm_SetupStruct __setup,
    @Const double[] __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);

/*
    vDSP_biquadm_SetCoefficientsDoubleD will
    update the filter coefficients within a valid vDSP_biquadm_SetupD object.
 */
public static native void vDSP_biquadm_SetCoefficientsDoubleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const DoublePointer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetCoefficientsDoubleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const DoubleBuffer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetCoefficientsDoubleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const double[] __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
    
/*
    vDSP_biquadm_SetTargetsDouble will
    set the target coefficients within a valid vDSP_biquadm_Setup object.
 */
    
public static native void vDSP_biquadm_SetTargetsDouble(
    vDSP_biquadm_SetupStruct __setup,
    @Const DoublePointer __targets,
    float __interp_rate,
    float __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetTargetsDouble(
    vDSP_biquadm_SetupStruct __setup,
    @Const DoubleBuffer __targets,
    float __interp_rate,
    float __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetTargetsDouble(
    vDSP_biquadm_SetupStruct __setup,
    @Const double[] __targets,
    float __interp_rate,
    float __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);

/*
    vDSP_biquadm_SetTargetsDoubleD will
    set the target coefficients within a valid vDSP_biquadm_SetupD object.
 */
public static native void vDSP_biquadm_SetTargetsDoubleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const DoublePointer __targets,
    double __interp_rate,
    double __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetTargetsDoubleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const DoubleBuffer __targets,
    double __interp_rate,
    double __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetTargetsDoubleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const double[] __targets,
    double __interp_rate,
    double __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
    
/*
    vDSP_biquadm_SetCoefficientsSingle will
    update the filter coefficients within a valid vDSP_biquadm_Setup object.
 
    Coefficients are specified in single precision.
 */
    
public static native void vDSP_biquadm_SetCoefficientsSingle(
    vDSP_biquadm_SetupStruct __setup,
    @Const FloatPointer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetCoefficientsSingle(
    vDSP_biquadm_SetupStruct __setup,
    @Const FloatBuffer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetCoefficientsSingle(
    vDSP_biquadm_SetupStruct __setup,
    @Const float[] __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);

/*
    vDSP_biquadm_SetCoefficientsSingleD will
    update the filter coefficients within a valid vDSP_biquadm_SetupD object.
 
    Coefficients are specified in single precision.
 */
public static native void vDSP_biquadm_SetCoefficientsSingleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const FloatPointer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetCoefficientsSingleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const FloatBuffer __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetCoefficientsSingleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const float[] __coeffs,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
    
/*
    vDSP_biquadm_SetTargetsSingle will
    set the target coefficients within a valid vDSP_biquadm_Setup object.
    The target values are specified in single precision.
 */
    
public static native void vDSP_biquadm_SetTargetsSingle(
    vDSP_biquadm_SetupStruct __setup,
    @Const FloatPointer __targets,
    float __interp_rate,
    float __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetTargetsSingle(
    vDSP_biquadm_SetupStruct __setup,
    @Const FloatBuffer __targets,
    float __interp_rate,
    float __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetTargetsSingle(
    vDSP_biquadm_SetupStruct __setup,
    @Const float[] __targets,
    float __interp_rate,
    float __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);

/*
    vDSP_biquadm_SetTargetsSingleD will
    set the target coefficients within a valid vDSP_biquadm_SetupD object.
    The target values are specified in single precision.
 */
public static native void vDSP_biquadm_SetTargetsSingleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const FloatPointer __targets,
    double __interp_rate,
    double __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetTargetsSingleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const FloatBuffer __targets,
    double __interp_rate,
    double __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);
public static native void vDSP_biquadm_SetTargetsSingleD(
    vDSP_biquadm_SetupStructD __setup,
    @Const float[] __targets,
    double __interp_rate,
    double __interp_threshold,
    @Cast("vDSP_Length") long __start_sec,
    @Cast("vDSP_Length") long __start_chn,
    @Cast("vDSP_Length") long __nsec,
    @Cast("vDSP_Length") long __nchn);

/*
    vDSP_biquadm_SetActiveFilters will set the overall active/inactive filter
    state of a valid vDSP_biquadm_Setup object.
 */
public static native void vDSP_biquadm_SetActiveFilters(
    vDSP_biquadm_SetupStruct __setup,
    @Cast("const bool*") BoolPointer __filter_states);
public static native void vDSP_biquadm_SetActiveFilters(
    vDSP_biquadm_SetupStruct __setup,
    @Cast("const bool*") boolean[] __filter_states);

/*
    vDSP_biquadm_SetActiveFiltersD will set the overall active/inactive filter
    state of a valid vDSP_biquadm_SetupD object.
 */
public static native void vDSP_biquadm_SetActiveFiltersD(
    vDSP_biquadm_SetupStructD __setup,
    @Cast("const bool*") BoolPointer __filter_states);
public static native void vDSP_biquadm_SetActiveFiltersD(
    vDSP_biquadm_SetupStructD __setup,
    @Cast("const bool*") boolean[] __filter_states);

// Convert a complex array to a complex-split array.
public static native void vDSP_ctoz(
    @Const DSPComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __Z,
    @Cast("vDSP_Stride") long __IZ,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_ctozD(
    @Const DSPDoubleComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __Z,
    @Cast("vDSP_Stride") long __IZ,
    @Cast("vDSP_Length") long __N);
    /*  Map:

            Pseudocode:     Memory:
            C[n]            C[n*IC/2].real + i * C[n*IC/2].imag
            Z[n]            Z->realp[n*IZ] + i * Z->imagp[n*IZ]

        These compute:

            for (n = 0; n < N; ++n)
                Z[n] = C[n];
    */


//  Convert a complex-split array to a complex array.
public static native void vDSP_ztoc(
    @Const DSPSplitComplex __Z,
    @Cast("vDSP_Stride") long __IZ,
    DSPComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_ztocD(
    @Const DSPDoubleSplitComplex __Z,
    @Cast("vDSP_Stride") long __IZ,
    DSPDoubleComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Map:

            Pseudocode:     Memory:
            Z[n]            Z->realp[n*IZ] + i * Z->imagp[n*IZ]
            C[n]            C[n*IC/2].real + i * C[n*IC/2].imag

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = Z[n];
    */



/*  In-place complex Discrete Fourier Transform routines, with and without
    temporary memory.  We suggest you use the DFT routines instead of these.
*/
public static native void vDSP_fft_zip(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zipD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zipt(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_ziptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N = 1 << Log2N;

        scale = 0 < Direction ? 1 : 1./N;

        // Define a complex vector, h:
        for (j = 0; j < N; ++j)
            h[j] = C->realp[j*IC] + i * C->imagp[j*IC];

        // Perform Discrete Fourier Transform.
        for (k = 0; k < N; ++k)
            H[k] = scale * sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

        // Store result.
        for (k = 0; k < N; ++k)
        {
            C->realp[k*IC] = Re(H[k]);
            C->imagp[k*IC] = Im(H[k]);
        }

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain the lesser of 16,384
        bytes or N * sizeof *C->realp bytes and is preferably 16-byte aligned
        or better.
    */


/*  Out-of-place complex Discrete Fourier Transform routines, with and without
    temporary memory.  We suggest you use the DFT routines instead of these.
*/
public static native void vDSP_fft_zop(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zopt(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zopD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zoptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N = 1 << Log2N;

        scale = 0 < Direction ? 1 : 1./N;

        // Define a complex vector, h:
        for (j = 0; j < N; ++j)
            h[j] = A->realp[j*IA] + i * A->imagp[j*IA];

        // Perform Discrete Fourier Transform.
        for (k = 0; k < N; ++k)
            H[k] = scale * sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

        // Store result.
        for (k = 0; k < N; ++k)
        {
            C->realp[k*IC] = Re(H[k]);
            C->imagp[k*IC] = Im(H[k]);
        }

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain the lesser of 16,384
        bytes or N * sizeof *C->realp bytes and is preferably 16-byte aligned
        or better.
    */


/*  In-place real-to-complex Discrete Fourier Transform routines, with and
    without temporary memory.  We suggest you use the DFT routines instead of
    these.
*/
public static native void vDSP_fft_zrip(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zripD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zript(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zriptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N = 1 << Log2N;

        If Direction is +1, a real-to-complex transform is performed, taking
        input from a real vector that has been coerced into the complex
        structure:

            scale = 2;

            // Define a real vector, h:
            for (j = 0; j < N/2; ++j)
            {
                h[2*j + 0] = C->realp[j*IC];
                h[2*j + 1] = C->imagp[j*IC];
            }

            // Perform Discrete Fourier Transform.
            for (k = 0; k < N; ++k)
                H[k] = scale *
                    sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

            // Pack DC and Nyquist components into C->realp[0] and C->imagp[0].
            C->realp[0*IC] = Re(H[ 0 ]).
            C->imagp[0*IC] = Re(H[N/2]).

            // Store regular components:
            for (k = 1; k < N/2; ++k)
            {
                C->realp[k*IC] = Re(H[k]);
                C->imagp[k*IC] = Im(H[k]);
            }

            Note that, for N/2 < k < N, H[k] is not stored.  However, since
            the input is a real vector, the output has symmetry that allows the
            unstored elements to be derived from the stored elements:  H[k] =
            conj(H(N-k)).  This symmetry also implies the DC and Nyquist
            components are real, so their imaginary parts are zero.

        If Direction is -1, a complex-to-real inverse transform is performed,
        producing a real output vector coerced into the complex structure:

            scale = 1./N;

            // Define a complex vector, h:
            h[ 0 ] = C->realp[0*IC];
            h[N/2] = C->imagp[0*IC];
            for (j = 1; j < N/2; ++j)
            {
                h[ j ] = C->realp[j*IC] + i * C->imagp[j*IC];
                h[N-j] = conj(h[j]);
            }

            // Perform Discrete Fourier Transform.
            for (k = 0; k < N; ++k)
                H[k] = scale *
                    sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

            // Coerce real results into complex structure:
            for (k = 0; k < N/2; ++k)
            {
                C->realp[k*IC] = H[2*k+0];
                C->imagp[k*IC] = H[2*k+1];
            }

            Note that, mathematically, the symmetry in the input vector compels
            every H[k] to be real, so there are no imaginary components to be
            stored.

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain N/2 * sizeof *C->realp
        bytes and is preferably 16-byte aligned or better.
    */


/*  Out-of-place real-to-complex Discrete Fourier Transform routines, with and
    without temporary memory.  We suggest you use the DFT routines instead of
    these.
*/
public static native void vDSP_fft_zrop(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zropD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zropt(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft_zroptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N = 1 << Log2N;

        If Direction is +1, a real-to-complex transform is performed, taking
        input from a real vector that has been coerced into the complex
        structure:

            scale = 2;

            // Define a real vector, h:
            for (j = 0; j < N/2; ++j)
            {
                h[2*j + 0] = A->realp[j*IA];
                h[2*j + 1] = A->imagp[j*IA];
            }

            // Perform Discrete Fourier Transform.
            for (k = 0; k < N; ++k)
                H[k] = scale *
                    sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

            // Pack DC and Nyquist components into C->realp[0] and C->imagp[0].
            C->realp[0*IC] = Re(H[ 0 ]).
            C->imagp[0*IC] = Re(H[N/2]).

            // Store regular components:
            for (k = 1; k < N/2; ++k)
            {
                C->realp[k*IC] = Re(H[k]);
                C->imagp[k*IC] = Im(H[k]);
            }

            Note that, for N/2 < k < N, H[k] is not stored.  However, since
            the input is a real vector, the output has symmetry that allows the
            unstored elements to be derived from the stored elements:  H[k] =
            conj(H(N-k)).  This symmetry also implies the DC and Nyquist
            components are real, so their imaginary parts are zero.

        If Direction is -1, a complex-to-real inverse transform is performed,
        producing a real output vector coerced into the complex structure:

            scale = 1./N;

            // Define a complex vector, h:
            h[ 0 ] = A->realp[0*IA];
            h[N/2] = A->imagp[0*IA];
            for (j = 1; j < N/2; ++j)
            {
                h[ j ] = A->realp[j*IA] + i * A->imagp[j*IA];
                h[N-j] = conj(h[j]);
            }

            // Perform Discrete Fourier Transform.
            for (k = 0; k < N; ++k)
                H[k] = scale *
                    sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

            // Coerce real results into complex structure:
            for (k = 0; k < N/2; ++k)
            {
                C->realp[k*IC] = H[2*k+0];
                C->imagp[k*IC] = H[2*k+1];
            }

            Note that, mathematically, the symmetry in the input vector compels
            every H[k] to be real, so there are no imaginary components to be
            stored.

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain N/2 * sizeof *C->realp
        bytes and is preferably 16-byte aligned or better.
    */


/*  In-place two-dimensional complex Discrete Fourier Transform routines, with
    and without temporary memory.
*/
public static native void vDSP_fft2d_zip(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zipD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zipt(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC1,
    @Cast("vDSP_Stride") long __IC0,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_ziptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N0 = 1 << Log2N0;
        N1 = 1 << Log2N1;

        if (IC1 == 0) IC1 = IC0*N0;

        scale = 0 < Direction ? 1 : 1. / (N1*N0);

        // Define a complex matrix, h:
        for (j1 = 0; j1 < N1; ++j1)
        for (j0 = 0; j0 < N0; ++j0)
            h[j1][j0] = C->realp[j1*IC1 + j0*IC0]
                  + i * C->imagp[j1*IC1 + j0*IC0];

        // Perform Discrete Fourier Transform.
        for (k1 = 0; k1 < N1; ++k1)
        for (k0 = 0; k0 < N0; ++k0)
            H[k1][k0] = scale * sum(sum(h[j1][j0]
                * e**(-Direction*2*pi*i*j0*k0/N0), 0 <= j0 < N0)
                * e**(-Direction*2*pi*i*j1*k1/N1), 0 <= j1 < N1);

        // Store result.
        for (k1 = 0; k1 < N1; ++k1)
        for (k0 = 0; k0 < N0; ++k0)
        {
            C->realp[k1*IC1 + k0*IC0] = Re(H[k1][k0]);
            C->imagp[k1*IC1 + k0*IC0] = Im(H[k1][k0]);
        }

        Note that the 0 and 1 dimensions are separate and identical, except
        that IC1 is set to a default, IC0*N0, if it is zero.  If IC1 is not
        zero, then the IC0 and N0 arguments may be swapped with the IC1 and N1
        arguments without affecting the results.

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain the lesser of 16,384
        bytes or N1*N0 * sizeof *C->realp bytes and is preferably 16-byte
        aligned or better.
    */


/*  Out-of-place two-dimensional complex Discrete Fourier Transform routines,
    with and without temporary memory.
*/
public static native void vDSP_fft2d_zop(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA0,
    @Cast("vDSP_Stride") long __IA1,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zopD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA0,
    @Cast("vDSP_Stride") long __IA1,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zopt(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA0,
    @Cast("vDSP_Stride") long __IA1,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zoptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA0,
    @Cast("vDSP_Stride") long __IA1,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N0 = 1 << Log2N0;
        N1 = 1 << Log2N1;

        if (IA1 == 0) IA1 = IA0*N0;
        if (IC1 == 0) IC1 = IC0*N0;

        scale = 0 < Direction ? 1 : 1. / (N1*N0);

        // Define a complex matrix, h:
        for (j1 = 0; j1 < N1; ++j1)
        for (j0 = 0; j0 < N0; ++j0)
            h[j1][j0] = A->realp[j1*IA1 + j0*IA0]
                  + i * A->imagp[j1*IA1 + j0*IA0];

        // Perform Discrete Fourier Transform.
        for (k1 = 0; k1 < N1; ++k1)
        for (k0 = 0; k0 < N0; ++k0)
            H[k1][k0] = scale * sum(sum(h[j1][j0]
                * e**(-Direction*2*pi*i*j0*k0/N0), 0 <= j0 < N0)
                * e**(-Direction*2*pi*i*j1*k1/N1), 0 <= j1 < N1);

        // Store result.
        for (k1 = 0; k1 < N1; ++k1)
        for (k0 = 0; k0 < N0; ++k0)
        {
            C->realp[k1*IC1 + k0*IC0] = Re(H[k1][k0]);
            C->imagp[k1*IC1 + k0*IC0] = Im(H[k1][k0]);
        }

        Note that the 0 and 1 dimensions are separate and identical, except
        that IA1 or IC1 are set to defaults, IA0*N0 or IC0*N0, if either is
        zero.  If neither is zero, then the IA0, IC0, and N0 arguments may be
        swapped with the IA1, IC1 and N1 arguments without affecting the
        results.

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain the lesser of 16,384
        bytes or N1*N0 * sizeof *C->realp bytes and is preferably 16-byte
        aligned or better.
    */


/*  In-place two-dimensional real-to-complex Discrete Fourier Transform
    routines, with and without temporary memory.
*/
public static native void vDSP_fft2d_zrip(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zripD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __flag);
public static native void vDSP_fft2d_zript(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zriptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __flag);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N0 = 1 << Log2N0;
        N1 = 1 << Log2N1;

        if (IC1 == 0) IC1 = IC0*N0/2;

        If Direction is +1, a real-to-complex transform is performed, taking
        input from a real vector that has been coerced into the complex
        structure:

            scale = 2;

            // Define a real matrix, h:
            for (j1 = 0; j1 < N1  ; ++j1)
            for (j0 = 0; j0 < N0/2; ++j0)
            {
                h[j1][2*j0+0] = C->realp[j1*IC1 + j0*IC0]
                          + i * C->imagp[j1*IC1 + j0*IC0];
                h[j1][2*j0+1] = C->realp[j1*IC1 + j0*IC0]
                          + i * C->imagp[j1*IC1 + j0*IC0];
            }

            // Perform Discrete Fourier Transform.
            for (k1 = 0; k1 < N1; ++k1)
            for (k0 = 0; k0 < N0; ++k0)
                H[k1][k0] = scale * sum(sum(h[j1][j0]
                    * e**(-Direction*2*pi*i*j0*k0/N0), 0 <= j0 < N0)
                    * e**(-Direction*2*pi*i*j1*k1/N1), 0 <= j1 < N1);

            // Pack special pure-real elements into output matrix:
            C->realp[0*IC1][0*IC0] = H[0   ][0   ].
            C->imagp[0*IC1][0*IC0] = H[0   ][N0/2]
            C->realp[1*IC1][0*IC0] = H[N1/2][0   ].
            C->imagp[1*IC1][0*IC0] = H[N1/2][N0/2]

            // Pack two vectors into output matrix "vertically":
            // (This awkward format is due to a legacy implementation.)
            for (k1 = 1; k1 < N1/2; ++k1)
            {
                C->realp[(2*k1+0)*IC1][0*IC0] = Re(H[k1][0   ]);
                C->realp[(2*k1+1)*IC1][0*IC0] = Im(H[k1][0   ]);
                C->imagp[(2*k1+0)*IC1][0*IC0] = Re(H[k1][N0/2]);
                C->imagp[(2*k1+1)*IC1][0*IC0] = Im(H[k1][N0/2]);
            }

            // Store regular elements:
            for (k1 = 0; k1 < N1  ; ++k1)
            for (k0 = 1; k0 < N0/2; ++k0)
            {
                C->realp[k1*IC1 + k0*IC0] = Re(H[k1][k0]);
                C->imagp[k1*IC1 + k0*IC0] = Im(H[k1][k0]);
            }

            Many elements of H are not stored.  However, since the input is a
            real matrix, H has symmetry that makes all the unstored elements of
            H functions of the stored elements of H.  So the data stored in C
            has complete information about the transform result.

        If Direction is -1, a complex-to-real inverse transform is performed,
        producing a real output vector coerced into the complex structure:

            scale = 1. / (N1*N0);

            // Define a complex matrix, h, in multiple steps:

            // Unpack the special elements:
            h[0   ][0   ] = C->realp[0*IC1][0*IC0];
            h[0   ][N0/2] = C->imagp[0*IC1][0*IC0];
            h[N1/2][0   ] = C->realp[1*IC1][0*IC0];
            h[N1/2][N0/2] = C->imagp[1*IC1][0*IC0];

            // Unpack the two vectors from "vertical" storage:
            for (j1 = 1; j1 < N1/2; ++j1)
            {
                h[j1][0   ] = C->realp[(2*j1+0)*IC1][0*IC0]
                        + i * C->realp[(2*j1+1)*IC1][0*IC0]
                h[j1][N0/2] = C->imagp[(2*j1+0)*IC1][0*IC0]
                        + i * C->imagp[(2*j1+1)*IC1][0*IC0]
            }

            // Take regular elements:
            for (j1 = 0; j1 < N1  ; ++j1)
            for (j0 = 1; j0 < N0/2; ++j0)
            {
                h[j1][j0   ] = C->realp[j1*IC1 + j0*IC0]
                         + i * C->imagp[j1*IC1 + j0*IC0];
                h[j1][N0-j0] = conj(h[j1][j0]);
            }

            // Perform Discrete Fourier Transform.
            for (k1 = 0; k1 < N1; ++k1)
            for (k0 = 0; k0 < N0; ++k0)
                H[k1][k0] = scale * sum(sum(h[j1][j0]
                    * e**(-Direction*2*pi*i*j0*k0/N0), 0 <= j0 < N0)
                    * e**(-Direction*2*pi*i*j1*k1/N1), 0 <= j1 < N1);

            // Store result.
            for (k1 = 0; k1 < N1  ; ++k1)
            for (k0 = 0; k0 < N0/2; ++k0)
            {
                C->realp[k1*IC1 + k0*IC0] = Re(H[k1][2*k0+0]);
                C->imagp[k1*IC1 + k0*IC0] = Im(H[k1][2*k0+1]);
            }

        Unlike the two-dimensional complex transform, the dimensions are not
        symmetric in this real-to-complex transform.

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain space for the greater
        of N1 or N0/2 floating-point elements.  The addresses are preferably
        16-byte aligned or better.
    */


/*  Out-of-place two-dimensional real-to-complex Discrete Fourier Transform
    routines, with and without temporary memory.
*/
public static native void vDSP_fft2d_zrop(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA0,
    @Cast("vDSP_Stride") long __IA1,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zropt(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA0,
    @Cast("vDSP_Stride") long __IA1,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zropD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA0,
    @Cast("vDSP_Stride") long __IA1,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fft2d_zroptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA0,
    @Cast("vDSP_Stride") long __IA1,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC0,
    @Cast("vDSP_Stride") long __IC1,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N0,
    @Cast("vDSP_Length") long __Log2N1,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N0 = 1 << Log2N0;
        N1 = 1 << Log2N1;

        if (IA1 == 0) IA1 = IA0*N0/2;
        if (IC1 == 0) IC1 = IC0*N0/2;

        If Direction is +1, a real-to-complex transform is performed, taking
        input from a real vector that has been coerced into the complex
        structure:

            scale = 2;

            // Define a real matrix, h:
            for (j1 = 0; j1 < N1  ; ++j1)
            for (j0 = 0; j0 < N0/2; ++j0)
            {
                h[j1][2*j0+0] = A->realp[j1*IA1 + j0*IA0]
                          + i * A->imagp[j1*IA1 + j0*IA0];
                h[j1][2*j0+1] = A->realp[j1*IA1 + j0*IA0]
                          + i * A->imagp[j1*IA1 + j0*IA0];
            }

            // Perform Discrete Fourier Transform.
            for (k1 = 0; k1 < N1; ++k1)
            for (k0 = 0; k0 < N0; ++k0)
                H[k1][k0] = scale * sum(sum(h[j1][j0]
                    * e**(-Direction*2*pi*i*j0*k0/N0), 0 <= j0 < N0)
                    * e**(-Direction*2*pi*i*j1*k1/N1), 0 <= j1 < N1);

            // Pack special pure-real elements into output matrix:
            C->realp[0*IC1][0*IC0] = H[0   ][0   ].
            C->imagp[0*IC1][0*IC0] = H[0   ][N0/2]
            C->realp[1*IC1][0*IC0] = H[N1/2][0   ].
            C->imagp[1*IC1][0*IC0] = H[N1/2][N0/2]

            // Pack two vectors into output matrix "vertically":
            // (This awkward format is due to a legacy implementation.)
            for (k1 = 1; k1 < N1/2; ++k1)
            {
                C->realp[(2*k1+0)*IC1][0*IC0] = Re(H[k1][0   ]);
                C->realp[(2*k1+1)*IC1][0*IC0] = Im(H[k1][0   ]);
                C->imagp[(2*k1+0)*IC1][0*IC0] = Re(H[k1][N0/2]);
                C->imagp[(2*k1+1)*IC1][0*IC0] = Im(H[k1][N0/2]);
            }

            // Store regular elements:
            for (k1 = 0; k1 < N1  ; ++k1)
            for (k0 = 1; k0 < N0/2; ++k0)
            {
                C->realp[k1*IC1 + k0*IC0] = Re(H[k1][k0]);
                C->imagp[k1*IC1 + k0*IC0] = Im(H[k1][k0]);
            }

            Many elements of H are not stored.  However, since the input is a
            real matrix, H has symmetry that makes all the unstored elements of
            H functions of the stored elements of H.  So the data stored in C
            has complete information about the transform result.

        If Direction is -1, a complex-to-real inverse transform is performed,
        producing a real output vector coerced into the complex structure:

            scale = 1. / (N1*N0);

            // Define a complex matrix, h, in multiple steps:

            // Unpack the special elements:
            h[0   ][0   ] = A->realp[0*IA1][0*IA0];
            h[0   ][N0/2] = A->imagp[0*IA1][0*IA0];
            h[N1/2][0   ] = A->realp[1*IA1][0*IA0];
            h[N1/2][N0/2] = A->imagp[1*IA1][0*IA0];

            // Unpack the two vectors from "vertical" storage:
            for (j1 = 1; j1 < N1/2; ++j1)
            {
                h[j1][0   ] = A->realp[(2*j1+0)*IA1][0*IA0]
                        + i * A->realp[(2*j1+1)*IA1][0*IA0]
                h[j1][N0/2] = A->imagp[(2*j1+0)*IA1][0*IA0]
                        + i * A->imagp[(2*j1+1)*IA1][0*IA0]
            }

            // Take regular elements:
            for (j1 = 0; j1 < N1  ; ++j1)
            for (j0 = 1; j0 < N0/2; ++j0)
            {
                h[j1][j0   ] = A->realp[j1*IA1 + j0*IA0]
                         + i * A->imagp[j1*IA1 + j0*IA0];
                h[j1][N0-j0] = conj(h[j1][j0]);
            }

            // Perform Discrete Fourier Transform.
            for (k1 = 0; k1 < N1; ++k1)
            for (k0 = 0; k0 < N0; ++k0)
                H[k1][k0] = scale * sum(sum(h[j1][j0]
                    * e**(-Direction*2*pi*i*j0*k0/N0), 0 <= j0 < N0)
                    * e**(-Direction*2*pi*i*j1*k1/N1), 0 <= j1 < N1);

            // Store result.
            for (k1 = 0; k1 < N1  ; ++k1)
            for (k0 = 0; k0 < N0/2; ++k0)
            {
                C->realp[k1*IC1 + k0*IC0] = Re(H[k1][2*k0+0]);
                C->imagp[k1*IC1 + k0*IC0] = Im(H[k1][2*k0+1]);
            }

        Unlike the two-dimensional complex transform, the dimensions are not
        symmetric in this real-to-complex transform.

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain space for the greater
        of N1 or N0/2 floating-point elements.  The addresses are preferably
        16-byte aligned or better.
    */


/*  In-place multiple complex Discrete Fourier Transform routines, with and
    without temporary memory.
*/
public static native void vDSP_fftm_zip(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IM,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zipD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IM,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zipt(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IM,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_ziptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IM,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N = 1 << Log2N;

        scale = 0 < Direction ? 1 : 1./N;

        // Repeat M times:
        for (m = 0; m < M; ++m)
        {

            // Define a complex vector, h:
            for (j = 0; j < N; ++j)
                h[j] = C->realp[m*IM + j*IC] + i * C->imagp[m*IM + j*IC];

            // Perform Discrete Fourier Transform.
            for (k = 0; k < N; ++k)
                H[k] = scale * sum(h[j]
                    * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

            // Store result.
            for (k = 0; k < N; ++k)
            {
                C->realp[m*IM + k*IC] = Re(H[k]);
                C->imagp[m*IM + k*IC] = Im(H[k]);
            }

        }

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain space for N
        floating-point elements and is preferably 16-byte aligned or better.
    */


/*  Out-of-place multiple complex Discrete Fourier Transform routines, with and
    without temporary memory.
*/
public static native void vDSP_fftm_zop(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Stride") long __IMA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IMC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zopD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Stride") long __IMA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IMC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zopt(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Stride") long __IMA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IMC,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zoptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Stride") long __IMA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IMC,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N = 1 << Log2N;

        scale = 0 < Direction ? 1 : 1./N;

        // Repeat M times:
        for (m = 0; m < M; ++m)
        {

            // Define a complex vector, h:
            for (j = 0; j < N; ++j)
                h[j] = A->realp[m*IMA + j*IA] + i * A->imagp[m*IMA + j*IA];

            // Perform Discrete Fourier Transform.
            for (k = 0; k < N; ++k)
                H[k] = scale * sum(h[j]
                    * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

            // Store result.
            for (k = 0; k < N; ++k)
            {
                C->realp[m*IM + k*IC] = Re(H[k]);
                C->imagp[m*IM + k*IC] = Im(H[k]);
            }

        }

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain space for N
        floating-point elements and is preferably 16-byte aligned or better.
    */


/*  In-place multiple real-to-complex Discrete Fourier Transform routines, with
    and without temporary memory.  We suggest you use the DFT routines instead
    of these.
*/
public static native void vDSP_fftm_zrip(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IM,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zripD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IM,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zript(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IM,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zriptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IM,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N = 1 << Log2N;

        // Repeat M times:
        for (m = 0; m < M; ++m)
        {

            If Direction is +1, a real-to-complex transform is performed,
            taking input from a real vector that has been coerced into the
            complex structure:

                scale = 2;

                // Define a real vector, h:
                for (j = 0; j < N/2; ++j)
                {
                    h[2*j + 0] = C->realp[m*IM + j*IC];
                    h[2*j + 1] = C->imagp[m*IM + j*IC];
                }

                // Perform Discrete Fourier Transform.
                for (k = 0; k < N; ++k)
                    H[k] = scale *
                        sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

                // Pack DC and Nyquist components into initial elements.
                C->realp[m*IM + 0*IC] = Re(H[ 0 ]).
                C->imagp[m*IM + 0*IC] = Re(H[N/2]).

                // Store regular components:
                for (k = 1; k < N/2; ++k)
                {
                    C->realp[m*IM + k*IC] = Re(H[k]);
                    C->imagp[m*IM + k*IC] = Im(H[k]);
                }

                Note that, for N/2 < k < N, H[k] is not stored.  However, since
                the input is a real vector, the output has symmetry that allows
                the unstored elements to be derived from the stored elements:
                H[k] = conj(H(N-k)).  This symmetry also implies the DC and
                Nyquist components are real, so their imaginary parts are zero.

            If Direction is -1, a complex-to-real inverse transform is
            performed, producing a real output vector coerced into the complex
            structure:

                scale = 1./N;

                // Define a complex vector, h:
                h[ 0 ] = C->realp[m*IM + 0*IC];
                h[N/2] = C->imagp[m*IM + 0*IC];
                for (j = 1; j < N/2; ++j)
                {
                    h[ j ] = C->realp[m*IM + j*IC] + i * C->imagp[m*IM + j*IC];
                    h[N-j] = conj(h[j]);
                }

                // Perform Discrete Fourier Transform.
                for (k = 0; k < N; ++k)
                    H[k] = scale *
                        sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

                // Coerce real results into complex structure:
                for (k = 0; k < N/2; ++k)
                {
                    C->realp[m*IM + k*IC] = H[2*k+0];
                    C->imagp[m*IM + k*IC] = H[2*k+1];
                }

                Note that, mathematically, the symmetry in the input vector
                compels every H[k] to be real, so there are no imaginary
                components to be stored.

        }

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain space for N/2
        floating-point elements and is preferably 16-byte aligned or better.
    */



/*  Out-of-place multiple real-to-complex Discrete Fourier Transform routines,
    with and without temporary memory.  We suggest you use the DFT routines
    instead of these.
*/
public static native void vDSP_fftm_zrop(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Stride") long __IMA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IMC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zropt(
    OpaqueFFTSetup __Setup,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Stride") long __IMA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IMC,
    @Const DSPSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zropD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Stride") long __IMA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IMC,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_fftm_zroptD(
    OpaqueFFTSetupD __Setup,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Stride") long __IMA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Stride") long __IMC,
    @Const DSPDoubleSplitComplex __Buffer,
    @Cast("vDSP_Length") long __Log2N,
    @Cast("vDSP_Length") long __M,
    @Cast("FFTDirection") int __Direction);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        N = 1 << Log2N;

        // Repeat M times:
        for (m = 0; m < M; ++m)
        {

            If Direction is +1, a real-to-complex transform is performed,
            taking input from a real vector that has been coerced into the
            complex structure:

                scale = 2;

                // Define a real vector, h:
                for (j = 0; j < N/2; ++j)
                {
                    h[2*j + 0] = A->realp[m*IMA + j*IA];
                    h[2*j + 1] = A->imagp[m*IMA + j*IA];
                }

                // Perform Discrete Fourier Transform.
                for (k = 0; k < N; ++k)
                    H[k] = scale *
                        sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

                // Pack DC and Nyquist components into initial elements.
                C->realp[m*IMC + 0*IC] = Re(H[ 0 ]).
                C->imagp[m*IMC + 0*IC] = Re(H[N/2]).

                // Store regular components:
                for (k = 1; k < N/2; ++k)
                {
                    C->realp[m*IMC + k*IC] = Re(H[k]);
                    C->imagp[m*IMC + k*IC] = Im(H[k]);
                }

                Note that, for N/2 < k < N, H[k] is not stored.  However, since
                the input is a real vector, the output has symmetry that allows
                the unstored elements to be derived from the stored elements:
                H[k] = conj(H(N-k)).  This symmetry also implies the DC and
                Nyquist components are real, so their imaginary parts are zero.

            If Direction is -1, a complex-to-real inverse transform is
            performed, producing a real output vector coerced into the complex
            structure:

                scale = 1./N;

                // Define a complex vector, h:
                h[ 0 ] = A->realp[m*IMA + 0*IA];
                h[N/2] = A->imagp[m*IMA + 0*IA];
                for (j = 1; j < N/2; ++j)
                {
                    h[ j ] = A->realp[m*IMA + j*IA]
                       + i * A->imagp[m*IMA + j*IA];
                    h[N-j] = conj(h[j]);
                }

                // Perform Discrete Fourier Transform.
                for (k = 0; k < N; ++k)
                    H[k] = scale *
                        sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

                // Coerce real results into complex structure:
                for (k = 0; k < N/2; ++k)
                {
                    C->realp[m*IMC + k*IC] = H[2*k+0];
                    C->imagp[m*IMC + k*IC] = H[2*k+1];
                }

                Note that, mathematically, the symmetry in the input vector
                compels every H[k] to be real, so there are no imaginary
                components to be stored.

        }

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.

        The temporary buffer versions perform the same operation but are
        permitted to use the temporary buffer for improved performance.  Each
        of Buffer->realp and Buffer->imagp must contain space for N/2
        floating-point elements and is preferably 16-byte aligned or better.
    */


/*  Non-power-of-two out-of-place complex Discrete Fourier Transform routines.
    We suggest you use the DFT routines instead of these.
*/





    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        p = 3 or 5, as shown in the routine name.

        N = p << Log2N;

        scale = 0 < Direction ? 1 : 1./N;

        // Define a complex vector, h:
        for (j = 0; j < N; ++j)
            h[j] = A->realp[j*IA] + i * A->imagp[j*IA];

        // Perform Discrete Fourier Transform.
        for (k = 0; k < N; ++k)
            H[k] = scale * sum(h[j] * e**(-Direction*2*pi*i*j*k/N), 0 <= j < N);

        // Store result.
        for (k = 0; k < N; ++k)
        {
            C->realp[k*IC] = Re(H[k]);
            C->imagp[k*IC] = Im(H[k]);
        }

        Setup must have been properly created by a call to vDSP_create_fftsetup
        (for single precision) or vDSP_create_fftsetupD (for double precision)
        and not subsequently destroyed.

        Direction must be +1 or -1.
    */


/*  Cascade biquadratic IIR filters.
*/
public static native void vDSP_biquad(
    @Const vDSP_biquad_SetupStruct __Setup,
    FloatPointer __Delay,
    @Const FloatPointer __X, @Cast("vDSP_Stride") long __IX,
    FloatPointer __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquad(
    @Const vDSP_biquad_SetupStruct __Setup,
    FloatBuffer __Delay,
    @Const FloatBuffer __X, @Cast("vDSP_Stride") long __IX,
    FloatBuffer __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquad(
    @Const vDSP_biquad_SetupStruct __Setup,
    float[] __Delay,
    @Const float[] __X, @Cast("vDSP_Stride") long __IX,
    float[] __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadD(
    @Const vDSP_biquad_SetupStructD __Setup,
    DoublePointer __Delay,
    @Const DoublePointer __X, @Cast("vDSP_Stride") long __IX,
    DoublePointer __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadD(
    @Const vDSP_biquad_SetupStructD __Setup,
    DoubleBuffer __Delay,
    @Const DoubleBuffer __X, @Cast("vDSP_Stride") long __IX,
    DoubleBuffer __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadD(
    @Const vDSP_biquad_SetupStructD __Setup,
    double[] __Delay,
    @Const double[] __X, @Cast("vDSP_Stride") long __IX,
    double[] __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
    /*  Maps:

            For this routine, strides are shown explicitly; the default maps
            are not used.

        These compute:

        S, B0, B1, B2, A1, and A2 are determined by Setup.
        S is the number of sections.

        X provides the bulk of the input signal.  Delay provides prior state
        data for S biquadratic filters.  The filters are applied to the data in
        turn.  The output of the final filter is stored in Y, and the final
        state data of the filters are stored in Delay.

        // Initialize the first row of a matrix x with data from X:
        for (n = 0; n < N; ++n)
            x[0][n ] = X[n*IX];

        // Initialize the "past" information, elements -2 and -1, from Delay:
        for (s = 0; s <= S; ++s)
        {
            x[s][-2] = Delay[2*s+0];
            x[s][-1] = Delay[2*s+1];
        }

        // Apply each filter:
        for (s = 1; s <= S; ++s)
            for (n = 0; n < N; ++n)
                x[s][n] =
                    + B0[s] * x[s-1][n-0]
                    + B1[s] * x[s-1][n-1]
                    + B2[s] * x[s-1][n-2]
                    - A1[s] * x[s  ][n-1]
                    - A2[s] * x[s  ][n-2];

        // Save the updated state data from the end of each row:
        for (s = 0; s <= S; ++s)
        {
            Delay[2*s+0] = x[s][N-2];
            Delay[2*s+1] = x[s][N-1];
        }

        // Store the results of the final filter:
        for (n = 0; n < N; ++n)
            Y[n*IY] = x[S][n];
    */


/*  vDSP_biquadm (for float) or vDSP_biquadmD (for double) applies a
    multi-channel biquadm IIR filter created with vDSP_biquadm_CreateSetup or
    vDSP_biquadm_CreateSetupD, respectively.
 */
public static native void vDSP_biquadm(
    vDSP_biquadm_SetupStruct __Setup,
    @Cast("const float**") PointerPointer __X, @Cast("vDSP_Stride") long __IX,
    @Cast("float**") PointerPointer __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadm(
    vDSP_biquadm_SetupStruct __Setup,
    @Const @ByPtrPtr FloatPointer __X, @Cast("vDSP_Stride") long __IX,
    @ByPtrPtr FloatPointer __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadm(
    vDSP_biquadm_SetupStruct __Setup,
    @Const @ByPtrPtr FloatBuffer __X, @Cast("vDSP_Stride") long __IX,
    @ByPtrPtr FloatBuffer __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadm(
    vDSP_biquadm_SetupStruct __Setup,
    @Const @ByPtrPtr float[] __X, @Cast("vDSP_Stride") long __IX,
    @ByPtrPtr float[] __Y, @Cast("vDSP_Stride") long __IY,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadmD(
     vDSP_biquadm_SetupStructD __Setup,
     @Cast("const double**") PointerPointer __X, @Cast("vDSP_Stride") long __IX,
     @Cast("double**") PointerPointer __Y, @Cast("vDSP_Stride") long __IY,
     @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadmD(
     vDSP_biquadm_SetupStructD __Setup,
     @Const @ByPtrPtr DoublePointer __X, @Cast("vDSP_Stride") long __IX,
     @ByPtrPtr DoublePointer __Y, @Cast("vDSP_Stride") long __IY,
     @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadmD(
     vDSP_biquadm_SetupStructD __Setup,
     @Const @ByPtrPtr DoubleBuffer __X, @Cast("vDSP_Stride") long __IX,
     @ByPtrPtr DoubleBuffer __Y, @Cast("vDSP_Stride") long __IY,
     @Cast("vDSP_Length") long __N);
public static native void vDSP_biquadmD(
     vDSP_biquadm_SetupStructD __Setup,
     @Const @ByPtrPtr double[] __X, @Cast("vDSP_Stride") long __IX,
     @ByPtrPtr double[] __Y, @Cast("vDSP_Stride") long __IY,
     @Cast("vDSP_Length") long __N);
    /*  These routines perform the same function as M calls to vDSP_biquad or
        vDSP_biquadD, where M, the delay values, and the biquad setups are
        derived from the biquadm setup:

            for (m = 0; m < M; ++M)
                vDSP_biquad(
                    setup derived from vDSP_biquadm setup,
                    delays derived from vDSP_biquadm setup,
                    X[m], IX,
                    Y[m], IY,
                    N);
    */


/*  Convolution and correlation.
*/
public static native void vDSP_conv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __F,
    @Cast("vDSP_Stride") long __IF,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_conv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __F,
    @Cast("vDSP_Stride") long __IF,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_conv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __F,
    @Cast("vDSP_Stride") long __IF,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_convD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __F,
    @Cast("vDSP_Stride") long __IF,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_convD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __F,
    @Cast("vDSP_Stride") long __IF,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_convD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __F,
    @Cast("vDSP_Stride") long __IF,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zconv(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __F,
    @Cast("vDSP_Stride") long __IF,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zconvD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __F,
    @Cast("vDSP_Stride") long __IF,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = sum(A[n+p] * F[p], 0 <= p < P);

        Commonly, this is called correlation if IF is positive and convolution
        if IF is negative.
    */


/*  3*3 and 5*5 convolutions.
*/
public static native void vDSP_f3x3(
    @Const FloatPointer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const FloatPointer __F,
    FloatPointer __C);
public static native void vDSP_f3x3(
    @Const FloatBuffer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const FloatBuffer __F,
    FloatBuffer __C);
public static native void vDSP_f3x3(
    @Const float[] __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const float[] __F,
    float[] __C);
public static native void vDSP_f3x3D(
    @Const DoublePointer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const DoublePointer __F,
    DoublePointer __C);
public static native void vDSP_f3x3D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const DoubleBuffer __F,
    DoubleBuffer __C);
public static native void vDSP_f3x3D(
    @Const double[] __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const double[] __F,
    double[] __C);
public static native void vDSP_f5x5(
    @Const FloatPointer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const FloatPointer __F,
    FloatPointer __C);
public static native void vDSP_f5x5(
    @Const FloatBuffer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const FloatBuffer __F,
    FloatBuffer __C);
public static native void vDSP_f5x5(
    @Const float[] __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const float[] __F,
    float[] __C);
public static native void vDSP_f5x5D(
    @Const DoublePointer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const DoublePointer __F,
    DoublePointer __C);
public static native void vDSP_f5x5D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const DoubleBuffer __F,
    DoubleBuffer __C);
public static native void vDSP_f5x5D(
    @Const double[] __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const double[] __F,
    double[] __C);
    /*  Maps:

            This routine does not have strides.

            A and C are regarded as two-dimensional matrices with dimensions
            [NR][NC].  F is regarded as a two-dimensional matrix with
            dimensions [P][P]:

            Pseudocode:     Memory:
            A[j][k]         A[j*NC + k]
            C[j][k]         C[j*NC + k]
            F[j][k]         F[j*P  + k]

        These compute:

            P = 3 or 5, according to the routine name.

            Below, "P/2" is evaluated using integer arithmetic, so it is 1 or 2
            (not 1.5 or 2.5).

            for (r = P/2; r < NR-P/2; ++r)
            for (c = P/2; c < NC-P/2; ++c)
                C[r][c] = sum(A[r+j][c+k] * F[j+P/2][k+P/2],
                    -P/2 <= j <= P/2, -P/2 <= k <= P/2);

            All other elements of C (a border of P/2 elements around all four
            sides) are set to zero.
    */


/*  Two-dimensional (image) convolution.
*/
public static native void vDSP_imgfir(
    @Const FloatPointer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const FloatPointer __F,
    FloatPointer __C,
    @Cast("vDSP_Length") long __P,
    @Cast("vDSP_Length") long __Q);
public static native void vDSP_imgfir(
    @Const FloatBuffer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const FloatBuffer __F,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __P,
    @Cast("vDSP_Length") long __Q);
public static native void vDSP_imgfir(
    @Const float[] __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const float[] __F,
    float[] __C,
    @Cast("vDSP_Length") long __P,
    @Cast("vDSP_Length") long __Q);
public static native void vDSP_imgfirD(
    @Const DoublePointer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const DoublePointer __F,
    DoublePointer __C,
    @Cast("vDSP_Length") long __P,
    @Cast("vDSP_Length") long __Q);
public static native void vDSP_imgfirD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const DoubleBuffer __F,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __P,
    @Cast("vDSP_Length") long __Q);
public static native void vDSP_imgfirD(
    @Const double[] __A,
    @Cast("vDSP_Length") long __NR,
    @Cast("vDSP_Length") long __NC,
    @Const double[] __F,
    double[] __C,
    @Cast("vDSP_Length") long __P,
    @Cast("vDSP_Length") long __Q);
    /*  Maps:

            This routine does not have strides.

            A and C are regarded as two-dimensional matrices with dimensions
            [NR][NC].  F is regarded as a two-dimensional matrix with
            dimensions [P][Q].

            A and C are regarded as two-dimensional matrices with dimensions
            [NR][NC].  F is regarded as a two-dimensional matrix with
            dimensions [P][P]:

            Pseudocode:     Memory:
            A[j][k]         A[j*NC + k]
            C[j][k]         C[j*NC + k]
            F[j][k]         F[j*Q  + k]

        These compute:

            P and Q must be odd.  "P/2" and "Q/2" are evaluated with integer
            arithmetic, so, if P is 3, P/2 is 1, not 1.5.

            for (r = P/2; r < NR-P/2; ++r)
            for (c = Q/2; c < NC-Q/2; ++c)
                C[r][c] = sum(A[r+j][c+k] * F[j+P/2][k+Q/2],
                    -P/2 <= j <= P/2, -Q/2 <= k <= Q/2);

            All other elements of C (borders of P/2 elements at the top and
            bottom and Q/2 elements at the left and right) are set to zero.
    */


public static native void vDSP_mtrans(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mtrans(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mtrans(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mtransD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mtransD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mtransD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N);
    /*  Maps:

            A is regarded as a two-dimensional matrix with dimemnsions
            [N][M] and stride IA.  C is regarded as a two-dimensional matrix
            with dimemnsions [M][N] and stride IC:

            Pseudocode:     Memory:
            A[n][m]         A[(n*M + m)*IA]
            C[m][n]         C[(m*N + n)*IC]

        These compute:

            for (m = 0; m < M; ++m)
            for (n = 0; n < N; ++n)
                C[m][n] = A[n][m];
    */


/*  Matrix multiply.
*/
public static native void vDSP_mmul(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_mmul(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_mmul(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_mmulD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_mmulD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_mmulD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
    /*  Maps:

            A is regarded as a two-dimensional matrix with dimemnsions [M][P]
            and stride IA.  B is regarded as a two-dimensional matrix with
            dimemnsions [P][N] and stride IB.  C is regarded as a
            two-dimensional matrix with dimemnsions [M][N] and stride IC.

            Pseudocode:     Memory:
            A[m][p]         A[(m*P+p)*IA]
            B[p][n]         B[(p*N+n)*IB]
            C[m][n]         C[(m*N+n)*IC]

        These compute:

            for (m = 0; m < M; ++m)
            for (n = 0; n < N; ++n)
                C[m][n] = sum(A[m][p] * B[p][n], 0 <= p < P);
    */


/*  Split-complex matrix multiply and add.
*/
public static native void vDSP_zmma(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zmmaD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
    /*  Maps:

            Pseudocode:     Memory:
            A[m][p]         A->realp[(m*P+p)*IA] + i * A->imagp[(m*P+p)*IA].
            B[p][n]         B->realp[(p*N+n)*IB] + i * B->imagp[(p*N+n)*IB].
            C[m][n]         C->realp[(m*N+n)*IC] + i * C->imagp[(m*N+n)*IC].
            D[m][n]         D->realp[(m*N+n)*ID] + i * D->imagp[(m*N+n)*ID].

        These compute:

            for (m = 0; m < M; ++m)
            for (n = 0; n < N; ++n)
                D[m][n] = sum(A[m][p] * B[p][n], 0 <= p < P) + C[m][n];
    */


/*  Split-complex matrix multiply and subtract.
*/
public static native void vDSP_zmms(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zmmsD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
    /*  Maps:

            Pseudocode:     Memory:
            A[m][p]         A->realp[(m*P+p)*IA] + i * A->imagp[(m*P+p)*IA].
            B[p][n]         B->realp[(p*N+n)*IB] + i * B->imagp[(p*N+n)*IB].
            C[m][n]         C->realp[(m*N+n)*IC] + i * C->imagp[(m*N+n)*IC].
            D[m][n]         D->realp[(m*N+n)*ID] + i * D->imagp[(m*N+n)*ID].

        These compute:

            for (m = 0; m < M; ++m)
            for (n = 0; n < N; ++n)
                D[m][n] = sum(A[m][p] * B[p][n], 0 <= p < P) - C[m][n];
    */


// Vector multiply, multiply, add, and add.
public static native void vDSP_zvmmaa(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Const DSPSplitComplex __E,
    @Cast("vDSP_Stride") long __IE,
    @Const DSPSplitComplex __F,
    @Cast("vDSP_Stride") long __IF,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmmaaD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Const DSPDoubleSplitComplex __E,
    @Cast("vDSP_Stride") long __IE,
    @Const DSPDoubleSplitComplex __F,
    @Cast("vDSP_Stride") long __IF,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                F[n] = A[n] * B[n] + C[n] * D[n] + E[n];
    */


/*  Split-complex matrix multiply and reverse subtract.
*/
public static native void vDSP_zmsm(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zmsmD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
    /*  Maps:

            Pseudocode:     Memory:
            A[m][p]         A->realp[(m*P+p)*IA] + i * A->imagp[(m*P+p)*IA].
            B[p][n]         B->realp[(p*N+n)*IB] + i * B->imagp[(p*N+n)*IB].
            C[m][n]         C->realp[(m*N+n)*IC] + i * C->imagp[(m*N+n)*IC].
            D[m][n]         D->realp[(m*N+n)*ID] + i * D->imagp[(m*N+n)*ID].

        These compute:

            for (m = 0; m < M; ++m)
            for (n = 0; n < N; ++n)
                D[m][n] = C[m][n] - sum(A[m][p] * B[p][n], 0 <= p < P);
    */


/*  Split-complex matrix multiply.
*/
public static native void vDSP_zmmul(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zmmulD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
    /*  Maps:

            Pseudocode:     Memory:
            A[m][p]         A->realp[(m*P+p)*IA] + i * A->imagp[(m*P+p)*IA].
            B[p][n]         B->realp[(p*N+n)*IB] + i * B->imagp[(p*N+n)*IB].
            C[m][n]         C->realp[(m*N+n)*IC] + i * C->imagp[(m*N+n)*IC].

        These compute:

            for (m = 0; m < M; ++m)
            for (n = 0; n < N; ++n)
                C[m][n] = sum(A[m][p] * B[p][n], 0 <= p < P);
    */


// Vector add.
public static native void vDSP_vadd(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vadd(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vadd(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddi(
    @Const IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const IntPointer __B,
    @Cast("vDSP_Stride") long __IB,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddi(
    @Const IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const IntBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddi(
    @Const int[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const int[] __B,
    @Cast("vDSP_Stride") long __IB,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvadd(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvaddD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvadd(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvadd(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvadd(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvaddD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvaddD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvaddD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] + B[n];
    */


// Vector subtract.
public static native void vDSP_vsub(
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsub(
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsub(
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsubD(
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsubD(
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsubD(
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvsub(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvsubD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] - B[n];
    */


// Vector multiply.
public static native void vDSP_vmul(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmul(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmul(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmulD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmulD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmulD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvmul(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvmul(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvmul(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvmulD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvmulD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvmulD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] * B[n];
    */


// Vector divide.
public static native void vDSP_vdiv(
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdiv(
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdiv(
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdivD(
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdivD(
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdivD(
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdivi(
    @Const IntPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdivi(
    @Const IntBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdivi(
    @Const int[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const int[] __A,
    @Cast("vDSP_Stride") long __IA,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvdiv(
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvdivD(
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvdiv(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvdiv(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvdiv(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvdivD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvdivD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvdivD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] / B[n];
    */


// Vector-scalar multiply.
public static native void vDSP_vsmul(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmul(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmul(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmulD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmulD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmulD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] * B[0];
    */


// Vector square.
public static native void vDSP_vsq(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsq(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsq(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsqD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsqD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsqD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n]**2;
    */



// Vector signed square.
public static native void vDSP_vssq(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vssq(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vssq(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vssqD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vssqD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vssqD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] * |A[n]|;
    */


// Euclidean distance, squared.
public static native void vDSP_distancesq(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_distancesq(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_distancesq(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_distancesqD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_distancesqD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_distancesqD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum((A[n] - B[n]) ** 2, 0 <= n < N);
    */


// Dot product.
public static native void vDSP_dotpr(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotprD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotprD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotprD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zdotpr(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zdotprD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrdotpr(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrdotpr(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrdotpr(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrdotprD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrdotprD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrdotprD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(A[n] * B[n], 0 <= n < N);
    */


// Vector add and multiply.
public static native void vDSP_vam(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vam(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vam(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vamD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __IDD,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vamD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __IDD,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vamD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    double[] __D,
    @Cast("vDSP_Stride") long __IDD,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                D[n] = (A[n] + B[n]) * C[n];
    */


// Vector multiply and add.
public static native void vDSP_vma(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vma(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vma(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvma(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmaD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                D[n] = A[n] * B[n] + C[n];
    */


// Complex multiplication with optional conjugation.
public static native void vDSP_zvmul(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    int __Conjugate);
public static native void vDSP_zvmulD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    int __Conjugate);
    /*  Maps:  The default maps are used.

        These compute:

            If Conjugate is +1:

                for (n = 0; n < N; ++n)
                    C[n] = A[n] * B[n];

            If Conjugate is -1:

                for (n = 0; n < N; ++n)
                    C[n] = conj(A[n]) * B[n];
    */


// Complex-split inner (conjugate) dot product.
public static native void vDSP_zidotpr(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zidotprD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(conj(A[n]) * B[n], 0 <= n < N);
    */


// Complex-split conjugate multiply and add.
public static native void vDSP_zvcma(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvcmaD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                D[n] = conj(A[n]) * B[n] + C[n];
    */


// Subtract real from complex-split.
public static native void vDSP_zrvsub(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvsub(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvsub(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvsubD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvsubD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zrvsubD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] - B[n];
    */


// Vector convert between double precision and single precision.
public static native void vDSP_vdpsp(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdpsp(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdpsp(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vspdp(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vspdp(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vspdp(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n];
    */


// Vector absolute value.
public static native void vDSP_vabs(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vabs(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vabs(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vabsD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vabsD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vabsD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vabsi(
    @Const IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vabsi(
    @Const IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vabsi(
    @Const int[] __A,
    @Cast("vDSP_Stride") long __IA,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvabs(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvabs(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvabs(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvabsD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvabsD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvabsD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = |A[n]|;
    */


// Vector bit-wise equivalence, NOT (A XOR B).
public static native void vDSP_veqvi(
    @Const IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const IntPointer __B,
    @Cast("vDSP_Stride") long __IB,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_veqvi(
    @Const IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const IntBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_veqvi(
    @Const int[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const int[] __B,
    @Cast("vDSP_Stride") long __IB,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = ~(A[n] ^ B[n]);
    */


// Vector fill.
public static native void vDSP_vfill(
    @Const FloatPointer __A,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfill(
    @Const FloatBuffer __A,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfill(
    @Const float[] __A,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfillD(
    @Const DoublePointer __A,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfillD(
    @Const DoubleBuffer __A,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfillD(
    @Const double[] __A,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfilli(
    @Const IntPointer __A,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfilli(
    @Const IntBuffer __A,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfilli(
    @Const int[] __A,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvfill(
    @Const DSPSplitComplex __A,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvfillD(
    @Const DSPDoubleSplitComplex __A,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[0];
    */


// Vector-scalar add.
public static native void vDSP_vsadd(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsadd(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsadd(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsaddD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsaddD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsaddD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsaddi(
    @Const IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const IntPointer __B,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsaddi(
    @Const IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const IntBuffer __B,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsaddi(
    @Const int[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const int[] __B,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] + B[0];
    */


// Vector-scalar divide.
public static native void vDSP_vsdiv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsdiv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsdiv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsdivD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsdivD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsdivD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsdivi(
    @Const IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const IntPointer __B,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsdivi(
    @Const IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const IntBuffer __B,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsdivi(
    @Const int[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const int[] __B,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] / B[0];
    */


// Complex-split accumulating autospectrum.
public static native void vDSP_zaspec(
    @Const DSPSplitComplex __A,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zaspec(
    @Const DSPSplitComplex __A,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zaspec(
    @Const DSPSplitComplex __A,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zaspecD(
    @Const DSPDoubleSplitComplex __A,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zaspecD(
    @Const DSPDoubleSplitComplex __A,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zaspecD(
    @Const DSPDoubleSplitComplex __A,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:

            No strides are used; arrays map directly to memory.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] += |A[n]| ** 2;
    */


// Create Blackman window.
public static native void vDSP_blkman_window(
    FloatPointer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_blkman_window(
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_blkman_window(
    float[] __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_blkman_windowD(
    DoublePointer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_blkman_windowD(
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_blkman_windowD(
    double[] __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
    /*  Maps:

            No strides are used; the array maps directly to memory.

        These compute:

            If Flag & vDSP_HALF_WINDOW:
                Length = (N+1)/2;
            Else
                Length = N;

            for (n = 0; n < Length; ++n)
            {
                angle = 2*pi*n/N;
                C[n] = .42 - .5 * cos(angle) + .08 * cos(2*angle);
            }
    */


// Coherence function.
public static native void vDSP_zcoher(
    @Const FloatPointer __A,
    @Const FloatPointer __B,
    @Const DSPSplitComplex __C,
    FloatPointer __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zcoher(
    @Const FloatBuffer __A,
    @Const FloatBuffer __B,
    @Const DSPSplitComplex __C,
    FloatBuffer __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zcoher(
    @Const float[] __A,
    @Const float[] __B,
    @Const DSPSplitComplex __C,
    float[] __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zcoherD(
    @Const DoublePointer __A,
    @Const DoublePointer __B,
    @Const DSPDoubleSplitComplex __C,
    DoublePointer __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zcoherD(
    @Const DoubleBuffer __A,
    @Const DoubleBuffer __B,
    @Const DSPDoubleSplitComplex __C,
    DoubleBuffer __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zcoherD(
    @Const double[] __A,
    @Const double[] __B,
    @Const DSPDoubleSplitComplex __C,
    double[] __D,
    @Cast("vDSP_Length") long __N);
    /*  Maps:

            No strides are used; arrays map directly to memory.

        These compute:

            for (n = 0; n < N; ++n)
                D[n] = |C[n]| ** 2 / (A[n] * B[n]);
    */


// Anti-aliasing down-sample with real filter.
public static native void vDSP_desamp(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __DF,
    @Const FloatPointer __F,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_desamp(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __DF,
    @Const FloatBuffer __F,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_desamp(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __DF,
    @Const float[] __F,
    float[] __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_desampD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __DF,
    @Const DoublePointer __F,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_desampD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __DF,
    @Const DoubleBuffer __F,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_desampD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __DF,
    @Const double[] __F,
    double[] __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zrdesamp(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __DF,
    @Const FloatPointer __F,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zrdesamp(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __DF,
    @Const FloatBuffer __F,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zrdesamp(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __DF,
    @Const float[] __F,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zrdesampD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __DF,
    @Const DoublePointer __F,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zrdesampD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __DF,
    @Const DoubleBuffer __F,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_zrdesampD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __DF,
    @Const double[] __F,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
    /*  Maps:

            No strides are used; arrays map directly to memory.  DF specifies
            the decimation factor.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = sum(A[n*DF+p] * F[p], 0 <= p < P);
    */


// Transfer function, B/A.
public static native void vDSP_ztrans(
    @Const FloatPointer __A,
    @Const DSPSplitComplex __B,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_ztrans(
    @Const FloatBuffer __A,
    @Const DSPSplitComplex __B,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_ztrans(
    @Const float[] __A,
    @Const DSPSplitComplex __B,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_ztransD(
    @Const DoublePointer __A,
    @Const DSPDoubleSplitComplex __B,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_ztransD(
    @Const DoubleBuffer __A,
    @Const DSPDoubleSplitComplex __B,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_ztransD(
    @Const double[] __A,
    @Const DSPDoubleSplitComplex __B,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:

            No strides are used; arrays map directly to memory.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = B[n] / A[n];
    */


// Accumulating cross-spectrum.
public static native void vDSP_zcspec(
    @Const DSPSplitComplex __A,
    @Const DSPSplitComplex __B,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zcspecD(
    @Const DSPDoubleSplitComplex __A,
    @Const DSPDoubleSplitComplex __B,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:

            No strides are used; arrays map directly to memory.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] += conj(A[n]) * B[n];
    */


// Vector conjugate and multiply.
public static native void vDSP_zvcmul(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvcmulD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __iC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = conj(A[n]) * B[n];
    */


// Vector conjugate.
public static native void vDSP_zvconj(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvconjD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = conj(A[n]);
    */


// Vector multiply with scalar.
public static native void vDSP_zvzsml(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvzsmlD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] * B[0];
    */


// Vector magnitudes squared.
public static native void vDSP_zvmags(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmags(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmags(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmagsD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmagsD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmagsD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = |A[n]| ** 2;
    */


// Vector magnitudes square and add.
public static native void vDSP_zvmgsa(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmgsa(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmgsa(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmgsaD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmgsaD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmgsaD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = |A[n]| ** 2 + B[n];
    */


// Complex-split vector move.
public static native void vDSP_zvmov(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvmovD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n];
    */


// Vector negate.
public static native void vDSP_zvneg(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvnegD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = -A[n];
    */


// Vector phasea.
public static native void vDSP_zvphas(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvphas(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvphas(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvphasD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvphasD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvphasD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = atan2(Im(A[n]), Re(A[n]));
    */


// Vector multiply by scalar and add.
public static native void vDSP_zvsma(
    @Const DSPSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPSplitComplex __B,
    @Const DSPSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_zvsmaD(
    @Const DSPDoubleSplitComplex __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DSPDoubleSplitComplex __B,
    @Const DSPDoubleSplitComplex __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DSPDoubleSplitComplex __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                D[n] = A[n] * B[0] + C[n];
    */


// Difference equation, 2 poles, 2 zeros.
public static native void vDSP_deq22(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_deq22(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_deq22(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_deq22D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_deq22D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_deq22D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 2; n < N+2; ++n)   // Note outputs start with C[2].
                C[n] =
                    + A[n-0]*B[0]
                    + A[n-1]*B[1]
                    + A[n-2]*B[2]
                    - C[n-1]*B[3]
                    - C[n-2]*B[4];
    */


// Create Hamming window.
public static native void vDSP_hamm_window(
    FloatPointer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hamm_window(
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hamm_window(
    float[] __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hamm_windowD(
    DoublePointer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hamm_windowD(
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hamm_windowD(
    double[] __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
    /*  Maps:

            No strides are used; the array maps directly to memory.

        These compute:

            If Flag & vDSP_HALF_WINDOW:
                Length = (N+1)/2;
            Else
                Length = N;

            for (n = 0; n < Length; ++n)
                C[n] = .54 - .46 * cos(2*pi*n/N);
    */


// Create Hanning window.
public static native void vDSP_hann_window(
    FloatPointer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hann_window(
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hann_window(
    float[] __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hann_windowD(
    DoublePointer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hann_windowD(
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
public static native void vDSP_hann_windowD(
    double[] __C,
    @Cast("vDSP_Length") long __N,
    int __Flag);
    /*  Maps:

            No strides are used; the array maps directly to memory.

        These compute:

            If Flag & vDSP_HALF_WINDOW:
                Length = (N+1)/2;
            Else
                Length = N;

            If Flag & vDSP_HANN_NORM:
                W = .816496580927726;
            Else
                W = .5;

            for (n = 0; n < Length; ++n)
                C[n] = W * (1 - cos(2*pi*n/N));
    */


// Maximum magnitude of vector.
public static native void vDSP_maxmgv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgvD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgvD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgvD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        C[0] is set to the greatest value of |A[n]| for 0 <= n < N.
    */


// Maximum magnitude of vector.
public static native void vDSP_maxmgvi(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgvi(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgvi(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgviD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgviD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxmgviD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        C[0] is set to the greatest value of |A[n]| for 0 <= n < N.
        I[0] is set to the least i*IA such that |A[i]| has the value in C[0].
    */


// Maximum value of vector.
public static native void vDSP_maxv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxvD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __I,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxvD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __I,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxvD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __I,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        C[0] is set to the greatest value of A[n] for 0 <= n < N.
    */


// Maximum value of vector, with index.
public static native void vDSP_maxvi(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxvi(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxvi(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxviD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxviD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_maxviD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        C[0] is set to the greatest value of A[n] for 0 <= n < N.
        I[0] is set to the least i*IA such that A[i] has the value in C[0].
    */


// Mean magnitude of vector.
public static native void vDSP_meamgv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meamgv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meamgv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meamgvD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meamgvD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meamgvD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(|A[n]|, 0 <= n < N) / N;
    */


// Mean of vector.
public static native void vDSP_meanv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meanv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meanv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meanvD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meanvD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_meanvD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(A[n], 0 <= n < N) / N;
    */


// Mean square of vector.
public static native void vDSP_measqv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_measqv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_measqv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_measqvD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __I,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_measqvD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __I,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_measqvD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __I,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(A[n]**2, 0 <= n < N) / N;
    */


// Minimum magnitude of vector.
public static native void vDSP_minmgv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgvD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgvD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgvD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        C[0] is set to the least value of |A[n]| for 0 <= n < N.
    */


// Minimum magnitude of vector, with index.
public static native void vDSP_minmgvi(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgvi(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgvi(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgviD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgviD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minmgviD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        C[0] is set to the least value of |A[n]| for 0 <= n < N.
        I[0] is set to the least i*IA such that |A[i]| has the value in C[0].
    */


// Minimum value of vector.
public static native void vDSP_minv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minvD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minvD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minvD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        C[0] is set to the least value of A[n] for 0 <= n < N.
    */


// Minimum value of vector, with index.
public static native void vDSP_minvi(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minvi(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minvi(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minviD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minviD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_minviD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        C[0] is set to the least value of A[n] for 0 <= n < N.
        I[0] is set to the least i*IA such that A[i] has the value in C[0].
    */


// Matrix move.
public static native void vDSP_mmov(
    @Const FloatPointer __A,
    FloatPointer __C,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __TA,
    @Cast("vDSP_Length") long __TC);
public static native void vDSP_mmov(
    @Const FloatBuffer __A,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __TA,
    @Cast("vDSP_Length") long __TC);
public static native void vDSP_mmov(
    @Const float[] __A,
    float[] __C,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __TA,
    @Cast("vDSP_Length") long __TC);
public static native void vDSP_mmovD(
    @Const DoublePointer __A,
    DoublePointer __C,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __TA,
    @Cast("vDSP_Length") long __TC);
public static native void vDSP_mmovD(
    @Const DoubleBuffer __A,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __TA,
    @Cast("vDSP_Length") long __TC);
public static native void vDSP_mmovD(
    @Const double[] __A,
    double[] __C,
    @Cast("vDSP_Length") long __M,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __TA,
    @Cast("vDSP_Length") long __TC);
    /*  Maps:

            This routine does not have strides.

            A is regarded as a two-dimensional matrix with dimensions [N][TA].
            C is regarded as a two-dimensional matrix with dimensions [N][TC].

        These compute:

            for (n = 0; n < N; ++n)
            for (m = 0; m < M; ++m)
                C[n][m] = A[n][m];
    */


// Mean of signed squares of vector.
public static native void vDSP_mvessq(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mvessq(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mvessq(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mvessqD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mvessqD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_mvessqD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(A[n] * |A[n]|, 0 <= n < N) / N;
    */


// Find zero crossing.
public static native void vDSP_nzcros(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Length") long __B,
    @Cast("vDSP_Length*") CLongPointer __C,
    @Cast("vDSP_Length*") CLongPointer __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_nzcros(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Length") long __B,
    @Cast("vDSP_Length*") CLongPointer __C,
    @Cast("vDSP_Length*") CLongPointer __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_nzcros(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Length") long __B,
    @Cast("vDSP_Length*") CLongPointer __C,
    @Cast("vDSP_Length*") CLongPointer __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_nzcrosD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Length") long __B,
    @Cast("vDSP_Length*") CLongPointer __C,
    @Cast("vDSP_Length*") CLongPointer __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_nzcrosD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Length") long __B,
    @Cast("vDSP_Length*") CLongPointer __C,
    @Cast("vDSP_Length*") CLongPointer __D,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_nzcrosD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("vDSP_Length") long __B,
    @Cast("vDSP_Length*") CLongPointer __C,
    @Cast("vDSP_Length*") CLongPointer __D,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        Let S be the number of times the sign bit changes in the sequence A[0],
        A[1],... A[N-1].

        If B <= S:
            D[0] is set to B.
            C[0] is set to n*IA, where the B-th sign bit change occurs between
            elements A[n-1] and A[n].
        Else:
            D[0] is set to S.
            C[0] is set to 0.
    */


// Convert rectangular to polar.
public static native void vDSP_polar(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_polar(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_polar(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_polarD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_polarD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_polarD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  Strides are shown explicitly in pseudocode.

        These compute:

            for (n = 0; n < N; ++n)
            {
                x = A[n*IA+0];
                y = A[n*IA+1];
                C[n*IC+0] = sqrt(x**2 + y**2);
                C[n*IC+1] = atan2(y, x);
            }
    */


// Convert polar to rectangular.
public static native void vDSP_rect(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rect(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rect(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rectD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rectD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rectD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  Strides are shown explicitly in pseudocode.

        These compute:

            for (n = 0; n < N; ++n)
            {
                r     = A[n*IA+0];
                theta = A[n*IA+1];
                C[n*IC+0] = r * cos(theta);
                C[n*IC+1] = r * sin(theta);
            }
    */


// Root-mean-square of vector.
public static native void vDSP_rmsqv(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rmsqv(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rmsqv(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rmsqvD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rmsqvD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_rmsqvD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sqrt(sum(A[n] ** 2, 0 <= n < N) / N);
    */


// Scalar-vector divide.
public static native void vDSP_svdiv(
    @Const FloatPointer __A,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svdiv(
    @Const FloatBuffer __A,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svdiv(
    @Const float[] __A,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svdivD(
    @Const DoublePointer __A,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svdivD(
    @Const DoubleBuffer __A,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svdivD(
    @Const double[] __A,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[0] / B[n];

        When A[0] is not zero or NaN and B[n] is zero, C[n] is set to an
        infinity.
    */


// Sum of vector elements.
public static native void vDSP_sve(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __I,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sve(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __I,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sve(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __I,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sveD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __I,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sveD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __I,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sveD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __I,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(A[n], 0 <= n < N);
    */


// Sum of vector elements magnitudes.
public static native void vDSP_svemg(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svemg(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svemg(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svemgD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svemgD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svemgD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(|A[n]|, 0 <= n < N);
    */


// Sum of vector elements' squares.
public static native void vDSP_svesq(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svesq(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svesq(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svesqD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svesqD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svesqD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(A[n] ** 2, 0 <= n < N);
    */


// Sum of vector elements and sum of vector elements' squares.
public static native void vDSP_sve_svesq(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __Sum,
    FloatPointer __SumOfSquares,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sve_svesq(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __Sum,
    FloatBuffer __SumOfSquares,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sve_svesq(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __Sum,
    float[] __SumOfSquares,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sve_svesqD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __Sum,
    DoublePointer __SumOfSquares,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sve_svesqD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __Sum,
    DoubleBuffer __SumOfSquares,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_sve_svesqD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __Sum,
    double[] __SumOfSquares,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            Sum[0]          = sum(A[n],      0 <= n < N);
            SumOfSquares[0] = sum(A[n] ** 2, 0 <= n < N);
    */


/*  Compute mean and standard deviation and then calculate new elements to have
    a zero mean and a unit standard deviation.

    For iOS 9.0 and later or OS X 10.11 and later, the production of new
    elements may be omitted by passing NULL for C.
*/
// #if (defined __IPHONE_OS_VERSION_MIN_REQUIRED && __IPHONE_OS_VERSION_MIN_REQUIRED < 90000) ||
//      (defined __MAC_OS_X_VERSION_MIN_REQUIRED && __MAC_OS_X_VERSION_MIN_REQUIRED < 101100)
    public static native void vDSP_normalize(
            @Const FloatPointer __A,
            @Cast("vDSP_Stride") long __IA,
            FloatPointer __C,
            @Cast("vDSP_Stride") long __IC,
            FloatPointer __Mean,
            FloatPointer __StandardDeviation,
            @Cast("vDSP_Length") long __N);
    public static native void vDSP_normalize(
            @Const FloatBuffer __A,
            @Cast("vDSP_Stride") long __IA,
            FloatBuffer __C,
            @Cast("vDSP_Stride") long __IC,
            FloatBuffer __Mean,
            FloatBuffer __StandardDeviation,
            @Cast("vDSP_Length") long __N);
    public static native void vDSP_normalize(
            @Const float[] __A,
            @Cast("vDSP_Stride") long __IA,
            float[] __C,
            @Cast("vDSP_Stride") long __IC,
            float[] __Mean,
            float[] __StandardDeviation,
            @Cast("vDSP_Length") long __N);
    public static native void vDSP_normalizeD(
            @Const DoublePointer __A,
            @Cast("vDSP_Stride") long __IA,
            DoublePointer __C,
            @Cast("vDSP_Stride") long __IC,
            DoublePointer __Mean,
            DoublePointer __StandardDeviation,
            @Cast("vDSP_Length") long __N);
    public static native void vDSP_normalizeD(
            @Const DoubleBuffer __A,
            @Cast("vDSP_Stride") long __IA,
            DoubleBuffer __C,
            @Cast("vDSP_Stride") long __IC,
            DoubleBuffer __Mean,
            DoubleBuffer __StandardDeviation,
            @Cast("vDSP_Length") long __N);
    public static native void vDSP_normalizeD(
            @Const double[] __A,
            @Cast("vDSP_Stride") long __IA,
            double[] __C,
            @Cast("vDSP_Stride") long __IC,
            double[] __Mean,
            double[] __StandardDeviation,
            @Cast("vDSP_Length") long __N);
// #else
// #endif
    /*  Maps:  The default maps are used.

        These compute:

            // Calculate mean and standard deviation.
            m = sum(A[n], 0 <= n < N) / N;
            d = sqrt(sum(A[n]**2, 0 <= n < N) / N - m**2);

            if (C)
            {
                // Normalize.
                for (n = 0; n < N; ++n)
                    C[n] = (A[n] - m) / d;
            }
    */


// Sum of vector elements' signed squares.
public static native void vDSP_svs(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svs(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svs(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svsD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svsD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_svsD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            C[0] = sum(A[n] * |A[n]|, 0 <= n < N);
    */


// Vector add, add, and multiply.
public static native void vDSP_vaam(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatPointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaam(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaam(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const float[] __D,
    @Cast("vDSP_Stride") long __ID,
    float[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaamD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    DoublePointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaamD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    DoubleBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaamD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const double[] __D,
    @Cast("vDSP_Stride") long __ID,
    double[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                E[n] = (A[n] + B[n]) * (C[n] + D[n]);
    */


// Vector add, subtract, and multiply.
public static native void vDSP_vasbm(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatPointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasbm(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasbm(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const float[] __D,
    @Cast("vDSP_Stride") long __ID,
    float[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasbmD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    DoublePointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasbmD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    DoubleBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasbmD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const double[] __D,
    @Cast("vDSP_Stride") long __ID,
    double[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                E[n] = (A[n] + B[n]) * (C[n] - D[n]);
    */


// Vector add and scalar multiply.
public static native void vDSP_vasm(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasm(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasm(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasmD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasmD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vasmD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                D[n] = (A[n] + B[n]) * C[0];
    */


// Vector linear average.
public static native void vDSP_vavlin(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vavlin(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vavlin(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vavlinD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vavlinD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vavlinD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = (C[n]*B[0] + A[n]) / (B[0] + 1);
    */


// Vector clip.
public static native void vDSP_vclip(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclip(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclip(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclipD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclipD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclipD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
            {
                D[n] = A[n];
                if (D[n] < B[0]) D[n] = B[0];
                if (C[0] < D[n]) D[n] = C[0];
            }
    */


// Vector clip and count.
public static native void vDSP_vclipc(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length*") CLongPointer __NLow,
    @Cast("vDSP_Length*") CLongPointer __NHigh);
public static native void vDSP_vclipc(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length*") CLongPointer __NLow,
    @Cast("vDSP_Length*") CLongPointer __NHigh);
public static native void vDSP_vclipc(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length*") CLongPointer __NLow,
    @Cast("vDSP_Length*") CLongPointer __NHigh);
public static native void vDSP_vclipcD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length*") CLongPointer __NLow,
    @Cast("vDSP_Length*") CLongPointer __NHigh);
public static native void vDSP_vclipcD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length*") CLongPointer __NLow,
    @Cast("vDSP_Length*") CLongPointer __NHigh);
public static native void vDSP_vclipcD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length*") CLongPointer __NLow,
    @Cast("vDSP_Length*") CLongPointer __NHigh);
    /*  Maps:  The default maps are used.

        These compute:

            NLow[0]  = 0;
            NHigh[0] = 0;
            for (n = 0; n < N; ++n)
            {
                D[n] = A[n];
                if (D[n] < B[0]) { D[n] = B[0]; ++NLow[0];  }
                if (C[0] < D[n]) { D[n] = C[0]; ++NHigh[0]; }
            }
    */


// Vector clear.
public static native void vDSP_vclr(
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclr(
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclr(
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclrD(
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclrD(
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vclrD(
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = 0;
    */


// Vector compress.
public static native void vDSP_vcmprs(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vcmprs(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vcmprs(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vcmprsD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vcmprsD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vcmprsD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            p = 0;
            for (n = 0; n < N; ++n)
                if (B[n] != 0)
                    C[p++] = A[n];
    */


// Vector convert to decibels, power, or amplitude.
public static native void vDSP_vdbcon(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("unsigned int") int __F);
public static native void vDSP_vdbcon(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("unsigned int") int __F);
public static native void vDSP_vdbcon(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("unsigned int") int __F);
public static native void vDSP_vdbconD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("unsigned int") int __F);
public static native void vDSP_vdbconD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("unsigned int") int __F);
public static native void vDSP_vdbconD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("unsigned int") int __F);
    /*  Maps:  The default maps are used.

        These compute:

            If Flag is 1:
                alpha = 20;
            If Flag is 0:
                alpha = 10;

            for (n = 0; n < N; ++n)
                C[n] = alpha * log10(A[n] / B[0]);
    */


// Vector distance.
public static native void vDSP_vdist(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdist(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdist(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdistD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdistD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vdistD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = sqrt(A[n]**2 + B[n]**2);
    */


// Vector envelope.
public static native void vDSP_venvlp(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_venvlp(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_venvlp(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_venvlpD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_venvlpD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_venvlpD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
            {
                if (C[n] < B[n] || A[n] < C[n]) D[n] = C[n];
                else D[n] = 0;
            }
    */


// Vector convert to integer, round toward zero.
public static native void vDSP_vfix8(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") BytePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix8(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") ByteBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix8(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") byte[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix8D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") BytePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix8D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") ByteBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix8D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") byte[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix16(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    ShortPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix16(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    ShortBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix16(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    short[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix16D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    ShortPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix16D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    ShortBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix16D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    short[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix32(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix32(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix32(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix32D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix32D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfix32D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu8(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") BytePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu8(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") ByteBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu8(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") byte[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu8D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") BytePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu8D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") ByteBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu8D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") byte[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu16(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") ShortPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu16(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") ShortBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu16(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") short[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu16D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") ShortPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu16D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") ShortBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu16D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") short[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu32(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu32(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu32(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu32D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu32D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixu32D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = trunc(A[n]);
    */


/*  Vector convert single precision to 24-bit integer with pre-scaling.
    The scaled value is rounded toward zero.
*/
public static native void vDSP_vsmfixu24(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    vDSP_uint24 __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmfixu24(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    vDSP_uint24 __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmfixu24(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    vDSP_uint24 __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    
/*  Vector convert single precision to 24-bit unsigned integer with pre-scaling.
    The scaled value is rounded toward zero.
*/
public static native void vDSP_vsmfix24(
   @Const FloatPointer __A,
   @Cast("vDSP_Stride") long __IA,
   @Const FloatPointer __B,
   vDSP_int24 __C,
   @Cast("vDSP_Stride") long __IC,
   @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmfix24(
   @Const FloatBuffer __A,
   @Cast("vDSP_Stride") long __IA,
   @Const FloatBuffer __B,
   vDSP_int24 __C,
   @Cast("vDSP_Stride") long __IC,
   @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmfix24(
   @Const float[] __A,
   @Cast("vDSP_Stride") long __IA,
   @Const float[] __B,
   vDSP_int24 __C,
   @Cast("vDSP_Stride") long __IC,
   @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
    
        These compute:
    
            for (n = 0; n < N; ++n)
                C[n] = trunc(A[n] * B[0]);
    
        Note: Values outside the representable range are clamped to the largest
        or smallest representable values of the destination type.
    */

    
// Vector convert 24-bit integer to single-precision float.
public static native void vDSP_vfltu24(
   @Const vDSP_uint24 __A,
   @Cast("vDSP_Stride") long __IA,
   FloatPointer __C,
   @Cast("vDSP_Stride") long __IC,
   @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu24(
   @Const vDSP_uint24 __A,
   @Cast("vDSP_Stride") long __IA,
   FloatBuffer __C,
   @Cast("vDSP_Stride") long __IC,
   @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu24(
   @Const vDSP_uint24 __A,
   @Cast("vDSP_Stride") long __IA,
   float[] __C,
   @Cast("vDSP_Stride") long __IC,
   @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt24(
  @Const vDSP_int24 __A,
  @Cast("vDSP_Stride") long __IA,
  FloatPointer __C,
  @Cast("vDSP_Stride") long __IC,
  @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt24(
  @Const vDSP_int24 __A,
  @Cast("vDSP_Stride") long __IA,
  FloatBuffer __C,
  @Cast("vDSP_Stride") long __IC,
  @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt24(
  @Const vDSP_int24 __A,
  @Cast("vDSP_Stride") long __IA,
  float[] __C,
  @Cast("vDSP_Stride") long __IC,
  @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
    
        These compute:
    
            for (n = 0; n < N; ++n)
                C[n] = A[n];
    */

    
// Vector convert 24-bit integer to single-precision float and scale.
public static native void vDSP_vfltsmu24(
     @Const vDSP_uint24 __A,
     @Cast("vDSP_Stride") long __IA,
     @Const FloatPointer __B,
     FloatPointer __C,
     @Cast("vDSP_Stride") long __IC,
     @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltsmu24(
     @Const vDSP_uint24 __A,
     @Cast("vDSP_Stride") long __IA,
     @Const FloatBuffer __B,
     FloatBuffer __C,
     @Cast("vDSP_Stride") long __IC,
     @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltsmu24(
     @Const vDSP_uint24 __A,
     @Cast("vDSP_Stride") long __IA,
     @Const float[] __B,
     float[] __C,
     @Cast("vDSP_Stride") long __IC,
     @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltsm24(
    @Const vDSP_int24 __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltsm24(
    @Const vDSP_int24 __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltsm24(
    @Const vDSP_int24 __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
    
        These compute:
    
            for (n = 0; n < N; ++n)
                C[n] = B[0] * (float)A[n];
    */
        

// Vector convert to integer, round to nearest.
public static native void vDSP_vfixr8(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") BytePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr8(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") ByteBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr8(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") byte[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr8D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") BytePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr8D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") ByteBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr8D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("char*") byte[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr16(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    ShortPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr16(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    ShortBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr16(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    short[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr16D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    ShortPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr16D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    ShortBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr16D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    short[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr32(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr32(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr32(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr32D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr32D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixr32D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru8(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") BytePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru8(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") ByteBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru8(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") byte[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru8D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") BytePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru8D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") ByteBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru8D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned char*") byte[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru16(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") ShortPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru16(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") ShortBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru16(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") short[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru16D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") ShortPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru16D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") ShortBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru16D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned short*") short[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru32(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru32(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru32(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru32D(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") IntPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru32D(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") IntBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfixru32D(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Cast("unsigned int*") int[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = rint(A[n]);

        Note:  It is expected that the global rounding mode be the default,
        round-to-nearest.  It is unspecified whether ties round up or down.
    */


// Vector convert to floating-point from integer.
public static native void vDSP_vflt8(
    @Cast("const char*") BytePointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8(
    String __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8(
    @Cast("const char*") BytePointer __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8(
    String __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8(
    @Cast("const char*") BytePointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8(
    String __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8D(
    @Cast("const char*") BytePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8D(
    String __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8D(
    @Cast("const char*") BytePointer __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8D(
    String __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8D(
    @Cast("const char*") BytePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt8D(
    String __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt16(
    @Const ShortPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt16(
    @Const ShortBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt16(
    @Const short[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt16D(
    @Const ShortPointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt16D(
    @Const ShortBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt16D(
    @Const short[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt32(
    @Const IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt32(
    @Const IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt32(
    @Const int[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt32D(
    @Const IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt32D(
    @Const IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vflt32D(
    @Const int[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu8(
    @Cast("const unsigned char*") BytePointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu8(
    @Cast("const unsigned char*") ByteBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu8(
    @Cast("const unsigned char*") byte[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu8D(
    @Cast("const unsigned char*") BytePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu8D(
    @Cast("const unsigned char*") ByteBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu8D(
    @Cast("const unsigned char*") byte[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu16(
    @Cast("const unsigned short*") ShortPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu16(
    @Cast("const unsigned short*") ShortBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu16(
    @Cast("const unsigned short*") short[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu16D(
    @Cast("const unsigned short*") ShortPointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu16D(
    @Cast("const unsigned short*") ShortBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu16D(
    @Cast("const unsigned short*") short[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu32(
    @Cast("const unsigned int*") IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu32(
    @Cast("const unsigned int*") IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu32(
    @Cast("const unsigned int*") int[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu32D(
    @Cast("const unsigned int*") IntPointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu32D(
    @Cast("const unsigned int*") IntBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfltu32D(
    @Cast("const unsigned int*") int[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n];
    */


// Vector fraction part (subtract integer toward zero).
public static native void vDSP_vfrac(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfrac(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfrac(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfracD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfracD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vfracD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] - trunc(A[n]);
    */


// Vector gather.
public static native void vDSP_vgathr(
    @Const FloatPointer __A,
    @Cast("const vDSP_Length*") CLongPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathr(
    @Const FloatBuffer __A,
    @Cast("const vDSP_Length*") CLongPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathr(
    @Const float[] __A,
    @Cast("const vDSP_Length*") CLongPointer __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathrD(
    @Const DoublePointer __A,
    @Cast("const vDSP_Length*") CLongPointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathrD(
    @Const DoubleBuffer __A,
    @Cast("const vDSP_Length*") CLongPointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathrD(
    @Const double[] __A,
    @Cast("const vDSP_Length*") CLongPointer __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.  Note that A has unit stride.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[B[n] - 1];
    */


// Vector gather, absolute pointers.
public static native void vDSP_vgathra(
    @Cast("const float*const*") PointerPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathra(
    @Const @ByPtrPtr FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathra(
    @Const @ByPtrPtr FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathra(
    @Const @ByPtrPtr float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathraD(
    @Cast("const double*const*") PointerPointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathraD(
    @Const @ByPtrPtr DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathraD(
    @Const @ByPtrPtr DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgathraD(
    @Const @ByPtrPtr double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = *A[n];
    */


// Vector generate tapered ramp.
public static native void vDSP_vgen(
    @Const FloatPointer __A,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgen(
    @Const FloatBuffer __A,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgen(
    @Const float[] __A,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgenD(
    @Const DoublePointer __A,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgenD(
    @Const DoubleBuffer __A,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vgenD(
    @Const double[] __A,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[0] + (B[0] - A[0]) * n/(N-1);
    */


// Vector generate by extrapolation and interpolation.
public static native void vDSP_vgenp(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vgenp(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vgenp(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vgenpD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vgenpD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vgenpD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                If n <= B[0],  then C[n] = A[0].
                If B[M-1] < n, then C[n] = A[M-1].
                Otherwise:
                    Let m be such that B[m] < n <= B[m+1].
                    C[n] = A[m] + (A[m+1]-A[m]) * (n-B[m]) / (B[m+1]-B[m]).

         The elements of B are expected to be in increasing order.
    */


// Vector inverted clip.
public static native void vDSP_viclip(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_viclip(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_viclip(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_viclipD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_viclipD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_viclipD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
            {
                if (A[n] <= B[0] || C[0] <= A[n])
                    D[n] = A[n];
                else
                    if (A[n] < 0)
                        D[n] = B[0];
                    else
                        D[n] = C[0];
            }

        It is expected that B[0] <= 0 <= C[0].
    */


// Vector index, C[i] = A[truncate[B[i]].
public static native void vDSP_vindex(
    @Const FloatPointer __A,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vindex(
    @Const FloatBuffer __A,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vindex(
    @Const float[] __A,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vindexD(
    @Const DoublePointer __A,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vindexD(
    @Const DoubleBuffer __A,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vindexD(
    @Const double[] __A,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[trunc(B[n])];
    */


// Vector interpolation between vectors.
public static native void vDSP_vintb(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vintb(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vintb(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vintbD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vintbD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vintbD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                D[n] = A[n] + C[0] * (B[n] - A[n]);
    */


// Vector test limit.
public static native void vDSP_vlim(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vlim(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vlim(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vlimD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vlimD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vlimD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                if (B[0] <= A[n])
                    D[n] = +C[0];
                else
                    D[n] = -C[0];
    */


// Vector linear interpolation.
public static native void vDSP_vlint(
    @Const FloatPointer __A,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vlint(
    @Const FloatBuffer __A,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vlint(
    @Const float[] __A,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vlintD(
    @Const DoublePointer __A,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vlintD(
    @Const DoubleBuffer __A,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vlintD(
    @Const double[] __A,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
            {
                b = trunc(B[n]);
                a = B[n] - b;
                C[n] = A[b] + a * (A[b+1] - A[b]);
            }
    */


// Vector maxima.
public static native void vDSP_vmax(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmax(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmax(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaxD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaxD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaxD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = B[n] <= A[n] ? A[n] : B[n];
    */


// Vector maximum magnitude.
public static native void vDSP_vmaxmg(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaxmg(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaxmg(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaxmgD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaxmgD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmaxmgD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = |B[n]| <= |A[n]| ? |A[n]| : |B[n]|;
    */


// Vector sliding window maxima.
public static native void vDSP_vswmax(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __WindowLength);
public static native void vDSP_vswmax(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __WindowLength);
public static native void vDSP_vswmax(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __WindowLength);
public static native void vDSP_vswmaxD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __WindowLength);
public static native void vDSP_vswmaxD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __WindowLength);
public static native void vDSP_vswmaxD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __WindowLength);
    /*  Maps:  The default maps are used.

        These compute the maximum value within a window to the input vector.
        A maximum is calculated for each window position:

            for (n = 0; n < N; ++n)
                C[n] = the greatest value of A[w] for n <= w < n+WindowLength.

        A must contain N+WindowLength-1 elements, and C must contain space for
        N+WindowLength-1 elements.  Although only N outputs are provided in C,
        the additional elements may be used for intermediate computation.

        A and C may not overlap.

        WindowLength must be positive (zero is not supported).
    */


// Vector minima.
public static native void vDSP_vmin(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmin(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmin(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vminD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vminD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vminD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] <= B[n] ? A[n] : B[n];
    */


// Vector minimum magnitude.
public static native void vDSP_vminmg(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vminmg(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vminmg(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vminmgD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vminmgD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vminmgD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.

        These compute:

            for (n = 0; n < N; ++n)
                C[n] = |A[n]| <= |B[n]| ? |A[n]| : |B[n]|;
    */


// Vector multiply, multiply, and add.
public static native void vDSP_vmma(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatPointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmma(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmma(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const float[] __D,
    @Cast("vDSP_Stride") long __ID,
    float[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmmaD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    DoublePointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmmaD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    DoubleBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmmaD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const double[] __D,
    @Cast("vDSP_Stride") long __ID,
    double[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                E[n] = A[n]*B[n] + C[n]*D[n];
    */


// Vector multiply, multiply, and subtract.
public static native void vDSP_vmmsb(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatPointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmmsb(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmmsb(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const float[] __D,
    @Cast("vDSP_Stride") long __ID,
    float[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmmsbD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    DoublePointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmmsbD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    DoubleBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmmsbD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const double[] __D,
    @Cast("vDSP_Stride") long __ID,
    double[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                E[n] = A[n]*B[n] - C[n]*D[n];
    */


// Vector multiply and scalar add.
public static native void vDSP_vmsa(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsa(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsa(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsaD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsaD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsaD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                D[n] = A[n]*B[n] + C[0];
    */


// Vector multiply and subtract.
public static native void vDSP_vmsb(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsb(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsb(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsbD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsbD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vmsbD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                D[n] = A[n]*B[n] - C[n];
    */


// Vector negative absolute value.
public static native void vDSP_vnabs(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vnabs(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vnabs(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vnabsD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vnabsD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vnabsD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                C[n] = -|A[n]|;
    */


// Vector negate.
public static native void vDSP_vneg(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vneg(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vneg(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vnegD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vnegD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vnegD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                C[n] = -A[n];
    */


// Vector polynomial.
public static native void vDSP_vpoly(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vpoly(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vpoly(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vpolyD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vpolyD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vpolyD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                C[n] = sum(A[P-p] * B[n]**p, 0 <= p <= P);
    */


// Vector Pythagoras.
public static native void vDSP_vpythg(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatPointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vpythg(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vpythg(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const float[] __D,
    @Cast("vDSP_Stride") long __ID,
    float[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vpythgD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    DoublePointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vpythgD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    DoubleBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vpythgD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const double[] __D,
    @Cast("vDSP_Stride") long __ID,
    double[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                E[n] = sqrt((A[n]-C[n])**2 + (B[n]-D[n])**2);
    */


// Vector quadratic interpolation.
public static native void vDSP_vqint(
    @Const FloatPointer __A,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vqint(
    @Const FloatBuffer __A,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vqint(
    @Const float[] __A,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vqintD(
    @Const DoublePointer __A,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vqintD(
    @Const DoubleBuffer __A,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
public static native void vDSP_vqintD(
    @Const double[] __A,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __M);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
            {
                b = max(trunc(B[n]), 1);
                a = B[n] - b;
                C[n] = (A[b-1]*(a**2-a) + A[b]*(2-2*a**2) + A[b+1]*(a**2+a))
                    / 2;
            }
    */


// Vector build ramp.
public static native void vDSP_vramp(
    @Const FloatPointer __A,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vramp(
    @Const FloatBuffer __A,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vramp(
    @Const float[] __A,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampD(
    @Const DoublePointer __A,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampD(
    @Const DoubleBuffer __A,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampD(
    @Const double[] __A,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[0] + n*B[0];
    */


// Vector running sum integration.
public static native void vDSP_vrsum(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __S,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrsum(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __S,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrsum(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __S,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrsumD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __S,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrsumD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __S,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrsumD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __S,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                C[n] = S[0] * sum(A[j], 0 < j <= n);

        Observe that C[0] is set to 0, and A[0] is not used.
    */


// Vector reverse order, in-place.
public static native void vDSP_vrvrs(
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrvrs(
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrvrs(
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrvrsD(
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrvrsD(
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrvrsD(
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            Let A contain a copy of C.
            for (n = 0; n < N; ++n)
                C[n] = A[N-1-n];
    */


// Vector subtract and multiply.
public static native void vDSP_vsbm(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbm(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbm(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbmD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbmD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbmD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                D[n] = (A[n] - B[n]) * C[n];
    */


// Vector subtract, subtract, and multiply.
public static native void vDSP_vsbsbm(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatPointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsbm(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    FloatBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsbm(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const float[] __D,
    @Cast("vDSP_Stride") long __ID,
    float[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsbmD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    DoublePointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsbmD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    DoubleBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsbmD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const double[] __D,
    @Cast("vDSP_Stride") long __ID,
    double[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                E[n] = (A[n] - B[n]) * (C[n] - D[n]);
    */


// Vector subtract and scalar multiply.
public static native void vDSP_vsbsm(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsm(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsm(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsmD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsmD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsbsmD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                D[n] = (A[n] - B[n]) * C[0];
    */


// Vector Simpson integration.
public static native void vDSP_vsimps(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsimps(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsimps(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsimpsD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsimpsD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsimpsD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            C[0] = 0;
            C[1] = B[0] * (A[0] + A[1])/2;
            for (n = 2; n < N; ++n)
                C[n] = C[n-2] + B[0] * (A[n-2] + 4*A[n-1] + A[n])/3;
    */


// Vector-scalar multiply and vector add.
public static native void vDSP_vsma(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsma(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsma(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmaD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmaD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmaD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                D[n] = A[n]*B[0] + C[n];
    */


// Vector-scalar multiply and scalar add.
public static native void vDSP_vsmsa(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsa(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsa(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsaD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsaD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsaD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                D[n] = A[n]*B[0] + C[0];
    */


// Vector scalar multiply and vector subtract.
public static native void vDSP_vsmsb(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsb(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsb(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsbD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsbD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsbD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                D[n] = A[n]*B[0] - C[n];
    */


// Vector-scalar multiply, vector-scalar multiply and vector add.
public static native void vDSP_vsmsma(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Const FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatPointer __D,
    FloatPointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsma(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Const FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const FloatBuffer __D,
    FloatBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsma(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Const float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const float[] __D,
    float[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsmaD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Const DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoublePointer __D,
    DoublePointer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsmaD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Const DoubleBuffer __D,
    DoubleBuffer __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vsmsmaD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Const double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Const double[] __D,
    double[] __E,
    @Cast("vDSP_Stride") long __IE,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        This computes:

            for (n = 0; n < N; ++n)
                E[n] = A[n]*B[0] + C[n]*D[0];
    */


// Vector sort, in-place.
public static native void vDSP_vsort(
    FloatPointer __C,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsort(
    FloatBuffer __C,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsort(
    float[] __C,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsortD(
    DoublePointer __C,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsortD(
    DoubleBuffer __C,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsortD(
    double[] __C,
    @Cast("vDSP_Length") long __N,
    int __Order);
    /*  If Order is +1, C is sorted in ascending order.
        If Order is -1, C is sorted in descending order.
    */


// Vector sort indices, in-place.
public static native void vDSP_vsorti(
    @Const FloatPointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length*") CLongPointer __Temporary,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsorti(
    @Const FloatBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length*") CLongPointer __Temporary,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsorti(
    @Const float[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length*") CLongPointer __Temporary,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsortiD(
    @Const DoublePointer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length*") CLongPointer __Temporary,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsortiD(
    @Const DoubleBuffer __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length*") CLongPointer __Temporary,
    @Cast("vDSP_Length") long __N,
    int __Order);
public static native void vDSP_vsortiD(
    @Const double[] __C,
    @Cast("vDSP_Length*") CLongPointer __I,
    @Cast("vDSP_Length*") CLongPointer __Temporary,
    @Cast("vDSP_Length") long __N,
    int __Order);
    /*  Maps:  No strides are used; arrays map directly to memory.

        I contains indices into C.
        
        If Order is +1, I is sorted so that C[I[n]] increases, for 0 <= n < N.
        If Order is -1, I is sorted so that C[I[n]] decreases, for 0 <= n < N.

        Temporary is not used.  NULL should be passed for it.
    */


// Vector swap.
public static native void vDSP_vswap(
    FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vswap(
    FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vswap(
    float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vswapD(
    DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vswapD(
    DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vswapD(
    double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __B,
    @Cast("vDSP_Stride") long __IB,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                A[n] is swapped with B[n].
    */


// Vector sliding window sum.
public static native void vDSP_vswsum(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vswsum(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vswsum(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vswsumD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vswsumD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
public static native void vDSP_vswsumD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N,
    @Cast("vDSP_Length") long __P);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                C[n] = sum(A[n+p], 0 <= p < P);

        Note that A must contain N+P-1 elements.
    */


// Vector table lookup and interpolation.
public static native void vDSP_vtabi(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __S1,
    @Const FloatPointer __S2,
    @Const FloatPointer __C,
    @Cast("vDSP_Length") long __M,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtabi(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __S1,
    @Const FloatBuffer __S2,
    @Const FloatBuffer __C,
    @Cast("vDSP_Length") long __M,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtabi(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __S1,
    @Const float[] __S2,
    @Const float[] __C,
    @Cast("vDSP_Length") long __M,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtabiD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __S1,
    @Const DoublePointer __S2,
    @Const DoublePointer __C,
    @Cast("vDSP_Length") long __M,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtabiD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __S1,
    @Const DoubleBuffer __S2,
    @Const DoubleBuffer __C,
    @Cast("vDSP_Length") long __M,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtabiD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __S1,
    @Const double[] __S2,
    @Const double[] __C,
    @Cast("vDSP_Length") long __M,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
            {
                p = S1[0] * A[n] + S2[0];
                if (p < 0)
                    D[n] = C[0];
                else if (p < M-1)
                {
                    q = trunc(p);
                    r = p-q;
                    D[n] = (1-r)*C[q] + r*C[q+1];
                }
                else
                    D[n] = C[M-1];
            }
    */


// Vector threshold.
public static native void vDSP_vthr(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthr(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthr(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthrD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthrD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthrD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                if (B[0] <= A[n])
                    C[n] = A[n];
                else
                    C[n] = B[0];
    */


// Vector threshold with zero fill.
public static native void vDSP_vthres(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthres(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthres(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthresD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthresD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthresD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                if (B[0] <= A[n])
                    C[n] = A[n];
                else
                    C[n] = 0;
    */


// Vector threshold with signed constant.
public static native void vDSP_vthrsc(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Const FloatPointer __C,
    FloatPointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthrsc(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Const FloatBuffer __C,
    FloatBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthrsc(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Const float[] __C,
    float[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthrscD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Const DoublePointer __C,
    DoublePointer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthrscD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Const DoubleBuffer __C,
    DoubleBuffer __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vthrscD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Const double[] __C,
    double[] __D,
    @Cast("vDSP_Stride") long __ID,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                if (B[0] <= A[n])
                    D[n] = +C[0];
                else
                    D[n] = -C[0];
    */


// Vector tapered merge.
public static native void vDSP_vtmerg(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtmerg(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtmerg(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    @Cast("vDSP_Stride") long __IB,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtmergD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    @Cast("vDSP_Stride") long __IB,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtmergD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtmergD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    @Cast("vDSP_Stride") long __IB,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            for (n = 0; n < N; ++n)
                C[n] = A[n] + (B[n] - A[n]) * n/(N-1);
    */


// Vector trapezoidal integration.
public static native void vDSP_vtrapz(
    @Const FloatPointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatPointer __B,
    FloatPointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtrapz(
    @Const FloatBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const FloatBuffer __B,
    FloatBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtrapz(
    @Const float[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const float[] __B,
    float[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtrapzD(
    @Const DoublePointer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoublePointer __B,
    DoublePointer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtrapzD(
    @Const DoubleBuffer __A,
    @Cast("vDSP_Stride") long __IA,
    @Const DoubleBuffer __B,
    DoubleBuffer __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vtrapzD(
    @Const double[] __A,
    @Cast("vDSP_Stride") long __IA,
    @Const double[] __B,
    double[] __C,
    @Cast("vDSP_Stride") long __IC,
    @Cast("vDSP_Length") long __N);
    /*  Maps:  The default maps are used.
        
        These compute:

            C[0] = 0;
            for (n = 1; n < N; ++n)
                C[n] = C[n-1] + B[0] * (A[n-1] + A[n])/2;
    */


// Wiener Levinson.
public static native void vDSP_wiener(
    @Cast("vDSP_Length") long __L,
    @Const FloatPointer __A,
    @Const FloatPointer __C,
    FloatPointer __F,
    FloatPointer __P,
    int __Flag,
    IntPointer __Error);
public static native void vDSP_wiener(
    @Cast("vDSP_Length") long __L,
    @Const FloatBuffer __A,
    @Const FloatBuffer __C,
    FloatBuffer __F,
    FloatBuffer __P,
    int __Flag,
    IntBuffer __Error);
public static native void vDSP_wiener(
    @Cast("vDSP_Length") long __L,
    @Const float[] __A,
    @Const float[] __C,
    float[] __F,
    float[] __P,
    int __Flag,
    int[] __Error);
public static native void vDSP_wienerD(
    @Cast("vDSP_Length") long __L,
    @Const DoublePointer __A,
    @Const DoublePointer __C,
    DoublePointer __F,
    DoublePointer __P,
    int __Flag,
    IntPointer __Error);
public static native void vDSP_wienerD(
    @Cast("vDSP_Length") long __L,
    @Const DoubleBuffer __A,
    @Const DoubleBuffer __C,
    DoubleBuffer __F,
    DoubleBuffer __P,
    int __Flag,
    IntBuffer __Error);
public static native void vDSP_wienerD(
    @Cast("vDSP_Length") long __L,
    @Const double[] __A,
    @Const double[] __C,
    double[] __F,
    double[] __P,
    int __Flag,
    int[] __Error);


/*  vDSP_FFT16_copv and vDSP_FFT32_copv perform 16- and 32-element FFTs on
    interleaved complex unit-stride vector-block-aligned data.

    Parameters:

        float *Output

            Pointer to space for output data (interleaved complex).  This
            address must be vector-block aligned.

        const float *Input

            Pointer to input data (interleaved complex).  This address must be
            vector-block aligned.

        FFT_Direction Direction

            Transform direction, FFT_FORWARD or FFT_INVERSE.

    These routines calculate:

        For 0 <= k < N,

            H[k] = sum(1**(S * j*k/N) * h[j], 0 <= j < N),

    where:

        N is 16 or 32, as specified by the routine name,

        h[j] is Input[2*j+0] + i * Input[2*j+1] at routine entry,

        H[j] is Output[2*j+0] + i * Output[2*j+1] at routine exit,

        S is -1 if Direction is FFT_FORWARD and +1 if Direction is FFT_INVERSE,
        and

        1**x is e**(2*pi*i*x).

    Input and Output may be equal but may not otherwise overlap.
*/
public static native void vDSP_FFT16_copv(FloatPointer __Output, @Const FloatPointer __Input,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT16_copv(FloatBuffer __Output, @Const FloatBuffer __Input,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT16_copv(float[] __Output, @Const float[] __Input,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT32_copv(FloatPointer __Output, @Const FloatPointer __Input,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT32_copv(FloatBuffer __Output, @Const FloatBuffer __Input,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT32_copv(float[] __Output, @Const float[] __Input,
    @Cast("FFTDirection") int __Direction);


/*  vDSP_FFT16_zopv and vDSP_FFT32_zopv perform 16- and 32-element FFTs on
    separated complex unit-stride vector-block-aligned data.

    Parameters:

        float *Or, float *Oi

            Pointers to space for real and imaginary output data.  These
            addresses must be vector-block aligned.

        const float *Ir, *Ii

            Pointers to real and imaginary input data.  These addresses must be
            vector-block aligned.

        FFT_Direction Direction

            Transform direction, FFT_FORWARD or FFT_INVERSE.

    These routines calculate:

        For 0 <= k < N,

            H[k] = sum(1**(S * j*k/N) * h[j], 0 <= j < N),

    where:

        N is 16 or 32, as specified by the routine name,

        h[j] is Ir[j] + i * Ii[j] at routine entry,

        H[j] is Or[j] + i * Oi[j] at routine exit,

        S is -1 if Direction is FFT_FORWARD and +1 if Direction is FFT_INVERSE,
        and

        1**x is e**(2*pi*i*x).

    Or may equal Ir or Ii, and Oi may equal Ii or Ir, but the ararys may not
    otherwise overlap.
*/
public static native void vDSP_FFT16_zopv(
          FloatPointer __Or,       FloatPointer __Oi,
    @Const FloatPointer __Ir, @Const FloatPointer __Ii,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT16_zopv(
          FloatBuffer __Or,       FloatBuffer __Oi,
    @Const FloatBuffer __Ir, @Const FloatBuffer __Ii,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT16_zopv(
          float[] __Or,       float[] __Oi,
    @Const float[] __Ir, @Const float[] __Ii,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT32_zopv(
          FloatPointer __Or,       FloatPointer __Oi,
    @Const FloatPointer __Ir, @Const FloatPointer __Ii,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT32_zopv(
          FloatBuffer __Or,       FloatBuffer __Oi,
    @Const FloatBuffer __Ir, @Const FloatBuffer __Ii,
    @Cast("FFTDirection") int __Direction);
public static native void vDSP_FFT32_zopv(
          float[] __Or,       float[] __Oi,
    @Const float[] __Ir, @Const float[] __Ii,
    @Cast("FFTDirection") int __Direction);


/*  How to use the Discrete Fourier Transform (DFT) and Discrete Cosine
    Transform (DCT) interfaces.

    There are three steps to performing a DFT or DCT:

        Call a setup routine (e.g., vDSP_DFT_zop_CreateSetup) to get a setup
        object.

            This is a preparation step to be done when a program is starting or
            is starting some new phase (e.g., when a communication channel is
            opened).  It should never be done during real-time processing.  The
            setup routine is slow and is called only once to prepare data that
            can be used many times.

        Call an execution routine (e.g., vDSP_DFT_Execute or vDSP_DCT_Execute)
        to perform a DFT or DCT, and pass it the setup object.

            The execution routine is fast (for selected cases) and is generally
            called many times.

        Call a destroy routine (e.g., vDSP_DFT_DestroySetup) to release the
        memory held by the setup object.

            This is done when a program is ending or is ending some phase.
            After calling a destroy routine, the setup data is no longer valid
            and should not be used.

    Discussion:

        The current sequences of setup, execution, destroy routines are:

            For single-precision (float):

                vDSP_DFT_zop_CreateSetup,
                vDSP_DFT_Execute,
                vDSP_DFT_DestroySetup.

                vDSP_DFT_zrop_CreateSetup,
                vDSP_DFT_Execute,
                vDSP_DFT_DestroySetup.

                vDSP_DCT_CreateSetup,
                vDSP_DCT_Execute,
                vDSP_DFT_DestroySetup.

                vDSP_DFT_CreateSetup,
                vDSP_DFT_zop,
                vDSP_DFT_DestroySetup.

            For double-precision (double):

                vDSP_DFT_zop_CreateSetupD,
                vDSP_DFT_ExecuteD,
                vDSP_DFT_DestroySetupD.

                vDSP_DFT_zrop_CreateSetupD,
                vDSP_DFT_ExecuteD,
                vDSP_DFT_DestroySetupD.

        Sharing DFT and DCT setups:

            Any setup returned by a DFT or DCT setup routine may be passed as
            input to any DFT or DCT setup routine for the same precision (float
            or double), in the parameter named Previous.  (This allows the
            setups to share data, avoiding unnecessary duplication of some
            setup data.)  Setup routines may be executed in any order.  Passing
            any setup of a group of setups sharing data will result in a new
            setup sharing data with all of the group.

            When calling an execution routine, each setup can be used only with
            its intended execution routine.  Thus the setup returned by
            vDSP_DFT_CreateSetup can only be used with vDSP_DFT_zop and not
            with vDSP_DFT_Execute.

            vDSP_DFT_DestroySetup is used to destroy any single-precision DFT
            or DCT setup.  vDSP_DFT_DestroySetupD is used to destroy any
            double-precision DFT or DCT setup.

        History:

            vDSP_DFT_CreateSetup and vDSP_DFT_zop are the original vDSP DFT
            routines.  vDSP_DFT_zop_CreateSetup, vDSP_DFT_zrop_CreateSetup, and
            vDSP_DFT_Execute are newer, more specialized DFT routines.  These
            newer routines do not have stride parameters (stride is one) and
            incorporate the direction parameter into the setup.  This reduces
            the number of arguments passed to the execution routine, which
            receives only the setup and four address parameters.  Additionally,
            the complex-to-complex DFT (zop) and real-to-complex DFT (zrop) use
            the same execution routine (the setup indicates which function to
            perform).

            We recommend you use vDSP_DFT_zop_CreateSetup,
            vDPS_DFT_zrop_CreateSetup, and vDSP_DFT_Execute, and that you not
            use vDSP_DFT_CreateSetup and vDSP_DFT_zop.

    Multithreading:

        The Accelerate FFT and DFT setup structures can optionally share
        underlying memory through the Previous parameter in the appropriate
        create setup function. To avoid undefined behaviour, don’t call a setup
        or destroy function on a setup structure while another setup structure
        that shares its memory is executing.

        The FFT and DFT setup structures only require read-only access to the
        underlying memory, therefore you can safely run multiple execution
        routines concurrently on structures that share memory.

        If you need to call setup and/or destroy routines while other DFT or
        DCT routines might be executing, you can either use Grand Central
        Dispatch or locks (costs time) to avoid simultaneous execution or you
        can create separate setup objects for them (costs memory).
*/


/*  A vDSP_DFT_Setup object is a pointer to a structure whose definition is
    unpubilshed.
*/
@Opaque public static class vDSP_DFT_SetupStruct extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vDSP_DFT_SetupStruct() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_DFT_SetupStruct(Pointer p) { super(p); }
}
@Opaque public static class vDSP_DFT_SetupStructD extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vDSP_DFT_SetupStructD() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_DFT_SetupStructD(Pointer p) { super(p); }
}

// DFT direction may be specified as vDSP_DFT_FORWARD or vDSP_DFT_INVERSE. /** enum  */
 public static final int vDSP_DFT_FORWARD = 1, vDSP_DFT_INVERSE = -1;

@Opaque public static class vDSP_DFT_Interleaved_SetupStruct extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vDSP_DFT_Interleaved_SetupStruct() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_DFT_Interleaved_SetupStruct(Pointer p) { super(p); }
}
@Opaque public static class vDSP_DFT_Interleaved_SetupStructD extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public vDSP_DFT_Interleaved_SetupStructD() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public vDSP_DFT_Interleaved_SetupStructD(Pointer p) { super(p); }
}

// Interleaved DFT used as vDSP_DFT_Interleaved_ComplextoComplex or vDSP_DFT_Interleaved_Real2Complex. /** enum  */
 ;


/*  vDSP_DFT_CreateSetup is a DFT setup routine.  It creates a setup object
    for use with the vDSP_DFT_zop execution routine.  We recommend you use
    vDSP_DFT_zop_CreateSetup instead of this routine.

    Parameters:

        vDSP_DFT_Setup Previous

            Previous is either zero or a previous DFT or DCT setup.  If a
            previous setup is passed, the new setup will share data with the
            previous setup, if feasible (and with any other setups the previous
            setup shares with).  If zero is passed, the routine will allocate
            and initialize new memory.

        vDSP_Length Length

            Length is the number of complex elements to be transformed.

    Return value:

        Zero is returned if memory is unavailable.

    The returned setup object may be used only with vDSP_DFT_zop for the length
    given during setup.  Unlike previous vDSP FFT routines, the setup may not
    be used to execute transforms with shorter lengths.

    Do not call this routine while any DFT routine sharing setup data might be
    executing.
*/
public static native vDSP_DFT_SetupStruct vDSP_DFT_CreateSetup(
    vDSP_DFT_SetupStruct __Previous,
    @Cast("vDSP_Length") long __Length);


/*  vDSP_DFT_zop_CreateSetup is a DFT setup routine.  It creates a setup object
    for use with the vDSP_DFT_Execute execution routine, to perform a
    complex-to-complex DFT.

    Parameters:

        vDSP_DFT_Setup Previous

            Previous is either zero or a previous DFT or DCT setup.  If a
            previous setup is passed, the new setup will share data with the
            previous setup, if feasible (and with any other setups the previous
            setup shares with).  If zero is passed, the routine will allocate
            and initialize new memory.

        vDSP_Length Length

            Length is the number of complex elements to be transformed.

        vDSP_DFT_Direction Direction

            Transform direction, vDSP_DFT_FORWARD or vDSP_DFT_INVERSE.

    Return value:

        Zero is returned if memory is unavailable or if there is no
        implementation for the requested case.  Currently, the implemented
        cases are:

            Length = 2**n.

            Length = f * 2**n, where f is 3, 5, or 15 and 3 <= n.

        Additionally, it is recommended that the array addresses (passed to
        vDSP_DFT_Execute) be 16-byte aligned.  For other cases, performance may
        be slightly or greatly worse, depending on transform length and
        processor model.

    Function:

        When vDSP_DFT_Execute is called with a setup returned from this
        routine, it calculates:

            For 0 <= k < N,

                H[k] = sum(1**(S * j*k/N) * h[j], 0 <= j < N),

        where:

            N is the length given in the setup;

            h is the array of complex numbers specified by Ir and Ii when
            vDSP_DFT_Execute is called:

                for 0 <= j < N,
                    h[j] = Ir[j] + i * Ii[j];

            H is the array of complex numbers specified by Or and Oi when
            vDSP_DFT_Execute returns:

                for 0 <= k < N,
                    H[k] = Or[k] + i * Oi[k];

            S is -1 if Direction is vDSP_DFT_FORWARD and +1 if Direction is
            vDSP_DFT_INVERSE; and

            1**x is e**(2*pi*i*x).

    Performance:

        Performance is good when the array addresses (passed to
        vDSP_DFT_Execute) are 16-byte aligned.  Other alignments are supported,
        but performance may be significantly worse in some cases, depending on
        the processor model or the transform length (because different
        algorithms are used for different forms of transform length).

    In-Place Operation:

        Or may equal Ir and Oi may equal Ii (in the call to vDSP_DFT_Execute).
        Otherwise, no overlap of Or, Oi, Ir, and Ii is supported.

    The returned setup object may be used only with vDSP_DFT_Execute for the
    length given during setup.  Unlike previous vDSP FFT routines, the setup
    may not be used to execute transforms with shorter lengths.

    Do not call this routine while any DFT or DCT routine sharing setup data
    might be executing.
*/
public static native vDSP_DFT_SetupStruct vDSP_DFT_zop_CreateSetup(
    vDSP_DFT_SetupStruct __Previous,
    @Cast("vDSP_Length") long __Length,
    @Cast("vDSP_DFT_Direction") int __Direction);
public static native vDSP_DFT_SetupStructD vDSP_DFT_zop_CreateSetupD(
    vDSP_DFT_SetupStructD __Previous,
    @Cast("vDSP_Length") long __Length,
    @Cast("vDSP_DFT_Direction") int __Direction);

/*  vDSP_DFT_zrop_CreateSetup and vDSP_DFT_zrop_CreateSetupD are DFT setup
    routines.  Each creates a setup object for use with the corresponding
    execution routine, vDSP_DFT_Execute or vDSP_DFT_ExecuteD, to perform a
    real-to-complex DFT or a complex-to-real DFT.  Documentation below is
    written for vDSP_DFT_zrop_CreateSetup.  vDSP_DFT_CreateSetupD behaves the
    same way, with corresponding changes of the types, objects, and routines to
    the double-precision versions.

    Parameters:

        vDSP_DFT_Setup Previous

            Previous is either zero or a previous DFT or DCT setup.  If a
            previous setup is passed, the new setup will share data with the
            previous setup, if feasible (and with any other setups the previous
            setup shares with).  If zero is passed, the routine will allocate
            and initialize new memory.

        vDSP_Length Length

            Length is the number of real elements to be transformed (in a a
            forward, real-to-complex transform) or produced (in a reverse,
            complex-to-real transform).  Length must be even.

        vDSP_DFT_Direction Direction

            Transform direction, vDSP_DFT_FORWARD or vDSP_DFT_INVERSE.

    Return value:

        Zero is returned if memory is unavailable or if there is no
        implementation for the requested case.  Currently, the implemented
        cases are:

            Length = 2**n.

            Length = f * 2**n, where f is 3, 5, or 15 and 4 <= n.

        Additionally, it is recommended that the array addresses (passed to
        vDSP_DFT_Execute) be 16-byte aligned.  For other cases, performance may
        be slightly or greatly worse, depending on transform length and
        processor model.

    Function:

        When vDSP_DFT_Execute is called with a setup returned from this
        routine, it calculates:

            For 0 <= k < N,

                H[k] = C * sum(1**(S * j*k/N) * h[j], 0 <= j < N),

        where:

            N is the Length given in the setup;

            h is the array of numbers specified by Ir and Ii when
            vDSP_DFT_Execute is called (see "Data Layout" below);

            H is the array of numbers specified by Or and Oi when
            vDSP_DFT_Execute returns (see "Data Layout" below);

            C is 2 if Direction is vDSP_DFT_FORWARD and 1 if Direction is
            vDSP_DFT_INVERSE;

            S is -1 if Direction is vDSP_DFT_FORWARD and +1 if Direction is
            vDSP_DFT_INVERSE; and

            1**x is e**(2*pi*i*x).

        Data Layout:

            If Direction is vDSP_DFT_FORWARD, then:

                h is an array of real numbers, with its even-index elements
                stored in Ir and its odd-index elements stored in Ii:

                    For 0 <= j < N/2,
                        h[2*j+0] = Ir[j], and
                        h[2*j+1] = Ii[j].

                H is an array of complex numbers, stored in Or and Oi:

                    H[0  ] = Or[0].  (H[0  ] is pure real.)
                    H[N/2] = Oi[0].  (H[N/2] is pure real.)
                    For 1 < k < N/2,
                        H[k] = Or[k] + i * Oi[k].

                For N/2 < k < N, H[k] is not explicitly stored in memory but is
                known because it necessarily equals the conjugate of H[N-k],
                which is stored as described above.

            If Direction is vDSP_DFT_INVERSE, then the layouts of the input and
            output arrays are swapped.  Ir and Ii describe an input array with
            complex elements laid out as described above for Or and Oi.  When
            vDSP_DFT_Execute returns, Or and Oi contain a pure real array, with
            its even-index elements stored in Or and its odd-index elements in
            Oi.

    Performance:

        Performance is good when the array addresses (passed to
        vDSP_DFT_Execute) are 16-byte aligned.  Other alignments are supported,
        but performance may be significantly worse in some cases, depending on
        the processor model or the transform length (because different
        algorithms are used for different forms of transform length).

    In-Place Operation:

        Or may equal Ir and Oi may equal Ii (in the call to vDSP_DFT_Execute).
        Otherwise, no overlap of Or, Oi, Ir, and Ii is supported.

    The returned setup object may be used only with vDSP_DFT_Execute for the
    length given during setup.  Unlike previous vDSP FFT routines, the setup
    may not be used to execute transforms with shorter lengths.

    Do not call this routine while any DFT routine sharing setup data might be
    executing.
*/
public static native vDSP_DFT_SetupStruct vDSP_DFT_zrop_CreateSetup(
    vDSP_DFT_SetupStruct __Previous,
    @Cast("vDSP_Length") long __Length, @Cast("vDSP_DFT_Direction") int __Direction);
public static native vDSP_DFT_SetupStructD vDSP_DFT_zrop_CreateSetupD(
    vDSP_DFT_SetupStructD __Previous,
    @Cast("vDSP_Length") long __Length, @Cast("vDSP_DFT_Direction") int __Direction);


/*  vDSP_DFT_DestroySetup and vDSP_DFT_DestroySetupD are DFT destroy routines.
    They release the memory used by a setup object.  Documentation below is
    written for vDSP_DFT_DestroySetup.  vDSP_DFT_DestroySetupD behaves the same
    way, with corresponding changes of the types, objects, and routines to the
    double-precision versions.

    Parameters:

        vDSP_DFT_Setup Setup

            Setup is the setup object to be released.  The object may have
            been previously allocated with any DFT or DCT setup routine, such
            as vDSP_DFT_zop_CreateSetup, vDSP_DFT_zrop_CreateSetup, or
            vDSP_DCT_CreateSetup.

            Setup may be a null pointer, in which case the call has no effect.

    Destroying a setup with shared data is safe; it will release only memory
    not needed by other undestroyed setups.  Memory (and the data it contains)
    is freed only when all setup objects using it have been destroyed.

    Do not call this routine while any DFT or DCT routine sharing setup data
    might be executing.
*/
public static native void vDSP_DFT_DestroySetup(vDSP_DFT_SetupStruct __Setup);
public static native void vDSP_DFT_DestroySetupD(vDSP_DFT_SetupStructD __Setup);


/*  vDSP_DFT_zop is a DFT execution routine.  It performs a DFT, with the aid
    of previously created setup data.

    Parameters:

        vDSP_DFT_Setup Setup

            A setup object returned by a previous call to
            vDSP_DFT_zop_CreateSetup.

        const float *Ir
        const float *Ii

            Pointers to real and imaginary components of input data.

        vDSP_Stride Is

            The number of physical elements from one logical input element to
            the next.

        float *Or
        float *Oi

            Pointers to space for real and imaginary components of output
            data.

            The input and output arrays may not overlap except as specified
            in "In-Place Operation", below.

        vDSP_Stride Os

            The number of physical elements from one logical output element to
            the next.

        vDSP_DFT_Direction Direction

            Transform direction, vDSP_DFT_FORWARD or vDSP_DFT_INVERSE.

    Observe there is no separate length parameter.  The length is passed via
    the setup object.

    Performance:

        Performance is good for these cases:

            All addresses are 16-byte aligned, all strides are one, and the
            length is f * 2**n, where f is 3, 5, or 15 and 3 <= n.

        Performance is extremely slow for all other cases.

    In-Place Operation:

        For cases where the length is f * 2**n, where f is 3, 5, or 15 and 3 <=
        n, Or may equal Ir and Oi may equal Ii.  Otherwise, no overlap of Or,
        Oi, Ir, and Ii is supported.

    This routine calculates:

        For 0 <= k < N,

            H[k] = sum(1**(S * j*k/N) * h[j], 0 <= j < N),

    where:

        N is the length given in the setup,

        h is the array of complex numbers specified by Ir, Ii, and Is at
        routine entry:

            h[j] = Ir[j*Is] + i * Ii[j*Is],
            for 0 <= j < N,

        H is the array of complex numbers stored as specified by Or, Oi, and Os
        at routine exit:

            H[k] = Or[k*Os] + i * Oi[k*Os],
            for 0 <= k < N,

        S is -1 if Direction is vDSP_DFT_FORWARD and +1 if Direction is
        vDSP_DFT_INVERSE, and

        1**x is e**(2*pi*i*x).

    Do not call this routine while any DFT setup or destroy routine sharing
    setup data might be executing.
*/
public static native void vDSP_DFT_zop(
    @Const vDSP_DFT_SetupStruct __Setup,
    @Const FloatPointer __Ir, @Const FloatPointer __Ii, @Cast("vDSP_Stride") long __Is,
          FloatPointer __Or,       FloatPointer __Oi, @Cast("vDSP_Stride") long __Os,
    @Cast("vDSP_DFT_Direction") int __Direction);
public static native void vDSP_DFT_zop(
    @Const vDSP_DFT_SetupStruct __Setup,
    @Const FloatBuffer __Ir, @Const FloatBuffer __Ii, @Cast("vDSP_Stride") long __Is,
          FloatBuffer __Or,       FloatBuffer __Oi, @Cast("vDSP_Stride") long __Os,
    @Cast("vDSP_DFT_Direction") int __Direction);
public static native void vDSP_DFT_zop(
    @Const vDSP_DFT_SetupStruct __Setup,
    @Const float[] __Ir, @Const float[] __Ii, @Cast("vDSP_Stride") long __Is,
          float[] __Or,       float[] __Oi, @Cast("vDSP_Stride") long __Os,
    @Cast("vDSP_DFT_Direction") int __Direction);


/*  vDSP_DFT_Execute and vDSP_DFT_ExecuteD are DFT execution routines.  They
    perform a DFT, with the aid of previously created setup data.
    Documentation below is written for vDSP_DFT_Execute.  vDSP_DFT_ExecuteD
    behaves the same way, with corresponding changes of the types, objects, and
    routines to the double-precision versions.

    Parameters:

        vDSP_DFT_Setup Setup

            A setup object returned by a previous call to
            vDSP_DFT_zop_CreateSetup or vDSP_DFT_zrop_CreateSetup.

        const float *Ir
        const float *Ii

            Pointers to input data.

        float *Or
        float *Oi

            Pointers to output data.

            The input and output arrays may not overlap except as specified
            in "In-Place Operation", below.

    Performance and In-Place Operation:

        See notes for the setup routine for the operation being executed.

    Function:

        The function performed by this routine is determined by the setup
        passed to it.  The documentation for the routine used to create the
        setup describes the function.

        Note that different numbers of elements are required when this routine
        is called, depending on the setup used:

            When the setup is from vDSP_zop_CreateSetup, each array (Ir, Ii,
            Or, and Oi) must have Length elements.

            When the setup is from vDSP_zrop_CreateSetup, each array (Ir, Ii,
            Or, and Oi) must have Length/2 elements.

    Do not call this routine while any DFT setup or destroy routine sharing
    setup data might be executing.
*/
public static native void vDSP_DFT_Execute(
    @Const vDSP_DFT_SetupStruct __Setup,
    @Const FloatPointer __Ir,  @Const FloatPointer __Ii,
          FloatPointer __Or,        FloatPointer __Oi);
public static native void vDSP_DFT_Execute(
    @Const vDSP_DFT_SetupStruct __Setup,
    @Const FloatBuffer __Ir,  @Const FloatBuffer __Ii,
          FloatBuffer __Or,        FloatBuffer __Oi);
public static native void vDSP_DFT_Execute(
    @Const vDSP_DFT_SetupStruct __Setup,
    @Const float[] __Ir,  @Const float[] __Ii,
          float[] __Or,        float[] __Oi);
public static native void vDSP_DFT_ExecuteD(
    @Const vDSP_DFT_SetupStructD __Setup,
    @Const DoublePointer __Ir,  @Const DoublePointer __Ii,
          DoublePointer __Or,        DoublePointer __Oi);
public static native void vDSP_DFT_ExecuteD(
    @Const vDSP_DFT_SetupStructD __Setup,
    @Const DoubleBuffer __Ir,  @Const DoubleBuffer __Ii,
          DoubleBuffer __Or,        DoubleBuffer __Oi);
public static native void vDSP_DFT_ExecuteD(
    @Const vDSP_DFT_SetupStructD __Setup,
    @Const double[] __Ir,  @Const double[] __Ii,
          double[] __Or,        double[] __Oi);


/*  vDSP_DCT_CreateSetup is a DCT setup routine.  It creates a setup object
    for use with the vDSP_DCT_Execute routine.  See additional information
    above, at "How to use the Discrete Fourier Transform (DFT) and Discrete
    Cosine Transform (DCT) interfaces."

    Parameters:

        vDSP_DFT_Setup Previous

            Previous is either zero or a previous DFT or DCT setup.  If a
            previous setup is passed, the new setup will share data with the
            previous setup, if feasible (and with any other setups the
            previous setup shares with).  If zero is passed, the routine
            will allocate and initialize new memory.

        vDSP_Length Length

            Length is the number of real elements to be transformed.

        vDSP_DCT_Type Type

            Type specifies which DCT variant to perform.  At present, the
            supported DCT types are II and III (which are mutual inverses, up
            to scaling) and IV (which is its own inverse).  These are specified
            with symbol names vDSP_DCT_II, vDSP_DCT_III, and vDSP_DCT_IV.

    Return value:

        Zero is returned if memory is unavailable or if there is no
        implementation for the requested case.  Currently, the implemented
        cases are:

            Length = f * 2**n, where f is 1, 3, 5, or 15 and 4 <= n.

    Function:

        When vDSP_DCT_Execute is called with a setup returned from this
        routine, it calculates:

            If Type is vDSP_DCT_II:

                For 0 <= k < N,

                    Or[k] = sum(Ir[j] * cos(k * (j+1/2) * pi / N, 0 <= j < N).

            If Type is vDSP_DCT_III

                For 0 <= k < N,

                    Or[k] = Ir[0]/2
                        + sum(Ir[j] * cos((k+1/2) * j * pi / N), 1 <= j < N).

            If Type is vDSP_DCT_IV:

                For 0 <= k < N,

                    Or[k] = sum(Ir[j] * cos((k+1/2) * (j+1/2) * pi / N, 0 <= j < N).

            Where:

                N is the length given in the setup,

                h is the array of real numbers passed to vDSP_DCT_Execute in
                Input, and

                H is the array of real numbers stored by vDSP_DCT_Execute in
                the array passed to it in Output.

     Performance:

        Performance is good when the array addresses (passed to
        vDSP_DFT_Execute) are 16-byte aligned.  Other alignments are supported,
        but performance may be significantly worse in some cases, depending on
        the processor model or the transform length (because different
        algorithms are used for different forms of transform length).

    In-Place Operation:

        Output may equal Input (in the call the vDSP_DCT_Execute).  Otherwise,
        no overlap is permitted between the two buffers.

    The returned setup object may be used only with vDSP_DCT_Execute for the
    length given during setup.

    Do not call this routine while any DFT or DCT routine sharing setup data
    might be executing.
*/ /** enum  */
 public static final int
    vDSP_DCT_II  = 2,
    vDSP_DCT_III = 3,
    vDSP_DCT_IV  = 4;

public static native vDSP_DFT_SetupStruct vDSP_DCT_CreateSetup(
    vDSP_DFT_SetupStruct __Previous,
    @Cast("vDSP_Length") long __Length,
    @Cast("vDSP_DCT_Type") int __Type);


/*  vDSP_DCT_Execute is a DCT execution routine.  It performs a DCT, with the
    aid of previously created setup data.  See additional information above, at
    "How to use the Discrete Fourier Transform (DFT) and Discrete Cosine
    Transform (DCT) interfaces."

    Parameters:

        vDSP_DFT_Setup Setup

            A setup object returned by a previous call to vDSP_DCT_CreateSetup.

        const float *Input

            Pointer to the input buffer.

        float *Output

            Pointer to the output buffer.

        Observe there are no separate length or type parameters.  They are
        specified at the time that the Setup is created.

        Because the DCT is real-to-real, the parameters for vDSP_DCT_Execute
        are different from those used for a DFT.
*/
public static native void vDSP_DCT_Execute(
    @Const vDSP_DFT_SetupStruct __Setup,
    @Const FloatPointer __Input,
    FloatPointer __Output);
public static native void vDSP_DCT_Execute(
    @Const vDSP_DFT_SetupStruct __Setup,
    @Const FloatBuffer __Input,
    FloatBuffer __Output);
public static native void vDSP_DCT_Execute(
    @Const vDSP_DFT_SetupStruct __Setup,
    @Const float[] __Input,
    float[] __Output);


/*  vDSP_DFT_Interleaved_CreateSetup is a DFT setup routine.  It creates a setup object
    for use with the vDSP_DFT_Interleaved_Execute execution routine, to perform
    a complex-to-complex DFT for interleaved data format.

    Parameters:

        vDSP_DFT_Interleaved_Setup Previous

            Previous is either zero or a previous DFT or DCT setup.  If a
            previous setup is passed, the new setup will share data with the
            previous setup, if feasible (and with any other setups the previous
            setup shares with).  If zero is passed, the routine will allocate
            and initialize new memory.

        vDSP_Length Length

            Length is the number of complex elements to be transformed.

        vDSP_DFT_Direction Direction

            Transform direction, vDSP_DFT_FORWARD or vDSP_DFT_INVERSE.

        vDSP_DFT_RealtoComplex RealtoComplex specifies transform used as vDSP_DFT_Interleaved_ComplextoComplex or vDSP_DFT_Interleaved_RealtoComplex.

            bool flag indicates whether the Setup is used for ComplextoComplex or RealtoComplex transform

    Note:

        For real-to-complex DFT, Length should be half of the length of the real signal.

    Return value:

        Zero is returned if memory is unavailable or if there is no
        implementation for the requested case.  Currently, the implemented
        cases are:

            Length = f * 2**n, where f is 2, 3, 5, 3*3, 3*5, or 5*5 and n >= 2.

        Additionally, it is recommended that the array addresses (passed to
        vDSP_DFT_Interleaved_Execute) be 16-byte aligned.  For other cases, performance may
        be slightly or greatly worse, depending on transform length and
        processor model.

    Function:

        When vDSP_DFT_Interleaved_Execute is called with a setup returned from this
        routine, it calculates:

            For 0 <= k < N,

                H[k] = sum(1**(S * j*k/N) * h[j], 0 <= j < N),

        where:

            N is the length given in the setup;

            h is the array of complex numbers specified by a complex array Iri when
            vDSP_DFT_Interleaved_Execute is called:

                for 0 <= j < N,
                    h[j] = Iri[2*j] + i * Iri[2*j+1];

            H is the array of complex numbers specified by a complex array Ori when
            vDSP_DFT_Interleaved_Execute returns:

                for 0 <= k < N,
                    H[k] = Ori[2*k] + i * Ori[2*k+1];

            S is -1 if Direction is vDSP_DFT_FORWARD and +1 if Direction is
            vDSP_DFT_INVERSE; and

            1**x is e**(2*pi*i*x).

    Performance:

        Performance is good when the array addresses (passed to
        vDSP_DFT_Interleaved_Execute) are 16-byte aligned.  Other alignments are supported,
        but performance may be significantly worse in some cases, depending on
        the processor model or the transform length (because different
        algorithms are used for different forms of transform length).

    In-Place Operation:

        Ori may equal Iri (in the call to vDSP_DFT_Interleaved_Execute).
        Otherwise, no overlap of Ori and Iri is supported.

    The returned setup object may be used only with vDSP_DFT_Interleaved_Execute for the
    length given during setup.  Unlike previous vDSP FFT routines, the setup
    may not be used to execute transforms with shorter lengths.

    Do not call this routine while any DFT or DCT routine sharing setup data
    might be executing.
*/

/** \abstract DFT setup routine for interleaved complex data, single-precision
 *
 *  \discussion
 *  This routine creates the required butterfly weight factors needed in the computation
 *  of the interleaved complex number DFT of a specified length. It returns with the pointer 
 *  to the DFT setup, if the length is supported, or NULL otherwise.
 *
 *  @param Previous (input) Previous is either zero or a previous DFT_Interleaved setup
 *
 *  @param Length (input) the number of complex elements to be transformed.
 *
 *  @param Direction (input) Transform direction, vDSP_DFT_FORWARD or vDSP_DFT_INVERSE.
 *
 *  @param RealtoComplex (input) flag for real to complex transform, true or false.
 *
 *  @return a pointer to the requested DFT setup on success, or 0 if the Length is not supported,
 *          or having other issues, such as memory allocation.
 *
 */
public static native vDSP_DFT_Interleaved_SetupStruct vDSP_DFT_Interleaved_CreateSetup(
    vDSP_DFT_Interleaved_SetupStruct Previous,
    @Cast("vDSP_Length") long Length,
    @Cast("vDSP_DFT_Direction") int Direction,
    @Cast("vDSP_DFT_RealtoComplex") boolean RealtoComplex);

/** \abstract DFT setup routine for interleaved complex data, double-precision
 *
 *  \discussion
 *  This routine creates the required butterfly weight factors needed in the computation
 *  of the interleaved complex number DFT of a specified length. It returns with the pointer 
 *  to the DFT setup, if the length is supported, or NULL otherwise.
 *
 *  @param Previous (input) Previous is either zero or a previous DFT_Interleaved setup
 *
 *  @param Length (input) the number of complex elements to be transformed.
 *
 *  @param Direction (input) Transform direction, vDSP_DFT_FORWARD or vDSP_DFT_INVERSE.
 *
 *  @param RealtoComplex (input) flag for real to complex transform, true or false.
 *
 *  @return a pointer to the requested DFT setup on success, or 0 if the Length is not supported,
 *          or having other issues, such as memory allocation.
 *
 */
public static native vDSP_DFT_Interleaved_SetupStructD vDSP_DFT_Interleaved_CreateSetupD(
    vDSP_DFT_Interleaved_SetupStructD Previous,
    @Cast("vDSP_Length") long Length,
    @Cast("vDSP_DFT_Direction") int Direction,
    @Cast("vDSP_DFT_RealtoComplex") boolean RealtoComplex);

/*  vDSP_DFT_Execute_Interleaved and vDSP_DFT_Interleaved_ExecuteD are DFT execution routines (interleaved data format).
    They perform a DFT, with the aid of previously created setup data.
    Documentation below is written for vDSP_DFT_Interleaved_Execute.
    vDSP_DFT_Interleaved_ExecuteD behaves the same way, with corresponding changes of the types, objects, and
    routines to the double-precision versions.

    Parameters:

        vDSP_DFT_Interleaved_Setup Setup

            A setup object returned by a previous call to vDSP_DFT_Interleaved_CreateSetup

        const DSPComplex *Iri

            Pointer to input data.

        DSPComplex *Ori

            Pointer to output data.

            The input and output arrays may not overlap except as specified
            in "In-Place Operation", below.

    Performance and In-Place Operation:

        See notes for the setup routine for the operation being executed.

    Function:

        The function performed by this routine is determined by the setup
        passed to it.  The documentation for the routine used to create the
        setup describes the function.

        Note that different numbers of elements are required when this routine
        is called, depending on the setup used:

            When the setup is from vDSP_DFT_Interleaved_CreateSetup, each array (Iri and
            Ori) must have Length elements.

    Do not call this routine while any DFT setup or destroy routine sharing
    setup data might be executing.
*/

/** \abstract DFT execution routine for real data, single-precision
 *
 *  \discussion
 *  This routine perform a DFT for real numbers, with the aid of previously created setup data.
 *
 *  @param Setup (input) A setup object returned by a previous call to vDSP_DFT_Interleaved_CreateSetup
 *
 *  @param Iri (input) Pointer to input data.
 *
 *  @param Ori (input) Pointer to output data.
 *
 */
public static native void vDSP_DFT_Interleaved_Execute(
    vDSP_DFT_Interleaved_SetupStruct Setup,
    @Const DSPComplex Iri,
          DSPComplex Ori);

/** \abstract DFT execution routine for interleaved complex data, double-precision
 *
 *  \discussion
 *  This routine perform a DFT for interleaved complex numbers, with the aid of previously created setup data.
 *
 *  @param Setup (input) A setup object returned by a previous call to vDSP_DFT_Interleaved_CreateSetupD
 *
 *  @param Iri (input) Pointer to input data.
 *
 *  @param Ori (input) Pointer to output data.
 *
 */
public static native void vDSP_DFT_Interleaved_ExecuteD(
    vDSP_DFT_Interleaved_SetupStructD Setup,
    @Const DSPDoubleComplex Iri,
          DSPDoubleComplex Ori);

/** \abstract DFT destroy routine, single-precision
 *
 *  \discussion
 *  This routine releases the memory used by a setup object.
 *
 *  @param Setup (input) A setup object vDSP_DFT_Interleaved_Setup,
 *    created by either vDSP_DFT_Interleaved_CreateSetup
 *
 */
public static native void vDSP_DFT_Interleaved_DestroySetup(vDSP_DFT_Interleaved_SetupStruct Setup);

/** \abstract DFT destroy routine, double-precision
 *
 *  \discussion
 *  This routine releases the memory used by a setup object.
 *
 *  @param Setup (input) A setup object vDSP_DFT_Interleaved_SetupD,
 *    created by either vDSP_DFT_Interleaved_CreateSetupD
 *
 */
public static native void vDSP_DFT_Interleaved_DestroySetupD(vDSP_DFT_Interleaved_SetupStructD Setup);


/*  vDSP_dotpr2, vector single-precision stereo dot product.

    Function:

        This routine calculates the dot product of A0 with B and the dot
        product of A1 with B.  This is functionally equivalent to calculating
        two dot products but might execute faster.

        In pseudocode, the operation is:

            sum0 = 0;
            sum1 = 0;
            for (i = 0; i < Length; ++i)
            {
                sum0 += A0[i*A0Stride] * B[i*BStride];
                sum1 += A1[i*A1Stride] * B[i*BStride];
            }
            *C0 = sum0;
            *C1 = sum1;

    Input:

        const float *A0, vDSP_Stride A0Stride.

            Starting address and stride for input vector A0.

        const float *A1, vDSP_Stride A1Stride.

            Starting address and stride for input vector A1.

        const float *B,  vDSP_Stride BStride.

            Starting address and stride for input vector B.

        float *C0.

            Address for dot product of A0 and B.

        float *C1.

            Address for dot product of A1 and B.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to *C0 and *C1.
*/
public static native void vDSP_dotpr2(
    @Const FloatPointer __A0, @Cast("vDSP_Stride") long __IA0,
    @Const FloatPointer __A1, @Cast("vDSP_Stride") long __IA1,
    @Const FloatPointer __B,  @Cast("vDSP_Stride") long __IB,
    FloatPointer __C0,
    FloatPointer __C1,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr2(
    @Const FloatBuffer __A0, @Cast("vDSP_Stride") long __IA0,
    @Const FloatBuffer __A1, @Cast("vDSP_Stride") long __IA1,
    @Const FloatBuffer __B,  @Cast("vDSP_Stride") long __IB,
    FloatBuffer __C0,
    FloatBuffer __C1,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr2(
    @Const float[] __A0, @Cast("vDSP_Stride") long __IA0,
    @Const float[] __A1, @Cast("vDSP_Stride") long __IA1,
    @Const float[] __B,  @Cast("vDSP_Stride") long __IB,
    float[] __C0,
    float[] __C1,
    @Cast("vDSP_Length") long __N);


/*  vDSP_dotpr2D, vector double-precision stereo dot product.

    Function:

        This routine calculates the dot product of A0 with B and the dot
        product of A1 with B.  This is functionally equivalent to calculating
        two dot products but might execute faster.

        In pseudocode, the operation is:

            sum0 = 0;
            sum1 = 0;
            for (i = 0; i < Length; ++i)
            {
                sum0 += A0[i*A0Stride] * B[i*BStride];
                sum1 += A1[i*A1Stride] * B[i*BStride];
            }
            *C0 = sum0;
            *C1 = sum1;

    Input:

        const double *A0, vDSP_Stride A0Stride.

            Starting address and stride for input vector A0.

        const double *A1, vDSP_Stride A1Stride.

            Starting address and stride for input vector A1.

        const double *B,  vDSP_Stride BStride.

            Starting address and stride for input vector B.

        double *C0.

            Address for dot product of A0 and B.

        double *C1.

            Address for dot product of A1 and B.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to *C0 and *C1.
*/
public static native void vDSP_dotpr2D(
    @Const DoublePointer __A0, @Cast("vDSP_Stride") long __IA0,
    @Const DoublePointer __A1, @Cast("vDSP_Stride") long __IA1,
    @Const DoublePointer __B,  @Cast("vDSP_Stride") long __IB,
    DoublePointer __C0,
    DoublePointer __C1,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr2D(
    @Const DoubleBuffer __A0, @Cast("vDSP_Stride") long __IA0,
    @Const DoubleBuffer __A1, @Cast("vDSP_Stride") long __IA1,
    @Const DoubleBuffer __B,  @Cast("vDSP_Stride") long __IB,
    DoubleBuffer __C0,
    DoubleBuffer __C1,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr2D(
    @Const double[] __A0, @Cast("vDSP_Stride") long __IA0,
    @Const double[] __A1, @Cast("vDSP_Stride") long __IA1,
    @Const double[] __B,  @Cast("vDSP_Stride") long __IB,
    double[] __C0,
    double[] __C1,
    @Cast("vDSP_Length") long __N);


/*  vDSP_dotpr_s1_15, vector integer 1.15 format dot product.

    Function:

        This routine calculates the dot product of A with B.

        In pseudocode, the operation is:

            sum = 0;
            for (i = 0; i < N; ++i)
            {
                sum0 += A[i*AStride] * B[i*BStride];
            }
            *C = sum;

    The elements are fixed-point numbers, each with one sign bit and 15
    fraction bits.  Where the value of the short int is normally x, it is
    x/32768 for the purposes of this routine.

    Input:

        const short int *A, vDSP_Stride AStride.

            Starting address and stride for input vector A.

        const short int *B,  vDSP_Stride BStride.

            Starting address and stride for input vector B.

        short int *C.

            Address for dot product of A and B.

        vDSP_Length N.

            Number of elements in each vector.

    Output:

        The result is written to *C.
*/
public static native void vDSP_dotpr_s1_15(
    @Const ShortPointer __A, @Cast("vDSP_Stride") long __IA,
    @Const ShortPointer __B, @Cast("vDSP_Stride") long __IB,
    ShortPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr_s1_15(
    @Const ShortBuffer __A, @Cast("vDSP_Stride") long __IA,
    @Const ShortBuffer __B, @Cast("vDSP_Stride") long __IB,
    ShortBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr_s1_15(
    @Const short[] __A, @Cast("vDSP_Stride") long __IA,
    @Const short[] __B, @Cast("vDSP_Stride") long __IB,
    short[] __C,
    @Cast("vDSP_Length") long __N);


/*  vDSP_dotpr2_s1_15, vector integer 1.15 format stereo dot product.

    Function:

        This routine calculates the dot product of A0 with B and the dot
        product of A1 with B.  This is functionally equivalent to calculating
        two dot products but might execute faster.

        In pseudocode, the operation is:

            sum0 = 0;
            sum1 = 0;
            for (i = 0; i < N; ++i)
            {
                sum0 += A0[i*A0Stride] * B[i*BStride];
                sum1 += A1[i*A1Stride] * B[i*BStride];
            }
            *C0 = sum0;
            *C1 = sum1;

    The elements are fixed-point numbers, each with one sign bit and 15
    fraction bits.  Where the value of the short int is normally x, it is
    x/32768 for the purposes of this routine.

    Input:

        const short int *A0, vDSP_Stride A0Stride.

            Starting address and stride for input vector A0.

        const short int *A1, vDSP_Stride A1Stride.

            Starting address and stride for input vector A1.

        const short int *B,  vDSP_Stride BStride.

            Starting address and stride for input vector B.

        short int *C0.

            Address for dot product of A0 and B.

        short int *C1.

            Address for dot product of A1 and B.

        vDSP_Length N.

            Number of elements in each vector.

    Output:

        The results are written to *C0 and *C1.
*/
public static native void vDSP_dotpr2_s1_15(
    @Const ShortPointer __A0, @Cast("vDSP_Stride") long __IA0,
    @Const ShortPointer __A1, @Cast("vDSP_Stride") long __IA1,
    @Const ShortPointer __B,  @Cast("vDSP_Stride") long __IB,
    ShortPointer __C0,
    ShortPointer __C1,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr2_s1_15(
    @Const ShortBuffer __A0, @Cast("vDSP_Stride") long __IA0,
    @Const ShortBuffer __A1, @Cast("vDSP_Stride") long __IA1,
    @Const ShortBuffer __B,  @Cast("vDSP_Stride") long __IB,
    ShortBuffer __C0,
    ShortBuffer __C1,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr2_s1_15(
    @Const short[] __A0, @Cast("vDSP_Stride") long __IA0,
    @Const short[] __A1, @Cast("vDSP_Stride") long __IA1,
    @Const short[] __B,  @Cast("vDSP_Stride") long __IB,
    short[] __C0,
    short[] __C1,
    @Cast("vDSP_Length") long __N);


/*  vDSP_dotpr_s8_24, vector integer 8.24 format dot product.

    Function:

        This routine calculates the dot product of A with B.

        In pseudocode, the operation is:

            sum = 0;
            for (i = 0; i < N; ++i)
            {
                sum0 += A[i*AStride] * B[i*BStride];
            }
            *C = sum;

    The elements are fixed-point numbers, each with eight integer bits
    (including sign) and 24 fraction bits.  Where the value of the int is
    normally x, it is x/16777216 for the purposes of this routine.

    Input:

        const int *A, vDSP_Stride AStride.

            Starting address and stride for input vector A.

        const int *B,  vDSP_Stride BStride.

            Starting address and stride for input vector B.

        int *C.

            Address for dot product of A and B.

        vDSP_Length N.

            Number of elements in each vector.

    Output:

        The result is written to *C.
*/
public static native void vDSP_dotpr_s8_24(
    @Const IntPointer __A, @Cast("vDSP_Stride") long __IA,
    @Const IntPointer __B, @Cast("vDSP_Stride") long __IB,
    IntPointer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr_s8_24(
    @Const IntBuffer __A, @Cast("vDSP_Stride") long __IA,
    @Const IntBuffer __B, @Cast("vDSP_Stride") long __IB,
    IntBuffer __C,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr_s8_24(
    @Const int[] __A, @Cast("vDSP_Stride") long __IA,
    @Const int[] __B, @Cast("vDSP_Stride") long __IB,
    int[] __C,
    @Cast("vDSP_Length") long __N);


/*  vDSP_dotpr2_s8_24, vector integer 8.24 format stereo dot product.

    Function:

        This routine calculates the dot product of A0 with B and the dot
        product of A1 with B.  This is functionally equivalent to calculating
        two dot products but might execute faster.

        In pseudocode, the operation is:

            sum0 = 0;
            sum1 = 0;
            for (i = 0; i < N; ++i)
            {
                sum0 += A0[i*A0Stride] * B[i*BStride];
                sum1 += A1[i*A1Stride] * B[i*BStride];
            }
            *C0 = sum0;
            *C1 = sum1;

    The elements are fixed-point numbers, each with eight integer bits
    (including sign) and 24 fraction bits.  Where the value of the int is
    normally x, it is x/16777216 for the purposes of this routine.

    Input:

        const int *A0, vDSP_Stride A0Stride.

            Starting address and stride for input vector A0.

        const int *A1, vDSP_Stride A1Stride.

            Starting address and stride for input vector A1.

        const int *B,  vDSP_Stride BStride.

            Starting address and stride for input vector B.

        int *C0.

            Address for dot product of A0 and B.

        int *C1.

            Address for dot product of A1 and B.

        vDSP_Length N.

            Number of elements in each vector.

    Output:

        The results are written to *C0 and *C1.
*/
public static native void vDSP_dotpr2_s8_24(
    @Const IntPointer __A0, @Cast("vDSP_Stride") long __IA0,
    @Const IntPointer __A1, @Cast("vDSP_Stride") long __IA1,
    @Const IntPointer __B,  @Cast("vDSP_Stride") long __IB,
    IntPointer __C0,
    IntPointer __C1,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr2_s8_24(
    @Const IntBuffer __A0, @Cast("vDSP_Stride") long __IA0,
    @Const IntBuffer __A1, @Cast("vDSP_Stride") long __IA1,
    @Const IntBuffer __B,  @Cast("vDSP_Stride") long __IB,
    IntBuffer __C0,
    IntBuffer __C1,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_dotpr2_s8_24(
    @Const int[] __A0, @Cast("vDSP_Stride") long __IA0,
    @Const int[] __A1, @Cast("vDSP_Stride") long __IA1,
    @Const int[] __B,  @Cast("vDSP_Stride") long __IB,
    int[] __C0,
    int[] __C1,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vaddsub, vector single-precision add and subtract.

    Adds vector I0 to vector I1 and leaves the result in vector O0.
    Subtracts vector I0 from vector I1 and leaves the result in vector O1.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            float i1 = I1[i*I1S], i0 = I0[i*I0S];
            O0[i*O0S] = i1 + i0;
            O1[i*O1S] = i1 - i0;
        }

    Input:

        const float *I0, const float *I1, vDSP_Stride I0S, vDSP_Stride I1S.

            Starting addresses of both inputs and strides for the input vectors.

        float *O0, float *O1, vDSP_Stride O0S, vDSP_Stride O1S.

            Starting addresses of both outputs and strides for the output vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O0 and O1.

    In-Place Operation:

        Either of O0 and/or O1 may equal I0 and/or I1, but O0 may not equal
        O1.  Otherwise, no overlap is permitted between any of the buffers.
*/
public static native void vDSP_vaddsub(
    @Const FloatPointer __I0, @Cast("vDSP_Stride") long __I0S,
    @Const FloatPointer __I1, @Cast("vDSP_Stride") long __I1S,
          FloatPointer __O0, @Cast("vDSP_Stride") long __O0S,
          FloatPointer __O1, @Cast("vDSP_Stride") long __O1S,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddsub(
    @Const FloatBuffer __I0, @Cast("vDSP_Stride") long __I0S,
    @Const FloatBuffer __I1, @Cast("vDSP_Stride") long __I1S,
          FloatBuffer __O0, @Cast("vDSP_Stride") long __O0S,
          FloatBuffer __O1, @Cast("vDSP_Stride") long __O1S,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddsub(
    @Const float[] __I0, @Cast("vDSP_Stride") long __I0S,
    @Const float[] __I1, @Cast("vDSP_Stride") long __I1S,
          float[] __O0, @Cast("vDSP_Stride") long __O0S,
          float[] __O1, @Cast("vDSP_Stride") long __O1S,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vaddsubD, vector double-precision add and subtract.

    Adds vector I0 to vector I1 and leaves the result in vector O0.
    Subtracts vector I0 from vector I1 and leaves the result in vector O1.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            double i1 = I1[i*I1S], i0 = I0[i*I0S];
            O0[i*O0S] = i1 + i0;
            O1[i*O1S] = i1 - i0;
        }

    Input:

        const double *I0, const double *I1, vDSP_Stride I0S, vDSP_Stride I1S.

            Starting addresses of both inputs and strides for the input vectors.

        double *O0, double *O1, vDSP_Stride O0S, vDSP_Stride O1S.

            Starting addresses of both outputs and strides for the output vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O0 and O1.

    In-Place Operation:

        Either of O0 and/or O1 may equal I0 and/or I1, but O0 may not equal
        O1.  Otherwise, no overlap is permitted between any of the buffers.
*/
public static native void vDSP_vaddsubD(
    @Const DoublePointer __I0, @Cast("vDSP_Stride") long __I0S,
    @Const DoublePointer __I1, @Cast("vDSP_Stride") long __I1S,
          DoublePointer __O0, @Cast("vDSP_Stride") long __O0S,
          DoublePointer __O1, @Cast("vDSP_Stride") long __O1S,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddsubD(
    @Const DoubleBuffer __I0, @Cast("vDSP_Stride") long __I0S,
    @Const DoubleBuffer __I1, @Cast("vDSP_Stride") long __I1S,
          DoubleBuffer __O0, @Cast("vDSP_Stride") long __O0S,
          DoubleBuffer __O1, @Cast("vDSP_Stride") long __O1S,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vaddsubD(
    @Const double[] __I0, @Cast("vDSP_Stride") long __I0S,
    @Const double[] __I1, @Cast("vDSP_Stride") long __I1S,
          double[] __O0, @Cast("vDSP_Stride") long __O0S,
          double[] __O1, @Cast("vDSP_Stride") long __O1S,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmul, vector single-precision vramp and multiply.

    This routine puts into O the product of I and a ramp function with initial
    value *Start and slope *Step.  *Start is updated to continue the ramp
    in a consecutive call.  To continue the ramp smoothly, the new value of
    *Step includes rounding errors accumulated during the routine rather than
    being calculated directly as *Start + N * *Step.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O[i*OS] = *Start * I[i*IS];
            *Start += *Step;
        }

    Input:

        const float *I, vDSP_Stride IS.

            Starting address and stride for the input vector.

        float *Start.

            Starting value for the ramp.

        const float *Step.

            Value of the step for the ramp.

        float *O, vDSP_Stride OS.

            Starting address and stride for the output vector.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmul(
    @Const FloatPointer __I, @Cast("vDSP_Stride") long __IS,
    FloatPointer __Start,
    @Const FloatPointer __Step,
    FloatPointer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul(
    @Const FloatBuffer __I, @Cast("vDSP_Stride") long __IS,
    FloatBuffer __Start,
    @Const FloatBuffer __Step,
    FloatBuffer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul(
    @Const float[] __I, @Cast("vDSP_Stride") long __IS,
    float[] __Start,
    @Const float[] __Step,
    float[] __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmulD, vector double-precision vramp and multiply.

    This routine puts into O the product of I and a ramp function with initial
    value *Start and slope *Step.  *Start is updated to continue the ramp
    in a consecutive call.  To continue the ramp smoothly, the new value of
    *Step includes rounding errors accumulated during the routine rather than
    being calculated directly as *Start + N * *Step.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O[i*OS] = *Start * I[i*IS];
            *Start += *Step;
        }

    Input:

        const double *I, vDSP_Stride IS.

            Starting address and stride for the input vector.

        double *Start.

            Starting value for the ramp.

        const double *Step.

            Value of the step for the ramp.

        double *O, vDSP_Stride OS.

            Starting address and stride for the output vector.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmulD(
    @Const DoublePointer __I, @Cast("vDSP_Stride") long __IS,
    DoublePointer __Start,
    @Const DoublePointer __Step,
    DoublePointer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmulD(
    @Const DoubleBuffer __I, @Cast("vDSP_Stride") long __IS,
    DoubleBuffer __Start,
    @Const DoubleBuffer __Step,
    DoubleBuffer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmulD(
    @Const double[] __I, @Cast("vDSP_Stride") long __IS,
    double[] __Start,
    @Const double[] __Step,
    double[] __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmuladd, vector single-precision vramp, multiply and add.

    This routine adds to O the product of I and a ramp function with initial
    value *Start and slope *Step.  *Start is updated to continue the ramp in a
    consecutive call.  To continue the ramp smoothly, the new value of *Step
    includes rounding errors accumulated during the routine rather than being
    calculated directly as *Start + N * *Step.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O[i*OS] += *Start * I[i*IS];
            *Start += *Step;
        }

    Input:

        const float *I, vDSP_Stride IS.

            Starting address and stride for the input vector.

        float *Start.

            Starting value for the ramp.

        const float *Step.

            Value of the step for the ramp.

        float *O, vDSP_Stride OS.

            Starting address and stride for the output vector.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are added to O.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmuladd(
    @Const FloatPointer __I, @Cast("vDSP_Stride") long __IS,
    FloatPointer __Start,
    @Const FloatPointer __Step,
    FloatPointer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd(
    @Const FloatBuffer __I, @Cast("vDSP_Stride") long __IS,
    FloatBuffer __Start,
    @Const FloatBuffer __Step,
    FloatBuffer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd(
    @Const float[] __I, @Cast("vDSP_Stride") long __IS,
    float[] __Start,
    @Const float[] __Step,
    float[] __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmuladdD, vector double-precision vramp, multiply and add.

    This routine adds to O the product of I and a ramp function with initial
    value *Start and slope *Step.  *Start is updated to continue the ramp in a
    consecutive call.  To continue the ramp smoothly, the new value of *Step
    includes rounding errors accumulated during the routine rather than being
    calculated directly as *Start + N * *Step.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O[i*OS] += *Start * I[i*IS];
            *Start += *Step;
        }

    Input:

        const double *I, vDSP_Stride IS.

            Starting address and stride for the input vector.

        double *Start.

            Starting value for the ramp.

        const double *Step.

            Value of the step for the ramp.

        double *O, vDSP_Stride OS.

            Starting address and stride for the output vector.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are added to O.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmuladdD(
    @Const DoublePointer __I, @Cast("vDSP_Stride") long __IS,
          DoublePointer __Start,
    @Const DoublePointer __Step,
          DoublePointer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladdD(
    @Const DoubleBuffer __I, @Cast("vDSP_Stride") long __IS,
          DoubleBuffer __Start,
    @Const DoubleBuffer __Step,
          DoubleBuffer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladdD(
    @Const double[] __I, @Cast("vDSP_Stride") long __IS,
          double[] __Start,
    @Const double[] __Step,
          double[] __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmul2, stereo vector single-precision vramp and multiply.

    This routine:

        Puts into O0 the product of I0 and a ramp function with initial value
        *Start and slope *Step.

        Puts into O1 the product of I1 and a ramp function with initial value
        *Start and slope *Step.

    *Start is updated to continue the ramp in a consecutive call.  To continue
    the ramp smoothly, the new value of *Step includes rounding errors
    accumulated during the routine rather than being calculated directly as
    *Start + N * *Step.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O0[i*OS] = *Start * I0[i*IS];
            O1[i*OS] = *Start * I1[i*IS];
            *Start += *Step;
        }

    Input:

        const float *I0, const float *I1, vDSP_Stride IS.

            Starting addresses of both inputs and stride for the input vectors.

        float *Start.

            Starting value for the ramp.

        const float *Step.

            Value of the step for the ramp.

        float *O0, float *O1, vDSP_Stride OS.

            Starting addresses of both outputs and stride for the output vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O0 and O1.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmul2(
    @Const FloatPointer __I0, @Const FloatPointer __I1, @Cast("vDSP_Stride") long __IS,
    FloatPointer __Start,
    @Const FloatPointer __Step,
    FloatPointer __O0, FloatPointer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul2(
    @Const FloatBuffer __I0, @Const FloatBuffer __I1, @Cast("vDSP_Stride") long __IS,
    FloatBuffer __Start,
    @Const FloatBuffer __Step,
    FloatBuffer __O0, FloatBuffer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul2(
    @Const float[] __I0, @Const float[] __I1, @Cast("vDSP_Stride") long __IS,
    float[] __Start,
    @Const float[] __Step,
    float[] __O0, float[] __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmul2D, stereo vector double-precision vramp and multiply.

    This routine:

        Puts into O0 the product of I0 and a ramp function with initial value
        *Start and slope *Step.

        Puts into O1 the product of I1 and a ramp function with initial value
        *Start and slope *Step.

    *Start is updated to continue the ramp in a consecutive call.  To continue
    the ramp smoothly, the new value of *Step includes rounding errors
    accumulated during the routine rather than being calculated directly as
    *Start + N * *Step.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O0[i*OS] = *Start * I0[i*IS];
            O1[i*OS] = *Start * I1[i*IS];
            *Start += *Step;
        }

    Input:

        const double *I0, const double *I1, vDSP_Stride IS.

            Starting addresses of both inputs and stride for the input vectors.

        double *Start.

            Starting value for the ramp.

        const double *Step.

            Value of the step for the ramp.

        double *O0, double *O1, vDSP_Stride OS.

            Starting addresses of both outputs and stride for the output vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O0 and O1.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmul2D(
    @Const DoublePointer __I0, @Const DoublePointer __I1, @Cast("vDSP_Stride") long __IS,
          DoublePointer __Start,
    @Const DoublePointer __Step,
          DoublePointer __O0, DoublePointer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul2D(
    @Const DoubleBuffer __I0, @Const DoubleBuffer __I1, @Cast("vDSP_Stride") long __IS,
          DoubleBuffer __Start,
    @Const DoubleBuffer __Step,
          DoubleBuffer __O0, DoubleBuffer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul2D(
    @Const double[] __I0, @Const double[] __I1, @Cast("vDSP_Stride") long __IS,
          double[] __Start,
    @Const double[] __Step,
          double[] __O0, double[] __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmuladd2, stereo vector single-precision vramp, multiply and add.

    This routine:

        Adds to O0 the product of I0 and a ramp function with initial value
        *Start and slope *Step.

        Adds to O1 the product of I1 and a ramp function with initial value
        *Start and slope *Step.

    *Start is updated to continue the ramp in a consecutive call.  To continue
    the ramp smoothly, the new value of *Step includes rounding errors
    accumulated during the routine rather than being calculated directly as
    *Start + N * *Step.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O0[i*OS] += *Start * I0[i*IS];
            O1[i*OS] += *Start * I1[i*IS];
            *Start += *Step;
        }

    Input:

        const float *I0, const float *I1, vDSP_Stride IS.

            Starting addresses of both inputs and stride for the input vectors.

        float *Start.

            Starting value for the ramp.

        const float *Step.

            Value of the step for the ramp.

        float *O0, float *O1, vDSP_Stride OS.

            Starting addresses of both outputs and stride for the output vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O0 and O1.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmuladd2(
    @Const FloatPointer __I0, @Const FloatPointer __I1, @Cast("vDSP_Stride") long __IS,
    FloatPointer __Start,
    @Const FloatPointer __Step,
    FloatPointer __O0, FloatPointer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd2(
    @Const FloatBuffer __I0, @Const FloatBuffer __I1, @Cast("vDSP_Stride") long __IS,
    FloatBuffer __Start,
    @Const FloatBuffer __Step,
    FloatBuffer __O0, FloatBuffer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd2(
    @Const float[] __I0, @Const float[] __I1, @Cast("vDSP_Stride") long __IS,
    float[] __Start,
    @Const float[] __Step,
    float[] __O0, float[] __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmuladd2D, stereo vector double-precision vramp, multiply and add.

    This routine:

        Adds to O0 the product of I0 and a ramp function with initial value
        *Start and slope *Step.

        Adds to O1 the product of I1 and a ramp function with initial value
        *Start and slope *Step.

    *Start is updated to continue the ramp in a consecutive call.  To continue
    the ramp smoothly, the new value of *Step includes rounding errors
    accumulated during the routine rather than being calculated directly as
    *Start + N * *Step.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O0[i*OS] += *Start * I0[i*IS];
            O1[i*OS] += *Start * I1[i*IS];
            *Start += *Step;
        }

    Input:

        const double *I0, const double *I1, vDSP_Stride IS.

            Starting addresses of both inputs and stride for the input vectors.

        double *Start.

            Starting value for the ramp.

        const double *Step.

            Value of the step for the ramp.

        double *O0, double *O1, vDSP_Stride OS.

            Starting addresses of both outputs and stride for the output vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O0 and O1.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmuladd2D(
    @Const DoublePointer __I0, @Const DoublePointer __I1, @Cast("vDSP_Stride") long __IS,
    DoublePointer __Start,
    @Const DoublePointer __Step,
    DoublePointer __O0, DoublePointer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd2D(
    @Const DoubleBuffer __I0, @Const DoubleBuffer __I1, @Cast("vDSP_Stride") long __IS,
    DoubleBuffer __Start,
    @Const DoubleBuffer __Step,
    DoubleBuffer __O0, DoubleBuffer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd2D(
    @Const double[] __I0, @Const double[] __I1, @Cast("vDSP_Stride") long __IS,
    double[] __Start,
    @Const double[] __Step,
    double[] __O0, double[] __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmul_s1_15, vector integer 1.15 format vramp and multiply.

    This routine puts into O the product of I and a ramp function with initial
    value *Start and slope *Step.  *Start is updated to continue the ramp
    in a consecutive call.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O[i*OS] = *Start * I[i*IS];
            *Start += *Step;
        }

    The elements are fixed-point numbers, each with one sign bit and 15
    fraction bits.  Where the value of the short int is normally x, it is
    x/32768 for the purposes of this routine.

    Input:

        const short int *I, vDSP_Stride IS.

            Starting address and stride for the input vector.

        short int *Start.

            Starting value for the ramp.

        const short int *Step.

            Value of the step for the ramp.

        short int *O, vDSP_Stride OS.

            Starting address and stride for the output vector.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmul_s1_15(
    @Const ShortPointer __I, @Cast("vDSP_Stride") long __IS,
    ShortPointer __Start,
    @Const ShortPointer __Step,
    ShortPointer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul_s1_15(
    @Const ShortBuffer __I, @Cast("vDSP_Stride") long __IS,
    ShortBuffer __Start,
    @Const ShortBuffer __Step,
    ShortBuffer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul_s1_15(
    @Const short[] __I, @Cast("vDSP_Stride") long __IS,
    short[] __Start,
    @Const short[] __Step,
    short[] __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmuladd_s1_15, vector integer 1.15 format vramp, multiply and add.

    This routine adds to O the product of I and a ramp function with initial
    value *Start and slope *Step.  *Start is updated to continue the ramp in a
    consecutive call.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O[i*OS] += *Start * I[i*IS];
            *Start += *Step;
        }

    The elements are fixed-point numbers, each with one sign bit and 15
    fraction bits.  Where the value of the short int is normally x, it is
    x/32768 for the purposes of this routine.

    Input:

        const short int *I, vDSP_Stride IS.

            Starting address and stride for the input vector.

        short int *Start.

            Starting value for the ramp.

        const short int *Step.

            Value of the step for the ramp.

        short int *O, vDSP_Stride OS.

            Starting address and stride for the output vector.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are added to O.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmuladd_s1_15(
    @Const ShortPointer __I, @Cast("vDSP_Stride") long __IS,
    ShortPointer __Start,
    @Const ShortPointer __Step,
    ShortPointer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd_s1_15(
    @Const ShortBuffer __I, @Cast("vDSP_Stride") long __IS,
    ShortBuffer __Start,
    @Const ShortBuffer __Step,
    ShortBuffer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd_s1_15(
    @Const short[] __I, @Cast("vDSP_Stride") long __IS,
    short[] __Start,
    @Const short[] __Step,
    short[] __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmul2_s1_15, stereo vector integer 1.15 format vramp and multiply.

    This routine:

        Puts into O0 the product of I0 and a ramp function with initial value
        *Start and slope *Step.

        Puts into O1 the product of I1 and a ramp function with initial value
        *Start and slope *Step.

    *Start is updated to continue the ramp in a consecutive call.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O0[i*OS] = *Start * I0[i*IS];
            O1[i*OS] = *Start * I1[i*IS];
            *Start += *Step;
        }

    The elements are fixed-point numbers, each with one sign bit and 15
    fraction bits.  Where the value of the short int is normally x, it is
    x/32768 for the purposes of this routine.

    Input:

        const short int *I0, const short int *I1, vDSP_Stride IS.

            Starting addresses of both inputs and stride for the input vectors.

        short int *Start.

            Starting value for the ramp.

        const short int *Step.

            Value of the step for the ramp.

        short int *O0, short int *O1, vDSP_Stride OS.

            Starting addresses of both outputs and stride for the output
            vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O0 and O1.

        On return, *Start contains initial *Start + N * *Step.

*/
public static native void vDSP_vrampmul2_s1_15(
    @Const ShortPointer __I0, @Const ShortPointer __I1, @Cast("vDSP_Stride") long __IS,
    ShortPointer __Start,
    @Const ShortPointer __Step,
    ShortPointer __O0, ShortPointer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul2_s1_15(
    @Const ShortBuffer __I0, @Const ShortBuffer __I1, @Cast("vDSP_Stride") long __IS,
    ShortBuffer __Start,
    @Const ShortBuffer __Step,
    ShortBuffer __O0, ShortBuffer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul2_s1_15(
    @Const short[] __I0, @Const short[] __I1, @Cast("vDSP_Stride") long __IS,
    short[] __Start,
    @Const short[] __Step,
    short[] __O0, short[] __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmuladd2_s1_15, stereo vector integer 1.15 format vramp, multiply
    and add.

    This routine:

        Adds to O0 the product of I0 and a ramp function with initial value
        *Start and slope *Step.

        Adds to O1 the product of I1 and a ramp function with initial value
        *Start and slope *Step.

    *Start is updated to continue the ramp in a consecutive call.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O0[i*OS] += *Start * I0[i*IS];
            O1[i*OS] += *Start * I1[i*IS];
            *Start += *Step;
        }

    The elements are fixed-point numbers, each with one sign bit and 15
    fraction bits.  Where the value of the short int is normally x, it is
    x/32768 for the purposes of this routine.

    Input:

        const short int *I0, const short int *I1, vDSP_Stride IS.

            Starting addresses of both inputs and stride for the input vectors.

        short int *Start.

            Starting value for the ramp.

        const short int *Step.

            Value of the step for the ramp.

        short int *O0, short int *O1, vDSP_Stride OS.

            Starting addresses of both outputs and stride for the output
            vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are added to O0 and O1.

        On return, *Start contains initial *Start + N * *Step.

*/
public static native void vDSP_vrampmuladd2_s1_15(
    @Const ShortPointer __I0, @Const ShortPointer __I1, @Cast("vDSP_Stride") long __IS,
    ShortPointer __Start,
    @Const ShortPointer __Step,
    ShortPointer __O0, ShortPointer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd2_s1_15(
    @Const ShortBuffer __I0, @Const ShortBuffer __I1, @Cast("vDSP_Stride") long __IS,
    ShortBuffer __Start,
    @Const ShortBuffer __Step,
    ShortBuffer __O0, ShortBuffer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd2_s1_15(
    @Const short[] __I0, @Const short[] __I1, @Cast("vDSP_Stride") long __IS,
    short[] __Start,
    @Const short[] __Step,
    short[] __O0, short[] __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmul_s8_24, vector integer 8.24 format vramp and multiply.

    This routine puts into O the product of I and a ramp function with initial
    value *Start and slope *Step.  *Start is updated to continue the ramp
    in a consecutive call.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O[i*OS] = *Start * I[i*IS];
            *Start += *Step;
        }

    The elements are fixed-point numbers, each with eight integer bits
    (including sign) and 24 fraction bits.  Where the value of the int is
    normally x, it is x/16777216 for the purposes of this routine.

    Input:

        const int *I, vDSP_Stride IS.

            Starting address and stride for the input vector.

        int *Start.

            Starting value for the ramp.

        const int *Step.

            Value of the step for the ramp.

        int *O, vDSP_Stride OS.

            Starting address and stride for the output vector.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmul_s8_24(
    @Const IntPointer __I, @Cast("vDSP_Stride") long __IS,
    IntPointer __Start,
    @Const IntPointer __Step,
    IntPointer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul_s8_24(
    @Const IntBuffer __I, @Cast("vDSP_Stride") long __IS,
    IntBuffer __Start,
    @Const IntBuffer __Step,
    IntBuffer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul_s8_24(
    @Const int[] __I, @Cast("vDSP_Stride") long __IS,
    int[] __Start,
    @Const int[] __Step,
    int[] __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmuladd_s8_24, vector integer 8.24 format vramp, multiply and add.

    This routine adds to O the product of I and a ramp function with initial
    value *Start and slope *Step.  *Start is updated to continue the ramp in a
    consecutive call.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O[i*OS] += *Start * I[i*IS];
            *Start += *Step;
        }

    The elements are fixed-point numbers, each with eight integer bits
    (including sign) and 24 fraction bits.  Where the value of the int is
    normally x, it is x/16777216 for the purposes of this routine.

    Input:

        const int *I, vDSP_Stride IS.

            Starting address and stride for the input vector.

        int *Start.

            Starting value for the ramp.

        const int *Step.

            Value of the step for the ramp.

        int *O, vDSP_Stride OS.

            Starting address and stride for the output vector.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are added to O.

        On return, *Start contains initial *Start + N * *Step.
*/
public static native void vDSP_vrampmuladd_s8_24(
    @Const IntPointer __I, @Cast("vDSP_Stride") long __IS,
    IntPointer __Start,
    @Const IntPointer __Step,
    IntPointer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd_s8_24(
    @Const IntBuffer __I, @Cast("vDSP_Stride") long __IS,
    IntBuffer __Start,
    @Const IntBuffer __Step,
    IntBuffer __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd_s8_24(
    @Const int[] __I, @Cast("vDSP_Stride") long __IS,
    int[] __Start,
    @Const int[] __Step,
    int[] __O, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmul2_s8_24, stereo vector integer 8.24 format vramp and multiply.

    This routine:

        Puts into O0 the product of I0 and a ramp function with initial value
        *Start and slope *Step.

        Puts into O1 the product of I1 and a ramp function with initial value
        *Start and slope *Step.

    *Start is updated to continue the ramp in a consecutive call.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O0[i*OS] = *Start * I0[i*IS];
            O1[i*OS] = *Start * I1[i*IS];
            *Start += *Step;
        }

    The elements are fixed-point numbers, each with eight integer bits
    (including sign) and 24 fraction bits.  Where the value of the int is
    normally x, it is x/16777216 for the purposes of this routine.

    Input:

        const int *I0, const int *I1, vDSP_Stride IS.

            Starting addresses of both inputs and stride for the input vectors.

        int *Start.

            Starting value for the ramp.

        const int *Step.

            Value of the step for the ramp.

        int *O0, int *O1, vDSP_Stride OS.

            Starting addresses of both outputs and stride for the output
            vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O0 and O1.

        On return, *Start contains initial *Start + N * *Step.

*/
public static native void vDSP_vrampmul2_s8_24(
    @Const IntPointer __I0, @Const IntPointer __I1, @Cast("vDSP_Stride") long __IS,
    IntPointer __Start,
    @Const IntPointer __Step,
    IntPointer __O0, IntPointer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul2_s8_24(
    @Const IntBuffer __I0, @Const IntBuffer __I1, @Cast("vDSP_Stride") long __IS,
    IntBuffer __Start,
    @Const IntBuffer __Step,
    IntBuffer __O0, IntBuffer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmul2_s8_24(
    @Const int[] __I0, @Const int[] __I1, @Cast("vDSP_Stride") long __IS,
    int[] __Start,
    @Const int[] __Step,
    int[] __O0, int[] __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  vDSP_vrampmuladd2_s8_24, stereo vector integer 8.24 format vramp, multiply
    and add.

    This routine:

        Adds to O0 the product of I0 and a ramp function with initial value
        *Start and slope *Step.

        Adds to O1 the product of I1 and a ramp function with initial value
        *Start and slope *Step.

    *Start is updated to continue the ramp in a consecutive call.

    This routine calculates:

        for (i = 0; i < N; ++i)
        {
            O0[i*OS] += *Start * I0[i*IS];
            O1[i*OS] += *Start * I1[i*IS];
            *Start += *Step;
        }

    The elements are fixed-point numbers, each with eight integer bits
    (including sign) and 24 fraction bits.  Where the value of the int is
    normally x, it is x/16777216 for the purposes of this routine.

    Input:

        const int *I0, const int *I1, vDSP_Stride IS.

            Starting addresses of both inputs and stride for the input vectors.

        int *Start.

            Starting value for the ramp.

        const int *Step.

            Value of the step for the ramp.

        int *O0, int *O1, vDSP_Stride OS.

            Starting addresses of both outputs and stride for the output
            vectors.

        vDSP_Length Length.

            Number of elements in each vector.

    Output:

        The results are written to O0 and O1.

        On return, *Start contains initial *Start + N * *Step.

*/
public static native void vDSP_vrampmuladd2_s8_24(
    @Const IntPointer __I0, @Const IntPointer __I1, @Cast("vDSP_Stride") long __IS,
    IntPointer __Start,
    @Const IntPointer __Step,
    IntPointer __O0, IntPointer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd2_s8_24(
    @Const IntBuffer __I0, @Const IntBuffer __I1, @Cast("vDSP_Stride") long __IS,
    IntBuffer __Start,
    @Const IntBuffer __Step,
    IntBuffer __O0, IntBuffer __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);
public static native void vDSP_vrampmuladd2_s8_24(
    @Const int[] __I0, @Const int[] __I1, @Cast("vDSP_Stride") long __IS,
    int[] __Start,
    @Const int[] __Step,
    int[] __O0, int[] __O1, @Cast("vDSP_Stride") long __OS,
    @Cast("vDSP_Length") long __N);


/*  When compiling for i386 on OS X 10.11 or later, the old vDSP routine names
    are deprecated.
*/
// #if defined vDSP_DeprecateTranslations

// #endif  //  #if defined vDSP_DeprecateTranslations


// #ifndef USE_NON_APPLE_STANDARD_DATATYPES
public static final int USE_NON_APPLE_STANDARD_DATATYPES = 1;
// #endif  /* !defined(USE_NON_APPLE_STANDARD_DATATYPES) */

// #if USE_NON_APPLE_STANDARD_DATATYPES
/** enum  */
public static final int
    FFT_FORWARD = kFFTDirection_Forward,
    FFT_INVERSE = kFFTDirection_Inverse;

/** enum  */
public static final int
    FFT_RADIX2  = kFFTRadix2,
    FFT_RADIX3  = kFFTRadix3,
    FFT_RADIX5  = kFFTRadix5;
// #endif  /* USE_NON_APPLE_STANDARD_DATATYPES */


// #pragma options align=reset


// #if __has_feature(assume_nonnull)
// #endif


// #ifdef __cplusplus
// #endif


// #endif // __VDSP__


}
