// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package uncomplicate.javacpp.accelerate.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class bnns extends uncomplicate.javacpp.accelerate.presets.bnns {
    static { Loader.load(); }

// Parsed from bnns_constants.h

//
//  bnns_constants.h
//  BasicNeuralNetworkSubroutines
//
//  Copyright © 2017 Apple Inc. All rights reserved.
//

// #ifndef __BNNS_CONSTANTS_HEADER__
// #define __BNNS_CONSTANTS_HEADER__

// #include <stdint.h>

// #if __has_feature(objc_fixed_enum) || __has_extension(cxx_strong_enums)
// #define BNNS_ENUM(_name, _type, ...)
//         typedef enum : _type { __VA_ARGS__ } _name
// #else
// #define BNNS_ENUM(_name, _type, ...)
//         enum { __VA_ARGS__ }; typedef _type _name
// #endif

// #if __has_include( <Availability.h> )
// #include <Availability.h>
// #else
// #define __API_AVAILABLE(...)
// #define __API_DEPRECATED_WITH_REPLACEMENT(...)
// #define __API_AVAILABLE(...)
// #endif

/**
 <p>
 \abstract Storage data type
 <p>
 \constant BNNSDataTypeFloatBit
 Common bit to floating point types, this constant is not a valid type
 <p>
 \constant BNNSDataTypeFloat16
 16-bit half precision floating point
 <p>
 \constant BNNSDataTypeFloat32
 32-bit single precision floating point
 <p>
 \constant BNNSDataTypeBFloat16
 16-bit brain floating Point
 <p>
 \constant BNNSDataTypeIntBit
 Common bit to signed integer types, this constant is not a valid type
 <p>
 \constant BNNSDataTypeInt8
 8-bit signed integer
 <p>
 \constant BNNSDataTypeInt16
 16-bit signed integer
 <p>
 \constant BNNSDataTypeInt32
 32-bit signed integer
 <p>
 \constant BNNSDataTypeInt64
 64-bit signed integer
 <p>
 \constant BNNSDataTypeUIntBit
 Common bit to unsigned integer types, this constant is not a valid type
 <p>
 \constant BNNSDataTypeUInt8
 8-bit unsigned integer
 <p>
 \constant BNNSDataTypeUInt16
 16-bit unsigned integer
 <p>
 \constant BNNSDataTypeUInt32
 32-bit unsigned integer
 <p>
 \constant BNNSDataTypeUInt64
 64-bit unsigned integer
 <p>
 \constant BNNSDataTypeIndexedBit
 Common bit to indexed floating point types, this constant is not a valid type
 <p>
 \constant BNNSDataTypeIndexed2
 2-bit unsigned indices into a floating point conversion table (4 values)
 <p>
 \constant BNNSDataTypeIndexed4
 4-bit unsigned indices into a floating point conversion table (16 values)
 <p>
 \constant BNNSDataTypeIndexed8
 8-bit unsigned indices into a floating point conversion table (256 values)
 <p>
 \constant BNNSDataTypeMiscellaneousBit
 Common bit to miscellaneous types, this constant is not a valid type
 <p>
 \constant BNNSDataTypeBoolean
 bool value
<p>
*/
/** enum BNNSDataType */
public static final int

   BNNSDataTypeFloatBit         = 0x10000,
  BNNSDataTypeFloat16          = BNNSDataTypeFloatBit | 16,
  BNNSDataTypeFloat32          = BNNSDataTypeFloatBit | 32,
  BNNSDataTypeBFloat16         = BNNSDataTypeFloatBit | 0x8000 | 16,

  BNNSDataTypeIntBit           = 0x20000,
  BNNSDataTypeInt1             = BNNSDataTypeIntBit | 1,
  BNNSDataTypeInt2             = BNNSDataTypeIntBit | 2,
  BNNSDataTypeInt4             = BNNSDataTypeIntBit | 4,
  BNNSDataTypeInt8             = BNNSDataTypeIntBit | 8,
  BNNSDataTypeInt16            = BNNSDataTypeIntBit | 16,
  BNNSDataTypeInt32            = BNNSDataTypeIntBit | 32,
  BNNSDataTypeInt64            = BNNSDataTypeIntBit | 64,

  BNNSDataTypeUIntBit          = 0x40000,
  BNNSDataTypeUInt1            = BNNSDataTypeUIntBit | 1,
  BNNSDataTypeUInt2            = BNNSDataTypeUIntBit | 2,
  BNNSDataTypeUInt3            = BNNSDataTypeUIntBit | 3,
  BNNSDataTypeUInt4            = BNNSDataTypeUIntBit | 4,
  BNNSDataTypeUInt6            = BNNSDataTypeUIntBit | 6,
  BNNSDataTypeUInt8            = BNNSDataTypeUIntBit | 8,
  BNNSDataTypeUInt16           = BNNSDataTypeUIntBit | 16,
  BNNSDataTypeUInt32           = BNNSDataTypeUIntBit | 32,
  BNNSDataTypeUInt64           = BNNSDataTypeUIntBit | 64,

  BNNSDataTypeIndexedBit       = 0x80000,
  BNNSDataTypeIndexed1         = BNNSDataTypeIndexedBit | 1,
  BNNSDataTypeIndexed2         = BNNSDataTypeIndexedBit | 2,
  BNNSDataTypeIndexed4         = BNNSDataTypeIndexedBit | 4,
  BNNSDataTypeIndexed8         = BNNSDataTypeIndexedBit | 8,

  BNNSDataTypeMiscellaneousBit = 0x100000,
  BNNSDataTypeBoolean          = BNNSDataTypeMiscellaneousBit | 8;

/**
 <p>
 \abstract Pooling layer function
 <p>
 \discussion
 In the definitions below, the input sample is <tt>X<sub>i</sub></tt> and has <tt>N</tt> elements.
 <p>
 \constant BNNSPoolingFunctionMax
 max(X<sub>i</sub>)
 <p>
 \constant BNNSPoolingFunctionAverageCountIncludePadding
 &sum;<sub>i</sub> X<sub>i</sub> / N
 <p>
 \constant BNNSPoolingFunctionAverageCountExcludePadding
 &sum;<sub>i</sub> X<sub>i</sub> / n
 - n is number of elements that weren't zero padded
 <p>
 \constant BNNSPoolingFunctionUnMax
 partial inverse of max(X<sub>i</sub>) in which all non-maximal values are set to zero
 <p>
 \constant BNNSPoolingFunctionL2Norm
 <math><msqrt><mi>&sum;<sub>i</sub> X<sub>i</sub><sup>2</sup></mi></msqrt></math>
<p>
*/
/** enum BNNSPoolingFunction */
public static final int

   BNNSPoolingFunctionMax                        = 0,
  BNNSPoolingFunctionAverageCountIncludePadding = 1,
  BNNSPoolingFunctionAverageCountExcludePadding = 2,
  BNNSPoolingFunctionUnMax                      = 3,
  BNNSPoolingFunctionL2Norm                     = 4,

  BNNSPoolingFunctionAverage  = BNNSPoolingFunctionAverageCountIncludePadding;

/**
 <p>
 \abstract Activation layer function
 <p>
 \constant BNNSActivationFunctionIdentity
 x
 <p>
 \constant BNNSActivationFunctionRectifiedLinear
 0 if x<0, and x if x>=0
 <p>
 \constant BNNSActivationFunctionReLU6
 min(max(0,x),6)
 <p>
 \constant BNNSActivationFunctionLeakyRectifiedLinear
 alpha*x if x<0, and x if x>=0
 A pointer to the alpha value can be obtained via a BNNSGetPointer() call, and the delta with respect to alpha
 is obtained via the weights_delta field in a call to BNNSApplyBackward() or BNNSApplyBackwardBatch() of a standalone
 Activation layer (the delta is not available in situations where the activation is fused with another layer).
 <p>
 \constant BNNSActivationFunctionSigmoid
 sigmoid(x)
 <p>
 \constant BNNSActivationFunctionLogSigmoid
 log(sigmoid(x))
 <p>
 \constant BNNSActivationFunctionTanh
 tanh(x)
 <p>
 \constant BNNSActivationFunctionScaledTanh
 alpha*tanh(x*beta)
 <p>
 \constant BNNSActivationFunctionAbs
 abs(x)
 <p>
 \constant BNNSActivationFunctionLinear
 alpha*x
 <p>
 \constant BNNSActivationFunctionClamp
 min(max(x, alpha), beta)
 <p>
 \constant BNNSActivationFunctionIntegerLinearSaturate
 Saturate<output_type>((iscale * x + ioffset) >> ishift)
 This is an arithmetic shift, preserving sign.
 <p>
 \constant BNNSActivationFunctionIntegerLinearSaturatePerChannel
 Saturate<output_type>((iscale_per_channel[channel] * x + ioffset_per_channel[channel]) >> ishift_per_channel[channel]) for each channel
 This is an arithmetic shift, preserving sign.
 <p>
 \constant BNNSActivationFunctionSoftmax
 softmax(x)_i = exp(x_i) / ( sum_i exp(x_i) ).
 <p>
 \constant BNNSActivationFunctionGELUApproximation
 GELUApproximation(x)_i = 0.5f * x * (1.0f + tanh(alpha*(x + beta * x * x * x))).
 <p>
 \constant BNNSActivationFunctionGumbel
 Gumbel_i =  −log(−log(alpha*Uniform(0,1)+beta)+beta)
 <p>
 \constant BNNSActivationFunctionGumbelMax
 GumbelMax(X)_i = MAX(−log(−log(alpha*Uniform(0,1)+beta)+beta) + Xj)
 <p>
 \constant BNNSActivationFunctionHardSigmoid
 HardSigmoid(x) = max(0, min(1, alpha*x + beta))
 <p>
 \constant BNNSActivationFunctionSoftplus
 Softplus(x) = alpha * log( 1 + exp(beta*x) )
 <p>
 \constant BNNSActivationFunctionSoftsign
 Softsign(x) = x / (1 + |x| )
 <p>
 \constant BNNSActivationFunctionELU
 ELU(x) = alpha*(exp(x) - 1) if x < 0, and x if x >= 0
 <p>
 \constant BNNSActivationFunctionSELU
 SELU(x) = 1.0507009873554804934193349852946*(1.6732632423543772848170429916717*(exp(x) - 1)) if x < 0,
         and 1.0507009873554804934193349852946*x if x >= 0
 <p>
 \constant BNNSActivationFunctionCELU
 ELU(x) = alpha*(exp(x/alpha) - 1) if x < 0, and x if x >= 0
 <p>
 \constant BNNSActivationFunctionClampedLeakyRectifiedLinear
 CLReLU(x) = min( alpha*x, beta) if x < 0, and min(x, beta) if  x >= 0
 <p>
 \constant BNNSActivationFunctionLinearWithBias
 alpha*x + beta
 <p>
 \constant BNNSActivationFunctionLogSoftmax
 log_softmax(x)_i = log( exp(x_i) / ( sum_i exp(x_i) ) ).
 <p>
 \constant BNNSActivationFunctionHardShrink
 0 if abs(x) < abs(alpha), and x otherwise
 <p>
 \constant BNNSActivationFunctionSoftShrink
 0 if abs(x) < abs(alpha), and x-copysign(alpha, x) otherwise
 <p>
 \constant BNNSActivationFunctionTanhShrink
 TanhShrink(x) = x − tanh(x)
 <p>
 \constant BNNSActivationFunctionThreshold
 beta if x <= alpha, and x otherwise
 <p>
 \constant BNNSActivationFunctionPReLUPerChannel
 alpha_c*x if x<0, and x if x>=0      (i.e. Leaky ReLU with per-channel alpha values)
 This activation is only valid for use with layouts of type BNNSDataLayoutImageCHW.
 The provided alpha value is used to initialize an array of alpha_c values, one per channel: if a PReLU with a shared alpha
 across all channels is required, use BNNSActivationFunctionLeakyRectifiedLinear with BNNSGetPointer().
 These values can then be updated (i.e. trained) individually using pointers obtained via BNNSGetPointer() calls.
 The delta vector with respect to alpha_c is obtained via the weights_delta field in a call to BNNSApplyBackward() or
 BNNSApplyBackwardBatch() of a standalone Activation layer (the delta is not available if situations where the activation is fused with another layer).
 <p>
 \constant BNNSActivationFunctionGELUApproximation2
 GELUApproximation2(x) = x*(ReLU6(x + 3.0) * 1.0/6.0)
 <p>
 \constant BNNSActivationFunctionHardSwish
 Same as BNNSActivationFunctionGELUApproximation2.
 HardSwish(x) = GELUApproximation2(x) = x*(ReLU6(x + 3.0) * 1.0/6.0)
 <p>
 \constant BNNSActivationFunctionSiLU
 SiLU(x) = x*sigmoid(x)
 <p>
 \constant BNNSActivationFunctionErf
 erf(x)
 <p>
 \constant BNNSActivationFunctionGELU
 GELU(x)_i = 0.5*x * ( 1 + erf(x/sqrt(2)) )
 <p>
 \constant BNNSActivationFunctionGELUApproximationSigmoid
 GELUApproxSigmoid(x)_i = x * sigmoid(1.702 * x)
<p>
*/
/** enum BNNSActivationFunction */
public static final int

   BNNSActivationFunctionIdentity                         = 0,
  BNNSActivationFunctionRectifiedLinear                  = 1,
  BNNSActivationFunctionLeakyRectifiedLinear             = 2,
  BNNSActivationFunctionSigmoid                          = 3,
  BNNSActivationFunctionTanh                             = 4,
  BNNSActivationFunctionScaledTanh                       = 5,
  BNNSActivationFunctionAbs                              = 6,
  BNNSActivationFunctionLinear                           = 7,
  BNNSActivationFunctionClamp                            = 8,
  BNNSActivationFunctionIntegerLinearSaturate            = 9,
  BNNSActivationFunctionIntegerLinearSaturatePerChannel  = 10,
  BNNSActivationFunctionSoftmax                          = 11,
  BNNSActivationFunctionGELUApproximation                = 12,
  BNNSActivationFunctionGumbel                           = 13,
  BNNSActivationFunctionGumbelMax                        = 14,
  BNNSActivationFunctionHardSigmoid                      = 15,
  BNNSActivationFunctionSoftplus                         = 16,
  BNNSActivationFunctionSoftsign                         = 17,
  BNNSActivationFunctionELU                              = 18,
  BNNSActivationFunctionClampedLeakyRectifiedLinear      = 19,
  BNNSActivationFunctionLinearWithBias                   = 20,
  BNNSActivationFunctionLogSoftmax                       = 21,
  BNNSActivationFunctionLogSigmoid                       = 22,
  BNNSActivationFunctionSELU                             = 23,
  BNNSActivationFunctionCELU                             = 24,
  BNNSActivationFunctionHardShrink                       = 25,
  BNNSActivationFunctionSoftShrink                       = 26,
  BNNSActivationFunctionTanhShrink                       = 27,
  BNNSActivationFunctionThreshold                        = 28,
  BNNSActivationFunctionPReLUPerChannel                  = 29,
  BNNSActivationFunctionGELUApproximation2               = 30,
  BNNSActivationFunctionHardSwish                        = BNNSActivationFunctionGELUApproximation2,
  BNNSActivationFunctionSiLU                             = 31,
  BNNSActivationFunctionReLU6                            = 32,
  BNNSActivationFunctionErf                              = 33,
  BNNSActivationFunctionGELU                             = 34,
  BNNSActivationFunctionGELUApproximationSigmoid         = 35;

/**
  <p>
  \abstract Filter flags
  <p>
  \constant BNNSFlagsUseClientPtr
  <p>
  Instructs the filter to keep the pointers provided by the client at creation time (weights, bias), and work directly from this data. In that
  case, the client must ensure these pointers remain valid through the entire lifetime of the filter.
  <p>
  If not set, the filter creation function must allocate buffers, and keep an internal copy of the data. In that case, the client doesn't have
  to keep the pointers valid after the filter is created.
<p>
*/
/** enum BNNSFlags */
public static final int

           BNNSFlagsUseClientPtr  = 0x0001;

/**
 <p>
 \abstract Loss layer function
 <p>
 \constant BNNSLossFunctionSoftmaxCrossEntropy
 perform softmax on input logits and compute cross entropy loss with one hot encoded labels.
 labels can be smoothed according to smoothing factor, loss can be scaled with scalar or vector weight and reduced according to reduction function
 for each sample in the batch:
    p = softmax(in sample)
    labels = one hot encoded lables for in sample
    weight = scaling factor
    sample loss = (1/number_of_classes)*(-1*sum_over_all_classes_i(labels[i]*log(p[i])*weight)
 <p>
 \constant BNNSLossFunctionSigmoidCrossEntropy
 perform sigmoid on input logits and compute cross entropy loss for each class independently.
 labels can be smoothed according to smoothing factor, loss can be scaled with scalar or weight matrix (matrix size = number_of_classes*batch_size) and reduced according to reduction function
 for each class in each sample in the batch:
    weight = scaling factor
    sample class loss[i] = weight*(-label[i]*log(sigmoid(logit[i])) - (1-label[i])*log(1-sigmoid(logit[i])))
 <p>
 loss = reduction(all batch sample class loss)
 <p>
 \constant BNNSLossFunctionMeanSquareError
 performs mean square error (MSE) computation between input logits and one hot encoded labels.
 loss can be scaled with scalar or weight matrix (matrix size = number_of_classes*batch_size) and reduced according to reduction function
 for each class in each sample in the batch:
    weight = scaling factor
    sample class mse[i] = weight * (logit[i] - label[i]) * (logit[i] - label[i])
 <p>
 loss = reduction(all batch sample class loss)
 <p>
 \constant BNNSLossFunctionHuber
 performs huber loss computation between input logits and one hot encoded labels.
 loss can be scaled with scalar or weight matrix (matrix size = number_of_classes*batch_size) and reduced according to reduction function
 for each class in each sample in the batch:
    weight = scaling factor
    error[i] = logit[i] - label[i]
    abs(error[i]) <= delta : huber[i] = weight * 0.5 * error[i] * error[i]
    abs(error[i]) > delta :  huber[i] = weight * delta * (abs(error) - 0.5 * delta)
 <p>
 loss = reduction(all batch sample loss)
 <p>
 \constant BNNSLossFunctionYolo
 performs yolo loss computation between prediction and ground truth labels
 Implementation is based on yolo papers, such as the following:
 You Only Look Once: Unified, Real-Time Object Detection: https://arxiv.org/abs/1506.02640
 SSD: Single Shot MultiBox Detector: https://arxiv.org/abs/1512.02325
 YOLO9000: Better, Faster, Stronger:  https://arxiv.org/abs/1612.08242
 <p>
 prediction represented as: |x,y,w,h,conf,c1,c2...cn| * number of anchors * number of cells in grid
 ground_truth represented as: |x,y,w,h,conf,c1,c2...cn| * number of anchors * number of cells in grid
 It is assumed that ground truth confidence is 0 if there is no object in the current cell, or 1 if there is an object  in the current cell
 It is also assumed that ground truth is duplicated for all anchors in a given cell.
 <p>
 The loss function is a hybrid of the following functions:
 x,y: MSE
 w,h: Huber
 confidence: Sigmoid Cross Entropy
 classification: Softmax Cross Entropy
 <p>
 loss = sum of all loss componenets (x,y,w,h,conf,class)
 <p>
 \constant BNNSLossFunctionLog
 performs log loss computation between labels (ground truth output tensor) and predictions (predicted outputs).
 loss can be scaled with scalar or weight matrix (matrix size = number_of_classes*batch_size) and reduced according to reduction function
 for each class in each sample in the batch:
    weight = scaling factor
    p_i = predictions[i] + epsilon;
    pm1_i = 1 - predictions[i] + epsilon;
    t_i = labels[i];
    log_loss[i] = -t_i *log( p_i ) - (1 - t_i) * log( pm1_i );
    in_delta[i] = (p_i - t_i)/(p_i*pm1_i);
 <p>
 loss = reduction(all batch sample class loss)
 <p>
 \constant BNNSLossFunctionCosineDistance
 performs cosine distance loss computation between labels (ground truth output tensor) and predictions (predicted outputs).
 both labels and predictions SHOULD be unit-normalized.
 loss can be scaled with scalar or weight matrix (matrix size = number_of_classes*batch_size) and reduced according to reduction function
 for each class in each sample in the batch:
    weight = scaling factor
    p_i = predictions[i];
    t_i = labels[i];
    loss = 1. - SUM (weight * t_i * p_i );
    in_delta[i] = -t_i + (1-loss)) * p_i;
 <p>
 loss = reduction(all batch sample class loss)
 <p>
 \constant BNNSLossFunctionHinge
 performs Hinge loss computation between labels (ground truth output tensor, 0 or 1) and logits (unbpunded 0-centered binary predictions).
 loss can be scaled with scalar or weight matrix (matrix size = number_of_classes*batch_size) and reduced according to reduction function
 for each class in each sample in the batch:
    weight = scaling factor
    t_i = 2*labels[i] - 1;  // convert 0 or 1 to -1 or 1
    loss = max(0, 1 - t_i * logits_i;
    <p>
    in_delta[i] = -1 if logits_i <= 1 and t_i == 1
                   0 if logits_i > 1 and t_i == 1
                   1 if logits_i >= -1 and t_i == -1
                   0 if logits_i < -1 and t_i == -1
 <p>
 <p>
 loss = reduction(all batch sample class loss)
 <p>
 \constant BNNSLossFunctionMeanAbsoluteError
 performs mean absolute error (MAE) computation between input prediction and labels.
 loss can be scaled with scalar or weight matrix (matrix size = number_of_classes*batch_size) and reduced according to reduction function
 for each class in each sample in the batch:
    weight = scaling factor
    sample class mae[i] = weight * absolute(prediction[i] - label[i]);
    <p>
    in_delta[i] = 1 if prediction_i >= label_i
                 -1 otherwisze
 <p>
 loss = reduction(all batch sample class loss)
 <p>
 \constant BNNSLossFunctionCategoricalCrossEntropy
 performs categorical cross entropy (softmax activation plus a cross entropy loss) computation between input prediction and labels.
 loss can be scaled with scalar or weight matrix (matrix size = number_of_classes*batch_size) and reduced according to reduction function
 for each class in each sample in the batch:
    weight = scaling factor
    numM = number of nonzero labels;
    scale_factor = 1/numM;
    logprobs = 0;
    for each element c in labels
       if (labels[r,c] != 0) logprobs += -log(probs[c]) * labels[c] * weight[c] * scale_factor;
       <p>
       if (labels[r,c] != 0)
          in_delta[r,c] = weight[c] * (probs[c] - scale_factor);
       else
          in_delta[r,c] = probs[c];
 <p>
 loss = reduction(all batch sample class loss)
 <p>
 */
/** enum BNNSLossFunction */
public static final int

           BNNSLossFunctionSoftmaxCrossEntropy      = 1,
          BNNSLossFunctionSigmoidCrossEntropy      = 2,
          BNNSLossFunctionMeanSquareError          = 3,
          BNNSLossFunctionHuber                    = 4,
          BNNSLossFunctionYolo                     = 5,
          BNNSLossFunctionLog                      = 6,
          BNNSLossFunctionCosineDistance           = 7,
          BNNSLossFunctionHinge                    = 8,
          BNNSLossFunctionMeanAbsoluteError        = 9,
          BNNSLossFunctionCategoricalCrossEntropy  = 10;

/**
 <p>
 \abstract Loss layer reduction function
 <p>
 \constant BNNSLossReductionNone
 No reduction. Output loss size equal to input size.
 <p>
 \constant BNNSLossReductionSum
 Sum the loss of all samples in the batch.
 <p>
 \constant BNNSLossReductionWeightedMean
 Sum the loss of all samples in the batch and divide by the sum of all weights.
 0 is returned if the sum of all weights is 0.
 <p>
 \constant BNNSLossReductionMean
 Sum the loss of all samples in the batch and divide by number of samples.
 <p>
 \constant  BNNSLossReductionNonZeroWeightMean
 Sum the loss of all samples in the batch and divide by number of nonzero weights.
 0 is returned in case all weights are zero.
 <p>
 */
/** enum BNNSLossReductionFunction */
public static final int

           BNNSLossReductionNone               = 0,
          BNNSLossReductionSum                = 1,
          BNNSLossReductionWeightedMean       = 2,
          BNNSLossReductionMean               = 3,
          BNNSLossReductionNonZeroWeightMean  = 4;

/**
 <p>
 \abstract Arithmetic function
 <p>
 \constant BNNSArithmeticAdd
 Arithmetic function add
 element-wise computation of out = in1+in2
 in-place computation is supported for forward and gradient
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 <p>
 \constant BNNSArithmeticSubtract
 Arithmetic function subtract
 element-wise computation of out = in1-in2
 in-place computation is supported for forward and gradient
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 <p>
 \constant BNNSArithmeticMultiply
 Arithmetic function multiply
 element-wise computation of out = in1*in2
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 <p>
 \constant BNNSArithmeticDivide
 Arithmetic function divide
 element-wise computation of out = in1/in2
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 <p>
 \constant BNNSArithmeticSquareRoot
 Arithmetic function square root
 element-wise computation of out = √in
 in-place computation is supported for inference
 in-place computation is supported for gradient if activation function is identity
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticReciprocalSquareRoot
 Arithmetic function reciprocal square root
 element-wise computation of out = 1/√in
 in-place computation is supported for inference
 in-place computation is supported for gradient if activation function is identity
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticCeil
 Arithmetic function ceil
 element-wise computation of out = ceil(in)
 in-place computation is supported for forward and gradient
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticFloor
 Arithmetic function floor
 element-wise computation of out = floor(in)
 in-place computation is supported for forward and gradient
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticRound
 Arithmetic function round
 element-wise computation of out = round(in)
 in-place computation is supported for forward and gradient
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticSin
 Arithmetic function sine
 element-wise computation of out = sin(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticCos
 Arithmetic function cosine
 element-wise computation of out = cos(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticTan
 Arithmetic function tangent
 element-wise computation of out = tan(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticAsin
 Arithmetic function inverse sine
 element-wise computation of out = asin(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticAcos
 Arithmetic function inverse cosine
 element-wise computation of out = acos(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticAtan
 Arithmetic function inverse tangent
 element-wise computation of out = atan(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticSinh
 Arithmetic function hyperbolic sine
 element-wise computation of out = sinh(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticCosh
 Arithmetic function hyperbolic cosine
 element-wise computation of out = cosh(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticTanh
 Arithmetic function hyperbolic tangent
 element-wise computation of out = tanh(in)
 in-place computation is supported for inference
 in-place computation is supported for gradient if activation function is identity
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticAsinh
 Arithmetic function inverse hyperbolic sine
 element-wise computation of out = asinh(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticAcosh
 Arithmetic function inverse hyperbolic cosine
 element-wise computation of out = acosh(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticAtanh
 Arithmetic function inverse hyperbolic tangent
 element-wise computation of out = atanh(in)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticPow
 Arithmetic function power
 element-wise computation of out = in1**in2
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 <p>
 \constant BNNSArithmeticExp
 Arithmetic function exp
 element-wise computation of e raised to the power of x. out = e^x
 in-place computation is supported for inference
 in-place computation is supported for gradient if activation function is identity
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticExp2
 Arithmetic function exp2
 element-wise computation of 2 raised to the power of x. out = 2^x
 in-place computation is supported for inference
 in-place computation is supported for gradient if activation function is identity
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticLog
 Arithmetic function log
 element-wise computation of the natural logarithm of x. out = log(x)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticLog2
 Arithmetic function log2
 element-wise computation of the base 2 logarithm of x. out = log2(x)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 <p>
 \constant BNNSArithmeticMultiplyNoNaN
 Arithmetic function multiply, returns 0 if the in2 is zero, even if in1 is NaN or infinite
 element-wise computation of out = in1*in2
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 <p>
 \constant BNNSArithmeticDivideNoNaN
 Arithmetic function divide, returns 0 if the in2 is zero.
 element-wise computation of out = in1/in2
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 <p>
 \constant BNNSArithmeticMultiplyAdd
 Arithmetic function multiply-add
 element-wise computation of out = in1*in2 + in3
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticTernary structure
 <p>
 \constant BNNSArithmeticMinimum
 Arithmetic function minimum
 element-wise computation of out = min(in1, in2)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 <p>
 \constant BNNSArithmeticMaximum
 Arithmetic function maximum
 element-wise computation of out = max(in1, in2)
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 <p>
 \constant BNNSArithmeticSelect
 Arithmetic function select
 element-wise computation of out = in1 ? in2 : in3
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticTernary structure
 <p>
 \constant BNNSArithmeticAbs
 Arithmetic function absolute
 element-wise computation of absolute value
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 
 \constant BNNSArithmeticSign
 Arithmetic function sign
 element-wise computation of the sign (1 for positive, -1 for negative, 0 for zero)
 in-place computation is supported for forward and gradient
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 
 \constant BNNSArithmeticNegate
 Arithmetic function negate
 element-wise computation of out = -in1
 in-place computation is supported for forward and gradient
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 
 \constant BNNSArithmeticReciprocal
 Arithmetic function reciprocal
 element-wise computation of out = 1/in1
 in-place computation is supported for inference
 in-place computation is supported for gradient if activation function is identity
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 
 \constant BNNSArithmeticSquare
 Arithmetic function square
 element-wise computation of out = in1 * in1
 in-place computation is supported for inference only
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 
 \constant BNNSArithmeticFloorDivide
 Arithmetic function floor divide (quotient rounds towards negative infinity)
 element-wise computation of out = floor(in1 / in2)
 in-place computation is supported for inference
 no gradient computation is supported
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 
 \constant BNNSArithmeticTruncDivide
 Arithmetic function truncated divide (quotient rounds towards zero)
 element-wise computation of out = trunc(in1 / in2)
 in-place computation is supported for inference
 no gradient computation is supported
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 
 \constant BNNSArithmeticTruncRemainder
 Arithmetic function remainder of truncated division
 element-wise computation of remainder of (trunc) division
 in-place computation is supported for inference
 no gradient computation is supported
 arithmetic_function_fields must point to BNNSArithmeticBinary structure
 
 \constant BNNSArithmeticErf
 Arithmetic function erf
 element-wise computation of error function
 arithmetic_function_fields must point to BNNSArithmeticUnary structure
 
 */
/** enum BNNSArithmeticFunction */
public static final int

           BNNSArithmeticAdd                   = 0,
          BNNSArithmeticSubtract              = 1,
          BNNSArithmeticMultiply              = 2,
          BNNSArithmeticDivide                = 3,
          BNNSArithmeticSquareRoot            = 4,
          BNNSArithmeticReciprocalSquareRoot  = 5,
          BNNSArithmeticCeil                  = 6,
          BNNSArithmeticFloor                 = 7,
          BNNSArithmeticRound                 = 8,
          BNNSArithmeticSin                   = 9,
          BNNSArithmeticCos                   = 10,
          BNNSArithmeticTan                   = 11,
          BNNSArithmeticAsin                  = 12,
          BNNSArithmeticAcos                  = 13,
          BNNSArithmeticAtan                  = 14,
          BNNSArithmeticSinh                  = 15,
          BNNSArithmeticCosh                  = 16,
          BNNSArithmeticTanh                  = 17,
          BNNSArithmeticAsinh                 = 18,
          BNNSArithmeticAcosh                 = 19,
          BNNSArithmeticAtanh                 = 20,
          BNNSArithmeticPow                   = 21,
          BNNSArithmeticExp                   = 22,
          BNNSArithmeticExp2                  = 23,
          BNNSArithmeticLog                   = 24,
          BNNSArithmeticLog2                  = 25,
          BNNSArithmeticMultiplyNoNaN         = 26,
          BNNSArithmeticDivideNoNaN           = 27,
          BNNSArithmeticMultiplyAdd           = 28,
          BNNSArithmeticMinimum               = 29,
          BNNSArithmeticMaximum               = 30,
          BNNSArithmeticSelect                = 31,
          BNNSArithmeticAbs                   = 32,
          BNNSArithmeticSign                  = 33,
          BNNSArithmeticNegate                = 34,
          BNNSArithmeticReciprocal            = 35,
          BNNSArithmeticSquare                = 36,
          BNNSArithmeticFloorDivide           = 37,
          BNNSArithmeticTruncDivide           = 38,
          BNNSArithmeticTruncRemainder        = 39,
          BNNSArithmeticErf                   = 40;

/**
 <p>
 \abstract BNNS Descriptor Data type
 <p>
 \constant BNNSConstant
 A constant that does not have a gradient.
 the constant is broadcasted across batch samples if batch size > 1
 <p>
 \constant BNNSSample
 A sample such as input or output.
 batch size is taken into account and it has a different gradient for each sample in the batch.
 <p>
 \constant BNNSParameter
 A trainable parameter such as weights or bias.
 the parameter is broadcasted across batch samples if batch size > 1
 the parameter gradient is summed across the batch samples
 <p>
 */
/** enum BNNSDescriptorType */
public static final int

           BNNSConstant   = 0,
          BNNSSample     = 1,
          BNNSParameter  = 2;

/**
 <p>
 \abstract Optimizer layer function
 <p>
 \constant BNNSOptimizerFunctionSGDMomentum
 Update parameters according to Stochastic Gradient Descent (SGD) with momentum algorithm.
 <p>
 \constant BNNSOptimizerFunctionAdam
 Update parameters according to Adam algorithm.
 <p>
 \constant BNNSOptimizerFunctionRMSProp
 Update parameters according to RMSProp algorithm.
 <p>
 \constant BNNSOptimizerFunctionAdamW
 Update parameters according to AdamW algorithm.
 <p>
 \constant BNNSOptimizerFunctionAdamAMSGrad
 Update parameters according to AMSGrad variant of the Adam algorithm.
 <p>
 \constant BNNSOptimizerFunctionAdamWAMSGrad
 Update parameters according to AMSGrad variant of the AdamW algorithm.
 <p>
 \constant BNNSOptimizerFunctionSGDMomentumWithClipping
 Update parameters according to Stochastic Gradient Descent (SGD) with momentum algorithm using clipped gradient.
 <p>
 \constant BNNSOptimizerFunctionAdamWithClipping
 Update parameters according to Adam algorithm using clipped gradient.
 <p>
 \constant BNNSOptimizerFunctionRMSPropWithClipping
 Update parameters according to RMSProp algorithm using clipped gradient.
 <p>
 \constant BNNSOptimizerFunctionAdamWWithClipping
 Update parameters according to AdamW algorithm using clipped gradient.
 <p>
 \constant BNNSOptimizerFunctionAdamAMSGradWithClipping
 Update parameters according to AMSGrad variant of the Adam algorithm using clipped gradient.
 <p>
 \constant BNNSOptimizerFunctionAdamWAMSGradWithClipping
 Update parameters according to AMSGrad variant of the AdamW algorithm using clipped gradient.
 <p>
 */
/** enum BNNSOptimizerFunction */
public static final int

           BNNSOptimizerFunctionSGDMomentum  = 1,
          BNNSOptimizerFunctionAdam         = 2,
          BNNSOptimizerFunctionRMSProp      = 3,
          BNNSOptimizerFunctionAdamW        = 4,
          BNNSOptimizerFunctionAdamAMSGrad  = 5,
          BNNSOptimizerFunctionAdamWAMSGrad = 6,

          BNNSOptimizerFunctionSGDMomentumWithClipping  = 7,
          BNNSOptimizerFunctionAdamWithClipping         = 8,
          BNNSOptimizerFunctionRMSPropWithClipping      = 9,
          BNNSOptimizerFunctionAdamWWithClipping        = 10,
          BNNSOptimizerFunctionAdamAMSGradWithClipping  = 11,
          BNNSOptimizerFunctionAdamWAMSGradWithClipping = 12;

/**
 <p>
 \abstract Optimizer regularization function
 <p>
 \constant BNNSOptimizerRegularizationNone
 No Regularization
 <p>
 \constant BNNSOptimizerRegularizationL1
 L1 Regularization
 <p>
 \constant BNNSOptimizerRegularizationL2
 L2 Regularization
 <p>
 */
/** enum BNNSOptimizerRegularizationFunction */
public static final int

           BNNSOptimizerRegularizationNone  = 0,
          BNNSOptimizerRegularizationL1    = 1,
          BNNSOptimizerRegularizationL2    = 2;

/**
 <p>
 \abstract Optimizer SGD with momentum variant
 <p>
 \constant BNNSSGDMomentumVariant0
 V[t+1] = m*V[t] - g*lr
 Nesterov diabled: W[t+1] += V[t+1]
 Nesterov enabled: W[t+1] += V[t+1]+m*(V[t+1]-V[t])
 <p>
 \constant BNNSSGDMomentumVariant1
 V[t+1] = m*V[t]+g
 Nesterov disabled: W[t+1] -= V[t+1]*lr
 Nesterov enabled: W[t+1] -= (m*V[t+1]+g)*lr
 <p>
 \constant BNNSSGDMomentumVariant2
 Nesterov disabled:
 V[t+1] = m*V[t] + lr*g
 W[t+1] -= V[t+1]
 Nesterov enabled:
 V[t+1] = m*V[t]+g
 W[t+1] -= lr*(g+V[t+1]*m)
 */
/** enum BNNSOptimizerSGDMomentumVariant */
public static final int

           BNNSSGDMomentumVariant0  = 0,
          BNNSSGDMomentumVariant1  = 1,
          BNNSSGDMomentumVariant2  = 2;

/**
 <p>
 \abstract Optimizer clipping function
 <p>
 \constant BNNSOptimizerClippingNone
 No clipping
 <p>
 \constant BNNSOptimizerClippingByValue
 Clipping gradient values to specified min and max
 <p>
 \constant BNNSOptimizerClippingByNorm
 Clipping gradient values to a maximum L2-norm
 <p>
 \constant BNNSOptimizerClippingByGlobalNorm
 Clipping gradient values by the ratio of the specified L2-norm and the global L2-norm
 <p>
 */
/** enum BNNSOptimizerClippingFunction */
public static final int

           BNNSOptimizerClippingNone         = 0,
          BNNSOptimizerClippingByValue      = 1,
          BNNSOptimizerClippingByNorm       = 2,
          BNNSOptimizerClippingByGlobalNorm = 3;

/**
 <p>
 \abstract Type of norm
 <p>
 \constant BNNSL2Norm L-2 norm
 <p>
 */
/** enum BNNSNormType */
public static final int

           BNNSL2Norm        = 1;

/**
 <p>
 \abstract filter type
 <p>
 \constant BNNSConvolution
 Convolution filter
 <p>
 \constant BNNSFullyConnected
 Fully connected filter
 <p>
 \constant BNNSBatchNorm
 Batchnorm filter
 <p>
 \constant BNNSInstanceNorm
 Instance normalization filter
 <p>
 \constant BNNSLayerNorm
 Layer normalization filter
 <p>
 \constant BNNSGroupNorm
 Group normalization filter
 
 \constant BNNSTransposedConvolution
 Transposed Convolution filter
 
 \constant BNNSQuantization
 Quantization filter
 
 \constant BNNSArithmetic
 Arithmetic filter
 <p>
 */
/** enum BNNSFilterType */
public static final int

           BNNSConvolution            = 0,
          BNNSFullyConnected         = 1,
          BNNSBatchNorm              = 2,
          BNNSInstanceNorm           = 3,
          BNNSLayerNorm              = 4,
          BNNSGroupNorm              = 5,
          BNNSTransposedConvolution  = 6,
          BNNSQuantization           = 7,
          BNNSArithmetic             = 8;

/**
 <p>
 \abstract Reduction layer functions
 <p>
 \constant BNNSReduceFunctionMax
 max(X)
 <p>
 \constant BNNSReduceFunctionMin
 min(X)
 <p>
 \constant BNNSReduceFunctionArgMax
 arg max(X)
 i.e. the index of the maximum value
 <p>
 \constant BNNSReduceFunctionArgMin
 arg min(X)
 i.e. the index of the minimum value
 <p>
 \constant BNNSReduceFunctionMean
 mean(X) = sum(X) / size(X)
 <p>
 \constant BNNSReduceFunctionMeanNonZero
 Y = {X_i such as Weight_i != 0}
 MeanNonZero(X) = sum(Y) / size(Y)
 <p>
 \constant BNNSReduceFunctionSum
 sum(X)
 <p>
 \constant BNNSReduceFunctionSumSquare
 sum(X_i * X_i)
 <p>
 \constant BNNSReduceFunctionSumLog
 SumLog(X) = sum log(X_i + epsilon)
 <p>
 \constant BNNSReduceFunctionL1Norm
 L1Norm(X) = sum | X_i |
 i.e. sum of the absolute value of each element
 <p>
 \constant BNNSReduceFunctionLogicalOr
  AnyOf(X) = X_0 || X_1 || ... X_n
 <p>
 \constant BNNSReduceFunctionLogicalAnd
  AllOf(X) = X_0 && X_1 && ... X_n
 <p>
 \constant BNNSReduceFunctionL2Norm
 L2Norm(X) = sqrt(sum (X_i * X_i) )
 i.e. the Euclidean norm
 
 \constant BNNSReduceFunctionLogSumExp
 LogSumExp(X) = log(sum(exp(X_i)))
 
 \constant BNNSReduceFunctionProduct
 product(X)
 <p>
 \constant BNNSReduceFunctionLogSum
 log(sum(X))
 
 \constant BNNSReduceFunctionAny
  Alias of BNNSReduceFunctionLogicalOr
 <p>
 \constant BNNSReduceFunctionAll
  Alias of BNNSReduceFunctionLogicalAnd
 <p>
 \constant BNNSReduceFunctionNone
  Just copies input to output.
  This function is provided for use in operations with an optional reduction operation
  where it is used to indicate no reduction operation is required. It is not supported
  in the reduction layer (users should just use BNNSCopy() or a suitable contraction layer
  if they wish to perform a copy or conversion operation).
 */
/** enum BNNSReduceFunction */
public static final int

           BNNSReduceFunctionMax          = 0,
          BNNSReduceFunctionMin          = 1,
          BNNSReduceFunctionArgMax       = 2,
          BNNSReduceFunctionArgMin       = 3,
          BNNSReduceFunctionMean         = 4,
          BNNSReduceFunctionMeanNonZero  = 5,
          BNNSReduceFunctionSum          = 6,
          BNNSReduceFunctionSumSquare    = 7,
          BNNSReduceFunctionSumLog       = 8,
          BNNSReduceFunctionL1Norm       = 9,
          BNNSReduceFunctionLogicalOr    = 10,
          BNNSReduceFunctionLogicalAnd   = 11,
          BNNSReduceFunctionL2Norm       = 12,
          BNNSReduceFunctionLogSumExp    = 13,
          BNNSReduceFunctionProduct      = 14,
          BNNSReduceFunctionNone         = 15,
          BNNSReduceFunctionLogSum       = 16,

          // Friendly aliases
          BNNSReduceFunctionAny           = BNNSReduceFunctionLogicalOr,
          BNNSReduceFunctionAll           = BNNSReduceFunctionLogicalAnd;

/**
 \discussion LSTM layer flags
 \constant BNNSLayerFlagsLSTMBidirectional - enable bidirectional LSTM
 \constant BNNSLayerFlagsLSTMDefaultActivations - ignore forget_gate_layer.activation, input_gate_layer.activation, candidate_gate_layer.activation, output_gate_layer.activation and hidden_activation and use default activations (see BNNSLayerParametersLSTM)
 */
/** enum BNNSLayerFlags */
public static final int

           BNNSLayerFlagsLSTMBidirectional       = 0x0001,
          BNNSLayerFlagsLSTMDefaultActivations  = 0x0002;

/**
 <p>
 \abstract Data layout and dimension
 <p>
 \discussion The layout defines the nature of the data stored in a N-dimensional array
 Introduced in macOS 10.15, iOS 13, tvOS 13, watchOS 6.
 <p>
 Note that we require that stride is always increasing, i.e. stride[i+1] >= stride[i].
 As such, the formulae given below for the location of an element uniquely determine what each stride value should be
 for a given memory layout.
 <p>
 if stride[k] is 0, it's replaced by the default value corresponding to contiguous memory. If size[k] corresponds to stride[k], as
 is true for most (but not all) of the layouts below, these would be:
 stride[k] = 1 for k = 0
 stride[k] = size[k-1] * stride[k-1] for k > 0
 <p>
 \constant BNNSDataLayoutVector
 One-dimensional vector.
 size[0] is the dimension of the vector. Value (i) is at index i * stride[0]
 <p>
 \constant BNNSDataLayoutRowMajorMatrix
 Two-dimensional matrix. Value (row, col) is at index col * stride[0] + row * stride[1]
 size[0] is the number of columns.
 size[1] is the number of rows.
 <p>
 \constant BNNSDataLayoutColumnMajorMatrix
 Two-dimensional matrix. Value (row, col) is at index row * stride[0] + col * stride[1]
 size[0] is the number of rows.
 size[1] is the number of columns.
 <p>
 \constant BNNSDataLayoutFullyConnectedSparse
 Two-dimensional array stored in sparse packed format.
 Use BNNSNDArrayGetSparseParameters() to determine the actual sparse parameters
 <p>
 \constant BNNSDataLayoutImageCHW
 Three-dimensional image stack. Value (x,y,channel) is at index x * stride[0] + y * stride[1] + channel * stride[2]
 size[0] is the image width (pixels).
 size[1] is the image height (pixels).
 size[2] is the number of channels.
 <p>
 \constant BNNSDataLayoutSNE
 Three dimensional tensor. Value (e, n, s) is at index e * stride[0] + n * stride[1] + s * stride[2].
 size[0] is E, the embedding dimension
 size[1] is N, the batch size
 size[2] is S, the sequence length
 <p>
 \constant BNNSDataLayoutNSE
 Three dimensional tensor. Value (e, s, n) is at index e * stride[0] + s * stride[1] + n * stride[2].
 size[0] is E, the embedding dimension
 size[1] is S, the sequence length
 size[2] is N, the batch size
 <p>
 \constant BNNSDataLayoutConvolutionWeightsOIHW
 Four-dimensional array of convolution weights.
 Value (kx,ky,InChannel,OutChannel) is at index kx * stride[0] + ky * stride[1] + InChannel * stride[2] + OutChannel * stride[3]
 size[0] is the convolution kernel width (pixels).
 size[1] is the convolution kernel height (pixels).
 size[2] is the number of input channels.
 size[3] is the number of output channels.
 <p>
 \constant BNNSDataLayoutConvolutionWeightsOIHrWr
 Four-dimensional array of rotated convolution weights.
 Value (kx,ky,InChannel,OutChannel) is at index (kw - 1 - kx) * stride[0] + (kh - 1 - ky) * stride[1] +  InChannel * stride[2] + OutChannel * stride[3]
 size[0] is the convolution kernel width (pixels).
 size[1] is the convolution kernel height (pixels).
 size[2] is the number of input channels.
 size[3] is the number of output channels.
 kw is size[0] and kx is between 0 to kw-1.
 kh is size[1] and ky is between 0 to kh-1.
 <p>
 \constant BNNSDataLayoutConvolutionWeightsIOHrWr
 Four-dimensional array of rotated convolution weights.
 Value (kx,ky,InChannel,OutChannel) is at index (kw - 1 - kx) * stride[0] + (kh - 1 - ky) * stride[1] + OutChannel * stride[2] + InChannel * stride[3]
 size[0] is the convolution kernel width (pixels).
 size[1] is the convolution kernel height (pixels).
 size[2] is the number of output channels.
 size[3] is the number of input channels.
 kw is size[0] and kx is between 0 to kw-1.
 kh is size[1] and ky is between 0 to kh-1.
 <p>
 \constant BNNSDataLayoutConvolutionWeightsOIHW_Pack32
 Four-dimensional array of packed convolution weights with 32 output channel packing and 128 Byte array address alignment.
 <p>
 A value position in the packed array can be determined in the following way:
 kernel_width is the kernel width
 kernel_height is the kernel height
 input_channels is the number of input channels
 output_channels is the number of output channels
 OutChannelGroup = OutChannel/32
 OutChannelPositionInGroup = OutChannel%32
 Value (kx,ky,InChannel,OutChannel) is at index OutChannelPositionInGroup + kw * 32 + ky * kernel_width * 32 + InChannel * kernel_height * kernel_width * 32 + OutChannelGroup * input_channels * kernel_height * kernel_width * 32
 <p>
 The inner most output channel packing must alway have a size of 32 elements, even in the last OutChannelGroup where number of output channels may be less than 32.
 The minimal weight array size in bytes is: 32*kernel_width*kernel_height*input_channels*((output_channels+31)/32)*(weight element size in bytes)
 Failing to allocate the minimal weight array size may result in runtime error.
 size and stride structures must match BNNSDataLayoutConvolutionWeightsOIYX layout.
 memory layout must be contiguous, such that stride[0] is either 1 or 0.
 <p>
 \constant BNNSDataLayoutMHA_DHK
 Three-dimensional array of multihead-attention weights. Value (k, d, h) is at d * stride[0] + h * stride[1] + k * stride[2]
 size[0] is d_model/d_key/d_value (depending on weight matrix being specified)
 size[1] is d_key/d_value (depending on weight matrix being specified)
 size[2] is the number of heads
 <p>
 \constant BNNSDataLayout2DLastMajor
 Two-dimensional matrix. Value (i, j) is at index i * stride[0] + j * stride[1]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 (This is the BLAS/LAPACK column major equivalent - this layout matches BNNSDataLayoutColumnMajorMatrix)
 <p>
 \constant BNNSDataLayout2DFirstMajor
 Two-dimensional matrix. Value (i, j) is at index j * stride[0] + i * stride[1]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 (This is the BLAS/LAPACK row major equivalent - note that BNNSDataLayoutRowMajorMatrix uses different ordering of size[])
 <p>
 \constant BNNSDataLayout3DLastMajor
 Three-dimensional tensor. Value (i, j, k) is at index i * stride[0] + j * stride[1] + k * stride[2]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 <p>
 \constant BNNSDataLayout3DFirstMajor
 Three-dimensional tensor. Value (i, j, k) is at index k * stride[0] + j * stride[1] + i * stride[2]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 <p>
 \constant BNNSDataLayout4DLastMajor
 Four-dimensional tensor. Value (i, j, k, l) is at index i * stride[0] + j * stride[1] +
     k * stride[2] + l * stride[3]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 size[3] is the size of the fourth dimension (l).
 <p>
 \constant BNNSDataLayout4DFirstMajor
 Four-dimensional tensor. Value (i, j, k, l) is at index l * stride[0] + k * stride[1] +
     j * stride[2] + i * stride[3]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 size[3] is the size of the fourth dimension (l).
 <p>
 \constant BNNSDataLayout5DLastMajor
 Five-dimensional tensor. Value (i, j, k, l, m) is at index i * stride[0] + j * stride[1] +
     k * stride[2] + l * stride[3] + m * stride[4]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 size[3] is the size of the fourth dimension (l).
 size[4] is the size of the fifth dimension (m).
 <p>
 \constant BNNSDataLayout5DFirstMajor
 Five-dimensional tensor. Value (i, j, k, l, m) is at index m * stride[0] + l * stride[1] +
     k * stride[2] + j * stride[3] + i * stride[4]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 size[3] is the size of the fourth dimension (l).
 size[4] is the size of the fifth dimension (m).
 <p>
 \constant BNNSDataLayout6DLastMajor
 Six-dimensional tensor. Value (i, j, k, l, m, n) is at index i * stride[0] + j * stride[1] +
     k * stride[2] + l * stride[3] + m * stride[4] + n * stride[5]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 size[3] is the size of the fourth dimension (l).
 size[4] is the size of the fifth dimension (m).
 size[5] is the size of the sixth dimension (n).
 <p>
 \constant BNNSDataLayout6DFirstMajor
 Six-dimensional tensor. Value (i, j, k, l, m, n) is at index n * stride[0] + m * stride[1] +
     l * stride[2] + k * stride[3] + j * stride[4] + i * stride[5]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 size[3] is the size of the fourth dimension (l).
 size[4] is the size of the fifth dimension (m).
 size[5] is the size of the sixth dimension (n).
 <p>
 \constant BNNSDataLayout7DLastMajor
 Seven-dimensional tensor. Value (i, j, k, l, m, n, o) is at index i * stride[0] + j * stride[1] +
     k * stride[2] + l * stride[3] + m * stride[4] + n * stride[5] + o * stride[6]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 size[3] is the size of the fourth dimension (l).
 size[4] is the size of the fifth dimension (m).
 size[5] is the size of the sixth dimension (n).
 size[6] is the size of the seventh dimension (o).
 <p>
 \constant BNNSDataLayout7DFirstMajor
 Seven-dimensional tensor. Value (i, j, k, l, m, n, o) is at index o * stride[0] + n * stride[1] +
     m * stride[2] + l * stride[3] + k * stride[4] + j * stride[5] + i * stride[6]
 size[0] is the size of the first dimension (i).
 size[1] is the size of the second dimension (j).
 size[2] is the size of the third dimension (k).
 size[3] is the size of the fourth dimension (l).
 size[4] is the size of the fifth dimension (m).
 size[5] is the size of the sixth dimension (n).
 size[6] is the size of the seventh dimension (o).
 <p>
 \constant BNNSDataLayout8DLastMajor
 Eight-dimensional tensor. Value (i, j, k, l, m, n, o, p) is at index
     i * stride[0] + j * stride[1] + k * stride[2] + l * stride[3] +
     m * stride[4] + n * stride[5] + o * stride[6] + p * stride[7]
 size[0] is the size of the first   dimension (i).
 size[1] is the size of the second  dimension (j).
 size[2] is the size of the third   dimension (k).
 size[3] is the size of the fourth  dimension (l).
 size[4] is the size of the fifth   dimension (m).
 size[5] is the size of the sixth   dimension (n).
 size[6] is the size of the seventh dimension (o).
 size[7] is the size of the eighth  dimension (p).
 <p>
 \constant BNNSDataLayout8DFirstMajor
 Eight-dimensional tensor. Value (i, j, k, l, m, n, o, p) is at index
     p * stride[0] + o * stride[1] + n * stride[2] + m * stride[3] +
     l * stride[4] + k * stride[5] + j * stride[6] + i * stride[7]
 size[0] is the size of the first   dimension (i).
 size[1] is the size of the second  dimension (j).
 size[2] is the size of the third   dimension (k).
 size[3] is the size of the fourth  dimension (l).
 size[4] is the size of the fifth   dimension (m).
 size[5] is the size of the sixth   dimension (n).
 size[6] is the size of the seventh dimension (o).
 size[7] is the size of the eighth  dimension (p).
 <p>
 */
/** enum BNNSDataLayout */
public static final int

   // 1-dimensional layouts (are identical and only included for ease of use and consistent numbering)
  BNNSDataLayoutVector                         = 0x10000,
  BNNSDataLayout1DLastMajor                    = 0x18000,
  BNNSDataLayout1DFirstMajor                   = 0x18001,

  // 2-dimensional layouts
  BNNSDataLayoutRowMajorMatrix                 = 0x20000,
  BNNSDataLayoutColumnMajorMatrix              = 0x20001,
  BNNSDataLayout2DLastMajor                    = 0x28000,
  BNNSDataLayout2DFirstMajor                   = 0x28001,
  BNNSDataLayoutFullyConnectedSparse           = 0x21001,

  // 3-dimensional layouts
  BNNSDataLayoutImageCHW                       = 0x30000,
  BNNSDataLayoutSNE                            = 0x30001,
  BNNSDataLayoutNSE                            = 0x30002,
  BNNSDataLayoutMHA_DHK                        = 0x30003,
  BNNSDataLayout3DLastMajor                    = 0x38000,
  BNNSDataLayout3DFirstMajor                   = 0x38001,

  // 4-dimensional layouts
  BNNSDataLayoutConvolutionWeightsOIHW         = 0x40000,
  BNNSDataLayoutConvolutionWeightsOIHrWr       = 0x40001,
  BNNSDataLayoutConvolutionWeightsIOHrWr       = 0x40002,
  BNNSDataLayoutConvolutionWeightsOIHW_Pack32  = 0x40010,
  BNNSDataLayout4DLastMajor                    = 0x48000,
  BNNSDataLayout4DFirstMajor                   = 0x48001,

  // 5-dimensional layouts
  BNNSDataLayout5DLastMajor                    = 0x58000,
  BNNSDataLayout5DFirstMajor                   = 0x58001,

  // 6-dimensional layouts
  BNNSDataLayout6DLastMajor                    = 0x68000,
  BNNSDataLayout6DFirstMajor                   = 0x68001,

  // 7-dimensional layouts
  BNNSDataLayout7DLastMajor                    = 0x78000,
  BNNSDataLayout7DFirstMajor                   = 0x78001,

  // 8-dimensional layouts
  BNNSDataLayout8DLastMajor                    = 0x88000,
  BNNSDataLayout8DFirstMajor                   = 0x88001;

/** \abstract Interpolation methods for resize.
 *
 * \constant BNNSInterpolationMethodNearest - Use nearest neighbor interpolation, suitable for any number of interpolation dimensions.
 * \constant BNNSInterpolationMethodLinear - Use linear or bilinear interpolation depending on number of resized dimensions. Requires that we are interpolating in at most two dimensions.
 */
/** enum BNNSInterpolationMethod */
public static final int

           BNNSInterpolationMethodNearest  = 0,
          BNNSInterpolationMethodLinear   = 1;

/** \abstract Interpolation sampling mode.
 * This parameter controls how the grid is sampled. If the input grid is [0, Xin-1] (corresponding to an input size of Xin),
 * and if the output size is Xout, then the grid points are sampled in the following manner
 *
 * \constant BNNSLinearSamplingDefault                   - spacing = (Xin - Xin/Xout) / (Xout - 1),
 *                                          grid_point[i] = min(Xin-1, max(0, i*spacing)), for i=0,1,...,Xout-1
 * \constant BNNSLinearSamplingAlignCorners         - Same as "STRICT_ALIGN_CORNERS" unless Xout=1,
 *                                          in which case, grid_point[0] = (Xin-1) / 2, if Xout==1
 * \constant BNNSLinearSamplingUnalignCorners     - spacing = Xin / Xout, grid_point[i] = min(Xin - 1, max(0, i*spacing + 0.5*spacing - 0.5)), for i=0,1,...,Xout-1
 * \constant BNNSLinearSamplingStrictAlignCorners - spacing = (Xin - 1) / (Xout - 1), grid_point[i] = min(Xin-1, max(0, i*spacing)), for i=0,1,...,Xout-1
 * \constant BNNSLinearSamplingOffsetCorners        - delta = max(1, Xin - 1) / Xout, spacing = ((Xout - 1) * delta) / (Xout - 1),
 *                                          grid_point[i] = min(Xin-1, max(0, 0.5*delta + i*spacing)), for i=0,1,...,Xout-1
 */
/** enum BNNSLinearSamplingMode */
public static final int

           BNNSLinearSamplingDefault             = 0,
          BNNSLinearSamplingAlignCorners        = 1,
          BNNSLinearSamplingUnalignCorners      = 2,
          BNNSLinearSamplingStrictAlignCorners  = 3,
          BNNSLinearSamplingOffsetCorners       = 4;

/** \abstract
 * Specifies the convention for specifying the four bounding box coordinates for an 2D image
 *
 *  \constant BNNSCornersHeightFirst      - [h_start, w_start, h_end, w_end]
 *  \constant BNNSCornersWidthFirst       - [w_start, h_start, w_end, h_end]
 *  \constant BNNSCenterSizeHeightFirst - [h_center, w_center, box_height, box_width]
 *  \constant BNNSCenterSizeWidthFirst  - [w_center, h_center, box_width, box_height]
 */
/** enum BNNSBoxCoordinateMode */
public static final int

           BNNSCornersHeightFirst          = 0,
          BNNSCornersWidthFirst           = 1,
          BNNSCenterSizeHeightFirst       = 2,
          BNNSCenterSizeWidthFirst        = 3;


/** \abstract padding modes for padding.
 *
 * \constant BNNSPaddingModeConstant    - padded area is filled with constant value specified by the user
 * \constant BNNSPaddingModeReflect       - padded area is filled up so that the padded area and the adjacent area with input data form an odd-symmetric pattern:  x x  A B C ->  C B A  B C
 * \constant BNNSPaddingModeSymmetric - padded area is filled up so that the padded area and the adjacent area with input data form an even-symmetric pattern: x x A B -> B A A B
*/
/** enum BNNSPaddingMode */
public static final int
     BNNSPaddingModeConstant   = 0,
    BNNSPaddingModeReflect    = 1,
    BNNSPaddingModeSymmetric  = 2;

/**
<p>
\abstract Relational layer operation type
<p>
\constant BNNSRelationalOperatorEqual
Perform element-by-element comparison of A == B
<p>
\constant BNNSRelationalOperatorLess
Perform element-by-element comparison of A < B
<p>
\constant BNNSRelationalOperatorLessEqual
Perform element-by-element comparison of A <= B
<p>
\constant BNNSRelationalOperatorGreater
Perform element-by-element comparison of A > B
<p>
\constant BNNSRelationalOperatorGreaterEqual
Perform element-by-element comparison of A >= B
<p>
\constant BNNSRelationalOperatorNotEqual
Perform element-by-element comparison of A != B
<p>
\constant BNNSRelationalOperatorLogicalAND
Perform element-by-element A && B
<p>
\constant BNNSRelationalOperatorLogicalOR
Perform element-by-element A || B
<p>
\constant BNNSRelationalOperatorLogicalNOT
Perform element-by-element  !A
<p>
\constant BNNSRelationalOperatorLogicalNAND
Perform element-by-element !(A && B)
<p>
\constant BNNSRelationalOperatorLogicalNOR
Perform element-by-element !(A || B)
<p>
\constant BNNSRelationalOperatorLogicalXOR
Perform element-by-element A ^ B
<p>
*/
/** enum BNNSRelationalOperator */
public static final int
     BNNSRelationalOperatorEqual         = 0,
    BNNSRelationalOperatorLess          = 1,
    BNNSRelationalOperatorLessEqual     = 2,
    BNNSRelationalOperatorGreater       = 3,
    BNNSRelationalOperatorGreaterEqual  = 4,
    BNNSRelationalOperatorNotEqual      = 5,
    BNNSRelationalOperatorLogicalAND    = 6,
    BNNSRelationalOperatorLogicalOR     = 7,
    BNNSRelationalOperatorLogicalNOT    = 8,
    BNNSRelationalOperatorLogicalNAND   = 9,
    BNNSRelationalOperatorLogicalNOR    = 10,
    BNNSRelationalOperatorLogicalXOR    = 11;

/** \abstract Pointer extraction specifiers
 *
 *  \discussion
 *  These enums are passed to BNNSGetPointer() to specify what pointer should be returned.
 *
 *  \constant BNNSPointerSpecifierAlpha - alpha parameter associated with layer (supported by: activation)
 *  \constant BNNSPointerSpecifierBeta - beta parameter associated with layer (supported by: activation)
 */
/** enum BNNSPointerSpecifier */
public static final int

           BNNSPointerSpecifierAlpha  = 0,
          BNNSPointerSpecifierBeta   = 1;

/** \abstract Flags to control behaviors on BNNSNDArrayDescriptors
 *
 *  \constant BNNSNDArrayFlagBackpropSet - During back propogation, the elements of this ndarray are overwritten by the jacobian.
 *            If the NDArray does not represent a backpropgation gradient calculated by the function, this variable is ignored (i.e. this will typically
 *            only be used for output variables with names ending _delta).
 *  \constant BNNSNDArrayFlagBackpropAccumulate - During back propogation, the value of the jacobian is added to the elements of this ndarray
 *            (i.e. if the value is input_delta on entry to the function and dL/dx is the jacobian, then on exit it will be input_delta + dL/dx).
 *            If the NDArray does not represent a backpropgation gradient calculated by the function, this variable is ignored (i.e. this will typically
 *            only be used for output variables with names ending _delta).
 */
/** enum BNNSNDArrayFlags */
public static final int

           BNNSNDArrayFlagBackpropSet          = 0,
          BNNSNDArrayFlagBackpropAccumulate   = 1;

/** \abstract Flags to control behavior of Embedding layers
 *
 *  \constant BNNSEmbeddingFlagScaleGradientByFrequency - If true, gradients calculated during the backward pass are scaled
 *            based on the number of occurrence of the corresponding index in the input.
 */
/** enum BNNSEmbeddingFlags */
public static final int
           BNNSEmbeddingFlagScaleGradientByFrequency     = 1;

/**
 <p>
 \abstract Quantizer function
 <p>
 \constant BNNSQuantizerFunctionQuantize
 y = scale*x + bias
 <p>
 \constant BNNSQuantizerFunctionDequantize
 y = (x-bias)/scale
 <p>
 */
/** enum BNNSQuantizerFunction */
public static final int
           BNNSQuantizerFunctionQuantize               = 0,
          BNNSQuantizerFunctionDequantize             = 1;


/** \abstract Random number generation methods
 *
 *  \discussion
 *  This method should not be used for cryptographic applications.
 *
 *  \constant BNNSRandomGeneratorMethodAES_CTR
 *  Implementation based on the AES hash of a counter.
 */
/** enum BNNSRandomGeneratorMethod */
public static final int
           BNNSRandomGeneratorMethodAES_CTR      = 0;

/**
 \constant BNNSSparsityTypeUnstructured - no special pattern in the sparsity
 <p>
 */
/** enum BNNSSparsityType */
public static final int
           BNNSSparsityTypeUnstructured = 0x0;

/** \abstract Target System values for BNNSGetBestDataLayout* functions
 *  \discussion
 *  Due to architectural and microarchitectural changes between different types and generations of apple devices, the optimal packing
 *  of data varies from device to device. In order to determine the optimal repacking for a given device, the user may call the
 *  BNNSGetBestDataLayout* family of functions. These functions take an argument representing the Target System from the values
 *  provided by this enumeration.
 *
 *  \constant BNNSTargetSystemGeneric         - Provide a single layout that is support and will provide reasonable performance on most devices
*/
/** enum BNNSTargetSystem */
public static final int
           BNNSTargetSystemGeneric      = 0;

/** \abstract Shuffle type for BNNSShuffle function
 *
 *  \constant BNNSShuffleTypePixelShuffleNCHW
 *  pixel shuffle for NCHW format, equivalent to depth-to-space in "CRD" mode, i.e.,
 *  rearranges elements in a tensor of shape (N,C×rxr,H,W) to a tensor of shape (N,C,H×r,W×r), where r is an upscale factor
 *
 *  \constant BNNSShuffleTypePixelUnshuffleNCHW
 *  pixel unshuffle for NCHW format, reverse of pixel shuffle, i.e.,
 *  reverses the PixelShuffle operation by rearranging elements in a tensor of shape (N,C,H×r,W×r) to a tensor of shape (N,C×rxr,H,W),
 *  where r is a downscale factor
 *
 *  \constant BNNSShuffleTypeDepthToSpaceNCHW
 *  {@code depth_to_space} for NCHW format, reverse of {@code space_to_depth} for NCHW.
 *  {@code depth_to_space} rearranges elements from (N, Cxbxb, H, W) --> (N, C, Hxb, Wxb), where b is the block size
 *  Elements are rearranged different to {@code BNNSShuffleTypePixelShuffleNCHW} for cases
 *  where the number of output channels is > 1. e.g., (1, 12, 3, 3) --> (1, 3, 6, 6)
 *
 *  \constant  BNNSShuffleTypeSpaceToDepthNCHW
 *  {@code space_to_depth} for NCHW format, reverse of {@code depth_to_space},
 *  rearranges elements to enable atrous convolution to be performed using dense convolution operations
 */

/** enum BNNSShuffleType */
public static final int
           BNNSShuffleTypePixelShuffleNCHW     = 0,
          BNNSShuffleTypePixelUnshuffleNCHW   = 1,
          BNNSShuffleTypeDepthToSpaceNCHW     = 2,
          BNNSShuffleTypeSpaceToDepthNCHW     = 3;

// #if !__has_include( <Availability.h> )
// #undef __API_AVAILABLE
// #undef __API_DEPRECATED_WITH_REPLACEMENT
// #undef __API_AVAILABLE
// #endif

// #undef BNNS_ENUM // remove local defintion of BNNS_ENUM

// #endif /* __BNNS_CONSTANTS_HEADER__ */


// Parsed from bnns_structures.h

//
//  bnns_structures.h
//  BasicNeuralNetworkSubroutines
//
//  Copyright © 2017 Apple Inc. All rights reserved.
//

// #ifndef __BNNS_STRUCTURES_HEADER__
// #define __BNNS_STRUCTURES_HEADER__

// #include <stddef.h>
// #include <stdint.h>
// #include <stdbool.h>
// #include <sys/types.h>
// #include "bnns_constants.h"

// #if __has_include( <Availability.h> )
// # include <Availability.h>
// #else
// # define __API_AVAILABLE(...)
// # define __API_DEPRECATED_WITH_REPLACEMENT(...)
// # define __API_DEPRECATED(...)
// #endif

// #if __has_feature(assume_nonnull)
// #else
//   # define _Null_unspecified
// # define _Nullable
// # define _Nonnull
// #endif

// #pragma mark - User-provided memory functions

/**
<p>
\abstract Type for user-provided memory allocation function
<p>
\discussion Should conform to posix_memalign(), and must be compatible with the memory deallocation function.
<p>
@param memptr Pointer to a <tt>(void *)</tt> receiving the address of the allocated memory.
@param alignment Requested alignment, must be a power of 2, and at least <tt>sizeof(void *)</tt>.
@param size Number of bytes to allocate.
<p>
@return 0 on success, or an error value on failure.
<p>
*/
public static class BNNSAlloc extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    BNNSAlloc(Pointer p) { super(p); }
    protected BNNSAlloc() { allocate(); }
    private native void allocate();
    public native int call(@Cast("void**") PointerPointer memptr, @Cast("size_t") long alignment, @Cast("size_t") long size);
}

/**
 <p>
 \abstract Type for user-provided memory deallocation function
 <p>
 \discussion Should conform to free(), and must be compatible with the memory allocation function.
 <p>
 @param ptr Address of the block to release.
 <p>
 */
public static class BNNSFree extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    BNNSFree(Pointer p) { super(p); }
    protected BNNSFree() { allocate(); }
    private native void allocate();
    public native void call(Pointer ptr);
}

// #pragma mark - Data formats

/**
 <p>
 \abstract Common activation function parameters
 <p>
 \field function Activation function
 \field alpha Parameter to the activation function
 \field beta Parameter to the activation function
 <p>
 \field iscale Scale for integer functions (macOS 10.13, iOS 11, tvOS 11, watchOS 4)
 \field ioffset Offset for integer functions (macOS 10.13, iOS 11, tvOS 11, watchOS 4)
 \field ishift Shift for integer functions (macOS 10.13, iOS 11, tvOS 11, watchOS 4)
 <p>
 \field iscale_per_channel Scale per channel for integer functions (macOS 10.13, iOS 11, tvOS 11, watchOS 4)
 \field ioffset_per_channel Offset per channel for integer functions (macOS 10.13, iOS 11, tvOS 11, watchOS 4)
 \field ishift_per_channel Shift per channel for integer functions (macOS 10.13, iOS 11, tvOS 11, watchOS 4)
<p>
*/
public static class BNNSActivation extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSActivation() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSActivation(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSActivation(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSActivation position(long position) {
        return (BNNSActivation)super.position(position);
    }
    @Override public BNNSActivation getPointer(long i) {
        return new BNNSActivation((Pointer)this).offsetAddress(i);
    }


  public native @Cast("BNNSActivationFunction") int function(); public native BNNSActivation function(int setter);
  public native float alpha(); public native BNNSActivation alpha(float setter);
  public native float beta(); public native BNNSActivation beta(float setter);

  // The following fields are available in macOS 10.13, iOS 11, tvOS 11, watchOS 4

  public native int iscale(); public native BNNSActivation iscale(int setter);
  public native int ioffset(); public native BNNSActivation ioffset(int setter);
  public native int ishift(); public native BNNSActivation ishift(int setter);

  public native @Const IntPointer iscale_per_channel(); public native BNNSActivation iscale_per_channel(IntPointer setter);
  public native @Const IntPointer ioffset_per_channel(); public native BNNSActivation ioffset_per_channel(IntPointer setter);
  public native @Const IntPointer ishift_per_channel(); public native BNNSActivation ishift_per_channel(IntPointer setter);

}

public static final int BNNS_MAX_TENSOR_DIMENSION = 8;

/**
 <p>
 \abstract Generic N-dimensional array
 <p>
 \discussion This type  is used to represent an N-dimensional array of values (N=1,2,3,4).
 The nature and dimension of the data is determined by the layout field.
 Introduced in macOS 10.15, iOS 13, tvOS 13, watchOS 6.
 <p>
 \field flags is used to control some behaviors of the NDArray
 \field layout defines the dimension (n) of the array, and how data is stored
 \field size is the number of values in each dimension; only the first n values are used
 \field stride is the increment (in values) between a value and the next in each dimension; only the first n values are used
        A stride value of 0 is interpreted to mean that values are contiguous in this axis (i.e. is treated as stride[i] = size[i-1]*stride[i-1],
        or stride[0] = 1 for the first dimension).
 <p>
 \field data points to the data; can be NULL
 \field data_type defines the size and type of the values stored in data
 <p>
 \field table_data points to the lookup table; used only when data_type is Indexed<N>
 \field table_data_type defines the size and type of the values stored in table_data; used only when data_type is Indexed<K>
 <p>
 \field data_scale is used in the conversion of integer values to floating point; used only when data_type is Int<K> or UInt<K>
 \field data_bias is used in the conversion of integer values to floating point; used only when data_type is Int<K> or UInt<K>
 <p>
 */
public static class BNNSNDArrayDescriptor extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSNDArrayDescriptor() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSNDArrayDescriptor(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSNDArrayDescriptor(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSNDArrayDescriptor position(long position) {
        return (BNNSNDArrayDescriptor)super.position(position);
    }
    @Override public BNNSNDArrayDescriptor getPointer(long i) {
        return new BNNSNDArrayDescriptor((Pointer)this).offsetAddress(i);
    }


  public native @Cast("BNNSNDArrayFlags") int flags(); public native BNNSNDArrayDescriptor flags(int setter);
  public native @Cast("BNNSDataLayout") int layout(); public native BNNSNDArrayDescriptor layout(int setter);

  public native @Cast("size_t") long size(int i); public native BNNSNDArrayDescriptor size(int i, long setter);
  @MemberGetter public native @Cast("size_t*") SizeTPointer size();
  public native @Cast("size_t") long stride(int i); public native BNNSNDArrayDescriptor stride(int i, long setter);
  @MemberGetter public native @Cast("size_t*") SizeTPointer stride();

  public native Pointer data(); public native BNNSNDArrayDescriptor data(Pointer setter);
  public native @Cast("BNNSDataType") int data_type(); public native BNNSNDArrayDescriptor data_type(int setter);

  public native Pointer table_data(); public native BNNSNDArrayDescriptor table_data(Pointer setter);
  public native @Cast("BNNSDataType") int table_data_type(); public native BNNSNDArrayDescriptor table_data_type(int setter);

  public native float data_scale(); public native BNNSNDArrayDescriptor data_scale(float setter); // 0.0f value will be set to 1.0f during computation
  public native float data_bias(); public native BNNSNDArrayDescriptor data_bias(float setter);

}

/**
 <p>
 \abstract Generic Tensor
 <p>
 \discussion
 This type presents a simpler interface than {@code BNNSNDArrayDescriptor} that avoids unnecessary complexity that
 is not required for the BNNSGraph family of APIs.
 <p>
 \field {@code data_type} - type of data stored in this tensor
 \field {@code rank} - rank of the tensor, must satisfy {@code 0 <= rank <= BNNS_MAX_TENSOR_DIMENSION}
 \field {@code shape} - the first {@code rank} elements give the shape of the tensor. Negative values indicate the dimension has
        unspecified dynamic size.
 \field {@code stride}- the first {@code rank} elements give the strides of each dimension. {@code stride[d]} corresponds to {@code shape[d]}. 
        Negative values indicate the stride is unspecified (normally due to the presence of a dynamic shape).
        Unlike BNNSNDArrayDescriptor, a stride of 0 is not interpreted to mean contiguous, but is taken as a literal 0.
        Unless otherwise stated, all BNNS routines expect data to be in first-major layout ({@code stride[d] >= stride[d+1]}).
 \field {@code data} - pointer to memory containing the actual values of the tensor
 \field {@code data_size_in_bytes} - the extent of {@code data}, used for bounds checking
 \field {@code name} - optional name of this tensor. This field is not read by BNNS (but will be set to a pointer into the IR for
        any BNNSTensors returned by BNNS) and is provided as a debugging aide only.
 */
public static class BNNSTensor extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSTensor() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSTensor(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSTensor(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSTensor position(long position) {
        return (BNNSTensor)super.position(position);
    }
    @Override public BNNSTensor getPointer(long i) {
        return new BNNSTensor((Pointer)this).offsetAddress(i);
    }


  public native @Cast("BNNSDataType") int data_type(); public native BNNSTensor data_type(int setter);

  public native @Cast("uint8_t") byte rank(); public native BNNSTensor rank(byte setter);
  public native @Cast("ssize_t") long shape(int i); public native BNNSTensor shape(int i, long setter);
  @MemberGetter public native @Cast("ssize_t*") SizeTPointer shape();
  public native @Cast("ssize_t") long stride(int i); public native BNNSTensor stride(int i, long setter);
  @MemberGetter public native @Cast("ssize_t*") SizeTPointer stride();

  public native Pointer data(); public native BNNSTensor data(Pointer setter);
  public native @Cast("size_t") long data_size_in_bytes(); public native BNNSTensor data_size_in_bytes(long setter);

  public native @Cast("const char*") BytePointer name(); public native BNNSTensor name(BytePointer setter);

}

// #pragma mark - Sub Layers Parameters

/**
 \abstract LSTM Gate Layer Descriptor
 \discussion
 gate layer is a building block of LSTM layers
 example of float output
 in - 1D array of iw_desc.size[0] elements
 hidden - 1D array of hw_desc.size[0] elements
 cell - 1D array of cw_desc.size[0] elements
 out - 1D array of iw_desc.size[1] elements
 input_weights - 2D arrary of iw_desc.size[1] X iw_desc.size[0]  elements (iw_desc.data points to data)
 hidden_weights - 2D arrary of hw_desc.size[1] X hw_desc.size[0]  elements (hw_desc.data points to data)
 cell_weights - 2D arrary of cw_desc.size[1] X cw_desc.size[0]  elements (cw_desc.data points to data)
 for (size_t o = 0; o < iw_desc.size[1]; o++)
 {
  float res = bias[o]; // init with bias value
  for (size_t i = 0; i < iw_desc.size[0]; i++) // matrix vector multiply
   res += input[i] * input_weights[o][i];
  for (size_t i = 0; i < hw_desc.size[0]; i++) // matrix vector multiply
   res += hidden[i] * hidden_weights[o][i];
  for (size_t i = 0; i < cw_desc.size[0]; i++) // matrix vector multiply
   res += cell[i] * cell_weights[o][i];
  out[i] = activation.func(res); // apply activation function
 }
 <p>
 - num_directions == 1 for unidirectional and 2 for bidirectional
 \field iw_desc input weights descriptor , weights are ordered as [num_layers][num_directions][hidden_size][input_size] (C style multi array notation)
        - iw_desc is duplicated for the case where num_layers > 1 && input_size != hidden_size
 \field hw_desc hidden weights descriptor , weights are ordered as [num_layers][num_directions][hidden_size][hidden_size] (C style multi array notation)
 \field cw_desc cell weights descriptor, weights are ordered as [num_layers][num_directions][hidden_size][hidden_size] (C style multi array notation)
 \field b_desc bias descriptor, bias is ordered as [num_layers][num_directions][hidden_size] (C style multi array notation)
 \field activation activation function
 */

public static class BNNSLSTMGateDescriptor extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLSTMGateDescriptor() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLSTMGateDescriptor(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLSTMGateDescriptor(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLSTMGateDescriptor position(long position) {
        return (BNNSLSTMGateDescriptor)super.position(position);
    }
    @Override public BNNSLSTMGateDescriptor getPointer(long i) {
        return new BNNSLSTMGateDescriptor((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor iw_desc(int i); public native BNNSLSTMGateDescriptor iw_desc(int i, BNNSNDArrayDescriptor setter);
  @MemberGetter public native BNNSNDArrayDescriptor iw_desc();
  public native @ByRef BNNSNDArrayDescriptor hw_desc(); public native BNNSLSTMGateDescriptor hw_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor cw_desc(); public native BNNSLSTMGateDescriptor cw_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor b_desc(); public native BNNSLSTMGateDescriptor b_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSActivation activation(); public native BNNSLSTMGateDescriptor activation(BNNSActivation setter);
}


/**
 \abstract contains NDarrat descriptors for inputs and outputs of LSTM
 \field data_desc - input / output
 \field hidden_desc - hidden input / output
 \field cell_state_desc - cell state input / output
*/

public static class BNNSLSTMDataDescriptor extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLSTMDataDescriptor() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLSTMDataDescriptor(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLSTMDataDescriptor(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLSTMDataDescriptor position(long position) {
        return (BNNSLSTMDataDescriptor)super.position(position);
    }
    @Override public BNNSLSTMDataDescriptor getPointer(long i) {
        return new BNNSLSTMDataDescriptor((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor data_desc(); public native BNNSLSTMDataDescriptor data_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor hidden_desc(); public native BNNSLSTMDataDescriptor hidden_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor cell_state_desc(); public native BNNSLSTMDataDescriptor cell_state_desc(BNNSNDArrayDescriptor setter);
}


/**
 \abstract Arithmetic struct that hold 1 input and an output descriptor
 \discussion
 \field in input descriptor
 \field in_type input descriptor type
 \field out output descriptor
 \field out_type output descriptor type
 <p>
 */

public static class BNNSArithmeticUnary extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSArithmeticUnary() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSArithmeticUnary(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSArithmeticUnary(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSArithmeticUnary position(long position) {
        return (BNNSArithmeticUnary)super.position(position);
    }
    @Override public BNNSArithmeticUnary getPointer(long i) {
        return new BNNSArithmeticUnary((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor in(); public native BNNSArithmeticUnary in(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSDescriptorType") int in_type(); public native BNNSArithmeticUnary in_type(int setter);
  public native @ByRef BNNSNDArrayDescriptor out(); public native BNNSArithmeticUnary out(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSDescriptorType") int out_type(); public native BNNSArithmeticUnary out_type(int setter);
}


/**
 \abstract Arithmetic struct that holds 2 input descriptors and an output descriptor
 \discussion
 \field in1 input1 descriptor
 \field in1_type  input1 descriptor type
 \field in2 descriptor
 \field in2_type input2 descriptor type
 \field out output descriptor
 \field out_type output descriptor type
 <p>
 */

public static class BNNSArithmeticBinary extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSArithmeticBinary() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSArithmeticBinary(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSArithmeticBinary(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSArithmeticBinary position(long position) {
        return (BNNSArithmeticBinary)super.position(position);
    }
    @Override public BNNSArithmeticBinary getPointer(long i) {
        return new BNNSArithmeticBinary((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor in1(); public native BNNSArithmeticBinary in1(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSDescriptorType") int in1_type(); public native BNNSArithmeticBinary in1_type(int setter);
  public native @ByRef BNNSNDArrayDescriptor in2(); public native BNNSArithmeticBinary in2(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSDescriptorType") int in2_type(); public native BNNSArithmeticBinary in2_type(int setter);
  public native @ByRef BNNSNDArrayDescriptor out(); public native BNNSArithmeticBinary out(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSDescriptorType") int out_type(); public native BNNSArithmeticBinary out_type(int setter);
}


/**
 \abstract Arithmetic struct that holds 3 input descriptors and an output descriptor
 \discussion
 \field in1 input1 descriptor
 \field in1_type  input1 descriptor type
 \field in2 descriptor
 \field in2_type input2 descriptor type
 \field in3 descriptor
 \field in3_type input3 descriptor type
 \field out output descriptor
 \field out_type output descriptor type
 <p>
 */

public static class BNNSArithmeticTernary extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSArithmeticTernary() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSArithmeticTernary(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSArithmeticTernary(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSArithmeticTernary position(long position) {
        return (BNNSArithmeticTernary)super.position(position);
    }
    @Override public BNNSArithmeticTernary getPointer(long i) {
        return new BNNSArithmeticTernary((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor in1(); public native BNNSArithmeticTernary in1(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSDescriptorType") int in1_type(); public native BNNSArithmeticTernary in1_type(int setter);
  public native @ByRef BNNSNDArrayDescriptor in2(); public native BNNSArithmeticTernary in2(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSDescriptorType") int in2_type(); public native BNNSArithmeticTernary in2_type(int setter);
  public native @ByRef BNNSNDArrayDescriptor in3(); public native BNNSArithmeticTernary in3(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSDescriptorType") int in3_type(); public native BNNSArithmeticTernary in3_type(int setter);
  public native @ByRef BNNSNDArrayDescriptor out(); public native BNNSArithmeticTernary out(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSDescriptorType") int out_type(); public native BNNSArithmeticTernary out_type(int setter);
}


/** \abstract Multihead Attention Projection Parameters
 *
 *  \description
 *  Each of the Query, Key and Value inputs and the output get their own version of this struct.
 *  In the backpropagation call, the _delta output reuses this structure to hold partial differentials.
 *  See BNNSLayerParametersMultiheadAttention for a full description of the layer.
 *
 *  \seealso BNNSLayerParametersMultiheadAttention
 *
 *  \field target_desc Descriptor of the main target of the operation - either an input (i.e. query, key or value) or an output (output)
 *  \field weights The weights to be used by the initial projection (i.e. Wᴷ)
 *  \field bias The bias to be used by the initial projection (i.e. pᴷ). If no bias is required, set bias.data = NULL.
 */
public static class BNNSMHAProjectionParameters extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSMHAProjectionParameters() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSMHAProjectionParameters(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSMHAProjectionParameters(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSMHAProjectionParameters position(long position) {
        return (BNNSMHAProjectionParameters)super.position(position);
    }
    @Override public BNNSMHAProjectionParameters getPointer(long i) {
        return new BNNSMHAProjectionParameters((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor target_desc(); public native BNNSMHAProjectionParameters target_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor weights(); public native BNNSMHAProjectionParameters weights(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor bias(); public native BNNSMHAProjectionParameters bias(BNNSNDArrayDescriptor setter);
}

// #pragma mark - Layer parameters

/**
 <p>
 \abstract Convolution parameters
 <p>
 \discussion
 The convolution product Output = Weights &times; Input is defined as follows.  Pixel <tt>Output(o,x,y)</tt> of the output image stack receives:
 <br><tt>Output(o,x,y) = &sum;<sub>i,kx,ky</sub> Weight(o,i,kx,ky) * Input(i,x_stride * x + kx*x_dilation_stride,y_stride * y + ky*y_dilation_stride)</tt> with
 <tt>kx=0..k_width-1</tt>, <tt>ky=0..k_height-1</tt>,
 <tt>i=0..in_channels-1</tt>, <tt>o=0..out_channels-1</tt>,
 <tt>x=0..out_width-1</tt>, <tt>y=0..out_height-1</tt>.
 <p>
 After the convolution is applied, the output is updated with bias and/or activation function as follows:
 <br><tt>Output(o,x,y) = ActivationFunction( Bias(o) + Output(o,x,y) )</tt>.
 <p>
 Dimensions must satisfy:
 <br><tt>in_width + 2 * x_padding >= x_stride * ( out_width - 1 ) + (k_width + (k_width-1)*(x_dilation_stride-1))</tt>, and <tt>in_height + 2 * y_padding >= y_stride * ( out_height - 1 ) + (k_height + (k_height-1)*(y_dilation_stride-1))</tt>.
 <br>A common use case is <tt>x_stride=y_stride=1</tt>, and <tt>x_padding=y_padding=0</tt>. In that case, <tt>in_width >= out_width + k_width - 1</tt>, and <tt>in_height >= out_height + k_height - 1</tt>.
 <p>
 Padding is a border of 0 values virtually added to the input image. if asymmetric padding is used, replace x_padding with pad[0]+pad[1] and y_padding with pad[2]+pad[3] in the input shape requirement formula above.
  
 Coefficient <tt>Weight(o,i,kx,ky)</tt> for output image <tt>o=0..out_channels-1</tt>, input image <tt>i=0..in_channels-1</tt>, and kernel point (kx,ky) is
 stored in <tt>weights[kx + k_width * (ky + k_height * (i + in_channels * o))]</tt>, where
 the convolution kernel dimensions are <tt>k_width,k_height</tt>.
 <p>
 \field bias Layer bias, <tt>out_channels</tt> values, one for each output channel
 \field activation Layer activation function
 \field weights_layout option to choose a different layout in memory for the weights Matrix
 \field x_stride width increment in the input image
 \field y_stride height increment in the input image
 \field x_dilation_stride width increment in the input image while convolving with the kernel. ignored if x_dilation_stride<=1.
 \field y_dilation_stride height increment in the input image while convolving with the kernel. ignored if y_dilation_stride<=1.
 \field x_padding width padding, virtual 0 values added to the left and right of each channel of the input stack
 \field y_padding height padding, virtual 0 values added to the top and bottom of each channel of the input stack
 \field groups convolution group size, ignored if groups <= 1.
 - if groups > 1:
 - input, output, weights and bias will be used for a set of convolutions.
 - input and output channels must be divisible by groups.
 - weight layout must be BNNSDataLayoutConvolutionWeightsOIHW or BNNSDataLayoutConvolutionWeightsOIHrWr
 - weights descriptor size[2] = in_channels/groups and weights descriptor size[3]=output channels, such that for each consecutive convolutions i and i+1 in the group, convolution i weights and convolution i+1 weights are separated by total_weights_size/groups elements
 - when calling apply forward and backward functions, in_stride, out_stride and gradient strides should be the strides for the entire convolution group.
 - transposed convolution gradient computation is not supported when groups>1
 \field pad left, right, up, down zero padding. used for asymmetric padding.
 - ignored if pad is all 0, or if x_padding>0 or y_padding>0.
 - left,up are adjucent to image position 0,0.
 */

public static class BNNSLayerParametersConvolution extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersConvolution() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersConvolution(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersConvolution(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersConvolution position(long position) {
        return (BNNSLayerParametersConvolution)super.position(position);
    }
    @Override public BNNSLayerParametersConvolution getPointer(long i) {
        return new BNNSLayerParametersConvolution((Pointer)this).offsetAddress(i);
    }


  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersConvolution i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor w_desc(); public native BNNSLayerParametersConvolution w_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersConvolution o_desc(BNNSNDArrayDescriptor setter);

  public native @ByRef BNNSNDArrayDescriptor bias(); public native BNNSLayerParametersConvolution bias(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSActivation activation(); public native BNNSLayerParametersConvolution activation(BNNSActivation setter);

  public native @Cast("size_t") long x_stride(); public native BNNSLayerParametersConvolution x_stride(long setter); // stride 0 will be set 1 during computation
  public native @Cast("size_t") long y_stride(); public native BNNSLayerParametersConvolution y_stride(long setter); // stride 0 will be set 1 during computation
  public native @Cast("size_t") long x_dilation_stride(); public native BNNSLayerParametersConvolution x_dilation_stride(long setter);
  public native @Cast("size_t") long y_dilation_stride(); public native BNNSLayerParametersConvolution y_dilation_stride(long setter);
  public native @Cast("size_t") long x_padding(); public native BNNSLayerParametersConvolution x_padding(long setter);
  public native @Cast("size_t") long y_padding(); public native BNNSLayerParametersConvolution y_padding(long setter);
  public native @Cast("size_t") long groups(); public native BNNSLayerParametersConvolution groups(long setter);
  public native @Cast("size_t") long pad(int i); public native BNNSLayerParametersConvolution pad(int i, long setter);
  @MemberGetter public native @Cast("size_t*") SizeTPointer pad();
}


/**
 <p>
 \abstract Fully connected layer parameters
 <p>
 \discussion
 The output of a fully connected layer is the result of a matrix-vector product.
 The output vector is defined by <tt>Output(o) = &sum;<sub>i</sub> Weight(o,i) * Input(i)</tt> for <tt>i=0..in_size-1</tt>, <tt>o=0..out_size-1</tt>.
 <p>
 Coefficient <tt>Weight(o,i)</tt> is stored in <tt>weights[i + o * in_size]</tt>.
 <p>
 After the matrix product, the output is updated with bias and/or activation function as follows:
 <br><tt>Output(o) = ActivationFunction( Bias(o) + Output(o) )</tt>.
 <p>
 \field i_desc descriptor of input vector
 \field w_desc weights Matrix coefficients, <tt>in_size * out_size</tt> values, with the layout described in the discussion
 \field o_desc descriptor of output vector
 <p>
 \field bias Layer bias, <tt>out_size</tt> values, one for each output component
 \field activation Layer activation function
 <p>
 */

public static class BNNSLayerParametersFullyConnected extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersFullyConnected() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersFullyConnected(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersFullyConnected(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersFullyConnected position(long position) {
        return (BNNSLayerParametersFullyConnected)super.position(position);
    }
    @Override public BNNSLayerParametersFullyConnected getPointer(long i) {
        return new BNNSLayerParametersFullyConnected((Pointer)this).offsetAddress(i);
    }


  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersFullyConnected i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor w_desc(); public native BNNSLayerParametersFullyConnected w_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersFullyConnected o_desc(BNNSNDArrayDescriptor setter);

  public native @ByRef BNNSNDArrayDescriptor bias(); public native BNNSLayerParametersFullyConnected bias(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSActivation activation(); public native BNNSLayerParametersFullyConnected activation(BNNSActivation setter);

}


/**
 <p>
 \abstract Pooling layer parameters
 <p>
 \discussion
 The pooling is defined as follows.  Pixel <tt>Output(o,x,y)</tt> of the output image stack receives:
 <br><tt>Output(o,x,y) = PoolingFunction( Input(o,x_stride * x + kx * x_dilation_stride, y_stride * y + ky * y_dilation_stride) )</tt> with <tt>kx=0..k_width-1</tt>, <tt>ky=0..k_height-1</tt>,
 <tt>o=0..out_channels-1</tt>, <tt>x=0..out_width-1</tt>, <tt>y=0..out_height-1</tt>.
 <p>
 After the pooling is applied, the output is updated with bias and/or activation function as follows:
 <br><tt>Output(o,x,y) = ActivationFunction( Bias(o) + Output(o,x,y) )</tt>.
 <p>
 Dimensions must satisfy:
 <br><tt>in_width + 2 * x_padding >= x_stride * (out_width - 1) + 1</tt>,
 <br><tt>iin_height + 2 * y_padding >= p->y_stride * (o->height - 1) + 1</tt>.
 <p>
 Padding is a border of 0 values virtually added to the input image.
 <p>
 \field bias Layer bias, <tt>out_channels</tt> values
 \field activation Layer activation function
 <p>
 \field pooling_function Selects the pooling function to apply to each sample
 <p>
 \field x_stride width increment in the input image
 \field y_stride height increment in the input image
 \field x_dilation_stride width increment in the input image while convolving with the kernel
 \field y_dilation_stride height increment in the input image while convolving with the kernel
 \field x_padding width padding, virtual 0 values added to the left and right of each channel of the input stack
 \field y_padding height padding, virtual 0 values added to the top and bottom of each channel of the input stack
 \field pad left, right, up, down padding. used for asymmetric padding
 - ignored if pad is all 0, or if x_padding>0 or y_padding>0.
 - left,up are adjucent to image position 0,0.
 */

public static class BNNSLayerParametersPooling extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersPooling() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersPooling(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersPooling(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersPooling position(long position) {
        return (BNNSLayerParametersPooling)super.position(position);
    }
    @Override public BNNSLayerParametersPooling getPointer(long i) {
        return new BNNSLayerParametersPooling((Pointer)this).offsetAddress(i);
    }


  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersPooling i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersPooling o_desc(BNNSNDArrayDescriptor setter);

  public native @ByRef BNNSNDArrayDescriptor bias(); public native BNNSLayerParametersPooling bias(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSActivation activation(); public native BNNSLayerParametersPooling activation(BNNSActivation setter);

  public native @Cast("BNNSPoolingFunction") int pooling_function(); public native BNNSLayerParametersPooling pooling_function(int setter);

  public native @Cast("size_t") long k_width(); public native BNNSLayerParametersPooling k_width(long setter);
  public native @Cast("size_t") long k_height(); public native BNNSLayerParametersPooling k_height(long setter);
  public native @Cast("size_t") long x_stride(); public native BNNSLayerParametersPooling x_stride(long setter); // stride 0 will be set 1 during computation
  public native @Cast("size_t") long y_stride(); public native BNNSLayerParametersPooling y_stride(long setter); // stride 0 will be set 1 during computation
  public native @Cast("size_t") long x_dilation_stride(); public native BNNSLayerParametersPooling x_dilation_stride(long setter);
  public native @Cast("size_t") long y_dilation_stride(); public native BNNSLayerParametersPooling y_dilation_stride(long setter);
  public native @Cast("size_t") long x_padding(); public native BNNSLayerParametersPooling x_padding(long setter);
  public native @Cast("size_t") long y_padding(); public native BNNSLayerParametersPooling y_padding(long setter);
  public native @Cast("size_t") long pad(int i); public native BNNSLayerParametersPooling pad(int i, long setter);
  @MemberGetter public native @Cast("size_t*") SizeTPointer pad();
}


/**
 <p>
 \abstract Activation/Conversion layer parameters
 <p>
 \discussion
 The output of a activation layer is the result of applying activation operation on input data
 Also supports conversion of data types when activation.function ==  BNNSActivationFunctionIdentity
 and i_desc.data_type != o_desc.data_type
 <p>
 \field i_desc descriptor of input
 \field o_desc descriptor of output
 \field activation Layer activation function
 \field axis_flags Flags indicating axes on which to conduct certain activation functions applications (e.g. softmax).
        A value of 0 is interpreted to mean the axis corresponding to i_desc.size[0].
        When used in batch processing, this flag can also specify the batch dimension at the bit one higher than the last dimension of BNNSDataLayout.
        For example, axis_flags = 2 specifies the batch dimension for BNNSDataLayoutVector.
        axis = 8 specifies the batch dimension for BNNSDataLayoutImageCHW.
 <p>
 */

public static class BNNSLayerParametersActivation extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersActivation() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersActivation(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersActivation(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersActivation position(long position) {
        return (BNNSLayerParametersActivation)super.position(position);
    }
    @Override public BNNSLayerParametersActivation getPointer(long i) {
        return new BNNSLayerParametersActivation((Pointer)this).offsetAddress(i);
    }


  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersActivation i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersActivation o_desc(BNNSNDArrayDescriptor setter);

  public native @ByRef BNNSActivation activation(); public native BNNSLayerParametersActivation activation(BNNSActivation setter);
  public native @Cast("uint32_t") int axis_flags(); public native BNNSLayerParametersActivation axis_flags(int setter);

}


/**
\abstract Loss layer parameters (basic version)
\discussion
If loss function is SoftmaxCrossEntropy, use BNNSLayerParametersLossSoftmaxCrossEntropy instead of this structure.
If loss function is SigmoidCrossEntropy, use BNNSLayerParametersLossSigmoidCrossEntropy instead of this structure.
If loss function is Huber, use BNNSLayerParametersLossHuber instead of this structure.
If loss function is Yolo, use BNNSLayerParametersLossYolo instead of this structure.
<p>
compute loss according to loss function and its parameters and reduce loss according to reduction
<p>
\field i_desc descriptor of input
\field o_desc descriptor of output
\field function Loss function
       If SoftmaxCrossEntropy, SigmoidCrossEntropy, Huber or Yolo loss is required, use the specific structures for those loss functions.
\field reduction loss reduction function to be used.
*/

public static class BNNSLayerParametersLossBase extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersLossBase() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersLossBase(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersLossBase(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersLossBase position(long position) {
        return (BNNSLayerParametersLossBase)super.position(position);
    }
    @Override public BNNSLayerParametersLossBase getPointer(long i) {
        return new BNNSLayerParametersLossBase((Pointer)this).offsetAddress(i);
    }

  public native @Cast("BNNSLossFunction") int function(); public native BNNSLayerParametersLossBase function(int setter);
  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersLossBase i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersLossBase o_desc(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSLossReductionFunction") int reduction(); public native BNNSLayerParametersLossBase reduction(int setter);
}


/**
 \abstract Loss layer parameters (Softmax Cross Entropy version)
 \discussion
 compute loss according to loss function and its parameters and reduce loss according to reduction
 <p>
 \field i_desc descriptor of input
 \field o_desc descriptor of output
 \field function Loss function
 \field reduction loss reduction function to be used.
 \field label_smooth smooth n labels. smoothing may not be supported for all loss functions.
        smoothed_labels[i] = labels[i]*(1-label_smooth) + label_smooth/n
 */

public static class BNNSLayerParametersLossSoftmaxCrossEntropy extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersLossSoftmaxCrossEntropy() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersLossSoftmaxCrossEntropy(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersLossSoftmaxCrossEntropy(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersLossSoftmaxCrossEntropy position(long position) {
        return (BNNSLayerParametersLossSoftmaxCrossEntropy)super.position(position);
    }
    @Override public BNNSLayerParametersLossSoftmaxCrossEntropy getPointer(long i) {
        return new BNNSLayerParametersLossSoftmaxCrossEntropy((Pointer)this).offsetAddress(i);
    }

    // Fields layout compatible with BNNSLayerParametersLoseBase
    public native @Cast("BNNSLossFunction") int function(); public native BNNSLayerParametersLossSoftmaxCrossEntropy function(int setter);
    public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersLossSoftmaxCrossEntropy i_desc(BNNSNDArrayDescriptor setter);
    public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersLossSoftmaxCrossEntropy o_desc(BNNSNDArrayDescriptor setter);
    public native @Cast("BNNSLossReductionFunction") int reduction(); public native BNNSLayerParametersLossSoftmaxCrossEntropy reduction(int setter);

    // Fields specific to Softmax Cross Entropy
    public native float label_smooth(); public native BNNSLayerParametersLossSoftmaxCrossEntropy label_smooth(float setter);
}


/**
 \abstract Loss layer parameters (Sigmoid Cross Entropy version)
 \discussion
 compute loss according to loss function and its parameters and reduce loss according to reduction
 <p>
 \field i_desc descriptor of input
 \field o_desc descriptor of output
 \field function Loss function
 \field reduction loss reduction function to be used.
 \field label_smooth smooth n labels. smoothing may not be supported for all loss functions.
        smoothed_labels[i] = labels[i]*(1-label_smooth) + label_smooth/2
 */

public static class BNNSLayerParametersLossSigmoidCrossEntropy extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersLossSigmoidCrossEntropy() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersLossSigmoidCrossEntropy(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersLossSigmoidCrossEntropy(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersLossSigmoidCrossEntropy position(long position) {
        return (BNNSLayerParametersLossSigmoidCrossEntropy)super.position(position);
    }
    @Override public BNNSLayerParametersLossSigmoidCrossEntropy getPointer(long i) {
        return new BNNSLayerParametersLossSigmoidCrossEntropy((Pointer)this).offsetAddress(i);
    }

    // Fields layout compatible with BNNSLayerParametersLoseBase
    public native @Cast("BNNSLossFunction") int function(); public native BNNSLayerParametersLossSigmoidCrossEntropy function(int setter);
    public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersLossSigmoidCrossEntropy i_desc(BNNSNDArrayDescriptor setter);
    public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersLossSigmoidCrossEntropy o_desc(BNNSNDArrayDescriptor setter);
    public native @Cast("BNNSLossReductionFunction") int reduction(); public native BNNSLayerParametersLossSigmoidCrossEntropy reduction(int setter);

    // Fields specific to Softmax Cross Entropy
    public native float label_smooth(); public native BNNSLayerParametersLossSigmoidCrossEntropy label_smooth(float setter);
}


/**
 \abstract Loss layer parameters (Huber version)
 \discussion
 compute loss according to loss function and its parameters and reduce loss according to reduction
 <p>
 \field i_desc descriptor of input
 \field o_desc descriptor of output
 \field function Loss function
 \field reduction loss reduction function to be used.
 \field huber_delta huber delta
 */

public static class BNNSLayerParametersLossHuber extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersLossHuber() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersLossHuber(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersLossHuber(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersLossHuber position(long position) {
        return (BNNSLayerParametersLossHuber)super.position(position);
    }
    @Override public BNNSLayerParametersLossHuber getPointer(long i) {
        return new BNNSLayerParametersLossHuber((Pointer)this).offsetAddress(i);
    }

    // Fields layout compatible with BNNSLayerParametersLoseBase
    public native @Cast("BNNSLossFunction") int function(); public native BNNSLayerParametersLossHuber function(int setter);
    public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersLossHuber i_desc(BNNSNDArrayDescriptor setter);
    public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersLossHuber o_desc(BNNSNDArrayDescriptor setter);
    public native @Cast("BNNSLossReductionFunction") int reduction(); public native BNNSLayerParametersLossHuber reduction(int setter);

    // Fields specific to Huber Loss
    public native float huber_delta(); public native BNNSLayerParametersLossHuber huber_delta(float setter);
}


/**
 \abstract Loss layer parameters (YoLo version)
 \discussion
 compute loss according to loss function and its parameters and reduce loss according to reduction
 Yolo loss input and ground truth labels data layout expected to be (batch size)x(grid height)x(grid width)x(anchors)x(x,y,w,h,confidence,classes)
 <p>
 \field i_desc descriptor of input
 \field o_desc descriptor of output
 \field function Loss function
 \field reduction loss reduction function to be used.
 - reduction must be BNNSLossReductionSum for loss function BNNSLossFunctionYolo
 \field huber_delta huber delta
 - ignored if loss function is not huber or yolo
 - for yolo loss, huber is used for w,h loss. yolo loss huber delta is assumed to be 1 if set to 0
 \field number_of_grid_columns number of columns in grid
 \field number_of_grid_rows number of rows in grid
 \field number_of_anchor_boxes number of anchor boxes in each cell
 \field anchor_box_size anchor box size, should be 5+number of classes
 \field rescore rescore confidence according to prediction vs. ground truth Intersection Over Union (IOU)
 \field scale_xy x,y loss scaling factor
 \field scale_wh w,h loss scaling factor
 \field scale_object confidence (object) loss scaling factor
 \field scale_no_object confidence (no object) scaling factor
 \field scale_classification classification scaling factor
 \field object_minimum_iou minimum iou for treating as object
 \field object_minimum_iou maximum iou for treating as no object
 \field anchors_data anchors data
 -must be consecutive float array: w0,h0,w1,h1, ... w_n,h_n, where n is number_of_anchor_boxes
 */

public static class BNNSLayerParametersLossYolo extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersLossYolo() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersLossYolo(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersLossYolo(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersLossYolo position(long position) {
        return (BNNSLayerParametersLossYolo)super.position(position);
    }
    @Override public BNNSLayerParametersLossYolo getPointer(long i) {
        return new BNNSLayerParametersLossYolo((Pointer)this).offsetAddress(i);
    }

    // Fields layout compatible with BNNSLayerParametersLoseBase
    public native @Cast("BNNSLossFunction") int function(); public native BNNSLayerParametersLossYolo function(int setter);
    public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersLossYolo i_desc(BNNSNDArrayDescriptor setter);
    public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersLossYolo o_desc(BNNSNDArrayDescriptor setter);
    public native @Cast("BNNSLossReductionFunction") int reduction(); public native BNNSLayerParametersLossYolo reduction(int setter);

    // Fields specific to YoLo Loss
    public native float huber_delta(); public native BNNSLayerParametersLossYolo huber_delta(float setter);
    public native @Cast("size_t") long number_of_grid_columns(); public native BNNSLayerParametersLossYolo number_of_grid_columns(long setter);
    public native @Cast("size_t") long number_of_grid_rows(); public native BNNSLayerParametersLossYolo number_of_grid_rows(long setter);
    public native @Cast("size_t") long number_of_anchor_boxes(); public native BNNSLayerParametersLossYolo number_of_anchor_boxes(long setter);
    public native @Cast("size_t") long anchor_box_size(); public native BNNSLayerParametersLossYolo anchor_box_size(long setter);
    public native @Cast("bool") boolean rescore(); public native BNNSLayerParametersLossYolo rescore(boolean setter);
    public native float scale_xy(); public native BNNSLayerParametersLossYolo scale_xy(float setter);
    public native float scale_wh(); public native BNNSLayerParametersLossYolo scale_wh(float setter);
    public native float scale_object(); public native BNNSLayerParametersLossYolo scale_object(float setter);
    public native float scale_no_object(); public native BNNSLayerParametersLossYolo scale_no_object(float setter);
    public native float scale_classification(); public native BNNSLayerParametersLossYolo scale_classification(float setter);
    public native float object_minimum_iou(); public native BNNSLayerParametersLossYolo object_minimum_iou(float setter);
    public native float no_object_maximum_iou(); public native BNNSLayerParametersLossYolo no_object_maximum_iou(float setter);
    public native FloatPointer anchors_data(); public native BNNSLayerParametersLossYolo anchors_data(FloatPointer setter);
}


/**
 \abstract SGD with Momentum Optimizer Fields
 \discussion
 BNNSOptimizerSGDMomentumFields structure should be pointed to by OptimizerAlgFields when using an Optimizer filter with optimization function BNNSOptimizerFunctionSGDMomentum.
 The structure will not be cached internally and must be valid when calling the optimizer apply, therefore, values such as learning_rate can be modified between optimizer filter apply calls.
 <p>
 The error function E = L + R(W) where L is the loss function and R(W) is the regularization term.
 The gradient g is dE/dW = dL/dW + dR(W)/dW
 dL/dW could be clipped using clip_gradients and scaled using gradient_scale
 dR(W)/dW could be scaled using regularization_scale
 <p>
 The SGD with momentum optimizer will calculate the parameter W at time t+1 using accumulator V, gradient g, learning rate lr and momentum m according to sgd_momentum_variant.
 <p>
 \field learning_rate learning rate
 \field momentum momentum. setting momentum to 0 will result in vanilla sgd, the accumulation term V will not be computed and associated scratch buffer can be NULL
 \field gradient_scale gradient scaling factor
 \field regularization_scale regularization scaling factor
 \field clip_gradients clip gradient between min and max values
 \field clip_gradients_min minimum gradient values. ignored if clip_gradients is false
 \field clip_gradients_max maximum gradient values. ignored if clip_gradients is false
 \field nesterov nesterov momentum update
 \field regularization_func regularization function
 \field sgd_momentum_variant sgd momentum variant
 <p>
 */

public static class BNNSOptimizerSGDMomentumFields extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSOptimizerSGDMomentumFields() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSOptimizerSGDMomentumFields(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSOptimizerSGDMomentumFields(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSOptimizerSGDMomentumFields position(long position) {
        return (BNNSOptimizerSGDMomentumFields)super.position(position);
    }
    @Override public BNNSOptimizerSGDMomentumFields getPointer(long i) {
        return new BNNSOptimizerSGDMomentumFields((Pointer)this).offsetAddress(i);
    }

  public native float learning_rate(); public native BNNSOptimizerSGDMomentumFields learning_rate(float setter);
  public native float momentum(); public native BNNSOptimizerSGDMomentumFields momentum(float setter);
  public native float gradient_scale(); public native BNNSOptimizerSGDMomentumFields gradient_scale(float setter);
  public native float regularization_scale(); public native BNNSOptimizerSGDMomentumFields regularization_scale(float setter);
  public native @Cast("bool") boolean clip_gradients(); public native BNNSOptimizerSGDMomentumFields clip_gradients(boolean setter);
  public native float clip_gradients_min(); public native BNNSOptimizerSGDMomentumFields clip_gradients_min(float setter);
  public native float clip_gradients_max(); public native BNNSOptimizerSGDMomentumFields clip_gradients_max(float setter);
  public native @Cast("bool") boolean nesterov(); public native BNNSOptimizerSGDMomentumFields nesterov(boolean setter);
  public native @Cast("BNNSOptimizerRegularizationFunction") int regularization_func(); public native BNNSOptimizerSGDMomentumFields regularization_func(int setter);
  public native @Cast("BNNSOptimizerSGDMomentumVariant") int sgd_momentum_variant(); public native BNNSOptimizerSGDMomentumFields sgd_momentum_variant(int setter);
}


/**
 \abstract SGD with Momentum and gradient clipping Optimizer Fields
 \discussion
 BNNSOptimizerSGDMomentumFields structure should be pointed to by OptimizerAlgFields when using an Optimizer filter with optimization function BNNSOptimizerFunctionSGDMomentum.
 The structure will not be cached internally and must be valid when calling the optimizer apply, therefore, values such as learning_rate can be modified between optimizer filter apply calls.
 <p>
 The error function E = L + R(W) where L is the loss function and R(W) is the regularization term.
 The gradient g is dE/dW = dL/dW + dR(W)/dW
 dL/dW could be clipped using clipping_func and scaled using gradient_scale
 dR(W)/dW could be scaled using regularization_scale
 <p>
 The SGD with momentum optimizer will calculate the parameter W at time t+1 using accumulator V, gradient g, learning rate lr and momentum m according to sgd_momentum_variant.
 <p>
 \field learning_rate learning rate
 \field momentum momentum. setting momentum to 0 will result in vanilla sgd, the accumulation term V will not be computed and associated scratch buffer can be NULL
 \field gradient_scale gradient scaling factor
 \field regularization_scale regularization scaling factor
 \field nesterov nesterov momentum update
 \field regularization_func regularization function
 \field sgd_momentum_variant sgd momentum variant
 \field clipping_func clipping function
 \field clip_gradients_min minimum gradient values. Used by BNNSOptimizerClippingByValue.
 \field clip_gradients_max maximum gradient values. Used by BNNSOptimizerClippingByValue.
 \field clip_gradients_max_norm max L2-norm. Used by BNNSOptimizerClippingByNorm and BNNSOptimizerClippingByGlobalNorm.
 \field clip_gradients_use_norm If you already know the global L2-norm, you can specify the global L2-norm to use by BNNSOptimizerClippingByGlobalNorm.
 If zero, global L2-norm of gradient tensors is computed and then used.
 <p>
 */

public static class BNNSOptimizerSGDMomentumWithClippingFields extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSOptimizerSGDMomentumWithClippingFields() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSOptimizerSGDMomentumWithClippingFields(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSOptimizerSGDMomentumWithClippingFields(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSOptimizerSGDMomentumWithClippingFields position(long position) {
        return (BNNSOptimizerSGDMomentumWithClippingFields)super.position(position);
    }
    @Override public BNNSOptimizerSGDMomentumWithClippingFields getPointer(long i) {
        return new BNNSOptimizerSGDMomentumWithClippingFields((Pointer)this).offsetAddress(i);
    }

  public native float learning_rate(); public native BNNSOptimizerSGDMomentumWithClippingFields learning_rate(float setter);
  public native float momentum(); public native BNNSOptimizerSGDMomentumWithClippingFields momentum(float setter);
  public native float gradient_scale(); public native BNNSOptimizerSGDMomentumWithClippingFields gradient_scale(float setter);
  public native float regularization_scale(); public native BNNSOptimizerSGDMomentumWithClippingFields regularization_scale(float setter);
  public native @Cast("bool") boolean nesterov(); public native BNNSOptimizerSGDMomentumWithClippingFields nesterov(boolean setter);
  public native @Cast("BNNSOptimizerRegularizationFunction") int regularization_func(); public native BNNSOptimizerSGDMomentumWithClippingFields regularization_func(int setter);
  public native @Cast("BNNSOptimizerSGDMomentumVariant") int sgd_momentum_variant(); public native BNNSOptimizerSGDMomentumWithClippingFields sgd_momentum_variant(int setter);
  public native @Cast("BNNSOptimizerClippingFunction") int clipping_func(); public native BNNSOptimizerSGDMomentumWithClippingFields clipping_func(int setter);
  public native float clip_gradients_min(); public native BNNSOptimizerSGDMomentumWithClippingFields clip_gradients_min(float setter);
  public native float clip_gradients_max(); public native BNNSOptimizerSGDMomentumWithClippingFields clip_gradients_max(float setter);
  public native float clip_gradients_max_norm(); public native BNNSOptimizerSGDMomentumWithClippingFields clip_gradients_max_norm(float setter);
  public native float clip_gradients_use_norm(); public native BNNSOptimizerSGDMomentumWithClippingFields clip_gradients_use_norm(float setter);
}


/**
 \abstract Adam and AdamW Fields
 \discussion
 BNNSOptimizerAdamFields structure should be pointed to by OptimizerAlgFields when using an Optimizer filter with one of the optimization functions BNNSOptimizerFunctionAdam, BNNSOptimizerFunctionAdamAMSGrad, BNNSOptimizerFunctionAdamW, or BNNSOptimizerFunctionAdamWAMSGrad.
 The structure will not be cached internally and must be valid when calling the optimizer apply, therefore, values such as learning_rate can be modified between optimizer filter apply calls.
 <p>
 The error function E = L + R(W) where L is the loss function and R(W) is the regularization term.
 The gradient g is dE/dW = dL/dW + dR(W)/dW
 dL/dW could be clipped using clip_gradients and scaled using gradient_scale
 For BNNSOptimizerFunctionAdam and BNNSOptimizerFunctionAdamAMSGrad dR(W)/dW could be scaled using regularization_scale (L_1/L_2 regularization).
 For BNNSOptimizerFunctionAdamW and BNNSOptimizerFunctionAdamWAMSGrad, regularization_scale is instead used for the decoupled weight decay parameter
 <p>
 Adam Implementation according to ADAM: A METHOD FOR STOCHASTIC OPTIMIZATION by Diederik P. Kingma, Jimmy Lei Ba (https://arxiv.org/pdf/1412.6980.pdf)
 <p>
 AdamW Implementation is based on DECOUPLED WEIGHT DECAY REGULARIZATION by I. Loshchilov and F. Hutter
 (https://arxiv.org/pdf/1711.05101.pdf)
 <p>
 The AMSGrad variants use the alternative versions of the update step described in
 ON THE CONVERGENCE OF ADAM AND BEYOND by S. Reddi, S. Kale and S. Kumar
 (https://arxiv.org/pdf/1904.09237)
 <p>
 \field learning_rate learning rate
 \field beta1 first moment constant. must be in [0,1)
 \field beta2 second moment constant. must be in [0,1)
 \field time_step time step. time step is maintained by user since optimizer is called for multiple layers with same time step. initial value must be 1, increase by 1 after optimizing all the layer paramers in the network.
 \field epsilon epsilon addition for the division in the parameter update stage, note that this is actually epsilon hat from section 2 of the
        Adam paper, which is related to the paper's epsilon through the relation epsilon_hat = epsilon * sqrt(1 - beta2 ** time_step)
 \field gradient_scale gradient scaling factor
 \field regularization_scale regularization scaling factor / decoupled weight decay parameter
 \field clip_gradients clip gradient between min and max values
 \field clip_gradients_min minimum gradient values. ignored if clip_gradients is false
 \field clip_gradients_max maximum gradient values. ignored if clip_gradients is false
 \field regularization_func regularization function (only used by Adam, ignored by AdamW)
 */

public static class BNNSOptimizerAdamFields extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSOptimizerAdamFields() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSOptimizerAdamFields(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSOptimizerAdamFields(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSOptimizerAdamFields position(long position) {
        return (BNNSOptimizerAdamFields)super.position(position);
    }
    @Override public BNNSOptimizerAdamFields getPointer(long i) {
        return new BNNSOptimizerAdamFields((Pointer)this).offsetAddress(i);
    }

  public native float learning_rate(); public native BNNSOptimizerAdamFields learning_rate(float setter);
  public native float beta1(); public native BNNSOptimizerAdamFields beta1(float setter);
  public native float beta2(); public native BNNSOptimizerAdamFields beta2(float setter);
  public native float time_step(); public native BNNSOptimizerAdamFields time_step(float setter);
  public native float epsilon(); public native BNNSOptimizerAdamFields epsilon(float setter);
  public native float gradient_scale(); public native BNNSOptimizerAdamFields gradient_scale(float setter);
  public native float regularization_scale(); public native BNNSOptimizerAdamFields regularization_scale(float setter);
  public native @Cast("bool") boolean clip_gradients(); public native BNNSOptimizerAdamFields clip_gradients(boolean setter);
  public native float clip_gradients_min(); public native BNNSOptimizerAdamFields clip_gradients_min(float setter);
  public native float clip_gradients_max(); public native BNNSOptimizerAdamFields clip_gradients_max(float setter);
  public native @Cast("BNNSOptimizerRegularizationFunction") int regularization_func(); public native BNNSOptimizerAdamFields regularization_func(int setter);
}


/**
 \abstract Adam and AdamW with gradient clipping Fields
 \discussion
 BNNSOptimizerAdamFields structure should be pointed to by OptimizerAlgFields when using an Optimizer filter with one of the optimization functions BNNSOptimizerFunctionAdam, BNNSOptimizerFunctionAdamAMSGrad, BNNSOptimizerFunctionAdamW, or BNNSOptimizerFunctionAdamWAMSGrad.
 The structure will not be cached internally and must be valid when calling the optimizer apply, therefore, values such as learning_rate can be modified between optimizer filter apply calls.
 <p>
 The error function E = L + R(W) where L is the loss function and R(W) is the regularization term.
 The gradient g is dE/dW = dL/dW + dR(W)/dW
 dL/dW could be clipped using clipping_func and scaled using gradient_scale
 For BNNSOptimizerFunctionAdam and BNNSOptimizerFunctionAdamAMSGrad dR(W)/dW could be scaled using regularization_scale (L_1/L_2 regularization).
 For BNNSOptimizerFunctionAdamW and BNNSOptimizerFunctionAdamWAMSGrad, regularization_scale is instead used for the decoupled weight decay parameter
 <p>
 Adam Implementation according to ADAM: A METHOD FOR STOCHASTIC OPTIMIZATION by Diederik P. Kingma, Jimmy Lei Ba (https://arxiv.org/pdf/1412.6980.pdf)
 <p>
 AdamW Implementation is based on DECOUPLED WEIGHT DECAY REGULARIZATION by I. Loshchilov and F. Hutter
 (https://arxiv.org/pdf/1711.05101.pdf)
 <p>
 The AMSGrad variants use the alternative versions of the update step described in
 ON THE CONVERGENCE OF ADAM AND BEYOND by S. Reddi, S. Kale and S. Kumar
 (https://arxiv.org/pdf/1904.09237)
 <p>
 \field learning_rate learning rate
 \field beta1 first moment constant. must be in [0,1)
 \field beta2 second moment constant. must be in [0,1)
 \field time_step time step. time step is maintained by user since optimizer is called for multiple layers with same time step. initial value must be 1, increase by 1 after optimizing all the layer paramers in the network.
 \field epsilon epsilon addition for the division in the parameter update stage, note that this is actually epsilon hat from section 2 of the
 Adam paper, which is related to the paper's epsilon through the relation epsilon_hat = epsilon * sqrt(1 - beta2 ** time_step)
 \field gradient_scale gradient scaling factor
 \field regularization_scale regularization scaling factor / decoupled weight decay parameter
 \field regularization_func regularization function (only used by Adam, ignored by AdamW)
 \field clipping_func clipping function
 \field clip_gradients_min minimum gradient values. Used by BNNSOptimizerClippingByValue.
 \field clip_gradients_max maximum gradient values. Used by BNNSOptimizerClippingByValue.
 \field clip_gradients_max_norm max L2-norm. Used by BNNSOptimizerClippingByNorm and BNNSOptimizerClippingByGlobalNorm.
 \field clip_gradients_use_norm global norm to use by BNNSOptimizerClippingByGlobalNorm. If zero, global norm of gradient tensors is computed and used.
 */

public static class BNNSOptimizerAdamWithClippingFields extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSOptimizerAdamWithClippingFields() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSOptimizerAdamWithClippingFields(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSOptimizerAdamWithClippingFields(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSOptimizerAdamWithClippingFields position(long position) {
        return (BNNSOptimizerAdamWithClippingFields)super.position(position);
    }
    @Override public BNNSOptimizerAdamWithClippingFields getPointer(long i) {
        return new BNNSOptimizerAdamWithClippingFields((Pointer)this).offsetAddress(i);
    }

  public native float learning_rate(); public native BNNSOptimizerAdamWithClippingFields learning_rate(float setter);
  public native float beta1(); public native BNNSOptimizerAdamWithClippingFields beta1(float setter);
  public native float beta2(); public native BNNSOptimizerAdamWithClippingFields beta2(float setter);
  public native float time_step(); public native BNNSOptimizerAdamWithClippingFields time_step(float setter);
  public native float epsilon(); public native BNNSOptimizerAdamWithClippingFields epsilon(float setter);
  public native float gradient_scale(); public native BNNSOptimizerAdamWithClippingFields gradient_scale(float setter);
  public native float regularization_scale(); public native BNNSOptimizerAdamWithClippingFields regularization_scale(float setter);
  public native @Cast("BNNSOptimizerRegularizationFunction") int regularization_func(); public native BNNSOptimizerAdamWithClippingFields regularization_func(int setter);
  public native @Cast("BNNSOptimizerClippingFunction") int clipping_func(); public native BNNSOptimizerAdamWithClippingFields clipping_func(int setter);
  public native float clip_gradients_min(); public native BNNSOptimizerAdamWithClippingFields clip_gradients_min(float setter);
  public native float clip_gradients_max(); public native BNNSOptimizerAdamWithClippingFields clip_gradients_max(float setter);
  public native float clip_gradients_max_norm(); public native BNNSOptimizerAdamWithClippingFields clip_gradients_max_norm(float setter);
  public native float clip_gradients_use_norm(); public native BNNSOptimizerAdamWithClippingFields clip_gradients_use_norm(float setter);
}


/**
 \abstract RMSProp Fields
 \discussion
 Implements the RMSProp method as described in [1] (centered version) and [2] (original, non-centred version).
 <p>
 Weight w_i is updated using one of the formulae
 Uncentered:
    n_i = ɑ n_i + (1 - ɑ) (dL/dw_i)**2
    Δ_i = γ Δ_i - η dL/dw_i / ( sqrt( n_i ) + ε )
    w_i = w_i + Δ_i
 Centered:
    n_i = ɑ n_i + (1 - ɑ) (dL/dw_i)**2
    g_i = ɑ g_i + (1 - ɑ) (dL/dw_i)
    Δ_i = γ Δ_i - η dL/dw_i / ( sqrt( n_i - g_i**2 ) + ε )
    w_i = w_i + Δ_i
 The gradients dL/dw_i may optionally be clipped to a given range.
 <p>
 [1] "Generating Sequences With Recurrent Neural Networks", A. Graves, https://arxiv.org/pdf/1308.0850v5.pdf
 [2] "Neural Networks for Machine Learning", Leacture 6a, G. Hinton, http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf
 <p>
 \field learning_rate the scheduled learning rate, which will be adjusted by the algorithm (η above)
 \field alpha smoothing constant (ɑ above)
 \field epsilon term added to denominator (ε above)
 \field centered use the centered variant if true
 \field momentum momentum decay rate (γ above) (set to 0 to disable momentum)
 \field gradient_scale gradient scaling factor
 \field regularization_scale regularization scaling factor / decoupled weight decay parameter
 \field clip_gradients clip gradient between min and max values
 \field clip_gradients_min minimum gradient values. ignored if clip_gradients is false
 \field clip_gradients_max maximum gradient values. ignored if clip_gradients is false
 \field regularization_func regularization function (only used by Adam, ignored by AdamW)
 */

public static class BNNSOptimizerRMSPropFields extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSOptimizerRMSPropFields() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSOptimizerRMSPropFields(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSOptimizerRMSPropFields(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSOptimizerRMSPropFields position(long position) {
        return (BNNSOptimizerRMSPropFields)super.position(position);
    }
    @Override public BNNSOptimizerRMSPropFields getPointer(long i) {
        return new BNNSOptimizerRMSPropFields((Pointer)this).offsetAddress(i);
    }

  public native float learning_rate(); public native BNNSOptimizerRMSPropFields learning_rate(float setter);
  public native float alpha(); public native BNNSOptimizerRMSPropFields alpha(float setter);
  public native float epsilon(); public native BNNSOptimizerRMSPropFields epsilon(float setter);
  public native @Cast("bool") boolean centered(); public native BNNSOptimizerRMSPropFields centered(boolean setter);
  public native float momentum(); public native BNNSOptimizerRMSPropFields momentum(float setter);
  public native float gradient_scale(); public native BNNSOptimizerRMSPropFields gradient_scale(float setter);
  public native float regularization_scale(); public native BNNSOptimizerRMSPropFields regularization_scale(float setter);
  public native @Cast("bool") boolean clip_gradients(); public native BNNSOptimizerRMSPropFields clip_gradients(boolean setter);
  public native float clip_gradients_min(); public native BNNSOptimizerRMSPropFields clip_gradients_min(float setter);
  public native float clip_gradients_max(); public native BNNSOptimizerRMSPropFields clip_gradients_max(float setter);
  public native @Cast("BNNSOptimizerRegularizationFunction") int regularization_func(); public native BNNSOptimizerRMSPropFields regularization_func(int setter);
}


/**
 \abstract RMSProp with gradient clipping Fields
 \discussion
 Implements the RMSProp method as described in [1] (centered version) and [2] (original, non-centred version).
 <p>
 Weight w_i is updated using one of the formulae
 Uncentered:
 n_i = ɑ n_i + (1 - ɑ) (dL/dw_i)**2
 Δ_i = γ Δ_i - η dL/dw_i / ( sqrt( n_i ) + ε )
 w_i = w_i + Δ_i
 Centered:
 n_i = ɑ n_i + (1 - ɑ) (dL/dw_i)**2
 g_i = ɑ g_i + (1 - ɑ) (dL/dw_i)
 Δ_i = γ Δ_i - η dL/dw_i / ( sqrt( n_i - g_i**2 ) + ε )
 w_i = w_i + Δ_i
 The gradients dL/dw_i may optionally be clipped to a given range.
 <p>
 [1] "Generating Sequences With Recurrent Neural Networks", A. Graves, https://arxiv.org/pdf/1308.0850v5.pdf
 [2] "Neural Networks for Machine Learning", Leacture 6a, G. Hinton, http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf
 <p>
 \field learning_rate the scheduled learning rate, which will be adjusted by the algorithm (η above)
 \field alpha smoothing constant (ɑ above)
 \field epsilon term added to denominator (ε above)
 \field centered use the centered variant if true
 \field momentum momentum decay rate (γ above) (set to 0 to disable momentum)
 \field gradient_scale gradient scaling factor
 \field regularization_scale regularization scaling factor / decoupled weight decay parameter
 \field regularization_func regularization function (only used by Adam, ignored by AdamW)
 \field clipping_func clipping function
 \field clip_gradients_min minimum gradient values. Used by BNNSOptimizerClippingByValue.
 \field clip_gradients_max maximum gradient values. Used by BNNSOptimizerClippingByValue.
 \field clip_gradients_max_norm max L2-norm. Used by BNNSOptimizerClippingByNorm and BNNSOptimizerClippingByGlobalNorm.
 \field clip_gradients_use_norm global norm to use by BNNSOptimizerClippingByGlobalNorm. If zero, global norm of gradient tensors is computed and used.
 */

public static class BNNSOptimizerRMSPropWithClippingFields extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSOptimizerRMSPropWithClippingFields() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSOptimizerRMSPropWithClippingFields(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSOptimizerRMSPropWithClippingFields(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSOptimizerRMSPropWithClippingFields position(long position) {
        return (BNNSOptimizerRMSPropWithClippingFields)super.position(position);
    }
    @Override public BNNSOptimizerRMSPropWithClippingFields getPointer(long i) {
        return new BNNSOptimizerRMSPropWithClippingFields((Pointer)this).offsetAddress(i);
    }

  public native float learning_rate(); public native BNNSOptimizerRMSPropWithClippingFields learning_rate(float setter);
  public native float alpha(); public native BNNSOptimizerRMSPropWithClippingFields alpha(float setter);
  public native float epsilon(); public native BNNSOptimizerRMSPropWithClippingFields epsilon(float setter);
  public native @Cast("bool") boolean centered(); public native BNNSOptimizerRMSPropWithClippingFields centered(boolean setter);
  public native float momentum(); public native BNNSOptimizerRMSPropWithClippingFields momentum(float setter);
  public native float gradient_scale(); public native BNNSOptimizerRMSPropWithClippingFields gradient_scale(float setter);
  public native float regularization_scale(); public native BNNSOptimizerRMSPropWithClippingFields regularization_scale(float setter);
  public native @Cast("BNNSOptimizerRegularizationFunction") int regularization_func(); public native BNNSOptimizerRMSPropWithClippingFields regularization_func(int setter);
  public native @Cast("BNNSOptimizerClippingFunction") int clipping_func(); public native BNNSOptimizerRMSPropWithClippingFields clipping_func(int setter);
  public native float clip_gradients_min(); public native BNNSOptimizerRMSPropWithClippingFields clip_gradients_min(float setter);
  public native float clip_gradients_max(); public native BNNSOptimizerRMSPropWithClippingFields clip_gradients_max(float setter);
  public native float clip_gradients_max_norm(); public native BNNSOptimizerRMSPropWithClippingFields clip_gradients_max_norm(float setter);
  public native float clip_gradients_use_norm(); public native BNNSOptimizerRMSPropWithClippingFields clip_gradients_use_norm(float setter);
}


/**
 \abstract Normalization layer parameters
 \discussion
 normalize inputs by using mean, variance, beta and gamma.
 <p>
 input and output descriptor must have the same dimensions. Only BNNSDataLayoutImageCHW and BNNSDataLayoutVector are supported.
 Vector of length L is equivalent to ImageCHW of dimension Lx1x1 (CxHxW).
 Currently supported data types for input and output are FP32, BF16,  and FP16.
 <p>
 beta and gamma are trainable parameters. beta and gamma must be the same type i.e. all FP32, BF16,  or FP16.
 Moving mean and variance must be in FP32 regardless of the input data type.
 Except for layer norm, beta, gamma, moving mean and moving variance width (descriptor size[0]) must be equal to number of input channels (descriptor size[2]).
 For layer norm, beta and gamma currently must have the same dimensions as the input depending on normalization_axis.
 <p>
 momentum is used to update the moving mean and moving variance during training and must be between 0 and 1
 <p>
 epsilon is used in the computation of 1/sqrt(variance + epsilon)
 <p>
 \field i_desc input descriptor
 \field o_desc output descriptor
 \field beta_desc beta parameter descriptor
 -ignored if pointer is NULL
 \field gamma_desc gamma parameter descriptor
 -ignored if pointer is NULL
 \field moving_mean pointer to the moving mean
 - Only applicable to batch norm and instance norm. Ignored in layer norm and group norm.
 If pointer is NULL, it means moving mean is not tracked in training or not used in inference.
 \field moving_variance pointer to the moving variance
 - Only applicable to batch norm and instance norm. Ignored in layer norm and group norm.
 If pointer is NULL, it means moving variance is not tracked in training or not used in inference.
 \field momentum momentum.
 -must be between 0 and 1.
 \field epsilon epsilon
 \field activation fused activation layer to follow the batch normalization layer. Only elementwise activation function is supported. ie. no softmax/logsoftmax.
 \field num_groups Divide the channels into this number of groups over which normalization statistics are computed.
 The number of channels in i_desc must be divisible by the number of groups. This is only used in group norm.
 \field normalization_axis The starting axis over which normalization applies. This is only used in layer norm.
 normalization_axis = 0 means normalize over CHW.
 normalization_axis = 1 means normalize over HW.
 normalization_axis = 2 means normalize over W.
 */

public static class BNNSLayerParametersNormalization extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersNormalization() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersNormalization(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersNormalization(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersNormalization position(long position) {
        return (BNNSLayerParametersNormalization)super.position(position);
    }
    @Override public BNNSLayerParametersNormalization getPointer(long i) {
        return new BNNSLayerParametersNormalization((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersNormalization i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersNormalization o_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor beta_desc(); public native BNNSLayerParametersNormalization beta_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor gamma_desc(); public native BNNSLayerParametersNormalization gamma_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor moving_mean_desc(); public native BNNSLayerParametersNormalization moving_mean_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor moving_variance_desc(); public native BNNSLayerParametersNormalization moving_variance_desc(BNNSNDArrayDescriptor setter);
  public native float momentum(); public native BNNSLayerParametersNormalization momentum(float setter);
  public native float epsilon(); public native BNNSLayerParametersNormalization epsilon(float setter);
  public native @ByRef BNNSActivation activation(); public native BNNSLayerParametersNormalization activation(BNNSActivation setter);
  public native @Cast("size_t") long num_groups(); public native BNNSLayerParametersNormalization num_groups(long setter);
  public native @Cast("size_t") long normalization_axis(); public native BNNSLayerParametersNormalization normalization_axis(long setter);
}


/**
 \abstract Dropout Layer Fields
 <p>
 \field i_desc - array descriptor for input
 \field o_desc - array descriptor for output
 \field rate dropout rate is the probability of an element or a group of elements is dropped out.  Range in [0, 1)
 \field seed the seed for the random number generator - ignored if 0
 \field control 8-bit bit mask indicating along which dimension the dropout decision is grouped(kept/dropped altogether) - for now only 4 LSBs have effects.
 */

public static class BNNSLayerParametersDropout extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersDropout() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersDropout(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersDropout(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersDropout position(long position) {
        return (BNNSLayerParametersDropout)super.position(position);
    }
    @Override public BNNSLayerParametersDropout getPointer(long i) {
        return new BNNSLayerParametersDropout((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersDropout i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersDropout o_desc(BNNSNDArrayDescriptor setter);
  public native float rate(); public native BNNSLayerParametersDropout rate(float setter);
  public native @Cast("uint32_t") int seed(); public native BNNSLayerParametersDropout seed(int setter);
  public native @Cast("uint8_t") byte control(); public native BNNSLayerParametersDropout control(byte setter);
}


/**
 \abstract LSTM layer parameters
 \discussion
 LSTM layers parameters include:
 - sequence descriptor to support different batch size for the sequence
 - 3 input descriptors (input, hidden_input, cell_state_input)
 - 3 output descriptors (output, hidden_output, cell_state_output)
 - 4 compute gates (each gate has "extra input weights descriptor" (iw_desc) for the case where num of layers is > 1 and input size != hidden size
 - activation gate for the hidden output
 - dropout value
 - sequence length, number of layers, batch size and bidirectional corresponds to various size fields in the parameters (see details below)
  it is sufficient to set these values, "0" size in the NDArray descriptors will be treated as these values. nonzero size in the NDArray descriptors that don't match these values will result in BNNS Error
 - to enable peepholes, set weights pointer in the gates descriptor (for example, set input_gate_layer[0].cw_desc.data)
 - to enable bias, set bias pointer in the gates descriptor (for example, set forget_gate_layer[0].bias.data)
 - input_hidden_descriptor will be treated as array's filled with 0 when input_hidden_descriptor.data is null
 - input_cell_state_descriptor will be treated as array's filled with 0 when input_cell_state_descriptor.data is null
 example LSTM computation
 {
  // input 1D array
  const float x_0 = input_descriptor.data_desc;
  const float h_0 = input_hidden_descriptor.data;
  const float c_0 = input_cell_state_descriptor.data;
  <p>
  // output 1D array
  float h_t = output_hidden_descriptor.data;
  float c_t = output_cell_state_descriptor.data;
  <p>
  // temporary 1D array
  float f_t[output_cell_state_descriptor.size[0]];
  float i_t[output_cell_state_descriptor.size[0]];
  float g_t[output_cell_state_descriptor.size[0]];
  float o_t[output_hidden_descriptor.size[0]];
  <p>
  f_t = forget_gate_result(x_0, h_0, c_0); // see description in BNNSGateDescriptor
  i_t = input_gate_result(x_0, h_0, c_0);; // see description in BNNSGateDescriptor
  g_t = candidate_gate_result(x_0, h_0, c_0);; // see description in BNNSGateDescriptor
  <p>
  for (size_t o = 0; o < output_cell_state_descriptor.size[0]; o++)
   c_t[o] = f_t[o] * C_t1[o] + i_t[o] * g_t[o];
  <p>
  o_t = output_gate_result(x_0, h_0, c_t);; // see description in BNNSGateDescriptor
  <p>
  for (size_t o = 0; o < output_hidden_descriptor.size[0]; o++)
   h_t[o] = o_t[o] * hidden_activation.func(c_t[o]);
 }
 <p>
 example of STACKED LSTM computation (multiple LSTMCell layers, num_layers > 1)
 {
  // input 1D array
  const float x_0[input_size]; //  = input_descriptor.data_desc;
  <p>
  // input 2D arrays
  const float h_0[num_layers][hidden_size]; //  = input_hidden_descriptor.data;
  const float c_0[num_layers][hidden_size]; //  = input_cell_state_descriptor.data;
  <p>
  // output 1D array
  float h_t = output_hidden_descriptor.data;
  float c_t = output_cell_state_descriptor.data;
  <p>
  (h_t, c_t) = LASTMCell[0](x_0, h_0[0], c_0[0]); // compute first layer with x_0 as input
  for (size_t l = 1; l < num_layers; l++) (h_t, c_t) = LASTMCell[1](h_t, h_0[l], c_0[l]); // compute remaining layers with h_t as input
 }
 <p>
 example of sequence LSTM computation (seq_len > 1)
 {
  // input 2D array
  const float x_0[seq_len][input_size]; //  = input_descriptor.data_desc;
  <p>
  // input 1D array
  const float h_0 = input_hidden_descriptor.data;
  const float c_0 = input_cell_state_descriptor.data;
  <p>
  // output 2D array
  float output[seq_len][hidden_size]; // = output_descriptor.data_desc
  <p>
  // output 1D array
  float h_t = output_hidden_descriptor.data;
  float c_t = output_cell_state_descriptor.data;
  <p>
  (h_t, c_t) = LASTMCell[0](x_0[0], h_0, c_0); // compute first input with h_0 and c_0 as inputs
  for (size_t s = 1; s < seq_len; s++)
  {
   output[s-1] = h_t; // store previous hidden output
   (h_t, c_t) = LASTMCell[0](x_0[s], h_t, c_t); // compute remaining inputs with h_t and c_t as inputs
  }
  output[seq_len-1] = h_t; // store last hidden output
 }
 <p>
 example of sequence bidirectional LSTM computation (seq_len > 1, batch_size > 1,  is_bidirectional == true)
 {
  // input 2D array
  const float x_0[seq_len][batch_size][input_size]; //  = input_descriptor.data_desc;
  const float h_0[2][batch_size][hidden size]; // = input_hidden_descriptor.data;
  const float c_0[2][batch_size][hidden size]; // = input_cell_state_descriptor.data;
  <p>
  // output 4D array
  float output[sequence length][batch_size][2][hidden size]; // = output_descriptor.data_desc
  <p>
  // output 3D array
  float h_t[2][batch_size][hidden size]; // = output_hidden_descriptor.data;
  float c_t[2][batch_size][hidden size]; // = output_cell_state_descriptor.data;
  <p>
  (h_t[0], c_t[0]) = LASTMCell[0](x_0[0], h_0[0], c_0[0]); // compute first input with h_0 and c_0 of the forward direction as inputs
  for (size_t s = 1; s < seq_len; s++)
  {
   output[s-1][batch_size][0] = h_t; // store previous hidden output for the first direction
   (h_t[0], c_t[0]) = LASTMCell[0](x_0[s], h_t[0], c_t[0]); // compute remaining inputs with h_t and c_t as inputs
  }
  output[seq_len-1][batch_size][0] = h_t; // store last hidden output of the forward direction
  <p>
  if (is_bidirectional)
  {
   (h_t[1], c_t[1]) = LASTMCell[0](x_0[seq_len-1], h_0[1], c_0[1]); // compute last input with h_0 and c_0 of the backward direction as inputs
   for (size_t s = 1; s < seq_len; s++)
   {
    output[s-1][batch_size][1] = h_t; // store previous hidden output for the first direction
    (h_t[1], c_t[1]) = LASTMCell[0](x_0[seq_len-s], h_t[1], c_t[1]); // compute remaining inputs in reverse order with h_t and c_t as inputs
   }
   output[0][batch_size][1] = h_t; // store last hidden output of the backward direction
  }
 }
 <p>
 \field input_size - number of elements in input
 \field hidden_size - number of elements in hidden and cell state
 \field num_layers - number of LSTM layers stacked together
 \field seq_len - size of the sequential input
 \field dropout - dropout ratio to apply between LSTM layers. doesn't apply to the last stacked layer, ignoerd when num_layers == 1
 \field lstm_flags - bit control flags (see BNNSLayerFlagsLSTM)
 \field batch_size - number of input & output samples
 \field sequence_descriptor - 1D array of sequence length elements (uint) to determine the batch size for each step
        (seq_len] > 1) and (sequence_descriptor.data == null) same batch_size will be used for all the sequence
 <p>
 - num_directions == 1 for unidirectional and 2 for bidirectional
 \field input_descriptor - contain the descriptors of the input, hidden input and cell state input data
        input_descriptor.data_desc - the layout should be either BNNSDataLayoutSNE with shape (input_size, batch_size, seq_len) or BNNSDataLayoutNSE with shape (input_size, seq_len, batch_size). If no layout is specified, SNE is assumed.
        input_descriptor.hidden_desc - the hierarchy of the data should be [num_layers][num_directions][batch_size][hidden_size] (C style multi array notation)
        input_descriptor.cell_state_desc - the hierarchy of the data should be [num_layers][num_directions][batch_size][hidden_size] (C style multi array notation)
 \field output_descriptor - contain the descriptors of the output, hidden output and cell state output data
        output_descriptor.data_desc - the layout should be either BNNSDataLayoutSNE with shape (num_directions*hidden_size, batch_size, seq_len) or BNNSDataLayoutNSE with shape (num_directions*hidden_size, seq_len, batch_size). The first dimension can be unpacked as a 2D array with hidden_size as the major dimension (i.e. it can be interpreted as a C array of shape [num_directions][hidden_size]). If no layout is specified, SNE is assumed.
        output_descriptor.hidden_desc - the last sequence hidden output. the hierarchy of the data should be [num_layers][num_directions][batch_size][hidden_size] (C style multi array notation)
        output_descriptor.cell_state_desc - the last sequence cell state output. the hierarchy of the data should be [num_layers][num_directions][batch_size][hidden_size] (C style multi array notation)
 \field forget_gate - forget descriptor (default activation is sigmoid), memory pointers ordered as [num_layers][num_directions][hidden_size][input_size/hidden_size] (C style multi array notation)
 \field input_gate - input descriptor (default activation is sigmoid), memory pointers ordered as  [num_layers][num_directions][hidden_size][input_size/hidden_size] (C style multi array notation)
 \field candidate_gate - candidate descriptor (default activation is tanh), memory pointers ordered as  [num_layers][num_directions][hidden_size][input_size/hidden_size] (C style multi array notation)
 \field output_gate - output descriptor (default activation is sigmoid), memory pointers ordered as [num_layers][num_directions][hidden_size][input_size/hidden_size] (C style multi array notation)
 \field hidden_activation - hidden activation layer to compute hidden output (default actviation tanh)
 */

public static class BNNSLayerParametersLSTM extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersLSTM() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersLSTM(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersLSTM(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersLSTM position(long position) {
        return (BNNSLayerParametersLSTM)super.position(position);
    }
    @Override public BNNSLayerParametersLSTM getPointer(long i) {
        return new BNNSLayerParametersLSTM((Pointer)this).offsetAddress(i);
    }

  public native @Cast("size_t") long input_size(); public native BNNSLayerParametersLSTM input_size(long setter);
  public native @Cast("size_t") long hidden_size(); public native BNNSLayerParametersLSTM hidden_size(long setter);
  public native @Cast("size_t") long batch_size(); public native BNNSLayerParametersLSTM batch_size(long setter);
  public native @Cast("size_t") long num_layers(); public native BNNSLayerParametersLSTM num_layers(long setter);
  public native @Cast("size_t") long seq_len(); public native BNNSLayerParametersLSTM seq_len(long setter);
  public native float dropout(); public native BNNSLayerParametersLSTM dropout(float setter);
  public native @Cast("uint32_t") int lstm_flags(); public native BNNSLayerParametersLSTM lstm_flags(int setter);
  public native @ByRef BNNSNDArrayDescriptor sequence_descriptor(); public native BNNSLayerParametersLSTM sequence_descriptor(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSLSTMDataDescriptor input_descriptor(); public native BNNSLayerParametersLSTM input_descriptor(BNNSLSTMDataDescriptor setter);
  public native @ByRef BNNSLSTMDataDescriptor output_descriptor(); public native BNNSLayerParametersLSTM output_descriptor(BNNSLSTMDataDescriptor setter);
  public native @ByRef BNNSLSTMGateDescriptor input_gate(); public native BNNSLayerParametersLSTM input_gate(BNNSLSTMGateDescriptor setter);
  public native @ByRef BNNSLSTMGateDescriptor forget_gate(); public native BNNSLayerParametersLSTM forget_gate(BNNSLSTMGateDescriptor setter);
  public native @ByRef BNNSLSTMGateDescriptor candidate_gate(); public native BNNSLayerParametersLSTM candidate_gate(BNNSLSTMGateDescriptor setter);
  public native @ByRef BNNSLSTMGateDescriptor output_gate(); public native BNNSLayerParametersLSTM output_gate(BNNSLSTMGateDescriptor setter);
  public native @ByRef BNNSActivation hidden_activation(); public native BNNSLayerParametersLSTM hidden_activation(BNNSActivation setter);
}


/**
 \abstract Arithmetic layer parameters
 \discussion
 Compute an arithmetic operation described by arithmetic_function.
 Descriptors are assumed to represent the same data if their descriptors data pointer are the same in which case the descriptor type and descriptor sizes, strides and data type must match.
 if input descriptors represent the same data, so should their gradient descriptors.
 For example, for a multiplication operation y=x*x, in1 and in2 are both pointing to x. in1_delta and in2_delta should both be pointing to the same gradient dx.
 <p>
 \field arithmetic_function arithmetic function
 \field arithmetic_function_fields a pointer to an arithmetic function field structure as described in BNNSArithmeticFunction, such as BNNSArithmeticBinary for arithmetic function BNNSArithmeticAdd
 \field activation Layer activation function
 */

public static class BNNSLayerParametersArithmetic extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersArithmetic() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersArithmetic(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersArithmetic(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersArithmetic position(long position) {
        return (BNNSLayerParametersArithmetic)super.position(position);
    }
    @Override public BNNSLayerParametersArithmetic getPointer(long i) {
        return new BNNSLayerParametersArithmetic((Pointer)this).offsetAddress(i);
    }

  public native @Cast("BNNSArithmeticFunction") int arithmetic_function(); public native BNNSLayerParametersArithmetic arithmetic_function(int setter);
  public native Pointer arithmetic_function_fields(); public native BNNSLayerParametersArithmetic arithmetic_function_fields(Pointer setter);
  public native @ByRef BNNSActivation activation(); public native BNNSLayerParametersArithmetic activation(BNNSActivation setter);
}


/** \abstract Permute Layer Parameters
 *
 *  \description
 *  This layer copies one tensor to another whilst permuting the order of the axes.
 *  It is assumed input and output axes are numbered as 0,1, ...N-1, where N is the dimension of the data layout.
 *  the permutation array specifies the input axis source for each output axis, such that the K'th element in the permutation array specify the input axis source for the K'th axis in the output descriptor
 *  for example, a permutation array [2,1,0] applied on a BNNSDataLayoutImageCHW tensor will result in axis reverse such that output axis 0 is input axis 2, output axis 1 is input axis 1, and output axis 2 is input axis 0.
 <p>
 *  notice:
 *  input and output data layout dimensions and data type must match
 *  output tensor sizes must be reordered according to the permutation specified in the permutation array
 *  permutation array values in indexes equal or beyond tenor dimension are being ignored
 *
 *  \field i_desc input descriptor
 *  \field o_desc output descriptor
 *  \field permutation permutation array
 */

public static class BNNSLayerParametersPermute extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersPermute() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersPermute(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersPermute(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersPermute position(long position) {
        return (BNNSLayerParametersPermute)super.position(position);
    }
    @Override public BNNSLayerParametersPermute getPointer(long i) {
        return new BNNSLayerParametersPermute((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersPermute i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersPermute o_desc(BNNSNDArrayDescriptor setter);
  public native @Cast("size_t") long permutation(int i); public native BNNSLayerParametersPermute permutation(int i, long setter);
  @MemberGetter public native @Cast("size_t*") SizeTPointer permutation();
}


/** \abstract Tensor Contraction Layer Parameters
 *
 *  \discussion
 *  This layer performs an arbitrary tensor contraction.
 *  A tensor contraction is a summation of the elements of two tensors over one or more indices. We represent this
 *  in the operation argument as a string using Einstein's summation convention.
 *  For example, the string
 *      "a_ijp, b_ijq -> o_pq"
 *  would represent the operation
 *      o_pq = alpha * \sum_{i,j} a_ijp * b_ijq.
 *  Inputs may be either trained parameters or inputs.
 *  If the name preceding the underscore is 'w' the tensor is assumed to be a trained parameter (weights), otherwise it is
 *  assumed to be an input (the letter has no other effect and may be whatever the user wishes). At most one of the inputs
 *  may be a trained parameter.
 *  If the names of the left-hand side inputs match, the operation is assumed to be the contraction of a tensor with itself (to e.g.
 *  calculate the Gram matrix or a dot product).
 *  In the case of one of the inputs being a weight or the operation is contraction of a tensor with itself, the regular BNNSFilterApply
 *  and BNNSFilterApplyBatch functions may be used with the resulting layer.
 *  If the operation has two inputs, the BNNSFilterApplyTwoInput or BNNSFilterApplyTwoInputBatch functions must be used instead.
 *
 *  This layer may also be used to copy from one layer to another with a permutation of indices.
 *  For example, the string
 *      "a_ij -> c_ji"
 *  would represent the operation
 *      C = alpha * A^T.
 *
 *  Broadcasting is supported by using '*' as the final index, e.g. "a_ij*, b_ij -> c_*" would match additional indices of a and c. * only
 *  ever represents indices that occur on both sides of the operation, and never an index over which summation is performed. A *
 *  on one side will only match indices represent by a * on the other side, and never indices represented by a letter. The wildcard may
 *  occur at either the start or end of the index sequence, however it must occur in the same position (start or end) for all operands.
 *
 *  Note that where index letters are matched, the sizes of the corresponding dimensions for the tensors must also match, unless one
 *  tensor has size 1, in which case it will be repeated (broadcast) to match the corresponding dimension.
 *
 *  \field operation string as described above
 *  \field alpha Scaling to be applied to result
 *  \field beta Scaling to be applied to output before adding result. Must be 0.0 or 1.0.
 *  \field iA_desc Descriptor of the A input matrix
 *  \field iB_desc Descriptor of the B input matrix
 *  \field o_desc Descriptor of the output matrix
 */

public static class BNNSLayerParametersTensorContraction extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersTensorContraction() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersTensorContraction(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersTensorContraction(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersTensorContraction position(long position) {
        return (BNNSLayerParametersTensorContraction)super.position(position);
    }
    @Override public BNNSLayerParametersTensorContraction getPointer(long i) {
        return new BNNSLayerParametersTensorContraction((Pointer)this).offsetAddress(i);
    }

  public native @Cast("const char*") BytePointer operation(); public native BNNSLayerParametersTensorContraction operation(BytePointer setter);
  public native float alpha(); public native BNNSLayerParametersTensorContraction alpha(float setter);
  public native float beta(); public native BNNSLayerParametersTensorContraction beta(float setter);
  public native @ByRef BNNSNDArrayDescriptor iA_desc(); public native BNNSLayerParametersTensorContraction iA_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor iB_desc(); public native BNNSLayerParametersTensorContraction iB_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersTensorContraction o_desc(BNNSNDArrayDescriptor setter);
}


/** \abstract Gram Matrix Layer Parameters
 *
 *  \discussion
 *  The Gram matrix is calculated as:
 *    G[ f, c ] = alpha * sum_{i,j} x[ i, j, f ] * x[ i, j, c ]
 *
 *  Any additional dimensions are broadcast.
 *  This operation is equivalent to using the TensorContraction layer with operation string "x_*ijf, x_*ijc -> G_*fc".
 *
 *  \field alpha Scaling to be applied to the result
 *  \field i_desc The tensor x.
 *  \field o_desc The tensor G.
 */

public static class BNNSLayerParametersGram extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersGram() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersGram(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersGram(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersGram position(long position) {
        return (BNNSLayerParametersGram)super.position(position);
    }
    @Override public BNNSLayerParametersGram getPointer(long i) {
        return new BNNSLayerParametersGram((Pointer)this).offsetAddress(i);
    }

  public native float alpha(); public native BNNSLayerParametersGram alpha(float setter);
  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersGram i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersGram o_desc(BNNSNDArrayDescriptor setter);
}


/** \abstract Resize Layer Parameters
 *
 *  \discussion
 *  Resize from between differently sized tensor using the specified method.
 *
 *  Resize is only performed in dimensions where tensor sizes differ between input and output.
 *  Resized dimensions must all either upsample or downsample. A mixture of the two is not permitted.
 *
 *  \field method - The interpolation method to use
 *  \field i_desc - NDArray descriptor for the input tensor.
 *  \field o_desc - NDArray descriptor for the output tensor. Dimensions must be an integral
 *                  multiple of those used for i_desc.
 *  \field align_corners - If true, aligns the corners of the upscaling grid to the centre of
 *                         scaling dimensions rather than the edges.
 */

public static class BNNSLayerParametersResize extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersResize() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersResize(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersResize(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersResize position(long position) {
        return (BNNSLayerParametersResize)super.position(position);
    }
    @Override public BNNSLayerParametersResize getPointer(long i) {
        return new BNNSLayerParametersResize((Pointer)this).offsetAddress(i);
    }

  public native @Cast("BNNSInterpolationMethod") int method(); public native BNNSLayerParametersResize method(int setter);
  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersResize i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersResize o_desc(BNNSNDArrayDescriptor setter);
  public native @Cast("bool") boolean align_corners(); public native BNNSLayerParametersResize align_corners(boolean setter);
}


/** \abstract Crop and Resize Layer Parameters
 *  \discussion only bilinear interpolation is supported now.
 *
 *  \field normalized_coordinates - If true, the bounding box coordinates are normalized to (0, 1)
 *  \field spatial_scale - Additional spatial scale that multiplies the bounding box coordinates.
 *  \field extrapolation_value - Value used for extrapolation, when applicable. Default to zero.
 *  \field sampling_mode - Sampling mode used to select sample points.
 *  \field box_coordinate_mode - Specifies the convention for specifying the four bounding box coordinates.
 *  \field method - The interpolation method to use
 */

public static class BNNSLayerParametersCropResize extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersCropResize() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersCropResize(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersCropResize(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersCropResize position(long position) {
        return (BNNSLayerParametersCropResize)super.position(position);
    }
    @Override public BNNSLayerParametersCropResize getPointer(long i) {
        return new BNNSLayerParametersCropResize((Pointer)this).offsetAddress(i);
    }

  public native @Cast("bool") boolean normalized_coordinates(); public native BNNSLayerParametersCropResize normalized_coordinates(boolean setter);
  public native float spatial_scale(); public native BNNSLayerParametersCropResize spatial_scale(float setter);
  public native float extrapolation_value(); public native BNNSLayerParametersCropResize extrapolation_value(float setter);
  public native @Cast("BNNSLinearSamplingMode") int sampling_mode(); public native BNNSLayerParametersCropResize sampling_mode(int setter);
  public native @Cast("BNNSBoxCoordinateMode") int box_coordinate_mode(); public native BNNSLayerParametersCropResize box_coordinate_mode(int setter);
  public native @Cast("BNNSInterpolationMethod") int method(); public native BNNSLayerParametersCropResize method(int setter);
}


/** \abstract Broadcast Matrix Multiplication Layer Parameters
 *
 *  \description
 *  Given two tensors calculate the tensor that results from performing the matrix
 *  multiplication on the last two indices. Indices other than the last two are matched
 *  from the back. If one tensor has higher dimension than the other, the lower rank matrix
 *  is broadcast in the missing dimensions. If a tensor has size 1 in a dimensions, then it
 *  is broadcast to match the size in the matching dimension of the other tensor.
 *  The output tensor may optionally be scaled by a scalar α, and the last two indices of
 *  each tensor may be transposed.
 *
 *  For example, if we have A_ijk and B_pqrkt, then indices i and r are matched and must
 *  have the same size. The following multiplications are performed:
 *  for p = 0:size(B,0)-1
 *    for q = 0:size(B,1)-1
 *      for r = 0:size(B,2)-1
 *        // Matrix multiplication on last two indices
 *        for j = 0:size(A,1)-1
 *          for t = 0:size(B,4)-1
 *            c_pqrjt = β c_pqrjt  + α \sum_k a_rjk b_pqrkt
 *  where alpha is scalar scaling factor.
 *  If dimension i of A had size 1, then we would broadcast in that dimension, with the final
 *  line of pseudocode above becoming
 *            c_pqrjt = β c_pqrjt  + α \sum_k a_1jk b_pqrkt
 *
 *  This layer is equivalent to the tensor contraction layer with one of the operation strings:
 *      transA    transB    operation
 *        F           F        "a_*ik, b_*kj -> c_*ij"
 *        F           T        "a_*ik, b_*jk -> c_*ij"
 *        T           F        "a_*ki, b_*kj -> c_*ij"
 *        T           T        "a_*ki, b_*jk -> c_*ij"
 *
 *  \field alpha - scalar by which to scale the result
 *  \field beta - scalar by which to scale output before adding result. Must be 0.0 or 1.0.
 *  \field transA - if true, transposes the last two dimensions of A
 *  \field transB - if true, transposes the last two dimensions of B
 *  \field quadratic - if true, it is assumed that this operation the multiplication of the matrix with itself, and inputB is ignored.
 *         This will make no difference on inference (except that higher performance may be achieved if quadratic=true),
 *         however the backward gradient calculation will be incorrect (or rather the desired gradient will otherwise be the sum
 *         of inputA_delta and inputB_delta if quadratic=false).
 *  \field a_is_weights - if true, the matrix A is treated as weights (i.e. fixed across all matrices in a batch on inference,
 *         accumulates gradients across a batch during training)
 *  \field b_is_weights - if true, the matrix B is treated as weights (i.e. fixed across all matrices in a batch on inference,
 *         accumulates gradients across a batch during training)
 *  \field iA_desc - descriptor for tensor A
 *  \field iB_desc - descriptor for tensor B
 *  \field o_desc - descriptor for tensor C
 */

public static class BNNSLayerParametersBroadcastMatMul extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersBroadcastMatMul() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersBroadcastMatMul(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersBroadcastMatMul(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersBroadcastMatMul position(long position) {
        return (BNNSLayerParametersBroadcastMatMul)super.position(position);
    }
    @Override public BNNSLayerParametersBroadcastMatMul getPointer(long i) {
        return new BNNSLayerParametersBroadcastMatMul((Pointer)this).offsetAddress(i);
    }

  public native float alpha(); public native BNNSLayerParametersBroadcastMatMul alpha(float setter);
  public native float beta(); public native BNNSLayerParametersBroadcastMatMul beta(float setter);
  public native @Cast("bool") boolean transA(); public native BNNSLayerParametersBroadcastMatMul transA(boolean setter);
  public native @Cast("bool") boolean transB(); public native BNNSLayerParametersBroadcastMatMul transB(boolean setter);
  public native @Cast("bool") boolean quadratic(); public native BNNSLayerParametersBroadcastMatMul quadratic(boolean setter);
  public native @Cast("bool") boolean a_is_weights(); public native BNNSLayerParametersBroadcastMatMul a_is_weights(boolean setter);
  public native @Cast("bool") boolean b_is_weights(); public native BNNSLayerParametersBroadcastMatMul b_is_weights(boolean setter);
  public native @ByRef BNNSNDArrayDescriptor iA_desc(); public native BNNSLayerParametersBroadcastMatMul iA_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor iB_desc(); public native BNNSLayerParametersBroadcastMatMul iB_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersBroadcastMatMul o_desc(BNNSNDArrayDescriptor setter);
}


/** \abstract Multihead Attention Parameters
 *
 *  \discussion
 *  This layer implements the multihead attention layer as described in the paper
 *  "Attention is All You Need" by A. Vaswani, N. Shazeer, N.Parmar, J. Uszkoreit, L. Jones, A. Gomez, L.Kaiser and I. Polosukhin.
 *
 *  Each input Q, K, V is projected num_head times and an attention calculation performed on each result, before the concatenated
 *  results are projected down to obtain an output. An optional dropout may be applied to the final result.
 *
 *  MultiheadAttention(Q, K, V) = concat(head_1, ... head_h) Wᴼ + epᴼᵀ                     where e is the vector of all 1s, and pᴼ is a bias vector
 *  head_i = Attention(QWᴾ_i + epᴾᵀ, KWᴷ_i + epᴷᵀ, VWⱽ_i + epⱽᵀ)                              where e is the vector of all 1s, and pᴾ, pᴷ and pⱽ are bias vectors
 *  Attention(Q, K, V) = dropout( softmax( mask( 1/sqrt(d_key) * Q [K; bᴷ; 0]ᵀ ) ) ) [V; bⱽ; 0]        where bᴷ and bⱽ are optional bias vectors and 0 row is added iff add_zero_attn is true.
 *  mask(R) = { r_ij + x_ij      if key_mask[ j ] is false, where X is the matrix described by the add_to_attention parameter
 *          { -inf                if key_mask[ j ] is true
 *
 *  The following are optional:
 *  - The use of projection bias vectors pᴾ, pᴷ, pⱽ, and pᴼ.
 *  - The use of attention bias vectors bᴷ and bⱽ.
 *  - The addition of the zero attention row.
 *  - The use of a key_mask.
 *  - The addition of X to the attention (this can be controlled on a per-apply call basis).
 *
 *  The following values are inferred from the input descriptors:
 *  num_heads - number of heads in the model, inferred from query.weights->size[2]
 *  target_length - target sequence length, inferred from query.target_desc->size[0]
 *  source_length - source sequence length, inferred from key.target_desc->size[0]
 *  d_model - dimension of model, inferred from query.target_desc->size[1]
 *  d_key - dimension of key space, inferred from key.weights->size[1]
 *  d_value - dimension of value space, inferred from output.target_desc->size[1]
 *  k_dim - dimension of input key sequence, inferred from key.target_desc->size[1]
 *  v_dim - dimension of input value sequence, inferred from value.target_desc->size[1]
 *  Note: In releases prior to macOS 12.0, iOS 15.0, watchOS 8.0 and tvOS 15.0, k_dim and v_dim must be equal to d_model.
 *
 *  Typical usage would be to set d_key = d_value = d_model / num_heads such that the total work
 *  involved is similar to that of a single headed attention layer of d_model dimension.
 *
 *  \field query describes the query-related input parameters and projection:
 *         .target_desc - a 2D tensor of shape target_length x d_model used as an input (Q above)
 *         .weights - a 3D tensor of shape d_model x d_key x num_heads giving a projection for each head from Q
 *                    to a d_key size space (Wᴾ above)
 *         .bias - a 2D tensor of shape d_key x num_heads added as a bias during the projection from Q (pᴾ above)
 *  \field key describes the key-related input parameters and projection:
 *         .target_desc - a 2D tensor of shape source_length x k_dim used as an input (K above)
 *         .weights - a 3D tensor of shape k_dim x d_key x num_heads giving a projection for each head from K
 *                    to a d_key size space (Wᴷ above)
 *         .bias - a 2D tensor of shape d_key x num_heads added as a bias during the projection from K (pᴷ above)
 *  \field value describes the value-related input parameters and projection:
 *         .target_desc - a 2D tensor of shape source_length x v_dim used as an input (V above)
 *         .weights - a 3D tensor of shape v_dim x d_value x num_heads giving a projection for each head from V
 *                    to a d_value size space (Wⱽ above)
 *         .bias - a 2D tensor of shape d_value x num_heads added as a bias during the projection from V (pⱽ above)
 *  \field add_zero_attn If true, a row of zeroes is added to the projected K and to V inputs to the Attention calculation
 *  \field key_attn_bias Optional, a 2D tensor of shape d_key x num_heads that is added as part of the attention calculation (bᴷ above)
 *         If not required, set key_attn_bias.data=NULL. If present, value_attn_bias must also be present.
 *  \field value_attn_bias Optional, a 2D tensor of shape d_value x num_heads that is added as part of the attention calculation (bⱽ above)
 *         If not required, set value_attn_bias.data=NULL. If present, key_attn_bias must also be present.
 *  \field output describes the output tensor and associated projection:
 *         .target_desc - a 2D tensor of shape target_length x d_model used for output of the result
 *         .weights - a 2D tensor of shape num_heads*d_value x d_model used to combine all heads into a single output (Wᴼ above)
 *         .bias - a 1D tensor of shape d_model added to the final result (pᴼ above)
 *  \field dropout the dropout probability (no dropout is performed if dropout is outside the range (0, 1)
 *  \field seed random seed used for dropout layer
 */

public static class BNNSLayerParametersMultiheadAttention extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersMultiheadAttention() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersMultiheadAttention(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersMultiheadAttention(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersMultiheadAttention position(long position) {
        return (BNNSLayerParametersMultiheadAttention)super.position(position);
    }
    @Override public BNNSLayerParametersMultiheadAttention getPointer(long i) {
        return new BNNSLayerParametersMultiheadAttention((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSMHAProjectionParameters query(); public native BNNSLayerParametersMultiheadAttention query(BNNSMHAProjectionParameters setter);
  public native @ByRef BNNSMHAProjectionParameters key(); public native BNNSLayerParametersMultiheadAttention key(BNNSMHAProjectionParameters setter);
  public native @ByRef BNNSMHAProjectionParameters value(); public native BNNSLayerParametersMultiheadAttention value(BNNSMHAProjectionParameters setter);
  public native @Cast("bool") boolean add_zero_attn(); public native BNNSLayerParametersMultiheadAttention add_zero_attn(boolean setter);
  public native @ByRef BNNSNDArrayDescriptor key_attn_bias(); public native BNNSLayerParametersMultiheadAttention key_attn_bias(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor value_attn_bias(); public native BNNSLayerParametersMultiheadAttention value_attn_bias(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSMHAProjectionParameters output(); public native BNNSLayerParametersMultiheadAttention output(BNNSMHAProjectionParameters setter);
  public native float dropout(); public native BNNSLayerParametersMultiheadAttention dropout(float setter);
  public native @Cast("uint32_t") int seed(); public native BNNSLayerParametersMultiheadAttention seed(int setter);
}


/**
 \discussion computing reduction function across selected dimensions
 specify the reduction axis by setting the o_desc.size[i] =1 (other dimensions must be similar to the input size)
 example:
 input [3][2][3], output [3][2][1] would be reduction on the width
 input [3][2][4], output [1][2][4] would be reduction on the channel
 input [3][2][4], output [1][2][1] would be reduction on the channel and width
 <p>
 - support only fp16/fp32 input and output (for now)
 - reduction function will be computed in fp32
 - when w_desc.data is set reduction is weighted (for each dimension, w_desc.size[i] == i_desc.size[i])
 - for SumLog operation, epsilon is added for each log operation
 <p>
 Sum reduction on channel example:
 input [3][2][4], output [1][2][4]
 for (size_t h = 0; h < 2; h++)
 {
  for (size_t w = 0; w < 4; w++)
  {
    float sum = 0.0f;
    for (size_t c = 0; c < 3; c++)
    {
      float w_val = 1.0f;
      if (weights.data) w_val = weights.data[c*2*4 + h*4 + w];
      sum += input.data[c*2*4 + h*4 + w] * w_val;
    }
    output.data[h*4 + w] = sum;
  }
 }
 <p>
 Mean by nonzero weights on width example
 input [3][2][4], output [3][2][1], weights[3][2][4]
 for (size_t c = 0; c < 3; c++)
 {
  for (size_t h = 0; h < 2; h++)
  {
    float sum = 0.0f;
    float count = 0.0f;
    for (size_t w = 0; w < 4; w++)
    {
      if ((weights.data) && (weights.data[c*2*4 + h*4 + w] != 0.0f)
      {
        w_val = weights.data[c*2*4 + h*4 + w];
        count += 1.0f;
        sum += input.data[c*2*4 + h*4 + w] * w_val;
      }
    }
    output.data[c*2*4 + h] = sum / count;
  }
 }
 <p>
 \field i_desc - input descriptor (pointer, data type, dimensions, dimension stride)
 \field o_desc - output descriptor (pointer, data type, dimensions, dimension stride)
 \field w_desc - weights descriptor when needed (pointer, data type, dimensions, dimension stride)
 \field reduce_func - reduction function across chosen axis
 \field epsilon - value added to SumLog reduction
 */
public static class BNNSLayerParametersReduction extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersReduction() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersReduction(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersReduction(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersReduction position(long position) {
        return (BNNSLayerParametersReduction)super.position(position);
    }
    @Override public BNNSLayerParametersReduction getPointer(long i) {
        return new BNNSLayerParametersReduction((Pointer)this).offsetAddress(i);
    }

  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersReduction i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersReduction o_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor w_desc(); public native BNNSLayerParametersReduction w_desc(BNNSNDArrayDescriptor setter);
  public native @Cast("BNNSReduceFunction") int reduce_func(); public native BNNSLayerParametersReduction reduce_func(int setter);
  public native float epsilon(); public native BNNSLayerParametersReduction epsilon(float setter);
}

/**
 \abstract Padding Layer Fields
 <p>
 \field i_desc                tensor descriptor for input
 \field o_desc               tensor descriptor for output.  For each dimension of the tensor ‘dim', the output size should  equal to i_desc.size[dim] + padding[dim][0] + padding[dim][1].
 \field padding_size     number of padding elements to add before and after the original data.
                    padding[d][0] gives the number of elements before, and padding[d][1] the number of elements after the data in dimension d.
                    Elements of the array that do not correspond to dimensions included in the tensor layout are not accessed.
 \field padding_mode   padding mode
 \field padding_value    the value to fill the padding area if BNNSPaddingModeConstant is used.  Up to 4 bytes can be stored, and first 'size' bytes are used depending on the data type.
 */


public static class BNNSLayerParametersPadding extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersPadding() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersPadding(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersPadding(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersPadding position(long position) {
        return (BNNSLayerParametersPadding)super.position(position);
    }
    @Override public BNNSLayerParametersPadding getPointer(long i) {
        return new BNNSLayerParametersPadding((Pointer)this).offsetAddress(i);
    }

    public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersPadding i_desc(BNNSNDArrayDescriptor setter);
    public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersPadding o_desc(BNNSNDArrayDescriptor setter);
    public native @Cast("size_t") long padding_size(int i, int j); public native BNNSLayerParametersPadding padding_size(int i, int j, long setter);
    @MemberGetter public native @Cast("size_t(*)[2]") SizeTPointer padding_size();
    public native @Cast("BNNSPaddingMode") int padding_mode(); public native BNNSLayerParametersPadding padding_mode(int setter);
    public native @Cast("uint32_t") int padding_value(); public native BNNSLayerParametersPadding padding_value(int setter);
}


/**
 * \abstract Embedding Layer Fields
 *
 * \discussion
 * Implements a lookup table into a dictionary array, the elements of which can be trained parameters.
 * Given a scalar index i, output is the i-th element of the dictionary array. An input may consist of multiple indices (words) that result in
 * multiple dictionary items (embeddings) being returned.
 * For example, if dictionary has shape (3, 4, 5), then a single dictionary item would have shape (3, 4) and input values would be in the
 * range [0, 4]. If the input shape was thus (6, 7), the output shape would be (3, 4, 6, 7), that is the concatenation of the dicitionary item
 * shape and the input shape.
 *
 * \field flags - Bit field for flags specifying additional behavior, such as scaling gradient by frequency
 * \field i_desc - Input descriptor for this layer. Must specify a (signed or unsigned) integer type.
 * \field o_desc - Output descriptor, of shape (dictionary_item.shape, i_desc.shape), where dictionary_item corresponds to the shape
 *        of dictionary without the final index.
 * \field dictionary - Dictionary of shape dictionary_item with an extra dimension of size num_embeddings appended.
 * \field padding_idx - If padding_idx is in the range [0, num_embeddings-1], then dictionary[:, padding_idx] is treated as always
 *        containing a zero tensor (forward apply will ignore the contents if dictionary[:, padding_idx], which may however change if an
 *        optimizer step is applied to them).
 * \field max_norm - If nonzero, then any vector with norm > max_norm will be renormalized to have norm max_norm during forward
 *        lookups. Type of norm is specified by norm_type.
 * \field norm_type - If max_norm is nonzero, the type of norm to use (specifically the p-norm where p=norm_type). If norm_type=0,
 *        the 2-norm is used.
 */

public static class BNNSLayerParametersEmbedding extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersEmbedding() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersEmbedding(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersEmbedding(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersEmbedding position(long position) {
        return (BNNSLayerParametersEmbedding)super.position(position);
    }
    @Override public BNNSLayerParametersEmbedding getPointer(long i) {
        return new BNNSLayerParametersEmbedding((Pointer)this).offsetAddress(i);
    }

  public native @Cast("BNNSEmbeddingFlags") int flags(); public native BNNSLayerParametersEmbedding flags(int setter);
  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersEmbedding i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersEmbedding o_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor dictionary(); public native BNNSLayerParametersEmbedding dictionary(BNNSNDArrayDescriptor setter);
  public native @Cast("size_t") long padding_idx(); public native BNNSLayerParametersEmbedding padding_idx(long setter);
  public native float max_norm(); public native BNNSLayerParametersEmbedding max_norm(float setter);
  public native float norm_type(); public native BNNSLayerParametersEmbedding norm_type(float setter);
}


/**
 \abstract Quantization layer parameters
 \discussion
 The Quantization layer converts higher precision tensors to lower precision tensors (Quantize) or lower precision tensors to higher precision tensors (Dequantize)
 The data_scale and data_bias fields in all provided descriptors are ignored.
 
 \field axis_mask dimension mask
 axis_mask describes the axis in which scale and bias are applied, if provided.
 To apply scale/bias on axis i, set axis_mask bit i to 1.
 axis_mask must have a single axis set to 1, or be equal to 0.
 The batch dimension may be specified as part of the axis mask by setting axis_mask = (1<<naxis), where naxis is the number of axes specified by the tensor layout
 If axis_mask is 0, the entire tensor will be quantized/dequantized using scalar scale and bias values, if provided.
 For example, when using a BNNSDataLayoutImageCHW layout,  axis_mask = 0 apply scale/bias on entire tensor, axis_mask = 1 apply scale/bias on width (W), axis_mask = 2 apply scale/bias on height (H), axis_mask = 4 apply scale/bias on channel (C), axis_mask = 8 apply scale/bias on the batch dimension.
 \field function quantizer function
 \field i_desc input descriptor
 \field o_desc output descriptor
 \field scale optional scale descriptor
 - ignored if scale.data is null
 - scale layout must be BNNSDataLayoutVector
 - scale vector size must be equal to the input tensor axis size, or equal to 1 if axis_mask is 0.
 \field bias optional bias descriptor
 - ignored if bias.data is null
 - bias layout must be BNNSDataLayoutVector
 - bias vector size must be equal to the input tensor axis size, or equal to 1 if axis_mask is 0.
 */

public static class BNNSLayerParametersQuantization extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerParametersQuantization() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerParametersQuantization(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerParametersQuantization(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerParametersQuantization position(long position) {
        return (BNNSLayerParametersQuantization)super.position(position);
    }
    @Override public BNNSLayerParametersQuantization getPointer(long i) {
        return new BNNSLayerParametersQuantization((Pointer)this).offsetAddress(i);
    }

  public native @Cast("size_t") long axis_mask(); public native BNNSLayerParametersQuantization axis_mask(long setter);
  public native @Cast("BNNSQuantizerFunction") int function(); public native BNNSLayerParametersQuantization function(int setter);
  public native @ByRef BNNSNDArrayDescriptor i_desc(); public native BNNSLayerParametersQuantization i_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor o_desc(); public native BNNSLayerParametersQuantization o_desc(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor scale(); public native BNNSLayerParametersQuantization scale(BNNSNDArrayDescriptor setter);
  public native @ByRef BNNSNDArrayDescriptor bias(); public native BNNSLayerParametersQuantization bias(BNNSNDArrayDescriptor setter);
}


/**
 \abstract parameters to describe sparsity attributes
 \discussion use this data structure as hint for BNNSNDArrayFullyConnectedSparsify
 for BNNSSparsityTypeUnstructured, sparsity_ratio is numerator / denominator
 \field flags - bit flags to define different states (currently reserved and should be initialized to zero)
 \field sparsity_ratio - numerator(sparsity_ratio[0]) and denominator(sparsity_ratio[1])indicating sparsity ratio. numerator must be less than denominator.
 \field sparsity_type - type of sparsity
 \field target_system - use this to specify different SoC where the inference will run. 
 */

public static class BNNSSparsityParameters extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSSparsityParameters() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSSparsityParameters(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSSparsityParameters(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSSparsityParameters position(long position) {
        return (BNNSSparsityParameters)super.position(position);
    }
    @Override public BNNSSparsityParameters getPointer(long i) {
        return new BNNSSparsityParameters((Pointer)this).offsetAddress(i);
    }

  public native @Cast("uint64_t") long flags(); public native BNNSSparsityParameters flags(long setter);
  public native @Cast("uint32_t") int sparsity_ratio(int i); public native BNNSSparsityParameters sparsity_ratio(int i, int setter);
  @MemberGetter public native @Cast("uint32_t*") IntPointer sparsity_ratio(); // numerator(sparsity_ratio[0]) and denominator(sparsity_ratio[1])indicating sparsity ratio. numerator must be less than denominator.
  public native @Cast("BNNSSparsityType") int sparsity_type(); public native BNNSSparsityParameters sparsity_type(int setter);
  public native @Cast("BNNSTargetSystem") int target_system(); public native BNNSSparsityParameters target_system(int setter);
}


// #pragma mark - Deprecated

/**
 <p>
 \abstract Image stack descriptor (DEPRECATED, Use BNNSNDArrayDescriptor)
 <p>
 \discussion
 An image stack is a sequence of images with the same width and height. Each image in the sequence is called a channel.
 For example, a RGB image will be stored as three separate channels. A pixel has only one scalar value, stored using the type
 described by <tt>data_type</tt>.
 <p>
 Pixel <tt>P(c,x,y)</tt> at position <tt>(x,y)</tt> in channel <tt>c</tt> is stored in
 <tt>data[x + row_stride * y + image_stride * c]</tt>, with
 <tt>x=0..width-1</tt>,
 <tt>y=0..height-1</tt>,
 <tt>c=0..channels-1</tt>. <tt>row_stride &geq; width</tt>, <tt>image_stride &geq; row_stride * height</tt>.
 <p>
 Int<n> types are converted to floating point using float Y = DATA_SCALE * (float)X + DATA_BIAS, and back to integer using Int<n> X = convert_and_saturate(Y / DATA_SCALE - DATA_BIAS)
 <p>
 \field width Image width
 \field height Image height
 \field channels Number of images in stack
 \field row_stride Increment (in values) between image rows
 \field image_stride Increment (in values) between image channels
 \field data_type Storage data type for image values. INDEXED data types are not allowed here.
 \field data_scale Conversion scale for image values, used for INT,UINT data types only
 \field data_bias Conversion bias for image values, used for INT,UINT data types only
 <p>
 */

public static class BNNSImageStackDescriptor extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSImageStackDescriptor() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSImageStackDescriptor(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSImageStackDescriptor(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSImageStackDescriptor position(long position) {
        return (BNNSImageStackDescriptor)super.position(position);
    }
    @Override public BNNSImageStackDescriptor getPointer(long i) {
        return new BNNSImageStackDescriptor((Pointer)this).offsetAddress(i);
    }


  public native @Cast("size_t") long width(); public native BNNSImageStackDescriptor width(long setter);
  public native @Cast("size_t") long height(); public native BNNSImageStackDescriptor height(long setter);
  public native @Cast("size_t") long channels(); public native BNNSImageStackDescriptor channels(long setter);
  public native @Cast("size_t") long row_stride(); public native BNNSImageStackDescriptor row_stride(long setter);
  public native @Cast("size_t") long image_stride(); public native BNNSImageStackDescriptor image_stride(long setter);

  public native @Cast("BNNSDataType") int data_type(); public native BNNSImageStackDescriptor data_type(int setter);
  public native float data_scale(); public native BNNSImageStackDescriptor data_scale(float setter);
  public native float data_bias(); public native BNNSImageStackDescriptor data_bias(float setter);

}


/**
 <p>
 \abstract Vector format descriptor (DEPRECATED, Use BNNSNDArrayDescriptor)
 <p>
 \discussion
 Represents a vector of dimension <tt>size</tt>.
 Each vector element is a scalar value, stored using the type specified in <tt>data_type</tt>.
 <p>
 Component <tt>V(i)</tt> at index <tt>i</tt> is stored in <tt>data[i]</tt>, with <tt>i=0..size-1</tt>.
 <p>
 Int<n> types are converted to floating point using float Y = DATA_SCALE * (float)X + DATA_BIAS, and back to integer using Int<n> X = convert_and_saturate(Y / DATA_SCALE - DATA_BIAS)
 <p>
 \field size Vector dimension
 \field data_type Storage data type for vector values. INDEXED data types are not allowed here.
 \field data_scale Conversion scale for vector values, used for INT,UINT data types only
 \field data_bias Conversion bias for vector values, used for INT,UINT data types only
 <p>
 */

public static class BNNSVectorDescriptor extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSVectorDescriptor() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSVectorDescriptor(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSVectorDescriptor(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSVectorDescriptor position(long position) {
        return (BNNSVectorDescriptor)super.position(position);
    }
    @Override public BNNSVectorDescriptor getPointer(long i) {
        return new BNNSVectorDescriptor((Pointer)this).offsetAddress(i);
    }


  public native @Cast("size_t") long size(); public native BNNSVectorDescriptor size(long setter);

  public native @Cast("BNNSDataType") int data_type(); public native BNNSVectorDescriptor data_type(int setter);
  public native float data_scale(); public native BNNSVectorDescriptor data_scale(float setter);
  public native float data_bias(); public native BNNSVectorDescriptor data_bias(float setter);

}


/**
 <p>
 \abstract Common layer parameters (DEPRECATED, Use BNNSNDArrayDescriptor)
 <p>
 \discussion Int<n> types are converted to floating point using float Y = DATA_SCALE * (float)X + DATA_BIAS, and back to integer using Int<n> X = convert_and_saturate(Y / DATA_SCALE - DATA_BIAS)
 <p>
 \field data Pointer to layer values (weights, bias), layout and size are specific to each layer
 \field data_type Storage data type for the values stored in <tt>data</tt>
 \field data_scale Conversion scale for values, used for INT data types only, ignored for INDEXED and FLOAT data types
 \field data_bias Conversion bias for values, used for INT data types only, ignored for INDEXED and FLOAT data types
 \field data_table Conversion table (256 values) for indexed floating point data, used for INDEXED data types only
 <p>
 */

public static class BNNSLayerData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSLayerData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSLayerData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSLayerData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSLayerData position(long position) {
        return (BNNSLayerData)super.position(position);
    }
    @Override public BNNSLayerData getPointer(long i) {
        return new BNNSLayerData((Pointer)this).offsetAddress(i);
    }


  public native @Const Pointer data(); public native BNNSLayerData data(Pointer setter);
  public native @Cast("BNNSDataType") int data_type(); public native BNNSLayerData data_type(int setter);
  public native float data_scale(); public native BNNSLayerData data_scale(float setter);
  public native float data_bias(); public native BNNSLayerData data_bias(float setter);
  public native @Const FloatPointer data_table(); public native BNNSLayerData data_table(FloatPointer setter);

}


/**
 <p>
 \abstract Convolution parameters (DEPRECATED, Use BNNSLayerParametersConvolution)
 <p>
 \discussion
 The convolution product Output = Weights &times; Input is defined as follows.  Pixel <tt>Output(o,x,y)</tt> of the output image stack receives:
 <br><tt>Output(o,x,y) = &sum;<sub>i,kx,ky</sub> Weight(o,i,kx,ky) * Input(i,x_stride * x + kx,y_stride * y + ky)</tt> with
 <tt>kx=0..k_width-1</tt>, <tt>ky=0..k_height-1</tt>,
 <tt>i=0..in_channels-1</tt>, <tt>o=0..out_channels-1</tt>,
 <tt>x=0..out_width-1</tt>, <tt>y=0..out_height-1</tt>.
 <p>
 After the convolution is applied, the output is updated with bias and/or activation function as follows:
 <br><tt>Output(o,x,y) = ActivationFunction( Bias(o) + Output(o,x,y) )</tt>.
 <p>
 Dimensions must satisfy:
 <br><tt>in_width + 2 * x_padding = x_stride * ( out_width - 1 ) + k_width</tt>, and <tt>in_height + 2 * y_padding = y_stride * ( out_height - 1 ) + k_height</tt>.
 <br>A common use case is <tt>x_stride=y_stride=1</tt>, and <tt>x_padding=y_padding=0</tt>. In that case, <tt>in_width = out_width + k_width - 1</tt>, and <tt>in_height = out_height + k_height - 1</tt>.
 <p>
 Padding is a border of 0 values virtually added to the input image.
 <p>
 Coefficient <tt>Weight(o,i,kx,ky)</tt> for output image <tt>o=0..out_channels-1</tt>, input image <tt>i=0..in_channels-1</tt>, and kernel point (kx,ky) is
 stored in <tt>weights[kx + k_width * (ky + k_height * (i + in_channels * o))]</tt>, where
 the convolution kernel dimensions are <tt>k_width,k_height</tt>.
 <p>
 \field x_stride X increment in the input image
 \field y_stride Y increment in the input image
 \field x_padding X padding, virtual 0 values added to the left and right of each channel of the input stack
 \field y_padding Y padding, virtual 0 values added to the top and bottom of each channel of the input stack
 \field k_width Width of the convolution kernel
 \field k_height Height of the convolution kernel
 \field in_channels Number of input channels
 \field out_channels Number of output channels
 \field weights Convolution weights, <tt>k_width * k_height * in_channels * out_channels</tt> values, with the layout described in the discussion
 \field bias Layer bias, <tt>out_channels</tt> values, one for each output channel
 \field activation Layer activation function
<p>
*/

public static class BNNSConvolutionLayerParameters extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSConvolutionLayerParameters() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSConvolutionLayerParameters(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSConvolutionLayerParameters(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSConvolutionLayerParameters position(long position) {
        return (BNNSConvolutionLayerParameters)super.position(position);
    }
    @Override public BNNSConvolutionLayerParameters getPointer(long i) {
        return new BNNSConvolutionLayerParameters((Pointer)this).offsetAddress(i);
    }


  public native @Cast("size_t") long x_stride(); public native BNNSConvolutionLayerParameters x_stride(long setter);
  public native @Cast("size_t") long y_stride(); public native BNNSConvolutionLayerParameters y_stride(long setter);
  public native @Cast("size_t") long x_padding(); public native BNNSConvolutionLayerParameters x_padding(long setter);
  public native @Cast("size_t") long y_padding(); public native BNNSConvolutionLayerParameters y_padding(long setter);
  public native @Cast("size_t") long k_width(); public native BNNSConvolutionLayerParameters k_width(long setter);
  public native @Cast("size_t") long k_height(); public native BNNSConvolutionLayerParameters k_height(long setter);
  public native @Cast("size_t") long in_channels(); public native BNNSConvolutionLayerParameters in_channels(long setter);
  public native @Cast("size_t") long out_channels(); public native BNNSConvolutionLayerParameters out_channels(long setter);

  public native @ByRef BNNSLayerData weights(); public native BNNSConvolutionLayerParameters weights(BNNSLayerData setter);
  public native @ByRef BNNSLayerData bias(); public native BNNSConvolutionLayerParameters bias(BNNSLayerData setter);
  public native @ByRef BNNSActivation activation(); public native BNNSConvolutionLayerParameters activation(BNNSActivation setter);

}


/**
 <p>
 \abstract Fully connected layer parameters (DEPRECATED, Use BNNSLayerParametersFullyConnected)
 <p>
 \discussion
 The output of a fully connected layer is the result of a matrix-vector product.
 The output vector is defined by <tt>Output(o) = &sum;<sub>i</sub> Weight(o,i) * Input(i)</tt> for <tt>i=0..in_size-1</tt>, <tt>o=0..out_size-1</tt>.
 <p>
 Coefficient <tt>Weight(o,i)</tt> is stored in <tt>weights[i + o * in_size]</tt>.
 <p>
 After the matrix product, the output is updated with bias and/or activation function as follows:
 <br><tt>Output(o) = ActivationFunction( Bias(o) + Output(o) )</tt>.
 <p>
 \field in_size Size of input vector
 \field out_size Size of output vector
 \field weights Matrix coefficients, <tt>in_size * out_size</tt> values, with the layout described in the discussion
 \field bias Layer bias, <tt>out_size</tt> values, one for each output component
 \field activation Layer activation function
<p>
*/

public static class BNNSFullyConnectedLayerParameters extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSFullyConnectedLayerParameters() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSFullyConnectedLayerParameters(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSFullyConnectedLayerParameters(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSFullyConnectedLayerParameters position(long position) {
        return (BNNSFullyConnectedLayerParameters)super.position(position);
    }
    @Override public BNNSFullyConnectedLayerParameters getPointer(long i) {
        return new BNNSFullyConnectedLayerParameters((Pointer)this).offsetAddress(i);
    }

  public native @Cast("size_t") long in_size(); public native BNNSFullyConnectedLayerParameters in_size(long setter);
  public native @Cast("size_t") long out_size(); public native BNNSFullyConnectedLayerParameters out_size(long setter);

  public native @ByRef BNNSLayerData weights(); public native BNNSFullyConnectedLayerParameters weights(BNNSLayerData setter);
  public native @ByRef BNNSLayerData bias(); public native BNNSFullyConnectedLayerParameters bias(BNNSLayerData setter);
  public native @ByRef BNNSActivation activation(); public native BNNSFullyConnectedLayerParameters activation(BNNSActivation setter);

}


/**
 \abstract Pooling layer parameters (DEPRECATED, Use BNNSLayerParametersPooling)
 <p>
 \discussion
 The pooling is defined as follows.  Pixel <tt>Output(o,x,y)</tt> of the output image stack receives:
 <br><tt>Output(o,x,y) = PoolingFunction( Input(o,x_stride * x + kx,y_stride * y + ky) )</tt> with <tt>kx=0..k_width-1</tt>, <tt>ky=0..k_height-1</tt>,
 <tt>o=0..out_channels-1</tt>, <tt>x=0..out_width-1</tt>, <tt>y=0..out_height-1</tt>.
 <p>
 After the pooling is applied, the output is updated with bias and/or activation function as follows:
 <br><tt>Output(o,x,y) = ActivationFunction( Bias(o) + Output(o,x,y) )</tt>.
 <p>
 Dimensions must satisfy:
 <br><tt>in_width + 2 * x_padding >= x_stride * (out_width - 1) + 1</tt>,
 <br><tt>iin_height + 2 * y_padding >= p->y_stride * (o->height - 1) + 1</tt>.
 <p>
 Padding is a border of 0 values virtually added to the input image.
 <p>
 \field x_stride X increment in the input image
 \field y_stride Y increment in the input image
 \field x_padding X padding, virtual 0 values added to the left and right of each channel of the input stack
 \field y_padding Y padding, virtual 0 values added to the top and bottom of each channel of the input stack
 \field k_width Width of the pooling kernel
 \field k_height Height of the pooling kernel
 \field in_channels Number of input channels
 \field out_channels Number of output channels
 \field pooling_function Selects the pooling function to apply to each sample
 \field bias Layer bias, <tt>out_channels</tt> values
 \field activation Layer activation function
 */


public static class BNNSPoolingLayerParameters extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSPoolingLayerParameters() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSPoolingLayerParameters(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSPoolingLayerParameters(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSPoolingLayerParameters position(long position) {
        return (BNNSPoolingLayerParameters)super.position(position);
    }
    @Override public BNNSPoolingLayerParameters getPointer(long i) {
        return new BNNSPoolingLayerParameters((Pointer)this).offsetAddress(i);
    }

  public native @Cast("size_t") long x_stride(); public native BNNSPoolingLayerParameters x_stride(long setter);
  public native @Cast("size_t") long y_stride(); public native BNNSPoolingLayerParameters y_stride(long setter);
  public native @Cast("size_t") long x_padding(); public native BNNSPoolingLayerParameters x_padding(long setter);
  public native @Cast("size_t") long y_padding(); public native BNNSPoolingLayerParameters y_padding(long setter);
  public native @Cast("size_t") long k_width(); public native BNNSPoolingLayerParameters k_width(long setter);
  public native @Cast("size_t") long k_height(); public native BNNSPoolingLayerParameters k_height(long setter);
  public native @Cast("size_t") long in_channels(); public native BNNSPoolingLayerParameters in_channels(long setter);
  public native @Cast("size_t") long out_channels(); public native BNNSPoolingLayerParameters out_channels(long setter);

  public native @Cast("BNNSPoolingFunction") int pooling_function(); public native BNNSPoolingLayerParameters pooling_function(int setter);
  public native @ByRef BNNSLayerData bias(); public native BNNSPoolingLayerParameters bias(BNNSLayerData setter);
  public native @ByRef BNNSActivation activation(); public native BNNSPoolingLayerParameters activation(BNNSActivation setter);

}


// #pragma mark - Filter parameters

/**
 <p>
 \abstract Common filter parameters
 <p>
 \field flags
 A logical OR of zero or more values from BNNSFlags.
 <p>
 \field n_threads
 If 0, use the best number of threads for the current machine.
 Otherwise, specifies the number of worker threads to execute.
 <p>
 \field alloc_memory
 If not NULL, will be called to allocate memory. Otherwise, posix_memalign() will be called.
 Must be compatible with the free_memory function.
 <p>
 \field free_memory
 If not NULL, will be called to deallocate memory. Otherwise, free() will be called.
 Must be compatible with the alloc_memory function.
 <p>
 */
public static class BNNSFilterParameters extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public BNNSFilterParameters() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BNNSFilterParameters(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSFilterParameters(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BNNSFilterParameters position(long position) {
        return (BNNSFilterParameters)super.position(position);
    }
    @Override public BNNSFilterParameters getPointer(long i) {
        return new BNNSFilterParameters((Pointer)this).offsetAddress(i);
    }


  public native @Cast("uint32_t") int flags(); public native BNNSFilterParameters flags(int setter);
  public native @Cast("size_t") long n_threads(); public native BNNSFilterParameters n_threads(long setter);
  public native BNNSAlloc alloc_memory(); public native BNNSFilterParameters alloc_memory(BNNSAlloc setter);
  public native BNNSFree free_memory(); public native BNNSFilterParameters free_memory(BNNSFree setter);

}

// #if !__has_include( <Availability.h> )
// # undef __API_DEPRECATED_WITH_REPLACEMENT
// # undef __API_DEPRECATED
// #endif

// #if __has_feature(assume_nonnull)
// #else
//   # undef _Nullable
// # undef _Null_unspecified
// # undef _Nonnull
// #endif

// #endif /* __BNNS_STRUCTURES_HEADER__ */


// Parsed from bnns.h

// Basic Neural Network Subroutines (BNNS)

// #ifndef __BNNS_HEADER__
// #define __BNNS_HEADER__

// #if __has_include( <TargetConditionals.h> )
// #include <TargetConditionals.h>
// #endif // __has_include( <TargetConditionals.h> )

// #include "bnns_constants.h"
// #include "bnns_structures.h"
// #include "bnns_graph.h"

// #include <sys/types.h>

// #if __has_include( <Availability.h> )
// #include <Availability.h>
// #else // __has_include( <Availability.h> )
// #define __API_AVAILABLE(...)
// #define __API_DEPRECATED(...)
// #define __API_DEPRECATED_WITH_REPLACEMENT(...)
// #endif // __has_include( <Availability.h> )

// #if __has_feature(assume_nonnull)
// #else
// #define _Null_unspecified
// #define _Nullable
// #define _Nonnull
// #endif

// #ifdef __cplusplus
// #endif

/*

 Logging

 When a parameter is invalid or an internal error occurs, an error message will be logged.
 Some combinations of parameters may not be supported. In that case, an info message will be logged.

 */

// #pragma mark - Filter creation

/**
 <p>
 \abstract Filter object
 <p>
 */
@Namespace @Name("void") @Opaque public static class BNNSFilter extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public BNNSFilter() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSFilter(Pointer p) { super(p); }
}

/**
 <p>
 \abstract Create a convolution layer filter
 <p>
 \discussion
 Creates a filter applying the convolution described in <tt>layer_params</tt>.
 Some combinations of the parameters may not be supported, in which case the call will fail.
 <p>
 @param layer_params Layer parameters and input, weights, output, bias and activation descriptors
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateLayerConvolution(@Const BNNSLayerParametersConvolution layer_params,
                                            @Const BNNSFilterParameters filter_params);

/**
 <p>
 \abstract Create a transposed convolution layer filter (also known as deconvolution)
 <p>
 \discussion
 Creates a filter applying the transposed convolution described in <tt>layer_params</tt>.
 Some combinations of the parameters may not be supported, in which case the call will fail.
 Currently only BNNSDataTypeFloat32 data type is supported.
 @param layer_params Layer parameters and input, weights, output, bias and activation descriptors
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateLayerTransposedConvolution(@Const BNNSLayerParametersConvolution layer_params,
                                                      @Const BNNSFilterParameters filter_params);

/**
 <p>
 \abstract Create a fully connected layer filter
 <p>
 \discussion
 Creates a filter applying the fully connected layer described in <tt>layer_params</tt>.
 Some combinations of the parameters may not be supported, in which case the call will fail.
 <p>
 @param layer_params  input, weights, output, bias and activation descriptors
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateLayerFullyConnected(@Const BNNSLayerParametersFullyConnected layer_params,
                                               @Const BNNSFilterParameters filter_params);

// #if !0

/**
 <p>
 \abstract Create a pooling layer filter
 <p>
 \discussion
 Creates a filter applying the pooling layer described in <tt>layer_params</tt>
 Some combinations of the parameters may not be supported, in which case the call will fail.
 <p>
 @param layer_params Layer parameters and input, weights, output, bias and activation descriptors
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateLayerPooling(@Const BNNSLayerParametersPooling layer_params,
                                        @Const BNNSFilterParameters filter_params);

// #endif 

/**
 <p>
 \abstract Create a Activation/Conversion layer filter
 <p>
 \discussion
 Creates a filter applying the given activation function or conversions.
 Input and output must have the same number of elements.
 <p>
 @param layer_params  input, output and activation descriptors
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateLayerActivation(@Const BNNSLayerParametersActivation layer_params,
                                           @Const BNNSFilterParameters filter_params);

// #if !0

/**
 <p>
 \abstract Create a Loss layer filter
 <p>
 \discussion
 Creates a filter applying loss function and loss reduction.
 <p>
 @param layer_params  input, output and loss description
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateLayerLoss(@Const Pointer layer_params,
                                     @Const BNNSFilterParameters filter_params);

/**
 <p>
 \abstract Create a Normalization layer filter
 <p>
 \discussion
 Creates a normalization filter that normalize inputs based on mean, variance and trainable parameters beta and gamma.
 <p>
 @param normType type of normalization, currently supporting batch, instance, layer and group norm.
 @param layer_params  normalization layer parameters pointer.
 @param filter_params Filter runtime parameters, may be NULL for default parameters.
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateLayerNormalization(@Cast("BNNSFilterType") int normType,
                                              @Const BNNSLayerParametersNormalization layer_params,
                                              @Const BNNSFilterParameters filter_params);

// #endif 

/**
 <p>
 \abstract Create an Arithmetic layer filter
 <p>
 \discussion
 Creates an Arithmetic filter such as add, subtract, multiply.
 <p>
 @param layer_params  Arithmetic layer parameters pointer.
 @param filter_params Filter runtime parameters, may be NULL for default parameters.
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateLayerArithmetic(@Const BNNSLayerParametersArithmetic layer_params,
                                           @Const BNNSFilterParameters filter_params);

// #if !0

/**
 <p>
 \abstract Create a Permute layer filter
 <p>
 \discussion
 Creates a permute layer filter that copies one tensor to another whilst permuting the order of the axes
 <p>
 @param layer_params  Permute layer parameters pointer.
 @param filter_params Filter runtime parameters, may be NULL for default parameters.
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateLayerPermute(@Const BNNSLayerParametersPermute layer_params,
                                        @Const BNNSFilterParameters filter_params);

/*
 @abstract Create a dropout filter

 @discussion
 The function will:
     validate correctness of the parameters
     create a new dropout filter

 @param layer_params dropout layer parameters
 @param filter_params filter parameters
 @return A new non-NULL filter on success, and NULL on failure.

 */
public static native BNNSFilter BNNSFilterCreateLayerDropout(@Const BNNSLayerParametersDropout layer_params,
                                        @Const BNNSFilterParameters filter_params);

/**
 \abstract Create a padding filter
<p>
\discussion
The function will:
   validate correctness of the filter parameters
   create a new padding filter
<p>
@param layer_params padding layer parameters
@param filter_params filter parameters
@return A new non-NULL filter on success, and NULL on failure.
<p>
*/

public static native BNNSFilter BNNSFilterCreateLayerPadding(@Const BNNSLayerParametersPadding layer_params,
                                        @Const BNNSFilterParameters filter_params);

// #endif 

/** \abstract Create a layer representing a broadcast matrix multiplication
 *
 *  \discussion See BNNSLayerParametersBroadcastMatMul for a full description of this layer.
 *
 *  \seealso BNNSLayerParametersBroadcastMatMul
 *
 *  @param layer_params layer description
 *  @param filter_params Filter runtime parameters, may be NULL for default parameters
 *  @return A new non-NULL filter on success, and NULL on failure.
 */
public static native BNNSFilter BNNSFilterCreateLayerBroadcastMatMul(@Const BNNSLayerParametersBroadcastMatMul layer_params,
                                                @Const BNNSFilterParameters filter_params);

/** \abstract Creates a layer representing an arbitrary tensor contraction
 *
 *  \discussion
 *  For a full discussion of this layer, see BNNSLayerParametersTensorContraction.
 *
 *  \seealso BNNSLayerParametersTensorContraction
 *
 *  @param layer_params layer description
 *  @param filter_params Filter runtime parameters, may be NULL for default parameters
 *  @return A new non-NULL filter on success, and NULL on failure.
 */
public static native BNNSFilter BNNSFilterCreateLayerTensorContraction(@Const BNNSLayerParametersTensorContraction layer_params,
                                                  @Const BNNSFilterParameters filter_params);

// #if !0

/** \abstract Create a layer representing a Gram matrix calculation
 *
 *  \discussion
 *  Performs the Gram matrix calculation:
 *    y[ f, c ] = alpha * sum_{i,j} x[ i, j, f ] * x[ i, j, c ]
 *
 *  \seealso BNNSLayerParametersGram
 *
 *  @param layer_params layer description
 *  @param filter_params Filter runtime parameters, may be NULL for default parameters
 *  @return A new non-NULL filter on success, and NULL on failure.
 */
public static native BNNSFilter BNNSFilterCreateLayerGram(@Const BNNSLayerParametersGram layer_params,
                                     @Const BNNSFilterParameters filter_params);

/** \abstract Create a layer representing a resizing in one or more dimensions
 *
 *  \discussion See BNNSLayerParametersResize for a full description of this layer.
 *
 *  \seealso BNNSLayerParametersResize
 *
 *  @param layer_params layer description
 *  @param filter_params Filter runtime parameters, may be NULL for default parameters
 *  @return A new non-NULL filter on success, and NULL on failure.
*/
public static native BNNSFilter BNNSFilterCreateLayerResize(@Const BNNSLayerParametersResize layer_params,
                                       @Const BNNSFilterParameters filter_params);

/** \abstract Create a multiheaded attention layer
 *
 *  \discussion See BNNSLayerParametersMultiheadAttention for a full description of this layer.
 *
 *  \seealso BNNSLayerParametersMultiheadAttention
 *
 *  @param layer_params layer description
 *  @param filter_params Filter runtime parameters, may be NULL for default parameters
 *  @return A new non-NULL filter on success, and NULL on failure.
 */
public static native BNNSFilter BNNSFilterCreateLayerMultiheadAttention(@Const BNNSLayerParametersMultiheadAttention layer_params,
                                                   @Const BNNSFilterParameters filter_params);

/** \abstract Create a reduction layer
 *
 *  \discussion See BNNSLayerParametersReduction for a full description of this layer.
 *
 *  \seealso BNNSLayerParametersReduction
 *
 *  @param layer_params layer description
 *  @param filter_params Filter runtime parameters, may be NULL for default parameters
 *  @return A new non-NULL filter on success, and NULL on failure.
 */
public static native BNNSFilter BNNSFilterCreateLayerReduction(@Const BNNSLayerParametersReduction layer_params,
                                          @Const BNNSFilterParameters filter_params);

/**
  <p>
  \abstract Create a fused filter
  <p>
  \discussion
  Create an N layer fused filter that process input in the following way: input -> filter0 -> filter1 -> ... -> filter N-1 -> output
  first N-1 filters must have activation function BNNSActivationFunctionIdentity in training.
  last filter may have a different activation function. gradient computation restrictions on last activation function are the same as in BNNSFilterApplyBackwardBatch.
  For K between 0 and N-2, the K filter output descriptor and the K+1 filter input descriptor  must have the same sizes, strides and data type.
  <p>
  Initial implementation support fusing 2 filters in the following configurations:
  Configuration 1: Convolution -> Normalization
  filter0 is convolution and filter1 is normalization. for example, the filter_type and layer_params arrays when using batchnorm should be as follows:
  filter_type: [BNNSConvolution, BNNSBatchNorm]
  layer_params: [pointer to BNNSLayerParametersConvolution, pointer to BNNSLayerParametersNormalization]
  <p>
  Configuration 2: FullyConnected -> Normalization
  filter0 is fully connected and filter1 is normalization. for example, the filter_type and layer_params arrays when using batchnorm should be as follows:
  filter_type: [BNNSFullyConnected, BNNSBatchNorm]
  layer_params: [pointer to BNNSLayerParametersFullyConnected, pointer to BNNSLayerParametersNormalization]
  <p>
  Configuration 3: Transposed Convolution -> Normalization
  filter0 is transposed convolution and filter1 is normalization. for example, the filter_type and layer_params arrays when using batchnorm should be as follows:
  filter_type: [BNNSTransposedConvolution, BNNSBatchNorm]
  layer_params: [pointer to BNNSLayerParametersConvolution, pointer to BNNSLayerParametersNormalization]
  <p>
  Configuration 4: Convolution -> Quantization
  filter0 is convolution and filter1 is quantization. The filter_type and layer_params arrays should be as follows:
  filter_type: [BNNSConvolution, BNNSQuantization]
  layer_params: [pointer to BNNSLayerParametersConvolution, pointer to BNNSLayerParametersQuantization]
  input and ouput descriptor data pointers in BNNSLayerParametersQuantization are ignored
  Note that if the quantization layer uses batch as an axis with scale and/or bias, the batch size is encoded in the quantization layer parameters. In this case, if the batch size changes, the filter must be destroyed and recreated.
 
  Configuration 5: FullyConnected -> Quantization
  filter0 is fully connected and filter1 is quantization. The filter_type and layer_params arrays should be as follows:
  filter_type: [BNNSFullyConnected, BNNSQuantization]
  layer_params: [pointer to BNNSLayerParametersFullyConnected, pointer to BNNSLayerParametersQuantization]
  input and ouput descriptor data pointers in BNNSLayerParametersQuantization are ignored
  Note that if the quantization layer uses batch as an axis with scale and/or bias, the batch size is encoded in the quantization layer parameters. In this case, if the batch size changes, the filter must be destroyed and recreated.
 
  Configuration 6: Transposed Convolution -> Quantization
  filter0 is transposed convolution and filter1 is quantization. The filter_type and layer_params arrays should be as follows:
  filter_type: [BNNSTransposedConvolution, BNNSQuantization]
  layer_params: [pointer to BNNSLayerParametersConvolution, pointer to BNNSLayerParametersQuantization]
  input and ouput descriptor data pointers in BNNSLayerParametersQuantization are ignored
  Note that if the quantization layer uses batch as an axis with scale and/or bias, the batch size is encoded in the quantization layer parameters. In this case, if the batch size changes, the filter must be destroyed and recreated.
 
  Configuration 7: Arithmetic -> Normalization
  filter0 is arithmetic and filter1 is normalization. for example, the filter_type and layer_params arrays when using batchnorm should be as follows:
  filter_type: [BNNSArithmetic, BNNSBatchNorm]
  layer_params: [pointer to BNNSLayerParametersArithmetic, pointer to BNNSLayerParametersNormalization]
  <p>
  @param number_of_fused_filters number of filters to fuse
  @param filter_type pointer to an array of filter type, array size must be number_of_fused_filters
  @param layer_params pointer to an array of layer parameter pointers. layer_params array size must be number_of_fused_filters
  every layer parameter structure must be valid and match the type specified in filter_type array, such that layer parameter at index i of layer_params can be used to create a stand-alone filter of the type specified by the filter type in filter_type array at index i.
  @param filter_params Filter runtime parameters, may be NULL for default parameters.
  <p>
  @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateFusedLayer(@Cast("const size_t") long number_of_fused_filters,
                                      @Cast("const BNNSFilterType*") IntPointer filter_type,
                                      @Cast("const void**") PointerPointer layer_params,
                                      @Const BNNSFilterParameters filter_params);
public static native BNNSFilter BNNSFilterCreateFusedLayer(@Cast("const size_t") long number_of_fused_filters,
                                      @Cast("const BNNSFilterType*") IntPointer filter_type,
                                      @Cast("const void**") @ByPtrPtr Pointer layer_params,
                                      @Const BNNSFilterParameters filter_params);
public static native BNNSFilter BNNSFilterCreateFusedLayer(@Cast("const size_t") long number_of_fused_filters,
                                      @Cast("const BNNSFilterType*") IntBuffer filter_type,
                                      @Cast("const void**") @ByPtrPtr Pointer layer_params,
                                      @Const BNNSFilterParameters filter_params);
public static native BNNSFilter BNNSFilterCreateFusedLayer(@Cast("const size_t") long number_of_fused_filters,
                                      @Cast("const BNNSFilterType*") int[] filter_type,
                                      @Cast("const void**") @ByPtrPtr Pointer layer_params,
                                      @Const BNNSFilterParameters filter_params);

/** \abstract Create an embedding layer
 *
 *  \discussion
 *  See the description of BNNSLayerParametersEmbedding for a full explanation of this layer.
 *
 *  \seealso BNNSLayerParametersEmbedding
 *
 *  @param layer_params layer description
 *  @param filter_params Filter runtime parameters, may be NULL for default parameters
 *  @return A new non-NULL filter on success, and NULL on failure.
 */
public static native BNNSFilter BNNSFilterCreateLayerEmbedding(@Const BNNSLayerParametersEmbedding layer_params,
                                          @Const BNNSFilterParameters filter_params);

// #endif 

// #pragma mark - Inference

/**
  \abstract Apply a filter
  <p>
  @param filter Filter to apply
  @param in Pointer to the input data
  @param out Pointer to the output data
  <p>
  @return 0 on success, and -1 on failure.
 */
public static native int BNNSFilterApply(BNNSFilter filter, @Const Pointer in, Pointer out);

/**
  <p>
  \abstract Apply a filter to several pairs of (input, output) data
  <p>
  \discussion
  The filter is applied for each of the <tt>batch_size</tt> inputs, and produces <tt>batch_size</tt> outputs.
  <tt>in</tt> (resp. <tt>out</tt>) is expected to point to <tt>batch_size</tt> times the input (resp. output) object size defined when the filter was created.
  <p>
  @param filter Filter to apply
  @param batch_size Number of (input, output) pairs to process
  @param in Pointer to the input data
  @param in_stride Increment (in values) between inputs
  @param out Pointer to the output data
  @param out_stride Increment (in values) between outputs
  <p>
  @return 0 on success, and -1 on failure.
 <p>
 */

public static native int BNNSFilterApplyBatch(BNNSFilter filter,
                         @Cast("size_t") long batch_size,
                         @Const Pointer in,
                         @Cast("size_t") long in_stride,
                         Pointer out,
                         @Cast("size_t") long out_stride);

// #if !0

/**
 \abstract Applies a previously created pooling layer filter
 <p>
 \discussion
 Pooling layer filter is applied for each of the batch_size inputs, and produces batch_size outputs. indices is optional.
 in (resp. out) is expected to point to batch_size times the input (resp. output) object size defined when the filter was created.
 indices has the same size as output if not null.
 <p>
 @param filter Filter to apply
 @param batch_size Number of (input, output, indices)  to process
 @param in Pointer to the input data
 @param in_stride Increment (in values) between inputs
 @param out  Pointer to the output data
 @param out_stride Increment (in values) between outputs
 @param indices  Pointer to the indices data generated by max pooling.
 - max pooling produces indices if not null. indices must have the same dimension and stride as the output data.
 - max unpooling requires a valid pointer. indices must have the same dimension and stride as the input data.
 - ignored for other pooling functions
 @param idx_stride Increment (in values) between indices
 */
public static native int BNNSPoolingFilterApplyBatch(BNNSFilter filter, @Cast("size_t") long batch_size,
                                @Const Pointer in, @Cast("size_t") long in_stride,
                                Pointer out, @Cast("size_t") long out_stride,
                                @Cast("size_t*") SizeTPointer indices, @Cast("size_t") long idx_stride);

/**
 \abstract Applies a previously created pooling layer filter, supporting multiple index data types
 <p>
 \discussion
 The only difference between this function and BNNSPoolingFilterApplyBatch is that
 BNNSPoolingFilterApplyBatch requires indices to be size_t,
 while BNNSPoolingFilterApplyBatchEx allows indices to have various types.
 Currently, only uint64_t and uint32_t are allowed for indices.
 
 @param filter Filter to apply
 @param batch_size Number of (input, output, indices)  to process
 @param in Pointer to the input data
 @param in_stride Increment (in values) between inputs
 @param out  Pointer to the output data
 @param out_stride Increment (in values) between outputs
 @param indices  Pointer to the indices data generated by max pooling.
 - max pooling produces indices if not null. indices must have the same dimension and stride as the output data.
 - max unpooling requires a valid pointer. indices must have the same dimension and stride as the input data.
 - ignored for other pooling functions
 @param idx_stride Increment (in values) between indices
 */
public static native int BNNSPoolingFilterApplyBatchEx(BNNSFilter filter, @Cast("size_t") long batch_size,
                                  @Const Pointer in, @Cast("size_t") long in_stride,
                                  Pointer out, @Cast("size_t") long out_stride,
                                  @Cast("const BNNSDataType") int indices_data_type, Pointer indices, @Cast("size_t") long idx_stride);

// #endif 

/**
  <p>
  \abstract Apply a filter
  <p>
  @param filter Filter to apply
  @param inA Pointer to the first input tensor
  @param inB Pointer to the second input tensor
  @param out Pointer to the output data
  <p>
  @return 0 on success, and -1 on failure.
*/
public static native int BNNSFilterApplyTwoInput(BNNSFilter filter,
                            @Const Pointer inA,
                            @Const Pointer inB,
                            Pointer out);

/**
  <p>
  \abstract Apply a filter to a several pairs of (input, output) data
  <p>
  \discussion
  The filter is applied for each of the <tt>batch_size</tt> inputs, and produces <tt>batch_size</tt> outputs.
  <tt>in</tt> (resp. <tt>out</tt>) is expected to point to <tt>batch_size</tt> times the input (resp. output) object size defined when the filter was created.
  <p>
  @param filter Filter to apply
  @param batch_size Number of (input, output) pairs to process
  @param inA Pointer to the first input tensor
  @param inA_stride Increment (in values) between inputs in the first tensor
  @param inB Pointer to the second input tensor
  @param inB_stride Increment (in values) between inputs in the second tensor
  @param out Pointer to the output data
  @param out_stride Increment (in values) between outputs
  <p>
  @return 0 on success, and -1 on failure.
<p>
*/
public static native int BNNSFilterApplyTwoInputBatch(BNNSFilter filter,
                                 @Cast("size_t") long batch_size,
                                 @Const Pointer inA,
                                 @Cast("size_t") long inA_stride,
                                 @Const Pointer inB,
                                 @Cast("size_t") long inB_stride,
                                 Pointer out,
                                 @Cast("size_t") long out_stride);

// #if !0

/**
 <p>
 \abstract Apply a normalization filter to several pairs of (input, output) data
 <p>
 \discussion
 The filter is applied for each of the <tt>batch_size</tt> inputs, and produces <tt>batch_size</tt> outputs.
 <tt>in</tt> (resp. <tt>out</tt>) is expected to point to <tt>batch_size</tt> times the input (resp. output) object size defined when the filter was created.
 <p>
 Normalization filter supports two different modes - training and inference.
 In training mode, only current batch/instance/layer/group statistics are used to normalize the input.
 In addition, training mode may store information internally to be used during backward computation.
 For batch norm and instance norm, moving mean and moving variance are computed during training
 so they can be later used during inference, ignored if null.
 For layer norm and group norm, moving mean and moving variance are not supported and ignored.
 <p>
 For batch norm and instance norm,  moving mean and moving variance are used to normalize the input during inference if not null.
 Otherwise, current batch/instance/layer/group statistics are used to normalize the input.
 <p>
 output address equal to input address (in-place) is supported for both training and inference
 <p>
 @param filter Filter to apply
 @param batch_size Number of (input, output) pairs to process
 @param in Pointer to the input data
 @param in_stride Increment (in values) between inputs
 @param out Pointer to the output data
 @param out_stride Increment (in values) between outputs
 @param training true if training, false if inference
 <p>
 @return 0 on success, and -1 on failure.
 <p>
 */

public static native int BNNSNormalizationFilterApplyBatch(BNNSFilter filter,
                                      @Cast("size_t") long batch_size,
                                      @Const Pointer in,
                                      @Cast("size_t") long in_stride,
                                      Pointer out,
                                      @Cast("size_t") long out_stride,
                                      @Cast("bool") boolean training);

/**
 <p>
 \abstract Apply a fused filter to several pairs of (input, output) data
 <p>
 \discussion
 The filter is applied for each of the <tt>batch_size</tt> inputs, and produces <tt>batch_size</tt> outputs.
 <tt>in</tt> (resp. <tt>out</tt>) is expected to point to <tt>batch_size</tt> times the input (resp. output) object size defined when the filter was created.
 <p>
 @param filter Filter to apply
 @param batch_size Number of (input, output) pairs to process
 @param in Pointer to the input data
 @param in_stride Increment (in values) between inputs
 @param out  Pointer to the output data
 @param out_stride Increment (in values) between outputs
 @param training true if training, false if inference
 -ignored if none of the filters is batchnorm
 -see training flag information in BNNSNormalizationFilterApplyBatch
 <p>
 @return 0 on success, and -1 on failure.
 <p>
 */

public static native int BNNSFusedFilterApplyBatch(BNNSFilter filter,
                              @Cast("size_t") long batch_size,
                              @Const Pointer in,
                              @Cast("size_t") long in_stride,
                              Pointer out,
                              @Cast("size_t") long out_stride,
                              @Cast("bool") boolean training);

/**
 <p>
 \abstract Apply a fused filter to several pairs of (input set, output) data
 <p>
 \discussion
 The filter is applied for each of the <tt>batch_size</tt> input set, and produces <tt>batch_size</tt> outputs.
 <tt>in</tt> (resp. <tt>out</tt>) is expected to point to <tt>batch_size</tt> times the input (resp. output) object size defined when the filter was created.
 <p>
 Currently only fused arithmetic -> normalization configuration is supported.
 <p>
 @param filter Filter to apply
 @param batch_size Number of (input sets, output) pairs to process
 @param number_of_inputs number of inputs for the arithmetic operation
 @param in pointer to an array of input pointers. in array size must be number_of_inputs.
 @param in_stride pointer to an array of input strides, each stride is an Increment (in values) between inputs in the batch for a corresponding input in the in array.
 @param out Pointer to the output data
 @param out_stride Increment (in values) between outputs
 @param training true if training, false if inference
 -ignored if none of the filters is batchnorm
 -see training flag information in BNNSNormalizationFilterApplyBatch
 <p>
 @return 0 on success, and -1 on failure.
 <p>
 */

public static native int BNNSFusedFilterApplyMultiInputBatch(BNNSFilter filter,
                                        @Cast("size_t") long batch_size,
                                        @Cast("size_t") long number_of_inputs,
                                        @Cast("const void**") PointerPointer in,
                                        @Cast("const size_t*") SizeTPointer in_stride,
                                        Pointer out,
                                        @Cast("size_t") long out_stride,
                                        @Cast("bool") boolean training);
public static native int BNNSFusedFilterApplyMultiInputBatch(BNNSFilter filter,
                                        @Cast("size_t") long batch_size,
                                        @Cast("size_t") long number_of_inputs,
                                        @Cast("const void**") @ByPtrPtr Pointer in,
                                        @Cast("const size_t*") SizeTPointer in_stride,
                                        Pointer out,
                                        @Cast("size_t") long out_stride,
                                        @Cast("bool") boolean training);

// #endif 

/**
 <p>
 \abstract Apply an arithmetic filter to several pairs of (input set, output) data
 <p>
 \discussion
 an input set is composed of the inputs necessary to compute a given arithmetic operation.
 <p>
 The filter is applied for each of the <tt>batch_size</tt> inputs, and produces <tt>batch_size</tt> outputs.
 <tt>batch_size</tt> is ignored for an input or output if its type is BNNSConstant or BNNSParameter.
 <p>
 <tt>in</tt> is expected to point to an array of arithmetic operation inputs as required by the given arithmetic operation.
 Inputs and output must have the same data layout. Input support broadcasting such that two descriptors are compatible if for every dimension descriptors sizes are equal or one of them is 1.
 for example, a valid addition operation could have input1 size [1,3,4], input2 size [2,3,1] and output size [2,3,4]
 unless specified otherwise, each input size should be equal to output size or be broadcast compatible.
 inputs are allowed to point to a common address (same input), in which case gradients in backward compute must also point to a common address (same gradient).
 <p>
 for example, an addition arithmetic operation require two inputs, and therefore the in array size and the in_stride array size is 2.
 each pointer in the in array should point to a valid input.
 in case input1, input2 and output types are all BNNSSample, the output for each output sample in the batch will be the addition of the corresponding batch sample in input1 and in input2.
 if output and input1 are BNNSSample and input2 is BNNSConstant or BNNSParameter, the output for each output sample in the batch will be the addition of the corresponding batch sample in input1 and input2 where batch is ignored for input2.
 <p>
 Some arithmetic functions support in-place processing for forward and backward apply operations. That is the input and output (or output_delta and input_delta) may use the same pointer and descriptor in order to save memory (if the layer has multiple inputs, the user may choose which to use in-place).
 The input data is destroyed in the process, thus care must be taken during the forward pass to ensure all required inputs to the backward pass are preserved (noting that this layer’s input is normally the preceding layer’s output).
 In addition, descriptors for input being processed in-place and output must exactly match. in-place descriptor types must also match in case batch size > 1.
 <p>
 @param filter Filter to apply
 @param batch_size Number of (input sets, output) pairs to process
 @param number_of_inputs number of inputs for the arithmetic operation
 @param in pointer to an array of input pointers. in array size must be number_of_inputs.
 @param in_stride pointer to an array of input strides, each stride is an Increment (in values) between inputs in the batch for a corresponding input in the in array.
 @param out Pointer to the output data
 @param out_stride Increment (in values) between outputs
 <p>
 @return 0 on success, and -1 on failure.
 <p>
 */
public static native int BNNSArithmeticFilterApplyBatch(BNNSFilter filter,
                                   @Cast("size_t") long batch_size,
                                   @Cast("size_t") long number_of_inputs,
                                   @Cast("const void**") PointerPointer in,
                                   @Cast("const size_t*") SizeTPointer in_stride,
                                   Pointer out,
                                   @Cast("size_t") long out_stride);
public static native int BNNSArithmeticFilterApplyBatch(BNNSFilter filter,
                                   @Cast("size_t") long batch_size,
                                   @Cast("size_t") long number_of_inputs,
                                   @Cast("const void**") @ByPtrPtr Pointer in,
                                   @Cast("const size_t*") SizeTPointer in_stride,
                                   Pointer out,
                                   @Cast("size_t") long out_stride);

// #if !0

/** \abstract Applies a previously created multihead attention layer
 *
 *  \discussion
 *  When training, the backward pass can be accelerated by caching intermediate values from the forward pass.
 *  This is done by providing a memory buffer backprop_cache. The recommended size for this buffer may be obtained by calling
 *  the function with the pointer backprop_cache_size set to non-NULL, and backprop_cache set to NULL. The recommended size
 *  will be stored in *backprop_cache_size (the layer application will not be perfomed).
 *  The user may optionally provide a scratch workspace. The required size will depend the size of backprop_cache provided, and
 *  if no scratch workspace is provided one will be allocated internally. The size of required workspace can be obtained by calling
 *  the routine with a non-NULL workspace_size parameter and a NULL workspace pointer, and the required size will be returned
 *  in *workspace_size (the layer application will not be perfomed).
 *  If both backprop_cache_size and workspace_size are queried simulateneously, the returned workspace size will assume that
 *  the full backprop_cache_size is provided.
 *
 *  @param F Filter to apply created by a previous call to BNNSFilterCreateLayerMultiheadAttention()
 *  @param batch_size Number of inputs in batch
 *  @param query Pointer to data for query input matrix, layout as described by layer_params->query.target_desc
 *  @param query_stride Batch stride for query
 *  @param key Pointer to data for key input matrix, layout as described by layer_params->key.target_desc
 *  @param key_stride Batch stride for key
 *  @param key_mask Mask applied to key for ignoring entries. A 1D tensor of type BNNSDataTypeBoolean and shape
 *         source_length. Where this tensor evalautes to true, the corresponding elements of the key matrix are
 *         ignored in the attention operation. No key mask is applied if NULL is passed.
 *  @param key_mask_stride Batch stride for key_mask
 *  @param value Pointer to data for value input matrix, layout as described by layer_params->value.target_desc
 *  @param value_stride Batch stride for value
 *  @param output Pointer to data for output matrix, layout as described by layer_params->output.target_desc
 *  @param output_stride Batch stride for output
 *  @param add_to_attention Optional, one of:
 *         1) a 2D tensor of shape target_length x source_length; or
 *         2) a 3D tensor of shape num_heads x target_length x source_length; or
 *         3) a 4D tensor of shape batch_size x num_heads x target_length x source_length.
 *         This is used as part of the mask function prior to softmax in the attention calculation (the matrix X in the layer description).
 *         If the data type is BNNSDataTypeBoolean, true is treated as adding -inf, and false as adding zero (that is to say attention
 *         is not permitted in locations indicated by the the mask).
 *         No matrix is added if this pointer is NULL.
 *         Note: The 3D, 4D and BNNSDataTypeBoolean variants of this parameter are only supported in macOS 12.0, iOS 15.0,
 *         watchOS 8.0, tvOS 15.0 and later.
 *  @param backprop_cache_size Specifies the size of the array backprop_cache, in bytes.
 *         If backprop_cache_size is not-NULL but backprop_cache is NULL, the recommended size for backprop_cache_size
 *         will be set, but not other calculations will be performed (except to set workspace_size if requested).
 *  @param backprop_cache Is used to store intermediate results that can be used to accelerate a future call to
 *         BNNSApplyMultiheadAttentionBackward.
 *  @param workspace_size Specifies the size of the array workspace, in bytes.
 *         If workspace_size is not-NULL but workspace is NULL, the recommended size for workspace_size
 *         will be set, but not other calculations will be performed (except to set backprop_cache_size if requested).
 *  @param workspace Is used as a scratch buffer during the calculation.
 */
public static native int BNNSApplyMultiheadAttention(BNNSFilter F, @Cast("size_t") long batch_size,
                                @Const Pointer query, @Cast("size_t") long query_stride,
                                @Const Pointer key, @Cast("size_t") long key_stride,
                                @Const BNNSNDArrayDescriptor key_mask, @Cast("size_t") long key_mask_stride,
                                @Const Pointer value, @Cast("size_t") long value_stride,
                                Pointer output, @Cast("size_t") long output_stride,
                                @Const BNNSNDArrayDescriptor add_to_attention,
                                @Cast("size_t*") SizeTPointer backprop_cache_size, Pointer backprop_cache,
                                @Cast("size_t*") SizeTPointer workspace_size, Pointer workspace);

/**
 \abstract Direct Apply a Quantization filter
 <p>
 \discussion
 The Quantization layer converts higher precision tensors to lower precision tensors (Quantize) or lower precision tensors to higher precision tensors (Dequantize)
 
 @param layer_params Quantizer layer parameters
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 @param batch_size Number of (input, output) pairs to process
 @param input_stride Increment (in values) between inputs
 @param output_stride Increment (in values) between outputs
 @return Zero on success, nonzero on failure.
 */
public static native int BNNSDirectApplyQuantizer(@Const BNNSLayerParametersQuantization layer_params,
                             @Const BNNSFilterParameters filter_params,
                             @Cast("size_t") long batch_size,
                             @Cast("size_t") long input_stride,
                             @Cast("size_t") long output_stride);

// #endif 

// #pragma mark - Filter destruction

/**
  <p>
  \abstract Destroy filter
  <p>
  \discussion Releases all resources allocated for this filter.
  <p>
  @param filter Filter to destroy
<p>
*/
public static native void BNNSFilterDestroy(BNNSFilter filter);

// #pragma mark - Training

// #if !0

/**
  <p>
  \abstract Apply a single step of optimization to one or more parameters
  <p>
  \discussion
  The optimizer will use the specified optimization algorithm to update a set of parameters such as weights and bias.
  Data layout in memory of parameters, gradients and accumulators arrays must be contiguous, such that stride[0]=1 and for every N>0 stride[N]=stride[N-1]*size[N-1]. strides   in the descriptors may be provided as zeros.
  accumulators must be allocated by caller and have the same size as a matching parameter. accumulator descriptor data must be set to zero the first time the filter is   applied.
  OptimizerAlgFields pointer is saved internally, changes to the struct fields such as learning_rate for BNNSOptimizerSGDMomentumFields structure are allowed between   filter apply calls.
  <p>
  Accumulator requirements depend on the optimzation algorithm and its parameters:
  <p>
  BNNSOptimzerFunctionSGDMomentum
  ===============================
  Set to NULL for vanilla SGD (indicating momentum is 0).
  Set to a size number_of_parameters array if use of momentum is desired.
  <p>
  BNNSOptimizerFunctionAdam
  =======================
  Set to a size 2*number_of_parameters array.
  The first number_of_parameters pointers are used for the first momentum descriptors, and the subsequent number_of_parameters pointers are used for the second  momentum descriptors.
  <p>
  BNNSOptimizerFunctionAdamAMSGrad
  ===============================
  Set to a size 3*number_of_parameters array.
  The first number_of_parameters pointers are used for the first momentum descriptors, the second number_of_parameters pointers are used for the second  momentum descriptors, and the third number_of_parameters pointers are used for the second momentum maxima descriptors.
  <p>
  BNNSOptimizerFunctionAdamW
  ========================
  Set to a size 2*number_of_parameters array.
  The first number_of_parameters pointers are used for the first momentum descriptors, and the subsequent number_of_parameters ointers are used for the second  momentum descriptors.
  <p>
  BNNSOptimizerFunctionAdamWAMSGrad
  ===============================
  Set to a size 3*number_of_parameters array.
  The first number_of_parameters pointers are used for the first momentum descriptors, the second number_of_parameters pointers are used for the second  momentum descriptors, and the third number_of_parameters pointers are used for the second momentum maxima descriptors.
  <p>
  BNNSOptimizerFunctionRMSProp
  ==========================
  Should be of size k*number_of_parameters, where
    k = 1  +  (OptimizerAlgFields.centered ? 1 : 0)  + (OptimizerAlgFields.momentum != 0.0).
  That is to say a base of one accumulator per parameter, with one extra accumulator required for each of centering and momentum if they are enabled.
  Using the notation used in the description of BNNSOptimizerRMSPropFields, the first number_of_parameters pointers are used for n_i, the next
  set are used for g_i (iff centering is used) and the next set are used for the momentum Δ_i (iff momentum γ != 0.0).
  <p>
  @param function Optimization function (algorithm) to use
  @param OptimizerAlgFields Parameters for optimization function, pointer to a struct whose type is determined by the value of function.
  @param number_of_parameters number of parameters to update
  @param parameters array of parameter descriptors
  @param gradients array of gradient descriptors. Each gradient descriptor data in the array must be the same size as its matching parameter descriptor in the  parameters array.
  @param accumulators array of accumulator descriptors. Required number of accumulators varies depending on optimization algorithm and parameters - see function description. In all cases, accumulators must be allocated and initialized to zero by the user prior to the first call optimization step.
  @param filter_params Filter runtime parameters, may be NULL for default parameters.
  <p>
  @return 0 on success, nonzero on failure
*/
public static native int BNNSOptimizerStep(@Cast("BNNSOptimizerFunction") int function, @Const Pointer OptimizerAlgFields,
                      @Cast("size_t") long number_of_parameters,
                      @Cast("BNNSNDArrayDescriptor**") PointerPointer parameters,
                      @Cast("const BNNSNDArrayDescriptor**") PointerPointer gradients,
                      @Cast("BNNSNDArrayDescriptor**") PointerPointer accumulators,
                      @Const BNNSFilterParameters filter_params);
public static native int BNNSOptimizerStep(@Cast("BNNSOptimizerFunction") int function, @Const Pointer OptimizerAlgFields,
                      @Cast("size_t") long number_of_parameters,
                      @ByPtrPtr BNNSNDArrayDescriptor parameters,
                      @Const @ByPtrPtr BNNSNDArrayDescriptor gradients,
                      @ByPtrPtr BNNSNDArrayDescriptor accumulators,
                      @Const BNNSFilterParameters filter_params);

/**
 <p>
 \abstract Clip tensor values to a specified min and max
 <p>
 \discussion
 Given a tensor src, this operation writes to a tensor dest of the same type and shape as src with its values clipped to min_val and max_val.
 <p>
 @param dest descriptor for the destination tensor
 @param src descriptor for the source tensor, must be of the same type and shape as the dest descriptor.
 @param min_val The minimum value.
 @param max_val The maximum value.
 <p>
 @return 0 on success, nonzero on failure
 */
public static native int BNNSClipByValue(BNNSNDArrayDescriptor dest,
                    @Const BNNSNDArrayDescriptor src,
                    float min_val, float max_val);

/**
 <p>
 \abstract Clip tensor values to a maximum L2-norm.
 <p>
 \discussion
 Given a tensor src, this operation writes to a tensor dest of the same type and shape as src with its values clipped such that the L2-norm does not
 exceed max_norm.
 <p>
 @param dest descriptor for the destination tensor
 @param src descriptor for the source tensor, must be of the same type and shape as the dest descriptor.
 @param max_norm The maximum L2-norm.
 @param axis_flags The dimensions to use for computing the L2-norm. If 0, uses all dimensions.
 <p>
 @return 0 on success, nonzero on failure
 */
public static native int BNNSClipByNorm(BNNSNDArrayDescriptor dest,
                   @Const BNNSNDArrayDescriptor src,
                   float max_norm,
                   @Cast("uint32_t") int axis_flags);

/**
 <p>
 \abstract Clip values of a list of tensors by a maximum global L2-norm.
 <p>
 \discussion
 Given a list of tensors src, and a maximum global L2-norm, max_norm, this operation computes a list of clipped tensors.
 If you already know the global norm of src, you can specify the global norm to use with use_norm.
 <p>
 @param dest array of destination tensor descriptors
 @param src array of source tensor descriptors. Each descriptor data in the array must be the same size as its matching dest descriptor in the dest array.
 @param count number of descriptors in the dest and src arrays
 @param max_norm maximum global L2-norm
 @param use_norm The global norm to use. If zero, global norm is computed based on src.
 <p>
 @return 0 on success, nonzero on failure
 */
public static native int BNNSClipByGlobalNorm(@Cast("BNNSNDArrayDescriptor**") PointerPointer dest,
                         @Cast("const BNNSNDArrayDescriptor**") PointerPointer src,
                         @Cast("size_t") long count,
                         float max_norm,
                         float use_norm);
public static native int BNNSClipByGlobalNorm(@ByPtrPtr BNNSNDArrayDescriptor dest,
                         @Const @ByPtrPtr BNNSNDArrayDescriptor src,
                         @Cast("size_t") long count,
                         float max_norm,
                         float use_norm);

/**
 <p>
 \abstract Compute the norm of the input tensor.
 <p>
 \discussion
 Given a tensor src, this operation compute its specified norm along the specified axes.
 <p>
 @param dest descriptor for the destination tensor. The dimensions in axis_flags are removed from the destination shape.
        If axis_flags specifies all dimensions, destination descriptor must be BNNSDataLayoutVector with size[0] = 1.
 @param src descriptor for the source tensor.
 @param norm_type Type of the norm. Currently only L2-norm is supported.
 @param axis_flags The dimensions to use for computing the L2-norm. If 0, uses all dimensions.
 <p>
 @return 0 on success, nonzero on failure
 */
public static native int BNNSComputeNorm(BNNSNDArrayDescriptor dest,
                    @Const BNNSNDArrayDescriptor src,
                    @Cast("BNNSNormType") int norm_type,
                    @Cast("uint32_t") int axis_flags);

/**
 <p>
 \abstract Backward path of norm computation to generate input delta.
 <p>
 \discussion
 The backward computation uses the output delta (dy) and the forward pass input (x) and output (y) to generate the input delta (dx).
 <p>
 @param in Pointer to the forward pass input data
 @param in_delta Pointer to the input delta descriptor
 @param out Pointer to the forward pass output data
 @param out_delta Pointer to the output delta descriptor
 @param norm_type Type of the norm. Currently only L2-norm is supported.
 @param axis_flags The dimensions to use for computing the L2-norm. If 0, uses all dimensions.
 <p>
 @return 0 on success, nonzero on failure
 */
public static native int BNNSComputeNormBackward(@Const Pointer in,
                            BNNSNDArrayDescriptor in_delta,
                            @Const Pointer out,
                            @Const BNNSNDArrayDescriptor out_delta,
                            @Cast("BNNSNormType") int norm_type,
                            @Cast("uint32_t") int axis_flags);

/**
 <p>
 \abstract Apply filter backward to generate input delta, weights delta and bias delta
 <p>
 \discussion
 For a general filter f that computes output y by using weights w and bias b
 The forward pass filter computation can be described as:
 y = f(x,w,b)
 for example, the output y of a convolution filter f can be described as
 y = f(x,w,b) = w*x+b
 <p>
 The backward computation uses the output delta (dy) to generate the input delta (dx), weight delta (dw) and bias delta (db)
 In some cases the backward computation function also requires the forward pass input (x) and the forward pass output (y).
 <p>
 The following arguments are required for the backward computation:
 out_delta descriptor (dy) are the gradients arriving from the following filter and must be provided.
 in pointer is the forward pass input (x) and should be provided if not specified it is ignored
 out pointer is the forward pass output (y) and should be provided if not specified it is ignored
 <p>
 For dropout processing, it only needs delta of input/output, and the result is independent of forward input/output.  So backward apply will ignore input/output.
 <p>
 The following gradients are generated by the backward computation.
 in_delta  - the input delta (dx)
 weights_delta - the weight delta (dw)
 bias_delta - the bias delta (db)
 NULL descriptor pointers will not be computed. data field of a valid descriptor must point to the delta buffer to be produced.
 <p>
 Important activation information:
 For any general activation function, when computing activation layer backward, the forward pass input (x) to the activation is required.
 However, in most activation functions, it is possible and faster to compute the activation backward from the forward pass output y.
 In the case of fused computation and activation layers, it is mandatory to provide the forward pass output y.
 Notice that some activation functions cannot be fused with the computation filters.
 <p>
 Activation backward functions that can accept either forward pass input or forward pass output (output is prefered):
 BNNSActivationFunctionIdentity
 BNNSActivationFunctionRectifiedLinear
 BNNSActivationFunctionLeakyRectifiedLinear   (if alpha > 0.0 and weights_delta is not present)
 BNNSActivationFunctionSigmoid
 BNNSActivationFunctionLogSigmoid
 BNNSActivationFunctionTanh
 BNNSActivationFunctionLinear
 BNNSActivationFunctionClamp
 BNNSActivationFunctionSoftmax
 BNNSActivationFunctionHardSigmoid
 BNNSActivationFunctionSoftplus
 BNNSActivationFunctionSoftsign
 BNNSActivationFunctionELU
 BNNSActivationFunctionSELU
 BNNSActivationFunctionCELU
 BNNSActivationFunctionClampedLeakyRectifiedLinear  (if alpha > 0.0)
 BNNSActivationFunctionLinearWithBias
 BNNSActivationFunctionLogSoftmax
 BNNSActivationFunctionHardShrink
 BNNSActivationFunctionSoftShrink
 BNNSActivationFunctionTanhShrink
 BNNSActivationFunctionThreshold
 BNNSActivationFunctionGELUApproximationSigmoid
 <p>
 The activation functions above can be fused with computation in training, only if the forward pass output y is provided in backward apply.
 <p>
 Other activation functions require forward pass input and does not support fusing computation with activation, such as:
 BNNSActivationFunctionAbs
 BNNSActivationFunctionGELUApproximation
 BNNSActivationFunctionGELUApproximation2
 BNNSActivationFunctionSiLU
 <p>
 Additional requirements:
 BNNSFlagsUseClientPtr flag must be enabled when creating the filter.
 data_type of all descriptors must be BNNSDataTypeFloat32.
 <p>
 @param filter Filter to apply backward
 @param batch_size Number of (input, output) pairs to process
 @param in Pointer to the forward pass input data (x)
 - ignored when computing input delta and bias delta unless filter is pooling or filter is activation and backpropagation from output is supported.
 @param in_stride Increment (in values) between inputs
 - ignored when computing input delta or bias delta if the filter is not pooling
 @param in_delta Pointer to the input delta descriptor
 - not produced if null
 @param in_delta_stride Increment (in values) between input deltas
 @param out Pointer to the forward pass output data (y)
 - out is ignored in all filters if activation is BNNSActivationFunctionIdentity
 - some activation function backward computation can run faster if provided with the forward output
 - fused computation and activation filters such as convolution with activation must provide the forward pass output
 @param out_stride Increment (in values) between outputs
 @param out_delta Pointer to the output delta descriptor (dy)
 @param out_delta_stride Increment (in values) between output deltas
 @param weights_delta Pointer to the weights delta descriptor
 - delta is aggregated across batch
 - not produced if null
 - computed weights_delta layout will match the filter weight layout that was provided at the creation of the filter
 @param bias_delta Pointer to the bias delta descriptor
 - not produced if null
 @return 0 on success, and -1 on failure.
 */
public static native int BNNSFilterApplyBackwardBatch(BNNSFilter filter,
                                 @Cast("size_t") long batch_size,
                                 @Const Pointer in,
                                 @Cast("size_t") long in_stride,
                                 BNNSNDArrayDescriptor in_delta,
                                 @Cast("size_t") long in_delta_stride,
                                 @Const Pointer out,
                                 @Cast("size_t") long out_stride,
                                 @Const BNNSNDArrayDescriptor out_delta,
                                 @Cast("size_t") long out_delta_stride,
                                 BNNSNDArrayDescriptor weights_delta,
                                 BNNSNDArrayDescriptor bias_delta);

/**
 <p>
 \abstract Apply pooling filter backward to generate input delta and bias delta
 <p>
 \discussion
 This is similar to BNNSFilterApplyBackwardBatch, but takes indices as an optional input.
 It is mandatory to compute all active gradients in a single function call. computation of input delta is not required in case the filter is the first layer in the network
 <p>
 @param filter Filter to apply backward
 @param batch_size Number of (input, output, indices) to process
 @param in Pointer to the forward pass input data (x)
 @param in_stride Increment (in values) between inputs
 @param in_delta Pointer to the input delta descriptor
 - not produced if null
 @param in_delta_stride Increment (in values) between input deltas
 @param out Pointer to the forward pass output data (y)
 - out is ignored if activation is BNNSActivationFunctionIdentity
 - fused pooling and activation filters  must provide the forward pass output
 @param out_stride Increment (in values) between outputs
 @param out_delta Pointer to the output delta descriptor (dy)
 @param out_delta_stride Increment (in values) between output deltas
 @param bias_delta Pointer to the bias delta descriptor
 - not produced if null
 @param indices Pointer to the forward pass indices data generated by max pooling.
 - max pooling could use indices to reduce computation if not null. indices must have the same dimension and stride as the output data.
 - max unpooling requires a valid pointer. indices must have the same dimension and stride as the input data.
 - ignored for other pooling functions
 @param idx_stride Increment (in values) between indices
 @return 0 on success, and -1 on failure.
 */
public static native int BNNSPoolingFilterApplyBackwardBatch(BNNSFilter filter,
                                        @Cast("size_t") long batch_size,
                                        @Const Pointer in,
                                        @Cast("size_t") long in_stride,
                                        BNNSNDArrayDescriptor in_delta,
                                        @Cast("size_t") long in_delta_stride,
                                        @Const Pointer out,
                                        @Cast("size_t") long out_stride,
                                        BNNSNDArrayDescriptor out_delta,
                                        @Cast("size_t") long out_delta_stride,
                                        BNNSNDArrayDescriptor bias_delta,
                                        @Cast("const size_t*") SizeTPointer indices,
                                        @Cast("size_t") long idx_stride);

/**
 <p>
 \abstract Apply pooling filter backward to generate input delta and bias delta, supporting multiple index data types
 <p>
 \discussion
 The only difference between this function and BNNSPoolingFilterApplyBackwardBatch is that
 BNNSPoolingFilterApplyBackwardBatch requires indices to be size_t,
 while BNNSPoolingFilterApplyBackwardBatchEx allows indices to have various types.
 Currently, only uint64_t and uint32_t are allowed for indices.
 <p>
 @param filter Filter to apply backward
 @param batch_size Number of (input, output, indices) to process
 @param in Pointer to the forward pass input data (x)
 @param in_stride Increment (in values) between inputs
 @param in_delta Pointer to the input delta descriptor
 - not produced if null
 @param in_delta_stride Increment (in values) between input deltas
 @param out Pointer to the forward pass output data (y)
 - out is ignored if activation is BNNSActivationFunctionIdentity
 - fused pooling and activation filters  must provide the forward pass output
 @param out_stride Increment (in values) between outputs
 @param out_delta Pointer to the output delta descriptor (dy)
 @param out_delta_stride Increment (in values) between output deltas
 @param bias_delta Pointer to the bias delta descriptor
 - not produced if null
 @param indices_data_type Data type of indices data
 @param indices Pointer to the forward pass indices data generated by max pooling.
 - max pooling could use indices to reduce computation if not null. indices must have the same dimension and stride as the output data.
 - max unpooling requires a valid pointer. indices must have the same dimension and stride as the input data.
 - ignored for other pooling functions
 @param idx_stride Increment (in values) between indices
 @return 0 on success, and -1 on failure.
 */
public static native int BNNSPoolingFilterApplyBackwardBatchEx(BNNSFilter filter,
                                          @Cast("size_t") long batch_size,
                                          @Const Pointer in,
                                          @Cast("size_t") long in_stride,
                                          BNNSNDArrayDescriptor in_delta,
                                          @Cast("size_t") long in_delta_stride,
                                          @Const Pointer out,
                                          @Cast("size_t") long out_stride,
                                          BNNSNDArrayDescriptor out_delta,
                                          @Cast("size_t") long out_delta_stride,
                                          BNNSNDArrayDescriptor bias_delta,
                                          @Cast("const BNNSDataType") int indices_data_type,
                                          @Const Pointer indices,
                                          @Cast("size_t") long idx_stride);

/**
 <p>
 \abstract Apply filter backward to generate input deltas, weights delta and bias delta (two input version)
 <p>
 \discussion
 For a general filter f that computes output y by using weights w and bias b
 The forward pass filter computation can be described as:
 y = f(x,w,b)
 for example, the output y of a convolution filter f can be described as
 y = f(x,w,b) = w*x+b
 <p>
 The backward computation uses the output delta (dy) to generate the input deltas (dxA, dxB), weight delta (dw) and bias delta (db) [as applicable]
 In some cases the backward computation function also requires the forward pass input (x) and the forward pass output (y).
 <p>
 The following arguments are required for the backward computation:
 out_delta descriptor (dy) are the gradients arriving from the following filter and must be provided.
 in pointer is the forward pass input (x) and should be provided if not specified it is ignored
 out pointer is the forward pass output (y) and should be provided if not specified it is ignored
 <p>
 The following gradients are generated by the backward computation.
 in_delta  - the input delta (dx)
 weights_delta - the weight delta (dw)
 bias_delta - the bias delta (db)
 NULL descriptor pointers will not be computed. data field of a valid descriptor must point to the delta buffer to be produced.
 <p>
 Important activation information:
 For any general activation function, when computing activation layer backward, the forward pass input (x) to the activation is required.
 However, in most activation functions, it is possible and faster to compute the activation backward from the forward pass output y.
 In the case of fused computation and activation layers, it is mandatory to provide the forward pass output y.
 Notice that some activation functions cannot be fused with the computation filters.
 <p>
 Activation backward functions that can accept either forward pass input or forward pass output (output is prefered):
 BNNSActivationFunctionIdentity
 BNNSActivationFunctionRectifiedLinear
 BNNSActivationFunctionLeakyRectifiedLinear (if alpha >= 0.0)
 BNNSActivationFunctionSigmoid
 BNNSActivationFunctionLogSigmoid
 BNNSActivationFunctionTanh
 BNNSActivationFunctionLinear
 BNNSActivationFunctionClamp
 BNNSActivationFunctionSoftmax
 BNNSActivationFunctionHardSigmoid
 BNNSActivationFunctionSoftplus
 BNNSActivationFunctionSoftsign
 BNNSActivationFunctionELU
 BNNSActivationFunctionSELU
 BNNSActivationFunctionCELU
 BNNSActivationFunctionClampedLeakyRectifiedLinear (if alpha >= 0.0)
 BNNSActivationFunctionLinearWithBias
 BNNSActivationFunctionLogSoftmax
 BNNSActivationFunctionHardShrink
 BNNSActivationFunctionSoftShrink
 BNNSActivationFunctionTanhShrink
 BNNSActivationFunctionThreshold
 BNNSActivationFunctionGELUApproximationSigmoid
 <p>
 The activation functions above can be fused with computation in training, only if the forward pass output y is provided in backward apply.
 <p>
 Other activation functions require forward pass input and does not support fusing computation with activation, such as:
 BNNSActivationFunctionAbs
 BNNSActivationFunctionGELUApproximation
 BNNSActivationFunctionGELUApproximation2
 BNNSActivationFunctionSiLU
 <p>
 Additional requirements:
 BNNSFlagsUseClientPtr flag must be enabled when creating the filter.
 data_type of all descriptors must be BNNSDataTypeFloat32.
 <p>
 @param filter Filter to apply backward
 @param batch_size Number of (input, output) pairs to process
 @param inA Pointer to the forward pass input data (x)
 @param inA_stride Increment (in values) between inputs
 @param inA_delta Pointer to the input delta descriptor
 - not produced if null
 @param inA_delta_stride Increment (in values) between input deltas
 @param inB Pointer to the forward pass input data (x)
 @param inB_stride Increment (in values) between inputs
 @param inB_delta Pointer to the input delta descriptor
 - not produced if null
 @param inB_delta_stride Increment (in values) between input deltas
 @param out Pointer to the forward pass output data (y)
 @param out_stride Increment (in values) between outputs
 @param out_delta Pointer to the output delta descriptor (dy)
 @param out_delta_stride Increment (in values) between output deltas
 @param weights_delta Pointer to the weights delta descriptor
 - delta is aggregated across batch
 - not produced if null
 - computed weights_delta layout will match the filter weight layout that was provided at the creation of the filter
 @param bias_delta Pointer to the bias delta descriptor
 - not produced if null
 @return 0 on success, and -1 on failure.
*/
public static native int BNNSFilterApplyBackwardTwoInputBatch(BNNSFilter filter,
                                         @Cast("size_t") long batch_size,
                                         @Const Pointer inA,
                                         @Cast("size_t") long inA_stride,
                                         BNNSNDArrayDescriptor inA_delta,
                                         @Cast("size_t") long inA_delta_stride,
                                         @Const Pointer inB,
                                         @Cast("size_t") long inB_stride,
                                         BNNSNDArrayDescriptor inB_delta,
                                         @Cast("size_t") long inB_delta_stride,
                                         @Const Pointer out,
                                         @Cast("size_t") long out_stride,
                                         @Const BNNSNDArrayDescriptor out_delta,
                                         @Cast("size_t") long out_delta_stride,
                                         BNNSNDArrayDescriptor weights_delta,
                                         BNNSNDArrayDescriptor bias_delta);

/**
 <p>
 \abstract Apply a normalization filter backward to generate input delta, beta delta and gamma delta
 <p>
 \discussion
 similar to BNNSFilterApplyBackwardBatch, but computing input delta, beta delta and gamma delta
 It is mandatory to compute all active gradients in a single function call. computation of input delta is not required in case the filter is the first layer in the network
 <p>
 @param filter Filter to apply backward
 @param batch_size Number of (input, output) pairs to process
 @param in_delta Pointer to the input delta descriptor
 - not produced if null
 - must be in BNNSDataTypeFloat32 or BNNSDataTypeBFloat16
 @param in_delta_stride Increment (in values) between input deltas
 @param out Pointer to the forward pass output data (y)
 - out is ignored if activation is BNNSActivationFunctionIdentity
 - forward pass output must be provided in case of fused instance normalization and activation
 @param out_stride Increment (in values) between outputs
 @param out_delta Pointer to the output delta descriptor (dy)
 - out delta may be modified in order to save memory allocations when computing fused activation backward
 - must be in BNNSDataTypeFloat32 or BNNSDataTypeBFloat16
 @param out_delta_stride Increment (in values) between output deltas
 @param beta_delta Pointer to the beta delta descriptor
 - not produced if null
 - must be in BNNSDataTypeFloat32 or BNNSDataTypeBFloat16
 @param gamma_delta Pointer to the gamma delta descriptor
 - not produced if null
 - must be in BNNSDataTypeFloat32 or BNNSDataTypeBFloat16
 @return 0 on success, and -1 on failure.
 */
public static native int BNNSNormalizationFilterApplyBackwardBatch(BNNSFilter filter,
                                              @Cast("size_t") long batch_size,
                                              BNNSNDArrayDescriptor in_delta,
                                              @Cast("size_t") long in_delta_stride,
                                              @Const Pointer out,
                                              @Cast("size_t") long out_stride,
                                              BNNSNDArrayDescriptor out_delta,
                                              @Cast("size_t") long out_delta_stride,
                                              BNNSNDArrayDescriptor beta_delta,
                                              BNNSNDArrayDescriptor gamma_delta);

/**
  <p>
  \abstract Apply a fused filter backward to generate gradients.
  <p>
  \discussion
  similar to BNNSFilterApplyBackwardBatch, but computing gradients of an N layer fused filter.
  It is mandatory to compute all active parameter delta in a single function call. computation of input delta is not required in case the fused filter is the first layer in the network
  <p>
  @param filter Filter to apply backward
  @param batch_size Number of (input, output) pairs to process
  @param in Pointer to the forward pass computation input data (x)
  @param in_stride Increment (in values) between inputs
  - ignored when computing input delta or bias delta if the filter is not pooling
  @param in_delta Pointer to the computation input delta descriptor
  - not produced if null
  @param in_delta_stride Increment (in values) between input deltas
  @param out Pointer to the forward pass output data (y)
  - out is ignored if last filter activation is BNNSActivationFunctionIdentity
  @param out_stride Increment (in values) between outputs
  @param out_delta Pointer to the last filter output delta descriptor (dy)
  - out delta may be modified to save memory when computing fused activation backward
  @param out_delta_stride Increment (in values) between output deltas
  @param delta_parameters
  a pointer to an array of parameter delta pointers
  order of parameter must be first filter parameters followed by second filter parameters until reaching the last filter parameters
  for each filter parameters, the parameter order must follow the same order as in the stand-alone filter backward apply api
  all filter parameters must be provided, excluding input delta and output delta which are provided separately
  null pointer must be used for each non active parameter
  for example, if first filter is convolution and second filter is batchnorm, parameters could be extracted in the following way:
  BNNSNDArrayDescriptor* weights_delta = delta_parameters[0]; //weight delta is the first convolution parameter in BNNSFilterApplyBackwardBatch
  BNNSNDArrayDescriptor* bias_delta = delta_parameters[1];  //bias delta is the second convolution parameter in BNNSFilterApplyBackwardBatch
  BNNSNDArrayDescriptor* beta_delta = delta_parameters[2]; //first batchnorm parameter in BNNSNormalizationFilterApplyBackwardBatch
  BNNSNDArrayDescriptor* gamma_delta = delta_parameters[3]; //second batchnorm parameter in BNNSNormalizationFilterApplyBackwardBatch
  <p>
  @return 0 on success, and -1 on failure.
 */
public static native int BNNSFusedFilterApplyBackwardBatch(BNNSFilter filter,
                                      @Cast("size_t") long batch_size,
                                      @Const Pointer in,
                                      @Cast("size_t") long in_stride,
                                      BNNSNDArrayDescriptor in_delta,
                                      @Cast("size_t") long in_delta_stride,
                                      @Const Pointer out,
                                      @Cast("size_t") long out_stride,
                                      BNNSNDArrayDescriptor out_delta,
                                      @Cast("size_t") long out_delta_stride,
                                      @Cast("BNNSNDArrayDescriptor**") PointerPointer delta_parameters);
public static native int BNNSFusedFilterApplyBackwardBatch(BNNSFilter filter,
                                      @Cast("size_t") long batch_size,
                                      @Const Pointer in,
                                      @Cast("size_t") long in_stride,
                                      BNNSNDArrayDescriptor in_delta,
                                      @Cast("size_t") long in_delta_stride,
                                      @Const Pointer out,
                                      @Cast("size_t") long out_stride,
                                      BNNSNDArrayDescriptor out_delta,
                                      @Cast("size_t") long out_delta_stride,
                                      @ByPtrPtr BNNSNDArrayDescriptor delta_parameters);

/**
 <p>
 \abstract Apply a fused filter backward to generate gradients.
 <p>
 \discussion
 similar to BNNSFilterApplyBackwardBatch, but computing gradients of a fused filter.
 It is mandatory to compute all active parameter delta in a single function call. computation of input delta is not required in case the fused filter is the first layer in the network
 <p>
 Currently only fused arithmetic -> normalization configuration is supported.
 <p>
 @param filter Filter to apply backward
 @param batch_size Number of (input sets, output) pairs to process
 @param number_of_inputs number of inputs for the arithmetic operation
 @param in pointer to an array of input pointers. in array size must be number_of_inputs.
 @param in_stride pointer to an array of input strides, each stride is an Increment (in values) between inputs in the batch for a corresponding input in the in array.
 @param in_delta pointer to an array of input delta pointers. in array size must be number_of_inputs.
 @param in_delta_stride pointer to an array of input delta strides, each stride is an Increment (in values) between inputs deltas in the batch for a corresponding input in the in_delta array.
 @param out Pointer to the forward pass output data (y)
 - out is ignored if last filter activation is BNNSActivationFunctionIdentity
 @param out_stride Increment (in values) between outputs
 @param out_delta Pointer to the last filter output delta descriptor (dy)
 - out delta may be modified to save memory when computing fused activation backward
 @param out_delta_stride Increment (in values) between output deltas
 @param delta_parameters
 a pointer to an array of parameter delta pointers
 order of parameter must be first filter parameters followed by second filter parameters until reaching the last filter parameters
 for each filter parameters, the parameter order must follow the same order as in the stand-alone filter backward apply api
 all filter parameters must be provided, excluding input delta and output delta which are provided separately
 null pointer must be used for each non active parameter
 for example, if first filter is arithmetic and second filter is batchnorm, parameters could be extracted in the following way:
 BNNSNDArrayDescriptor* beta_delta = delta_parameters[0]; //first batchnorm parameter in BNNSNormalizationFilterApplyBackwardBatch
 BNNSNDArrayDescriptor* gamma_delta = delta_parameters[1]; //second batchnorm parameter in BNNSNormalizationFilterApplyBackwardBatch
 <p>
 @return 0 on success, and -1 on failure.
 */
public static native int BNNSFusedFilterApplyBackwardMultiInputBatch(BNNSFilter filter,
                                                @Cast("size_t") long batch_size,
                                                @Cast("size_t") long number_of_inputs,
                                                @Cast("const void**") PointerPointer in,
                                                @Cast("const size_t*") SizeTPointer in_stride,
                                                @Cast("BNNSNDArrayDescriptor**") PointerPointer in_delta,
                                                @Cast("const size_t*") SizeTPointer in_delta_stride,
                                                @Const Pointer out,
                                                @Cast("const size_t") long out_stride,
                                                BNNSNDArrayDescriptor out_delta,
                                                @Cast("size_t") long out_delta_stride,
                                                @Cast("BNNSNDArrayDescriptor**") PointerPointer delta_parameters);
public static native int BNNSFusedFilterApplyBackwardMultiInputBatch(BNNSFilter filter,
                                                @Cast("size_t") long batch_size,
                                                @Cast("size_t") long number_of_inputs,
                                                @Cast("const void**") @ByPtrPtr Pointer in,
                                                @Cast("const size_t*") SizeTPointer in_stride,
                                                @ByPtrPtr BNNSNDArrayDescriptor in_delta,
                                                @Cast("const size_t*") SizeTPointer in_delta_stride,
                                                @Const Pointer out,
                                                @Cast("const size_t") long out_stride,
                                                BNNSNDArrayDescriptor out_delta,
                                                @Cast("size_t") long out_delta_stride,
                                                @ByPtrPtr BNNSNDArrayDescriptor delta_parameters);

/**
 <p>
 \abstract Apply an arithmetic filter backward to generate input gradients
 <p>
 \discussion
 Compute gradients for all arithmetic operation inputs
 It is mandatory to compute all input gradients in a single function call.
 if inputs were pointing to a common address during forward computation (same input), gradients should also point to a common address (same gradient)
 descriptors for output delta and input delta that are being processed in-place must exactly match. in-place descriptor types must also match in case batch size > 1.
 <p>
 @param filter Filter to apply
 @param batch_size Number of (input sets, output) pairs to process
 @param number_of_inputs number of inputs for the arithmetic operation
 @param in pointer to an array of input pointers. in array size must be number_of_inputs.
 - in may be NULL for arithmetic layers that support forward in-place processing
 @param in_stride pointer to an array of input strides, each stride is an Increment (in values) between inputs in the batch for a corresponding input in the in array.
 @param in_delta pointer to an array of input delta pointers. in array size must be number_of_inputs.
 @param in_delta_stride pointer to an array of input delta strides, each stride is an Increment (in values) between inputs deltas in the batch for a corresponding input in the in_delta array.
 @param out Pointer to the forward pass output data (y)
 - forward pass output must be provided in case of fused arithmetic and activation
 - out may not be provided when activation is BNNSActivationFunctionIdentity, but in some arithmetic functions, providing the forward output may speedup the backward compute.
 @param out_stride Increment (in values) between outputs
 @param out_delta Pointer to the output delta descriptor (dy)
 @param out_delta_stride Increment (in values) between output deltas
 <p>
 @return 0 on success, and -1 on failure.
 <p>
 */
public static native int BNNSArithmeticFilterApplyBackwardBatch(BNNSFilter filter,
                                           @Cast("size_t") long batch_size,
                                           @Cast("size_t") long number_of_inputs,
                                           @Cast("const void**") PointerPointer in,
                                           @Cast("const size_t*") SizeTPointer in_stride,
                                           @Cast("BNNSNDArrayDescriptor**") PointerPointer in_delta,
                                           @Cast("const size_t*") SizeTPointer in_delta_stride,
                                           @Const Pointer out,
                                           @Cast("const size_t") long out_stride,
                                           BNNSNDArrayDescriptor out_delta,
                                           @Cast("const size_t") long out_delta_stride);
public static native int BNNSArithmeticFilterApplyBackwardBatch(BNNSFilter filter,
                                           @Cast("size_t") long batch_size,
                                           @Cast("size_t") long number_of_inputs,
                                           @Cast("const void**") @ByPtrPtr Pointer in,
                                           @Cast("const size_t*") SizeTPointer in_stride,
                                           @ByPtrPtr BNNSNDArrayDescriptor in_delta,
                                           @Cast("const size_t*") SizeTPointer in_delta_stride,
                                           @Const Pointer out,
                                           @Cast("const size_t") long out_stride,
                                           BNNSNDArrayDescriptor out_delta,
                                           @Cast("const size_t") long out_delta_stride);

/**
 <p>
 \abstract Apply permute filter backward to generate input gradient
 <p>
 \discussion
 similar to BNNSFilterApplyBackwardBatch with only the necessary argument subset for permute.
 <p>
 @param filter Filter to apply
 @param batch_size Number of (input, output) pairs to process
 @param in_delta Pointer to the input delta descriptor
 @param in_delta_stride Increment (in values) between input deltas
 @param out_delta Pointer to the output delta descriptor
 @param out_delta_stride Increment (in values) between output deltas
 <p>
 */
public static native int BNNSPermuteFilterApplyBackwardBatch(BNNSFilter filter,
                                        @Cast("size_t") long batch_size,
                                        BNNSNDArrayDescriptor in_delta,
                                        @Cast("size_t") long in_delta_stride,
                                        @Const BNNSNDArrayDescriptor out_delta,
                                        @Cast("size_t") long out_delta_stride);

/**
 <p>
 \abstract Apply a loss filter to compute forward loss and loss gradient on a batch with several pairs of (input, labels)
 <p>
 \discussion
 The filter is applied for each of the <tt>batch_size</tt> inputs,labels and computes reduced loss and an optional loss gradient.
 <tt>in</tt> (resp. <tt>out</tt>) is expected to point to <tt>batch_size</tt> times the input (resp. output) object size defined when the filter was created.
 The function supports forward loss computation, and also backward loss without back propagation from output delta.
 Input delta computation is an optimization that can be used if the loss layer is the last layer in the network.
 <p>
 @param filter Loss filter to apply
 @param batch_size Number of (input, labels) pairs to compute
 @param in Pointer to the input data
 @param in_stride Increment (in values) between inputs
 @param labels Pointer to the labels
 @param labels_stride Increment (in values) between labels
 @param weights optional loss computation weight
 @param weights_size weight size must be one of:
 for softmax cross entropy:
    0 results in no weight loss scaling.
    1 results in same weight scaling for all samples in the batch.
    batch_size results in different weight per each sample in the batch
 for sigmoid cross enrtopy, mse and huber loss, weights_size must be one of:
    0 results in no weight loss scaling.
    1 results in same weight scaling for all samples in the batch.
    batch_size*input_width results in different weight per each sample in the batch
 @param out Pointer to the computed loss. output size depand on loss function and reduction function.
 Loss array expected to be consecutive in memory (in case loss is unreduced), such that the stride between loss of consecutive samples in the batch is 1.
 if loss is reduced, out will be a single result.
 for softmax cross entropy, if loss is unreduced, out should be large enough to contain batch_size consecutive loss results.
 for sigmoid cross entropy unreduced loss, mse unreduced loss and huber unreduced loss, out should be large enough to contain batch_size*input_width consecutive loss results, where input_width is size[0] of the input descriptor.
 <p>
 @param in_delta Pointer to the input delta descriptor
 - not produced if null
 @param in_delta_stride Increment (in values) between input deltas
 <p>
 @return 0 on success, and -1 on failure.
 <p>
 */
public static native int BNNSLossFilterApplyBatch(BNNSFilter filter,
                             @Cast("size_t") long batch_size,
                             @Const Pointer in,
                             @Cast("size_t") long in_stride,
                             @Const Pointer labels,
                             @Cast("size_t") long labels_stride,
                             @Const Pointer weights,
                             @Cast("size_t") long weights_size,
                             Pointer out,
                             BNNSNDArrayDescriptor in_delta,
                             @Cast("size_t") long in_delta_stride);

/**
 <p>
 \abstract Apply a loss filter backward to generate gradients.
 <p>
 \discussion
 The filter is applied for each of the <tt>batch_size</tt> inputs,labels and computes the backward loss gradient.
 <tt>in</tt> (resp. <tt>out</tt>) is expected to point to <tt>batch_size</tt> times the input (resp. output) object size defined when the filter was created.
 Note that if the loss layer is the last layer in the network, the BNNSLossFilterApplyBatch can be used to compute both forward and backward without back propagation from output delta.
 <p>
 @param filter Loss filter to apply
 @param batch_size Number of (input, labels) pairs to compute
 @param in Pointer to the input data
 @param in_stride Increment (in values) between inputs
 @param in_delta Pointer to the input delta descriptor
 @param in_delta_stride Increment (in values) between input deltas
 @param labels Pointer to the labels
 @param labels_stride Increment (in values) between labels
 @param weights optional loss computation weight
 @param weights_size weight size must be one of:
 for softmax cross entropy:
    0 results in no weight loss scaling.
    1 results in same weight scaling for all samples in the batch.
    batch_size results in different weight per each sample in the batch
 for sigmoid cross enrtopy, mse and huber loss, weights_size must be one of:
    0 results in no weight loss scaling.
    1 results in same weight scaling for all samples in the batch.
    batch_size*input_width results in different weight per each sample in the batch
 @param out_delta Pointer to the output delta descriptor
 @param out_delta_stride Increment (in values) between output deltas
 <p>
 @return 0 on success, and -1 on failure.
*/
public static native int BNNSLossFilterApplyBackwardBatch(BNNSFilter filter,
                                     @Cast("size_t") long batch_size,
                                     @Const Pointer in,
                                     @Cast("size_t") long in_stride,
                                     BNNSNDArrayDescriptor in_delta,
                                     @Cast("size_t") long in_delta_stride,
                                     @Const Pointer labels,
                                     @Cast("size_t") long labels_stride,
                                     @Const Pointer weights,
                                     @Cast("size_t") long weights_size,
                                     @Const BNNSNDArrayDescriptor out_delta,
                                     @Cast("size_t") long out_delta_stride);

/** \abstract Applies a previously created multihead attention layer backwards to obtain gradients
 *
 *  \discussion
 *  Two common cases are that query=key=value or query=key. In these cases the backpropogated gradient for these parameters
 *  the gradient calculation is then the sum of the individual deltas. If any the pointers query_param_delta.target_desc.data,
 *  key_param_delta.target_desc.data or value_param_delta.target_desc.data are equal to each other, the returned tensor will
 *  be set correctly to the sum of the components.
 *
 *  @param F Filter to apply created by a previous call to BNNSFilterCreateLayerMultiheadAttention()
 *  @param batch_size Number of inputs in batch
 *  @param query Pointer to data for query input matrix, layout as described by layer_params->query.target_desc
 *  @param query_stride Batch stride for query
 *  @param query_param_delta Pointer to data structure used to hold deltas for corresponding components. A NULL value
 *         in a member's data component indicates that it should not be computed.
 *         The value query_param_delta.target_desc.stride[2] is used as the batch stride for query_param_delta.target_desc.
 *  @param key Pointer to data for key input matrix, layout as described by layer_params->key.target_desc
 *  @param key_stride Batch stride for key
 *  @param key_mask Mask applied to key for ignoring entries, layout as described in forward call.
 *         No mask is applied if this pointer is NULL.
 *  @param key_mask_stride Batch stride for key_mask
 *  @param key_param_delta Pointer to data structure used to hold deltas for corresponding components. A NULL value
 *         in a member's data component indicates that it should not be computed.
 *         The value key_param_delta.target_desc.stride[2] is used as the batch stride for key_param_delta.target_desc.
 *  @param value Pointer to data for value input matrix, layout as described by layer_params->value.target_desc
 *  @param value_stride Batch stride for value
 *  @param value_param_delta Pointer to data structure used to hold deltas for corresponding components. A NULL value
 *         in a member's data component indicates that it should not be computed.
 *         The value value_param_delta.target_desc.stride[2] is used as the batch stride for value_param_delta.target_desc.
 *  @param add_to_attention Optional, a 2D tensor of shape target_length x source_length that is used as part of the mask function prior
 *         to softmax in the attention calculation (the matrix X in the layer description). No matrix is added if this pointer is NULL.
 *  @param output Pointer to data for output matrix, , layout as described by layer_params->output.target_desc
 *  @param output_stride Batch stride for output.
 *  @param output_param_delta Pointer to data structure used to hold deltas for corresponding components. A NULL value
 *         in a member's data component indicates that it should not be computed.
 *         The value output_param_delta.target_desc.stride[2] is used as the batch stride for output_param_delta.target_desc.
 *  @param backprop_cache_size Specifies the size of the array backprop_cache, in bytes. If 0, or backprop_cache is NULL,
 *         backprop_cache is not accessed.
 *  @param backprop_cache Is used to store intermediate results that can be used to accelerate a future call to
 *         BNNSApplyMultiheadAttentionBackward.
 *  @param workspace_size Specifies the size of the array workspace, in bytes.
 *         If workspace_size is not-NULL but workspace is NULL, the recommended size for workspace_size
 *         will be set, but not other calculations will be performed (except to set backprop_cache_size if requested).
 *  @param workspace Is used as a scratch buffer during the calculation.
 */
public static native int BNNSApplyMultiheadAttentionBackward(BNNSFilter F, @Cast("size_t") long batch_size,
                                        @Const Pointer query, @Cast("size_t") long query_stride,
                                        BNNSMHAProjectionParameters query_param_delta,
                                        @Const Pointer key, @Cast("size_t") long key_stride,
                                        @Const BNNSNDArrayDescriptor key_mask, @Cast("size_t") long key_mask_stride,
                                        BNNSMHAProjectionParameters key_param_delta,
                                        @Const Pointer value, @Cast("size_t") long value_stride,
                                        BNNSMHAProjectionParameters value_param_delta,
                                        @Const BNNSNDArrayDescriptor add_to_attention,
                                        BNNSNDArrayDescriptor key_attn_bias_delta,
                                        BNNSNDArrayDescriptor value_attn_bias_delta,
                                        @Const Pointer output, @Cast("size_t") long output_stride,
                                        BNNSMHAProjectionParameters output_param_delta,
                                        @Cast("size_t") long backprop_cache_size, Pointer backprop_cache,
                                        @Cast("size_t*") SizeTPointer workspace_size, Pointer workspace
                                        );

// #pragma mark - Direct inference

/**
 \abstract return the minimum bytes capacity of the training cache buffer (used to store intermediate results during the forward pass)
 @return minimum bytes capacity of the training cache buffer
 */
public static native @Cast("size_t") long BNNSComputeLSTMTrainingCacheCapacity(@Const BNNSLayerParametersLSTM layer_params);

/**
 <p>
 \abstract Direct Apply LSTM with training caching
 \discussion compute LSTM forward and cache intermediate results to accelerate backward computation
 - the user can query the minimum buffer size for training cache using BNNSComputeLSTMTrainingCacheCapacity
 - training_cache_ptr == NULL means not to cache
 - BNNS will return failure when training_cache_capacity is lower than the minimum bytes capacity of the training cache buffer that BNNSComputeLSTMTrainingCacheCapacity returned
 @param layer_params - layer parameters
 @param filter_params - filter parameters
 @param training_cache_ptr - buffer to store intermediate results to accelerate backward computation. if Null, intermediate results aren't cached
 @param training_cache_capacity - size in bytes of training_cache_ptr
 @return 0 on success, and -1 on failure.
 <p>
 */
public static native int BNNSDirectApplyLSTMBatchTrainingCaching(@Const BNNSLayerParametersLSTM layer_params,
                                            @Const BNNSFilterParameters filter_params,
                                            Pointer training_cache_ptr,
                                            @Cast("const size_t") long training_cache_capacity);

// #endif 

/**
  <p>
  \abstract Direct Apply an Activation/Conversion filter to several pairs of (input, output) data
  <p>
  \discussion
  equal to calling BNNSCreateActivation & BNNSFilterApplyBatch & BNNSDestroy
  <p>
  @param layer_params Layer parameters and input, weights, output, bias and activation descriptors
  should set i_desc.data pointing to input data and o_desc.data pointing to output data
  <p>
  @param filter_params Filter runtime parameters, may be NULL for default parameters
  @param batch_size Number of (input, output) pairs to process
  @param in_stride Increment (in values) between inputs
  @param out_stride Increment (in values) between outputs
  <p>
  @return 0 on success, and -1 on failure.
 <p>
 */
public static native int BNNSDirectApplyActivationBatch(@Const BNNSLayerParametersActivation layer_params,
                                   @Const BNNSFilterParameters filter_params,
                                   @Cast("size_t") long batch_size,
                                   @Cast("size_t") long in_stride,
                                   @Cast("size_t") long out_stride);

/**
  <p>
  \abstract Copies the contents of one BNNSNDArrayDescriptor to another of the same shape.
  \discussion
  Equivalent to using a contraction layer with opstring "src_* -> dest_*"
  <p>
  @param dest The destination tensor
  @param src The source tensor - must not overlap in memory with the destination tensor
 <p>
 */
public static native int BNNSCopy(BNNSNDArrayDescriptor dest,
             @Const BNNSNDArrayDescriptor src,
             @Const BNNSFilterParameters filter_params);

// #if !0

/**
 * \abstract Returns required workspace size for a call to BNNSMatMul() with the given parameters.
 *
 * \discussion
 * This routine does not access the data pointers on the array descriptors, so they need not point to actual data.
 *
 * @param transA - if true, transposes the last two dimensions of A
 * @param transB - if true, transposes the last two dimensions of B
 * @param alpha - scalar by which to scale the result
 * @param inputA - descriptor for tensor A
 * @param inputB - descriptor for tensor B
 * @param output - descriptor for tensor C
 * @param filter_params - filter runtime parameters, may be NULL for default parameters
 *
 * @return Required allocation size for workspace parameter to BNNSMatMul, in bytes.
 *          If parameters are invalid, a negative value is returned.
 */
public static native @Cast("ssize_t") long BNNSMatMulWorkspaceSize(@Cast("const bool") boolean transA,
                                @Cast("const bool") boolean transB,
                                float alpha,
                                @Const BNNSNDArrayDescriptor inputA,
                                @Const BNNSNDArrayDescriptor inputB,
                                @Const BNNSNDArrayDescriptor output,
                                @Const BNNSFilterParameters filter_params);

/**
 * \abstract Directly apply a broadcast matrix multiplication layer.
 *
 * \discussion
 * This routine performs to operation C = alpha * op(A) * op(B), with approriate broadcasting if dimensions are absent on one
 * or more matrices. Matrix multiplication is always on the final two indices of each operand. For example, if we have
 * A is 4x5x6
 * B is 6x7
 * C is 4x5x7
 * Then the operation performed (if transA=transB=false) is:
 *  c_pij = sum_k a_pik * b_kj
 * Noting that the matrix B has been broadcast in the p dimension
 *
 * Performs the same action as a broadcast matrix multiplication layer without instantiating a BNNSFilter.
 * This function replaces the deprecated BNNSDirectApplyBroadcastMatMul and allows explicit provision
 * of workspace memory. If workspace is not null, no allocation is performed internally.
 *
 * @param transA - if true, transposes the last two dimensions of A
 * @param transB - if true, transposes the last two dimensions of B
 * @param alpha - scalar by which to scale the result
 * @param inputA - descriptor for tensor A
 * @param inputB - descriptor for tensor B
 * @param output - descriptor for tensor C; on output only the data values are changed
 * @param workspace - pointer to memory region to be used as scratch. Must have size no less than
 *        the value returned by BNNSMatMulWorkspaceSize
 * @param filter_params - filter runtime parameters, may be NULL for default parameters
 *
 * @return 0 on success, non-zero on failure
 */
public static native int BNNSMatMul(@Cast("const bool") boolean transA,
               @Cast("const bool") boolean transB,
               float alpha,
               @Const BNNSNDArrayDescriptor inputA,
               @Const BNNSNDArrayDescriptor inputB,
               @Const BNNSNDArrayDescriptor output,
               Pointer workspace,
               @Const BNNSFilterParameters filter_params);

/**
 * \abstract Directly apply a broadcast matrix multiplication layer.
 *
 * \description
 * Performs the same action as a broadcast matrix multiplication layer without instantiating a BNNSFilter.
 *
 * @param transA - if true, transposes the last two dimensions of A
 * @param transB - if true, transposes the last two dimensions of B
 * @param alpha - scalar by which to scale the result
 * @param inputA - descriptor for tensor A
 * @param inputB - descriptor for tensor B
 * @param output - descriptor for tensor C; on output only the data values are changed
 * @param filter_params - filter runtime parameters, may be NULL for default parameters
 */
public static native void BNNSDirectApplyBroadcastMatMul(@Cast("const bool") boolean transA,
                                    @Cast("const bool") boolean transB,
                                    float alpha,
                                    @Const BNNSNDArrayDescriptor inputA,
                                    @Const BNNSNDArrayDescriptor inputB,
                                    @Const BNNSNDArrayDescriptor output,
                                    @Const BNNSFilterParameters filter_params);

// #endif 

/** \abstract Transposes a tensor by swapping two of its dimensions.
 *
 *  \discussion
 *  Users should consider whether a data transposition with memory copy (i.e. this operation) is required, or if the same effect can be
 *  achieved by just switching layout in the descriptor of the same memory (e.g. for a 2D matrix can switching from row major to column
 *  major storage satsify the requirements). Consideration will be needed for both whether individual layers support alternative data
 *  layouts, and runtime performance.
 *
 *  This routine is not presented as a layer, but as a data manipulation. If deployed in a training scenario, observe that backpropagation
 *  can be achieved by applying exactly the same operation to the output delta as was applied to the original input.
 *
 *  This operation is equivalent to using the TensorContraction layer with operation string similar to "x_*ij -> y_*ji", only with the appropriate
 *  axes represented for the transposition.
 *
 *  In place operation is NOT supported.
 *
 *  @param dest Descriptor for the destination tensor
 *  @param src Descriptor for the source tensor
 *  @param axis0 First axis of transposition
 *  @param axis1 Second axis of transposition
 *  @param filter_params Filter runtime parameters, may be NULL for default parameters
 */
public static native int BNNSTranspose(BNNSNDArrayDescriptor dest,
                  @Const BNNSNDArrayDescriptor src,
                  @Cast("size_t") long axis0, @Cast("size_t") long axis1,
                  @Const BNNSFilterParameters filter_params);

// #if !0

/**
  \abstract Apply Reduction on selected axis
 @param layer_params  Layer parameters: input descriptor, output descriptor, reduce function and epsilon
                      need to set the pointers:
                      layer_params.i_desc.data - pointer to input buffer
                      layer_params.o_desc.data - pointer to output buffer
                      layer_params.w_desc.data - pointer to weights buffer (set to NULL if not needed)
  @param filter_params Filter runtime parameters, may be NULL for default parameters
  @return 0 on success, and -1 on failure.
*/
public static native int BNNSDirectApplyReduction(@Const BNNSLayerParametersReduction layer_params,
                             @Const BNNSFilterParameters filter_params);

/**
 \abstract create and return a new tensor of bool type by comparing two input tensors
 <p>
 \discussion
       compare two input tensors and generate a tensor of bool type containing the results of element-by-element comparison
 <p>
 @param  in0  pointer to the tensor descriptor of type BNNSNDArrayDescriptor for comparison/logical operations - left side of the operator
 @param  in1  pointer to the tensor descriptor of type BNNSNDArrayDescriptor for comparison/logical operations - right side of the operator
 @param  op   type of comparison in BNNSRelationalOperator type
 @param  out  pointer to the tensor descriptor of type BNNSNDArrayDescriptor for the output of comparison.
             The active dimensions should match those of inA/inB, and the type should be BNNSDataTypeBoolean8.
 @return the error code of the processing - error only if I/O tensor descriptors have invalid or mismatching information
 */
public static native int BNNSCompareTensor(@Const BNNSNDArrayDescriptor in0, @Const BNNSNDArrayDescriptor in1, @Cast("BNNSRelationalOperator") int op, BNNSNDArrayDescriptor out);

/**
 \abstract return a new tensor by replicating the input tensor multiple times
 
 \discussion
   The size of output tensor along each dimension should be a multiple of input tensor,
   and the multiple is the number of repetition.
 <p>
 @param input Pointer to the input tensor descriptor
 @param output Pointer to the output tensor descriptor
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 @return Zero on success, nonzero on failure.
 */
public static native int BNNSTile(@Const BNNSNDArrayDescriptor input,
             BNNSNDArrayDescriptor output,
             @Const BNNSFilterParameters filter_params);


/**
 \abstract Returns top K values
 \discussion
   Returns a sparse vector of the top K entries from the input.
   In the case of ties that span the top-K boundary, only the lexigraphically first entries will be returned.
   Nullability of best_indices is changed to allow passing null pointer.
 @param K Number of entries to find
 @param axis Axis along which to find top K entries
 @param batch_size Number of batches
 @param input The input tensor
 @param input_batch_stride The batch stride for input.data
 @param best_values Descriptor of a K-length vector. On return contains the K best values in descending order.
 @param best_values_batch_stride The batch stride for best_values
 @param best_indices Descriptor of a K-length vector. On return contains the indices of the K best values in descending order.  (set to NULL if not needed)
 @param best_indices_batch_stride The batch stride in size_t elements for best_indices
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 @return Zero on success, nonzero on failure.
 */


/**
 \abstract Given a tensor index for each member of a batch, returns a boolean vector indicating whether each index
            corresponds to a top-k value of the input.
 \discussion
  Consider the 4x4 tensor in a batch size of 3:
    X(:,:,0) = [ 1 3 5 7 ]         X(:,:,1) = [ 1 8 3 4 ]         X(:,:,2) = [ 4 8 7 7 ]
           [ 2 5 1 9 ]                       [ 8 1 3 5 ]                        [ 4 3 8 5 ]
           [ 1 5 3 2 ]                       [ 1 7 2 3 ]                        [ 5 7 3 1 ]
  and the test indices:
    T(:, 0) = (0, 3, 1)
    T(:, 1) = (2, 2, 0)
    T(:, 2) = (3, 2, 1)
  with K= 2 and axis=1, the result would be:
     (F, F, T)      from comparing values (1, 1, 5) against the top K sets (5, 7), (5, 9), (3,5) in the first batch
     (F, F, F)      from comparing values (3, 3, 1) against the top K set (4, 8), (5, 8), (3,7) in the second batch
     (T, T, T)      from comparing values (7, 8, 7) against the top K set (7, 8), (5, 8), (5, 7) in the third batch
  Observe that in the case of ties, all possible entries are included in the top K.
 @param K Number of entries to find
 @param axis Axis along which to find top K entries
 @param batch_size Number of batches
 @param input The input tensor
 @param input_batch_stride The batch stride for input.data
 @param test_indices Test index tensor, shape must match that of input, with the given axis removed
 @param test_indices_batch_stride The batch stride for test_indices.data
 @param output The boolean output tensor
 @param output_batch_stride The batch stride for output.data, of shape matching test_indices
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 @return Zero on success, nonzero on failure.
 */
public static native int BNNSDirectApplyInTopK(@Cast("size_t") long K, @Cast("size_t") long axis, @Cast("size_t") long batch_size,
                          @Const BNNSNDArrayDescriptor input, @Cast("size_t") long input_batch_stride,
                          @Const BNNSNDArrayDescriptor test_indices, @Cast("size_t") long test_indices_batch_stride,
                          BNNSNDArrayDescriptor output, @Cast("size_t") long output_batch_stride,
                          @Const BNNSFilterParameters filter_params);

/**
 \abstract Gather elements along a single axis
 <p>
 \discussion
 Maps one n dimensional tensor to another n dimensional tensor, only with indices along the
 given axis gathered as according to the given indices tensor.
   output[i_0, ... i_axis, ... i_{n-1}] = input[i_0, ... idx_axis, ... i_{n-1}]
 where the value idx_axis is drawn from the indices tensor as follows:
 1) If indices is a 1d vector, idx_axis = indices[i_axis]
 2) If indices shape matches output shape, idx_axis = indices[i_0, ... i_axis, ... i_{n-1}]
 (Note that in the degeneate case where output is a 1d vector the two definitions are equivalent)
 <p>
 In both cases, if any indices value is out of range, an error is generated.
 <p>
 @param axis Axis along which indices are gathered
 @param input Tensor from which values are gathered
 @param indices 1D tensor containing indices to gather
 @param output Tensor in which to store output. Must have shape consistent with input and indices as described above.
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 */
public static native int BNNSGather(@Cast("size_t") long axis,
               @Const BNNSNDArrayDescriptor input,
               @Const BNNSNDArrayDescriptor indices,
               BNNSNDArrayDescriptor output,
               @Const BNNSFilterParameters filter_params);

/**
 \abstract Scatter elements along a single axis
 <p>
 \discussion
 Given a set of input indices along the given axis, we modify the output tensor setting
   output[i_0, ... idx_axis, ... i_{n-1}] = input[i_0, ... i_axis, ... i_{n-1}]
 where the value idx_axis is drawn from the indices tensor as follows:
 1) If indices is a 1d vector, idx_axis = indices[i_axis]
 2) If indices shape matches input shape, idx_axis = indices[i_0, ... i_axis, ... i_{n-1}]
 (Note that in the degeneate case where input is a 1d vector the two definitions are equivalent)
 <p>
 If any indices value is out of range, an error is generated.
 <p>
 Output values that are scattered to reduced with the existing value as
   output[output_idx] = op(output[output_idx], input[input_idx]).
 If multiple input values update the same output element, the order of update operations is undefined.
 In particular, if op == BNNSReduceFunctionNone there is no guarantee any particular value will result.
 <p>
 @param axis Axis along which indices are scattered
 @param op Reduction op used to reduce existing output value with scattered value.
        At present only BNNSReduceFunctionNone and BNNSReduceFunctionSum are supported.
 @param input Tensor from which values are scattered
 @param indices 1D tensor containing indices to gather. Must have the same size as the axis-th dimension of input.
 @param output Tensor into which indices are scattered
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 */
public static native int BNNSScatter(@Cast("size_t") long axis,
                @Cast("BNNSReduceFunction") int op,
                @Const BNNSNDArrayDescriptor input,
                @Const BNNSNDArrayDescriptor indices,
                BNNSNDArrayDescriptor output,
                @Const BNNSFilterParameters filter_params);

/**
 \abstract Gathers a (k-1)-dimensional set of slices or elements from the input array
 <p>
 \discussion
 This provides a more comprehensive version of BNNSGather that allows gathering slices of the input array.
 <p>
 The indices array is interpreted as a (k-1) dimensional set of 1d lookup vectors (thus the indices tensor has (k-1) + 1 = k dimensions total).
 If the 1d lookup vectors do not give a full set of indices, the remaining indices are treated as a slice.
 e.g. If the input array is 3 dimensional, then:
    indices[i] = {1} would gather the 2d slice input[1, :, :]
    indices[i] = {3,2} would gather the 1d slice input[3, 2, :]
    indices[i] = {2,1,3} would gather the element input[2, 1, 3]
 As such, the shape of the output is given by the concatenation of the shape for the first k-1 dimensions of indices and the
 shape of the slice gathered (which is itself given by the shape of the last p dimensions of the input tensor, where
 p=ndim(input)-indices.size[k-1]).
 <p>
 If any indices value are out of range, an error is generated.
 <p>
 @param input Tensor from which values are gathered
 @param indices Tensor containing indices to gather
 @param output Tensor in which to store output. Must have shape consistent with input and indices as described above.
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 */
public static native int BNNSGatherND(@Const BNNSNDArrayDescriptor input,
                 @Const BNNSNDArrayDescriptor indices,
                 BNNSNDArrayDescriptor output,
                 @Const BNNSFilterParameters filter_params);

/**
 \abstract Scatters a (k-1)-dimensional set of slices or elements across the output array
 <p>
 \discussion
 This is the inverse of the BNNSGatherND operation.
 <p>
 The indices array is interpreted as a (k-1) dimensional set of 1d lookup vectors (thus the indices tensor has (k-1) + 1 = k dimensions total).
 If the 1d lookup vectors do not give a full set of indices, the remaining indices are treated as a slice.
 e.g. If the output array is 3 dimensional, then:
    indices[i] = {1} would refer to the 2d slice output[1, :, :]
    indices[i] = {3,2} would refer to the 1d slice output[3, 2, :]
    indices[i] = {2,1,3} would refer to the output[2, 1, 3]
 As such, the shape of the input is given by the concatenation of the shape for the first k-1 dimensions of indices and the
 shape of the slice gathered (which is itself given by the shape of the last p dimensions of the output tensor, where
 p=ndim(output)-indices.size[k-1]).
 <p>
 If any indices value are out of range, an error is generated.
 <p>
 Output values that are scattered to reduced with the existing value as
   output[output_idx] = op(output[output_idx], input[input_idx]).
 If multiple input values update the same output element, the order of update operations is undefined.
 In particular, if op == BNNSReduceFunctionNone there is no guarantee any particular value will result.
 <p>
 @param op Reduction op used to reduce existing output value with scattered value.
        At present only BNNSReduceFunctionNone and BNNSReduceFunctionSum are supported.
 @param input Tensor from which values are scattered
 @param indices Tensor containing indices to scatter
 @param output Tensor into which indices are scattered
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 */
public static native int BNNSScatterND(@Cast("BNNSReduceFunction") int op,
                  @Const BNNSNDArrayDescriptor input,
                  @Const BNNSNDArrayDescriptor indices,
                  BNNSNDArrayDescriptor output,
                  @Const BNNSFilterParameters filter_params);

/**
 \abstract Rearranges elements in a tensor according to shuffle type
 
 @param type Type of shuffle to perform
 @param input Pointer to the input tensor descriptor
 @param output Pointer to the output tensor descriptor
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 @return Zero on success, nonzero on failure.
 */
public static native int BNNSShuffle(@Cast("const BNNSShuffleType") int type,
                @Const BNNSNDArrayDescriptor input,
                BNNSNDArrayDescriptor output,
                @Const BNNSFilterParameters filter_params);

/**
 \abstract Set elements outside a center band to zeros for the innermost matrix (the two dimensions with
 the lowest stride values)
 \discussion
   Currently only works on contiguous input and output
 <p>
 @param num_lower The number of subdiagonals that the function copies. Set to a negative value to copy the entire lower triangle
 @param num_upper The number of superdiagonals that the function copies. Set to a negative value to copy the entire upper triangle
 @param input Pointer to the input tensor descriptor
 @param output Pointer to the output tensor descriptor
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 @return Zero on success, nonzero on failure.
 */
public static native int BNNSBandPart(int num_lower,
                 int num_upper,
                 @Const BNNSNDArrayDescriptor input,
                 BNNSNDArrayDescriptor output,
                 @Const BNNSFilterParameters filter_params);

/**
 \abstract Resize the spatial dimensions (two dimensions with the smallest strides) of the first input
 according to the bounding boxes and box indices specified in the second input.
 
 \discussion
   Only works on contiguous tensors
 <p>
 @param layer_params Pointer to layer parameter
 @param input Pointer to the input tensor descriptor
 @param roi Pointer to regions of interest tensor descriptor
 @param output Pointer to the output tensor descriptor
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 @return Zero on success, nonzero on failure.
 */
public static native int BNNSCropResize(@Const BNNSLayerParametersCropResize layer_params,
                   @Const BNNSNDArrayDescriptor input,
                   @Const BNNSNDArrayDescriptor roi,
                   BNNSNDArrayDescriptor output,
                   @Const BNNSFilterParameters filter_params);

// #pragma mark - Direct Apply Backward

/**
 \abstract Direct Apply LSTM with training caching
 \discussion compute LSTM backward
 @param layer_params - layer parameters
 @param layer_delta_params - layer delta parameters (include inputs & outputs for backward)
 @param filter_params - filter parameters
 @param training_cache_ptr - buffer with intermediate results to accelerate backward computation. if Null, intermediate results weren't cached and forward pass will be recomupted
 @param training_cache_capacity - size in bytes of training_cache_ptr. return failure when training_cache_capacity is lower than the minimum bytes capacity of the training cache
 @return 0 on success, and -1 on failure.
*/
public static native int BNNSDirectApplyLSTMBatchBackward(@Const BNNSLayerParametersLSTM layer_params,
                                     @Const BNNSLayerParametersLSTM layer_delta_params,
                                     @Const BNNSFilterParameters filter_params,
                                     @Const Pointer training_cache_ptr,
                                     @Cast("const size_t") long training_cache_capacity);

/**
 \abstract backward path of BNNSTile to calculate input delta from output delta
 
 \discussion
   The size of output tensor along each dimension should be a multiple of input tensor,
   and the multiple is the number of repetition.
 <p>
 @param in_delta Pointer to the input delta tensor descriptor
 @param out_delta Pointer to the output delta tensor descriptor
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 @return Zero on success, nonzero on failure.
 */
public static native int BNNSTileBackward(BNNSNDArrayDescriptor in_delta,
                     @Const BNNSNDArrayDescriptor out_delta,
                     @Const BNNSFilterParameters filter_params);

/**
 \abstract backward path of BNNSCropResize to calculate input delta from output delta
 
 \discussion
   Only works on contiguous tensors
 <p>
 @param layer_params Pointer to layer parameter
 @param in_delta Pointer to the input delta tensor descriptor
 @param roi Pointer to regions of interest tensor descriptor
 @param out_delta Pointer to the output delta tensor descriptor
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 @return Zero on success, nonzero on failure.
 */
public static native int BNNSCropResizeBackward(@Const BNNSLayerParametersCropResize layer_params,
                           BNNSNDArrayDescriptor in_delta,
                           @Const BNNSNDArrayDescriptor roi,
                           @Const BNNSNDArrayDescriptor out_delta,
                           @Const BNNSFilterParameters filter_params);

// #pragma mark - Utility

/**
 \abstract Get NDArray descriptor containing reference to filter data member
 <p>
 \discussion
 Some filters have potentially trainiable parameters embedded in the filter structure (for example activation layers often have an alpha or beta parameter).
 To facilitate training or otherwise modifying these parameters after layer creation, we provide the following function.
 Note that the pointer is only valid until the BNNSFilter is destroyed, and that care must be taken if the filter is used on multiple threads.
 <p>
 @param filter Filter to obtain pointer into
 @param target enum specifying what a pointer is required to
 <p>
 @return On success, a BNNSNDArrayDescriptor describing the requested parameter.
          On failure, a BNNSNDArrayDescriptor with data member set to NULL.
 */
public static native @ByVal BNNSNDArrayDescriptor BNNSGetPointer(BNNSFilter filter, @Cast("BNNSPointerSpecifier") int target);

// #endif 

/**
 \abstract calculate the size in bytes of the array data
 @return 0 if unable to determine the size (or array->data is null)
 */
public static native @Cast("size_t") long BNNSNDArrayGetDataSize(@Const BNNSNDArrayDescriptor array);

/**
 \abstract calculate the minimum size in bytes of the array data given the shape and stride
 @return size of allocation sufficient to hold the tensor data, or {@code SIZE_T_MAX} if unable to
         determine the size (e.g. due to dynamic shape or overflow)
 */
public static native @Cast("size_t") long BNNSTensorGetAllocationSize(@Const BNNSTensor tensor);

/**
 \abstract Determine the rank of the given layout
 @return The number of dimensions represented by {@code layout}, or {@code SIZE_T_MAX} if unable to determine
 */
public static native @Cast("size_t") long BNNSDataLayoutGetRank(@Cast("BNNSDataLayout") int layout);

// #if !0

/**
 \abstract Converts sparse tensor from the standardized COO layout to a device specific sparse layout used by FullyConnected
 \discussion The COO format is similar to that used in tensorflow and described at  https://www.tensorflow.org/guide/sparse_tensor
 - If the developer preallocates the workspace, it must be at least twice the size of the dense input.
 - BNNS will allocate scratch memory if workspace is NULL
 - the developer may pre allocate out->data to equal to the memory size of the dense input.
 - BNNS will allocate the memory for the sparse NDArray given by out if out->data is NULL, it will be the developer's responsibility to free this memory allocated by BNNS
 - if out->data was allocated to be >= size of input->data, we recommend query the output actual data size using BNNSNDArrayGeteDataSize after sparsify operation has been completed and reallocate to the smaller size
 - the size of dense input can be obtained by calling BNNSNDArrayGetDataSize
 - sparse_params are optional for the user to hint the attributes of the sparsity in the input. specifying pattern that doesn't match the sparse weights could result in failure to Sparsify the weights for Sparse Fully Connected
 @param in_dense_shape - describe the dense shape of the sparse 2D array. developer should set sizes and layout.
 @param in_indices - A 2D NDArray with shape [NNZ, rank], that contains the interleaved indices of the nonzero values. For row-major ordering, the even elements are the column indices and the odd elements are the row indices. For column-major ordering, the even element are the row indices and the odd elements are the column indices.
 @param in_values -  A 1D NDArray with shape [NNZ] containing all nonzero values.
 @param out - nd array descriptor of device optimized BNNS Sparse Fully Connected weights. use it when setting BNNSLayerParametersFullyConnected for BNNSDirectApplyFullyConnectedBatch or BNNSFilterCreateLayerFullyConnected
 @param sparse_params - optional data structure to hint the sparsify function. this could help identifying specialized patterns that can be accelerated compared to unstructured sparsity. see BNNSSparsityType for pattern types.
 @param batch_size - the expected batch_size when calling BNNSFilterCreateLayerFullyConnected or BNNSFilterApplyBatch with device optimized BNNS Sparse Fully Connected weights. this is important in the decision of how to pack the weights. when set to 0, assuming it will be set to 1 during inference
 @param workspace - scratch memory to use while generating the opaque BNNS Sparse Fully Connected weights. it is recommended that the size of this buffer should be equal to the memory size of the dense input. if set to NULL, BNNS will allocate and free during the run of BNNSNDArrayFullyConnectedSparsify.
 @param workspace_size - size in bytes of workspace when preallocated by the developer. Will be ignored if workspace is NULL.
 @return 0 for success, non 0 on failure (failure reason will reported in os logs)
 */
public static native int BNNSNDArrayFullyConnectedSparsifySparseCOO(@Const BNNSNDArrayDescriptor in_dense_shape,
                                               @Const BNNSNDArrayDescriptor in_indices,
                                               @Const BNNSNDArrayDescriptor in_values,
                                               BNNSNDArrayDescriptor out,
                                               @Const BNNSSparsityParameters sparse_params,
                                               @Cast("const size_t") long batch_size,
                                               Pointer workspace,
                                               @Cast("const size_t") long workspace_size,
                                               @Const BNNSFilterParameters filter_params);

/**
 \abstract Converts sparse tensor from the standardized CSR layout to a device specific sparse layout used by FullyConnected
 \discussion
 - If the developer preallocate the workspace, it must be at least twice the size of the dense input.
 - BNNS will allocate scratch memory if workspace is NULL
 - the developer may pre allocate out->data to equal to the memory size of the dense input.
 - BNNS will allocate the memory for the sparse NDArray given by out if out->data is NULL, it will be the developer's responsibility to free this memory allocated by BNNS
 - if out->data was allocated to be >= size of input->data, we recommend query the output actual data size using BNNSNDArrayGeteDataSize after sparsify operation has been completed and reallocate to the smaller size
 - the size of dense input can be obtained by calling BNNSNDArrayGetDataSize
 - sparse_params are optional for the user to hint the attributes of the sparsity in the input. specifying pattern that doesn't match the sparse weights could result in failure to Sparsify the weights for Sparse Fully Connected
 @param in_dense_shape - describe the dense shape of the sparse 2D array. developer should set sizes and layout.
 @param in_column_indices - A 1D NDArray with shape [NNZ], containing the column indices of the nonzero values
 @param in_row_starts - A 1D NDArray with shape [row_size+1], containing pointers to the start of each row. (expected value 0 in location [0])
 @param in_values -  A 1D NDArray with shape [NNZ] containing all nonzero values.
 @param out - nd array descriptor of device optimized BNNS Sparse Fully Connected weights. use it when setting BNNSLayerParametersFullyConnected for BNNSDirectApplyFullyConnectedBatch or BNNSFilterCreateLayerFullyConnected
 @param sparse_params - optional data structure to hint the sparsify function. this could help identifying specialized patterns that can be accelerated compared to unstructured sparsity. see BNNSSparsityType for pattern types.
 @param batch_size - the expected batch_size when calling BNNSFilterCreateLayerFullyConnected or BNNSFilterApplyBatch with device optimized BNNS Sparse Fully Connected weights. this is important in the decision of how to pack the weights. when set to 0, assuming it will be set to 1 during inference
 @param workspace - scratch memory to use while generating the opaque BNNS Sparse Fully Connected weights. it is recommended that the size of this buffer should be equal to the memory size of the dense input. if set to NULL, BNNS will allocate and free during the run of BNNSNDArrayFullyConnectedSparsify.
 @param workspace_size - size in bytes of workspace when preallocated by the developer. Will be ignored if workspace is NULL.
 @return 0 for success, non 0 on failure (failure reason will reported in os logs)
 */
public static native int BNNSNDArrayFullyConnectedSparsifySparseCSR(@Const BNNSNDArrayDescriptor in_dense_shape,
                                               @Const BNNSNDArrayDescriptor in_column_indices,
                                               @Const BNNSNDArrayDescriptor in_row_starts,
                                               @Const BNNSNDArrayDescriptor in_values,
                                               BNNSNDArrayDescriptor out,
                                               @Const BNNSSparsityParameters sparse_params,
                                               @Cast("const size_t") long batch_size,
                                               Pointer workspace,
                                               @Cast("const size_t") long workspace_size,
                                               @Const BNNSFilterParameters filter_params);

// #endif 

// #pragma mark - Random number generation

/**
 <p>
 \abstract Random number generator object
 <p>
 */
@Namespace @Name("void") @Opaque public static class BNNSRandomGenerator extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public BNNSRandomGenerator() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSRandomGenerator(Pointer p) { super(p); }
}

/**
 \abstract Create a random number generator
 <p>
 \discussion
 Creates a BNNSRandomGenerator object that can be used to generate a stream of random numbers.
 The generator will be intialized using an interally generated seed that will vary from call to call.
 <p>
 @param method - method to be used for random number generation.
 <p>
 @param filter_params - options structure, if NULL, defaults are used.
 <p>
 @return On success, an BNNSRandomGenerator object describing the RNG state.
 On failure, returns NULL.
 <p>
 \seealso BNNSCreateRandomGeneratorWithSeed
 */
public static native BNNSRandomGenerator BNNSCreateRandomGenerator(@Cast("BNNSRandomGeneratorMethod") int method, @Const BNNSFilterParameters filter_params);

/**
 \abstract Create a random number generator using the given seed
 <p>
 \discussion
 Creates a BNNSRandomGenerator object that can be used to generate a stream of random numbers.
 <p>
 @param method - method to be used for random number generation.
 <p>
 @param seed - random seed to be used when initializing generator.
 <p>
 @param filter_params - options structure, if NULL, defaults are used.
 <p>
 @return On success, an BNNSRandomGenerator object describing the RNG state.
          On failure, returns NULL.
 <p>
 \seealso BNNSCreateRandomGenerator
 */
public static native BNNSRandomGenerator BNNSCreateRandomGeneratorWithSeed(@Cast("BNNSRandomGeneratorMethod") int method, @Cast("uint64_t") long seed, @Const BNNSFilterParameters filter_params);

/** \abstract Destroys a random number generator object
 *
 *  \discussion
 *  Frees memory allocated by BNNSCreateRandomGenerator
 *
 *  @param generator - generator to be destroyed
 */
public static native void BNNSDestroyRandomGenerator(BNNSRandomGenerator generator);

/** \abstract Get the state size in bytes for a RandomGenerator
 *
 *  \discussion
 *  This captures the state from a random generator object such that it can be copied or stored and used to restore the
 *  generator at a later point.
 *
 *  @param generator - generator to be queried
 *
 *  @return State size in bytes (0 on failure).
 */
public static native @Cast("size_t") long BNNSRandomGeneratorStateSize(BNNSRandomGenerator generator);

/** \abstract Get the state for a RandomGenerator
 *
 *  \discussion
 *  This captures the state from a random generator object such that it can be copied or stored and used to restore the
 *  generator at a later point.
 *  Note that if generator is used on multiple threads, usage is serialized through an internal lock. In this scenario we recommend
 *  users create a different BNNSRandomGenerator object with a different seed for each thread to ensure consistency of output
 *  on any replay usingBNNSRandomGeneratorGetState/ BNNSRandomGeneratorSetState.
 *
 *  @param generator - generator to be queried
 *
 *  @param state_size - size of state buffer in bytes, must be at least as large as the value returned by BNNSRandomGeneratorStateSize.
 *
 *  @param state - pointer to space of size returned by call to BNNSRandomGeneratorStateSize(generator)
 *
 *  @return 0 on success, nonzero on error.
 */
public static native int BNNSRandomGeneratorGetState(BNNSRandomGenerator generator, @Cast("size_t") long state_size, Pointer state);

/** \abstract Set the state for a RandomGenerator
 *
 *  \discussion
 *  Restores the state for a RandomGenerator from one captured by a previous call to BNNSRandomGeneratorGetState().
 *  Note that if generator is used on multiple threads, usage is serialized through an internal lock. In this scenario we recommend
 *  users create a different BNNSRandomGenerator object with a different seed for each thread to ensure consistency of output
 *  on any replay using BNNSRandomGeneratorGetState/BNNSRandomGeneratorSetState.
 *
 *  @param generator - generator to be updated
 *
 *  @param state_size - size of state buffer in bytes, only the first BNNSRandomGeneratorStateSize() bytes are copied.
 *
 *  @param state - pointer to space of size returned by call to BNNSRandomGeneratorStateSize(generator)
 *
 *  @return 0 on success, nonzero on error.
 */
public static native int BNNSRandomGeneratorSetState(BNNSRandomGenerator generator, @Cast("size_t") long state_size, Pointer state);

/** \abstract Fill the supplied tensor with random float data using the supplied generator mapped to the Unif(a, b) distribution
 *
 *  \discussion
 *  We generate pseudo-random values from Unif(a, b).
 *  Note that if generator is used on multiple threads, usage is serialized through an internal lock. In this scenario we recommend
 *  users create a different BNNSRandomGenerator object with a different seed for each thread to ensure consistency of output
 *  on any replay using BNNSRandomGeneratorGetState/BNNSRandomGeneratorSetState and to eliminate contention.
 *  Should a or b be outside the range of representable values for the output descriptor's data type, they will be capped at the
 *  closest finite value that is representable.
 *
 *  @param generator - random generator to be used
 *
 *  @param desc - tensor descriptor to be filled with random values, data type must be floating point
 *
 *  @param a - lower bound of distribution (if desc.data_type is not BNNSDataTypeFloat32, a must be exact exactly representable in the requested precision)
 *
 *  @param b - upper bound of distribution (if desc.data_type is not BNNSDataTypeFloat32, b must be exact exactly representable in the requested precision)
 *
 *  @return 0 on success, nonzero on error.
 */
public static native int BNNSRandomFillUniformFloat(BNNSRandomGenerator generator, BNNSNDArrayDescriptor desc, float a, float b);

/** \abstract Fill the supplied tensor with random integer data using the supplied generator mapped to the Unif(a, b) distribution
 *
 *  \discussion
 *  We generate pseudo-random values from Unif(mean-variance, mean+variance).
 *  Note that if generator is used on multiple threads, usage is serialized through an internal lock. In this scenario we recommend
 *  users create a different BNNSRandomGenerator object with a different seed for each thread to ensure consistency of output
 *  on any replay using BNNSRandomGeneratorGetState/BNNSRandomGeneratorSetState and to eliminate contention.
 *  Should a or b be outside the range of representable values for the output descriptor's data type, they will be capped at the
 *  closest value that is representable.
 *
 *  @param generator - random generator to be used
 *
 *  @param desc - tensor descriptor to be filled with random values, data type must be integer
 *
 *  @param a - lower bound of distribution
 *
 *  @param b - upper bound of distribution
 *
 *  @return 0 on success, nonzero on error.
*/
public static native int BNNSRandomFillUniformInt(BNNSRandomGenerator generator, BNNSNDArrayDescriptor desc, @Cast("int64_t") long a, @Cast("int64_t") long b);


/** \abstract Fill the supplied tensor with random float data using the supplied generator mapped to a normal distribution
 *
 *  \discussion
 *  We generate a standard normal distribution for a specified mean and standard deviation.
 *  Note that if generator is used on multiple threads, usage is serialized through an internal lock. In this scenario we recommend
 *  users create a different BNNSRandomGenerator object with a different seed for each thread to ensure consistency of output
 *  on any replay using BNNSRandomGeneratorGetState/BNNSRandomGeneratorSetState and to eliminate contention.
 *  Should a or b be outside the range of representable values for the output descriptor's data type, they will be capped at the
 *  closest finite value that is representable.
 *
 *  @param generator - random generator to be used
 *
 *  @param desc - tensor descriptor to be filled with random values, data type must be floating point
 *
 *  @param mean - mean of distribution
 *
 *  @param stddev - standard deviation of distribution
 *
 *  @return 0 on success, nonzero on error.
 */
public static native int BNNSRandomFillNormalFloat(BNNSRandomGenerator generator, BNNSNDArrayDescriptor desc, float mean, float stddev);


/** \abstract Fill the supplied tensor with random float data using the supplied generator mapped to
 *  categorical distributions with the given event (log) probabilities.
 *
 *  \discussion
 *  We generate  random values from a categorical distribution with specified event probabilities or event log probabilities.
 *  Note that if generator is used on multiple threads, usage is serialized through an internal lock. In this scenario we recommend
 *  users create a different BNNSRandomGenerator object with a different seed for each thread to ensure consistency of output
 *  on any replay using BNNSRandomGeneratorGetState/BNNSRandomGeneratorSetState and to eliminate contention.
 *  Assume r is the rank of the probabilities tensor, and K is the inner most dimension of probabilities tensor, i.e., probabilities.size[r-1].
 *  Then, desc must be a rank r tensor with the first r-1 dimensions having the same size as the first r-1 dimensions of probabilities, where
 *  the first r-1 dimensions are treated as batch sizes and each desc [i_0, ..., i_r-2, i_r-1] will be an integer in 0,1,..., K-1 drawn from the
 *  categorical distribution from the corresponding probabilities slice [i_0, ..., i_r-2, :]. That is to say desc.size[r-1] samples are drawn from
 *  a categorical distribution, such that P(desc[i_0, ..., i_r-2, i_r-1] == k) = probabilities[i0, ..., i_r-2, k].
 *  The probabilities data is assumed to be nonnegative and finite, which will be normalized to sum one along the inner most dimension.
 *  The log probabilities data will be normalized, so their exponentials sum to one along the inner most dimension.
 *
 *  @param generator - random generator to be used
 *
 *  @param desc - tensor descriptor to be filled with random values, data type must be floating point
 *
 *  @param probabilities - probabilities or log probabilities, data type must be the same as desc
 *
 *  @param log_probabilities - true if log probabilities is provided, otherwise probabilities data is provided
 *
 *  @return 0 on success, nonzero on error.
 */
public static native int BNNSRandomFillCategoricalFloat(BNNSRandomGenerator generator,
                                   @Const BNNSNDArrayDescriptor desc,
                                   @Const BNNSNDArrayDescriptor probabilities,
                                   @Cast("bool") boolean log_probabilities);

// #if !0

// #pragma mark - K-Nearest Neighbors

/**
 <p>
 \abstract K-nearest neighbors container object
 <p>
 */
@Namespace @Name("void") @Opaque public static class BNNSNearestNeighbors extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public BNNSNearestNeighbors() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BNNSNearestNeighbors(Pointer p) { super(p); }
}

/**
 \abstract Create a BNNSNearestNeighbors object, that is used to calculate k nearest neighbors of data points
 based on Euclidean distance
 <p>
 @param max_n_samples - maximum number of data points
 @param n_features - number of features (dimensions) of each data point
 @param n_neighbors - number of nearest neighbors
 @param data_type - data type of the features, only fp32 and fp16 is supported by now
 @param filter_params - filter runtime parameters, may be NULL for default parameters
 <p>
 @return On success, a BNNSNearestNeighbors object is created. On failure, returns NULL.
 */
public static native BNNSNearestNeighbors BNNSCreateNearestNeighbors(@Cast("const unsigned int") int max_n_samples,
                                                @Cast("const unsigned int") int n_features,
                                                @Cast("const unsigned int") int n_neighbors,
                                                @Cast("const BNNSDataType") int data_type,
                                                @Const BNNSFilterParameters filter_params);

/**
 \abstract Destroy a BNNSNearestNeighbors object
 <p>
 @param knn - the BNNSNearestNeighbors object to be destroyed
 */
public static native void BNNSDestroyNearestNeighbors(BNNSNearestNeighbors knn);

/**
 \abstract Add new sample data to BNNSNearestNeighbors
 <p>
 @param knn - the BNNSNearestNeighbors object used for calculation and storage
 @param n_new_samples - number of new data points to be added
 @param data_ptr - pointer to the new data array of size [n_new_samples, n_features]
 <p>
 @return 0 for success, nonzero on failure (failure reason will reported in os logs)
 */
public static native int BNNSNearestNeighborsLoad(BNNSNearestNeighbors knn,
                             @Cast("const unsigned int") int n_new_samples,
                             @Const Pointer data_ptr);

/**
 \abstract Return the sorted indices and distances of the k nearest neighbors to certain sample point
 <p>
 @param knn -  the BNNSNearestNeighbors object used for calculation and storage
 @param sample_number - sample number to return the k nearest neighbors, if negative return all of them
 @param indices - sorted indices of the k nearest neighbors to the sample point (sample_number), if not null.
  If sample_number is negative, indices is an array of [n_samples, n_neighbors], otherwise indices is an array of [n_neighbors].
  Return -1 for n_neighbors larger than n_samples.
 @param distances - sorted distances of the k nearest neighbors to the sample point (sample_number), if not null.
  If sample_number is negative, distances is an array of [n_samples, n_neighbors], otherwise distances is an array of [n_neighbors].
  Return INFINITY for n_neighbors larger than n_samples.
 <p>
 @return 0 for success, nonzero on failure (failure reason will reported in os logs)
 */
public static native int BNNSNearestNeighborsGetInfo(BNNSNearestNeighbors knn,
                                int sample_number,
                                IntPointer indices,
                                Pointer distances);
public static native int BNNSNearestNeighborsGetInfo(BNNSNearestNeighbors knn,
                                int sample_number,
                                IntBuffer indices,
                                Pointer distances);
public static native int BNNSNearestNeighborsGetInfo(BNNSNearestNeighbors knn,
                                int sample_number,
                                int[] indices,
                                Pointer distances);

// #pragma mark - Deprecated Filter Creation Functions

/**
 <p>
 \abstract Create a convolution layer filter (DEPRECATED,  Use BNNSFilterCreateLayerConvolution)
 <p>
 \discussion
 Creates a filter applying the convolution described in <tt>layer_params</tt>.
 Some combinations of the parameters may not be supported, in which case the call will fail.
 <p>
 @param in_desc Input image stack descriptor
 @param out_desc Output image stack descriptor
 @param layer_params Layer parameters and weights
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateConvolutionLayer(@Const BNNSImageStackDescriptor in_desc,
                                            @Const BNNSImageStackDescriptor out_desc,
                                            @Const BNNSConvolutionLayerParameters layer_params,
                                            @Const BNNSFilterParameters filter_params);

/**
 <p>
 \abstract Create a fully connected layer filter (DEPRECATED,  Use BNNSFilterCreateLayerFullyConnected)
 <p>
 \discussion
 Creates a filter applying the fully connected layer described in <tt>layer_params</tt>.
 Some combinations of the parameters may not be supported, in which case the call will fail.
 <p>
 @param in_desc Input vector descriptor
 @param out_desc Output vector descriptor
 @param layer_params Layer parameters and weights
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateFullyConnectedLayer(@Const BNNSVectorDescriptor in_desc,
                                               @Const BNNSVectorDescriptor out_desc,
                                               @Const BNNSFullyConnectedLayerParameters layer_params,
                                               @Const BNNSFilterParameters filter_params);

/**
 <p>
 \abstract Create a pooling layer filter (DEPRECATED,  Use BNNSFilterCreateLayerPooling)
 <p>
 \discussion
 Creates a filter applying the pooling layer described in <tt>layer_params</tt>
 Some combinations of the parameters may not be supported, in which case the call will fail.
 <p>
 @param in_desc Input image stack descriptor
 @param out_desc Output image stack descriptor
 @param layer_params Layer parameters and weights
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreatePoolingLayer(@Const BNNSImageStackDescriptor in_desc,
                                        @Const BNNSImageStackDescriptor out_desc,
                                        @Const BNNSPoolingLayerParameters layer_params,
                                        @Const BNNSFilterParameters filter_params);

/**
 <p>
 \abstract Create a vector conversion/activation layer filter (DEPRECATED,  Use BNNSFilterCreateLayerActivation)
 <p>
 \discussion
 Creates a filter applying the given activation function and conversions to vectors. Input and output vectors must have the same size.
 <p>
 @param in_desc Input vector descriptor
 @param out_desc Output vector descriptor
 @param activation Activation function to apply and its parameters
 @param filter_params Filter runtime parameters, may be NULL for default parameters
 <p>
 @return A new non-NULL filter on success, and NULL on failure.
 <p>
 */
public static native BNNSFilter BNNSFilterCreateVectorActivationLayer(@Const BNNSVectorDescriptor in_desc,
                                                 @Const BNNSVectorDescriptor out_desc,
                                                 @Const BNNSActivation activation,
                                                 @Const BNNSFilterParameters filter_params);

// #endif 

// #if !__has_include( <Availability.h> )
// #undef __API_AVAILABLE
// #undef __API_DEPRECATED
// #undef __API_DEPRECATED_WITH_REPLACEMENT
// #endif

// #if __has_feature(assume_nonnull)
// #else
//   #undef _Nullable
// #undef _Null_unspecified
// #undef _Nonnull
// #endif

// #ifdef __cplusplus
// #endif


// #endif // __BNNS_HEADER__


}
