/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.velocity.VelocityContext;
import org.testng.IClass;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.xml.XmlSuite;
import org.uncommons.reportng.AbstractReporter;
import org.uncommons.reportng.ReportNGException;
import org.uncommons.reportng.TestClassComparator;
import org.uncommons.reportng.TestMethodComparator;
import org.uncommons.reportng.TestResultComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLReporter
extends AbstractReporter {
    private static final String FRAMES_PROPERTY = "org.uncommons.reportng.frames";
    private static final String TEMPLATES_PATH = "org/uncommons/reportng/templates/html/";
    private static final String INDEX_FILE = "index.html";
    private static final String SUITES_FILE = "suites.html";
    private static final String OVERVIEW_FILE = "overview.html";
    private static final String GROUPS_FILE = "groups.html";
    private static final String RESULTS_FILE = "results.html";
    private static final String CHRONOLOGY_FILE = "chronology.html";
    private static final String OUTPUT_FILE = "output.html";
    private static final String CUSTOM_STYLE_FILE = "custom.css";
    private static final String SUITE_KEY = "suite";
    private static final String SUITES_KEY = "suites";
    private static final String GROUPS_KEY = "groups";
    private static final String RESULT_KEY = "result";
    private static final String FAILED_CONFIG_KEY = "failedConfigurations";
    private static final String SKIPPED_CONFIG_KEY = "skippedConfigurations";
    private static final String FAILED_TESTS_KEY = "failedTests";
    private static final String SKIPPED_TESTS_KEY = "skippedTests";
    private static final String PASSED_TESTS_KEY = "passedTests";
    private static final String METHODS_KEY = "methods";
    private static final String REPORT_DIRECTORY = "html";
    private static final Comparator<ITestNGMethod> METHOD_COMPARATOR = new TestMethodComparator();
    private static final Comparator<ITestResult> RESULT_COMPARATOR = new TestResultComparator();
    private static final Comparator<IClass> CLASS_COMPARATOR = new TestClassComparator();

    public HTMLReporter() {
        super(TEMPLATES_PATH);
    }

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectoryName) {
        this.removeEmptyDirectories(new File(outputDirectoryName));
        boolean useFrames = System.getProperty(FRAMES_PROPERTY, "true").equals("true");
        File outputDirectory = new File(outputDirectoryName, REPORT_DIRECTORY);
        outputDirectory.mkdir();
        try {
            if (useFrames) {
                this.createFrameset(outputDirectory);
            }
            this.createOverview(suites, outputDirectory, !useFrames);
            this.createSuiteList(suites, outputDirectory);
            this.createGroups(suites, outputDirectory);
            this.createResults(suites, outputDirectory);
            this.createLog(outputDirectory);
            this.copyResources(outputDirectory);
        }
        catch (Exception ex) {
            throw new ReportNGException("Failed generating HTML report.", ex);
        }
    }

    private void createFrameset(File outputDirectory) throws Exception {
        VelocityContext context = this.createContext();
        this.generateFile(new File(outputDirectory, INDEX_FILE), "index.html.vm", context);
    }

    private void createOverview(List<ISuite> suites, File outputDirectory, boolean isIndex) throws Exception {
        VelocityContext context = this.createContext();
        context.put(SUITES_KEY, suites);
        this.generateFile(new File(outputDirectory, isIndex ? INDEX_FILE : OVERVIEW_FILE), "overview.html.vm", context);
    }

    private void createSuiteList(List<ISuite> suites, File outputDirectory) throws Exception {
        VelocityContext context = this.createContext();
        context.put(SUITES_KEY, suites);
        this.generateFile(new File(outputDirectory, SUITES_FILE), "suites.html.vm", context);
    }

    private void createResults(List<ISuite> suites, File outputDirectory) throws Exception {
        int index = 1;
        for (ISuite suite : suites) {
            int index2 = 1;
            for (ISuiteResult result : suite.getResults().values()) {
                VelocityContext context = this.createContext();
                context.put(RESULT_KEY, (Object)result);
                context.put(FAILED_CONFIG_KEY, this.sortByTestClass(result.getTestContext().getFailedConfigurations()));
                context.put(SKIPPED_CONFIG_KEY, this.sortByTestClass(result.getTestContext().getSkippedConfigurations()));
                context.put(FAILED_TESTS_KEY, this.sortByTestClass(result.getTestContext().getFailedTests()));
                context.put(SKIPPED_TESTS_KEY, this.sortByTestClass(result.getTestContext().getSkippedTests()));
                context.put(PASSED_TESTS_KEY, this.sortByTestClass(result.getTestContext().getPassedTests()));
                String fileName = String.format("suite%d_test%d_%s", index, index2, RESULTS_FILE);
                this.generateFile(new File(outputDirectory, fileName), "results.html.vm", context);
                ++index2;
            }
            ++index;
        }
    }

    private void createChronology(List<ISuite> suites, File outputDirectory) throws Exception {
        int index = 1;
        for (ISuite suite : suites) {
            ArrayList methods = new ArrayList(suite.getInvokedMethods());
            if (!methods.isEmpty()) {
                VelocityContext context = this.createContext();
                context.put(SUITE_KEY, (Object)suite);
                context.put(METHODS_KEY, methods);
                String fileName = String.format("suite%d_%s", index, CHRONOLOGY_FILE);
                this.generateFile(new File(outputDirectory, fileName), "chronology.html.vm", context);
            }
            ++index;
        }
    }

    private SortedMap<IClass, List<ITestResult>> sortByTestClass(IResultMap results) {
        TreeMap<IClass, List<ITestResult>> sortedResults = new TreeMap<IClass, List<ITestResult>>(CLASS_COMPARATOR);
        for (ITestResult result : results.getAllResults()) {
            int index;
            ArrayList<ITestResult> resultsForClass = (ArrayList<ITestResult>)sortedResults.get(result.getTestClass());
            if (resultsForClass == null) {
                resultsForClass = new ArrayList<ITestResult>();
                sortedResults.put(result.getTestClass(), resultsForClass);
            }
            if ((index = Collections.binarySearch(resultsForClass, result, RESULT_COMPARATOR)) < 0) {
                index = Math.abs(index + 1);
            }
            resultsForClass.add(index, result);
        }
        return sortedResults;
    }

    private void createGroups(List<ISuite> suites, File outputDirectory) throws Exception {
        int index = 1;
        for (ISuite suite : suites) {
            SortedMap<String, SortedSet<ITestNGMethod>> groups = this.sortGroups(suite.getMethodsByGroups());
            if (!groups.isEmpty()) {
                VelocityContext context = this.createContext();
                context.put(SUITE_KEY, (Object)suite);
                context.put(GROUPS_KEY, groups);
                String fileName = String.format("suite%d_%s", index, GROUPS_FILE);
                this.generateFile(new File(outputDirectory, fileName), "groups.html.vm", context);
            }
            ++index;
        }
    }

    private void createLog(File outputDirectory) throws Exception {
        if (!Reporter.getOutput().isEmpty()) {
            VelocityContext context = this.createContext();
            this.generateFile(new File(outputDirectory, OUTPUT_FILE), "output.html.vm", context);
        }
    }

    private SortedMap<String, SortedSet<ITestNGMethod>> sortGroups(Map<String, Collection<ITestNGMethod>> groups) {
        TreeMap<String, SortedSet<ITestNGMethod>> sortedGroups = new TreeMap<String, SortedSet<ITestNGMethod>>();
        for (Map.Entry<String, Collection<ITestNGMethod>> entry : groups.entrySet()) {
            TreeSet<ITestNGMethod> methods = new TreeSet<ITestNGMethod>(METHOD_COMPARATOR);
            methods.addAll(entry.getValue());
            sortedGroups.put(entry.getKey(), methods);
        }
        return sortedGroups;
    }

    private void copyResources(File outputDirectory) throws IOException {
        this.copyClasspathResource(outputDirectory, "reportng.css", "reportng.css");
        this.copyClasspathResource(outputDirectory, "reportng.js", "reportng.js");
        this.copyClasspathResource(outputDirectory, "sorttable.js", "sorttable.js");
        File customStylesheet = META.getStylesheetPath();
        if (customStylesheet != null) {
            if (customStylesheet.exists()) {
                this.copyFile(outputDirectory, customStylesheet, CUSTOM_STYLE_FILE);
            } else {
                InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(customStylesheet.getPath());
                if (is != null) {
                    this.copyStream(outputDirectory, is, CUSTOM_STYLE_FILE);
                }
            }
        }
    }
}

